function frm_wizard(){};

frm_wizard.prototype = {
    __constructor: async function(){
		this.__views = {};
		this.__data = {};
		this.__view = null;

        await this._create('scrollbar','obj_scrollbar');
		this.scrollbar._scrollbar(this._getAnchor('main'));
	},

    _view: async function(sView, arg){
        if (this.__views[sView]){

			this._main.setAttribute('slide', sView);
			this.__data.currentView = sView;

            await this._create('main', this.__views[sView], '', '', {
                title:this._label.bind(this),
                buttons:this._buttons.bind(this),
				view:this._view.bind(this),
				next:this._next.bind(this),
				data:this.__data,
				parent:this
			}, arg);

			if (this._onchange)
				this._onchange(sView, arg);
        } else {
			 console.warn(this._pathName,'undefined view', sView);
		}
	},

	_label: async function(v){
		if (v){
			if (!this.label)
				await this._create('label','obj_label','header','ico');

			this.label._value(getLang(v));
		}
		else
		if (this.label)
			this.label._destruct();
	},

    _buttons: async function(arr){
        await this._clean('footer');

		var prefix =  Is.Array(arr)?'x_btn_':'',
			cnt = count(arr);

        for(var name in arr){
			var css = (arr[name].css || '') + (cnt == 1?' simple':''),
            	btn = await this._create(prefix + name, arr[name].type || 'obj_button', 'footer', css);

			if (arr[name].disabled)
				btn._disabled(true);

			if (arr[name].value)
                btn._value(arr[name].value);

            if (arr[name].onclick){
                btn._onclick = arr[name].onclick;
            }
            else
            if (name == 'btn_cancel'){
                btn._onclick = function(){
                    this._destruct();
                }.bind(this);
            }
        }
    },

	_next: function(sCurentView, arg){
		var sView = sCurentView || this.__data.currentView,
			aViews = Object.keys(this.__views).filter(function(itm){
				return !this.__data.views || ~this.__data.views.indexOf(itm);
			}.bind(this));

		var sNext = aViews[aViews.indexOf(sView)+1];
		if (sNext)
			this._view(sNext, arg);
		else
			this._destruct();
	}

	//Relaunch settings on exit
	//_onclose: function(){}
};