function frm_videoplayer() { }
frm_videoplayer.prototype = {
	__constructor: async function (options) {
		this._title(options.title, true);

		console.log(options.url);
		await this._draw('frm_videoplayer', 'main', {
			url: options.url,
			type: 'video/' + Path.extension(options.title)
		});

		await storage.library('video.min', 'videojs');
		storage.css('video-js-base');
		storage.css('video-js-theme-fantasy');

		this.__video = videojs(this._getAnchor('video'), {
			controlBar: {
				pictureInPictureToggle: false
			}
		});
		this.__video.on('play', function() {
			gui.__exeEvent('videojs-started', this.__video);
		}.bind(this));
		gui._obeyEvent('videojs-started', [this, '__stopVideo']);

		this.__video.on('canplay', function() {
			this.__video.off('canplay');
			this._size(this.__video.videoWidth() || 640, this.__video.videoHeight() || 384, true);
		}.bind(this));

		this.__video.on('error', function() {
			this._destruct();
		}.bind(this));

		this._add_destructor('__destructor');
	},

	_ondock: function() {
		this._stopVideo();
		return true;
	},

	_stopVideo: function() {
		try {
			this.__video.pause();
		} catch {
			//
		}
	},

	__stopVideo: function(context) {
		if (this.__video && context !== this.__video) {
			this._stopVideo();
		}
	},

	__destructor: function() {
		this._stopVideo();
		gui._disobeyEvent('videojs-started', [this, '__stopVideo']);
	}
}