function frm_upload_detail(){};
frm_upload_detail.prototype = {

	__constructor: async function(aData) {
		await storage.library('leaflet', 'leaflet');
		await storage.library('mapbox-gl.min', 'leaflet');
		await storage.library('leaflet-mapbox-gl.min', 'leaflet');

		var me = this;

		var link = aData.EVNURL;

		this.__locations = (aData.smartLinkData[0].Locations || []).filter(function(location) {
			return location.CityLatitude || location.CityLongitude;
		});

		await this._draw('frm_upload_detail', 'main', {
			link: link,
			empty: !this.__locations.length,
			disable_shareable_link: GWOthers.getItem('RESTRICTIONS', 'disable_shareable_link') == 1
		});

		if (GWOthers.getItem('RESTRICTIONS', 'disable_shareable_link') != 1) {
			this.copy_link._onclick = function() {
				toClipboard({
					'text/plain': link
				});
			};

			this.revoke_link._onclick = function() {
				TeamChatAPI.filesUninvite({
					id: aData.EVN_ID,
					aid: aData.aid,
					fid: aData.fid
				}, {
					success: function () {
						gui.__exeEvent('changedId', { oldId: aData.EVN_ID, newId: aData.EVN_ID });
					},
					context: this
				});
			}

			await this._create('qr', 'obj_qr', 'qr', '', link, false);
		}

		if (this.__locations.length) {
			this.__mapSetup();
			this.__showAllLocations();
		}

		await this._create('list', 'obj_upload_visits', 'visits', '', aData, function(aData) {
			me.__activeItem && me.__activeItem.classList.remove('active');
			if (me.__activeItem === this) {
				delete me.__activeItem;
				me.__showAllLocations();
			} else {
				this.classList.add('active');
				me.__activeItem = this;
				me.__showMarker((aData.Location || {}).marker);
			}
		}, this.__locations);
		this.list._queue = aData.smartLinkData;
		this.list._serverSort({aid: sPrimaryAccount, fid: 'UPLOAD_VISITS', iid: link.split('/').pop()});

		this.list._oncount = function(length) {
			if (length) {
				addcss(this._main, 'splash')
			} else {
				removecss(this._main, 'splash');
			}
		};

		if (this.export) {
			this.export._onclick = function() {
				me.export._disabled(true);
				TeamChatAPI.getSmartLinkData({
					smarts: link.split('/').pop(),
					limit: 0
				}, {
					success: function(response) {
						me.__exportToCSV(me.__processVisits(response[0]), aData.EVNTITLE + '.csv');
						me.export._disabled(false);
					},
					error: function() {
						gui.notifier._value({ type: 'alert', args: { header: '', text: 'ERROR::EXPORT_CSV' }});
						me.export._disabled(false);
					}
				});
			};
		}

		this._add_destructor('__destructor');
	},

	__processVisits: function(response) {
		var locations = {};
		response.Locations.forEach(function(location) {
			locations[location.Capital + '.' + location.City] = location;
		});

		var visits = response.Visits.map(function(visit) {
			var location = locations[visit.Whois.Capital + '.' + visit.Whois.City];
			var ua = UAParser(visit.Whois.Agent);
			
			Object.assign(visit, visit.Whois, {
				DateTime: new IcewarpDate(visit.CreatedAt).format('LL LT'),
				OS: ua.os.name + ' ' + ua.os.version,
				Browser: ua.browser.name + ' ' + (ua.browser.major || ua.browser.version),
				Country: location.Name,
				Longitude: location.CityLongitude,
				Latitude: location.CityLatitude,
				UserAgent: visit.Whois.Agent
			});
			return visit;
		});

		var headers = ['DateTime', 'City', 'Country', 'Latitude', 'Longitude', 'Ipv4', 'OS', 'Browser', 'UserAgent'];

		return [headers].concat(visits.map(function(visit) {
			return headers.map(function(header) {
				return visit[header] || '';
			});
		}));
	},

	__exportToCSV: function(rows, filename) {
		var processRow = function (row) {
			var finalVal = '';
			for (var j = 0; j < row.length; j++) {
				var innerValue = row[j] === null ? '' : row[j].toString();
				if (row[j] instanceof Date) {
					innerValue = row[j].toLocaleString();
				};
				var result = innerValue.replace(/"/g, '""');
				if (result.search(/("|,|\n)/g) >= 0)
					result = '"' + result + '"';
				if (j > 0)
					finalVal += ',';
				finalVal += result;
			}
			return finalVal + '\n';
		};
	
		var csvFile = '';
		for (var i = 0; i < rows.length; i++) {
			csvFile += processRow(rows[i]);
		}
	
		var blob = new Blob([csvFile], { type: 'text/csv;charset=utf-8;' });
		var link = document.createElement("a");
		if (link.download !== undefined) {
			var url = URL.createObjectURL(blob);
			link.setAttribute("href", url);
			link.setAttribute("download", filename);
			link.style.visibility = 'hidden';
			document.body.appendChild(link);
			link.click();
			document.body.removeChild(link);
		}
	},

	__mapSetup: function() {
		this.__map = L.map(this._getAnchor('map'), {
			attributionControl: false,
			zoomControl: false,
			dragging: false,
			zoomSnap: 0,
			boxZoom: false,
			doubleClickZoom: false,
			scrollWheelZoom: false,
			closePopupOnClick: false
		}).setView([0, 0], 1);
		L.mapboxGL({
			attribution: "\u003ca href=\"https://www.maptiler.com/copyright/\" target=\"_blank\"\u003e\u0026copy; MapTiler\u003c/a\u003e \u003ca href=\"https://www.openstreetmap.org/copyright\" target=\"_blank\"\u003e\u0026copy; OpenStreetMap contributors\u003c/a\u003e",
			style: 'https://api.maptiler.com/maps/632dd2e6-d600-4063-a528-301bd0de9b44/style.json?key=OJu3z7zT01aT8z6fjwxV',
			zoom: 0,
			center: [0, 0]
		}).addTo(this.__map);

		this.__markerIcon = L.divIcon({
			className: 'marker'
		});

		this._getAnchor('frame').contentWindow.addEventListener('resize', function() {
			clearTimeout(this.__resizeTimeout);
			this.__resizeTimeout = setTimeout(function() {
				this.__map.invalidateSize();
			}.bind(this), 50);
		}.bind(this), false);
	},

	__showMarker: function(marker) {
		if (marker) {
			marker.openPopup();
			this.__map.flyTo(marker.getLatLng(), 4);
		}
	},

	__showAllLocations: function() {
		this.__map.closePopup();

		if (!this.__featureGroup) {
			this.__locations.forEach(function(location) {
				location.marker = L.marker([location.CityLatitude, location.CityLongitude], {
					icon: this.__markerIcon
				}).bindPopup(location.City + ', ' + location.Name, {
					closeButton: false
				});
			}, this);
			
			if (this.__locations.length) {
				this.__featureGroup = L.featureGroup(this.__locations.map(function(location) {
					return location.marker;
				})).addTo(this.__map);
			}
		}

		if (this.__featureGroup) {
			this.__map.fitBounds(this.__featureGroup.getBounds(), { padding: [20, 20], maxZoom: 4 });
		}
	},

	__destructor: function() {
		this.__map && this.__map.remove();
	}

};