_me = frm_sharing.prototype;
function frm_sharing(){};

frm_sharing.RIGHTS_GROUP = {};
frm_sharing.RIGHTS_GROUP.Y = {
	FULL: 'abcdeiklrtwx',
	WRITE: 'beiklr',
	OWNER: 'bcdeiklrx',
	ALL: 'bcdeiklrtwx',
	READ: 'lr',
	NONE: '-'
};
frm_sharing.RIGHTS_GROUP.I = frm_sharing.RIGHTS_GROUP.Y;
frm_sharing.RIGHTS_GROUP.DEFAULT = {
	FULL: 'aiklrtwx',
	WRITE: 'iklrw',
	AUTHOR: 'ilr',
	OWNER: 'iklrwx',
	ALL: 'iklrtwx',
	READ: 'lr',
	NONE: '-'
};

_me.__getRightsGroup = function(folder_info, group) {
	return (frm_sharing.RIGHTS_GROUP[WMFolders.getType(folder_info)] || frm_sharing.RIGHTS_GROUP.DEFAULT)[group];
};

_me.__constructor = async function(aHandler, aFolderInfo){
	this.__aFolderInfo = aFolderInfo;

	if (aHandler){
		this.__success_handler = aHandler;
		this.__error_handler = aHandler;
	}

	this._size(700, 450, true);

	var me = this;

	this.__bFormEnabled = false;
	this.inp_add._disabled(!this.__bFormEnabled);

	var folder = {};
	if(aFolderInfo.fid) {
		folder = dataSet.get('folders', [aFolderInfo.aid, aFolderInfo.fid]) || {};
		this._title(getLang('POPUP_FOLDERS::SHARING') + ' (' + (folder.NAME || (folder.RELATIVE_PATH || aFolderInfo.fid).replace(/^~/g, '')) + ')', true);
	} else {
		this._title(getLang('POPUP_FOLDERS::SHARING_ACCOUNT') + ' - ' + aFolderInfo.aid, true);
	}

	// Create 'INHERIT' button
	if (aFolderInfo.fid) {
		await this._create('x_btn_inherit', 'obj_button', 'footer','noborder ok');
		this.x_btn_inherit._disabled(true);

		this.x_btn_inherit._value('FORM_BUTTONS::INHERIT');
		this.x_btn_inherit._onclick = function() {
			//SMAZ PRAVA
			me.__aData = {};
			me.x_btn_ok._onclick();
		};
		this.x_btn_inherit._main.parentNode.insertBefore(this.x_btn_inherit._main, this.x_btn_inherit._main.previousSibling);
	}

	await this.users._addColumns({
		avatar: {width: 40, mode: 'px', css: 'avatar', type: 'static'},
		user:{css: 'user', title:"SHARING::SHARED_WITH", width:100, mode:'%', type:'static', css: 'user'},
		perm:{title:"SHARING::PERMISSIONS", width:140, css:'ico more', type:'static'},
		x: {width: 30, mode: 'px', css: 'remove', type: 'static'}
	});


	//Load Data
	var bEnable = true;

	try{
		var tmp;
		if (this.__aFolderInfo.fid)
			tmp = (await WMFolders.list(this.__aFolderInfo))[this.__aFolderInfo.aid][this.__aFolderInfo.fid];
		else
			tmp = (await WMAccounts.list(this.__aFolderInfo))[this.__aFolderInfo.aid];

		if (tmp){

			if (tmp.INHERITED_ACL == '1')
				this._title(getLang('POPUP_FOLDERS::SHARING')+' - '+(aFolderInfo.fid?(folder.NAME || (folder.RELATIVE_PATH || aFolderInfo.fid).replace(/^~/g, '')):aFolderInfo.aid) + ' ('+ getLang('SHARING::INHERITED') +')',true);

			if (tmp.RIGHTS && tmp.RIGHTS.indexOf('a')<0)
			    bEnable = false;

			tmp = tmp.ACL;
		}

		for(var i in tmp)
			this.__aData[i]  = tmp[i];

		tmp = null;
	}
	catch {
		bEnable = true;
	}

	var bPublic = dataSet.get('folders',[aFolderInfo.aid,aFolderInfo.fid,'PUBLIC']);
	//check for shared folder
	if (this.__aFolderInfo && this.__aFolderInfo.fid && (this.__aFolderInfo.fid.indexOf(sPrimaryAccountSPREFIX) === 0 || bPublic)){
		if (bPublic || this.__aFolderInfo.fid.indexOf('@')>0){
			var a = ((this.__aData[sPrimaryAccount] || this.__aData['['+aFolderInfo.fid+']'] || this.__aData.anyone) || {}).rights;
			if (Is.Array(a) && inArray(a,'a')>-1){
				//Enable All
				this.__bFormEnabled = true;
				this.x_btn_ok._disabled(false);
				this.inp_add._disabled(false);
				this.inp_add._focus();

				if (this.x_btn_inherit)
					this.x_btn_inherit._disabled(false);
			}
		}
	}
	//Enable All
	else
	if (bEnable){
		this.__bFormEnabled = true;
		this.x_btn_ok._disabled(false);
		this.inp_add._disabled(false);
		this.inp_add._focus();

		if (this.x_btn_inherit)
			this.x_btn_inherit._disabled(false);
	}

	this.inp_add._onkeyup = function() {
		me.x_btn_ok._disabled(!!me.inp_add._value());
	};

	this.__aData2 = clone(this.__aData,true);

	this._fill();

	this.users._obeyEvent('onclick', [async function (e,args){
		var elm = args.elm,
			arg = args.arg,
			cell = args.cell;
		if (me.__bFormEnabled && arg && arg.user && me.__aData[arg.user] && Is.Array(me.__aData[arg.user].rights)){

			switch(cell){
				case 'perm':

					if (arg && me.__aData[arg.user] && me.__aData[arg.user].rights && !+me.__aData[arg.user].isGuest){
						var r = me.__aData[arg.user].rights.sort().join(''),
							pos = getSize(elm),
							custom = !~[
								me.__getRightsGroup(aFolderInfo, 'READ'),
								me.__getRightsGroup(aFolderInfo, 'AUTHOR'),
								me.__getRightsGroup(aFolderInfo, 'WRITE'),
								me.__getRightsGroup(aFolderInfo, 'OWNER'),
								me.__getRightsGroup(aFolderInfo, 'ALL'),
								me.__getRightsGroup(aFolderInfo, 'FULL'),
								'-'
							].indexOf(r);

						me.cmenu = await gui._create('cmenu','obj_context');
						await me.cmenu._fill([
							{title:'SETTINGS::READ', arg:me.__getRightsGroup(aFolderInfo, 'READ').split(''), css: 'ico2' + (r==me.__getRightsGroup(aFolderInfo, 'READ')?' check':'')},
							(WMFolders.getType(aFolderInfo) === 'Y' || WMFolders.getType(aFolderInfo) === 'I') ? false :
							{title:'SETTINGS::AUTHOR', arg:me.__getRightsGroup(aFolderInfo, 'AUTHOR').split(''), css: 'ico2' + (r==me.__getRightsGroup(aFolderInfo, 'AUTHOR')?' check':'')},
							{title:'SETTINGS::WRITE', arg:me.__getRightsGroup(aFolderInfo, 'WRITE').split(''), css: 'ico2' + (r==me.__getRightsGroup(aFolderInfo, 'WRITE')?' check':'')},
							(WMFolders.getType(aFolderInfo) === 'Y' || WMFolders.getType(aFolderInfo) === 'I') ? {
								title:'SETTINGS::OWNER', arg:me.__getRightsGroup(aFolderInfo, 'OWNER').split(''), css: 'ico2' + (r==me.__getRightsGroup(aFolderInfo, 'OWNER')?' check':'')
							} : false,
							{title:'SETTINGS::ALL', arg:me.__getRightsGroup(aFolderInfo, 'ALL').split(''), css: 'ico2' + (r==me.__getRightsGroup(aFolderInfo, 'ALL')?' check':'')},
							{title:'SETTINGS::FULL', arg:me.__getRightsGroup(aFolderInfo, 'FULL').split(''), css: 'ico2' + (r==me.__getRightsGroup(aFolderInfo, 'FULL')?' check':'')},
							{title:'-'},
							{title:'SHARING::CUSTOM', arg:'custom', css: 'ico2' + (custom ? ' check' : '')},
							{title:'-'},
							{title:'SHARING::NONE', arg:[], css: 'ico2' + (r=='-'?' check':'')}
						].filter(Boolean));
						me.cmenu._place(pos.x+pos.w/2,pos.y+pos.h,null,3);

						me.cmenu._onclick = async function(e, elm, id, arg2){
							if (arg && arg.user){
								if(arg2 === 'custom') {
									await gui._create('frm_permissions', 'frm_permissions', '', '', {
										permissions: me.__aData[arg.user].rights,
										teamchat: ~'IY'.indexOf(WMFolders.getType(aFolderInfo)),
										callback: function(perms) {
											me.__aData[arg.user] = me.__aData[arg.user] || {};
											me.__aData[arg.user].rights = perms;
											me._fill();
										}
									});
								} else if(Is.Array(arg2)) {
									me.__aData[arg.user] = me.__aData[arg.user] || {};
									me.__aData[arg.user].rights = arg2;
									me._fill();
								}
							}
						};

						e.stopPropagation();
					}
			}

		}
	}]);
};

_me.__onAddNewFromAddressbook = async function (bOK, aAddresses) {
	if (bOK && aAddresses && aAddresses[0]) {
		var tmp;
		for (var i in aAddresses[0]) {
			tmp = MailAddress.splitEmailsAndNames(aAddresses[0][i]);
			if (tmp && (tmp = tmp[0]) && tmp.email && (!this.__aData[tmp.email] || this.__aData[tmp.email][0] === '~')) {
				this.__aData[tmp.email] = this.__aData[tmp.email] || {};
				var domain = tmp.email.replace(/(^\[)|(\]$)/g, '').split('@')[1];
				this.__aData[tmp.email].name = tmp.name;
				this.__aData[tmp.email].isGuest = await new Promise((resolve) => {
					icewarpapi.isGuestDomain(domain, function() {
						resolve(true);
					}, function() {
						resolve(false);
					});
				});
				this.__aData[tmp.email].rights = ['r', 'l'];
			}
		}

		this._fill();
	}
};

_me._fill = function(){
	var aData = [],
		arr = {};

	arr[this.__getRightsGroup(this.__aFolderInfo, 'FULL')] = getLang('SETTINGS::FULL');
	arr[this.__getRightsGroup(this.__aFolderInfo, 'ALL')] = getLang('SETTINGS::ALL');
	arr[this.__getRightsGroup(this.__aFolderInfo, 'READ')] = getLang('SETTINGS::READ');
	arr[this.__getRightsGroup(this.__aFolderInfo, 'OWNER')] = getLang('SETTINGS::OWNER');
	arr[this.__getRightsGroup(this.__aFolderInfo, 'WRITE')] = getLang('SETTINGS::WRITE');
	arr[this.__getRightsGroup(this.__aFolderInfo, 'AUTHOR')] = getLang('SETTINGS::AUTHOR');
	arr[this.__getRightsGroup(this.__aFolderInfo, 'NONE')] = getLang('SETTINGS::NONE');
	arr['*'] = getLang('SETTINGS::CUSTOM');

	for(var i in this.__aData)
		if (this.__aData[i][0]!='~') {

			var r = this.__aData[i].rights.sort().join('') || '-';

			aData.push({
				data:{
					avatar: obj_avatar.getAvatarHTML({ email: i, name: this.__aData[i].name, size: 32 }),
					user: '<span>' + (this.__aData[i].name || '').escapeHTML() + '</span><span>' + (i == 'anyone' ? getLang('SHARING::ANONYMOUS') : i.escapeHTML()) + '</span>',
					perm: +this.__aData[i].isGuest ? getLang('SETTINGS::READ') : '<span>' + (arr[r] || arr['*']).escapeHTML() +'</span>',
					x: ''
				},
				arg: {user:i,rights:this.__aData[i].rights, name: this.__aData[i].name, isGuest: this.__aData[i].isGuest},
				css: (+this.__aData[i].isGuest ? 'guest ' : '') + (Is.Array(this.__aData[i].rights)?this.__aData[i].rights.join(' '):'')});
		}

	this.users._fill(aData);
	this.x_btn_ok._disabled(!!this.inp_add._value());
};

_me.__save = function(){

	this.x_btn_ok._disabled(true);
	if (this.x_btn_inherit)
		this.x_btn_inherit._disabled(true);

	var d1 = clone(this.__aData,true),
		d2 = clone(this.__aData2,true),
		i;

	if (!Is.Empty(this.__aData)){
		for(i in d2)
			if ((d1[i].rights) && arrayCompare(d2[i].rights.sort(),d1[i].rights.sort()))
				delete d1[i];

		//No change, do not save
		if (Is.Empty(d1)){
			this.__success_handler();
			return;
		}
	}

	var acl = {};
	for (i in d1) {
		acl[i] = d1[i].rights || d1[i];
	}
	this.__aFolderInfo.acl = acl;
	if (this.__aFolderInfo.fid)
		WMFolders.add(this.__aFolderInfo,'null','',[this,'__success_handler'],[this,'__error_handler']);
	else
		WMAccounts.add(this.__aFolderInfo,'null','',[function(id, str){
			if (id)
				this.__error_handler(null, id, str);
			else
				this.__success_handler();

		}.bind(this)]);
};

_me.__success_handler = function(aData) {
	frm_manage_users.prototype.__success_handler.call(this, aData);
	gui.__exeEvent('itemShare', {
		aid: this.__aFolderInfo.aid,
		fid: this.__aFolderInfo.fid,
		isShared: Object.values(this.__aData).some(function(user) {
			return !Is.Empty(user.rights);
		})
	});
};
