_me = frm_share.prototype;

function frm_share() {};

_me.__constructor = async function (aValues, callback) {
	var me = this;

	this.__aValues = aValues;
	this._title('COMMON::SHARE');
	this._resizable(false);
	this._modal(true);

	await this._draw('frm_share', 'main', {
		disable_shareable_link: GWOthers.getItem('RESTRICTIONS', 'disable_shareable_link') == 1
	});
	await this._create('obj_scrollbar', 'obj_scrollbar');
	this.obj_scrollbar._scrollbar(this._getAnchor('main'));

	this.email.__separator = ';;;';

	this.__callback = callback;

	this._add_destructor('__onClose');

	if (this._getAnchor('copy_to_clipboard')) {
		this._getAnchor('copy_to_clipboard').addEventListener('click', function () {
			var input = document.createElement('input');
			input.style.opacity = 0;
			input.value = aValues.INVITETICKET;
			document.body.appendChild(input);
			input.select();
			document.execCommand('copy');
			input.parentElement.removeChild(input);
			this.__addCloseButton();
			this._getAnchor('link_copied').classList.remove('hidden');
		}.bind(this));
	}

	this._getAnchor('email_toggle').addEventListener('click', function () {
		this._getAnchor('email_container').classList.remove('hidden');
		this._reposition();
	}.bind(this));

	this.address_book._onclick = function () {
		gui._create('address_book', 'frm_addaddress', '', '', [this, '__onAddNewFromAddressbook'], ['ADDRESS_BOOK::SELECTED_ADDRESSES'], void 0, void 0, true, void 0, true, this._isModal());
	}.bind(this);

	this.__emailAction = 'notify_item';
	this.send_email._onclick = function () {
		var emails = (me.email._value() || '').split(';;;').filter(Boolean);
		var length = emails.length;
		if (length) {
			me.send_email._disabled(true);
		}
		emails.forEach(function (sEmail) {
			var email = MailAddress.splitEmailsAndNames(sEmail);
			if (email && (email = email[0]) && (email = email.email)) {

				WMItems.action({
					aid: aValues.aid,
					fid: aValues.fid,
					iid: aValues.EVN_ID,
					values: {
						EMAIL: email
					}
				}, me.__emailAction, [function () {
					if (!--length) {
						me.email._value('');
						me.send_email._disabled(false);
						me.__openSuccessPage(emails.map(function(sEmail) {
							return MailAddress.splitEmailsAndNames(sEmail)[0].email;
						}));
					}
				}]);
			}
		});
	};

	var f = dataSet.get('folders', [sPrimaryAccount]);
	var has_teamchat = sPrimaryAccountTeamchatToken && Object.keys(f).some(function (k) {
		return f[k].TYPE === 'I';
	});
	if (has_teamchat) {
		this._getAnchor('teamchat').classList.remove('hidden');

		this._getAnchor('teamchat_toggle').addEventListener('click', function () {
			me._getAnchor('teamchat_container').classList.remove('hidden');
			me._reposition();
		});

		this.lbl_chat._onclick = function () {
			var sFolder,
				f = Cookie.get(['last']);

			if (f && (f = f['I']) && (f = Path.split(f)) && WMFolders.getType(f) == 'I') {
				sFolder = f[1];
			} else {
				f = dataSet.get('folders', [sPrimaryAccount]);
				for (var id in f) {
					if (f[id].TYPE == 'I') {
						sFolder = id;
						break;
					}
				}
			}

			sFolder && gui._create('frm_select_folder', 'frm_select_folder', '', '', 'CHAT::SELECT', sPrimaryAccount, sFolder,
				[function (aid, fid) {
					var sName = dataSet.get('folders', [aid, fid, 'NAME']) || dataSet.get('folders', [aid, fid, 'RELATIVE_PATH']) || '';
					if (sName.length) {
						fid += '::' + sName;
						me.teamchat._value('[' + fid + ']');
					}
				}], true, true, ['Y', 'I'], '', true
			);
		};

		this.teamchat._onchange = function () {
			var tcs = MailAddress.splitEmails(this._value());
			if (tcs.length !== this.__etag.querySelectorAll('span').length) {
				this._value(tcs.join(','));
			}
			me.send_teamchat._disabled(!this._value());
		};

		this.__teamchatAction = 'document_link';
		this.send_teamchat._disabled(true);
		this.send_teamchat._onclick = function () {
			var tc = me.teamchat._value();
			if (!tc) {
				return;
			}
			me.send_teamchat._disabled(true);
			me.__tcs = tc.split(',');
			me.__tcs_length = me.__tcs.length;
			me.__tcs.forEach(function(tc) {
				var folder = tc.split('[')[1].split('::')[0];
				if (typeof me.__teamchatAction === 'function') {
					me.__teamchatAction({ aid: sPrimaryAccount, fid: folder }, aValues, [me, '__tc_callback']);
				} else {
					WMItems.action({
						aid: aValues.aid,
						fid: aValues.fid,
						iid: aValues.EVN_ID,
						nodes: {
							note: '',
							folder: folder
						}
					}, me.__teamchatAction, [me, '__tc_callback']);
				}
			});
		};
	}

	gui.socket.api._obeyEvent('onurlinfo', [this, '__onurlinfo']);

	this.back._onclick = function() {
		me.__closeSuccessPage();
	};
	this.__closeSuccessPage();
	this._size(700, 'auto', true);
};

_me.__preview = function() {
	this.send_teamchat._disabled(true);
	gui.socket.api._linkpreview(this.__aValues.INVITETICKET || this.__aValues.EVNURL, [function(aData) {
		if (aData.ATTRIBUTES.ID) {
			this.__lastURL = this.__aValues.INVITETICKET || this.__aValues.EVNURL;
		}
	}.bind(this)]);
};

_me.__onurlinfo = function(aData) {
	if (this.__lastURL && Is.Object(aData) && aData.URL && this.__lastURL == aData.URL[0].VALUE) {
		this.send_teamchat._disabled(!this.teamchat._value());
		this._create('preview', 'obj_urlpreview', '', '', aData);
	}
};

_me.__tc_callback = function() {
	if (!--this.__tcs_length) {
		this.teamchat._value('');
		this.__openSuccessPage(this.__tcs.map(function(tc) {
			return tc.split('::')[1].replace(/\]$/, '');
		}));
	}
}

_me.__openSuccessPage = function (recipients) {
	this.__addCloseButton();
	this._getAnchor('main_content').classList.add('hidden');
	this._getAnchor('share').classList.add('hidden');
	this._getAnchor('success').classList.remove('hidden');
	if(recipients.length > 1) {
		this._getAnchor('text').innerHTML = getLang('COLLABORATION::SUCCESS_MESSAGE_MULTIPLE', [
			mkElement('span', {
				className: 'name',
				textContent: recipients[0]
			}).outerHTML,
			mkElement('span', {
				className: 'others',
				textContent: getLang('COLLABORATION::SUCCESS_MESSAGE_OTHER' + (recipients.length > 2 ? 'S' : ''), [recipients.length - 1])
			}).outerHTML
		]);
		gui.tooltip._add(this._getAnchor('success').querySelector('.others'), recipients.slice(1).map(function(recipient) {
			return recipient.entityify();
		}).join('<br>'), { hide:false, css:'dark pad', html: true });
	} else {
		this._getAnchor('text').innerHTML = getLang('COLLABORATION::SUCCESS_MESSAGE', [
			mkElement('span', {
				className: 'name',
				textContent: recipients[0]
			}).outerHTML
		]);
	}
};

_me.__closeSuccessPage = function () {
	this._getAnchor('success').classList.add('hidden');
	this._getAnchor('main_content').classList.remove('hidden');
	this._getAnchor('share').classList.remove('hidden');
};

_me.__addCloseButton = async function () {
	var me = this;
	if (!this.x_btn_ok) {
		// Create 'OK' button
		await this._create('x_btn_ok', 'obj_button', 'footer', '');
		this.x_btn_ok._tabIndex();
		this.x_btn_ok._value('FORM_BUTTONS::CLOSE');
		this.x_btn_ok._onclick = function() {
			this._disabled(true);
			me._destruct();
		};
		this._reposition();
	}
};

_me.__onAddNewFromAddressbook = function (bOK, aAddresses) {
	if (bOK && aAddresses && aAddresses[0]) {
		var emails = this.email._value().split(';;;');
		for (var i in aAddresses[0]) {
			emails.push(aAddresses[0][i]);
		}
		this.email._value(emails.filter(function(v, i, s) {
			return s.indexOf(v) === i;
		}).join(';;;'));
	}
};

_me.__onClose = function () {
	gui.socket.api._disobeyEvent('onurlinfo', [this, '__onurlinfo']);
	executeCallbackFunction(this.__callback);
};

_me._reposition = function() {
	var container = this._getAnchor('container');
	var bcr = container.getBoundingClientRect();
	if ((bcr.y + bcr.height) > document.body.clientHeight) {
		container.style.top = '0px';
	}
};