function frm_setupwizard_security(){};

frm_setupwizard_security.prototype = {
    __constructor: async function(view){

		await this._draw('frm_setupwizard_security', 'main', {
			twoFactor: sPrimaryAccount2F > 0,
			sms: GWOthers.getItem('RESET_SETTINGS', 'sms') > 0
		});

		this.__view = view;

		view.title('SETUPWIZARD::LBL_SETUPWIZARD');
		view.parent._menu('security');
		await view.buttons([
			{value:'COMMON::NEXT', css:'big img next rounded color1', onclick:function(){
				var sOldMail = dataSet.get('accounts',[sPrimaryAccount,'ALTERNATIVE']) || '';
				var bSMS = this._getAnchor('sms') && this._getAnchor('sms').checked;
				var sNewMail = bSMS ? 'sms:' + this.altsms._value() : this.altmail._value();

				if (sOldMail != sNewMail)
					WMAccounts.add({aid:sPrimaryAccount,'ALTERNATIVE':sNewMail},'','', [function(bOk){
						if (bOk){
							dataSet.add('accounts',[sPrimaryAccount,'ALTERNATIVE'], sNewMail);
							view.next();
						}
						else
							this.altmail._select();
					}]);
				else
					view.next();

			}.bind(this),
			disabled:true}
		]);

		this.altmail._onerror = this._check.bind(this);
		if (this.altsms) {
			this.altsms._onerror = this._check.bind(this);
		}

		var me = this;
		if (this._getAnchor('sms')) {
			this._getAnchor('sms').onchange = function() {
				me.altmail._disabled(this.checked);
				me.altsms && me.altsms._disabled(!this.checked);
			};
		}

		if (this._getAnchor('mail')) {
			this._getAnchor('mail').onchange = function() {
				me.altmail._disabled(!this.checked);
				me.altsms && me.altsms._disabled(this.checked);
			};
		}

		if (sPrimaryAccount2F) {
			this._verify();
		}
		this._altmail();
	},

	_verify: function(){

		var elm = this._getAnchor('txt_verifi');

		if (!elm) {
			return;
		}

		elm.innerHTML = getLang('QUICK_SETTINGS::AUTHENTICATION',['<span>' + getLang(sPrimaryAccount2FE?'COMMON::ON':'COMMON::OFF') + '</span>']);

		if (!sPrimaryAccount2FE){
			addcss(elm, 'off');

			this.verifi._value(getLang('COMMON::ENABLE'));
			this.verifi._onclick = async function(){
				var frm = await gui._create('verify','frm_verify');
					frm._modal(true);
			};

			gui._obeyEvent('storage', [function(e, arg){
				if (e && e.type == 'set' && Is.Array(arg) && ~arg.indexOf("VERIFICATION")) {
					this._verify();

					return false;
				}
			}.bind(this)]);
		}
		else{
			removecss(elm, 'off');
			if (this.verifi)
				this.verifi._destruct();
		}

		this._check();
	},

	_altmail:function(){
		var aliases = dataSet.get('storage',['ALIASES','ITEMS']).filter(function(alias) {
			return alias.VALUES.PRIMARY || (alias.VALUES.TYPE || {}).VALUE === 'user';
		}).map(function(alias) {
			return alias.VALUES.EMAIL.VALUE;
		}).concat([sPrimaryAccount]);
		this.altmail._restrict([Is.Email], '', [function(email) {
			return !~aliases.indexOf(email);
		}], getLang('setupwizard::alternative_email_error'));
		if ((dataSet.get('accounts',[sPrimaryAccount,'ALTERNATIVE']) || '').indexOf('sms:') === 0) {
			if (this.altsms) {
				this.altsms._value((dataSet.get('accounts',[sPrimaryAccount,'ALTERNATIVE']) || '').replace(/^sms:/, ''));
			} else {
				this.altmail._value((dataSet.get('accounts',[sPrimaryAccount,'ALTERNATIVE']) || ''));
			}
			if (this._getAnchor('sms')) {
				this._getAnchor('sms').checked = true;
				this._getAnchor('sms').onchange();
			}
		} else {
			this.altmail._value(dataSet.get('accounts',[sPrimaryAccount,'ALTERNATIVE']) || '');
			if (this._getAnchor('mail')) {
				this._getAnchor('mail').checked = true;
				this._getAnchor('mail').onchange();
			}
		}
	},

	_check:function(){
		this.x_alt._value(this.altmail._checkError.filter(Boolean)[0] || '');
		this.x_altsms && this.x_altsms._value(this.altsms._checkError.filter(Boolean)[0] || '');

		var hasError = !!this.altmail._checkError.filter(Boolean)[0];
		var hasError2 = this.x_altsms ? !!this.altsms._checkError.filter(Boolean)[0] : false;

		var disabled = (sPrimaryAccount2F && GWOthers.getItem('LAYOUT_SETTINGS','require_2fa') == '1' && !sPrimaryAccount2FE) || hasError || hasError2 || !(this.altmail._value() + (this.altsms ? this.altsms._value() : ''));

		this.__view.parent.x_btn_0._disabled(disabled);
	},
};