function frm_setupwizard_personal(){};

frm_setupwizard_personal.prototype = {
    __constructor: async function(view){
		this.__view = view;
		this.__readOnly = GWOthers.getItem('RESTRICTIONS', 'disable_vcardedit') == '1';

		view.title('SETUPWIZARD::LBL_SETUPWIZARD');
		view.parent._menu('personal');
		await view.buttons([{
			value: 'COMMON::NEXT',
			css: 'next rounded color1 big img',
			onclick: function () {
				this._store(view);
			}.bind(this),
			disabled: !this.__readOnly
		}]);

		await this._draw('frm_setupwizard_personal','main',{readonly:this.__readOnly});

		await this._create('loader', 'obj_loader');

		if (this.__readOnly){
			this.fullname._readonly(true);
			this.phone._readonly(true);
			this._init();
		}
		else{
			this._avatar();

			await storage.library('wm_tools');
			(new wm_tools).geo([function(geo){
				this._init(geo.country_code);
			}.bind(this)]);
		}
	},

	_init: async function(sCountryCode){

		//there is no country select when readOnly mode
		if (this.country){

			//Country Code Select
			await storage.library('codes', 'codes');
			var aData = country_calling_codes.map(function(code){
				return [code.name, code.callingCode];
			});
			aData.unshift([getLang('SETUPWIZARD::COUNTRY_PH'), 0, {suggest: false}]);

			this.country._fill(aData);
			this.country._onchange = function(){
				this._showCode(this.country._getDataValue());
			}.bind(this);

			var iCountryID = 0;
			if (sCountryCode){
				var id = -1;
				for (var i in country_calling_codes) {
					if (country_calling_codes[i].code === sCountryCode) {
						id = i;
						break;
					}
				}
				iCountryID = 1 + (+id);
			}
			this.country._value(iCountryID);

			this.fullname._restrict('\\S+');
			this.phone._restrict('^(\\+?[\\d ]+)?$');

			var rPrefix = /^\+(\d{1,3})\s?(.+)/gm;
			this.phone._onchange = function(){
				var v = this.phone._value();

				if ((v || '').indexOf('+') === 0){
					var pref = rPrefix.exec(v),
						country_value = pref?aData.findIndex(function(a){ if (a[1] == pref[1]) { return true } }):-1;

					if (pref && pref[1] && ~country_value){
						this.country._value(country_value);
						this.phone._value(pref[2], true);
					}
					else{
						this.country._value(0);
						return;
					}
				}

			}.bind(this);

			var aFields = ['fullname','phone'];

			//Render mandatory items
			// if (GWOthers.getItem('GLOBAL_SETTINGS', 'mandatory_user_info') == '1' && Cookie.get(['suppressmandatory'])!=1){
			// 	var mandatory = GWOthers.getItem('GLOBAL_SETTINGS', 'mandatory_contact_fields');
			// }

			aFields.forEach(function(obj){
				this[obj]._onerror = this._check.bind(this);
			}.bind(this));
		}
		this.fullname._value(dataSet.get('accounts', [sPrimaryAccount, 'FULLNAME']));

		this.__homeLocation = {values:{LCTTYPE:'H'}};

		WMItems.list({aid:sPrimaryAccount, fid:'@@mycard@@', iid:'@@mycard@@'},'','','',[function(aData){
			if (Is.Object(aData) && (aData = aData[sPrimaryAccount]) && (aData = aData['@@mycard@@'])){

				for(var id in aData){
					if (id.charAt(0) == '*'){
						//full name
						this.__fullname = createNameFromLocation(aData[id]);
						this.__fullname && this.fullname._value(this.__fullname);

						//phone
						if (aData[id].LOCATIONS){
							var loc;
							for(var i in aData[id].LOCATIONS){
								loc = aData[id].LOCATIONS[i].values;
								if (loc.LCTTYPE == 'H'){

									this.__homeLocation = {
										uid:loc.LCT_ID,
										values:loc
									};

									this.phone._value(loc.LCTPHNMOBILE || '');
									break;
								}
							}
						}

						//avatar
						if (aData[id].ATTACHMENTS){
							var att;
							for(var attid in aData[id].ATTACHMENTS){
								att = aData[id].ATTACHMENTS[attid].values;
								if (att.ATTTYPE == 'P'){
									this.__avatarID = attid;
									this.__showAvatar('attachment', sPrimaryAccount+'/'+aData[id].ITMFOLDER+'/'+aData[id].ITM_ID+'/'+attid);
									break;
								}
							}
						}

						break;
					}
				}

			}
			this.loader && this.loader._destruct();
		}.bind(this)]);
	},

    _showCode: function(code){
        if (code){
            addcss(this.phone._main, 'show_code');

            if (!this.__eCode){
                this.__eCode = mkElement('div',{class:'code'});
                this.__eCode.onclick = function(){
                    this.country._value(0);
                }.bind(this);

                this.phone._main.insertBefore(this.__eCode, this.phone._main.firstChild);
            }

            this.__eCode.innerHTML = '+' + code;
        }
        else{
            removecss(this.phone._main, 'show_code');
        }
	},

	_avatar: async function(){
		await this._create('X_AVATAR', 'obj_upload');
		this.X_AVATAR._setFileTypes('image/*','');
		this.X_AVATAR._setPostParam('resize',1);
		this.X_AVATAR._setPostParam('width',800);
		this.X_AVATAR._setPostParam('height',800);

		this.X_AVATAR._onuploadstart = async function(){
			(await this._create('image_processing', 'obj_loader'))._value(getLang('COMMON::PROCESSING'));
		}.bind(this);

		this.X_AVATAR._onuploadend = function(arg){

			this.image_processing && this.image_processing._destruct();

			if (arg && (arg = arg[arg.length-1]) && arg.folder && arg.id)
				this.__showAvatar('file', arg.folder+'/'+arg.id);

		}.bind(this);

		this.X_AVATAR._dropzone(this._main);

		addcss(this._getAnchor('upload'), 'enabled');
		this._getAnchor('avatar').onclick = this._getAnchor('upload').onclick = this.X_AVATAR._click.bind(this.X_AVATAR);
	},

	__showAvatar:function(sType, sPath){

		var me = this,
			sURL = sPrimaryAccountClient + 'server/download.php?' + buildURL({'dlsess':dataSet.get('main',['dlsess']),'class':sType,'fullpath':sPath,'no':unique_id()}),
			img = new Image();

		img.onload = function(){
			var elm = me._getAnchor('avatar');
			if (elm){
				if (this.height>10 && this.width>10){
					elm.style.backgroundImage = 'url("'+ sURL +'")';
					elm.style.backgroundColor = '#FFFFFF';
					addcss(elm, 'loaded');
				}
				//Placeholder
				else{
					elm.style.backgroundImage = '';
					elm.style.backgroundColor = '';
					removecss(elm, 'loaded');
				}
			}
		};

		img.src = sURL;
	},

	_store:function(view){

		if (this.__readOnly){
			view.next();
			return;
		}

		var aValues = {values:{}};

		//Name
		aValues.values = parseNameToLocation(this.fullname._value());
		aValues.values.ITMSUFFIX = '';

		//Phone & calling code
		var new_phone = this.phone._value(),
			iCCode = this.country._getDataValue();
		if (iCCode)
			new_phone = '+'+iCCode+' '+new_phone.trim();

		if (this.__homeLocation.values.LCTPHNMOBILE != new_phone){
			this.__homeLocation.values.LCTPHNMOBILE = new_phone;
			aValues.LOCATIONS = [this.__homeLocation];
		}

		//Avatar
		var Attachments = this.X_AVATAR._value();
		if (Attachments.values.length){
			aValues.ATTACHMENTS = [];

			//remove existing avatar
			if (this.__avatarID)
				aValues.ATTACHMENTS.push({uid:this.__avatarID});

			//add new
			var aAtt = Attachments.values[0];
			aValues['ATTACHMENTS'].push({values:{"class":'image',description:aAtt.name,fullpath:aAtt.folder +'/'+ aAtt.id}});
		}

		WMItems.add([sPrimaryAccount, '@@mycard@@', '@@mycard@@'], aValues, '', '', '', [function(aData){
			if (aData){
				//fire avatar update evn
				if (aValues.ATTACHMENTS) {
					obj_avatar.sAvatarNo = Date.now();
					delete obj_avatar.ownAvatarURL;
					gui.__exeEvent('refreshAvatar', null, sPrimaryAccount);
				}

				view.next();
			}
		}]);
	},

	_check:function(){
		this.__view.parent.x_btn_0._disabled(this.fullname._checkError.length);
	}
};