function frm_setupwizard_backup() { };

frm_setupwizard_backup.prototype = {
	__constructor: async function (view) {
		this.__view = view;

		view.title('SETUPWIZARD::CUSTOM_BACKUP');
		view.parent._menu('backup');
		await view.buttons([{
			value: 'COMMON::NEXT',
			css: 'next rounded color1 big img',
			onclick: function () {
				this._store(view);
			}.bind(this)
		}]);

		await this._draw('frm_setupwizard_backup', 'main', {
			terms_url: GWOthers.getItem('CUSTOM_BACKUP_FORM', 'terms_url')
		});

		this._init(view);
	},

	_init: function (view) {
		this.custombackup._onchange = function(e, v) {
			this._parent._parent.x_btn_0._disabled(!v);
			this._parent.btn_skip._main.classList[v ? 'add' : 'remove']('hidden');
		}
		var custombackup = dataSet.get('accounts', [sPrimaryAccount, 'CUSTOMBACKUP']);
		this.custombackup._checked(custombackup, true);
		this.custombackup._onchange(false, custombackup);

		this.btn_skip._onclick = function () {
			var repeat_after_logins = +GWOthers.getItem('CUSTOM_BACKUP_FORM', 'REPEAT_AFTER_LOGINS');
			if (repeat_after_logins) {
				GWOthers.setItem('CUSTOM_BACKUP_FORM', 'REPEAT_AFTER_LOGINS_USER', repeat_after_logins);
			}

			var repeat_after_days = +GWOthers.getItem('CUSTOM_BACKUP_FORM', 'REPEAT_AFTER_DAYS');
			if (repeat_after_days) {
				GWOthers.setItem('CUSTOM_BACKUP_FORM', 'REPEAT_AFTER_DISPLAYED_ON', new IcewarpDate().format('YYYY-MM-DD'));
			}

			GWOthers.setItem('CUSTOM_BACKUP_FORM', 'DO_NOT_ASK_AGAIN', this.do_not_ask_again._checked());
			if (GWOthers.save([function() {
				view.next();
			}]) === 2) {
				view.next();
			}
		}.bind(this);
	},

	_store: function (view) {
		var custombackup = +this.custombackup._checked();
		WMAccounts.action({'CUSTOMBACKUP': custombackup}, 'set_custombackup', [function(){
			dataSet.add('accounts', [sPrimaryAccount, 'CUSTOMBACKUP'], custombackup);
			GWOthers.setItem('CUSTOM_BACKUP_FORM', 'DO_NOT_ASK_AGAIN', this.do_not_ask_again._checked());
			if (GWOthers.save([function() {
				view.next();
			}]) === 2) {
				view.next();
			}
		}.bind(this)]);
	}
};