function frm_setupwizard(){};

frm_setupwizard.prototype = {
    __constructor: async function(sView, aViews, sForceClosable, version) {
		this._modal(true);
		this._closable(sForceClosable);
		this._resizable(false);
		this._size(760,795,true);

		if (version) {
			this.__version = version;
		}

		this.__data = {
			views: aViews,
			seen:{}
		};

		if (sPrimaryAccountACTIVESYNC == '1' && (!aViews || ~aViews.indexOf('pair'))){
			WMItems.list({
				aid: sPrimaryAccount,
				fid: '__@@DEVICES@@__',
				filter: {
					limit: 1
				}
			}, '', '', '', [function(aData) {
				this._response(aData, sView);
			}.bind(this)]);
		}
		else
			this._response(false, sView);

		this._focus();
	},

	_response:function(aData, sView){

		//available views
		this.__views = {};
		if (sPrimaryAccountGUEST) {
			this.__views = {
				intro:		'frm_setupwizard_intro'
			}
		} else {
			this.__views = {
				intro:		'frm_setupwizard_intro',
				personal:	'frm_setupwizard_personal',
			};

			if (GWOthers.getItem('CUSTOM_BACKUP_FORM', 'enabled') == '1' && GWOthers.getItem('CUSTOM_BACKUP_FORM', 'DO_NOT_ASK_AGAIN') !== 'true') {
				this.__views.backup = 'frm_setupwizard_backup';
			}

			this.__views.security = 'frm_setupwizard_security';
		};

		// sync
		if (sPrimaryAccountACTIVESYNC == '1' && ((aData && (aData = aData[sPrimaryAccount]) && (aData = aData['__@@DEVICES@@__']) && aData['/'] == '0') || (sView === 'device'))){
			this.__views.pair = 'frm_setupwizard_pair';
			this.__views.device = 'frm_setupwizard_device';
			this.__views.mobile = 'frm_setupwizard_mobile';
		}

		if (dataSet.get('main', ['ICEWARPMOBILEAPP_URL'])) {
			this.__views.app = 'frm_setupwizard_app';
			this.__views.app2 = 'frm_setupwizard_app2';
			this.__views.app3 = 'frm_setupwizard_app3';
		}

		if (!Object.keys(this.__views).length) {
			return this._destruct();
		}

		this.__views.finish = 'frm_setupwizard_finish';

		//Default page logic
		this._view(sView || 'intro');
	},

	_menu: async function(sValue){
		if (sValue){

			this.__data.seen[sValue] = true;

			//Menu
			if (!this.menu){
				await this._create('menu','obj_hmenu','header','transparent');
				this.menu._onclick = function(e, elm, id, arg){
					this._view(arg);
				}.bind(this);
			}

			var	aMenu = sPrimaryAccountGUEST ? [] : [
				{title: 'SETUPWIZARD::TAB_PERSONAL', css: '', arg: 'personal'},
				this.__views.backup && {title: 'SETUPWIZARD::BACKUP', css: '', arg: 'backup'},
				{title: 'SETUPWIZARD::TAB_SECURITY', css: '', arg: 'security'}
			].filter(Boolean);

			if (this.__views.pair)
				aMenu.push({title: 'SETUPWIZARD::TAB_DEVICE', css: '', arg: 'pair'});

			if (this.__views.app)
				aMenu.push({title: 'SETUPWIZARD::TAB_APP', css: '', arg: 'app'});

			aMenu = aMenu.filter(function(itm){
				return !this.__data.views || !this.__data.views.length || ~this.__data.views.indexOf(itm.arg);
			}, this).map(function(itm){

				if (!this.__data.seen[itm.arg] || itm.arg == sValue){
					itm.css = 'nohover';
					if (itm.arg == sValue)
						itm.css += ' active';

					delete itm.arg;
				}

				return itm;
			}, this);

			if (aMenu.length > 1) {
				await this.menu._fill(aMenu);
			} else {
				this.menu._destruct();
			}
		}
		else
		if (this.menu)
			this.menu._destruct();
	},

	_onclose: function () {
		Cookie.set(['setupwizard'], (GWOthers.getItem('LOGIN_SETTINGS', 'version') || '').split('.').slice(0, 3).join('.'));
		if (this.__version) {
			Cookie.set(['setupwizard_version'], this.__version);
		}
		this.__onclose && this.__onclose();
		return true;
	}
};
