_me = frm_settings_admin.prototype;
function frm_settings_admin(){};

_me.__constructor = async function(bDomainadmin,sDomainName)
{
	var me = this;
	this._defaultSize(850, 620, {
		goldenRatio: true
	});

	if ((this._bDomainadmin = bDomainadmin?true:false))
		this._title(getLang('MAIN_MENU::DOMAIN_OPTIONS')+(sDomainName?' ('+ sDomainName +')':''),true);
	else
		this._title('MAIN_MENU::ADMIN_OPTIONS');

	this._xmlns = 'public';

	if (this._bDomainadmin) {
		await this._draw('frm_settings_domainadmin','main', {
			domain_settings: true,
			gw_access: sPrimaryAccountGW > 0,
			im_access: sPrimaryAccountIM > 0,
			chat_access: sPrimaryAccountCHAT > 0,
			digest_allowed: (GWOthers.getItem('GLOBAL_SETTINGS', 'teamchat_notify') || 0) > 0
		});
		this._storage = 'domainadmin_storage';
		if (sDomainName){
			this._domain = sDomainName.trim();
			this._storage += '_' + this._domain;
		}
		else
			this._domain = dataSet.get('main',['domain']);
	}
	else {
		//include domains
		await storage.library('wm_domains');
		this._domains = new wm_domains;

		await this._draw('frm_settings_admin','main',{
			admin_settings: true,
			gw_access: sPrimaryAccountGW > 0,
			im_access: sPrimaryAccountIM > 0,
			chat_access: sPrimaryAccountCHAT > 0,
			digest_allowed: (GWOthers.getItem('GLOBAL_SETTINGS', 'teamchat_notify') || 0) > 0
		});
		this._storage = 'admin_storage';
	}

	var aRsc = ['skins',
				'mail_settings_general',
				'mail_settings_default',
				'layout_settings',
				'languages',
				'reset_settings',
				'calendar_settings',
				'default_calendar_settings',
				'event_settings',
				'global_settings',
				'spellchecker_languages',
				'restrictions',
				'external_settings',
				'groups',
				'signature',
				'teamchat_notify',
				'documents'
				];

	if (sPrimaryAccountIM>0) {
		aRsc.push('im');
		aRsc.push('chat');
	}

	if (!this._bDomainadmin)
		aRsc.push('domains_settings');

	await storage.library('wm_storage');
	await storage.library('frm_settings_helper');

    if (this._bDomainadmin && this._domain)
		dataSet.add(this._storage, '', await WMStorage.get({'xmlns': this._xmlns,'domain':this._domain,'resources':aRsc}));
	else
		dataSet.add(this._storage, '', await WMStorage.get({'xmlns': this._xmlns,'resources':aRsc}));

	this.__loadItems();

	this.x_btn_ok._onclick = function(){
		me.__saveItems();
		//if (GWOthers.getItem('LAYOUT_SETTINGS', 'language') != me._curLanguage)
		//	alert(getLang('LANGUAGES::ONCHANGE_INFO'));
	};

	this.__helper = new FrmSettingsHelper(this._bDomainadmin, true);
};

_me.__loadItems = function()
{
	if(!this.maintab) {
		return;
	}

	var me = this;

	// ********************************************
	// MAILSETTINGS
	this.maintab.mail_settings._onactive = function (bFirstTime) {
		var oTab = this.maintab;
		if (!bFirstTime){
            oTab.general._active(false);
			return;
		}

		// TAB1 - GENERAL
		oTab.general._onactive = function (bFirstTime) {
			if (bFirstTime) {

				this.show_inline_images._onchange = function(){
					oTab.general.show_images._disabled(!this._checked());
				};

				this.default_flag._fillLang({
					'1':["COLOR_LABELS::RED_FLAG",'bg_red'],
					'2':["COLOR_LABELS::BLUE_FLAG",'bg_blue'],
					'3':["COLOR_LABELS::GREEN_FLAG",'bg_green'],
					'5':["COLOR_LABELS::ORANGE_FLAG",'bg_orange'],
					'8':["COLOR_LABELS::PURPLE_FLAG",'bg_purple'],
					'a':["COLOR_LABELS::YELLOW_FLAG",'bg_yellow']
				});

				var aData = GWOthers.get('MAIL_SETTINGS_GENERAL', me._storage, true);
				if (aData)
					loadDataIntoFormOnAccess(this, aData, me._bDomainadmin);
			}
		}

		// TAB2 - DEFAULT
		oTab.mail_default._onactive = function (bFirstTime) {
			if (bFirstTime) {
				// Disable/enable options related to html email
				this.html_message._onchange = function() {
					me.__helper.htmlMessageFormatChange(
						this._parent,
						'0' === this._value()
					);
				};

				//spellchecker default lang
				var aLang = dataSet.get(me._storage,['SPELLCHECKER_LANGUAGES','ITEMS']);
				var aData = {};
				for (var i in aLang)
					if (aLang[i].VALUES && aLang[i].VALUES.PATH && aLang[i].VALUES.NAME)
						aData[aLang[i].VALUES.PATH.VALUE] = aLang[i].VALUES.NAME.VALUE;

				this.spellchecker._fill(aData);

				//Font-family
                aLang = dataSet.get('storage',['FONTS','ITEMS']);
				aData = {'0':getLang('SETTINGS::DEFAULT')};
			    for(i in aLang)
					if (aLang[i].VALUES.FAMILY.VALUE)
						aData[aLang[i].VALUES.FAMILY.VALUE] = aLang[i].VALUES.NAME.VALUE;
				this.font_family._fill(aData);
				this.font_family._obeyEvent('show', [function (e, args) {
					[].forEach.call(args.owner.block._main.querySelectorAll('a'), function (a) {
						a.style.fontFamily = a.getAttribute('rel');
					});
				}]);

				aData = GWOthers.get('MAIL_SETTINGS_DEFAULT', me._storage, true);
				if (aData)
					loadDataIntoFormOnAccess(this, aData, me._bDomainadmin);

                if (!this.font_family._value())
                	this.font_family._value('0');
				
				frm_settings.prototype._setClassificationColors.call(me, this, aData);
			}
		};

		// TAB8 - GROUPS
		oTab.groups._onactive = async function (bFirstTime) {
			if (bFirstTime) {

				var ds = dataSet.get(me._storage,['GROUPS','ITEMS']),
					dg = this.groups;

				//DataGrid
				dg.__sortColumn = 'GROUP';
				dg.__sortType = 0;
				await dg._addColumns({
					'GROUP':{title:'SETTINGS::GROUP','width':50,mode:'%','arg':{'sort':'asc'},encode:true},
					'FOLDER':{title:'SETTINGS::SENT_FOLDER','width':50,mode:'%','arg':{'sort':'asc'},encode:true}
				});

				if (Is.Array(ds))
					for (var out = {}, i = 0; i<ds.length; i++)
						if (ds[i].VALUES && ds[i].VALUES.GROUP)
							out[ds[i].VALUES.GROUP.VALUE] = {
								data:{
									GROUP:ds[i].VALUES.GROUP.VALUE,
									FOLDER:ds[i].VALUES.SENTFOLDER && ds[i].VALUES.SENTFOLDER.VALUE?ds[i].VALUES.SENTFOLDER.VALUE:getLang('SETTINGS::DEFAULT')
								},
								arg:{
									group:ds[i].VALUES.GROUP.VALUE,
									folder:ds[i].VALUES.SENTFOLDER && ds[i].VALUES.SENTFOLDER.VALUE ? sPrimaryAccount + '/' + ds[i].VALUES.SENTFOLDER.VALUE:'' // /~
								}
							};

				dg._fill(out);

				dg.__grouphandler = function(a,b){
					if (a && dg._aData[a.group])
						delete dg._aData[a.group];

					dg._aData[b.group] = {
						data:{
							GROUP:b.group,
							FOLDER:b.folder?Path.split(b.folder)[1]:getLang('SETTINGS::DEFAULT')
						},
						arg:b
					};
					dg._fill();
				};

				// open item
				dg._ondblclick = function(e,elm,arg){
					if (arg)
						oTab.groups.x_edit._onclick();
				};

				//Dialog
				async function dialog(arg,aHandler){

					var frm = await gui._create('add_group','frm_ok_cancel','','frm_group');
						frm._modal(true);
						frm._resizable(false);

						frm._title('SETTINGS::GROUP');
						await frm._draw('frm_group','main');
						frm._size(380,'auto',true);

						//folder input
						frm.folder._value(arg && arg.folder?arg.folder:GWOthers.getItem('DEFAULT_FOLDERS','sent'));

						//group input
						if (arg && arg.group)
							frm.group._value(arg.group);

						frm.group._onerror = function(b){
							frm.x_btn_ok._disabled(b);
						};

						frm.group._restrict([function(v){
							if (v){
								var tmp = MailAddress.splitEmailsAndNames(v);
								if (tmp[0] && tmp[0].email && Is.Email(tmp[0].email))
									return true;
							}
							return false;
						}]);

						frm.group._onsubmit = function(){
							frm.x_btn_ok._onclick();
						};

						//OK
						frm.x_btn_ok._onclick = function(){
							if (aHandler){
								var tmp = MailAddress.splitEmailsAndNames(frm.group._value());
								if (tmp[0] && tmp[0].email && Is.Email(tmp[0].email))
									executeCallbackFunction(aHandler,arg,{group:tmp[0].email,folder:frm.folder._value() == GWOthers.getItem('DEFAULT_FOLDERS','sent')?'':frm.folder._value()})
							}

							this._parent._destruct();
						};

				};

				//Buttons
				this.x_add._onclick = function(){
					dialog('',[dg, '__grouphandler']);
				};

				this.x_edit._onclick = function(){
					var v = dg._value();
					for (var i in v)
						if (dg._aData[v[i]]){
							dialog(dg._aData[v[i]].arg,[dg, '__grouphandler']);
							break;
						}
				};

				this.x_remove._onclick = function(){
					var v = dg._value();
					for (var i = v.length-1; i>=0; i--)
						delete dg._aData[v[i]];

					dg._fill();
				};

			}
		};

		oTab.signature._onactive = async function (bFirstTime) {
			if (bFirstTime){
				await this.text._create('vars','obj_select','additional');
				this.text.__opt.forceEmbeddedImages = false;
				this.text.vars._fill({
					'*':getLang('SIGNATURE::VARIABLE'),
					'%displayname%':getLang('CONTACT::DISPLAYNAME'),
					'%firstname%':getLang('CONTACT::FIRST_NAME'),
					'%middlename%':getLang('CONTACT::MIDDLE_NAME'),
					'%surname%':getLang('CONTACT::LAST_NAME'),
					'%fullname%':getLang('CONTACT::FULL_NAME'),
					'%nickname%':getLang('CONTACT::NICK_NAME'),
					'%profilepicture&WIDTH&HEIGHT%': getLang('CONTACT::picture'),
					'%title%':getLang('CONTACT::TITLE'),
					'%suffix%':getLang('CONTACT::SUFFIX'),
					'%email1%':getLang('CONTACT::EMAIL1'),
					'%email2%':getLang('CONTACT::EMAIL2'),
					'%email3%':getLang('CONTACT::EMAIL3'),
					'%im%':getLang('CONTACT::IM'),
					'%freebusy%':getLang('CONTACT::CALENDAR_URL'),
					'%company%':getLang('CONTACT::COMPANY'),
					'%job%':getLang('CONTACT::JOB'),
					'%profession%':getLang('CONTACT::PROFESSION'),
					'%department%':getLang('CONTACT::DEPARTMENT'),
					'%assistant%':getLang('CONTACT::ASSISTANT'),
					'%manager%':getLang('CONTACT::MANAGER'),
					'%homepage%':getLang('CONTACT::HOMEPAGE'),
					'%street%':getLang('CONTACT::STREET'),
					'%city%':getLang('CONTACT::CITY'),
					'%state%':getLang('CONTACT::STATE'),
					'%zip%':getLang('CONTACT::ZIP'),
					'%country%':getLang('CONTACT::COUNTRY'),
					'%phonehome%':getLang('CONTACT::PHONE')+' '+getLang('PHONE::LCTPHNHOME1'),
					'%phonehome2%':getLang('CONTACT::PHONE')+' '+getLang('PHONE::LCTPHNHOME2'),
					'%phonemobile%':getLang('PHONE::LCTPHNMOBILE'),
					'%phoneassistant%':getLang('CONTACT::PHONE')+' '+getLang('PHONE::LCTPHNASSISTANT'),
					'%phonework%':getLang('CONTACT::PHONE')+' '+getLang('PHONE::LCTPHNWORK1'),
					'%phonework2%':getLang('CONTACT::PHONE')+' '+getLang('PHONE::LCTPHNWORK2'),
					'%faxhome%':getLang('PHONE::LCTPHNFAXHOME'),
					'%faxwork%':getLang('PHONE::LCTPHNFAXWORK'),
					'%faxother%':getLang('PHONE::LCTPHNOTHERFAX'),
					'%phonecallback%':getLang('PHONE::LCTPHNCALLBACK'),
					'%phonecompany%':getLang('PHONE::LCTPHNCOMPANY'),
					'%phonecar%':getLang('PHONE::LCTPHNCAR'),
					'%phoneisdn%':getLang('PHONE::LCTPHNISDN'),
					'%phoneother%':getLang('PHONE::LCTPHNOTHER'),
					'%phonepager%':getLang('PHONE::LCTPHNPAGER'),
					'%phoneprimary%':getLang('PHONE::LCTPHNPRIMARY'),
					'%phoneradio%':getLang('PHONE::LCTPHNRADIO'),
					'%phonetelex%':getLang('PHONE::LCTPHNTELEX'),
					'%phonehearing%':getLang('PHONE::LCTPHNHEARING'),
					'%phonesip%':getLang('PHONE::SIP'),
					'%businesshomepage%':getLang('CONTACT::HOMEPAGE') + ' ('+getLang('CONTACT::BUSINESS') +')',
					'%businessstreet%':getLang('CONTACT::STREET') + ' ('+getLang('CONTACT::BUSINESS') +')',
					'%businesscity%':getLang('CONTACT::CITY') + ' ('+getLang('CONTACT::BUSINESS') +')',
					'%businessstate%':getLang('CONTACT::STATE') + ' ('+getLang('CONTACT::BUSINESS') +')',
					'%businesszip%':getLang('CONTACT::ZIP') + ' ('+getLang('CONTACT::BUSINESS') +')',
					'%businesscountry%':getLang('CONTACT::COUNTRY') + ' ('+getLang('CONTACT::BUSINESS') +')',
				});

				this.x_preview._onclick = async function(){
					await storage.library('wm_tools');

					var aValues = {};
					storeDataFromFormWithAccess(me.maintab.mail_settings.maintab.signature, aValues, {});

					if (!aValues.text.length)
						await gui._create('signature_preview','frm_signature_preview','','signature_preview', '');
					else{
						var tools = new wm_tools();
						tools.signature_preview(aValues.text, [function(sData) {
							if (Is.String(sData))
								gui._create('signature_preview','frm_signature_preview','','signature_preview', sData);
						}]);
					}
				};

				this.text._disableInsertImageFromComputer = true;

				this.text.vars._value('*');
				this.text.vars._onchange = function(){
					if (this._value() != '*') {
						this._parent.__exec('html.insert', [this._value(), true]);
					}
					this._value('*');
				};

				var aSign = dataSet.get(me._storage,['SIGNATURE','ITEMS','0','VALUES','TEXT']);
				if (aSign){
					var aData = {};
					if (aSign.ATTRIBUTES){
						aData.USERACCESS = {'text':aSign.ATTRIBUTES.USERACCESS};
						aData.ACCESS = {'text':aSign.ATTRIBUTES.ACCESS};
						aData.DOMAINADMINACCESS = {'text':aSign.ATTRIBUTES.DOMAINADMINACCESS};
					}
					aData.VALUES = {'text':aSign.VALUE};
					loadDataIntoFormOnAccess(this, aData, me._bDomainadmin);
				}

				this.text._disableInsertImageFromComputer = true;
			}
		};

		// force drawing first tab
		oTab.general._active(true);
	}
	// ********************************************

	// IM SETTINGS
	if (this.maintab.chat_settings)
		this.maintab.chat_settings._onactive = function (bFirstTime) {
			var oTab = this.maintab;
			if (bFirstTime){

				if (oTab.input)
					oTab.input._onactive = function (bFirstTime) {
		                if (bFirstTime){
							var aData = GWOthers.get('CHAT', me._storage, true);
							if (typeof aData == 'object')
								loadDataIntoFormOnAccess(this, aData, me._bDomainadmin);
						}
					};

				if (oTab.im)
					oTab.im._onactive = function (bFirstTime) {
		                if (bFirstTime){
							var aData = GWOthers.get('IM', me._storage, true);
							if (typeof aData == 'object')
								loadDataIntoFormOnAccess(this, aData, me._bDomainadmin);
						}
					};

				if (oTab.teamchat)
					oTab.teamchat._onactive = function (bFirstTime) {
						if (bFirstTime){
							this.teamchat_notify._onchange = function(){
								var b = !this._value();
								this._parent.u_gw_teamchat_dailynotify && this._parent.u_gw_teamchat_dailynotify._disabled(b);
								this._parent.u_gw_teamchat_pinnotify && this._parent.u_gw_teamchat_pinnotify._disabled(b);
								this._parent.u_gw_teamchat_uploadnotify && this._parent.u_gw_teamchat_uploadnotify._disabled(b);
								this._parent.u_gw_teamchat_mentionnotify && this._parent.u_gw_teamchat_mentionnotify._disabled(b);
							};

							var aData = GWOthers.get('CHAT', me._storage, true) || {};
							var bData = GWOthers.get('GLOBAL_SETTINGS', me._storage, true) || {VALUES: {}, ACCESS: {}, USERACCESS: {}, DOMAINADMINACCESS: {}};
							for(var i in bData.VALUES) {
								aData.VALUES[i] = bData.VALUES[i];
							}
							for(i in bData.ACCESS) {
								aData.ACCESS[i] = bData.ACCESS[i];
							}
							for(i in bData.USERACCESS) {
								aData.USERACCESS[i] = bData.USERACCESS[i];
							}
							for(i in bData.DOMAINADMINACCESS) {
								aData.DOMAINADMINACCESS[i] = bData.DOMAINADMINACCESS[i];
							}
							if (typeof aData === 'object')
								loadDataIntoFormOnAccess(this, aData, me._bDomainadmin);

							this.teamchat_notify._onchange();
						}
					};

				// force drawing first tab
				oTab.input._active(true);
			}
		};

	// GENERALSETTINGS
	this.maintab.general_settings._onactive = function (bFirstTime) {
		var oTab = this.maintab;
		if (!bFirstTime){
			oTab.layout._active(false);
			return;
		}

		// TAB1 - LAYOUT
		oTab.layout._onactive = function (bFirstTime) {
			if (bFirstTime) {
				this.date_format._fill(CalendarFormatting.getFormats());
				//LANGs
				var aLang = GWOthers.get('LANGUAGES', me._storage, true),
					aData = {};
				for (var lang in aLang['VALUES'])
					aData[lang] = aLang['VALUES'][lang];
				this.language._fill(aData);

				if (!aData[GWOthers.getItem('LAYOUT_SETTINGS','language')])
					GWOthers.setItem('LAYOUT_SETTINGS','language',GWOthers.getDefaultValues('LAYOUT_SETTINGS').LANGUAGE);

				//SKINs
				var aSkin = GWOthers.get('SKINS', me._storage, true);
				aData = {};
				for (var i in aSkin['VALUES'])
					if (i != 'value' && i != 'biggerrtl' && i != 'banner')
						aData[i] = aSkin['VALUES'][i];
				this.skin._fill(aData);
				this.skin._onchange = function() {
					me.__skin = this._value();
				};

				if (GWOthers.getItem('LAYOUT_SETTINGS', 'skin') === 'biggerrtl') {
					GWOthers.setItem('LAYOUT_SETTINGS', 'skin', 'bigger');
				}
				if (!aData[GWOthers.getItem('LAYOUT_SETTINGS','skin')] || GWOthers.getItem('LAYOUT_SETTINGS', 'skin') === 'banner')
					GWOthers.setItem('LAYOUT_SETTINGS','skin',GWOthers.getDefaultValues('LAYOUT_SETTINGS').SKIN);

				//LOAD DATA
				aData = GWOthers.get('LAYOUT_SETTINGS', me._storage, true);

				me.__skin = GWOthers.getItem('LAYOUT_SETTINGS', 'skin');

				if (typeof aData == 'object')
					loadDataIntoFormOnAccess(this, aData, me._bDomainadmin);
			}
		};
		if (oTab.documents) {
			oTab.documents._onactive = function (bFirstTime) {
				if (bFirstTime) {
					var aData = GWOthers.get('DOCUMENTS', me._storage, true);

					//Autosave
					this.autosave._onclick = function() {
						this._parent.autosave_minutes._disabled(this._checked());
					};

					// Disable document editing
					this.disable_office._value(0);
					this.disable_office._onclick = function() {
						this._parent.office_app._disabled(!this._value());
					};
					this.office_app._fill({
						webdoc: getLang('OFFICELAUNCHER::WEBDOC'),
						webdoc_read: getLang('OFFICELAUNCHER::WEBDOC_READ'),
						suite: getLang('OFFICELAUNCHER::SUITE')
					});

					if (typeof aData == 'object')
						loadDataIntoFormOnAccess(this, aData, me._bDomainadmin);

					this.autosave_minutes._disabled(!this.autosave._checked());
					this.office_app._disabled(this.disable_office._value());
				}
			};
		}
		oTab.login._onactive = function (bFirstTime) {
			if (bFirstTime) {
				//Restriction part
				aData = GWOthers.get('RESTRICTIONS', me._storage, true);
				if (typeof aData == 'object')
					loadDataIntoFormOnAccess(this, aData, me._bDomainadmin);

				if (this.enabled) {
					this.enabled._onchange = function() {
						this._parent.sms._disabled(!this._checked());
					};
				}

				// password reset
				aData = GWOthers.get('RESET_SETTINGS', me._storage, true);
				if (typeof aData == 'object')
					loadDataIntoFormOnAccess(this, aData, me._bDomainadmin);

				var aData = GWOthers.get('LAYOUT_SETTINGS', me._storage, true);

				['facebook_link', 'twitter_link', 'linkedin_link', 'require_2fa', 'disable_languages', 'disable_signup', 'disable_remember', 'disable_autofill', 'contact_support', 'facebook_disabled', 'twitter_disabled', 'linkedin_disabled'].forEach(function(input) {
					(oTab.login[input] || oTab.login['x_' + input])._value(aData.VALUES[input]);
					if (oTab.login['x_' + input + '_set'].user)
						oTab.login['x_' + input + '_set'].user._value(aData.USERACCESS[input] == 'view');
					if (oTab.login['x_' + input + '_set'].domadmin)
						oTab.login['x_' + input + '_set'].domadmin._value(aData.DOMAINADMINACCESS[input] == 'view');

					if (me._bDomainadmin) {
						(oTab.login[input] || oTab.login['x_' + input])._disabled(aData.ACCESS[input] == 'view');
					}
				}, this);
			}
		};

		// TAB4 - SERVER
		if (oTab.server)
			oTab.server._onactive = function (bFirstTime) {
				if (bFirstTime) {
					var aData = GWOthers.get('GLOBAL_SETTINGS', me._storage, true);
					if (typeof aData == 'object')
						loadDataIntoFormOnAccess(this, aData, me._bDomainadmin);
				}
			};

		// TAB5 - RESTRICTIONS
		if (oTab.restrictions)
			oTab.restrictions._onactive = function (bFirstTime) {
				if (bFirstTime) {
					var aData = GWOthers.get('RESTRICTIONS', me._storage, true);
					if (typeof aData == 'object')
						loadDataIntoFormOnAccess(this, aData, me._bDomainadmin);

					if (aData.VALUES.disable_gw_types){
						if (aData.VALUES.disable_gw_types.indexOf('c')>-1)
							oTab.restrictions.x_c._value(1);
						if (aData.VALUES.disable_gw_types.indexOf('e')>-1)
							oTab.restrictions.x_e._value(1);
						if (aData.VALUES.disable_gw_types.indexOf('j')>-1)
							oTab.restrictions.x_j._value(1);
						if (aData.VALUES.disable_gw_types.indexOf('n')>-1)
							oTab.restrictions.x_n._value(1);
						if (aData.VALUES.disable_gw_types.indexOf('t')>-1)
							oTab.restrictions.x_t._value(1);
						if (aData.VALUES.disable_gw_types.indexOf('f')>-1)
							oTab.restrictions.x_f._value(1);
						if (aData.VALUES.disable_gw_types.indexOf('r')>-1)
							oTab.restrictions.x_r._value(1);


						/*
						//Not used
						if (aData.VALUES.disable_gw_types.indexOf('w')>-1)
							oTab.restrictions.x_w._value(1);
						if (aData.VALUES.disable_gw_types.indexOf('b')>-1)
							oTab.restrictions.x_b._value(1);
						*/

						if (aData.VALUES.disable_gw_types.indexOf('q')>-1)
							oTab.restrictions.x_q._value(1);
					}

					if (oTab.restrictions.x_disable_gw_types_set.domadmin)
						oTab.restrictions.x_disable_gw_types_set.domadmin._value(aData.DOMAINADMINACCESS.disable_gw_types == 'view');


					if(oTab.restrictions.disable_login_help)
						oTab.restrictions.disable_login_help._onchange = function() {
							if(this._checked())
								oTab.restrictions.disable_login_banners._checked(true);
						}

				}
			};

		if (oTab.dropbox)
			oTab.dropbox._onactive = function (bFirstTime) {
				if (bFirstTime) {
					var aData = GWOthers.get('EXTERNAL_SETTINGS', me._storage, true);
					if (typeof aData == 'object')
						loadDataIntoFormOnAccess(this, aData, me._bDomainadmin);
				}
			}

		// force drawing first tab
		oTab.layout._active(true);
	};

	// ********************************************
	// CALENDARSETTINGS

	this.maintab.calendar_settings._onactive = function (bFirstTime) {
		var oTab = this.maintab,
			forcedWeekBeginsOn = false;
		if (!bFirstTime){
            oTab.main._active(false);
			return;
		}

		oTab.main.week_begins._disabled(oTab.main.begin_on_today._value());
		oTab.main.begin_on_today._onchange = function () {
			oTab.main.week_begins._disabled(forcedWeekBeginsOn || oTab.main.begin_on_today._value());
		};

		// TAB1 - MAIN
		oTab.main._onactive = function (bFirstTime) {
			if (bFirstTime) {
				var that = this;
				// init
				this.week_begins._fillLang({
					'sunday': "DAYS::SUNDAY",
					'monday': "DAYS::MONDAY",
					'tuesday': "DAYS::TUESDAY",
					'wednesday': "DAYS::WEDNESDAY",
					'thursday': "DAYS::THURSDAY",
					'friday': "DAYS::FRIDAY",
					'saturday': "DAYS::SATURDAY"
				});

				this.week_begins._value('sunday');

				function dayBegins(aVaLue, bSkipOnchange) {
					if (aVaLue === void 0) {
						return +that.x_day_begins_hour._value() + that.x_day_begins_minute._value() / 4;
					}
					that.x_day_begins_hour._value(Math.floor(aVaLue), bSkipOnchange);
					that.x_day_begins_minute._value((aVaLue % 1) * 4, bSkipOnchange);
				}
				function dayEnds(aVaLue, bSkipOnchange) {
					if (aVaLue === void 0) {
						return +that.x_day_ends_hour._value() + that.x_day_ends_minute._value() / 4;
					}
					that.x_day_ends_hour._value(Math.floor(aVaLue), bSkipOnchange);
					that.x_day_ends_minute._value((aVaLue % 1) * 4, bSkipOnchange);
				}

				this.x_day_begins_hour._onchange = this.x_day_begins_minute._onchange = function (){
					if (dayBegins() > dayEnds())
						dayEnds(dayBegins(), true);

					that.day_begins._value(dayBegins(), true);
				};

				this.x_day_ends_hour._onchange = this.x_day_ends_minute._onchange = function (){
					if (dayBegins() > dayEnds())
						dayBegins(dayEnds(), true);

					that.day_ends._value(dayEnds(), true);
				};

				this.day_begins._onchange = function() {
					dayBegins(this._value(), true);
					that.x_day_begins_hour._disabled(this._disabled(), true);
					that.x_day_begins_minute._disabled(this._disabled(), true);
				}
				this.day_ends._onchange = function() {
					dayEnds(this._value(), true);
					that.x_day_ends_hour._disabled(this._disabled(), true);
					that.x_day_ends_minute._disabled(this._disabled(), true);
				}

				var hours = {};
				var minutes = {};
				for(var i = 0; i < 24; i++) {
					hours[i] = i;
				}
				for(i = 0; i < 4; i++) {
					minutes[i] = ('0' + i * 15).substr(-2);
				}
				this.x_day_begins_hour._fill(hours);
				this.x_day_ends_hour._fill(hours);
				this.x_day_begins_minute._fill(minutes);
				this.x_day_ends_minute._fill(minutes);

				// Handle work week logic
				this.week_numbers._fillLang({
					'0': "WEEK::LOCALE_SPECIFIC",
					'1': "WEEK::FIRST_DAY_OF_YEAR",
					'2': "WEEK::FIRST_FULL_WEEK",
					'3': "WEEK::FIRST_FOUR_DAY_WEEK"
				});

				// Handle work week logic
				this.workweek_begins._fillLang({
					'1': "DAYS::MONDAY",
					'2': "DAYS::TUESDAY",
					'3': "DAYS::WEDNESDAY",
					'4': "DAYS::THURSDAY",
					'5': "DAYS::FRIDAY",
					'6': "DAYS::SATURDAY",
					'7': "DAYS::SUNDAY"
				});
				this.workweek_begins._onchange = function (){
					var begin = parseInt(this._value());
					var end = oTab.main.workweek_ends;
					// Set week end to 5 days ahead by default
					if(end._value()==undefined)
						end._value((begin+=4) > 7 ? begin-7 : begin);
					// Work week can't start and end on same day
					else if(begin==end._value())
						end._value(begin==7?1:begin+1);
				}
				this.workweek_ends._fillLang({
					'1': "DAYS::MONDAY",
					'2': "DAYS::TUESDAY",
					'3': "DAYS::WEDNESDAY",
					'4': "DAYS::THURSDAY",
					'5': "DAYS::FRIDAY",
					'6': "DAYS::SATURDAY",
					'7': "DAYS::SUNDAY"
				});
				this.workweek_ends._onchange = function (){
					var begin = oTab.main.workweek_begins;
					var end = this._value();
					// Set week start to Monday by default
					if(begin._value()==undefined)
						begin._value('1');
					// Do not allow work week to be on same day
					if(begin._value()==end)
						begin._value(end==1?7:end-1);
				}

				// load data
				var aData = GWOthers.get('CALENDAR_SETTINGS', me._storage, true);
				if (aData) {
					loadDataIntoFormOnAccess(this, aData, me._bDomainadmin);
					dayBegins(this.day_begins._value());
					dayEnds(this.day_ends._value());
					if(!this.begin_on_today._disabled() && !this.begin_on_today._checked() && this.week_begins._disabled()) {
						forcedWeekBeginsOn = true;
					}
				}
			}
		}

		// TAB2 - DEFAULT SETTINGS
		oTab.default_settings._onactive = function (bFirstTime) {
			if (bFirstTime) {
				var aData = GWOthers.get('DEFAULT_CALENDAR_SETTINGS', me._storage, true);
				if (aData)
					loadDataIntoFormOnAccess(this, aData, me._bDomainadmin);
			}
		}

		// TAB3 - DEFAULT EVENT
		if (oTab.reminder)
			oTab.reminder._onactive = function (bFirstTime) {
				if (bFirstTime) {
                    this.event && (this.event._wasActivated = true);
					var aData = GWOthers.get('EVENT_SETTINGS',me._storage, true);
					if (typeof aData == 'object')
						loadDataIntoFormOnAccess(this.event, aData, me._bDomainadmin);
				}
			}

		// force drawing first tab
		oTab.main._active(true);
	};

	// ********************************************
	// DOMAINS
	if (this.maintab.domains_settings)
	this.maintab.domains_settings._onactive = function (bFirstTime) {
		if (!bFirstTime)
			return;

		// init
		this.x_adddomain._onclick = function(){
			var sDomain = (this._parent.x_domain._value() || '').trim();
			if (sDomain != ''){

				//domains are unigue
				var old = this._parent.domains._value();
				for(var i in old)
					if(old[i].domain == sDomain) return;

				this._parent.domains._add([{'domain':sDomain}]);
			}
		};

		this.x_remove._onclick = function(){
			this._parent.domains._removeSelected();
		};

		this.domains._ondblclick = function(){
			var aDomain = this._getSelectedValue();
			if (aDomain && aDomain.domain)
				gui._create('settings','frm_settings_admin','','',true,aDomain.domain);
		};

		this.x_editdomain._onclick = function(){
			var aDomain = this._parent.domains._getSelectedValue();
			if (aDomain && aDomain.domain)
				gui._create('settings','frm_settings_admin','','',true,aDomain.domain);
		};

		// load values into lister
		var aDomains = me._domains.get(me._storage,true);
		if (aDomains)
			this.domains._add(aDomains);

		// load values into select
		var i;
		aDomains = me._domains.get(me._storage);
		if (aDomains){
			var arr = [],arr2 = {};
			for(i in aDomains)
				if (aDomains[i].domain)
					arr.push(aDomains[i].domain.toString().trim());

			arr.sort();
			for(i in arr)
				arr2[arr[i]] = arr[i];

			this.x_domain._fill(arr2);
		}
	};

	// ********************************************
	// FINALIZATION

	// force drawing first tab
	this.maintab.mail_settings._active(true);
};

_me.__saveItems = function()
{
	if(!this.maintab) {
		return;
	}

	var me = this;
	var aValues = {}, aAccess;
	var oTab, i;

	function storeNonWellKnown(oForm, sResource) {
		var aValues = {},
			aAccess = {};
		if (oForm && oForm._wasActivated) {
			storeDataFromFormWithAccess(oForm, aValues, aAccess);
			GWOthers.set(sResource, aValues, me._storage, aAccess);
		}
	};

	// ********************************************
	// MAILSETTINGS
	if (this.maintab.mail_settings && this.maintab.mail_settings._wasActivated) {
		oTab = this.maintab.mail_settings.maintab;

		storeNonWellKnown(oTab.mail_default, 'MAIL_SETTINGS_DEFAULT');

		// General
		if (oTab.general && oTab.general._wasActivated){
			aValues = {},aAccess = {};
			storeDataFromFormWithAccess(oTab.general, aValues, aAccess);

			if (aAccess.DOMAINADMINACCESS){
				aAccess.DOMAINADMINACCESS.autoupdate_minutes = aAccess.DOMAINADMINACCESS.autoupdate;
				aAccess.DOMAINADMINACCESS.autosave_minutes = aAccess.DOMAINADMINACCESS.autosave;
				aAccess.DOMAINADMINACCESS.autoclear_trash_days = aAccess.DOMAINADMINACCESS.autoclear_trash;
			}
			if (aAccess.USERACCESS){
				aAccess.USERACCESS.autoupdate_minutes = aAccess.USERACCESS.autoupdate;
				aAccess.USERACCESS.autosave_minutes = aAccess.USERACCESS.autosave;
				aAccess.USERACCESS.autoclear_trash_days = aAccess.USERACCESS.autoclear_trash;
			}

			GWOthers.set('MAIL_SETTINGS_GENERAL', aValues, this._storage, aAccess);
		}

		// Groups
		var out;
		if (oTab.groups && oTab.groups._wasActivated) {

			out = [];
			var v = oTab.groups.groups._aData;
			if (count(v)>0)
				for(i in v)
					if (v[i].arg)
						out.push({
							ATTRIBUTES:{ACCESS:'full',DONT_SEND:false},
							VALUES:{
								GROUP:{ATTRIBUTES:{USERACCESS:'view'},VALUE:v[i].arg.group},
								SENTFOLDER:{ATTRIBUTES:{USERACCESS:'view'}, VALUE: Path.split(v[i].arg.folder)[1]/*.split('~')[1]*/ || ''}
							}
						});

			dataSet.add(me._storage,['GROUPS','ITEMS'],out,1);
			dataSet.add(me._storage,['GROUPS','ATTRIBUTES','DONT_SEND'],false,1);

		}

		// Signature
		if (oTab.signature && oTab.signature._wasActivated) {
			aValues = {},aAccess = {};
			storeDataFromFormWithAccess(oTab.signature, aValues, aAccess);

			out = [{
				ATTRIBUTES:{
					DONT_SEND:false
				},
				VALUES:{
					TEXT:{ATTRIBUTES:{USERACCESS:aAccess.USERACCESS.text},VALUE:aValues.text}
				}
			}];

			if (aAccess.DOMAINADMINACCESS)
				out[0].VALUES.TEXT.ATTRIBUTES.DOMAINADMINACCESS = aAccess.DOMAINADMINACCESS.text;

			dataSet.add(me._storage,['SIGNATURE','ITEMS'],out,1);
			dataSet.add(me._storage,['SIGNATURE','ATTRIBUTES','DONT_SEND'],false,1);
		}
	}
	// ********************************************

	// CHAT SETTINGS
	if (this.maintab.chat_settings && this.maintab.chat_settings._wasActivated) {
		oTab = this.maintab.chat_settings.maintab;
		storeNonWellKnown(oTab.input, 'CHAT');
		storeNonWellKnown(oTab.im, 'IM');

		if(oTab.teamchat_notifications && oTab.teamchat_notifications._wasActivated) {
			aValues = {};
			var bValues = {};
			aAccess = {};
			var bAccess = {};
			storeDataFromFormWithAccess(oTab.teamchat_notifications, aValues, aAccess);
			for(i in aValues) {
				if(i === 'teamchat_notify') {
					bValues[i] = aValues[i];
					delete(aValues[i]);
				}
			}
			for(i in aAccess.DOMAINADMINACCESS || {}) {
				if(i === 'teamchat_notify') {
					bAccess.DOMAINADMINACCESS = bAccess.DOMAINADMINACCESS || {};
					bAccess.DOMAINADMINACCESS[i] = aAccess.DOMAINADMINACCESS[i];
					delete(aAccess[i]);
				}
			}
			for(i in aAccess.USERACCESS || {}) {
				if(i === 'teamchat_notify') {
					bAccess.USERACCESS = bAccess.USERACCESS || {};
					bAccess.USERACCESS[i] = aAccess.USERACCESS[i];
					delete(aAccess[i]);
				}
			}
			GWOthers.set('CHAT', aValues, me._storage, aAccess);
			GWOthers.set('GLOBAL_SETTINGS', bValues, me._storage, bAccess);
		}
	}

	// GENERALSETTINGS
	if (this.maintab.general_settings && this.maintab.general_settings._wasActivated) {
		oTab = this.maintab.general_settings.maintab;

		//Layout settings
		if (oTab.layout && oTab.layout._wasActivated) {
/*
			var aValues = {},aAccess = {};
			storeDataFromFormWithAccess(oTab.layout, aValues, aAccess);

			aAccess.USERACCESS.interfaces = oTab.layout.x_interfaces_set.user._value()?'view':'full';
			if (aAccess.DOMAINADMINACCESS)
				aAccess.DOMAINADMINACCESS.interfaces = oTab.layout.x_interfaces_set.domadmin._value()?'view':'full';

			aValues.interfaces = (oTab.layout.x_pro._value()?'a':'') + (oTab.layout.x_basic._value()?'b':'') + (oTab.layout.x_pda._value()?'p':'');

			GWOthers.set('LAYOUT_SETTINGS', aValues, this._storage, aAccess);
*/

			aValues = {};
			aAccess = { USERACCESS: {} };

			if (!this._bDomainadmin)
				aAccess.DOMAINADMINACCESS = {}

			GWOthers.set('LAYOUT_SETTINGS', aValues, this._storage, aAccess);

			storeNonWellKnown(oTab.layout, 'LAYOUT_SETTINGS');
		}


		if (oTab.documents && oTab.documents._wasActivated) {
			storeNonWellKnown(oTab.documents, 'DOCUMENTS');
		}

		if (oTab.login && oTab.login._wasActivated) {

			aValues = {},
			aAccess = {USERACCESS:{}};

			if (!this._bDomainadmin)
				aAccess.DOMAINADMINACCESS = {};

			['facebook_link', 'twitter_link', 'linkedin_link', 'require_2fa', 'disable_languages', 'disable_signup', 'disable_remember', 'disable_autofill', 'contact_support', 'facebook_disabled', 'twitter_disabled', 'linkedin_disabled'].forEach(function(input) {
				aValues[input] = (oTab.login[input] || oTab.login['x_' + input])._value();
				aAccess.USERACCESS[input] = oTab.login['x_' + input + '_set'].user._value() ? 'view' : 'full';
				if (!this._bDomainadmin) {
					aAccess.DOMAINADMINACCESS[input] = oTab.login['x_' + input + '_set'].domadmin._value() ? 'view' : 'full';
				}
			}, this);

			//Store Layout part
			GWOthers.set('LAYOUT_SETTINGS', aValues, this._storage, aAccess);

			//Store restriction part
			storeNonWellKnown(oTab.login, 'RESTRICTIONS');

			// Store reset password
			if (oTab.login.enabled) {
				GWOthers.set('RESET_SETTINGS', {
					enabled: oTab.login.enabled._value(),
					sms: oTab.login.sms._value(),
				}, this._storage);
			}
		}

		if (oTab.server && oTab.server._wasActivated)
			storeNonWellKnown(oTab.server, 'GLOBAL_SETTINGS');

		if (oTab.restrictions && oTab.restrictions._wasActivated){
			aValues = {},
			aAccess = {};

			storeDataFromFormWithAccess(oTab.restrictions, aValues, aAccess);

			//DISABLE_GW_TYPES
			if (aAccess.DOMAINADMINACCESS)
				aAccess.DOMAINADMINACCESS.disable_gw_types = oTab.restrictions.x_disable_gw_types_set.domadmin._value()?'view':'full';

			aAccess.USERACCESS.disable_gw_types = oTab.restrictions.x_disable_gw_types_set.user._value()?'view':'full';
			aValues.disable_gw_types = ['c', 'e', 'n', 't', 'r', 'f', 'q'].filter(function(sType) {
				return oTab.restrictions['x_' + sType]._value();
			}).join('');

			GWOthers.set('RESTRICTIONS', aValues, this._storage, aAccess);
		}

		if (oTab.dropbox && oTab.dropbox._wasActivated)
			storeNonWellKnown(oTab.dropbox, 'EXTERNAL_SETTINGS');

	}
	// ********************************************

	// CALENDARSETTINGS
	if (this.maintab.calendar_settings && this.maintab.calendar_settings._wasActivated) {
		oTab = this.maintab.calendar_settings.maintab;

		// Store general calendar settnigs
		aValues = {},
		aAccess = {};
		storeDataFromFormWithAccess(oTab.main, aValues, aAccess);
		if (aAccess.DOMAINADMINACCESS){
			aAccess.DOMAINADMINACCESS.autoclear_trash_days = aAccess.DOMAINADMINACCESS.autoclear_trash;
		}
		if (aAccess.USERACCESS){
			aAccess.USERACCESS.autoclear_trash_days = aAccess.USERACCESS.autoclear_trash;
		}
		GWOthers.set('CALENDAR_SETTINGS', aValues, this._storage, aAccess);

		// Store default calendar settings
		storeNonWellKnown(oTab.default_settings, 'DEFAULT_CALENDAR_SETTINGS');

		// Store reminder settings
		if (oTab.reminder && oTab.reminder._wasActivated)
			storeNonWellKnown(oTab.reminder.event, 'EVENT_SETTINGS');

	}
	// ********************************************

	// DOMAINSSETTINGS
	if (this.maintab.domains_settings && this.maintab.domains_settings._wasActivated) {
		oTab = this.maintab.domains_settings;
		aValues = {};

		storeDataFromForm(oTab,aValues);
		me._domains.set(aValues.domains,this._storage);
	}

	//Záloha stávajícího storage
	dataSet.add('tmp_storage','',dataSet.get(this._storage));

	var nOK;
	//Hromadné posílání povolených změn na server
	if (this._bDomainadmin && this._domain)
		nOK = WMStorage.set({'xmlns':this._xmlns,'domain':this._domain,'resources':dataSet.get(this._storage)},this._storage,'',[this,'__saveItemsHandler']);
	else
		nOK = WMStorage.set({'xmlns':this._xmlns,'resources':dataSet.get(this._storage)},this._storage,'',[this,'__saveItemsHandler']);

	//Na server se nic neposílá?
	if (nOK == 2) {
		dataSet.remove('tmp_storage');
		this._destruct();
	}
	else
		this._main.style.display = "none";
};

_me.__saveItemsHandler = function(bOK)
{
	//Přijal server náš dotaz?
	if (bOK){
		dataSet.remove('tmp_storage');

		// Switch skin style
		try{
			//set font variant
			var font = GWOthers.getItem('LAYOUT_SETTINGS', 'font_weight');
			if (font == 'auto')
				font = gui.__BROWSER.retina?'light':'normal';

			if (font == 'light')
				addcss(document.body,'light');
			else
				removecss(document.body,'light');

			var night_mode_enabled = dataSet.get('main', ['night_mode_enabled']);
			if (this.maintab.general_settings._wasActivated && this.maintab.general_settings.maintab.layout.x_night_mode_set.user._checked()) {
				night_mode_enabled = this.maintab.general_settings.maintab.layout.night_mode._value() == 1;
				if (this.maintab.general_settings.maintab.layout.night_mode._value() == 2 && window.matchMedia && window.matchMedia('(prefers-color-scheme)').matches) {
					night_mode_enabled = window.matchMedia('(prefers-color-scheme: dark)').matches;
				}
				dataSet.add('main', ['night_mode_enabled'], night_mode_enabled);
			}

			//set skin
			if (this.__skin != GWOthers.getItem('LAYOUT_SETTINGS','skin')) {
				NightMode().reset(function() {
					storage.css('style', true, function() {
						if (night_mode_enabled) {
							NightMode().activate();
						}
					});
				});
			} else if (night_mode_enabled) {
				NightMode().activate();
			} else {
				NightMode().reset();
			}
		}
		catch(r){ console.log(this._name||false,r)}

		this._destruct();
	}
	else{
		dataSet.add(this._storage,'',dataSet.get('tmp_storage'));
		dataSet.remove('tmp_storage');
		this._main.style.display = "block";
	}
};
