_me = frm_reactions.prototype;
function frm_reactions(){}

/**
 *
 */
_me.__constructor = async function(aData, sInitTab) {
	//var me = this;

	this._size(450,400,true);
	this._modal(true);
	this._dockable(false);

	this._title('CHAT::REACTIONS');

	this.__reactions = {};
	this.__start = sInitTab;

	await this._create('tabs','obj_tabs','main','ico small nobuttons transparent');

	//Reactions
	if (aData.REACTIONS)
		this._fill(aData.REACTIONS);
	else{
		await this._create('loading', 'obj_loader');

		var iid = aData.iid;
		//if (aData.EVNCLASS != 'I' && aData.EVNCLASS != 'W' && aData.EVNCLASS != 'S')
		if (aData.EVNLINKTYPE == '10')
			iid = aData.EVNLINKID?WMItems.__clientID(aData.EVNLINKID):aData.iid;

		//GET
		var aItemsInfo = {aid:aData.aid, fid:aData.fid, iid:iid, values:['REACTIONS']};

		WMItems.list(aItemsInfo,'','','',[function(aResponse){
			if (aResponse && (aResponse = aResponse[aData.aid]) && (aResponse = aResponse[aData.fid]) && (aResponse = aResponse[iid])){
				aData.REACTIONS = aResponse.REACTIONS;
				this._fill(aData.REACTIONS);
			}
			//Error
			else
				this._destruct();

		}.bind(this)]);

	}

	// Create 'OK' button
	await this._create('x_btn_ok', 'obj_button', 'footer', 'color1');
	this.x_btn_ok._value('FORM_BUTTONS::OK');
	this.x_btn_ok._onclick = function() {
		this._destruct();
	}.bind(this);

	this.x_btn_ok._focus();
};

_me._fill = async function(aData){
	if (this.loading)
		this.loading._destruct();

	var ar = {'*':{}};
	for (var id in aData)
		if (aData[id] && aData[id].values){

			if (!ar[aData[id].values.REAVALUE])
				ar[aData[id].values.REAVALUE] = {};

			ar[aData[id].values.REAVALUE][id] = aData[id].values;
			ar['*'][id] = aData[id].values;
		}

	this.__reactions = ar;

	for (var sName in ar){
		var tab = await this.tabs._create('tab','obj_tab','main', (sName == '*'?'all':'ico ico_'+sName.replace(/\s+/g,'_')));
		tab.__reaction = sName;
		tab.__eLi.setAttribute('iw-reaction', sName);

		if (sName == '*'){
			tab._value(getLang('COMMON::ALL') +' '+ count(aData), true);
			this._fill_list(tab);
		}
		else
			tab._value(count(ar[sName]), true);

		tab._onactive = function(bFirstTime){
			if (bFirstTime){
				this._parent._parent._fill_list(this);
			}
		};

		if (this.__start == sName)
			tab._active();
	}
};

_me._fill_list = async function(tab){
	if (tab) {
		if (!tab.list) {
			await tab._create('list', 'obj_list');
		}

		var arr = this.__reactions[tab.__reaction || '*'] || {},
			aData = [];

		for (var id in arr) {
			aData.push(arr[id]);
		}

		aData = aData.sort(function(a, b) {
			return (a.REAOWNNAME || a.REAOWNEMAIL || '').localeCompare(b.REAOWNNAME || b.REAOWNEMAIL || '');
		}).map(function(v) {
			var elm = mkElement('div');

			elm.appendChild(obj_avatar.getAvatarElement({
				email: v.REAOWNEMAIL,
				name: v.REAOWNNAME || v.REAOWNEMAIL,
				size: 32
			}));
			elm.appendChild(mkElement('span', {
				className: 'label',
				innerHTML: v.REAOWNNAME.entityify()
			}));

			return {
				html: elm.innerHTML
			};
		});

		tab.list._fill(aData);
	}
};
