_me = frm_quick_select_folder.prototype;
function frm_quick_select_folder(){};

/**
 * @see  inc/frm_select_folder.js
 */
_me.__constructor = async function(sMainLabel, sAccountID, sFolderID, aResponse, bDisableAccounts, bOneAccount, sFilterType, sFilterRights, bDisableNewButton, sFilterRightsOr, bFilterPublic, bForceShowFolderIcons){

	this._modal(true);
	this._resizable(false);

	var me = this,
		sFullFolderPath = '',
		aFilterType = Array.isArray(sFilterType) ? sFilterType : (sFilterType || '').split(',').filter(Boolean),
		bAlfresco = ~aFilterType.indexOf('K');

	this.__aResponse = aResponse;

	if (sMainLabel)
		this._title(sMainLabel);

	// Create formular from template
	if (bAlfresco){
		await this._create('tree_folder','obj_tree_folder','main','alfresco_folder noroot scroll', '@@alfresco@@');
		this.tree_folder._listen_data('alfresco');
		this.tree_folder._onclick = function(e, elm, id){
			var aPath = Path.split(id, true);
			Alfresco.getFolderInfo(aPath.fid, [function(bOK, aFolder){
				if (bOK)
					Alfresco.setLastFolder(aFolder.fid);
			}], true);
		}.bind(this);
	}
	else{
		await this._create('tree_folder','obj_tree_folder2', 'main', bForceShowFolderIcons ? 'icons' : '', sAccountID && bOneAccount ? sAccountID : void 0);
	}

	this.tree_folder.__filter_show_subfolders = false;

	if (sAccountID)
	{
		if (sAccountID == sPrimaryAccount &&  sFolderID == '__@@VIRTUAL@@__/__@@EVENTS@@__')
			sFolderID = Mapping.getDefaultFolderForGWType('E');

		// Set type of the items to be filetered
		if (bOneAccount)
			this.tree_folder.sFilterAccountId = sAccountID;
	}

	if (bFilterPublic)
		this.tree_folder._filter_public(true);

	if (sFilterRights)
		this.tree_folder._filter_rights(sFilterRights);

	if (sFilterRightsOr)
		this.tree_folder._filter_rights_or(sFilterRightsOr);

	if (sFolderID)
		sFullFolderPath = sAccountID + '/' + sFolderID;
	else
	if (bAlfresco)
		sFullFolderPath = Alfresco.getLastFolder(true);
	else {
		sFullFolderPath = (aFilterType.map(function(ft) {
			return Cookie.get(['last_used_folder', ft]);
		}).filter(function(fp) {
			return !!fp;
		}) || [])[0] || sAccountID;
	}

	if (bAlfresco){
		Alfresco.getFolderInfo();

		if (sFullFolderPath){
			var aPath = Path.split(sFullFolderPath,true);
			if (aPath.fid){
				Alfresco.getFolderInfo(aPath.fid, [function(bOK, aFolder){
					if (bOK && aFolder.fid.length){
						me.tree_folder._setActive(Path.build(aFolder));
					}
				}]);
			}
		}

		var alfresco_search;
		this.tree_folder._onsearch = function(filter) {
			clearTimeout(alfresco_search);
			alfresco_search = setTimeout(me.__alfrescoSearch.bind(me, filter), 150);
		};
	}
	else{
		if (aFilterType.length)
			this.tree_folder._filter_folder(aFilterType);

		await this.tree_folder._setActive(sFullFolderPath);
		this.tree_folder._listen_cookie('select_folder_tree');
	}

	// Redraw the folder tree
	if ((sAccountID && bOneAccount) || aFilterType.length){
		this.tree_folder._fill();
	}

	if (sFullFolderPath){
		this.tree_folder._open(sFullFolderPath, 'minus');
	}
	else{
		var ds = dataSet.get('folders');
		for(sFullFolderPath in ds)
			this.tree_folder._open(sFullFolderPath,'minus');
	}

	await this._create('filter', 'obj_input', 'main', 'obj_input_100 ico ico_folder filter');
	this.filter._onkeyup = function(e) {
		if (e.key === 'Enter') {
			return;
		}
		this.tree_folder.inp_search._value(this.filter._value());
		this.tree_folder.inp_search._onkeyup(e);
	}.bind(this);
	var active;
	this.filter._onkeydown = function(e) {
		switch(e.key) {
			case 'ArrowDown':
				active && active.classList.remove('active');
				if ((active = (active && active.nextElementSibling) || results.firstElementChild)) {
					active.classList.add('active');
				}
				e.preventDefault();
				break;
			case 'ArrowUp':
				active && active.classList.remove('active');
				if ((active = (active && active.previousElementSibling) || results.lastElementChild)) {
					active.classList.add('active');
				}
				e.preventDefault();
				break;
			case 'Enter':
				active && this.__selectFolder(active.getAttribute('data-id'));
		}
	}.bind(this);
	this.filter._placeholder(getLang('POPUP_FOLDERS::TYPE_FOLDER_NAME'));

	var args = [].slice.call(arguments);
	this.filter.__setMask({
		foldertree: ['', getLang('POPUP_FOLDERS::SELECT_FOLDER')]
	}, [function () {
		var popup = gui._create.apply(gui, ['selectFolder', 'frm_select_folder', '', ''].concat(args));
		popup.__selectFolder = me.__selectFolder;
		me._destruct();
	}]);
	this.filter.__showMaskHelper = function() {};
	this.filter.__showMask();

	var title = mkElement('div', {
		className: 'title',
		textContent: getLang('SEARCH::RECENT')
	});
	this._getAnchor('main').appendChild(title);

	var results = mkElement('div', {
		className: 'results'
	});
	this._getAnchor('main').appendChild(results);

	this.tree_folder._onfill = function(aFolders) {
		title.style.display = 'block';
		results.style.display = 'block';

		if (!this.filter) {
			return;
		}
		var filter = this.filter._value();
		if (filter) {
			title.textContent = getLang('SEARCH::RESULTS');

			aFolders = aFolders.filter(function(folder) {
				var data = dataSet.get('folders', Path.split(folder));
				return data && (!bDisableAccounts || data.TYPE !== 'X') && ~(data.NAME || folder).toLowerCase().indexOf(filter.toLowerCase());
			});
		} else {
			title.textContent = getLang('SEARCH::RECENT');

			var last_used_folders = Cookie.get(['last_used_folders']) || [];
			last_used_folders = last_used_folders.filter(function(folder) {
				return ~aFolders.indexOf(folder);
			});
			aFolders = last_used_folders;
		}

		if (!aFolders.length) {
			title.style.display = 'none';
			results.style.display = 'none';
		}

		while(results.firstChild) {
			results.removeChild(results.lastChild);
		}

		aFolders = aFolders.forEach(function(folder) {
			var aPath = Path.split(folder, true);
			results.appendChild(mkElement('div', {
				class: 'result',
				textContent: WMFolders.getFolderPath(aPath),
				'data-id': folder,
				onclick: this.__selectFolder.bind(this, folder)
			}));
		}, this);
		(active = results.firstElementChild) && results.firstElementChild.classList.add('active');
	}.bind(this);
	this.tree_folder._onfill(Object.keys(this.tree_folder.__idTableReal));

	this._size(640,'auto',true);

	this.filter._focus(true);
};

_me.__selectFolder = function(folder) {
	var path = Path.split(folder)

	executeCallbackFunction(this.__aResponse, path[0], path[1]);
	var last_used_folders = Cookie.get(['last_used_folders']) || [];
	last_used_folders.unshift(folder);
	last_used_folders = last_used_folders.filter(function(v, i, a) {
		return a.indexOf(v) === i;
	});
	Cookie.set(['last_used_folders'], last_used_folders);
	this._destruct();
};

_me.__alfrescoSearch = function(filter) {
	WMFolders.list({
		aid: '@@alfresco@@',
		search: filter
	},'','', [function(aData) {
		for(var i in aData['@@alfresco@@']) {
			dataSet.add('alfresco', ['@@alfresco@@', i.replace('/Company Home/', '')], aData['@@alfresco@@'][i]);
		}
		this.tree_folder._fill(dataSet.get('alfresco'));
	}.bind(this)]);
};
