_me = frm_print.prototype;
function frm_print(){};

_me.__constructor = async function(){

	this.__template = new cTemplate();
	this.__template.strict = false;

	var me = this;
	this._title('PRINT::PREVIEW');
	this._defaultSize(450,500, {
		goldenRatio: true
	});

	await this._create("frame","obj_frame","main");

	this.__data	= {};
	this.__libs = 0;

	setTimeout(function() {
		var doc = this.__getDoc();
		AttachEvent(doc, "onclick", function(e){
			if (e.target.tagName == 'SPAN' && e.target.id && hascss(e.target,'btnx')){
				var id = e.target.id.substr(me._pathName.length+1).split('/');
				if (me.__data[id[0]])
					for(var i = me.__data[id[0]].length-1; i>=0; i--)
						if (me.__data[id[0]][i].id == id[1]){

							me.__data[id[0]].splice(i,1);
							me._fill(id[0]);

							break;
						}
			}

		});


		var link = mkElement('link','',doc);
		link.setAttribute("type","text/css");
		link.setAttribute("rel","stylesheet");
		link.setAttribute("href","client/skins/default/css/frm_print_all.css");
		link.onload = function(){me.__load()};
		doc.head.appendChild(link);

		link = mkElement('link','',doc);
		link.setAttribute("type","text/css");
		link.setAttribute("rel","stylesheet");
		link.setAttribute("media","print");
		link.setAttribute("href","client/skins/default/css/frm_print_print.css");
		link.onload = function(){me.__load()};
		doc.head.appendChild(link);

		link = null;
		while(doc.body.firstChild) {
			doc.body.removeChild(doc.body.lastChild);
		}
	}.bind(this), 50);

	// Create 'OK' button
	await this._create('x_btn_ok', 'obj_button', 'footer','ok noborder color1');
	this.x_btn_ok._value('MAIN_MENU::PRINT');
	this.x_btn_ok._onclick = function() {
		me.frame._print();
	};

	// Create 'CANCEL' button
	await this._create('x_btn_cancel', 'obj_button', 'footer', 'cancel noborder simple');
	this.x_btn_cancel._value('FORM_BUTTONS::CANCEL');
	this.x_btn_cancel._onclick = function() { me._destruct() };
};

_me.__getDoc = function() {
	return this.frame.__eFrame.contentDocument || this.frame.__eFrame.contentWindow.document;
};

_me._add = function (sType, aData) {

	setTimeout(async function() {
		if (sType){

			this.__data[sType] = this.__data[sType] || [];
			// Save data
			if (Is.Array(aData)){
				for(var i in aData) {
					aData[i] = clone(aData[i], true);
					['EVNNOTE', 'NOTE_TEXT', 'NOTE', 'ITMDESCRIPTION'].forEach(function(col) {
						if (aData[i][col]) {
							aData[i][col] = DOMPurify.sanitize(aData[i][col]);
						}
					});

					aData[i] = this.__parse(sType, aData[i]);
					this.__data[sType].push({id:unique_id(), data:aData[i], out: await this.__template.tmp('print_' + sType.toLowerCase(), aData[i])});
				}
			} else {
				aData[i] = clone(aData, true);
				['EVNNOTE', 'NOTE_TEXT', 'NOTE', 'ITMDESCRIPTION'].forEach(function(col) {
					if (aData[col]) {
						aData[col] = DOMPurify.sanitize(aData[col]);
					}
				});

				aData = this.__parse(sType, aData);
				this.__data[sType].push({id:unique_id(), data:aData, out: await this.__template.tmp('print_' + sType.toLowerCase(), aData)});
			}

			this._fill(sType);
		}
	}.bind(this), 50);
};

_me._fill = function(sType){

	if (sType){
		var elm = this.__getDoc().getElementById(sType);

		if (Is.Empty(this.__data[sType])){
			if (elm)
				elm.parentNode.removeChild(elm);
			delete this.__data[sType];
			return;
		}

		var html = '', i;

		// Sort
		switch(sType){
		case 'C':
			this.__data[sType].sort(function(a,b){
				if (a.data.ITMSURNAME>b.data.ITMSURNAME)
					return 1;
				else
				if (a.data.ITMSURNAME<b.data.ITMSURNAME)
					return -1;
				else
				if (a.data.ITMCLASSIFYAS>b.data.ITMCLASSIFYAS)
					return 1;
				else
				if (a.data.ITMCLASSIFYAS<b.data.ITMCLASSIFYAS)
					return -1;
				else
					return 0;
			});

			var last, s;
			for (i in this.__data[sType]){
				s = (this.__data[sType][i].data.ITMSURNAME || this.__data[sType][i].data.ITMCLASSIFYAS || '').trim().charAt(0).toUpperCase();

				html += '<div class="card">';

				if (last != s){
					last = s;
					html += '<div class="char">'+ (last || '...') +'</div>';
				}

				html += '<span class="btnx" id="'+this._pathName+'/'+sType+'/'+this.__data[sType][i].id+'"></span>' + this.__data[sType][i].out + '</div>';

			}

			break;

		default:
				// Refresh
			for (i in this.__data[sType])
				html += '<div class="card"><span class="btnx" id="'+this._pathName+'/'+sType+'/'+this.__data[sType][i].id+'"></span>' + this.__data[sType][i].out + '</div>';
		}

		if (!elm){
			elm = mkElement('div', {id:sType}, this.__getDoc());
			this.__getDoc().body.appendChild(elm);
		}

		elm.innerHTML = html;
	}

	this._focus();
};

_me.__parse = function(sType,aData){
	switch (sType) {
	case 'T':
		if (aData.EVNENDDATE) {
			aData.evnenddate = IcewarpDate.julian(aData.EVNENDDATE).format('L');
		}
		if (aData.EVNSTARTDATE) {
			aData.evnstartdate = IcewarpDate.julian(aData.EVNSTARTDATE).format('L');
		}
		if (aData.EVNSTATUS) {
			aData.evnstatus = getLang({I: 'TASK::IN_PROGRESS', N: 'TASK::WAITING', B: 'TASK::NOT_STARTED', M: 'TASK::COMPLETED', Q: 'TASK::DEFERRED'}[aData.EVNSTATUS]);
			switch (aData.EVNSTATUS) {
			case 'I':
			case 'Q':
			case 'N':
				if (aData.EVNCOMPLETE * 1 > 0) {
					aData.evncomplete = (aData.EVNCOMPLETE * 1) + '%';
				}
			}
		}
		break;

	case 'C':
		if (aData.ITMBDATE){
			if (+aData.ITMBDATE)
				aData.ITMBDATE = IcewarpDate.julian(aData.ITMBDATE).format('L');
			else
				delete aData.ITMBDATE;
		}

		if (aData.ITMGENDER){
			switch(aData.ITMGENDER){
				case '1':
					aData.ITMGENDER = getLang('CONTACT::MALE');
					break;
				case '2':
					aData.ITMGENDER = getLang('CONTACT::FEMALE');
					break;
				default:
					delete aData.ITMGENDER;
			}
		}
	}
	return aData;
};
_me.__load = async function(){
	this.__libs++;
	if (this.__libs == 2 && dataSet.get('main', ['night_mode_enabled'])) {
		await storage.library('night_mode');
		NightMode(this.frame.__eFrame.contentWindow).activate();
	}
};
