_me = frm_pdf.prototype;

function frm_pdf() {};

/**
 * License
 */
_me.__constructor = async function () {
	this._defaultSize(900, 620, {
		goldenRatio: true
	});
	this._detachable(true);
	this._title('ATTACHMENT::PDF');

	await this._create('frame', 'obj_frame');

	this._messageHandler = this.__messageHandler.bind(this);
	window.addEventListener('message', this._messageHandler, false);
	this._add_destructor('__onDestruct');
};

_me.__messageHandler = function (event) {
	var data;

	if(event.source !== this.frame.__eFrame.contentWindow) {
		return;
	}

	try {
		data = JSON.parse(event.data);
	} catch {
		//
	}

	if (data && data.event === 'pdfjs' && data.error) {
		this._destruct();
		gui.notifier._value({
			type: 'alert',
			args: {
				header: 'ALERTS::PDFJS',
				text: 'alerts::pdfjs_' + data.error.code
			}
		});
	}
}

_me.__onDestruct = function () {
	window.removeEventListener('message', this._messageHandler);
};

_me._load = function (url, sTitle, previewURL, bSkipPostMessage) {
	if (!url) {
		return;
	}

	if (url.match(/^blob:/)) {
		bSkipPostMessage = true;
	}

	!bSkipPostMessage && gui.__exeEvent('previewItem', {
		filename: sTitle,
		url: url,
		previewURL: previewURL
	});

	if (sTitle) {
		this._title(sTitle, true);
	}

	if (Item.pdfSupport()) {
		if (!url.match(/^blob:/)) {
			url = url.replace(/\/files.download\?/, '/' + sTitle + '?') + '&override_method=files.download';
			url += (~url.indexOf('?') ? '&' : '?') + 'disposition=inline';
		}
	
		return this.frame._src(url);
	}

	if (url.indexOf('http') != 0)
		url = '../../../../' + url;

	this.frame._src('client/inc/pdfjs/web/viewer.html?' + buildURL({
		file: url,
		lang: GWOthers.getItem('LAYOUT_SETTINGS', 'language')
	}));
};
