_me = frm_new_item.prototype;
function frm_new_item() { };

_me.__constructor = async function () {
	var me = this;
	await this._draw('frm_new_item', '', frm_new_item.__oOpt);

	this._getAnchor('mail').onclick = function() {
		me._destruct();
		frm_new_item.__newMail();
	};

	if (this._getAnchor('sms')) {
		this._getAnchor('sms').onclick = function () {
			me._destruct();
			frm_new_item.__newSMS();
		};
	}

	this._getAnchor('template').onclick = function () {
		me._destruct();
		frm_new_item.__newTemplate()
	};

	if (this._getAnchor('conference')) {
		this._getAnchor('conference').onclick = function () {
			me._destruct();
			frm_new_item.__newConference();
		};
	}

	if (this._getAnchor('event')) {
		this._getAnchor('event').onclick = function () {
			me._destruct();
			frm_new_item.__newEvent();
		};
	}

	if (this._getAnchor('note')) {
		this._getAnchor('note').onclick = function () {
			me._destruct();
			frm_new_item.__newNote();
		};
	}

	if (this._getAnchor('word')) {
		this._getAnchor('word').onclick = function () {
			me._destruct();
			frm_new_item.__newWord();
		};
	}

	if (this._getAnchor('excel')) {
		this._getAnchor('excel').onclick = function () {
			me._destruct();
			frm_new_item.__newExcel();
		};
	}

	if (this._getAnchor('powerpoint')) {
		this._getAnchor('powerpoint').onclick = function () {
			me._destruct();
			frm_new_item.__newPowerpoint();
		};
	}

	if (this._getAnchor('contact')) {
		this._getAnchor('contact').onclick = function () {
			me._destruct();
			frm_new_item.__newContact();
		};
	}

	if (this._getAnchor('distribution_list')) {
		this._getAnchor('distribution_list').onclick = function () {
			me._destruct();
			frm_new_item.__newDistributionList();
		};
	}

	if (this._getAnchor('task')) {
		this._getAnchor('task').onclick = function () {
			me._destruct();
			frm_new_item.__newTask();
		};
	}

	if (this._getAnchor('room')) {
		this._getAnchor('room').onclick = function () {
			me._destruct();
			frm_new_item.__newRoom();
		};
	}
};

frm_new_item.__newMail = function() {
	NewMessage.compose({
		alias: Item.getAliasFromPath(dataSet.get('active_folder'))
	});
};

frm_new_item.__newSMS = function() {
	if (!frm_new_item.__oOpt.sms) {
		return;
	}
	NewMessage.compose({
		sms: true
	});
};

frm_new_item.__newTemplate = function() {
	NewMessage.compose({
		template: true
	});
};

frm_new_item.__newConference = async function() {
	if (!frm_new_item.__oOpt.conference) {
		return;
	}
	await storage.library('wm_conference');
	wm_conference.create(function (conference) {
		conference.join();
	}, {
		subject: 'Conference'
	});
};

frm_new_item.__newEvent = function() {
	if (!frm_new_item.__oOpt.event) {
		return;
	}
	if (~['frm_main_calendar_dayweek', 'frm_main_calendar_month'].indexOf((gui.frm_main.main || {})._type)) {
		gui.frm_main.main._createEvent();
	} else {
		Item.create('E');
	}
};

frm_new_item.__newNote = function() {
	if (!frm_new_item.__oOpt.note) {
		return;
	}
	Item.create('N');
};

frm_new_item.__newWord = function() {
	if (!frm_new_item.__oOpt.document) {
		return;
	}
	Item.create('F', {
		docType: '.docx',
		useCurrentActiveFolder: false
	});
};

frm_new_item.__newExcel = function() {
	if (!frm_new_item.__oOpt.document) {
		return;
	}
	Item.create('F', {
		docType: '.xlsx',
		useCurrentActiveFolder: false
	});
};

frm_new_item.__newPowerpoint = function() {
	if (!frm_new_item.__oOpt.document) {
		return;
	}
	Item.create('F', {
		docType: '.pptx',
		useCurrentActiveFolder: false
	});
};

frm_new_item.__newContact = function() {
	if (!frm_new_item.__oOpt.contact) {
		return;
	}
	Item.create('C');
};

frm_new_item.__newDistributionList = function() {
	if (!frm_new_item.__oOpt.contact) {
		return;
	}
	Item.create('L');
};

frm_new_item.__newTask = function() {
	if (!frm_new_item.__oOpt.task) {
		return;
	}
	Item.create('T');
};

frm_new_item.__newRoom = async function() {
	if (!frm_new_item.__oOpt.room) {
		return;
	}
	await gui._create('frm_addroom', 'frm_addroom', '', '', sPrimaryAccount, '', [function () {
		Folder.openFolder.apply(null, arguments);
	}]);
	gui.frm_addroom._view('private');
};

frm_new_item.bindShortcuts = function() {
	var dgw = GWOthers.getItem('RESTRICTIONS', 'disable_gw_types');
	var isMac = navigator.platform.toUpperCase().indexOf('MAC') >= 0;
	
	frm_new_item.__oOpt = {
		conference: !sPrimaryAccountGUEST && window.sPrimaryAccountCONFERENCE,
		event: sPrimaryAccountGW && (!dgw || dgw.indexOf('e') < 0),
		note: (sPrimaryAccountGW && (!dgw || dgw.indexOf('n') < 0)) && !gui.frm_main.filter._getAnchor('N').classList.contains('hidden'),
		document: sPrimaryAccountGW && (!dgw || dgw.indexOf('f') < 0),
		contact: sPrimaryAccountGW && (!dgw || dgw.indexOf('c') < 0),
		task: sPrimaryAccountGW && (!dgw || dgw.indexOf('t') < 0),
		room: sPrimaryAccountCHAT,
		sms: sPrimaryAccountSMS && ((GWOthers.getItem('RESTRICTIONS', 'disable_sms') || 0) < 1),
		alt: isMac ? '⌥ ' : 'Alt + '
	};

	document.body.addEventListener('keydown', function(e) {
		if (e.altKey) {
			if (document.activeElement && ~['INPUT', 'TEXTAREA'].indexOf(document.activeElement.tagName) || document.activeElement.closest('[contenteditable]')) {
				return;
			}

			var stop = true;
			switch (e.code) {
				case 'KeyM':
					frm_new_item.__newMail();
					break;
				case 'KeyS':
					frm_new_item.__newSMS();
					break;
				case 'KeyX':
					frm_new_item.__newConference();
					break;
				case 'KeyE':
					frm_new_item.__newEvent();
					break;
				case 'KeyN':
					frm_new_item.__newNote();
					break;
				case 'KeyC':
					frm_new_item.__newContact();
					break;
				case 'KeyL':
					frm_new_item.__newDistributionList();
					break;
				case 'KeyT':
					frm_new_item.__newTask();
					break;
				case 'KeyD':
					frm_new_item.__newWord();
					break;
				case 'KeyS':
					frm_new_item.__newExcel();
					break;
				case 'KeyP':
					frm_new_item.__newPowerpoint();
					break;
				case 'KeyR':
					frm_new_item.__newRoom();
					break;
				default:
					stop = false;
			}
			if (stop) {
				e.preventDefault();
				e.stopImmediatePropagation();
			}
		}
	}.bind(this), true);
};