_me = frm_moderators.prototype;
function frm_moderators() { };

_me.__constructor = async function (users, callback, opt) {
	var me = this;

	this.__opt = Object.assign({
		title:'EVENT::MANAGE',
		description: true,
		description_text1:'EVENT::MANAGE_DESCRIPTION',
		description_text2:'EVENT::MANAGE_DESCRIPTION2',
		moderators_support: true,
		moderators_heading: getLang('EVENT::MODERATORS'),
		users_heading: getLang('EVENT::ATTENDEES'),
		filter_placeholder: getLang('EVENT::FILTER_ATTENDEES'),
		readonly: false,
		role_support: true,
		status_support: true,
		remove_support: true,
		invite_support: true,
		admin_support: true,
		remove_myself_admin_support: true
	}, opt);

	this._title(this.__opt.title);
	this._defaultSize(600, 800);
	this._modal(true);
	this._resizable(false);

	await this._create('_scrollbar', 'obj_scrollbar');
	this._scrollbar._scrollbar(this._getAnchor('main'), this._getAnchor('main').parentNode);

	await this._draw('frm_moderators', 'main', this.__opt);

	if (this.__opt.description) {
		var moderator_icon = '<span class="icon moderator"></span>',
			remove_icon = '<span class="icon remove"></span>';
		this._getAnchor('description').innerHTML = [
			this.__opt.description_text1 && getLang(this.__opt.description_text1),
			this.__opt.description_text2 && getLang(this.__opt.description_text2, [
				moderator_icon,
				remove_icon
			])
		].filter(Boolean).join('<br />');
	}

	// FILTER
	this.filter._onchange = function () {
		var value = this._value().trim().toLowerCase();
		[].forEach.call(me.x_users.children, function (div) {
			div.classList.toggle('hidden', value && !~div.querySelector('.name').textContent.toLowerCase().indexOf(value));
		});
		[].forEach.call(me.x_moderators.children, function (div) {
			div.classList.toggle('hidden', value && !~div.querySelector('.name').textContent.toLowerCase().indexOf(value));
		});
	};

	// SUGGEST
	if (this.x_suggest) {
		this.x_address_book_icon._onclick = async function () {
			await gui._create('address_book', 'frm_addaddress', '', '', [me, '__onAddNewFromAddressbook'], ['ADDRESS_BOOK::SELECTED_ADDRESSES'], void 0, void 0, void 0, void 0, true);
			gui.address_book._modal(true);
		};

		this.x_suggest._single = true;
		this.x_suggest._itemClass = 'C';

		this.x_suggest._disobeyEvent('change', [this.x_suggest, '_checksize']);
		this.x_suggest._checksize = function () { };
		this.x_suggest._placeholder(getLang('ATTENDEES::QUICK_ADD'));
		this.x_suggest._onsubmit = function () {
			if (!this._checkError.length) {
				var tmp = MailAddress.splitEmailsAndNames(this._value());
				this._value('');
				if (tmp && tmp[0] && tmp[0].email) {
					me.__onAddNewFromAddressbook(true, [[MailAddress.createEmail(tmp[0].name, tmp[0].email)]]);
				}
			}
		};
		this.x_suggest.__minWidth = 400;
		this.x_suggest._onmouseselect = this.x_suggest._onsubmit;
		this.x_suggest._restrict([function (v) {
			if (v === '') return true;
			var tmp = MailAddress.splitEmailsAndNames(v);
			if (tmp && tmp[0] && tmp[0].email) {
				return Is.Email(tmp[0].email);
			}
			return false;
		}]);
		this.x_suggest._main.appendChild(mkElement('div', {
			className: 'add',
			onclick: async function () {
				await gui._create('address_book', 'frm_addaddress', '', '', [me, '__onAddNewFromAddressbook'], ['ADDRESS_BOOK::SELECTED_ADDRESSES'], void 0, void 0, void 0, void 0, true);
				gui.address_book._modal(true);
			}
		}));

		this.x_suggest._onchange = function() {
			me.x_btn_ok._disabled(me.x_suggest._value());
		};
		this.x_suggest._focus();
	}

	// LISTS
	this.x_users = this._getAnchor('users');
	this.x_users.__users = [];
	this.x_moderators = this._getAnchor('moderators') || {};
	this.x_moderators.__users = [];

	this.x_users.onclick = this.x_moderators.onclick = function (e) {
		var i = e.target.parentNode.id.substr((me._pathName + '.list/').length);
		if (i === '') {
			return;
		}

		if (e.target.classList.contains('remove')) {
			this._removeUser(i);
		} else if (e.target.classList.contains('moderator')) {
			this._moderator(i);
		}
	};

	

	if (this.__opt.role_support && !this.__opt.readonly) {
		this.x_users.oncontextmenu = this.x_moderators.oncontextmenu = async function(e){
			var row = e.target.parentNode;
			if (!row.id) {
				row = row.parentNode;
			}
			var id = row.id.substr((me._pathName + '.list/').length);
			if (id === '') {
				return;
			}

			if (this.__users[id]){
				e.preventDefault();

				var aMenu,pos = getSize(row);

				var cmenu = await gui._create('cmenu','obj_context','','obj_timetable_context');

				cmenu._onclick = function(e,elm,i,arg){
					this.__users[id][arg.key] = arg.value;
					this._fill();
				}.bind(this);

				//Status
				if (e.clientX-pos.x<40 && !gui._rtl || gui._rtl && e.clientX-pos.x-pos.w<40){
					var status = this.__users[id].status;
					aMenu = [{'title':'ATTENDEES::STATUS_P',css:'bg_status_P ' + (status == ''?'ico2 check':'ico'),'arg':{'id':id,'key':'status',value:''}},
							{'title':'ATTENDEES::STATUS_A',css:'bg_status_A ' + (status == 'A'?'ico2 check':'ico'),'arg':{'id':id,'key':'status',value:'A'}},
							{'title':'ATTENDEES::STATUS_D',css:'bg_status_D ' + (status == 'D'?'ico2 check':'ico'),'arg':{'id':id,'key':'status',value:'D'}}];

					await cmenu._fill(aMenu);
					cmenu._place(e.clientX, e.clientY, 150, 2);
				}
				//Role
				else{
					var role = this.__users[id].role;
					aMenu = [{'title':'ATTENDEES::ROLE_Q',css:'bg_role_Q ' + (role === 'Q'?'ico2 check':'ico'),'arg':{'id':id,'key':'role',value:'Q'}},
							{'title':'ATTENDEES::ROLE_S',css:'bg_role_S ' + (role === 'S'?'ico2 check':'ico'),'arg':{'id':id,'key':'role',value:'S'}},
							{'title':'ATTENDEES::ROLE_T',css:'bg_role_T ' + (role === 'T'?'ico2 check':'ico'),'arg':{'id':id,'key':'role',value:'T'}}];

					await cmenu._fill(aMenu);
					cmenu._place(e.clientX, e.clientY, 150, 2);
				}
			}
		};

		this.x_users.ondblclick = this.x_moderators.ondblclick = async function(e){
			var row = e.target.parentNode;
			if (!row.id) {
				row = row.parentNode;
			}
			var id = row.id.substr((me._pathName + '.list/').length);
			if (id === '') {
				return;
			}

			if (this.__users[id]){
				e.preventDefault();
				var user = this.__users[id];
				await gui._create('edit_dialog', 'frm_edit_attendee', '', '', 'frm_edit_attendee', 'ATTENDEES::EDIT_TITLE', [function(arg) {
					user.email = arg.CNTEMAIL;
					user.name = arg.CNTCONTACTNAME;
					user.role = arg.CNTROLE;
					user.status = arg.CNTSTATUS;
					this._fill();
				}.bind(this)], { CNTEMAIL: user.email, CNTCONTACTNAME: user.name, CNTROLE: user.role, CNTSTATUS: user.status });
			}
		};
	}

	this.x_users._fill = this.x_moderators._fill = function () {
		var out = mkElement('div');

		if (me.__opt.role_support)
			this.__users = this.__users.sort(function (a, b) {
				return (a.role === 'G') ? -1 : (b.role === 'G');
			});
		else
			this.__users = this.__users.sort(function (a, b) {
				if (a.email == sPrimaryAccount)
					return -1;
				else
				if (b.email == sPrimaryAccount)
					return 1;

				return (a.name || a.email).localeCompare(b.name || b.email)
			});


		for (var i = 0; i < this.__users.length; i++) {
			if (this.__users[i].action === 'remove')
				continue;

			var css = [this.__users[i].css];

			if (me.__opt.status_support)
				css.push('status_' + (this.__users[i].status || 'M'));

			if (me.__opt.role_support && this.__users[i].role)
				css.push('role_' + this.__users[i].role);

			if (this.__users[i].moderator)
				css.push('is-moderator');

			var myself = this.__users[i].email === sPrimaryAccount;
			var name = myself ? getLang('COMMON::YOU') : (this.__users[i].name || this.__users[i].email).escapeHTML();
			out.appendChild(mkElement('div', {
				id: me._pathName + '.list/' + i,
				className: css.filter(Boolean).join(' '),
				unselectable: 'on',
				title: this.__users[i].email,
				innerHTML: obj_avatar.getAvatarHTML({
					email: this.__users[i].email,
					name: name,
					size: 28
				}) + '<div class="name">' + name + '</div>' +
					((me.__opt.admin_support && (me.__opt.remove_myself_admin_support || !myself)) ? '<div class="moderator">' + getLang('EVENT::MODERATOR') + '</div>' : '') +
					((!me.__opt.remove_support || myself) ? '' : '<div class="remove"><div class="icon"></div></div>'),
			}));
		}

		this.innerHTML = out.innerHTML;
	};

	this.x_users._addUser = function (aInfo) {
		if (aInfo.email && aInfo.email.indexOf('[') === 0) {
			(new wm_tools()).distrib({
				name: aInfo.email
			}, [this, '_addGroup', [aInfo.role]]);
		} else {
			aInfo.email = aInfo.email.toLowerCase();
			for (var i = this.__users.length - 1; i > -1; i--)
				if (this.__users[i].email === aInfo.email && this.__users[i].action !== 'remove')
					return false;
			for (i = me.x_moderators.__users.length - 1; i > -1; i--)
				if (me.x_moderators.__users[i].email === aInfo.email && me.x_moderators.__users[i].action !== 'remove')
					return false;

			aInfo.action = 'new';
			this.__users.push(aInfo);
			this._fill();
		}
	};

	this.x_users._addGroup = function (aData, sRole) {
		for (var i in aData) {
			if (me.__opt.role_support)
				aData[i].role = sRole;

			this._addUser(aData[i]);
		}
	};

	this.x_users._moderator = this.x_moderators._moderator = function (i) {
		if (this.__users[i].moderator) {
			this.__users[i].moderator = false;
			if (this.__users[i].action !== 'new') this.__users[i].action = 'edit';

			me.x_users.__users.push(this.__users[i]);
			me.x_moderators.__users.splice(i, 1);
		} else {
			this.__users[i].moderator = true;
			if (this.__users[i].action !== 'new') this.__users[i].action = 'edit';

			me.x_moderators.__users.push(this.__users[i]);
			me.x_users.__users.splice(i, 1);
		}

		me.x_moderators._fill();
		me.x_users._fill();
	};

	this.x_users._removeUser = this.x_moderators._removeUser = function (i) {
		if (this.__users[i].action === 'new')
			this.__users.splice(i, 1);
		else
			this.__users[i].action = 'remove';

		this._fill();
	};

	for (var i in users) {
		if (this.__opt.moderators_support && users[i].moderator) {
			this.x_moderators.__users.push(users[i]);
		} else {
			this.x_users.__users.push(users[i]);
		}
	}

	this.x_users._fill();
	this.x_moderators._fill();

	// BUTTONS
	this.x_btn_ok._value('FORM_BUTTONS::SAVE');
	this.x_btn_ok._onclick = function () {
		this._disabled(true);
		callback(me.x_moderators.__users.concat(me.x_users.__users));
		this._parent._destruct();
	};

	this.x_btn_cancel._onclick = function () {
		this._parent._destruct();
	};
};

_me.__onAddNewFromAddressbook = function (bOK, aAddresses) {
	if (bOK && aAddresses[0]) {
		var tmp;

		for (var i in aAddresses[0]) {
			tmp = MailAddress.splitEmailsAndNames(aAddresses[0][i]);

			if (typeof tmp[0] === 'object') {
				if (this.__opt.role_support)
					tmp[0].role = 'Q';

				this.x_users._addUser(tmp[0]);
			}
		}
	}
};