_me = frm_main_conference.prototype;

function frm_main_conference() {};
frm_main_conference.__formData = null;

_me.__constructor = async function () {
	var me = this;

	this.__opt = {
		full: ~['jitsi', 'jitsi-full'].indexOf(dataSet.get('accounts',[sPrimaryAccount, 'MEETING_PROVIDER']))
	};

	gui.frm_main._title(getLang('CONFERENCE::TITLE'));

	addcss(this._main, 'full');

	await this._draw('frm_main_conference', 'main', {
		full: this.__opt.full
	});

	gui._obeyEvent('conference_started', [this, '_updateView']);
	gui._obeyEvent('conference_ended', [this, '_updateView']);

	this._add_destructor('__storeFormData');

	await this._updateView(true);

	if (this.__opt.full){
		await this.slides._create('upcoming', 'obj_list_conference', '', 'panel');
		await this.slides._create('history', 'obj_list_conference', '', 'panel');

		this.slides.upcoming.__options.search = 'afterend:now';
		this.slides.upcoming._serverSort({
			aid: sPrimaryAccount,
			fid: '__@@VIRTUAL@@__/__@@MEETINGS@@__'
		}, false, {
			search: gui.frm_main.search.__getDefaultQuery('W')
		});

		this.slides.history.__options.order = 'desc';
		this.slides.history._serverSort(Path.split(GWOthers.getItem('DEFAULT_FOLDERS', 'JOURNAL'), true), false, {
			search: gui.frm_main.search.__getDefaultQuery('W')
		});

		this.switch._fill(['CONFERENCE::UPCOMING', 'CONFERENCE::HISTORY']);
		this.switch._onchange = function() {
			me.slides._value(['upcoming', 'history'][this._value() - 1]);
		};
		this.switch._value(1);
	}
	this.close._onclick = function() {
		gui.frm_main.filter.__filter('D', false, false, 5);
	};
};

_me.__storeFormData = function() {
	if (this.__currentView === 'schedule') {
		frm_main_conference.__formData = this.schedule.__value();
	}
};

_me._updateView = async function(bForce){
	//auto disobey
	if (!this || this._destructed)
		return false;

	if (frm_main_conference.__formData) {
		await this._view('schedule');
		this.schedule.__value(frm_main_conference.__formData);
		frm_main_conference.__formData = null;
	} else if (dataSet.get('main', ['conference'])) {
		await this._view('progress');
	} else if (bForce || (this.__currentView === 'progress')) {
		await this._view('home');
	}
};

_me._view = async function(sView, aData, bDestructOld){

	if (this._destructed || (this.__currentView === sView)) {
		return;
	}
	this.__currentView = sView;

	var o;
	switch(sView){
		case 'name':
			o = await this._create('name','obj_conference_name', 'view_pane');
			break;
		case 'schedule':
			o = await this._create('schedule','obj_conference_schedule', 'view_pane');
			break;
		case 'progress':
			o = await this._create('progress','obj_conference_progress', 'view_pane');
			break;

		default:
			o = await this._create('home','obj_conference_home', 'view_pane');
	}

	if (o){

		//draw Back button
		var back = this._getAnchor('back');
		if (o.__opt && o.__opt.back_button){
			back.textContent = o.__opt.back_button;
			back.onclick = function(){
				this._view(o.__opt.back_action || 'home', null, true);
			}.bind(this);
			addcss(this._main, 'back');
		}
		else
			removecss(this._main, 'back');

		if (o.__destructTimer)
			clearTimeout(o.__destructTimer);

		if (this.__current){
			addcss(this.__current._main, 'flyout');

			removecss(o._main, 'flyout');
			addcss(o._main, 'flyin');

			if (bDestructOld || ['obj_conference_schedule', 'obj_conference_name'].indexOf(this.__current._type) == -1){
				this.__current.__destructTimer = setTimeout(function(){
					if (this && !this._destructed)
						this._destruct();
				}.bind(this.__current), 500);
			}
		}

		this.__current = o;
	}
};

_me._showsearch = function(aFolder){
	if (this.__opt.full){
		gui.frm_main.search._onsearch = function() {
			// this.slides.upcoming._search(v);
			// this.slides.history._search(v);
		}.bind(this);

		gui.frm_main.search._setFolder(aFolder);
	}
};

_me._serverSort = function(){};

_me._scheduleConference = function () {
	Item.openwindow([
		sPrimaryAccount,
		frm_main_conference.FOLDER
	], {
		conference: true
	});
};
