_me = frm_main_chat.prototype;
function frm_main_chat(){};

_me.__constructor = async function(sDataset, opt){

	//Reset Title
	gui.frm_main._title();

	var me = this;
	this.__sDataset = sDataset;
	this.__updateTab = {};
	this.__current = {};

	this.__opt = Object.assign({
		remember_folder: true,
		popup: false,
		buttons:{context:this, anchor:'buttons'},
		search: gui.frm_main.search,
		thread:[gui.frm_main,'_openTeamchatThread'],
		selectView:[gui.frm_main,'_selectView'],
		fakeView:[this,'_fakeView'],
		toolbar: {context: gui.frm_main, anchor: 'toolbar1'},
		uploadInstanceId: ''
	}, opt || {});

	await this._draw('frm_main_chat', 'main', {guest_user:sPrimaryAccountGUEST});

	//chat input
	this.__input_menu_handlers = {
		word:[function(){
			WMChat.addDocument({aid:me.__aid, fid:me.__fid}, {type:'F', doc:'.docx'}, function() {}, me._gui);
		}],
		excel:[function(){
			WMChat.addDocument({aid:me.__aid, fid:me.__fid}, {type:'F', doc:'.xlsx'}, function() {}, me._gui);
		}],
		ppoint:[function(){
			WMChat.addDocument({aid:me.__aid, fid:me.__fid}, {type:'F', doc:'.pptx'}, function() {}, me._gui);
		}],
		// note:[function(){
		// 	WMChat.addDocument({aid:me.__aid, fid:me.__fid}, {type:'N'});
		// }],
		code:[this,'_code'],
		attach:[this,'_attachFile'],
		event:[
			function(){
				WMChat.addEvent({aid:me.__aid, fid:me.__fid}, function() {}, me._gui);
			}
		],
		conference:(sPrimaryAccountGUEST  || (window.TeamChatAPI && TeamChatAPI.teamChatOnly())) ? void 0 : [
			function(){
				WMChat.addEvent({aid:me.__aid, fid:me.__fid}, {conference:true}, function() {}, me._gui);
			}
		],
		email:(sPrimaryAccountGUEST  || (window.TeamChatAPI && TeamChatAPI.teamChatOnly())) ? void 0 : [
			function(){
				WMChat.addEmail({aid:me.__aid, fid:me.__fid}, void 0, me._gui);
			}
		]
	};

	await this._create("text","obj_chat_input","text","",{
		guest:!sPrimaryAccountGUEST,
		parseurl:true,
		block:true,
		handlers:this.__input_menu_handlers,
		memory:{
			set:[function(val){
				dataSet.add('teamchat', [me.__fid, 'input'], val, true);
			}],
			get:[function(){
				return dataSet.get('teamchat', [me.__fid, 'input']) || '';
			}]
		},
		upload: true,
		upload_enabled: true,
		uploadInstanceId: this.__opt.uploadInstanceId,
		alias: me.__fid,
		label: function() {
			return WMFolders.getFolderName({
				aid: me.__aid,
				fid: me.__fid
			});
		}.bind(this)
	});

	this.text.input._placeholder(getLang('IM::MESSAGE_PH'));

	this.text._onsubmit = function (v, arg, aPrivate, callback) {
		if (v.length || (arg && arg.url) || this._upload._getAttachments().length) {
			me._message(v, arg, callback);
		}
	};

	this.text._focus();
	this.text.input._obeyEvent('onkeyup', [this, '__keyupHandler']);

	//Tabs
	await this._init_tabs();

	//Room status
	gui._obeyEvent('visibilitychange', [this, '__pushBackgroundStatus']);
	this._add_destructor('__pushOfflineStatus');

	//inject toolbar into menu
	if (this.__opt.toolbar) {
		this._toolbar = await this.__opt.toolbar.context._create('chat_toolbar', 'obj_chat_toolbar',{
			target: this.__opt.toolbar.anchor,
			first:true
		}, '', this.__opt);
	} else {
		this._toolbar = await this._create('chat_toolbar', 'obj_chat_toolbar','header', '', {
			context: this
		});
	}

	gui.frm_main.dnd.registr_drop(this, ['item']);
};

_me._active_dropzone = async function(v){
	if (v && v.type == 'item') {
		var mask = mkElement('div', {
			className: 'dropzone item',
			onmouseenter: function() {
				mask.classList.add('active');
			},
			onmouseleave: function() {
				mask.classList.remove('active');
			},
			innerHTML: await (new cTemplate()).tmp('dropzone', {
				title: getLang('CHAT::DROP_TITLE', [WMFolders.getFolderName({aid: this.__aid, fid: this.__fid})]),
				body: ''
			})
		});
		this._main.appendChild(mask);
		return mask;
	} else {
		return false;
	}
};

_me._ondrop = function(v) {
	if (v.type == 'item'){
		this.__addItems(v.value.map(function(v) {
			return {
				title: v.name,
				size: v.size,
				aid: v.aid,
				fid: v.fid,
				iid: v.iid
			}
		}));
	}
};

_me.__pushOfflineStatus = function(){
	try {
		gui._disobeyEvent('visibilitychange', [this, '__pushBackgroundStatus']);
		WMChat.setRoomStatus(this.tabs.room.list, {aid:this.__aid, fid:this.__fid}, 'OFFLINE');
		// if (this.__opt.toolbar && this.__opt.toolbar.context.toolbar) {
		// 	this.__opt.toolbar.context._getAnchor('toolbar1').insertAdjacentElement('beforeend', this.__opt.toolbar.context.toolbar._main);
		// }
		this._toolbar && this._toolbar._destruct();
	} catch {
		//
	}
};
_me.__pushBackgroundStatus = function(){
	WMChat.setRoomStatus(this.tabs.room.list, {aid:this.__aid, fid:this.__fid}, gui._isVisible() ? 'ONLINE' : 'BACKGROUND');
};
_me.__keyupHandler = function(){
	if (this.__statusTimer)
		clearTimeout(this.__statusTimer);
	else
		WMChat.setRoomStatus(this.tabs.room.list, {aid:this.__aid, fid:this.__fid}, 'TYPING');

	this.__statusTimer = setTimeout(function(){
		if (!this._destructed)
			this.__pushBackgroundStatus();

		delete this.__statusTimer;
	}.bind(this), 2000);
};


_me._init_tabs = async function(){
	var me = this;

	//Search
	this.tabs._onchange = function(sTab){
		sTab && me.__opt.search._setFolder({ aid: me.__aid, fid: me.__fid }, sTab);

		if (me.btn_files_sort){
			if (sTab == 'files')
				removecss(me.btn_files_sort._main, 'hidden');
			else
				addcss(me.btn_files_sort._main, 'hidden');
		}
	};

	//BUTTONS
	this.btn_members = await this._create.call(this.__opt.buttons.context, 'btn_members', 'obj_button', this.__opt.buttons.anchor, 'ico img simple inline frm_main_chat-button btn_invite');
	this.btn_members._title('CHAT::INVITE_MEMBERS');
	this.btn_members._onclick = function() {
		me._gui._create('invite','frm_groupchat_invite','','',{aid:me.__aid, fid:me.__fid});
	};

	this.btn_follow = await this._create.call(this.__opt.buttons.context, 'btn_follow', 'obj_button', this.__opt.buttons.anchor, 'ico img simple inline frm_main_chat-button btn_follow');
	this.btn_follow._title('CHAT::FOLLOW');
	this.btn_follow._onclick = function() {
		if (+dataSet.get('folders', [me.__aid, me.__fid, 'AUTOFOLLOW']) > 0) {
			this.btn_follow._main.classList.remove('active');
			this.btn_follow._main.classList.remove('ring');
			setTimeout(function() {
				gui.tooltip._show(me.btn_follow._main, getLang('CHAT::STOP_AUTO_FOLLOWING'), { delay: 5, y: getSize(me.btn_follow._main).y - 28 });
			}, 5);
		} else {
			this.btn_follow._main.classList.add('active');
			this.btn_follow._main.classList.add('ring');
			setTimeout(function() {
				gui.tooltip._show(me.btn_follow._main, getLang('CHAT::AUTO_FOLLOWING'), { delay: 5, y: getSize(me.btn_follow._main).y - 28 });
			}, 5);
		}
		WMChat.followRoom({aid: me.__aid, fid: me.__fid}, +!(+dataSet.get('folders', [me.__aid, me.__fid, 'AUTOFOLLOW']) > 0));
	}.bind(this);

	this.btn_option = await this._create.call(this.__opt.buttons.context, 'btn_option','obj_button',this.__opt.buttons.anchor,'ico img simple inline frm_main_chat-button btn_option');
	this.btn_option._title('COMPOSE::OPTIONS');
	this.btn_option._onclick = async function(e){
		if (this.cmenu && !this.cmenu._destructed)
			return;

		var elm = e.target,
			aMenu = [{
				anchor: 'body',
				keep: true
			}];

		this.cmenu = await me._gui._create("cmenu", "obj_context", "main", "obj_groupchat_options");
		await this.cmenu._fill(aMenu);

		await this.cmenu._draw('obj_groupchat_options','body');
		this.cmenu.sw_notify._onchange = function(){
			WMChat.notifyRoom({aid:me.__aid, fid:me.__fid}, this._value());
		};
		this.cmenu.sw_notify._value(+dataSet.get('folders', [me.__aid, me.__fid, 'NOTIFY']) > 0, true);
		this.cmenu.sw_notify._disabled(!(GWOthers.getItem('CHAT','visual_notify')>'0' || GWOthers.getItem('CHAT','sound_notify')>'0'));

		// this.cmenu.sw_follow._value(+dataSet.get('folders', [me.__aid, me.__fid, 'AUTOFOLLOW']) > 0);
		// this.cmenu.sw_follow._onchange = function() {
		// 	WMChat.followRoom({aid: me.__aid, fid: me.__fid}, +!(+dataSet.get('folders', [me.__aid, me.__fid, 'AUTOFOLLOW']) > 0));
		// };

		this.cmenu._getAnchor('leave').onclick = function(){
			gui._create('frm_confirm','frm_confirm','','',[function() {
				WMChat.leaveRoom({aid:me.__aid, fid:me.__fid}, [function(bOK){
					if (bOK)
						this._destruct();
				}]);
			}],'CONFIRMATION::LEAVE_ROOM_CONFIRMATION','CONFIRMATION::LEAVE_ROOM',[dataSet.get('folders', [me.__aid, me.__fid, 'NAME']) || Path.basename(me.__fid)]);

		}.bind(this.cmenu);

		this.cmenu._placeMenu(elm, {mode:'left'});

		this.cmenu._onclose = function(_, e) {
			return _ ? !Is.Child(e.target, this.cmenu._main) : true;
		}.bind(this);

		e.stopPropagation();
	};

	this.tabs.norooms.create._onclick = function() {
		var sFolderID = Path.split(dataSet.get('active_folder'));
		Folder.addFolder({
			aid: sPrimaryAccount,
			fid: sFolderID[1]
		}, [function() {
			Folder.openFolder.apply(null, arguments);
		}]);
	};

	//// CHAT ////
	//this.tabs.room.label._escape = true;
	this.tabs.room.list._onclick = function(e, elm){
		var id;

		//Send mail
		if (hascss(elm, 'mailto')) {
			var email = elm.getAttribute('rel');
			if (email)
				Item.sendEmailTo(email);
		} else if (elm.tagName == 'SPAN') {
			if (hascss(elm, 'mention') && (id = elm.getAttribute('rel'))) {
				var addr = MailAddress.splitEmailsAndNames(id);
				if ((addr = addr[0]) && addr.email)
					me.text.input._addMention(addr);
			} else if (hascss(elm, 'show_gpins')) {
				me.__opt.selectView && executeCallbackFunction(me.__opt.selectView,{aid:me.__aid, fid:me.__fid}, 'pins_view');
				e.stopPropagation();
			} else if (hascss(elm, 'show_threads')) {
				me.__opt.selectView && executeCallbackFunction(me.__opt.selectView,{aid:me.__aid, fid:me.__fid}, 'threads_view');
				e.stopPropagation();
			}
		} else if (elm.tagName == 'A' && elm.protocol === 'mailto:') {
			e.preventDefault();
			NewMessage.compose({to:elm.pathname});
		}
	};

	this.tabs.room.list._onreply = function(aPath){
		this.__opt.thread && executeCallbackFunction(this.__opt.thread, {
			aid: aPath.aid,
			fid: aPath.fid,
			iid: aPath.iid || WMItems.__clientID(aPath.EVN_ID)
		});
	}.bind(this);

	this.tabs.room.list._ongoto = function(aData){
		//Open comment
		if (aData.EVNCOMEVNID){
			this.__opt.thread && executeCallbackFunction(this.__opt.thread, aData);
		}
		//Switch to room
		else{
			//faux view selection
			this.__opt.fakeView && executeCallbackFunction(this.__opt.fakeView, aData);
			this._serverSort('room_view', {until:aData.iid, highlight:true}, true);
		}
	}.bind(this);

	this.tabs.room.list._oncontextEvent = function(evn){
		switch(evn.type){
			case 'quote':
				me.text.input._value('"' + evn.value + '" ');
				me.text.input._focus();
				break;
			case 'event':
				me.__global_context_menu(evn.e, evn.elm, evn.obj);
		}
	};

	//// CHAT - PINS ////
	this.tabs.room.btn_switch._fill(['SHARING::PUBLIC','SHARING::PRIVATE']);
	this.tabs.room.btn_switch._value(1, true);
	this.tabs.room.btn_switch._onchange = function(){

		var opt = {
			search: me.__opt.search._value(),
			type:'gchat:' + ['global_pins','my_pins'][this._value()-1]
		};

		this._parent.list._placeholder('CHAT::NOPINS');
		this._parent.list._serverSort({aid:me.__aid, fid:me.__fid}, true, opt);
	};

	//// FILES ////
	this.tabs.files._onactive = async function (bFirstTime) {
		if (bFirstTime){
			//SORT
			me.btn_files_sort = await me._create.call(me.__opt.buttons.context, 'btn_files_sort','obj_button',me.__opt.buttons.anchor,'ico img simple frm_main_chat-button btn_files_sort');
			me.btn_files_sort._title('SORT::SORT_BY');
			me.btn_files_sort._onclick = async function(e){
				if (this.cmenu && !this.cmenu._destructed)
					return;

				var elm = e.target,
					pos = getSize(elm),
					sType = Cookie.get(['folders', me.__aid, me.__fid, 'files', 'sort']) || 'EVN_MODIFIED',
					sSort = Cookie.get(['folders', me.__aid, me.__fid, 'files', 'sortdir']) || 'desc';

				var aMenu = [{
						title: 'CHAT::SORT_NAME',
						arg: ['EVNTITLE']
					},
					{
						title: 'CHAT::SORT_DATE',
						arg: ['EVN_MODIFIED']
					},
					{
						title: 'CHAT::SORT_SIZE',
						arg: ['EVNCOMPLETE']
					},
					{
						title: '-'
					},
					{
						title: ({
							EVNTITLE: 'SORT::EVNTITLE_ASC',
							EVN_MODIFIED: 'SORT::DATE_ASC',
							EVNCOMPLETE: 'SORT::SIZE_ASC'
						})[sType],
						arg: ['', 'asc']
					},
					{
						title: ({
							EVNTITLE: 'SORT::EVNTITLE_DESC',
							EVN_MODIFIED: 'SORT::DATE_DESC',
							EVNCOMPLETE: 'SORT::SIZE_DESC'
						})[sType],
						arg: ['', 'desc']
					}
				].map(function(v){
					if (v.arg){
						v.css = "ico2";

						if (v.arg[0]){
							if (v.arg[0] == sType){
								v.css += " check";
							}

							v.arg[1] = sSort;
						}
						else{
							if (v.arg[1] == sSort){
								v.css += " check";
							}

							v.arg[0] = sType;
						}
					}
					return v;
				});

				this.cmenu = await me._gui._create("cmenu", "obj_context");
				await this.cmenu._fill(aMenu);
				this.cmenu._onclick = function(e, elm, id, arg){
					Cookie.set(['folders', me.__aid, me.__fid, 'files', 'sort'], arg[0]);
					Cookie.set(['folders', me.__aid, me.__fid, 'files', 'sortdir'], arg[1]);
					me.tabs.files.list._serverSort({aid: me.__aid, fid: me.__fid}, me.__updateTab[this._name], true);
				};

				this.cmenu._place(pos.x,pos.y+(pos.h/2));

				e.stopPropagation();
			};

			AttachEvent(this._getAnchor('main'), 'oncontextmenu', function(e){
				me.__global_context_menu(e, e.target, this.list);
			}.bind(this));

			this.list._placeholder('CHAT::NOFILES');
		}

		this.list._serverSort({aid:me.__aid, fid:me.__fid}, me.__updateTab[this._name], {
			search: me.__opt.search.__getDefaultQuery('I'),
			type: 'gchat:files'
		});
	};

	//// EVENTS ////
	this.tabs.events._onactive = function (bFirstTime) {
		if (bFirstTime){
			this.btn_switch._fill(['CONFERENCE::UPCOMING', 'CONFERENCE::HISTORY']);
			this.btn_switch._onchange = function(){
				var opt = {
					search: me.__opt.search.__getDefaultQuery('I')
				};

				this.list.__options.history = this.btn_switch._value() == 2;
				this.list._serverSort({aid:me.__aid, fid:me.__fid}, me.__updateTab[this._name], opt);

			}.bind(this);

			this.btn_switch._value(1);

			AttachEvent(this._getAnchor('main'), 'oncontextmenu', function(e){
				me.__global_context_menu(e, e.target, this.list);
			}.bind(this));
		}
		else{
			this.btn_switch._onchange();
		}
	};

	//ROOM
	this.tabs.room._onactive = function (){
		if (me.text)
			me.text._focus();

		if (this.list.__aRequestData.folder && this.list.__aRequestData.folder.fid){
			WMChat.room.add(this.list, this.list.__aRequestData.folder.fid);
		}
	};
	this.tabs.room._ondeactive = function (){
		if (this.list.__aRequestData.folder && this.list.__aRequestData.folder.fid){
			WMChat.room.remove(this.list, this.list.__aRequestData.folder.fid);
		}
	};

	AttachEvent(this.tabs.room._getAnchor('main'), 'oncontextmenu', function(e){
		me.__global_context_menu(e, e.target, this.list);
	}.bind(this.tabs.room));


	//RESPONSIVE LAYOUT
	if (!this.__opt.popup){
		this.tabs.room.list._obeyEvent('onresize',[this, '__resizeHandler']);
		setTimeout(function(){
			this.__resizeHandler && this.__resizeHandler();
		}.bind(this), 100);
	}
};

_me.__global_context_menu = async function(e) {
	this.cmenu && await this.cmenu._destruct();

	e.preventDefault();
	e.stopPropagation();

	var aMenu = [];

	if (this.__input_menu_handlers['word'] || this.__input_menu_handlers['excel'] || this.__input_menu_handlers['ppoint'] || this.__input_menu_handlers['note']) {
		aMenu.push({'title': 'CHAT::CREATE_NEW_DOCUMENT', css: 'ico2 file', nodes: [
				this.__input_menu_handlers['word'] ? {'title': 'main_menu::new_word', 'arg': {'method': 'word'}, css: 'ico2 word'} : false,
				this.__input_menu_handlers['excel'] ? {'title': 'main_menu::new_excel', 'arg': {'method': 'excel'}, css: 'ico2 excel'} : false,
				this.__input_menu_handlers['ppoint'] ? {'title': 'main_menu::new_ppoint', 'arg': {'method': 'ppoint'}, css: 'ico2 ppoint'} : false,
				this.__input_menu_handlers['note'] ? {'title': 'main_menu::new_note', 'arg': {'method': 'note'}, css: 'ico2 note'} : false
		].filter(Boolean)});
	}

	if (this.__input_menu_handlers['attach']) {
		aMenu.push({'title': 'CHAT::SHARE_FILE_OR_DOCUMENT', 'arg': {'method': 'attach'}, css: 'ico2 attach'});
	}

	if (this.__input_menu_handlers['code']) {
		aMenu.push({'title': 'INSERT_CODE::TITLE', 'arg': {'method': 'code'}, css: 'ico2 code'});
	}

	if (this.__input_menu_handlers['conference']) {
		aMenu.push({'title': 'CHAT::NEW_CONFERENCE', 'arg': {'method': 'conference'}, css: 'ico2 conference', disabled: !sPrimaryAccountCONFERENCE});
	}

	if (this.__input_menu_handlers['event'])
		aMenu.push({'title': 'IM::NEW_EVENT', 'arg': {'method': 'event'}, css: 'ico2 event'});

	if (this.__input_menu_handlers['email'])
		aMenu.push({'title': 'CHAT::NEW_EMAIL', 'arg': {'method': 'email'}, css: 'ico2 email'});

	if (this.__input_menu_handlers['geo'])
		aMenu.push({'title': 'IM::GEO', 'arg': {'method': 'geo'}, css: 'ico2 geo', disabled: !("geolocation" in navigator) || !GWOthers.getItem('EXTERNAL_SETTINGS', 'google_maps_api_key')});

	addcss(this._main, 'color1');

	this.cmenu = await this._gui._create("cmenu", "obj_context", '', 'obj_chat_input_add', this);
	await this.cmenu._fill(aMenu);
	this.cmenu._place(e.clientX, e.clientY, null, 2);

	this.cmenu._obeyEvent('destructed', [function () {
		removecss(this._main, 'color1');
	}.bind(this)]);

	this.cmenu._onclick = function (e, elm, id, arg) {
		if (arg.method && this.__input_menu_handlers && this.__input_menu_handlers[arg.method])
			executeCallbackFunction(this.__input_menu_handlers[arg.method]);
		else
			executeCallbackFunction(arg);
	}.bind(this);
};

_me._code = function () {
	this._gui._create('insert_code', 'frm_insert_code', '', '', [function (sBody) {
		this._message(sBody);
	}.bind(this)]);
};

_me._message = async function(sBody, aArgs, callback){
	if (this.__aid && this.__fid) {
		if(sBody[0] === '/') {
			var me = this;
			var confirm = await this._gui._create('confirm', 'frm_confirm', '', '', [function() {
				me.__message(sBody, aArgs);
				callback && callback();
			}], 'CHAT::COMMAND_DETECTED', 'CHAT::COMMAND_DETECTED_HELPER', ['<b>' + sBody.match(/^\/([^\s]*)/)[1] + '</b>'], [function() {
				me.__message('\\' + sBody, aArgs);
				callback && callback();
			}]);
			confirm.x_btn_ok._value('CHAT::SEND_AS_COMMAND');
			confirm.x_btn_cancel._value('CHAT::SEND_AS_TEXT');
			confirm.x_btn_cancel._main.classList.add('color4');

			await confirm._create('x_btn_close', 'obj_button', 'footer', 'cancel color2 noborder');
			confirm.x_btn_close._tabIndex();
			confirm.x_btn_close._value('FORM_BUTTONS::CANCEL');
			confirm.x_btn_close._onclick = function() {
				confirm._destruct();
			};
		} else {
			this.__message(sBody, aArgs);
			callback && callback();
		}
	}
};

_me.__message = function(sBody, aArgs){
	var files = this.text._upload._getAttachments();
	aArgs = Object.assign(aArgs || {}, {body:sBody});

	if (this.text._isUploading()) {
		WMChat.queueMessageWithAttachments({aid:this.__aid, fid:this.__fid}, this.text._upload, aArgs);

		this.text._newUploadInstance();
		return;
	}

	if (sBody.match(/\(data:.*?;base64,.*?\)/)) {
		replaceAsync(sBody, /!\[(.*?)\]\((data:image\/(.*?);base64,.*?)\)/g, (full, name, data, type) => {
			return new Promise((resolve) => {
				fetch(data).then(res => res.blob()).then(async blob => {
					if (type === 'heif') {
						type = 'heic'
					}
					var image = new File([blob], name + '.' + type, { type: 'image/' + type });

					var uploadInstance = await obj_upload._instance(this, unique_id());
					
					function uploadEndHandler(data) {
						if (data.owner !== uploadInstance.file) {
							return;
						}

						gui._disobeyEvent('onuploadend', [uploadEndHandler]);
						if (!data.files.length) {
							resolve('');
						}
						var aFolder = {
							aid: sPrimaryAccount,
							fid: Mapping.getDefaultFolderForGWType('F')
						};
				
						var now = new IcewarpDate();
						WMItems.add([aFolder.aid, aFolder.fid], {
							values: {
								EVNSHARETYPE: GWOthers.getItem('DEFAULT_CALENDAR_SETTINGS', 'file_sharing'),
								EVNSTARTDATE: now.format(IcewarpDate.JULIAN),
								EVNSTARTTIME: now.hour() * 60 + now.minute()
							},
							ATTACHMENTS: uploadInstance._getAddon()
						}, '', '', '', [function (aResponse, aData) {
							uploadInstance._destruct();
							if (aResponse === true) {
								resolve('![' + name + '](' + aData.att_link + ')');
							} else if (aResponse !== 2) {
								resolve('');
							}
						}]);
					}
					gui._obeyEvent('onuploadend', [uploadEndHandler]);
					uploadInstance.file.__ondropfile([image]);
				});
			});
		}).then((sBody) => {
			aArgs.body = sBody;
			if (files.length) {
				WMChat.addMessageWithAttachments({
					aid: this.__aid,
					fid: this.__fid
				}, files, aArgs);
				this.text._clearAttachments(true);
			} else {
				WMChat.message({
					aid: this.__aid,
					fid: this.__fid
				}, aArgs);
			}
		});
	} else if (files.length) {
		WMChat.addMessageWithAttachments({aid:this.__aid, fid:this.__fid}, files, aArgs);

		this.text._clearAttachments(true);
	} else {
		WMChat.message({aid:this.__aid, fid:this.__fid}, aArgs);
	}
};


/**
 * @Note: funkce která zobrazuje a skrývá quicksearch toolbar
 * @Date: 28.5.2007 11:39:16
 **/
_me._showsearch = function(aFolder){

	if (aFolder){
		if (WMFolders.getType(aFolder) === 'Y') {
			gui.frm_main._lastView = 'norooms_view';
			this.tabs._value('norooms');
			gui.__exeEvent('viewSelected','norooms_view');
			this.__opt.search._setFolder(aFolder, 'norooms');
			this.__opt.search._onsearch = function(){};
		} else if (gui.frm_main._lastView === 'norooms_view') {
			gui.frm_main._lastView = 'room_view';
			this.tabs._value('room');
			gui.__exeEvent('viewSelected','room_view');
		}

		var bChangeFolder = this.__aid!=aFolder.aid || this.__fid != aFolder.fid;
		
		var disabled = WMFolders.getType(aFolder) !== 'I';
		this.text._disabled(disabled);
		this.btn_members._disabled(disabled);
		this.btn_follow._disabled(disabled);
		// this._parent.main.btn_invite._disabled(disabled);
		// this._parent.main.btn_detach && this._parent.main.btn_detach._disabled(disabled);
		this._parent.main.btn_option._disabled(disabled);
		if (disabled) {
			return;
		};

		this.btn_follow._main.classList.remove('ring');
		if (+dataSet.get('folders', [aFolder.aid, aFolder.fid, 'AUTOFOLLOW']) > 0) {
			this.btn_follow._main.classList.add('active');
		} else {
			this.btn_follow._main.classList.remove('active');
		}
		

		//Switch between folders
		if (bChangeFolder){
			if (this.__aid && this.__fid){

				if (this.tabs && this.tabs.room && this.tabs.room._wasActivated){
					if (this.tabs._value()!='room'){
						var t = ['room','files','events'];
						for(var i = t.length-1;i>=0;i--)
							if (this.tabs && this.tabs[t[i]] && this.tabs[t[i]]._wasActivated && this.tabs[t[i]].list)
								this.tabs[t[i]].list._clear();
					}
				}

				//send offline status
				WMChat.setRoomStatus(this.tabs.room.list, {aid:this.__aid, fid:this.__fid}, 'OFFLINE');
			}

			this._toolbar._setFolder(aFolder);

			this.__aid = aFolder.aid;
			this.__fid = aFolder.fid;
			var aRights = WMFolders.getRights(aFolder);

			//send online status
			this.__pushBackgroundStatus();

			//Remember last chat folder
			if (this.__opt.remember_folder)
				Cookie.set(['last','I'], this.__aid+'/'+this.__fid);

			//BUTTONS
			// this.btn_option._disabled(!(GWOthers.getItem('CHAT','visual_notify')>'0' || GWOthers.getItem('CHAT','sound_notify')>'0'));
			// this.btn_invite._disabled(!aRights.write);

			this.text._folder(aFolder);
			this.text._disabled(!aRights.write);
			if (aRights.write){
				this._main.classList.remove('readonly');
				this.text.input._value(dataSet.get('teamchat', [aFolder.fid, 'input']) || '');
				this.text.__options.alias = aFolder.fid;
				this.text.__initToolbar();
				this.text._focus();
			} else {
				this._main.classList.add('readonly');
				this.text.input._value('')
			}
		}

		//Handle search
		this.__opt.search._setFolder(aFolder, 'room');
		this.__opt.search._onsearch = function(v){
			if (this.tabs){
				var tab = this.tabs[this.tabs._value()];

				//Search in main list
				if (tab.list && tab.list._search)
					tab.list._search(v);
			}
		}.bind(this);
	}
};
/**
 *
 *
 * @param {string} sType
 * @param {object} aFilter, filter for room
 */
_me._serverSort = function(sType, aFilter, bForce){
	var sFilter = '';
	sType = (sType || 'room').replace('_view','');

	this._main.setAttribute('view', sType);

	//Those types use the same view
	if (['room', 'mentions','pins','threads','unread_threads'].indexOf(sType)>-1){
		sFilter = sType;
		sType = 'room';
	}

	//refresh only once
	if (!bForce && sType && this.__current.type == sType && this.__current.filter == sFilter && this.__current.fid == this.__fid)
		return;
	else{
		if (sFilter === 'unread_threads' && !(aFilter || {}).lasttime) {
			return gui.frm_main._selectView({ aid: this.__aid, fid: this.__fid }, 'room_view');
		}
		this.__current.type = sType;
		this.__current.filter = sFilter;
		this.__current.fid = this.__fid;
	}

	if (WMFolders.getType([this.__aid, this.__fid]) == 'I'){



		this.tabs._value(sType);

		var tab = this.tabs[sType];

		//Room
		if (sFilter == 'room'){

			if (tab.list.__aRequestData.counter)
				dataSet.remove('teamchat', ['forced_last_read_id']);

			if (!Is.Object(aFilter)){
				aFilter	= {
					search: this.__opt.search._value() || ''
				};

				if (!tab.list.__aRequestData.folder || tab.list.__aRequestData.folder.aid != this.__aid || tab.list.__aRequestData.folder.fid != this.__fid){
					var lastID = dataSet.get('teamchat', ['forced_last_read_id']);
					if (lastID) {
						aFilter.until = WMItems.__clientID(lastID);
						aFilter.highlight = true;
					}
				}
			}

			tab.list._placeholder('');
			tab.list._serverSort({aid:this.__aid, fid:this.__fid}, this.tabs._value() == sType, aFilter);
		}
		else
		//Pins & Mentions
		if (sType == 'room'){
			if (sFilter == 'pins'){
				tab.btn_switch._onchange();
			}
			else{
				tab.list._placeholder('CHAT::NO' + sFilter.toUpperCase());
				tab.list._serverSort({aid:this.__aid, fid:this.__fid}, this.tabs._value() == sType, {
					search: this.__opt.search.__getDefaultQuery('I'),
					type: 'gchat:' + sFilter,
					lasttime: (aFilter || {}).lasttime
				});
			}
		}
		// else
		//Other tabs
		// if (tab._onactive){
			//this.__updateTab[tab._name] = true;
			//tab._onactive();
		// }
	}
};

/**
 * Select different tab without refresh
 */
_me._fakeView = function(aPath,){
	Cookie.set(['views',aPath.aid,aPath.fid,'view'], 'room_view');
	gui.frm_main._lastView = 'room_view';
	this.tabs._value('room');
	gui.__exeEvent('viewSelected','room_view');
};

// Global Actions
_me._attachFile = function(){
	if (this.__aid && this.__fid){
		// In case "Attach from webclient" is disabled, just show browser upload dialog
		if ('1' === GWOthers.getItem('RESTRICTIONS', 'disable_attach_item'))
			this.text._upload._click();
		else
			this._gui._create('insert_item', 'frm_insert_item', '', 'frm_insert_item_nobottomdiv', [this, '__addItems'], this.__aid, this.__fid, '', this.text._upload, false, sPrimaryAccountGUEST ? ['I', 'X'] : ['M', 'F', 'I', 'X']);
	}
};

_me.__addItems = function(files) {
	this.text._upload._addFiles(files.map(function (file) {
		return {
			class: 'item',
			aid: file.aid,
			fid: file.fid,
			iid: file.iid,
			name: file.title,
			size: file.size,
			fullpath: file.fullpath
		};
	}));
};

_me.__resizeHandler = function(){
	//auto-disobey
	if (this._destructed)
		return false;
	else{
		var w = this._main.offsetWidth;

		if (w>1150)
			addcss(this._main, 'wide');
		else
			removecss(this._main, 'wide');

		if (w>1150 && w<1800)
			addcss(this._main, 'fixed');
		else
			removecss(this._main, 'fixed');

	}
};
