_me = frm_main.prototype;
function frm_main(){};
frm_main.recent_sorted = false;

_me.__constructor = async function(bAlreadySynced)
{
	var me = this;

	this.__refreshFolderTimeout = {};

	this._main.setAttribute('selected', 'folder');

	//Always open system menu on Ctrl+Rclick
	gui._main.addEventListener('contextmenu', function(e){
		(e.ctrlKey || e.metaKey) && e.stopPropagation();
		return true;
	}, true);

	//Create TITLE object
	await this._create('title', 'obj_title');

	//Disable History buttons
	if ('onpopstate' in window && 'pushState' in history){
		window.onpopstate = function(){
			history.pushState(parseURL(), document.title, document.pathname);
			me.title._refresh(true);
		};
	}

	//Create focus management object
	await gui._create('focus','obj_focus');

	//Create DRAG AND DROP
	await storage.library('dragndrop');
	this.dnd = new cDnD();

	if (!Is.Defined(gui._REQUEST_VARS['mailto']) && !gui._REQUEST_VARS['cc'] && !gui._REQUEST_VARS['bcc']){

		//Create SOUND object
		this.sound = await gui._create('sound','obj_sound');
		this.audio = await gui._create('audio','obj_audio');

		//Create global print object
		await gui._create('printer','obj_print');

		//Page leave confirmation dialog
		//Do not apply in debug mode
		window.onbeforeunload= function(e){
			if (typeof e.clientX == 'undefined' || e.clientX<0 || e.clientY<0){
				switch(GWOthers.getItem('LAYOUT_SETTINGS','confirm_exit').toString()){
				case '1':
					if (gui._getChildObjects('main','frm_compose').length<1)
						break;

				case '2':
					e.stopPropagation();
					e.preventDefault();

						//This is displayed on the dialog
					return getLang('CONFIRMATION::UNLOAD');
				}

				if (!e.explicitOriginalTarget || e.explicitOriginalTarget == document){
					//kill Connection Manager
					if (gui.connection)
						gui.connection._destruct();

					if (gui.frm_main){
						//kill IM
						if (gui.frm_main.im)
							gui.frm_main.im._destruct();

						//kill SIP
		                gui.frm_main.__onDestruct();
					}
				}
			}
		};
		window.onunload = function() {
			for(var i in Gui.__detachedWindows) {
				var detached = Gui.__detachedWindows[i];
				detached.onbeforeunload = false;
				detached.close();
			}
		};

		//WebSocket
		if (window.WebSocket){
			await gui._create('socket','obj_websocket');
			await gui.socket._create('api','obj_websocket_api');
			await gui._create('subscriber','obj_subscriber');

			if (!sPrimaryAccountGUEST)
				await gui.socket._create('xmpp','obj_websocket_xmpp');

			//Team Chat - Notifier
			var refresh_timeout;
			gui.socket.api._obeyEvent('onnotify', [function(aData){
				var folder, aFolders, aActive, i, fid, n;
				//Documents Notification
				if (GWOthers.getItem('CHAT','visual_notify') == '1' && (aData['ORIGINATOR-EMAIL'] || aData.EMAIL) !== sPrimaryAccount && aData['ITEM-TYPE'] === 'F' && aData['FOLDER-TYPE'] == 'F' && aData['TYPE'] === 'item' && ~['update', 'add'].indexOf(aData.ACTION)) {
					return;
				}

				//Teamchat Notification
				if (aData.EMAIL && aData.ACTION){

					if (aData['FOLDER-TYPE'] === 'N' && gui.frm_main._dashboardLoaded()) {
						gui.frm_main.dashboard.frame._postMessage({
							event: 'websocket',
							data: aData
						});
					}

					if (aData.EMAIL != sPrimaryAccount && (
						'folder' === aData.TYPE || // Case when new room is created by another user
						'acl' == aData.TYPE || // Access room change
						('item' === aData.TYPE && 'W' === aData['ITEM-TYPE'] && aData.ACTION === 'add') // Case when invitation to private room is sent (must be treated as creation of new public room)
					)){
						switch(aData.ACTION){
							case 'delete':
							case 'update':
							case 'add':
								refresh_timeout && clearTimeout(refresh_timeout);
								refresh_timeout = setTimeout(function() {
									WMAccounts.refresh({'aid':sPrimaryAccount},'folders', undefined, [me, me.__newTeamchatRoomCallback, [aData]]);
								}, 1000);
								break;

							case 'accessed':
								if (aData['ORIGINATOR-EMAIL'] !== sPrimaryAccount) {
									break;
								}

								folder = Path.slash(aData.FOLDER);
								aFolders = dataSet.get('folders',[sPrimaryAccount]);
								aActive = Path.split(dataSet.get('active_folder'));

								for(fid in aFolders) {
									if (aFolders[fid].OWNER == aData.EMAIL && aFolders[fid].RELATIVE_PATH == folder){

										if (!aFolders[fid].SYNC || aFolders[fid].SYNC === '0'){
											return;
										}

										dataSet.add('folders', [sPrimaryAccount, fid, 'RECENT'], '0');

										var r = false;
										for (n in aFolders) {
											if (aFolders[n].TYPE == 'I' && aFolders[n].SYNC && parseInt(aFolders[n].RECENT)) {
												r = true;
											}
										}
										me.filter._recent('I', r &&' ');

										break;
									}
								}
							}
					}
					else
					if (aData['FOLDER-TYPE'] == 'I' && aData.FOLDER) {
						if (aData.ACTION.indexOf('reaction') === 0) {
							return;
						}
						folder = Path.slash(aData.FOLDER);
						aFolders = dataSet.get('folders', [sPrimaryAccount]);

						for(i in aFolders) {
							if (aFolders[i].OWNER === aData.EMAIL && aFolders[i].RELATIVE_PATH === folder) {
								if (!aFolders[i].SYNC || aFolders[i].SYNC === '0'){
									return;
								}
								fid = i;
								break;
							}
						}

						if (!fid) {
							return;
						}

						if (aData.COMEVNID) {
							if (WMChat.thread.has(aData.COMEVNID)) {
								return;
							}
							if (me.rslide && me.rslide._value() !== 'threads' && aData.COMISFOLLOWED == '1') {
								me.stat._unread('threads', true);
							}

							if (dataSet.get('folders', [sPrimaryAccount, fid, 'AUTOFOLLOW']) == '1') {
								return;
							}
						}
						var sType = 'teamchat';
						switch(aData['ITEM-TYPE']){
						case 'F':
							sType = 'document_' + (aData.ACTION === 'add' ? 'added' : 'edited');

						case 'I':
						case 'W':
						case 'Y':
						case 'Q':
						case 'S':
							//Recent +1
							folder = Path.slash(aData.FOLDER);
							aActive = Path.split(dataSet.get('active_folder'));

							if (aData['ORIGINATOR-EMAIL'] !== sPrimaryAccount) {
								if ((aActive[0] == sPrimaryAccount) && (aActive[1] == fid) && me.main.tabs.room._isActive && me.main.__current.filter === 'room') {
									i = 0;
								} else {
									i = parseInt(aFolders[fid].RECENT || 0) + 1;
									me.filter._recent('I', ' ');
								}

								dataSet.add('folders', [sPrimaryAccount, fid, 'RECENT'], i.toString());
							}

							me.__addTeamchatFolderToRecent(fid);

							dataSet.add('folders', [sPrimaryAccount, fid, 'GROUPCHAT_LASTACTIVITY'], Math.floor(new Date().getTime() / 1000).toString());

							//Notifications
							if (aData['ORIGINATOR-EMAIL'] !== sPrimaryAccount && aData.EMAIL !== sPrimaryAccount && dataSet.get('folders', [sPrimaryAccount, fid, 'NOTIFY']) == '1' && (aData.TITLE || aData.BODY || '').indexOf('/') !== 0){

								if (!WMChat.room.has(WMChat.getFid(folder)) || !gui.__focus){

									//Visual (Message only)
									if (GWOthers.getItem('CHAT','visual_notify')>'0'){

										gui.notifier._value({
											type: sType,
											save: true,
											args: { data: aData, text: aData.BODY || aData.TITLE },
											//group: 'teamchat_' + folder,
											timeout: 5000,
											aHandler: [function(aData){

												fid = WMChat.getFid(aData.FOLDER);
												folder = dataSet.get('folders',[sPrimaryAccount, fid]);

												if (folder){
													if (aData.COMEVNID) {
														return me._openTeamchatThread({
															aid: sPrimaryAccount,
															fid: fid,
															iid: WMItems.__clientID(aData.COMEVNID)
														});
													}
													me.filter.__filter('I', false, true);
													me._selectView({aid:sPrimaryAccount, fid:fid});
												}

											}, [aData]]
										});
									}

									//Sound
									if (GWOthers.getItem('CHAT','sound_notify')>'0' && me.sound){
										me.sound._play('chat');
									}
								}

							}
						}
					}
					else
					if (aData.FOLDER && aData.ITEM && ~['F', 'I', 'Y'].indexOf(aData['FOLDER-TYPE'])) {
						folder = Path.slash(aData.FOLDER);
						aFolders = dataSet.get('folders',[sPrimaryAccount]);
						fid = null;

						for(i in aFolders) {
							if ((aFolders[i].OWNER || sPrimaryAccount) == aData.EMAIL && aFolders[i].RELATIVE_PATH == folder){
								fid = i;
								break;
							}
						}

						var ds;
						if(fid && (ds = dataSet.get('items', [sPrimaryAccount, fid, WMItems.__clientID(aData.ITEM)]))) {
							var bUpdate = false;
							switch (aData.ACTION) {
							case "lock":
								ds.EVNLOCKOWN_EMAIL = aData['ORIGINATOR-EMAIL'];
								ds.EVNLOCKOWN_ID = aData['ORIGINATOR-ID'];
								bUpdate = true;
								break;

							case "unlock":
								ds.EVNLOCKOWN_EMAIL = sPrimaryAccount;
								ds.EVNLOCKOWN_ID = '';
								bUpdate = true;
								break;

							case "start_edit":
							case "join_edit":
							case "stop_edit":
							case "edit_session_finished":
								// ds.EVN_DOCUMENTEDITINGINFO = aData.BODY;
								bUpdate = true;
								break;

							case "update":
							case "add":
								if (aData.TIME>0){
									ds.EVN_MODIFIED = aData.TIME;
									bUpdate = true;
								}
							}

							if (bUpdate){
								dataSet.update('items', [sPrimaryAccount, fid, WMItems.__clientID(aData.ITEM)]);
							}
						}
					}
					else
					//update for inbox
					if (aData.SERVICE === 'SMTP' && /*aData.EMAIL === sPrimaryAccount && */aData.ACTION === 'add'){
						var new_mail = dataSet.get('temp', ['new_mail']) || {};
						folder = Path.slash(aData.FOLDER);
						var sFolder = folder;
						if (aData.EMAIL !== sPrimaryAccount) {
							sFolder = sPrimaryAccountSPREFIX + aData.EMAIL + '/' + folder;
						}
						new_mail[sFolder] = new_mail[sFolder] || [];
						new_mail[sFolder].push({
							from: aData['ORIGINATOR-NAME'] || aData['ORIGINATOR-EMAIL'],
							subject: aData.BODY
						});
						dataSet.add('temp', ['new_mail'], new_mail, true);

						aFolders = dataSet.get('folders',[sPrimaryAccount]);
						for(i in aFolders) {
							if (((aFolders[i].OWNER || sPrimaryAccount) == aData.EMAIL && aFolders[i].RELATIVE_PATH === folder) || (i === sFolder)){
								fid = i;
								break;
							}
						}
						if (!fid) {
							return;
						}

						me.__refreshFolderTimeout[folder] = me.__refreshFolderTimeout[folder] || setTimeout(function() {
							delete me.__refreshFolderTimeout[folder];

							WMFolders.sync({ aid: sPrimaryAccount, fid: fid }, 'folders', '', [me, '_refreshItems', [sPrimaryAccount]]);
						}, Math.max(Math.random() * 30000, 10000));
					}
					else { // refresh items
						if (!gui.frm_main.main || !gui.frm_main.main.list) {
							return;
						}

						folder = Path.slash(aData.FOLDER);
						aFolders = dataSet.get('folders',[sPrimaryAccount]);

						for(i in aFolders) {
							if (((aFolders[i].OWNER || sPrimaryAccount) == aData.EMAIL && aFolders[i].RELATIVE_PATH === folder) || (i === (sPrimaryAccountSPREFIX + aData.EMAIL + '/' + folder))){
								fid = i;
								break;
							}
						}
						if (fid && (dataSet.get('current_folder') === (sPrimaryAccount + '/' + fid)) && (aData['ORIGINATOR-DEVICEID'] !== dataSet.get('main', ['device_id']))) {
							me.__refreshFolderTimeout[folder] = me.__refreshFolderTimeout[folder] || setTimeout(function() {
								delete me.__refreshFolderTimeout[folder];
								if (!gui.frm_main.main || !gui.frm_main.main.list) {
									return;
								}
								gui.frm_main.main.list._serverSort(void 0, void 0, void 0, void 0, void 0, true, true);
							}, Math.max(Math.random() * 60000, 30000));
						}
					}
				}

			}]);
		}
	}

	// load libraries
	await storage.library('class_folder');
	await storage.library('class_item');
	await storage.library('class_items_recover_helper');
	await storage.library('class_old_message');
	await storage.library('class_new_message');

	//Synchro-set folders dataset
	var aAccounts = dataSet.get('accounts');
	this.__goNextCount = 0;
	for (var sAccId in aAccounts)
		if (aAccounts[sAccId])
			if (aAccounts[sAccId]['PRIMARY']){
				if (!bAlreadySynced)
					dataSet.add('folders',[sAccId], (await WMAccounts.refresh({'aid':sAccId}))[sAccId]);
			}
			else
			if ((GWOthers.getItem('RESTRICTIONS','disable_otheraccounts') || 0)<1 || aAccounts[sAccId].TYPE == 'rss'){
				this.__goNextCount++;
				WMFolders.list({'aid':sAccId},'folders',[sAccId],[this,'_goNext']);
			}

	//Telemetry
	if (sPrimaryTelemetry){
		await storage.library('telemetry');
		await gui._create('telemetry','telemetry');
	}

	//Continue...
	if (!this.__goNextCount)
		this.__constructor2();
};

_me.__prepareTopBanner = function () {
	var top_type = GWOthers.getItem('BANNER_OPTIONS', 'top_type');
	var banner = document.getElementById('banner-container');
	switch(top_type){
		case 'url':
			var top_url = GWOthers.getItem('BANNER_OPTIONS', 'top_url');
			if (top_url){
				banner.style.backgroundImage = 'url(' + top_url + ')';
				var top_link = GWOthers.getItem('BANNER_OPTIONS', 'top_link');
				if (top_link){
					banner.setAttribute('href', top_link);
				}
				banner.removeAttribute('hidden');
			}
			break;

		case 'code':
			var bAdSense = GWOthers.getItem('RESTRICTIONS', 'enable_adsense'),
				customer_id = GWOthers.getItem('BANNER_OPTIONS', 'customer_id'),
				top_code = GWOthers.getItem('BANNER_OPTIONS', 'top_code');

			if (bAdSense && customer_id && top_code){

				(window.adsbygoogle = window.adsbygoogle || []).push({});
				if (!document.getElementById('adsbygoogle')) {
					var script = mkElement('script', {
						id: 'adsbygoogle',
						type: 'text/javascript',
						src: "//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"
					});
					document.head.appendChild(script);
				}

				banner.appendChild(mkElement('ins', {
					'class': 'adsbygoogle',
					'data-ad-client': customer_id.trim(),
					'data-ad-slot': top_code
				}));
				banner.removeAttribute('hidden');
			}
	}
};

_me._goNext = function(){
	this.__goNextCount--;
	if (!this.__goNextCount)
		this.__constructor2();
};

_me.__constructor2 = async function (){
	var me = this;

	//Drop File, registr Events
	if (window.FormData){
		this.__dropzones = [];
		this.__dragtimer = null;
		this.__filedrag = true;

		document.addEventListener("dragover", function(e){
			if (me.__filedrag){

				e.preventDefault();

				if (me.__dragtimer == null) {
					me.__file_dragover(e);
				} else {
					clearTimeout(me.__dragtimer);
				}

				me.__dragtimer = setTimeout(function(){
					me.__dragtimer = null;
					me.__file_dragover(false);
				}, 500);
			}
		}, false);

		document.addEventListener("drop", function(e){
			me.__file_dragover(false);
			if (me.__filedrag) {
				e.preventDefault();
			}
		}, false);

		document.addEventListener("dragstart", function(){
			me.__filedrag = false;
		}, true);
		document.addEventListener("dragend", function(){
			me.__filedrag = true;
		}, true);
	}

	//// Auto-Compose - Mailto parametr ////
	if (Is.Defined(gui._REQUEST_VARS['mailto']) || gui._REQUEST_VARS['cc'] || gui._REQUEST_VARS['bcc']){

		var head = {
			to:unescape(gui._REQUEST_VARS['mailto'] || ''),
			subject:unescape(gui._REQUEST_VARS['subject'] || ''),
			cc:unescape(gui._REQUEST_VARS['cc'] || ''),
			bcc:unescape(gui._REQUEST_VARS['bcc'] || ''),
			mailBody:unescape(gui._REQUEST_VARS['body'] || '')
		};

		var frm = await NewMessage.compose(head);
		frm._maximize();
		frm._resizable(false);
		frm._dockable(false);
		frm._onclose = function(b){
			if (b)
				self.close();

			return false;
		};

		frm._obeyEvent('onhide',[async function(){
			if (!gui.loader)
				await gui._create('loader','obj_loader');

			gui.loader._value(getLang('COMMON::SENDING'));
		}]);

		frm._obeyEvent('onshow',[function(){
			if (gui.loader)
				gui.loader._destruct();
		}]);

		frm._obeyEvent('onsend',[function(){
			addcss(gui.loader._main,'alert');
			gui.loader._value(getLang('MESSAGE::CLOSE_WINDOW'));
			self.close();
		}]);

		return;
	}

	//Preload TAGs
	await this._loadTags(true);



	//COOKIE FILTERING, remove all
	// 2Do, include: rights, tree
	var aFolders = dataSet.get('folders','',true),
		aItems = Cookie.get(['folders']);
	if (typeof aItems == 'object'){
		for(var aid in aItems){
			if (!aFolders[aid]){
				Cookie.set(['folders',aid],'');
			}
			else
			for(var fid in aItems[aid])
				if (!aFolders[aid][fid])
					Cookie.set(['rights',aid,fid],'');
		}
	}

	//FILTER RIGHTS
	var	aRights = Cookie.get(['rights']);
	if (typeof aRights == 'object'){
		for(var sAccId in aRights){

			if (!aFolders[sAccId]){
				Cookie.set(['rights',sAccId],'');
				continue;
			}

			for(var sFolId in aRights[sAccId]){
				if (!aFolders[sAccId][sFolId])
					Cookie.set(['rights',sAccId,sFolId],'');
			}
		}
	}
	Cookie.get(['rights',sAccId,sFolId],'');


	//FILTER VIEWS
	if (typeof Cookie.get(['views']) == 'object')
		Cookie.set(['views']);


	//FILTER TREE NODES
	var aTree = Cookie.get(['tree']);
	if (Is.Array(aTree) && aTree.length){
		Cookie.set(['tree'], aTree.filter(function(v){

			if (v.indexOf('other/') === 0){
				v = v.substring(6);
			}

			var p = Path.split(v, true);

			if (p.fid.length){

				//check for subdirs
				var bSub = false;
				for(var f in aFolders[p.aid])
					if (f != p.fid && f.indexOf(p.fid + '/') == 0){
						bSub = true;
						break;
					}

				return bSub && aFolders[p.aid] && (aFolders[p.aid][p.fid] || p.fid!='SPAM_QUEUE' || p.fid!='__@@VIRTUAL@@__');
			}
			else
			if (p.aid === 'root::other'){
				return true;
			}
			else
			if (p.aid){
				return aFolders[p.aid];
			}
		}));
	}

	this._gui._main.classList.toggle('allow-blurred-background', GWOthers.getItem('LAYOUT_SETTINGS', 'blurred_background') == 1);

	await this._draw('frm_main');

	this._create('search', 'obj_search', 'menu2');
	this._create('dashboard', 'frm_dashboard', 'main', '', [this, '__constructor3']);

	this._getAnchor('main').addEventListener('scroll', function(e) {
		e.target.scrollLeft = 0;
		e.target.scrollTop = 0;
	});
};

_me.__constructor3 = async function(bLoaded) {
	if (this.__initialized && (bLoaded || (bLoaded === false))) {
		if (!this.__fullyLoadedDashboard) {
			this.__setActiveFolder(bLoaded);
		}
		return;
	}

	this.__initialized = true;

	if (!Intl.Segmenter) {
		await storage.library('IntlSegmenterPolyfill', 'IntlSegmenterPolyfill');
		Intl.Segmenter = await IntlSegmenterPolyfillBundled.createIntlSegmenterPolyfill();
	}

	var me = this;

	this.dock._onchange = function(b){
		(b ? addcss : removecss)(me._main, 'dock');
	};

	this._getAnchor('box').onscroll = function(e) {
		e.preventDefault();
		this.scrollTop = 0;
	};

	//Upload document (for contextmenu)
	await this._create('upload','obj_upload');
	this.upload._onuploadend = function () {
		var active_folder = this.__active_folder || Path.split(dataSet.get('active_folder'));
		var aFolder = {
			aid: active_folder[0],
			fid: active_folder[1]
		};
		var aRights = WMFolders.getRights({ aid: active_folder[0], fid: active_folder[1] }),
			aAccess = WMFolders.getAccess({ aid: active_folder[0], fid: active_folder[1] });

		if(WMFolders.getType(aFolder) !== 'F' || !(aRights.owner || aAccess.write)) {
			aFolder = {
				aid: sPrimaryAccount,
				fid: Mapping.getDefaultFolderForGWType('F')
			};
		}

		if (this._destructed)
			return;

		var v = this._getAddon();

		if (v && v.length && aFolder) {
			var now = new IcewarpDate();
			var aValues = {
				values: {
					EVNSHARETYPE: GWOthers.getItem('DEFAULT_CALENDAR_SETTINGS', 'file_sharing'),
					EVNSTARTDATE: now.format(IcewarpDate.JULIAN),
					EVNSTARTTIME: now.hour() * 60 + now.minute()
				},
				ATTACHMENTS: v
			};

			WMItems.add([aFolder.aid, aFolder.fid], aValues, '', '', '', [
				function (aResponse, aData) {
					if (aResponse === true) {
						Item.__refreshView([aFolder.aid, aFolder.fid], true);
						(Array.isArray(aData) ? aData : [aData]).forEach(function (aData, index) {
							gui.__exeEvent('onuploadcommit', { id: v[index].values.fullpath.split('/').pop(), data: aData, context: this });
						});
						// gui.notifier._value({type: 'item_saved', args: [aFolder.aid, aFolder.fid]});
					}
				}.bind(this)
			]);

			this._reset();
		}
	};

	/*** FOLDER PICKER ***/
	await this._createFolderPicker();

	/*** SET LAYOUT SIZE ***/
	this._changeViewSize(GWOthers.getItem('LAYOUT_SETTINGS', 'compact_view') || "0", true);

	/*** TOP MENU ***/
	if (!sPrimaryAccountGUEST) {
		await this._create('new', 'obj_button', 'menu1', 'simple color1 border new ico ico2 select add');
		this.new._value('MAIN_MENU::NEW');
		this.new._onclick = async function(e) {
			if (gui.frm_favorites) {
				gui.frm_favorites._destruct();
			}
			if (gui.frm_new_item) {
				return gui.frm_new_item._destruct();
			}

			me.new._main.classList.add('active');

			var context = await gui._create('frm_new_item', 'frm_new_item');
			var offset = gui.frm_main.filter._main.clientWidth;
			var bannerHeight = (gui.banner._main || {}).clientHeight || 0;
			if (gui._rtl) {
				context._place(document.body.clientWidth - context._main.clientWidth - (7 + offset), 64 + bannerHeight);
			} else {
				context._place(offset - 7, 64 + bannerHeight);
			}
			context._add_destructor('__onDestruct');
			context.__onDestruct = function() {
				me.new._main.classList.remove('active');
			};

			e.preventDefault();
			e.stopPropagation();
		};
		frm_new_item.bindShortcuts();
	}

	await this._create('favorites', 'obj_button', 'menu1', 'simple color1 border favorites ico ico2 select');
	this.favorites._value('FAVORITES::FAVORITES');
	this.favorites._onclick = async function(e) {
		if (gui.frm_new_item) {
			gui.frm_new_item._destruct();
		}
		if (gui.frm_favorites) {
			return gui.frm_favorites._destruct();
		}

		me.favorites._main.classList.add('active');

		var context = await gui._create('frm_favorites', 'frm_favorites');
		var bannerHeight = (gui.banner._main || {}).clientHeight || 0;
		if (gui._rtl) {
			context._place(document.body.clientWidth - context._main.clientWidth - 81, 64 + bannerHeight);
		} else {
			context._place(51, 64 + bannerHeight);
		}
		context._add_destructor('__onDestruct');
		context.__onDestruct = function() {
			me.favorites._main.classList.remove('active');
		};

		e && e.preventDefault();
		e && e.stopPropagation();
	};
	this.favorites._ondrop = function(v) {
		if (gui.frm_favorites) {
			gui.frm_favorites._destruct();
		}

		if (v.type == 'folder' || v.type == 'virtual_folder') {
			WMFolders.addToFavorites(v.value[0]);
		}

		me.favorites._main.classList.remove('dnd');
	}.bind(this);

	var favorites_timeout;
	this.favorites._ondragover = function(aData) {
		me.favorites._main.classList.add('dnd');
		if ((aData || {}).type === 'item') {
			favorites_timeout = favorites_timeout || setTimeout(function() {
				if (!gui.frm_favorites) {
					me.favorites._onclick();
				}
			}, 250);
		}
	};
	this.favorites._ondragout = function() {
		me.favorites._main.classList.remove('dnd');
		me.favorites._onclick();
		clearTimeout(favorites_timeout);
		favorites_timeout = false;
	};
	gui.frm_main.dnd.registr_drop(this.favorites, ['folder', 'virtual_folder', 'item']);

	/*** TOP TOOLBAR ***/
	await this._create('toolbar','obj_hmenu_toolbar','toolbar1','transparent', true);

	//// logout ////
	await this._create('stat','obj_hmenu_status','menu3');

	//// resize interface ////
	this._initResize();

	// Right Pane ////
	await this._create('rslide','obj_slide','right');
	this.rslide._onchange = function(){
		gui.frm_main._rightDock(this._value());
	};

	await this.rslide._create('chatgpt', 'obj_rdock_chatgpt');
	await this.rslide._create('chatgpt_conversation', 'obj_rdock_chatgpt_conversation');
	gui._obeyEvent('chatgptChanged', [function() {
		if (!dataSet.get('chatgpt') && ~['chatgpt', 'chatgpt_conversation'].indexOf(me.rslide._value())) {
			gui.frm_main._rightDock('threads');
		}
	}]);

	/// TEAMCHAT ///
	if (sPrimaryAccountCHAT){
		await this.rslide._create('thread','obj_rdock_thread');
		await this.rslide._create('threads','obj_rdock_threads');
	}

	/// IM ///
	if (window.sPrimaryAccountIM && (GWOthers.getItem('RESTRICTIONS', 'disable_im') || 0)<1 && (!TeamChatAPI || !TeamChatAPI.teamChatOnly())) {
		// Create IM object & link it to the frm_main
		await this.rslide._create('im','obj_rdock_im')
		this.im = this.rslide.im.im;

		//IM Autologin performed by obj_im constructor
		//Show IM dock action performed by obj_hmenu_status
	}

	/// CALENDAR ///
	var rst = GWOthers.getItem('RESTRICTIONS', 'disable_gw_types') || '';
	if (!sPrimaryAccountGUEST && sPrimaryAccountGW && !TeamChatAPI.teamChatOnly() && (!rst || !~rst.indexOf('e'))){
		await this.rslide._create('calendar','obj_rdock_calendar');
	}

	/// UPLOAD ///
	if (!~(GWOthers.getItem('RESTRICTIONS', 'disable_gw_types') || '').indexOf('f')) {
		await this.rslide._create('upload','obj_rdock_upload');
	}
	await this.rslide._create('upload_detail','obj_rdock_upload_detail');

	var slideCookie = Cookie.get(['rdock']) || false;
	if (!TeamChatAPI || !TeamChatAPI.teamChatOnly()) {
		/// Settings ///
		await this.rslide._create('settings','obj_rdock_settings');
		if (~['chatgpt', 'chatgpt_conversation'].indexOf(slideCookie) && !dataSet.get('chatgpt')) {
			slideCookie = 'threads';
		}
		this.rslide._value(slideCookie);
	} else {
		this.rslide._value('threads');
	}

	//// Auto-Start SIP ////
	if (window.sPrimaryAccountSIP && (GWOthers.getItem('RESTRICTIONS', 'disable_sip') || 0)<1) {
		//SIP Autologin
		if (GWOthers.getItem('SIP','mode')=='integrate' && GWOthers.getItem('SIP','start')>0)
			this.__sipAutoLogin = setTimeout(function(){
				if (me && GWOthers.getItem('SIP','start')>0 && !me.sip)
					me._create('sip','obj_sip');
			},GWOthers.getItem('SIP','webrtc')==1 ? 2000 : 15000);
	}

		// [ASync] Refresh after login
	if (oWM_INIT && !oWM_INIT.__refreshed)
		this._getNew(false, true);

	var getNewTime = +new Date();
	setInterval(function() {
		var iRefresh = parseInt(GWOthers.getItem('MAIL_SETTINGS_GENERAL', 'autoupdate_minutes'), 10);
		if (+new Date() > getNewTime + (iRefresh * 60000)) {
			this._getNew();
			getNewTime = +new Date();
		}
	}.bind(this), 10000);

	this.__onlineHandler();
	gui._obeyEvent('online', [this, '__onlineHandler']);
	gui._obeyEvent('offline', [this, '__offlineHandler']);

	//Add destructor because of SIP
	this._add_destructor('__onDestruct');

	//// Reminders ////
	if (sPrimaryAccountGW){
		this.__RMN_get();
		this.__rmnInterval1 = setInterval(function(){ me.__RMN_get() },600000);
		// check reminders every 60 seconds
		this.__rmnInterval2 = setInterval(function(){ me.__RMN_check() },20000);
	}

	//// Activity Monitoring
	if (GWOthers.getItem('LAYOUT_SETTINGS','activity')>0 && !gui._REQUEST_VARS['tconly']){
		var activity_last = new IcewarpDate(),
			activity_time = parseInt(GWOthers.getItem('LAYOUT_SETTINGS','activity'),10);
		activity_time = (activity_time>2?activity_time:2)*60;

		this.__activity = function(){
			activity_last = new IcewarpDate();
		};

		//Bind events
		gui._obeyEvent('click',[this,'__activity']);
		gui._obeyEvent('mousemove',[this,'__activity']);
		gui._obeyEvent('focus',[this,'__activity']);

		//Check for Activity
		setInterval(function(){
			if ((new IcewarpDate()).unix() - activity_last.unix()>activity_time)
				me.__logout(true);
		}, 10000);
	}

	function setupWizard(){
		// every time there will be change in setup wizard and we want to show it to the user, increase the version below
		var wizard_version = '1';

		if (sPrimaryAccountGUEST) {
			return;
		}

		var version = (GWOthers.getItem('LOGIN_SETTINGS', 'version') || '').split('.').slice(0, 3).join('.');
		var wrongVersion = version !== Cookie.get(['setupwizard']) && wizard_version !== Cookie.get(['setupwizard_version']);

		// skip wizard for users from 14+ versions
		if ((Cookie.get(['setupwizard']) || '').split('.')[0] == 14 && wizard_version == 1 && !Cookie.get(['setupwizard_version'])) {
			wrongVersion = false;
		}

		//Check mandatory pages
		var aPages = [], sPage;
		if (!GWOthers.getItem('LAYOUT_SETTINGS', 'disable_wizards') && wrongVersion) {
			aPages = ['pair', 'device', 'mobile', 'app'];
		};

		//2FA & Altmail
		if (sPrimaryAccount2F && (GWOthers.getItem('LAYOUT_SETTINGS','require_2fa') == '1' && !sPrimaryAccount2FE)/* || !Is.Email(dataSet.get('accounts',[sPrimaryAccount,'ALTERNATIVE']))*/){
			sPage = 'security';
			aPages.push('security');
		}

		// backup
		if (GWOthers.getItem('CUSTOM_BACKUP_FORM', 'enabled') == '1' && GWOthers.getItem('CUSTOM_BACKUP_FORM', 'DO_NOT_ASK_AGAIN') !== 'true') {
			var repeat_after_logins = +GWOthers.getItem('CUSTOM_BACKUP_FORM', 'REPEAT_AFTER_LOGINS');
			var repeat_after_logins_user = GWOthers.getItem('CUSTOM_BACKUP_FORM', 'REPEAT_AFTER_LOGINS_USER');
			var repeat_after_days = GWOthers.getItem('CUSTOM_BACKUP_FORM', 'REPEAT_AFTER_DAYS');
			var repeat_after_displayed_on = GWOthers.getItem('CUSTOM_BACKUP_FORM', 'REPEAT_AFTER_DISPLAYED_ON');

			if (
				dataSet.get('accounts', [sPrimaryAccount, 'CUSTOMBACKUP']) == 0 && (
					( repeat_after_logins && repeat_after_logins_user === void 0 ) ||
					( repeat_after_days && repeat_after_displayed_on === void 0 ) ||
					( repeat_after_logins_user !== void 0 && repeat_after_logins_user < 1 ) ||
					(
						repeat_after_days !== void 0 && repeat_after_displayed_on &&
						new IcewarpDate(repeat_after_displayed_on).add(repeat_after_days, 'days').isBefore(new IcewarpDate(), 'day')
					)
				)
			) {
				sPage = 'backup';
				aPages.push('backup');
			}

			if (repeat_after_logins_user) {
				GWOthers.setItem('CUSTOM_BACKUP_FORM', 'REPEAT_AFTER_LOGINS_USER', repeat_after_logins_user - 1);
				GWOthers.save();
			}
		}

		if (GWOthers.getItem('LAYOUT_SETTINGS', 'disable_wizards') == 1 && !~aPages.indexOf('backup') && !~aPages.indexOf('security')) {
			return;
		}

		//vCard
		WMItems.list({aid:sPrimaryAccount, fid:'@@mycard@@', iid:'@@mycard@@'},'','','',[function(aData){
			if (Is.Object(aData) && (aData = aData[sPrimaryAccount]) && (aData = aData['@@mycard@@'])){
				for(var id in aData){
					if (id.charAt(0) == '*'){
						//full name
						var phone = '',
							fullname = createNameFromLocation(aData[id]);

						//phone
						if (aData[id].LOCATIONS){
							var loc;
							for(var i in aData[id].LOCATIONS){
								loc = aData[id].LOCATIONS[i].values;
								if (loc.LCTTYPE == 'H'){
									phone = loc.LCTPHNMOBILE || '';
									break;
								}
							}
						}

						break;
					}
				}
			}

			if (!GWOthers.getItem('LAYOUT_SETTINGS', 'disable_wizards') && (!phone || !fullname) && wrongVersion) {
				sPage = 'intro';
				aPages.push('personal');
			}

			if (aPages.length || wrongVersion) {
				aPages.push('finish');
				gui._create('frm_setupwizard','frm_setupwizard','','', sPage, aPages, false, wizard_version);
			}
		}]);

	};

	// Expired Account warning check
	if (dataSet.get('accounts',[sPrimaryAccount,'PASSEXPIRED']))
		gui._create('expired','frm_changepass','','', [setupWizard] ,true);
	// Show What's New popup if not disabled or already shown for this version
	else {
		setupWizard();
	}

	// Force user to enter personal data if set by admin
	if (GWOthers.getItem('RESTRICTIONS','mandatory_user_info') == '1' && Cookie.get(['suppressmandatory'])!=1) {
		Item.openwindow([sPrimaryAccount, '@@mycard@@','@@mycard@@'], '', '', 'C', null, [
			function(frm){
				frm._closable(false);
				frm._modal(true);
				frm._title("POPUP_ITEMS::MANDATORYDETAILS");

				// Strict checking of fields, no cancel
				if (GWOthers.getItem('GLOBAL_SETTINGS','mandatory_contact_fields')) {
					if (frm.x_btn_cancel)
						frm.x_btn_cancel._main.style.display = 'none';
				}
				else
					Cookie.set(['suppressmandatory'],1);
			}
		]);
	}


	//Handle "open" url parameter
	if (gui._REQUEST_VARS['open']){
		var sFolder = Path.basedir(gui._REQUEST_VARS['open']),
			sRID = WMItems.__clientID(Path.basename(gui._REQUEST_VARS['open']));

		if (sFolder && sRID){
			WMItems.list({aid:sPrimaryAccount, fid:sFolder, rid:sRID}, '','','',[function(aData){
				if (aData && (aData = aData[sPrimaryAccount]) && (aData = aData[sFolder])){
					for (var i in aData)
						if (aData[i].aid){

							var aPath = [sPrimaryAccount, sFolder, i];

							//M
							if (WMFolders.getType(aPath) == 'M'){
								//Draft
								if (GWOthers.getItem('DEFAULT_FOLDERS', 'drafts') == sPrimaryAccount+'/'+sFolder)
									OldMessage.edit(aPath);
								//Mail
								else
									OldMessage.openwindow(aPath);
							}
							//GW
							else
								Item.openwindow(aPath);

							break;
						}
				}
				else{
					//invalid path;
				}
			}]);
		}
		else{
			//invalid attr
		}
	}

	if (gui._REQUEST_VARS.telemetry)
		gui._create('frm_telemetry','frm_telemetry');

	//Registr Drop for Tree Auto-Expanding
	this.dnd.registr_drop(this, ['item','folder']);

	this.__prepareTopBanner();

	gui._obeyEvent('folderSelected', [this, '__select_handler',['folder']]);
	gui._obeyEvent('itemSelected', [this, '__select_handler',['item']]);

	//jitsi
	gui._create('jitsi', 'frm_jitsi', {
		first: true
	}, '');
	gui._obeyEvent('conference_started', [this, '_updateConferenceTopBar']);
	gui._obeyEvent('conference_ended', [this, '_updateConferenceTopBar']);

	window.addEventListener('beforeunload', function() {
		this.__saveAutoreopeningWindows(true);
	}.bind(this), false);
	this.__autoreopenClosedWindows();
	if (+GWOthers.getItem('LAYOUT_SETTINGS', 'autoreopen_windows')) {
		gui._obeyEvent('autoreopenArgs_updated', [this, '__saveAutoreopeningWindows']);
		setInterval(function() {
			this.__saveAutoreopeningWindows();
		}.bind(this), 60 * 1000);
	}

	var query = parseURL();
	if (query.ThreadID) {
		gui.frm_main._openTeamchatThread({
			aid: sPrimaryAccount,
			fid: query.RoomID.replace(/\\+/g, '/'),
			iid: WMItems.__clientID(query.ThreadID)
		});
	}

	this.__setActiveFolder(bLoaded);
};

_me.__setActiveFolder = function(bLoaded) {
	var aFolders = dataSet.get('folders','',true),
		oActiveFolder = {}, n;

	if (sPrimaryAccountGUEST || (window.TeamChatAPI && TeamChatAPI.teamChatOnly())){
		if (Cookie.get(['last']) && Cookie.get(['last']).I) {
			var parts = Path.split(Cookie.get(['last']).I, true);
			if (dataSet.get('folders', [parts.aid, parts.fid])) {
				oActiveFolder = parts;
			}
		}
		if (!oActiveFolder.fid) {
			for (n in aFolders[sPrimaryAccount])
				if (aFolders[sPrimaryAccount][n].TYPE == 'I') {
					oActiveFolder = {aid: sPrimaryAccount, fid: n};
					break;
				}
		}
	} else {
		oActiveFolder = Path.split(Cookie.get(['last_folder']), true);
		// var sFolderType = WMFolders.getType(oActiveFolder);
		var initial_page = GWOthers.getItem('LAYOUT_SETTINGS', 'initial_page');
		switch(initial_page) {
			case 'r':
				if (oActiveFolder && oActiveFolder.aid && oActiveFolder.fid && dataSet.get('folders', [oActiveFolder.aid, oActiveFolder.fid])) {
					break;
				}
			case 'h':
				if (bLoaded === false || dataSet.get('dashboard', ['config', 'dashboard_enabled']) === false) {
					oActiveFolder =  {aid: sPrimaryAccount, fid: 'INBOX'};
				} else {
					oActiveFolder =  {aid: sPrimaryAccount, fid: '__@@VIRTUAL@@__/__@@DASHBOARD@@__'};
				}
				break;

			default:
				oActiveFolder = {aid: sPrimaryAccount, fid: 'INBOX'};
		}
	}

	if (sPrimaryAccountCHAT) {
		var r, f = dataSet.get('folders',[sPrimaryAccount]);
		for (n in f) {
			if (f[n].TYPE == 'I' && f[n].SYNC && parseInt(f[n].RECENT)) {
				r = true;
			}
		}

		this.filter._recent('I', r && ' ');
	}

	var hash = location.hash && parseURL(location.hash.replace(/^#/, ''));
	if (hash && hash.channelID) {
		var channels = parseURL(atob(hash.channelID));
		
		var folders = dataSet.get('folders',[sPrimaryAccount]);
		for (var i in channels) {
			var channel = Path.slash(i);

			for (var fid in folders){
				if (folders[fid].TYPE == 'I' && folders[fid].RELATIVE_PATH == channel){
					oActiveFolder = {aid: sPrimaryAccount, fid: fid};
					break;
				}
			}
		}
	}

	var folderType = WMFolders.getType(oActiveFolder);
	if (bLoaded !== void 0 || !frm_dashboard.__apps.some(function(app) { return app.folderType === folderType; })) {
		this.__fullyLoadedDashboard = true;
		gui.preloader && gui.preloader._remove();
		gui.frm_main.filter.__filter(folderType, false, false, 100);
	}
};

_me.__onlineHandler = function() {
	if (this.__lastOnline && (+new Date() - this.__lastOnline) > 70000) {
		this.__forcedReload = true;
	}
	this.__lastOnline = +new Date();

	this.__lastOnlineTimeout = setTimeout(this.__onlineHandler.bind(this), 10000);
};

_me.__offlineHandler = function() {
	clearTimeout(this.__lastOnlineTimeout);
};

_me._openFolderPicker = function(bNoAnimation) {
	var sActiveFolder = dataSet.get('active_folder'),
		aPath = Path.split(sActiveFolder, true),
		sType = WMFolders.getType(aPath);

	if (sType === 'Y') {
		sType = 'I';
	}

	if (!+GWOthers.getItem('LAYOUT_SETTINGS', 'autohide_tree')) {
		Cookie.set(['hide_tree', sType], 0);
	}

	if (bNoAnimation) {
		this._main.classList.add('noTreeAnimation');
	}

	if (!this._folderPickerIsOpen()) {
		[].forEach.call(this.bar._main.querySelectorAll('.maxbox'), function(scroll) {
			scroll.scrollTop = 0;
		});
	}
	this._getAnchor('bar').scrollTop = 0;
	this.bar._main.removeAttribute('aria-hidden');

	this._main.classList.add('folder_tree_transition');
	this._getAnchor('bar').classList.remove('collapsed');
	this._getAnchor('main').ontransitionend = function() {
		this._main.classList.remove('folder_tree_transition');
	}.bind(this);

	this._main.classList.add('folder_tree_expanded');
	this.folderPicker._main.classList.add('active');
	this._getAnchor('slider').classList.add('show');

	if (sType === 'I') {
		this.filter._recent('I');
	}
	this.bar.search._focus();

	setTimeout(function() {
		this._main.classList.remove('noTreeAnimation');
	}.bind(this), 5);
};

_me._closeFolderPicker = function(bNoAnimation) {
	if (!this._folderPickerIsOpen()) {
		return;
	}
	var sActiveFolder = dataSet.get('active_folder'),
		aPath = Path.split(sActiveFolder, true),
		sType = WMFolders.getType(aPath);

	if (sType === 'Y') {
		sType = 'I';
	}
	if (sType === 'I') {
		return;
	}

	if (bNoAnimation) {
		this._main.classList.add('noTreeAnimation');
	}

	Cookie.set(['hide_tree', sType], 1);

	this._main.classList.add('folder_tree_transition');
	this._getAnchor('main').ontransitionend = function() {
		this._main.classList.remove('folder_tree_transition');
		this._getAnchor('bar').classList.add('collapsed');
	}.bind(this);

	this._main.classList.remove('folder_tree_expanded');
	this.folderPicker._main.classList.remove('active');
	this.bar._main.setAttribute('aria-hidden', '');
	this._getAnchor('slider').classList.remove('show');

	setTimeout(function() {
		this._main.classList.remove('noTreeAnimation');
	}.bind(this), 5);
};

_me._folderPickerIsOpen = function() {
	return this._main.classList.contains('folder_tree_expanded');
};

_me._createFolderPicker = async function () {
	var me = this;
	var folderPicker = await this._create('folderPicker', 'obj_button', 'bar', 'color4 rounded ico ico2 toggle select folders');

	folderPicker._unread = folderPicker._unread || folderPicker._main.appendChild(mkElement('div', {
		class: 'unread'
	}));
	folderPicker._onclick = function() {
		if (!this._folderPickerIsOpen()) {
			me._openFolderPicker();
		} else {
			me._closeFolderPicker(false, true);
			if (document.activeElement) {
				document.activeElement.blur();
			}
		}
	}.bind(this);
	
	await this._create('bar', 'obj_barmenu', 'bar', '', {
		toggleButton: folderPicker
	});

	document.addEventListener('click', function(e) {
		// clicked inside folder tree
		if (this._getAnchor('bar').contains(e.target) || !+GWOthers.getItem('LAYOUT_SETTINGS', 'autohide_tree') || (gui.cmenu && gui.cmenu._owner && this._getAnchor('bar').contains(gui.cmenu._owner._main) && gui.cmenu._main.contains(e.target)) || this._mouseup_bar) {
			return;
		}

		if (e.target.closest('.refresh')) {
			return;
		}

		var sActiveFolder = dataSet.get('active_folder'),
			aPath = Path.split(sActiveFolder, true),
			sType = WMFolders.getType(aPath);

		// clicked while in teamchat
		if (sType === 'I' || sType === 'Y') {
			return;
		}

		gui.frm_main._closeFolderPicker();
	}.bind(this), true);

	dataSet.on('active_folder', [], function() {
		var sActiveFolder = dataSet.get('active_folder'),
			aPath = Path.split(sActiveFolder, true),
			sType = WMFolders.getType(aPath);

		if (sType === 'Y') {
			sType = 'I';
		}

		this.folderPicker._main.classList[sType === 'I' ? 'remove' : 'add']('select');

		if (!+GWOthers.getItem('LAYOUT_SETTINGS', 'autohide_tree') || !Cookie.get(['hide_tree', sType])) {
			return;
		}
		this._closeFolderPicker();
	}, this);

	var sActiveFolder = dataSet.get('active_folder'),
		aPath = Path.split(sActiveFolder, true),
		sType = WMFolders.getType(aPath);
	if (Cookie.set(['hide_tree', sType])) {
		this._closeFolderPicker();
	}
};

_me.__saveAutoreopeningWindows = async function(bUnload) {
	var autoreopenWindows = {};
	try {
		autoreopenWindows = JSON.parse(localStorage.getItem('autoreopenWindows') || '{}') || {};
	} catch {
		//
	}

	if (!+GWOthers.getItem('LAYOUT_SETTINGS', 'autoreopen_windows')) {
		delete autoreopenWindows[sPrimaryAccount];
	} else {
		autoreopenWindows[sPrimaryAccount] = [];
		for (var obj of gui._getChildObjects().filter(function(obj) {
			return obj.__autoreopen;
		})) {
			try {
				obj._obeyEvent('destructed', [this, '__saveAutoreopeningWindows']);
				autoreopenWindows[sPrimaryAccount].push({
					type: obj._type,
					autoreopen: obj.__autoreopenArgs,
					position: obj.__position,
					docked: obj._docked,
					data: obj.__storeAutoreopenData ? await obj.__storeAutoreopenData(bUnload) : {}
				});
			} catch {
				//
			}
		}
	}
	try {
		localStorage.setItem('autoreopenWindows', JSON.stringify(autoreopenWindows));
	} catch {
		//
	}
};

_me.__autoreopenClosedWindows = function(){
	var userAutoreopenWindows,
		autoreopenWindows = {};
	try {
		autoreopenWindows = JSON.parse(localStorage.getItem('autoreopenWindows') || '{}') || {};
	} catch {
		//
	}
	userAutoreopenWindows = autoreopenWindows[sPrimaryAccount] || [];
	delete autoreopenWindows[sPrimaryAccount];
	localStorage.setItem('autoreopenWindows', JSON.stringify(autoreopenWindows));

	if(!+GWOthers.getItem('LAYOUT_SETTINGS', 'autoreopen_windows')) {
		return;
	}

	userAutoreopenWindows.forEach(async function(obj) {
		try {
			var new_window = await reopen.call(this, obj);
			Is.Function(new_window.__autoreopen) && setTimeout(function() {
				new_window.__autoreopen(obj.data);
			}, 5);
		} catch {
			//
		}
	}, this);

	async function reopen(obj) {
		var p = obj.position,
			fun = window[obj.autoreopen.context],
			context = fun;

		obj.autoreopen.fun.forEach(function(f) {
			fun = fun[f];
		});

		var new_window = await fun.apply(context, obj.autoreopen.args);

		new_window._place(p.x, p.y, p.w, p.h);
		if (p.max && !new_window.__position.max) {
			new_window._maximize(true);
		} else if (!p.max && new_window.__position.max) {
			new_window._maximize(false);
		}
		obj.docked && new_window._dock();

		new_window._obeyEvent('destructed', [this, '__saveAutoreopeningWindows']);
		return new_window;
	};
};

_me._updateConferenceTopBar = function(){
	gui._main.classList[dataSet.get('main', ['conference']) ? 'add' : 'remove']('conference_in_progress');
};

_me.__select_handler = function(aData,e,sType){
	if (sType !== 'item' || aData.length == 3)
		this._main.setAttribute('selected', sType);
};

_me._active_dropzone = function(){
	return false;
};

/**
 * SIP
 **/
_me._call = async function(n, bVideo, bExt, bScreen){

	if (n)
		//Direct Call over SIP
		if (!bExt && this.sip){
			if (dataSet.get('sip',['state']) == 'online')
				this.sip._call(n,bVideo,bScreen);
			else
				this.sip._login(async function(bOK){
					if(bOK)
						gui.frm_main.sip._call(n,bVideo,bScreen);
					else
						gui._create('alert', 'frm_alert', '', '', '', 'SIP::ERROR', 'SIP::REGISTRATION_FAILED');
				});
		}
		else
		//Open Dial, fill number and login to SIP
		if (!bExt && window.sPrimaryAccountSIP && (GWOthers.getItem('RESTRICTIONS', 'disable_sip') || 0)<1 && GWOthers.getItem('SIP', 'mode') == 'integrate'){
			this._create('sip','obj_sip','','',function(bOK){
				if(bOK)
					gui.frm_main.sip._call(n,bVideo,bScreen);
				else
					gui._create('alert', 'frm_alert', '', '', '', 'SIP::ERROR', 'SIP::REGISTRATION_FAILED');
			});
		}
		//Direct Call over External
		else{
			await storage.library('wm_messages');
			message.dial(n,[function(bOK){
		 		if (bOK && gui.notifier)
					gui.notifier._value({type: 'sip_external'});
			}]);
		}
};

/**
 * Load TAGs into DataSet
 **/
_me._loadTags = async function(bSynchro){
	if (sPrimaryAccountGW){
		if (bSynchro)
			this.__parseTags(await WMItems.list({aid:sPrimaryAccount,fid:'__@@TAGS@@__'}));
		else
			WMItems.list({aid:sPrimaryAccount,fid:'__@@TAGS@@__'},'','','',[this,'__parseTags']);
	}
};
_me.__parseTags = function(aData){
	var aOut = {};

	if (aData[sPrimaryAccount] && (aData = aData[sPrimaryAccount]['__@@TAGS@@__'])){

		delete aData['/'];
		delete aData['#'];
		delete aData['$'];
		delete aData['@'];

		var sColor;
		for (var i in aData)
			if (aData[i].TAGNAME){
				if (aData[i].TAGCOLOR)
					sColor = colors.fast_contrast(aData[i].TAGCOLOR);
				else
					sColor = '#000000';

				aOut[aData[i].TAGNAME] = {TAGNAME:aData[i].TAGNAME, TAGCOUNT:aData[i].TAGCOUNT, TAGCOLOR:aData[i].TAGCOLOR,TEXTCOLOR:sColor,ID:i};
			}
	}

	dataSet.add('tags','',aOut);
};

_me._changeViewSize = function(v, bNoSave) {
	document.body.classList.toggle('compact', +v != 0);

	if (!bNoSave && gui.frm_main.main && gui.frm_main.main.list)
		gui.frm_main.main.list._serverSort(void 0, void 0, void 0, void 0, void 0, true, true);
};

/**
	 * activate registred dropzones
	 * 28.6.2011 14:21:02
	 **/
_me.__file_dragover = function(e){

	for (var i = 0;i<this.__dropzones.length;i++)
	// Activate dropzone
		if (this.__dropzones[i] && !this.__dropzones[i]._destructed && this.__dropzones[i]._pathName && this.__dropzones[i]._showDropZone)
			this.__dropzones[i]._showDropZone(e);
		// Auto-Remove dropzone
		else {
			this.__dropzones.splice(i,1);
		}
};

/**
	 *	Registr obj with dropzone,
	 *	obj._showDropZone(e) metod of such object will be called by dragover event
	 *	28.6.2011 14:14:57
	 **/
_me._registr_dropzone = function(obj){
	if (obj && !obj._destructed && obj._showDropZone){
		for (var i = 0;i<this.__dropzones.length;i++)
			if(this.__dropzones[i]===obj) return true;

		this.__dropzones.push(obj);
		return true;
	}
	return false;
};

_me._remove_dropzone = function(obj){
	this.__dropzones = this.__dropzones || [];
	for (var i = 0;i<this.__dropzones.length;i++)
		if (this.__dropzones[i]===obj){
			this.__dropzones.splice(i,1);
			break;
		}
};

_me._title = function(sFolder,iSelected,iTotal){
	if (this.title){
		var sOut = '', aAccount, sPgTitle = GWOthers.getItem('LAYOUT_SETTINGS','title') || '';

		if ((aAccount = dataSet.get('accounts',[sPrimaryAccount]))){

			if (sFolder){
				sOut += sFolder;

				if (iTotal>0)
                	sOut += ' ['+(iSelected>0?iSelected+'/':'')+iTotal+']';

				sOut += ' - ';
			}

			this.title._add(sOut + (sPgTitle ? sPgTitle + ' - ' : '') + MailAddress.createEmail(aAccount.FULLNAME, sPrimaryAccountGUEST ? aAccount.USERNAME : sPrimaryAccount, true));
		}
	}
};


//Request for reminder list
_me.__RMN_get = function(){
	if(window.TeamChatAPI && TeamChatAPI.teamChatOnly()){
		return;
	}
	if (gui.__online){

		var iReminder = parseInt(Cookie.get(['reminders']),10),
			iDate = (new IcewarpDate()).format(IcewarpDate.JULIAN);

		if (!Is.Number(iReminder) || iReminder<iDate-7)
			iReminder = iDate-7;
		else
		if (iReminder>=iDate)
			iReminder = iDate-1;

		WMItems.list({aid:sPrimaryAccount,fid:'__@@REMINDERS@@__',values:['CTZ'],filter:{INTERVAL:iReminder+ '-' +(iDate+1)}},'','','',[this,'__RMN_parse']);
	}
	else{
		var d = new IcewarpDate();

		Cookie.set(['reminders'],d.format(IcewarpDate.JULIAN));
	}
};

//Check for incoming reminders (executed every 1min)
_me.__RMN_check = function(bShow){
	var iTame = (new IcewarpDate()).unix(),
		aData = dataSet.get('reminders'),
		out = {},
		eventId;

	if (aData){
		for(var i in aData)
			if (aData[i].unix<iTame)
				out[aData[i].sha1] = aData[i];

		if (!Is.Empty(out))
			if (bShow/* || gui.frm_reminder*/){
				for (eventId in out) {
					gui.notifier._value({type: 'reminder' + (out[eventId].conferenceid ? '_conference' : ''), args: out[eventId], unique: 'reminder_' + eventId});
				}

			}
			else
				this.__RMN_get();
	}
};
//Parse RMN list into dataset
_me.__RMN_parse = async function(aData){
	if (Is.Object(aData)){
		await storage.library('sha1');

		var aOut = [], tStemp = 0;
		for (var i in aData)
			    for (var j in aData[i]){

				delete aData[i][j]['/'];
				delete aData[i][j]['#'];
				delete aData[i][j]['$'];
				delete aData[i][j]['@'];

				for (var k in aData[i][j]){

					if (!tStemp || tStemp>aData[i][j][k].REMINDERUNIXTIME)
						tStemp = aData[i][j][k].REMINDERUNIXTIME;

					aOut.push({
						aid:sPrimaryAccount,
						fid:aData[i][j][k].EVNFOLDER,
						iid:WMItems.__clientID(aData[i][j][k].EVN_ID),
						startdate:aData[i][j][k].EVNSTARTDATE,
						starttime:aData[i][j][k].EVNSTARTTIME,
						enddate:aData[i][j][k].EVNENDDATE,
						endtime:aData[i][j][k].EVNENDTIME,
						conferenceid:aData[i][j][k].EVNMEETINGID,
						organizer:aData[i][j][k].EVNORGANIZER,
						unix:aData[i][j][k].REMINDERUNIXTIME,
						rid:k,
						sha1:SHA1(k),
						'class':aData[i][j][k].EVNCLASS,
						'title':aData[i][j][k].EVNTITLE
					});
				}
			}

			//Sort by REMINDERUNIXTIME ASC
		aOut = aOut.sort(function(a,b){return a.unix - b.unix});

		var d = new IcewarpDate();
		if (tStemp>0)
			d = IcewarpDate.unix(tStemp);

		Cookie.set(['reminders'],d.format(IcewarpDate.JULIAN));

		dataSet.add('reminders','',aOut,true);

		this.__RMN_check(true);
	}
};

_me.__onDestruct = function (){
	//kill sip autologin timeout
	if (this.__sipAutoLogin)
	    clearTimeout(this.__sipAutoLogin);

	//destruct SIP before itself
	if (gui.dial)
		gui.dial.__hide();

	if (this.sip)
		this.sip._destruct();

	//clear reminder intervals
	if (sPrimaryAccountGW){
		clearInterval(this.__rmnInterval1);
		clearInterval(this.__rmnInterval2);
	}
};

/**
 * GetNew (Get New button)
 *
 **/
_me._getNew = function(callback, bMain){
	var me = this;
	var aAccounts = dataSet.get('accounts');

	if (!aAccounts || !gui.__online) return callback && callback();

	var disable_other = (GWOthers.getItem('RESTRICTIONS','disable_otheraccounts') == 1);

	Object.keys(this.__refreshFolderTimeout).forEach(function(s){
		clearTimeout(this.__refreshFolderTimeout[s]);
	}, this);
	this.__refreshFolderTimeout = {};

	if (bMain) {
		var aSelected = this.bar.folders._getActive();
		WMFolders.sync({aid: aSelected[0], fid: aSelected[1]}, 'folders', '', [function() {
			me._refreshItems(aSelected[0]);
			if (!disable_other) {
				setTimeout(function() {
					for(var sAccId in aAccounts){
						if (aAccounts[sAccId] && !aAccounts[sAccId].PRIMARY && aAccounts[sAccId].TYPE !== 'rss') {
							accounts.refresh({ aid: sAccId, force: true }, 'folders', '', [me,'_refreshItems', [sAccId, true]]);
						}
					}
				}, 500);
			}
		}]);
		return callback && callback();
	}

	if (dataSet.get('current_view') === 'dashboard_view') {
		this.dashboard._refresh();
		return callback && callback();
	}

	if (this.__forcedReload) {
		dataSet.remove('removedFromDataset');
	}

	for(var sAccId in aAccounts){
		if (aAccounts[sAccId] && !(disable_other && !aAccounts[sAccId]['PRIMARY'] && aAccounts[sAccId]['TYPE']!='rss')) {
			accounts.refresh({ aid: sAccId, force: this.__forcedReload },'folders','',[function(sAccId) {
				executeCallbackFunction([me,'_refreshItems',[sAccId, true]]);
				callback && callback();
			}.bind(null, sAccId)]);
		}
	}
	this.__forcedReload = false;
};

/**
 * refreshne pravou stranu je-li refreshovan account s prave aktivnim adresarem
 **/
_me._refreshItems = function(sAccId, bForce)
{
	var list = (this.main || {}).list;
	if (!bForce && list && ~(list._SQLsearch || '').indexOf('+folders:"') && (list._SQLsearch || '').replace(/\+folders:".*?"/, '').replace(/is:unread/, '').trim().replace('()', '')) {
		return;
	}
	gui.__exeEvent('account', 'refresh', sAccId);

	var aSelected = this.bar.folders._getActive();
	if (aSelected[0] == sAccId && aSelected[1])
	{
		var sFolID = aSelected[1];
		if (WMFolders.getType([sAccId,sFolID]) != 'X')
			this.bar.folders._handleNode({'aid':sAccId,'fid':sFolID},true);
		else{
			dataSet.remove('items');
			dataSet.remove('preview');

			this.bar.folders._handleNode({'aid':sPrimaryAccount,'fid':'~'},true);
		}
	}

	//refresh itemview if __reloadme == true (F, Lock by doc converting)
	var id;
	if (gui.frm_main.main && gui.frm_main.main.itemview && gui.frm_main.main.itemview.__reloadme && (id = gui.frm_main.main.itemview.__activeItemID) && id[0] == sAccId)
		Item.open(id,'','','',true);
};

/**
 * dataSet:current_folder	is changed before rendering
 * dataSet:active_folder	is changed after rendering
 */
_me._selectView = async function(aFolder,sView,aOpt,oDate,bForceUpdate,sSearch,bNoTreeUpdate, bSkipServerSort){
	// HomePage
 	aFolder = aFolder || {};
	if (!aFolder['fid']){
		if (aFolder.type !== 'I') {
			if(!aFolder['aid'])
				aFolder['aid'] = sPrimaryAccount;

			aFolder['fid'] = '~';
		}
	}

	//Ziskat pohled a jeho nastaveni
	var aView = Cookie.get(['views',aFolder.aid,aFolder.fid]),
		sFolType = aView.type || WMFolders.getType(aFolder);

	window.Sentry && Sentry.setTag('module', {
		M: 'mail',
		Q: 'mail',
		E: 'calendar',
		I: 'teamchat',
		Y: 'teamchat',
		W: 'conferences',
		D: 'dashboard',
		N: 'notes',
		F: 'documents',
		T: 'tasks',
		C: 'contacts'
	}[sFolType]);

	if (!sView) {
		sView = aView.view
	}

	switch (sFolType) {
		case 'M':
		case 'Q':
			if (!~['mail_view', 'mail_view_wide', 'mail_view_list'].indexOf(sView)) {
				sView = 'mail_view_wide';
			}
			break;
		
		case 'E':
			/*if (sView === 'dashboard_view' && (!this._dashboardLoaded() || !this.dashboard._hasCapability('calendar'))) {
				sView = 'workweek_view';
			} else */if (!~['list', 'list_wide', 'list_view', 'day_view', 'week_view', 'workweek_view', 'month_view', 'dashboard_view'].indexOf(sView)) {
				sView = 'workweek_view';
			}
			break;

		case 'I':
		case 'Y':
			if (!~['norooms_view', 'room_view', 'files_view', 'events_view', 'pins_view', 'mentions_view', 'threads_view', 'unread_threads_view'].indexOf(sView)) {
				sView = 'room_view';
			}
			break;

		case 'W':
			if (sView !== 'conference_view') {
				sView = 'conference_view';
			}
			break;

		case 'D':
		case 'N':
		case 'F':
			var app = { N: 'notes', F: 'files' }[sFolType];
			var dashboard_enabled = dataSet.get('dashboard', ['config', 'dashboard_' + app + '_enabled']) == 1;
			if (sView === 'dashboard_view' && (sFolType !== 'D' && (/*!this._dashboardLoaded() || */!this.dashboard || !this.dashboard._hasCapability(app) || !dashboard_enabled))) {
				sView = 'list_wide';
			}
			break;

		default:
			if (!~['list', 'list_wide', 'list_view'].indexOf(sView)) {
				sView = 'list_wide';
			}
			break;
	}

	// for automated tests
	var bar = this._getAnchor('bar');
	bar.onscroll = function() {
		bar.scrollTop = 0;
	}

	Cookie.set(['views', aFolder['aid'], aFolder['fid'], 'view'], sView);

	// After creating lists, fill middle menu on top
	var bNewFolder = false;
	if (dataSet.get('current_folder') != aFolder['aid'] + '/' + aFolder['fid'] || this._lastView != sView){
		bNewFolder = true;
		dataSet.add('current_folder','',aFolder['aid'] + '/' + aFolder['fid']);
	}

	if (bNewFolder || bForceUpdate) {
		// promazat datasety
		dataSet.remove('items','',true);
	}

	if (sView != this._lastView || bNewFolder){

		gui.__exeEvent('viewSelected', sView, [aFolder.aid, aFolder.fid]);
		dataSet.add('current_view', '', sView);

		this._main.setAttribute('view', sView || '');
	}
	if (sFolType) {
		this._main.setAttribute('folder-type', sFolType);
	} else {
		this._main.removeAttribute('folder-type');
	}

	if (sView === 'dashboard_view') {
		this.main && this.main._main.setAttribute('aria-hidden', '');
		this.dashboard && this.dashboard._main.removeAttribute('aria-hidden');
	} else {
		this.main && this.main._main.removeAttribute('aria-hidden');
		this.dashboard && this.dashboard._main.setAttribute('aria-hidden', '');
	}

	//Změnil se pohled?
	if (sView != this._lastView || (sView!='month_view' && bForceUpdate))
	{
		var aRange;
		var tmp_e = ['day_view','week_view','workweek_view'],
			tmp_i = ['norooms_view', 'room_view','files_view','events_view','pins_view','mentions_view','threads_view','unread_threads_view'];

		if (sView === 'day_view' && this._lastView !== 'day_view' && !oDate) {
			oDate = new IcewarpDate();
		}

		//Změnil se pohled v rámci stejného objektu?
		if (~tmp_i.indexOf(sView) && ~tmp_i.indexOf(this._lastView)){
			//
		} else if (~tmp_e.indexOf(sView) && ~tmp_e.indexOf(this._lastView))
		{
			//NEni li zadan Date veme se range[start] z obj_evnview nebo dnesni den
			if (!oDate){
				oDate = new IcewarpDate();
				if (this.main.calendar._selection && this.main.calendar._selection.startdate){
					 oDate = IcewarpDate.julian(this.main.calendar._selection.startdate);
				}
				else if (this.main.calendar.__allDaySelection && this.main.calendar.__allDaySelection.startdate){
					oDate = IcewarpDate.julian(this.main.calendar.__allDaySelection.startdate);
				}else {
					aRange = await this.main.calendar._range();
					if (aRange['start']){
						oDate = IcewarpDate.julian(aRange['start']);
					}
				}
			}
		}
		else {
			if (this.main){
				if (this._lastView == 'day_view' || this._lastView == 'week_view' || this._lastView == 'workweek_view' || this._lastView == 'month_view')
					oDate = oDate || this.main._getDate();
				else
					oDate = new IcewarpDate();

				await this.main._destruct();
			}
			else
				oDate = new IcewarpDate();

			switch(sView){

			case 'mail_view':
			case 'mail_view_wide':
			case 'mail_view_list':
				dataSet.remove('preview');
				await this._create('main',{
					mail_view:'frm_main_mail',
					mail_view_wide:'frm_main_mail_wide',
					mail_view_list:'frm_main_mail_list'
				}[sView]);
				break;

			case 'list':
			case 'list_wide':
			case 'list_view':
				dataSet.remove('preview');
				await this._create('main',{
					list:'frm_main_datagrid',
					list_wide:'frm_main_datagrid_wide',
					list_view:'frm_main_datagrid_view'
				}[sView]);
				break;

			case 'day_view':
			case 'week_view':
			case 'workweek_view':
				await this._create('main','frm_main_calendar_dayweek','','','items');
				break;
			case 'month_view':
				await this._create('main','frm_main_calendar_month','','','items',oDate);
				break;

			case 'norooms_view':
			case 'room_view':
			case 'files_view':
			case 'events_view':
			case 'pins_view':
			case 'mentions_view':
			case 'threads_view':
			case 'unread_threads_view':
				await this._create('main','frm_main_chat','','','items');
				break;

			case 'conference_view':
				await this._create('main','frm_main_conference');
				break;

			default:
				break;
			}
		}

		//Search
		if (this.main && this.main._showsearch)
			this.main._showsearch(aFolder, sSearch);

	}
	else{
		switch(sView){
		case 'day_view':
		case 'workweek_view':
		case 'week_view':
			//NEni li zadan Date veme se range[start] z obj_evnview nebo dnesni den
			if (!oDate){
				oDate = new IcewarpDate();
				if (this.main.calendar._selection && this.main.calendar._selection.startdate){
					oDate = new IcewarpDate(this.main.calendar._selection.startdate, {format:IcewarpDate.JULIAN});
				} else{
					aRange = await this.main.calendar._range();
					if (aRange['start']){
						oDate = new IcewarpDate(aRange['start'], {format:IcewarpDate.JULIAN});
					}
				}
			}
		}

		//Search
		if (this.main && this.main._showsearch && dataSet.get('active_folder') != aFolder['aid'] + '/' + aFolder['fid']){
			this.main._showsearch(aFolder, sSearch);
		}
	}

	if (bNewFolder){
		dataSet.add('active_folder', '', aFolder['aid'] + '/' + aFolder['fid'], bNoTreeUpdate);
	}

	removecss(this._getAnchor('menu2'), 'hidden');
	// Sort list items if necessary
	var bSelectFolder = true;
	switch(sView){
	case 'nothing':
	case 'home':
		break;

	case 'conference_view':
		this.main._serverSort();
		if(~['jitsi', 'jitsi-full'].indexOf(dataSet.get('accounts',[sPrimaryAccount, 'MEETING_PROVIDER']))) {
			addcss(this._getAnchor('menu2'), 'hidden');
		}
		break;

	case 'day_view':
	case 'week_view':
	case 'workweek_view':
		this.main._setDate(oDate,sView == 'day_view'?1:7,sView=='workweek_view');
		this.main._serverSort(sView);
		break;

	case 'norooms_view':
	case 'room_view':
	case 'files_view':
	case 'events_view':
	case 'pins_view':
	case 'mentions_view':
	case 'threads_view':
	case 'unread_threads_view':

	case 'month_view':
		this.main._serverSort(sView, aOpt, !!aOpt);
		break;

	// Máme preview pohled?
	case 'mail_view':
	case 'mail_view_wide':
	case 'list_view':
	case 'list_wide':
		if (!dataSet.get('active_items', [aFolder.aid, aFolder.fid]))
			dataSet.remove('preview');

		if (this.main.list && !bSkipServerSort){

			if (this.search && bNewFolder)
				this.main.list._SQLsearch = this.search.__getDefaultQuery(sFolType, true);

			this.main.list._serverSort(aFolder,aView['sort']['column'],aView['sort']['type'],false, aOpt, true, !bNewFolder);
			bSelectFolder = false;
		}

		//force resize
		if (bNewFolder)
			gui.__exeEvent('resize');

		break;

	default:
		if (this.main && this.main.list){
			this.main.list._serverSort(aFolder,aView['sort']['column'],aView['sort']['type'], [this,'__taskReminderBellIconTooltip'], aOpt, true, !bNewFolder);
			bSelectFolder = false;
		}
	}

	this._lastView = sView;

	if (bSelectFolder || aFolder.elm){
		gui.__exeEvent('folderSelected',aFolder);
	}

	//zapsat do cookies last folder
	if (sFolType !== 'G'){
		Cookie.set(['last_folder'], aFolder.aid + '/' + aFolder.fid);
		Cookie.set(['last', sFolType], aFolder.aid + '/' + aFolder.fid);
	}

	return bNewFolder;
};

_me.__taskReminderBellIconTooltip = function() {
	// load reminder on mouseenter over bell icon
	var me = this;
	setTimeout(function() {
		if(!me.main || !me.main.list) {
			return;
		}
		[].forEach.call(me.main.list._main.querySelectorAll('.col_TASK_STARTDATE, .col.reminder .reminder'), function(elm) {
			if(!elm._mouseenter) {
				elm.addEventListener('mouseenter', function(e) {
					if(elm._mouseenter < 2) {
						var id = gui.frm_main.main.list._aData[e.target.getAttribute('id').split('/')[1]].arg;
						WMItems.list(id, '', '', '', [function(data) {
							var reminders = data[id.aid][id.fid][id.iid].REMINDERS;
							for(var i in reminders) {
								if(+reminders[i].values.RMNTIME) {
									e.target && e.target.setAttribute('title', IcewarpDate.unix(reminders[i].values.RMNTIME).format('DD/MM/YYYY HH:mm'));
									break;
								} else if(reminders[i].values.RMNMINUTESBEFORE) {
									e.target && e.target.setAttribute('title', frm_event2.prototype._reminderObjectToText(reminders[i]));
									break;
								}
							}
						}]);
						elm._mouseenter = 2;
					}
				});
				elm._mouseenter = 1;
			}
		});
	}, 50);
};

/* pokud je posledni aktivni email v danem folderu otevre ho v mailview */
_me.__synchroDatasetHandler = function(sAccId,sFolId) {
	var sActiveItem = dataSet.get('active_items', [sAccId, sFolId]);
	var aItems = dataSet.get('items', [sAccId, sFolId]);

	if (!this.main || aItems === void 0) { // unable to get folder items
		return;
	}

	if (sActiveItem && this.main.list && Object.values(this.main.list.__rowOffset).some(function(item) {
		return item.id === sActiveItem;
	})) {

	} else if(!sActiveItem || !~Object.keys(aItems).indexOf(sActiveItem)) {
		var removed = dataSet.get('removedFromDataset', [sAccId, sFolId]) || [];
		Object.keys(aItems).some(function (v) {
			if (v.indexOf('*') === 0 && !~removed.indexOf(v)) {
				sActiveItem = v;
				return true;
			}
		});
	}

	this.__taskReminderBellIconTooltip();

	if (sActiveItem){
		//check if folder is blank
		if (!aItems || !Object.keys(aItems).length){
			dataSet.remove('active_items', [sAccId, sFolId]);
			dataSet.remove('preview');
			return;
		}

		//Select item in List
		if (this.main.list){
			var v = this.main.list._value();
			var oFolder = dataSet.get('folders', [sAccId, sFolId]);
			if (oFolder && oFolder.TYPE === 'M' && (oFolder.SPAM || oFolder.DEFAULT === 'H')) {
				// this.main.list._value([]);
				return;
			} else {
				if (!v.length || (aItems && !aItems[v[0]])){
					var aData = dataSet.get('items', [sAccId, sFolId, sActiveItem]);
					if (aData && aData.ORIGINALFOLDER) {
						this.main.list._value([aData.ORIGINALACCOUNT + '/' + aData.ORIGINALFOLDER + '/' + sActiveItem]);
					} else {
						this.main.list._value([sActiveItem]);
					}
				}
			}
		}

		//Open item in mailview
		if (this.main.mailview) {
			OldMessage.open([sAccId, sFolId, sActiveItem]);
		}
		else
		if (this.main.itemview){
			Item.open([sAccId, sFolId, sActiveItem]);
		}
	}
};



// A change of ip was detected, ask if logout or sign in anew
_me._acceptChangedIP = function () {
	if(!gui.reauth || gui.reauth._destructed)
		gui._create('reauth','frm_reauth');
};

// Note, logout is also called from frm_change_ip
_me.__logout = function(bSkip){

	if (this._destructed) return;

	//#catch all opened compose windows
	if (!bSkip){
		var aChild = gui._getChildObjects('','frm_compose');
		for (var i in aChild){
			if (!aChild[i].__logoutOnDestruct && aChild[i]._onclose())
				aChild[i]._destruct();
			else{
				aChild[i].__show();
				aChild[i].__logoutOnDestruct = true;
				return true;
			}
		}
	}

	//kill IM
	if (this.im && !this.im._destructed){
		this.im._destruct([this,'__logout',[true]]);
		return;
	}

	if(this.__loggedOut) return;
	this.__loggedOut = true;

	//kill SIP
	this.__onDestruct();

	//kill connection manager
	if (gui.connection)
		gui.connection._destruct();

	//stop cookies auto-saving
	if (window.Cookie)
		window.clearInterval(window.Cookie._interval);

	//if external login was used
	var sURL = GWOthers.getItem('LAYOUT_SETTINGS','logout_url') || (document.location.protocol +'//'+ document.location.hostname + (document.location.port?':'+document.location.port:'') + document.location.pathname);

	//TeamChat Desktop Client appendix
	if (window.TeamChatAPI && TeamChatAPI.teamChatOnly())
		sURL += '?' + buildURL({tconly:1, token:TeamChatAPI.getToken(), notifyuri:TeamChatAPI.getNotifyURI()});

	//logout user
	auth.logout();

	//remove datasets
	dataSet.remove('main','',true);
	dataSet.remove('cookies','',true);
	dataSet.remove('accounts','',true);
	dataSet.remove('folders','',true);
	dataSet.remove('items','',true);
	//MailView, ItemView
	dataSet.remove('preview','',true);

	dataSet.remove('active_items','',true);
	dataSet.remove('active_folder','',true);
	dataSet.remove('settings','',true);

	window.onbeforeunload = null;

	if (sURL && !sURL.match(/^https?:\/\//)) {
		sURL = document.location.protocol + '//' + sURL;
	}

	document.location.replace(sURL);
	return;
};

_me.__showConferenceDialog = async function(aid, fid, iid) {
	if(aid && fid && iid && WMFolders.getType([aid,fid]) === 'C') {
		WMItems.list({"aid": aid, "fid": fid, "iid": iid},'','','',[async function(aData){
			var aValues = aData[aid];
			if (aValues && (aValues = aValues[fid]) && (aValues = aValues[iid])){
				await storage.library('wm_conference');
				wm_conference.create(function(conference) {
					var email, emails = [];
					for (var i in aValues['LOCATIONS']) {
						email = aValues['LOCATIONS'][i]['values']['LCTEMAIL1'] || aValues['LOCATIONS'][i]['values']['LCTEMAIL2'] || aValues['LOCATIONS'][i]['values']['LCTEMAIL3'];
						if (email) emails.push(email);
					}
					if (emails.length)
						conference.invite(emails);
				});
			}
		}]);
	}
	else {
		await storage.library('wm_conference');
		wm_conference.create(function(conference) {
			conference.join();
		});
	}
};

_me.__showDialDialog = function(aid, fid, iid) {
	if (aid && fid && iid && WMFolders.getType([aid,fid]) === 'C') {
		WMItems.list({"aid": aid, "fid": fid, "iid": iid},'','','',[
			function(aData){
				var aValues = aData[aid];
				if (aValues && (aValues = aValues[fid]) && (aValues = aValues[iid])){

					var	aLocations = aValues['LOCATIONS'],
						v,nPhone,sName,aPhones = {};

					for (var i in aLocations){
						if (aLocations[i]['values']['LCTTYPE'] == 'H') {
							if ((v = aLocations[i].values)){

								//Phones
								for (var j in v)
									if (v[j] && j.indexOf('LCTPHN') == 0){

										nPhone = v[j].trim();

										if (j == 'LCTPHNOTHER' && nPhone.indexOf('sip:') === 0){
											nPhone = nPhone.substring(nPhone.indexOf(':') + 1);
											sName = getLang('PHONE::SIP');
										}
										else
											sName = getLang('PHONE::'+j.toUpperCase(),'',2);

										aPhones[nPhone] = (sName?'['+sName+'] ':'') + nPhone;
									}

								//Emails
								if (v.LCTEMAIL1)
									aPhones[v.LCTEMAIL1] = v.LCTEMAIL1;
								if (v.LCTEMAIL2)
									aPhones[v.LCTEMAIL2] = v.LCTEMAIL2;
								if (v.LCTEMAIL3)
									aPhones[v.LCTEMAIL3] = v.LCTEMAIL3;
							}

							break;
						}
					}

					var c = count(aPhones);
					if (c){
						for(var sPhone in aPhones){
							if (c>1)
								gui._create('im_phone','frm_confirm_select','','',[function(n){ gui.frm_main._call(n); }], 'MAIN_MENU::DIAL', 'DIAL::SELECT_CONTECT', null, aPhones, sPhone);
							else
								gui.frm_main._call(sPhone);

							break;
						}
					}
				}
			}
		]);
	}
};

_me.__showSMSDialog = function(aid, fid, ids) {
	if (ids && WMFolders.getType([aid,fid]) === 'C'){
		var tmp = Is.Array(ids)?ids:[ids];
		for (var i in tmp)
			tmp[i] = WMItems.__serverID(tmp[i]);

		var aFilter = {search: '+has:"mobile" +items:"' + tmp.join(',').replace(/\*/g,'') + '"'},
			aValues = ['ITMCLASSIFYAS','LCTPHNMOBILE'];
		WMItems.list({'aid':aid,'fid':fid,'values':aValues,'filter':aFilter},'','','',[NewMessage.compose_sms]);
	}
	else
		NewMessage.compose_sms();
};

/**
 * open thread in right dock
 **/
_me._openTeamchatThread = function(aPath){
	if (sPrimaryAccountCHAT && WMFolders.getType(aPath) == 'I'){
		this.rslide.thread._init(aPath);
		this.rslide._value('thread');
	}
};

_me._openChatGPTConversation = async function(id, oOptions) {
	for (var i in Gui.__detachedWindows) {
		if ((((Gui.__detachedWindows[i] || {}).component || {}).__aData || {}).id === id) {
			return Gui.__detachedWindows[i].focus();
		}
	}

	var conv = await this.rslide.chatgpt_conversation._init(id, oOptions || {});
	this.rslide._value('chatgpt_conversation', true);
	return conv;
};

/**
 * Adds given teamchat folder (room) to "Recent" rooms list
 *
 * @param {String} sFolderPath Folder path (i.e.: Public/TeamChat/5ad741c10bec)
 *
 * @returns {undefined}
 */
_me.__addTeamchatFolderToRecent = function(sFolderPath) {
	var aRecent = Cookie.get(['recent']) || [],
		sFolderAbsPath = sPrimaryAccount + '/' + sFolderPath,
		i;

	// Remove folder from recent folders
	i = aRecent.indexOf(sFolderAbsPath);
	if (-1 !== i) {
		aRecent.splice(i, 1);
	}

	// Add/move folder to the top of the list
	aRecent.unshift(sFolderAbsPath);
	Cookie.set(['recent'], aRecent);
};

_me._rightDock = function (sName){
	var bResize = false;

	if (sName){
		if (!this.__rightDock){
			this._getAnchor('right').removeAttribute('aria-hidden');
			addcss(this._main,'rdock');
			this.__rightDock = true;
			bResize = true;
		}
	}
	else
	if (sName === false){
		if (this.__rightDock){
			this._getAnchor('right').setAttribute('aria-hidden', '');
			removecss(this._main,'rdock');
			this.__rightDock = false;
			bResize = true;
		}
	}
	else
		return this.__rightDock;

	//set rdock attribute
	if (sName) {
		this._main.setAttribute('rdock', sName);
		this.__activeSlider = 'slider2';
		this._resize(Cookie.get(['vertical_slider2',screen.width+'x'+screen.height]) || 340, false);
	} else {
		this._main.removeAttribute('rdock');
		this._getAnchor('container').style[gui._rtl?'paddingLeft':'paddingRight'] = '';
	}

	//store to cookie
	Cookie.set(['rdock'], sName || '');

	//Call window.onresize event handler
	if (bResize)
		gui.__exeEvent('resize');
};

/**
 * Callback function. Called when new teamchat room is added to the dataset
 *
 * @returns {undefined}
 */
_me.__newTeamchatRoomCallback = function(aData) {
	var aFolders = dataSet.get('folders', [sPrimaryAccount]),
		sFolderId;

	if(sPrimaryAccountGUEST && !Object.keys(aFolders).some(function(sFolder) {
		return aFolders[sFolder].TYPE === 'I';
	})) {
		return gui._create("confirm", "frm_alert", "", "", [function() {
			gui.frm_main.__logout();
		}], 'MAIN_MENU::LOGOUT', 'ERROR::MISSING_TEAMCHAT');
	}

	// Get folder path by id
	if (aData.ACTION == 'add'){
		for (sFolderId in aFolders){
			if (Object.prototype.hasOwnProperty.call(aFolders, sFolderId) && aFolders[sFolderId].RELATIVE_PATH === Path.slash(aData.FOLDER)) {
				this.__addTeamchatFolderToRecent(sFolderId);
				this.bar._setFolderName(this.bar.__sActiveFolder);
				return;
			}
		}
	}
	else
	//Active folder and doesn't exist, go to HOME
	if (WMFolders.getType(Path.split(dataSet.get('active_folder'))) === 'X'){
		gui.frm_main._selectView(Folder.getNext({type:'I'}, aFolders));
	}
};

_me.__copyItem = function(aIds, aDest) {
	var ids = [
			aIds[0].aid,
			aIds[0].fid,
			aIds.map(function(aId) {
				return aId.id;
			})
		];
	Item.__copyOrMoveItems(aDest[0], aDest[1], 'copy', ids);
};

_me._dashboardLoaded = function() {
	return this.dashboard && this.dashboard.__isLoaded && !this.dashboard.__isDown;
}