function frm_invite_people() { };

frm_invite_people.prototype = {
	__constructor: async function (view) {
		var me = this;

		this._getAnchor('helper').innerHTML = getLang('INVITE::HELPER', ['<img src="./client/skins/default/images/rounded/Settings-1.svg" />']);

		this.__users = [];

		this.input._onsubmit = function() {
			var value = me.input._value().trim();
			if (!value || !Is.Email(value)) {
				return;
			}

			value = MailAddress.splitEmailsAndNames(value)[0];

			if (!me.__users.some(function(user) {
				return user.email === value.email;
			})) {
				me.__users.push(value);
				var user = mkElement('div', {
					className: 'user',
					textContent: MailAddress.createEmail(value.name, value.email, true)
				}, false, [
					mkElement('div', {
						className: 'remove',
						onclick: function(user, event) {
							me.__users = me.__users.filter(function(u) {
								return u.email !== user.email;
							});
							event.target.parentNode.parentNode.removeChild(event.target.parentNode);
							me.__updateButton();
						}.bind(null, value)
					})
				]);
				me._getAnchor('list').appendChild(user);
				me.__updateButton();
			}
			me.input._value('');
		}

		this.input._restrict([function(value) {
			value = MailAddress.splitEmailsAndNames(value)[0];
			return !value || Is.Email(value.email);
		}]);

		this.input.__setMask({
			add: [getLang('FORM_BUTTONS::ADD')]
		},[function() {
			this.input._onsubmit();
			this.input._focus();
		}.bind(this)]);

		this.input._focus();

		this.btn_next._onclick = function () {
			me.__invite(function() {
				view.view('finish');
			});
		};

		this.__updateButton();
	},

	__updateButton: function() {
		this.btn_next._disabled(!this.__users.length);
		(this.__users.length ? removecss : addcss)(this._getAnchor('header'), 'hidden');
	},

	__invite: function(callback) {
		WMAccounts.invite(this.__users);
		callback();
	}
};