_me = frm_insert_item.prototype;
function frm_insert_item(){};

/**
 * Constructor
 *
 * @param {Boolean} bNoFolders      Shows dialog for selection only from files folder
 * @param {Array}   aAllowedFolders Array of folders allowed in left menu. I.e.: ['M', 'E', 'X' ...]
 *
 * @return {undefined}
 */
_me.__constructor = async function(aResponse, sAccount, sFolder, sType, oUpload, bNoFolders, aAllowedFolders, aPreselectedFolder, sRights) {
	this._default_folder = sFolder;
	this._default_account = sAccount;
	this._modal(true);

	var me = this;

	this._dataSet = 'tmp_'+this._name;
	this.__value = {};

	this._title('INSERT_ITEM::INSERT_ITEM');

	// Create form from template
	if (bNoFolders) {
		await this._draw('frm_insert_item', 'main');
		this._size(800,500,true);
	} else {
		await this._draw('frm_insert_item_folders', 'main');
		this._size(1000,500,true);

		aAllowedFolders.some(function(v,i,a){
			return v === 'F' && a.push('K');
		});
	}

	this._placeShift();

	//Datagrid init
	this.datagrid._default_values = function (sFolType){

		switch(sFolType){
			case 'I':
				return ['EVN_ID','EVNTITLE','EVN_MODIFIED','EVNTHUMBNAILID','EVNTHUMBNAILTIME','EVNPROCESSINGQUEUED','EVNCOMPLETE'];
			case 'K':
				return WMItems.default_values('F');
			default:
				return WMItems.default_values(sFolType);
		}
	};
	this.datagrid._listen_data(this._dataSet,'',true);
	this.datagrid._onchange = function(){
		if (this.__value.length>0){
			var val = {}, tmp;

			for (var i in this.__value)
			    if (me.__value[this.__value[i]])
                    val[this.__value[i]] = me.__value[this.__value[i]];
				else{
                    var f = this._getFolder();
                    if ((tmp = dataSet.get(this._listener_data,[f.aid,f.fid,this.__value[i]])))
						val[this.__value[i]] = tmp;
				}

			me.__value = val;
		}
	};
	this.datagrid._ondblclick = function(){
		me.x_btn_ok._onclick();
	};

	//Open folder
	sFolder = sFolder || Mapping.getDefaultFolderForGWType(aPreselectedFolder);
	if (sFolder){
		if (sFolder && WMFolders.getType([sAccount,sFolder]) != 'X'){
			if (this.tree_folder)
				await this.tree_folder._setActive ((sAccount || sPrimaryAccount)+'/'+sFolder);
			else
				this.datagrid._serverSort({aid:(sAccount || sPrimaryAccount),fid:sFolder});
		}

		await this._search({aid:(sAccount || sPrimaryAccount),fid:sFolder});
	}

	//Tree and filter init
	if (!bNoFolders) {
		this.filter.__filter = this.__filterTree.bind(this);

		if (window.TeamChatAPI && TeamChatAPI.teamChatOnly()) {
			aPreselectedFolder = 'X';
			aAllowedFolders = ['X', 'I'];
		}

		// In case only one folder is allowed:
		// - hide folders menu
		// - hide helper (it contains screenshot of selection of particular folder types)
		// - make drop zone to occupy whole dialog width
		if (1 === aAllowedFolders.length) {
			addcss(this._main,'nofilter');
		}

		if(oUpload) {
			this.__oUpload = oUpload;
			oUpload._dropzone(this._main.querySelector('.upload'), async function () {
				return await (new cTemplate()).tmp('dropzone', {
					body: getLang('CHAT::DROP_BODY'),
					title: aResponse[0]._type === 'frm_main_chat' ? getLang('CHAT::DROP_TITLE', [Path.basename(aResponse[0].__fid)]) : getLang('ATTACHMENT::DROPZONE')
				});
			}, 'item');
			gui._obeyEvent('onuploadstart', [function () {
				if (me && !me._destructed)
					me._destruct();

				return false;
			}]);
			this.upload_button._onclick = function() {
				oUpload.__active_folder = [sAccount, sFolder];
				oUpload._click();
			};
			if (!~aAllowedFolders.indexOf('X')) {
				aPreselectedFolder = aAllowedFolders[0];
			}
		} else if(aAllowedFolders) {
			aAllowedFolders = aAllowedFolders.filter(function(folder) {
				return folder !== 'X';
			});
			aPreselectedFolder = aAllowedFolders[0];
		}

		//TREE
		await this._create('tree_folder','obj_tree_folder2','tree','scroll', sAccount, sType, sRights, false, {privateRootActive: false});
		var disable_gw_types = GWOthers.getItem('RESTRICTIONS', 'disable_gw_types');
		if (disable_gw_types) {
			if (aAllowedFolders) {
				aAllowedFolders = aAllowedFolders.filter(function(folder_type) {
					return !~disable_gw_types.indexOf(folder_type.toLowerCase());
				});
			}
			if (aPreselectedFolder && ~disable_gw_types.indexOf(aPreselectedFolder.toLowerCase())) {
				aPreselectedFolder = 'X';
			}
		}

		this.filter.__filter(aPreselectedFolder || 'X');
		if (aAllowedFolders) {

			var allowed = this.filter.__aTypes.filter(function(type) {
				var elm = this.filter._main.querySelector('a.'+ type.toLowerCase());
				if (elm) {
					elm.classList[!~aAllowedFolders.indexOf(type) ? 'add' : 'remove']('hidden');
					return ~aAllowedFolders.indexOf(type);
				}
			}, this);
			if (allowed.length < 2) {
				this._getAnchor('filter_tree').classList.add('hidden');
			}
		}

		this.tree_folder._onactivate = async function(id){

			var arg = Path.split(id, true),
				sType = WMFolders.getType(arg);

			if (me.radio)
				if (sType == 'M'){
					me.radio._disabled(true);
					me.radio._value('embedded');
				}
				else
					me.radio._disabled(false);

			await me._search(arg);

			me.datagrid._SQLfulltext = '';
			me.datagrid._SQLtype = sType === 'I' ? 'gchat:files' : '';

			if (!this._sFilterFolderType['X'] && !this._sFilterFolderType['K']) {
				me.datagrid.__preloading = false;
				me.datagrid._serverSort(arg);
			}

			removecss(me._getAnchor('search'), 'active');
		};
	}

	// This function is triggered when 'OK' button is pressed.
	this.x_btn_ok._onclick = function() {

		var v = me.datagrid._value();

		if (v.length){
			var aItem, aResult = [], sType, tmp;
			var f = me.datagrid._getFolder();
            for(var i in v){
                if (!(aItem = dataSet.get(me.datagrid._listener_data,[f.aid,f.fid,v[i]]))) continue;

                sType = WMFolders.getType(aItem);

				tmp = {
					id: v[i],
					fullpath: aItem.aid+'/'+aItem.fid+'/'+WMItems.__serverID(v[i]),
					embedded: (!me.radio || me.radio._value() == 'embedded'),
					aid:aItem.aid,
					fid:aItem.fid,
					iid: WMItems.__serverID(v[i])
				};

				switch (sType) {
					case 'M':
						tmp.title = (aItem.SUBJECT ? aItem.SUBJECT + ' - ' : '') + WMItems.__serverID(v[i]) + '.eml';
						tmp.size = aItem.SIZE
						break;
					case 'C':
						tmp.title = aItem['ITMCLASSIFYAS']+'.vcf';
						break;
					case 'I':
					case 'K':
					case 'F':
						tmp.title = aItem.EVNLOCATION;
						tmp.size = aItem.EVNCOMPLETE;
						tmp.url = aItem.EVNURL;
						break;
					case 'E':
					case 'J':
					case 'N':
					case 'T':
						tmp.title = aItem['EVNTITLE']+'.ics';
						break;
					default:  tmp.title = getLang('INSERT_ITEM::UNTITLED');
				}

				aResult.push(tmp);
			}

			if (Is.Defined(aResponse)) {
				executeCallbackFunction(aResponse, aResult);
			}
		}

		setTimeout(function() {
			me._destruct();
		}, 5);
	};

	this._onclose = function() {
		dataSet.remove(me._dataSet);
		if(oUpload && oUpload.__remove_dropzone) {
			oUpload.__remove_dropzone(this._main.querySelector('.upload'));
		}
		return true;
	};

	if (this._getAnchor('leftdiv')) {
		await this._create('resizer', 'obj_resizer', '', '', {
			x: 220,
			offsetX: (this._getAnchor('filter_tree') || {}).clientWidth || 0,
			cacheId: this._type,
			onresize: function(x) {
				me._getAnchor('leftdiv').style.width = x + 'px';
			}
		});
	}

	this._add_destructor('__onDestruct');
};

_me.__onDestruct = function() {
	this.__oUpload && this.__oUpload.__remove_dropzone(this._main.querySelector('.upload'));
};

_me._search = async function (aFolder){
	if (!this.search) {
		await this._create('search', 'obj_search','search','', {
			aid: aFolder.aid,
			fid: aFolder.fid
		}, {
			afterRender: function(popup) {
				popup.style.zIndex = this.__zindex;
			}.bind(this)
		});
	} else {
		this.search._setFolder(aFolder);
	}
	if (aFolder){

		if (!aFolder.ftype)
			aFolder.ftype = WMFolders.getType(aFolder);

		this.search._onsearch = function(v,s){
			if(WMFolders.getType(aFolder) === 'I') {
				v += ' gchat:files';
			}
			this._parent.datagrid._SQLsearch = v;
			this._parent.datagrid._SQLfulltext = s;
			this._parent.datagrid._serverSort(false, false, false, false, false, true, true);
		};
	}
};

_me.__filterTree = async function (id) {

	var oTree = this.tree_folder,
		me = this,
		activate = Mapping.getDefaultFolderForGWType(id) ? sPrimaryAccount + '/' + Mapping.getDefaultFolderForGWType(id) : dataSet.get('cookies', ['last', id]);

	oTree.__filter = '';

	this._main.setAttribute('view', id);

	switch (id) {
		case 'I':
			oTree._filter_folder(['I', 'Y']);
			if (this._default_folder) {
				activate = sPrimaryAccount + '/' + this._default_folder;
			}
			break;
		case 'M':
			oTree._filter_folder(['M', 'R', 'QL', 'Q']);
			activate = sPrimaryAccount + '/INBOX';
			break;
		case 'E':
			oTree._filter_folder(['E']);
			break;
		case 'B':
			oTree._filter_folder(['B', 'G', 'QL', 'Q']);
			activate = GWOthers.get('DEFAULT_FOLDERS','storage')['VALUES']['trash'];
			break;
		case 'X':
			oTree._filter_folder(['X']);
			break;

		// display alfresco tree
		case 'K':

			oTree._filter_folder(['K']);

			if (this.alfresco_folder){
				var aPath = this.alfresco_folder._getActive();
				if (Is.String(aPath[1]))
					this.datagrid._serverSort({aid:aPath[0], fid:aPath[1]});
				break;
			}

			await this._create('alfresco_folder','obj_tree_folder','tree','alfresco_folder noroot scroll search', '@@alfresco@@');
			this.alfresco_folder._filterRawData = function(data) {
				if (data && data['@@alfresco@@'] && !data['@@alfresco@@']['@@search']) {
					data = clone(data, true);
					data['@@alfresco@@']['@@search@@'] = {
						NAME: getLang('FOLDERS::SEARCH'),
						TYPE: 'F',
						RIGHTS: 'rl',
						LOADED: true
					};
				}
				return data;
			}
			this.alfresco_folder._listen_data('alfresco');
			this.alfresco_folder._onactivate = async function(id, bChange){
				if (bChange){
					var aPath = Path.split(id, true);

					if (aPath.fid === '@@search@@') {
						// empty item results
						this.datagrid._aFolder = aPath;
						this.datagrid._fill({});
						return;
					}

					await this._search(aPath);

					this.datagrid._SQLsearch = '';
					this.datagrid._SQLfulltext = '';

					this.datagrid._serverSort(aPath);

					if (this.radio){
						this.radio._disabled(true);
						this.radio._value('embedded');
					}
				}
			}.bind(this);

			this.alfresco_folder._onclick = function(e, elm, id){

				var aPath = Path.split(id, true);

				if (aPath.fid === '@@search@@') {
					// do not try to open virtual search folder
					return;
				}
				Alfresco.getFolderInfo(aPath.fid, [function(bOK, aFolder){
					if (bOK)
						Alfresco.setLastFolder(aFolder.fid);
				}]);
			};

			Alfresco.getFolderInfo();

			var sLastFolder;
			if (this._default_account == '@@alfresco@@' && this._default_folder)
				sLastFolder = this._default_folder;
			else
				sLastFolder = Alfresco.getLastFolder();

			if (sLastFolder){
				Alfresco.getFolderInfo(sLastFolder, [function(bOK, aFolder){
					if (bOK && aFolder.fid.length){
						this.alfresco_folder._setActive(Path.build(aFolder));
					}
				}.bind(this)]);
			}

			var alfresco_search;
			this.alfresco_folder._onsearch = function(filter) {
				clearTimeout(alfresco_search);
				alfresco_search = setTimeout(me.__alfrescoSearch.bind(me, filter), 150);
			};

			break;

		default:
			oTree._filter_folder([id]);
			if (this._default_folder) {
				activate = sPrimaryAccount + '/' + this._default_folder;
			}
	}

	for (var i in this.filter.__aTypes) {
		(oTree._sFilterFolderType[this.filter.__aTypes[i]] ? addcss : removecss)(this.filter._getAnchor(this.filter.__aTypes[i]), 'active');
	}

	if (!~['X','K'].indexOf(id)){
		oTree._invalidateActive();
		oTree._fill();
		activate && await oTree._setActive(activate);
	}
};

_me.__alfrescoSearch = function(filter) {
	WMFolders.list({
		aid: '@@alfresco@@',
		search: filter
	},'','', [function(aData) {
		for(var i in aData['@@alfresco@@']) {
			dataSet.add('alfresco', ['@@alfresco@@', i.replace('/Company Home/', '')], aData['@@alfresco@@'][i]);
		}
		this.alfresco_folder._fill(dataSet.get('alfresco'));
	}.bind(this)]);
}
