_me = frm_imgview.prototype;
function frm_imgview(){};

frm_imgview.__cache = {};
_me.__constructor = async function(){
	var me = this;

	await storage.library('load-image.all.min', 'loadimage');
	await storage.library('zoomist', 'zoomist');

	this._place('0%','0%',"100%","100%");
	this._zIndex();

	this._getAnchor('previews').addEventListener("wheel", (event) => {
		if (me.__wheeltimeout) {
			return;
		}
		me.__wheeltimeout = true;
		setTimeout(function() {
			me.__wheeltimeout = false;
		}, 250);

		if (event.deltaY > 0) {
			me._next();
		} else {
			me._prev();
		}
	});

	this._getAnchor('rotate').addEventListener("click", () => {
		if (this.__img) {
			this.__img.style.rotate = ((parseInt(this.__img.style.rotate) || 0) + 90) + 'deg';
		}
	});

	this.__queue = [];
	this.__previews = {};
	//Full Screen toggle
	this._getAnchor('full').onclick = function(e){

		var doc = me._main.ownerDocument;
		if (!doc.fullscreenElement) {
			me._main.requestFullscreen && me._main.requestFullscreen();
		} else {
			doc.cancelFullScreen && doc.cancelFullScreen();
			doc.exitFullscreen && doc.exitFullscreen();
		}

		me.__focus(e);
	};

	this._getAnchor('area').onclick = function(e) {
		if (e.target === me._getAnchor('area')) {
			e.stopImmediatePropagation();
			me._destruct();
		}
	};

	this._getAnchor('download').onclick = function(e){
		var a = mkElement('a', {
			href: location.origin + '/teamchatapi/http.download?token=' + sPrimaryAccountTeamchatToken + '&url=' + encodeURIComponent(me.__queue[me.__value].url.replace(/&disposition=inline/, '').unentityify()),
			download: '',
			target: '_blank',
		});
		a.click();
		me.__focus(e);
	};

	this._getAnchor('pin').onclick = async function(){
		if (me.pins) {
			me.pins._hide(true);
			me.pins._destruct();
			return delete me.pins;
		}

		me.pins = await me._gui._create('pins', 'obj_minipin', '', '', [me, '__pin']);

		//Activate Pin
		var linkextras,
			aData = me.__queue[me.__value].data;
		if ((aData.GPINOWNEMAIL && aData.GPINOWNEMAIL !== sPrimaryAccount) || (aData.EVNLINKEXTRAS && (linkextras = parseURL(aData.EVNLINKEXTRAS)) && linkextras.AccountEmail)) {
			addcss(me.pins._main.querySelector('.public'), 'disabled');
		}

		(aData.GPINWHEN ? addcss : removecss)(me.pins._main.querySelector('.public'), 'active');
		(aData.PINWHEN ? addcss : removecss)(me.pins._main.querySelector('.private'), 'active');

		me.pins._modal(true);

		me.pins._onclose = function() {
			me.pins._hide(true);
			me.pins._destruct();
			delete me.pins;
		};

		me.pins._onstate = function(s) {
			(s === 'visible' ? addcss : removecss)(this, 'active');
		}.bind(this);

		var pos = getSize(this);

		me.pins._show();
		me.pins._place({
			left: 'auto',
			right: (document.body.offsetWidth - pos.x - pos.w / 2 - me.pins._main.offsetWidth / 2) + 'px',
			top: (pos.y + pos.h) + 'px'
		});
	};

	this._getAnchor('prev').onclick = function(e) {
		e.stopPropagation();
		me._prev();
		me.__focus(e);
	};

	this._getAnchor('next').onclick = function(e) {
		e.stopPropagation();
		me._next();
		me.__focus(e);
	};

	this._getAnchor('close').onclick = function(e) {
		e.stopPropagation();
		me._destruct();
	};

	this._getAnchor('image').onclick = function(e) {
		me.__focus(e);
	};

	var eInput = this._getAnchor('input');
		eInput.onkeydown = function(e){
			switch(e.keyCode){
				case 37:
				case 38:
				case 33:
					me._prev();
					break;

				case 39:
				case 40:
				case 34:
				case 32:
					me._next();
					break;

				case 27:
					me._destruct();
					break;
			}

			e.stopPropagation();
		};

	me.__focus();

	this._obeyEvent('imageLoaded', [this, '__imageLoaded']);
	if (gui.socket) {
		gui.socket.api._obeyEvent('onnotify', [this, '__notify']);
	}

	this._add_destructor('__destructor');

	gui.tooltip._add(this._getAnchor('zoom'), getLang('PDFJS::ZOOM_TITLE'));
	gui.tooltip._add(this._getAnchor('rotate'), getLang('PDFJS::PAGE_ROTATE_CW_LABEL'));
	gui.tooltip._add(this._getAnchor('pin'), getLang('CHAT::PIN'));
	gui.tooltip._add(this._getAnchor('download'), getLang('ATTACHMENT::DOWNLOAD'));
	gui.tooltip._add(this._getAnchor('full'), getLang('DOCUMENT::FULLSCREEN'));
	gui.tooltip._add(this._getAnchor('close'), getLang('FORM_BUTTONS::CLOSE'));

	this._getAnchor('iframe').contentWindow.addEventListener('resize', function() {
		me.__resizeImage(me.__img);
	});
};

_me.__destructor = function() {
	this._disobeyEvent('imageLoaded', [this, '__imageLoaded']);
	if (gui.socket)
		gui.socket.api._disobeyEvent('onnotify', [this, '__notify']);
};

_me.__notify = function(aData) {
	var index = -1;
	for(var i in this.__queue) {
		if ((this.__queue[i].data || {}).EVN_ID === (aData.LINKID || aData.ITEM)) {
			index = i;
			break;
		}
	}

	if (index === -1) {
		return;
	}

	switch (aData.ACTION) {
		case 'reaction':
			this.__queue[i].data.REACTIONS = (this.__queue[i].data.REACTIONS || 0) + 1;
			break;
		case 'reaction-deleted':
			this.__queue[i].data.REACTIONS = this.__queue[i].data.REACTIONS - 1;
			break;
		case 'comment':
			this.__queue[i].data.COMCOUNT = +(this.__queue[i].data.COMCOUNT || 0) + 1;
			break;
		default:
			return;
	}

	this.__createPreview(i, this.__previews[i]);
};

_me.__focus = function(e) { 
	e && e.stopPropagation();
	this._getAnchor('input').focus();
};

_me._next = function() {
	this._value(this.__getNext());
};

_me._prev = function() {
	this._value(this.__getPrev());
};

_me._fill = async function(aData){
	this.__queue = clone(Is.Object(aData)?aData:[], true).map(function(data) {
		if (~data.url.indexOf('/teamchatapi/') && ~data.url.indexOf('files.download') && ~data.url.indexOf('ticket=')) {
			data.url += '&disposition=inline';
		}
		return data;
	});

	await this.__populatePreviews();

	if (this.__queue.length == 1) {
		addcss(this._main, 'single');
	}

	return this;
};

_me.__getNext = function(){
	var next = +this.__value;

	do {
		next = (next + 1) % this.__queue.length;
	} while (next != this.__value && (!this.__queue[next] || (frm_imgview.__cache[this.__queue[next].url] === false)));

	return next;
};

_me.__getPrev = function() {
	var prev = +this.__value;

	do {
		prev = (prev - 1 + this.__queue.length) % this.__queue.length;
	} while (prev != this.__value && (!this.__queue[prev] || (frm_imgview.__cache[this.__queue[prev].url] === false)));

	return prev;
};

_me.__populatePreviews = async function() {
	this.__previews = [];
	for (var i in this.__queue) {
		var q = this.__queue[i];
		if (frm_imgview.__cache[this.__queue[i].url] === false) {
			return;
		}

		await this.__createPreview(i);

		if (!q.thumbnailUrl) {
			this.__preloadImage(i);
		}
	}
	if (!this.__queue.some(function(q, i) {
		return frm_imgview.__cache[this.__queue[i].url] !== false;
	}, this)) {
		this._destruct();
	}
};

_me.__createPreview = async function(i, eReplace) {
	var previews = this._getAnchor('previews');
	var data = this.__queue[i].data;
	var rea_count = 0;
	if (data && data.EVN_METADATA) {
		var reactions = parseURL(parseURL(data.EVN_METADATA).core_reactions_data);
		for (var j in reactions) {
			rea_count += +reactions[j];
		}
	}

	var thumbnail,
		loader = mkElement('div', {
			className: 'obj_loader',
			innerHTML: await (new cTemplate()).tmp('obj_loader')
		});

	loader.querySelector('.loaderp').remove();
	if (this.__queue[i].thumbnailUrl) {
		thumbnail = mkElement('img', {
			src: this.__queue[i].thumbnailUrl,
			onerror: function(i) {
				thumbnail.replaceWith(loader);
				this.__preloadImage(i);
			}.bind(this, i)
		});
	}

	this.__previews[i] = mkElement('div', {
		className: 'preview' + (this.__value == i ? ' active' : ''),
		onclick: function(i, e) {
			this._value(i);
			this.__focus(e);
		}.bind(this, i)
	}, false, [
		thumbnail || loader,
		data && mkElement('div', {
			className: 'meta'
		}, false, [
			data.COMCOUNT && mkElement('div', {
				className: 'replies',
				textContent: data.COMCOUNT
			}),
			rea_count && mkElement('div', {
				className: 'reactions',
				textContent: rea_count
			})
		])
	].filter(Boolean));

	if (eReplace) {
		eReplace.replaceWith(this.__previews[i]);
	} else {
		previews.appendChild(this.__previews[i]);
	}
}

_me._drawPreview = function(i, thumbnailUrl) {
	var loader = this.__previews[i].querySelector('.obj_loader');
	if (loader) {
		loader.replaceWith(mkElement('img', {
			src: thumbnailUrl
		}));
		this.__queue[i].thumbnailUrl = thumbnailUrl;
	}

	this.__exeEvent('imageLoaded', null, {
		index: i
	});
};

_me._value = function(v) {
	if (this._destructed) {
		return;
	}
	if (Is.Defined(v)){
		if (v === false) {
			this._destruct();
		} else if (this.__queue[v] && this.__value != v){
			this._getAnchor('download').classList.toggle('hidden', ~this.__queue[v].url.indexOf('blob:'));
			addcss(this._main, 'loading');

			if (this.__img && this.__img.parentNode){
				this.__img.parentNode.removeChild(this.__img);
			}

			if (frm_imgview.__cache[this.__queue[v].url] === false) {
				this.__value = v;
				return this._next();
			}

			if (frm_imgview.__cache[this.__queue[v].url] instanceof Image) {
				this.__drawImage(frm_imgview.__cache[this.__queue[v].url]);
			} else if (this.__queue[v].previewURL) {
				this.__drawImage(mkElement('img', {
					src: this.__queue[v].previewURL
				}));
			}
			this.__setActive(v);

			this.__preloadImage(v);
			this.__preloadImage(this.__getNext(v));
			this.__preloadImage(this.__getPrev(v));

			this._getAnchor('label').textContent = this.__queue[v].title || '';

			this.__initThread(v);
		}
	} else {
		return this.__value || null;
	}
};

_me.__imageLoaded = function(e, data) {
	if (+this.__value === +data.index) {
		this.__drawImage(frm_imgview.__cache[this.__queue[this.__value].url]);
	}
};

_me.__drawImage = function(img) {
	if (this.__img && this.__img.parentNode){
		this.__img.parentNode.removeChild(this.__img);
		this.__img.style.rotate = '0deg';
	}
	this._getAnchor('img').appendChild(this.__img = img);

	this.__resizeImage(img);

	this.__activateZoomist();

	this.__img.onclick = function(e) {
		e.stopPropagation();
		this.__focus()
	}.bind(this);

	this.__img.ondragstart = function() {
		return false;
	};
	this.__img.ondrop = function() {
		return false;
	};

	removecss(this._main, 'loading');
};

_me.__setActive = function(v) {
	this.__value = v;

	var active = this._main.querySelector('.previews .active');
	if (active) {
		active.classList.remove('active');
	}

	active = this.__previews[v];
	if (active) {
		active.classList.add('active');
		active.scrollIntoView({
			inline: 'nearest'
		});
	}
}

_me.__preloadImage = async function(v) {
	var me = this;

	if (frm_imgview.__cache[this.__queue[v].url] === true || frm_imgview.__cache[this.__queue[v].url] === false) {
		return;
	}

	if (frm_imgview.__cache[this.__queue[v].url] instanceof Image) {
		this._drawPreview(v, this.__queue[v].preview || frm_imgview.__cache[this.__queue[v].url].src);
		return this.__exeEvent('imageLoaded', null, {
			index: v
		});
	}

	frm_imgview.__cache[this.__queue[v].url] = true;

	switch (Path.extension(this.__queue[v].title)) {
		case 'gif':
			var img = mkElement('img', {
				onload: function() {
					frm_imgview.__cache[me.__queue[v].url] = img;
					me._drawPreview(v, this.src);
				},
				onerror: function() {
					frm_imgview.__cache[me.__queue[v].url] = false;
					me.__queue[v] = false;
					me.__previews[v].parentNode.removeChild(me.__previews[v]);
				},
				src: this.__queue[v].url
			});
		break;

		case 'heic':
			var url = dataSet.get('cache', ['image', this.__queue[v].url]);
			if (url) {
				me.__loadImage(v, url);
			} else if (this.__queue[v].url.indexOf('blob:') === 0) {
				dataSet.add('cache', ['image', me.__queue[v].url], this.__queue[v].url);
				me.__loadImage(v, this.__queue[v].url);
			} else {
				await storage.library('heic-to', 'heic-to/dist');
				getRemoteFileContent(this.__queue[v].url, function(response) {
					if (!response) {
						frm_imgview.__cache[me.__queue[v].url] = false;
						me.__queue[v] = false;
						me.__previews[v].parentNode.removeChild(me.__previews[v]);
						return;
					}
					heicTo({ blob: response, toType: "image/jpg", quality: 0.5 }).then(function(newImage) {
						var url = URL.createObjectURL(newImage);
						dataSet.add('cache', ['image', me.__queue[v].url], url);

						me.__loadImage(v, url);
					}).catch(function() {
						frm_imgview.__cache[me.__queue[v].url] = false;
						me.__queue[v] = false;
						me.__previews[v].parentNode.removeChild(me.__previews[v]);
					});
				}, 'blob');
			}
		break;

		default:
			me.__loadImage(v, me.__queue[v].url);
	}
};

_me.__loadImage = function(v, url) {
	var me = this;
	loadImage(url, function(img) {
		if (img.type !== "error") {
			frm_imgview.__cache[me.__queue[v].url] = img;
			me._drawPreview(v, me.__queue[v].url);
		} else {
			frm_imgview.__cache[me.__queue[v].url] = false;
			me.__queue[v] = false;
			me.__previews[v].parentNode.removeChild(me.__previews[v]);
		}
	}, {
		orientation: true
	});
}

_me.__initThread = function(v) {
	clearTimeout(this.__threadTimeout);
	if (this.__queue[v].data) {
		addcss(this._main, 'thread');
		if (!this.thread) {
			this._create('thread', 'obj_rdock_thread', 'thread', '', {
				uploadInstanceId: 'imgView',
				autofocus: false
			});
		}

		this.__threadTimeout = setTimeout(function() {
			if (this._destructed || !this.__queue[v].data) {
				return;
			}
			var iid = this.__queue[v].data.EVN_ID;
			var cid = this.__queue[v].data.EVNCOMEVNID;
			var fid = this.__queue[v].data.fid;
			var aid = this.__queue[v].data.aid;
			if (cid) {
				fid = fid.replace('/' + cid, '');
			}
			fid = fid.replace('/' + iid, '');
			if (WMFolders.getType([aid, fid]) === 'I') {
				!this._destructed && this.thread._init({
					aid: aid,
					fid: fid,
					iid: WMItems.__clientID(cid || iid),
					useCookie: false
				});
			}
		}.bind(this), 500);
	} else if (this.thread) {
		removecss(this._main, 'thread');
		this.thread._destruct();
	}
	this.__resizeImage(this.__img);
};

_me.__pin = function(sVal) {

	var sAction = sVal == 'public' ? 'add_global_pin' : 'add_pin',
		data = this.__queue[this.__value].data;

	if (data.GPINWHEN && sVal === 'public') {
		sAction = 'delete_global_pin';
	} else if (data.PINWHEN && sVal === 'private') {
		sAction = 'delete_pin';
	}

	WMItems.action({aid: data.aid, fid: data.fid, iid: data.iid}, sAction, [function(bOK, aData){
		if (bOK) {
			var arg = {};
			if (sAction == 'add_global_pin' && aData.IQ && aData.IQ[0].RESULT && aData.IQ[0].RESULT[0].LAST_PINNED_ITEM) {
				arg.LAST_PINNED_ITEM = aData.IQ[0].RESULT[0].LAST_PINNED_ITEM[0].VALUE;
			}

			var list = (((gui.frm_main.main || {}).tabs || {}).room || {}).list;
			list && list._fire(data.iid, sAction, arg);

			list = ((gui.frm_main.rslide.thread || {}).thread || {}).list;
			list && list._fire(data.iid, sAction, arg);
		}
	}.bind(this)]);
};

_me.__activateZoomist = function() {
	if (this.__instance) {
		return this.__instance.reset();
	}
	this.__instance = new Zoomist(this._getAnchor('zoomist-container'), {
		maxScale: 4,
		bounds: true,
		draggable: true,
		wheelable: true,
		pinchable: true,
		zoomRatio: 0.1,
		minScale: 1,
		initScale: 1,
		slider: {
			el: this._getAnchor('zoom'),
			direction: 'horizontal'
		}
	});
};

_me.__resizeImage = function(img) {
	if (!img) {
		return;
	}
	var width = img.naturalWidth;
	var height = img.naturalHeight;
	var zoomistWidth = this._getAnchor('area').clientWidth;
	if (this.__queue.length > 1) {
		zoomistWidth -= 160;
	}
	var zoomistHeight = this._getAnchor('area').clientHeight;

	if (height > zoomistHeight) {
		width = width / height * zoomistHeight;
		height = zoomistHeight;
	}
	
	if (width > zoomistWidth) {
		height = height / width * zoomistWidth;
		width = zoomistWidth;
	}

	img.setAttribute('width', width);
	img.setAttribute('height', height);
};