function frm_groupchat() { };

frm_groupchat.prototype = {
	__constructor: async function (aPath, oOptions) {

		this._defaultSize(900, 620, {
			goldenRatio: true,
			minHeight: 400
		});

		this.__options = Object.assign({
			detached: false
		}, oOptions || {});

		this.__path = aPath;

		gui._obeyEvent('ondetach', [this, '_ondetach']);
		this._add_destructor('__destructor');

		if (this.__options.detached) {
			this.__options.uploadInstanceId = 'detached';
			this._detach();
		} else {
			await this.__init();
		}
	},

	__destructor: function () {
		gui._disobeyEvent('ondetach', [this, '_ondetach']);
	},

	__init: async function() {
		//Get default view
		var sDefaultView = (Cookie.get(['views', this.__path.aid, this.__path.fid]) || {}).view || 'room_view';

		//title
		this._title(WMFolders.getFolderName(this.__path), true);

		//header - template
		await this._draw('frm_groupchat_header', 'header');

		//header - search
		await this._create('search', 'obj_search', 'h-search', '', this.__path);

		//BODY
		await this._create('panels', 'obj_slide');
		this.panels._onchange = function () {
			this._main.setAttribute('iw-view', this.panels._value());
		}.bind(this);

		await this.panels._create('room', 'obj_slide_panel');
		this.panels._value('room');

		//groupchat frm
		var opt = {
			remember_folder: false,
			search: this.search,
			popup: true,
			thread: [this, '_openTeamchatThread'],
			buttons: {context: this, anchor: 'h-btn2'},
			selectView:[function(aPath, sView){
				this._selectView(sView);
			}.bind(this)],
			fakeView:[function(){
				this._updateToolbar('room_view');
			}.bind(this)],
			toolbar: null,
			uploadInstanceId: this.__options.uploadInstanceId
		};

		await this.panels.room._create('main', 'frm_main_chat', '', '', this._name, opt);
		this.panels.room.main._showsearch(this.__path);
		this.panels.room.main._serverSort(sDefaultView);

		this.panels.room._onactive = function(){
			var room = this.main.tabs.room;
			if (room._isActive && room.list.__aRequestData.folder && (!room.list.__aRequestData.filter || !room.list.__aRequestData.filter.type))
				WMChat.room.add(room.list, room.list.__aRequestData.folder.fid);

				this.main.text && this.main.text._focus();

		};
		this.panels.room._ondeactive = function(){
			var room = this.main.tabs.room;
			if (room._isActive && room.list.__aRequestData.folder)
				WMChat.room.remove(room.list, room.list.__aRequestData.folder.fid);
		};


		//body - header
		this._initHeader(sDefaultView);
	},

	_selectView: function(sView){
		this._updateToolbar(sView);
		this.panels.room.main._serverSort(sView.replace('_view', ''));
	},

	_initHeader: function (sView) {
		// await this.panels.room.main.chat_toolbar._create('toolbar','obj_hmenu_toolbar','','transparent', false, {
		// 	context: this.panels.room.main
		// });

		this._updateToolbar(sView);
	},

	_updateToolbar: function () {
		if (this.panels.room.main.chat_toolbar.toolbar) {
			this.panels.room.main.chat_toolbar.toolbar.__folderSelect_handler(this.__path);
		}
	},

	_openTeamchatThread: async function (aPath) {
		if (!this.panels.thread) {
			await this.panels._create('thread', 'frm_groupchat_thread');
			await this._create('btn_back', 'obj_button', 'h-btn1', 'ico simple rounded color1 btn_back');
			this.btn_back._value('FORM_BUTTONS::BACK');
			this.btn_back._onclick = function(){
				this.panels._value('room');
			}.bind(this);

			this.panels.thread._onactive = function(){
				this.thread.text && this.thread.text._focus();
			};
		}

		this.panels.thread._init(aPath);
		this.panels._value('thread');
	},

	_ondetach: function(context) {
		if (this._gui !== context) {
			return;
		}

		setTimeout(function() {
			this.__init();
		}.bind(this), 5);
		var doc = this._gui._main.ownerDocument;
		doc.body.addEventListener('click', function(event) {
			var popover = doc.querySelector('.application-popover');
			if (popover && !popover.contains(event.target)) {
				this.search.search.hide();
			}
		}.bind(this), false);
	},

	_onbeforedetach: function(callback) {
		this.thread && this.thread.text && this.thread.text.input.__initEditor('textarea');
		callback();
	}
};