_me = frm_file.prototype;
function frm_file(){};

_me.__constructor = async function() {
	this._skip_teamchat_choose_folder = arguments[6];
	var me = this;

	// Create 'OK' button
	await this._create('x_btn_ok', 'obj_button', 'footer', 'noborder color1');
	this.x_btn_ok._value('FORM_BUTTONS::SAVE');

	await this._create('X_ATTACHMENTS','obj_upload_item');

	//Prepare Upload Object
	if (!this._sItemID){
		this._resizable(false);
		await this._draw('frm_file_main', 'main', {folders:(this._aValues.fullpath)?true:false, teamchat: !!this._skip_teamchat_choose_folder});
		this._defaultSize(740, this._skip_teamchat_choose_folder ? 'auto' : 350);
		this._size(740, this._skip_teamchat_choose_folder ? 'auto' : 350);

		this.__tab1 = this;
	}
	else{
		this._defaultSize(740, 585);
		await this._draw(
			'frm_file',
			'main',
			{
				folders: (this._aValues.fullpath)?true:false,
				revisions:(this._aValues.REVISIONS?true:false),
				disable_html : !GWOthers.getItemAccess('MAIL_SETTINGS_DEFAULT','html_message') && '0' === GWOthers.getItem('MAIL_SETTINGS_DEFAULT','html_message')
			}
		);
		this.X_ATTACHMENTS.file._setMultipleSelection(false);

		if (this._aValues.EVNLOCKOWN_ID && this._aValues.EVNLOCKOWN_ID != sPrimaryAccountGWID)
			this.__readonly = true;

		this.__tab1 = this.maintab.tab1;
	}

	if(this.__tab1.EVNNOTE) {
		//HTML Mode switcher
		this.__tab1.EVNNOTE.select._fillLang({'enabled': "COMPOSE::HTML", 'disabled': "COMPOSE::TEXT", 'code':'RICH::CODE'});
		this.__tab1.EVNNOTE.select._value('enabled');

		// Keyboard esc from rich text area to close window
		this.__tab1.EVNNOTE._onesc = function() {
			me._close(true);
		};

		this.__tab1.EVNNOTE._rtl && this.__tab1.EVNNOTE.__eFrame.contentDocument.body.setAttribute('dir', 'rtl');
	} else {
		await this._create('EVNNOTE', 'obj_chat_input', 'text', '', {
			upload: true
		});
		this.EVNNOTE.input._placeholder(getLang('IM::COMMENT_PH'));
		this.EVNNOTE.input._onsubmit = function(){
			!me.x_btn_ok._disabled() && me.x_btn_ok._onclick();
		};
		this.EVNNOTE._folder({
			aid: this._sAccountID,
			fid: this._sFolderID
		});
	}

	// Create 'CANCEL' button
	await this._create('x_btn_cancel', 'obj_button', 'footer','cancel noborder simple');
	this.x_btn_cancel._value('FORM_BUTTONS::CANCEL');
	this.x_btn_cancel._onclick = function() { me._destruct() };

	this.x_btn_cancel._main.insertAdjacentElement('afterend', mkElement('div', {
		className: 'flex-row-filler'
	}));

	if (this.x_btn_ok)
		this.x_btn_ok._disabled(true);

    this.X_ATTACHMENTS._disabled(this.__readonly);
    this.X_ATTACHMENTS._onchange = function(){
		//Title
		var sName = getLang('FILE::FILE');
		if (this.__idtable)
			for (var i = this.__idtable.length;i--;)
				if (!this.__idtable[i].removed && this.__idtable[i].name){
					sName = this.__idtable[i].description || this.__idtable[i].name || '';

					if (sName.length>64)
						sName = sName.substr(0,50)+'..'+ Path.extension(sName);

					break;
				}
		me._title(sName + (me._aValues.EVNFOLDER ? ' - ' + WMFolders.getFolderPath({aid: me._aValues.aid, fid: me._aValues.fid}) : '') + (me._aValues.EVNEXPIRE > 0 ? ' - ' + getLang('FILE::EXPIRE', [IcewarpDate.unix(me._aValues.EVNEXPIRE).format('L')]) : ''), true);
	};

	await this.__initForm('FILE::FILE');

	if (this.__tab1.x_folders) {
		if (this._sItemID){
			this.__tab1.x_folders._destruct();
			this.__tab1._getAnchor('folder').classList.add('readonly');
		} else {
			this.__tab1.x_folders._onclick = function(){
				gui._create('frm_select_folder','frm_select_folder','','','POPUP_FOLDERS::SELECT_FOLDER',me._sAccountID,me._sFolderID,[me,'__changeFolder'],true,true,['F','Y','I'],'',false,'wk');
			};
		}
	}

	//remove contextmenu
	this.X_ATTACHMENTS._onuploadstart = function(){
		if (me.x_btn_ok)
			me.x_btn_ok._disabled(true);
		if (me.x_btn_cancel)
			me.x_btn_cancel._disabled(true);
	};

	this.X_ATTACHMENTS._onuploadend = function(){
		me.__checkEnableForm();
		if (me.x_btn_cancel)
			me.x_btn_cancel._disabled(false);
	};

	//Registr DropZone
	if (!this.__readonly && this.X_ATTACHMENTS._dropzone)
		this.X_ATTACHMENTS._dropzone(this.__eContainer);

	if((((this._aValues['ATTACHMENTS'] || [])[0] || {})['values'] || {})['ATTDESC']) {
		this.X_ATTACHMENTS.file._disabled(true);
	}

	if (this.__tab1.EVNTYPE) {
		this.__tab1.EVNTYPE._setId([this._sAccountID, this._sFolderID, this._sItemID]);
	}

	this.__checkEnableForm(void 0, false);
};

_me._onresize = function() {
	var
		dialogHeight = this._getAnchor('main').querySelector('.popupmaindialog').offsetHeight,
		height = dialogHeight - 300;
	height = Math.max(height, 90);
	this.__tab1.EVNNOTE._main.style.height = height + 'px';
};

//Update Save As
_me.__checkEnableForm = function(b, show_error){
	var disabled = false;
	show_error = show_error === void 0 ? true : show_error;
	if (this.x_btn_ok){
		var that = this;
		if(!this._getAnchor('name')) {
			that = this.maintab.tab1;
		}
		var is_filename = Is.Filename(that._getAnchor('name').value);
		if(is_filename) {
			that._getAnchor('name').classList.remove('error');
		} else if (show_error) {
			that._getAnchor('name').classList.add('error');
		}
		disabled = Is.Defined(b)?b:!is_filename;
		this.x_btn_ok._disabled(disabled);
	}
	return !disabled;
};

_me.__print = async function(aValues){
	aValues = aValues.values;

	if (!gui.print)
		await gui._create('print','frm_print');

	gui.print._add('F', aValues);
};

_me.__loadItems = async function() {
	var me = this;

	if (this.__tab1.EVNNOTE.select){
		if (!this._aValues || !this._aValues.EVNDESCFORMAT || this._aValues.EVNDESCFORMAT.toLowerCase() != 'text/plain')
			this.__tab1.EVNNOTE.select._value('enabled');
		else
			this.__tab1.EVNNOTE.select._value('disabled');
	}

	if (this._aValues['ATTACHMENTS'] || this._aValues['PUSH_ATTACHMENTS']){
		var out = [], tmp, i;

		if (this._aValues['ATTACHMENTS']){
			for (i in this._aValues['ATTACHMENTS']) {

				if (~['thumbnail', 'pdf'].indexOf(this._aValues['ATTACHMENTS'][i]['values']['ATTTYPE']))
					continue;

				tmp = {
					'name': (this._aValues['ATTACHMENTS'][i]['values']['ATTDESC'] || '').unescapeHTML(),
					'class': this._aValues['ATTACHMENTS'][i]['values']['ATTTYPE'],
					'id': i,
					'size': this._aValues['ATTACHMENTS'][i]['values']['ATTSIZE'],
				};

				if (this._aValues['ATTACHMENTS'][i]['values']['ATTPARAMS'])
					tmp.mime = this._aValues['ATTACHMENTS'][i]['values']['ATTPARAMS'].split('=')[1];

				if (this._aValues['ATTACHMENTS'][i]['values']['fullpath'])
					tmp.fullpath = this._aValues['ATTACHMENTS'][i]['values']['fullpath'];
				else
				if (this._aValues.fullpath)
					tmp.fullpath = this._aValues.fullpath;
				else
				if (this._sItemID)
					tmp.folder = this._sAccountID+'/'+this._sFolderID+'/'+WMItems.__serverID(this._sItemID);

				out.push(tmp);
			}
		}

		if (this._aValues['PUSH_ATTACHMENTS']){
			//path = this._aValues['PUSH_ATTACHMENTS'][0]['fullpath'].substr(0, this._aValues['PUSH_ATTACHMENTS'][0]['fullpath'].lastIndexOf('/'));

			for (i in this._aValues['PUSH_ATTACHMENTS']) {
				tmp = {
					'name': this._aValues['PUSH_ATTACHMENTS'][0]['title'],
					'id': this._aValues['PUSH_ATTACHMENTS'][0]['id'],
					'size': this._aValues['PUSH_ATTACHMENTS'][0]['size'],
					'class': this._aValues['PUSH_ATTACHMENTS'][0]['embedded'] ? 'item' : 'itemlink',
					'fullpath': this._aValues['PUSH_ATTACHMENTS'][0]['fullpath']
				};

				out.push(tmp);
			}
		}

		if (this._aValues.fullpath || !this._sItemID)
			this.X_ATTACHMENTS._value({values: out});
		else
			this.X_ATTACHMENTS._value({'folder': this._sAccountID+'/'+this._sFolderID+'/'+WMItems.__serverID(this._sItemID), 'values': out});

		var extension = Path.extension(out[0].name),
			label = '', type, preview,
			mime = out[0].mime || '';

		if (Item.imageSupport(out[0].name)) {
			label = getLang('ITEMVIEW::MIME_IMG');
			type = 'image';
			preview = true;
		} else if(~mime.indexOf('video')) {
			type = 'video';
			label = getLang('ITEMVIEW::MIME_VIDEO');
		} else if(~mime.indexOf('audio')) {
			type = 'audio';
			label = getLang('ITEMVIEW::MIME_SOUND');
		} else if(~mime.indexOf('image')) {
			type = 'image';
			label = getLang('ITEMVIEW::MIME_IMG');
		} else if(~mime.indexOf('template')) {
			label = getLang('ITEMVIEW::MIME_TPL');
		} else if(~mime.indexOf('compressed')) {
			label = getLang('ITEMVIEW::MIME_ARCHIVE');
		} else if(extension.toLowerCase() === 'pdf') {
			type = 'pdf';
			label = getLang('ITEMVIEW::MIME_PDF');
		} else if (Item.isDocument(out[0].name)) {
			label = getLang('ITEMVIEW::MIME_DOC');
			type = 'doc';
		} else if (Item.isPresentation(out[0].name)) {
			label = getLang('ITEMVIEW::MIME_PRESENTATION');
			type = 'ppt';
		} else if (Item.isSpreadsheet(out[0].name)) {
			label = getLang('ITEMVIEW::MIME_SS');
			type = 'xls';
		} else if (Item.videoSupport(out[0].name)) {
			label = getLang('ITEMVIEW::MIME_VIDEO');
			type = 'video';
		} else if (Item.audioSupport(out[0].name)) {
			label = getLang('ITEMVIEW::MIME_SOUND');
			type = 'audio';
		} else if (Item.editSupport(out[0].name)) {
			label = getLang('ITEMVIEW::MIME_TXT');
			type = 'note';
		}

		var that = this;
		if(!this._getAnchor('icon')) {
			that = this.maintab.tab1;
		} else {
			this.x_btn_ok._value('MAIN_MENU::NEW_DOCUMENT');
			this.x_btn_ok._main.classList.add('new_document');
		}

		if (preview) {
			that._getAnchor('icon').appendChild(mkElement('img', {
				className: 'preview',
				src: await Item.webdavURL([this._sAccountID, this._sFolderID, this._sItemID], this.X_ATTACHMENTS.__idtable[0].name)
			}))
		}  else {
			that._getAnchor('icon').appendChild(mkElement('div', {
				className: 'icon ' + type,
				text: label
			}));
		}

		that._getAnchor('extension').textContent = '.' + extension;

		if (!WMFolders.getAccess({aid: this._sAccountID, fid: this._sFolderID}).write) {
			this._sFolderID = Mapping.getDefaultFolderForGWType('F');
			this._sAccountID = sPrimaryAccount;
		}
		this.__changeFolder(this._sAccountID, this._sFolderID, this._sItemID);

		if (this._skip_teamchat_choose_folder && ~['I', 'Y'].indexOf(WMFolders.getType([this._sAccountID, this._sFolderID]))) {
			this.__tab1.x_folders._destruct();
		} else {
			this.__tab1.x_folders._value('DOCUMENT::CHANGE_FOLDER');
		}

		that._getAnchor('name').value = this.X_ATTACHMENTS.__idtable[0].name.split('.').slice(0, -1).join('.');
		that._getAnchor('name').focus();
		that._getAnchor('name').setAttribute('placeholder', getLang('DOCUMENT::NAME_HELPER'));
		that._getAnchor('name').addEventListener('keyup', function(evn) {
			if (evn.keyCode === 13) {
				if(!this.__checkEnableForm()) {
					return;
				}
				evn.target.disabled = true;
				evn.target.setAttribute('disabled', 'disabled');
				evn.target.blur();
				return this.x_btn_ok._onclick();
			}

			var files = this.X_ATTACHMENTS._value();
			for(var i in files) {
				if (files[i].id)
					this.X_ATTACHMENTS._rename(files[i].id, that._getAnchor('name').value + '.' + extension);
			}

			this.__checkEnableForm();
		}.bind(this));

		this._colapsed = true;
		that._getAnchor('separator') && that._getAnchor('separator').addEventListener('click', function() {
			this._onresize();
			if (this._colapsed) {
				that._getAnchor('separator_text').textContent = getLang('DOCUMENT::SHOW_LESS_OPTIONS');
				that._getAnchor('separator').classList.add('less');
				var frmtbl = that._getAnchor('main').querySelector('.popupmaindialog > .frmtbl');
				frmtbl && this._defaultSize(740, 600);
				this._resizable(true);
			} else {
				that._getAnchor('separator_text').textContent = getLang('DOCUMENT::SHOW_MORE_OPTIONS');
				that._getAnchor('separator').classList.remove('less');
				if(this.__position.max) {
					this._maximize();
				}
				this._defaultSize(740, 350);
				this._resizable(false);
			}
			this._colapsed = !this._colapsed;
		}.bind(this));
	}

	//General
	loadDataIntoForm(this.__tab1, this._aValues);
	if (this.__readonly && this.__tab1._type !== 'obj_tab'){
		this.EVNNOTE && this.EVNNOTE._disabled(true);
		this.EVNTYPE && this.EVNTYPE._readonly(true);
	}

	//Resources
	if (this.maintab && this.maintab['revisions'])
	this.maintab['revisions']._onactive = async function (bFirstTime) {
		if (bFirstTime){
			//Layout
			var btncheck = function (){
				var l = me.maintab['revisions'].list._value().length<1,
					b = me.x_btn_ok._disabled() || l || (me.__readonly?true:false);

				me.maintab['revisions'].download._disabled(l);
				me.maintab['revisions'].edit._disabled(b);
				me.maintab['revisions'].revert._disabled(b);
				me.maintab['revisions'].remove._disabled(b);
			};

			//DataGrid
			this.list.__sortColumn = 'DATE';
			this.list.__sortType = 'desc';
			await this.list._addColumns({
				DATE:{title:"DATAGRID_ITEMS_VIEW::DATE",width:120,arg:{sort:'asc'}},
				OWNER:{title:"DATAGRID_ITEMS_VIEW::SNDOWNER",width:200,arg:{sort:'asc'}},
				COMMENT: {title: "MAIL_VIEW::COMMENT", width: 100, mode:'%', encode: true}
			});
			this.list._onchange = function(){
				btncheck();
			};
			this.list._fill2 = function(){
				var aData = [];
				for (var id in me._aValues['REVISIONS']){
					aData.push({data:{
						DATE:[IcewarpDate.unix(me._aValues['REVISIONS'][id].values.REVTIMESTAMP).format('L LT'),me._aValues['REVISIONS'][id].values.REVTIMESTAMP],
						OWNER:me._aValues['REVISIONS'][id].values.REVEMAIL,
						COMMENT:[me._aValues['REVISIONS'][id].values.REVCOMMENT,'',me._aValues['REVISIONS'][id].values.REVCOMMENT]
					},
					arg:{id:id}});
				}

				this._fill(aData);
				btncheck();
			};

/*
 [425b751de38f]
.. [values]
.... [REVID](string) = 425b751de38f
.... [REVHASH](string) = de893bbfa2ae667f1640abad07174341
.... [REVTIMESTAMP](string) = 1361972460
.... [REVOWNER](string) = 3f4e548304eb
.... [REVCOMMENT](string) = My first document revision

*/
			this.list._fill2();

			this.list._ondblclick = function(){
				this._parent.download._onclick();
			};
			this.list._oncontext = async function(e,elm,arg,row){
				if (arg && arg.id){

					if (inArray(this._value(),row)<0)
						this._value([row]);

					var cmenu = await gui._create('cmenu','obj_context');
						await cmenu._fill([
							{title:'ATTACHMENT::DOWNLOAD',arg:[me.maintab.revisions.download,'_onclick']},
							{title:'ITEM::EDIT_COMMENT',arg:[me.maintab.revisions.edit,'_onclick'],disabled:me.maintab.revisions.edit._disabled()},
							{title:'ITEM::REVERT',arg:[me.maintab.revisions.revert,'_onclick'],disabled:me.maintab.revisions.revert._disabled()},
							{title:'ATTACHMENT::REMOVE',arg:[me.maintab.revisions.remove,'_onclick'],disabled:me.maintab.revisions.remove._disabled()}
						]);
						cmenu._place(e.clientX,e.clientY);
				}
			};

			//Buttons
			var click = function(){

				if (this._disabled()) return;

				for (var attid in me._aValues['ATTACHMENTS'])
					break;

				var v  = this._parent.list._value();
				if (attid && v){

					//Multiple
					if (this._name == 'remove'){
						var uids = [];
						for(var i in v)
							if (this._parent.list._aData[v[i]] && this._parent.list._aData[v[i]].arg)
								uids.push({uid:this._parent.list._aData[v[i]].arg.id});

						if (uids.length)
							WMItems.add([me._sAccountID,me._sFolderID,me._sItemID],{revisions:uids},'','','',[function(bOK){

								if (bOK == true){

									for(var i in uids)
										delete me._aValues['REVISIONS'][uids[i].uid];

									me.maintab.revisions.list._fill2();
								}
							}]);
					}
					else
					//Single
					if ((v = v[0]) && (v = this._parent.list._aData[v]) && (v = v.arg))
						switch (this._name)	{
							case 'download':
								downloadItem(buildURL({'dlsess': dataSet.get('main', ['dlsess']), 'class': 'revision', 'fullpath': me._sAccountID+'/'+me._sFolderID+'/'+WMItems.__serverID(me._sItemID)+'|'+v.id+'/'+attid}));
								break;

							case 'edit':
								this._parent.list._editColumn(this._parent.list._value()[0],'COMMENT',{},[function(sComment){
									WMItems.add([me._sAccountID,me._sFolderID,me._sItemID],{revisions:[{uid:v.id, values:{revcomment:sComment}}]},'','','',[function(bOK){
										if (bOK == true)
											me._aValues['REVISIONS'][v.id].values.REVCOMMENT = sComment;

										me.maintab.revisions.list._fill2();
									}]);
									return sComment.escapeHTML();
								}]);
								break;

							case 'revert':
								WMItems.action({aid:me._sAccountID,fid:me._sFolderID,iid:me._sItemID,values:{revision:v.id}},'revert_to_revision',[function(){
									me._destruct();
									Item.openwindow([me._sAccountID,me._sFolderID,me._sItemID]);
								}]);

								break;
						}
				}
			};

			this.download._onclick = click;
			this.edit._onclick = click;
			this.revert._onclick = click;
			this.remove._onclick = click;
		}
	};
};

_me.__changeFolder = function (sAccount, sFolder, sItem) {
	this._sAccountID = sAccount;
	this._sFolderID = sFolder;
	this._id = [sAccount, sFolder];

	if (sItem) {
		this._id.push(sItem);
	}

	var sPath, data = dataSet.get('folders', [sAccount, sFolder]);

	if (WMFolders.getType(this._id) == 'I' && data.OWNER && ~data.OWNER.indexOf('##internalservicedomain.icewarp.com##')){
		var yf = dataSet.get('folders', [sAccount, Path.basedir(sFolder)]);
		sPath = (yf.NAME || yf.RELATIVE_PATH) + '/' + data.NAME;
	}
	else{
		sPath = WMFolders.getFolderPath({aid: sAccount, fid: sFolder});
	}

	(this._getAnchor('folder') ? this : this.maintab.tab1)._getAnchor('folder').textContent = sPath;

	//Update footer
	this.__sharetype();
};

_me.__saveItems = function(aValues) {
	var is_teamchat_folder = WMFolders.getType({aid: this._sAccountID, fid: this._sFolderID}) === 'I';

	if(this.__tab1.EVNNOTE.select && !is_teamchat_folder) {
		aValues['values']['EVNDESCFORMAT'] = (this.__tab1.EVNNOTE.select._value() === 'disabled')? 'text/plain':'text/html';
		this.__tab1.EVNNOTE.__output_format = aValues.values.EVNDESCFORMAT !== 'text/plain';
	} else {
		aValues['values']['EVNDESCFORMAT'] = 'text/plain';
		this.__tab1.EVNNOTE.__output_format = false;
	}
	aValues.values.EVNNOTE = this.__tab1.EVNNOTE._value();
	if(is_teamchat_folder) {
		var turndownService = new TurndownService();
		turndownService.use([turndownPluginGfm.tables]);
		aValues.values.EVNNOTE = turndownService.turndown(aValues.values.EVNNOTE).replace(/!\[.*?\]\(.*?\)/g, '').replace(/<\/?img.*?>/g, '');
	}

	var addon;
	aValues['values']['EVNCLASS'] = 'F';
	if (!Is.Empty(addon = this.X_ATTACHMENTS._getAddon())) {
		if (this._sItemID || addon.length == 1){
			aValues['values']['EVNLOCATION'] = aValues['values']['EVNTITLE'] = addon[0].values.description;
			aValues['values']['EVNRID'] = aValues['values']['EVNLOCATION'];
			aValues['values']['EVNCOMPLETE'] = this.X_ATTACHMENTS._getSize();
		}

		var now = new IcewarpDate();
		aValues['values']['EVNSTARTDATE'] = now.format(IcewarpDate.JULIAN);
		aValues['values']['EVNSTARTTIME'] = now.format(IcewarpDate.JULIAN_TIME);

		//Rename on Item level
		if (addon.length == 1 && addon[0].values.description)
			aValues.values.EVNTITLE = aValues.values.EVNLOCATION = aValues.values.EVNRID = addon[0].values.description;

		aValues['ATTACHMENTS'] = addon;
	}
};

_me._openFileAndListFolder = function (bOk,aData,bAuto){

	this._listFolder(bOk,aData,bAuto);

	if(!bAuto && bOk === true && aData.name) {
		if (Item.officeSupport(aData.name)) {
			var arg = {
				EVN_ID: aData.teamchat_link || aData.id,
				EVNCLASS: aData.teamchat_link?'R':'F',
				EVNTITLE: aData.name,
				aid: this._id[0],
				fid: this._id[1],
				iid: WMItems.__clientID(aData.id)
			};

			Item.officeOpen(arg,[Item.downloadFile,[[arg['aid'], arg['fid'], arg['iid']]]], Path.extension(aData.name));
		} else {
			Item.previewItem([this._id[0], this._id[1], WMItems.__clientID(aData.id)], aData.name);
		}
	}
};

_me.__autoreopen = async function(data) {
	// do not reinit attachments
	var attachments = this._aValues.ATTACHMENTS;
	delete this._aValues.ATTACHMENTS;

	Object.assign(this._aValues, data.values);
	await this.__loadItems();

	this._aValues.ATTACHMENTS = attachments;
};