_me = frm_event2.prototype;

function frm_event2() {};

_me.__constructor = async function () {

	await storage.library('short_url');
	await storage.library('textversion', 'textversion');
	await storage.library('purify.wrapper', 'purify');

	this.__tools = new wm_tools();
	this.__attendee = !!(this._aValues.EVNFLAGS & 2);

	if(!Object.keys(this._aValues).length) {
		return this._destruct();
	}

	if (this._repeating) {
		if (this._aValues.EVNCLASS === 'E' && this._aValues._TZEVNSTARTDATE === this._aValues._TZEXPEVNSTARTDATE) {
			this.__firstOccurrence = true;
		}
		this._aValues['EXPDATE'] = this._aReccurenceValues['EVNSTARTDATE'];

		if (this._aValues['EVNSTARTTIME'] < 0) {
			this._aValues['EVNSTARTDATE'] = this._aValues._TZEXPEVNSTARTDATE;
			this._aValues['EVNENDDATE'] = this._aValues._TZEXPEVNENDDATE;
		} else {
			this._aValues['_TZEVNSTARTDATE'] = this._aValues._TZEXPEVNSTARTDATE;
			this._aValues['_TZEVNSTARTTIME'] = this._aValues._TZEXPEVNSTARTTIME;
			this._aValues['_TZEVNENDDATE'] = this._aValues._TZEXPEVNENDDATE;
			this._aValues['_TZEVNENDTIME'] = this._aValues._TZEXPEVNENDTIME;
		}
	}

	await this.__constructor2();
};

_me._onclose = async function (b) {
	if (b){
		if (await this._userEdited()) {

			// For cloned event there is special callback which deletes the cloned event
			var callback = this._bClone ? '__confirmedClone' : '__confirmed';

			var confirm = await gui._create('frm_confirm', 'frm_confirm', '', '', [this, callback], 'CONFIRMATION::ARE_YOU_SURE', 'CONFIRMATION::ALL_CHANGES_WILL_BE_LOST');
			confirm._closable(false);
			return false;
		}
		else
		if (this._bClone){
			this.__confirmedClone(true);
		}
	}

	return true;
};

/**
 * Called when event edit dialog is being closed unsaved after user confirms confirm dialog
 *
 * @returns {undefined}
 */
_me.__confirmedClone = function (bForce) {
	var refreshParameters = [
		this._sAccountID,
		this._sFolderID, [this._sItemID]
	];
	var removeParameters = {
		'aid': refreshParameters[0],
		'fid': refreshParameters[1],
		'iid': refreshParameters[2]
	};

	!bForce && this.__hide('ATTACHMENT::SAVING');

	WMItems.remove(removeParameters, 'items', '', 'folders', [function (bOK) {
		if (bOK) {
			!bForce && this._close(false);
			Item.__refreshView(refreshParameters);
		} else {
			!bForce && this.__show();
		}
	}.bind(this)]);
};

_me.__onBeforeStoreItems = function() {
	if (this._repeating) {
		gui._create('frm_confirm_repeating', 'frm_confirm_repeating', '', '', [this, '__editRepeating'], 'REPEATING_CONFIRM::TITLE_EDIT', this.__attendee ? 'REPEATING_CONFIRM::TEXT_EDIT' : 'REPEATING_CONFIRM::TEXT_EDIT2', '', this.__attendee, '', '', '', !this.__attendee);
	} else {
		this.__storeItems();
	}
}

_me.__editRepeating = function (nType) {
	if (nType === 2) {
		this._aValues['EXPFOLLOWING'] = 'true';
		if (this.__firstOccurrence) {
			delete this._aValues.EXPDATE;
		}
	}

	this.__storeItems()
};

_me.__constructor2 = async function () {
	this._defaultSize(800, 550, {
		goldenRatio: true,
		minWidth: 750
	});

	this._aValues = this._aValues || {};
	this._aValues.EVNCLASS = this._aValues.EVNCLASS || 'E';

	var me = this, i,
		gchat = WMFolders.getType([this._sAccountID, this._sFolderID]) == 'I';

	this.__real_email = sPrimaryAccount;
	if(~this.__real_email.indexOf('@##')) {
		this.__real_email = this.__real_email.split('@##')[0].replace('_', '@');
	}

	this.__oresponse = this.__oresponse || {};
	if (this.__oresponse.propose) {
		this.__readonly = true;
	}

	this.__show();

	var aData = {};
	if (this._aValues.EVNCLASS === 'O' || this._aValues.EXPDATE)
		aData.noRepeat = true;

	if (this._aValues.EXPDATE)
		aData.occurrence = true;

	if (!Is.Defined(this._id[2])) {
		var sFolder = '';
		if (WMFolders.getAccess({
				aid: this._id[0],
				fid: this._id[1]
			}, 'write')) {
			if (!this._sFolderID.indexOf('__@@VIRTUAL@@__/')) {
				var aFolders = dataSet.get('folders', [this._id[0], this._id[1], 'VIRTUAL', 'FOLDERS']);
				for (i in aFolders || {}) {
					if (aFolders[i]) {
						sFolder = i;
						break;
					}
				}
			} else {
				sFolder = this._id[1];
			}
		}

		this._id[1] = sFolder || Mapping.getDefaultFolderForGWType('E');
		this.x_btn_ok._value('FORM_BUTTONS::CREATE');
	}

	var sOwner = me._aValues.EVNORGANIZER?MailAddress.splitEmailsAndNames(me._aValues.EVNORGANIZER)[0].email:'';
	if (!sOwner) {
		var meta = '';
		//get owner from EVN_METADATA
		if (this._aValues['EVN_METADATA'] && (meta = parseURL(this._aValues['EVN_METADATA'])) && meta.core_own_email){
			sOwner = meta.core_own_email;
		}
		//fallback
		else{
			var tmpf = Path.split(this._id[1])[0];
			if (~(dataSet.get('folders', [this._id[0], tmpf, 'TYPE']) || '').indexOf('A'))
				sOwner = tmpf.replace(/~/g, '');
			else {
				sOwner = me._sAccountID;
			}
		}
	}

	this.__moderator = sOwner === sPrimaryAccount && !this.__readonly;
	for (i in this._aValues.CONTACTS) {
		if (this._aValues.CONTACTS[i].values.CNTEMAIL === this.__real_email) {
			this.__moderator = this._aValues.CONTACTS[i].values.CNTMODERATOR == 1;
			break;
		}
	}

	this.__evnid = {
		aid: me._id[0],
		fid: me._id[1],
		iid: me._id[2],
		owner_id: sOwner
	};

	if (Is.Defined(this._aValues._TZID)) {
		this._aValues['EVNSTARTDATE'] = this._aValues._TZEVNSTARTDATE;
		this._aValues['EVNENDDATE'] = this._aValues._TZEVNENDDATE;
		this._aValues['EVNSTARTTIME'] = this._aValues._TZEVNSTARTTIME;
		this._aValues['EVNENDTIME'] = this._aValues._TZEVNENDTIME;
		this._aValues['TZID'] = this._aValues._TZID;
	}

	if (!Is.Defined(this._id[2])) {
		aData.path = true;
	}

	aData.guest = !!sPrimaryAccountGUEST;
	aData.conference = sPrimaryAccountCONFERENCE && ~['jitsi', 'jitsi-full'].indexOf(dataSet.get('accounts',[sPrimaryAccount, 'MEETING_PROVIDER']));
	aData.conference_link = wm_conference.get(this._aValues.EVNMEETINGID).getLink();
	aData.recording = sPrimaryAccountRECORDING;

	//aData.disable_html = !GWOthers.getItemAccess('MAIL_SETTINGS_DEFAULT','html_message') && '0' === GWOthers.getItem('MAIL_SETTINGS_DEFAULT','html_message');
	await this._draw('frm_event2', 'main', aData);

	if (Is.Defined(this._id[2]) && !this.__oresponse.propose) {
		addcss(this._getAnchor('block_time'), 'collapsed');
		addcss(this._getAnchor('conference_block'), 'collapsed');
	}

	if (gchat){
		if (!Is.Defined(this._id[2])) {
			//GroupChat 1
			this._aValues['CONTACTS'] = this._aValues['CONTACTS'] || {};
			this._aValues['CONTACTS'][getFreeKey(this._aValues['CONTACTS'])] = {
				values: {
					CNTEMAIL: '__@@groupchat@@__',
					CNTCONTACTNAME: getLang('ATTENDEES::ALL_ATTENDEES'),
					CNTROLE:'Q',
					CNTSTATUS:'B',
					NEW:true
				}
			};
		}
		else
		//Translate team chat "All Attendees"
		if (this._aValues['CONTACTS']){
			for(i in this._aValues['CONTACTS']){
				if (Object.prototype.hasOwnProperty.call(this._aValues['CONTACTS'], i) && this._aValues['CONTACTS'][i].values && this._aValues['CONTACTS'][i].values.CNTEMAIL === '__@@groupchat@@__' && !this._aValues['CONTACTS'][i].values.CNTCONTACTNAME){
					this._aValues['CONTACTS'][i].values.CNTCONTACTNAME = getLang('ATTENDEES::ALL_ATTENDEES');
					break;
				}
			}
		}
	}

	await this._create('_scrollbar', 'obj_scrollbar');
	this._scrollbar._scrollbar(this._getAnchor('left_content'), this._getAnchor('left_column'));
	await this._create('_scrollbar2', 'obj_scrollbar');
	this._scrollbar2._scrollbar(this._getAnchor('user_list'), this._getAnchor('user_list_container'));

	if(this.x_include_in_my_cal) {
		this.X_PATH._onchange = function(value) {
			var tmp = Path.split(value);
			var account = tmp[0];
			var folder = tmp[1];
			var paths = folder.split('/');

			var is_public = false;
			while(!is_public && paths.length) {
				is_public = dataSet.get('folders', [account, paths.join('/'), 'PUBLIC']);
				paths.pop();
			}

			var folder_data = dataSet.get('folders', [account, folder]);
			if (Is.Defined(me._id[2]) || (folder_data && (!folder_data.OWNER || (folder_data.OWNER === me.__real_email))) || is_public) {
				me.x_include_in_my_cal._main.setAttribute('hidden', '');
				me.x_include_in_my_cal._checked(false);
			} else {
				me.x_include_in_my_cal._main.removeAttribute('hidden');
			}

			if(me.x_list) {
				me.x_list.__users.forEach(function(user) {
					if (user.groupchat) {
						user.active = true;
						me.x_list._removeUser(true);
					}
				});
				me.x_list._removeUser();

				if (WMFolders.getType([account, folder]) === 'I') {
					me.X_PATH._value(sPrimaryAccount + '/' + Mapping.getDefaultFolderForGWType('E'), true);
					WMItems.list({
						aid: account,
						fid: '__@@GROUP@@__/' + folder,
						values:[],
						filter: {
							sort: 'FRTNAME asc, FRTEMAIL asc'
						}
					}, '', '', '', [function(aData) {
						if (aData && (aData = aData[account]) && (aData = aData['__@@GROUP@@__/' + folder])){
							for(var id in aData) {
								if (id.indexOf('*') === 0) {
									me.x_list._addUser({
										email: aData[id].FRTEMAIL,
										name: aData[id].FRTNAME,
										role: 'Q',
										status: 'B',
										action: 'new',
										groupchat: true
									});
								}
							}
						}
					}]);
				}
			}
		};
	}

	if (!Is.Defined(this._id[2])) {
		if (gchat) {
			this.X_PATH._disabled(true);
		}
		this.X_PATH._value(this._id[0] + '/' + this._id[1]);
	} else if (WMFolders.getType([this._sAccountID, this._sFolderID]) === 'I') {
		this.X_PATH._main.parentNode.parentNode.setAttribute('hidden', '');
	} else {
		this.X_PATH._setType('E');
		this.X_PATH._value(this._id[0] + '/' + this._aValues.EVNFOLDER);
	}

	if (this.MEETING_ACTION) {
		this.MEETING_ACTION._onchange = function(event, checked) {
			me._main.classList.toggle('conference', checked);
			if (event) {
				if (checked) { // enabled and not prefilled
					event.stopPropagation();
					me._openConferenceSetup();
				} else {
					me._main.removeAttribute('iw-view');
				}
			}
			me._updateConferenceSummary();
		};
		this.MEETING_ACTION._value(this._aValues.conference);

		if (this._aValues.EVNMEETINGID) {
			if(this.MEETING_PASSWORD) {
				this.MEETING_PASSWORD._value(this._aValues.MEETING_PASSWORD || this._aValues.EVNMEETINGPASSWORD);
				this.MEETING_PASSWORD._readonly(!this.__moderator && (this.__readonly || this.__attendee));
			}
			this._aValues.MEETING_ACTION = this.MEETING_ACTION._checked(true) ? 'edit' : 0;
			this._main.classList.add('conference');

			await this._create('x_btn_join', 'obj_button', {
				position: 'afterend',
				element: this.x_btn_ok._main
			}, 'color3 pad');
			this.x_btn_join._value('CONFERENCE::JOIN');

			this._getAnchor('conference_link').classList.remove('hidden');

			this.x_btn_join._onclick = async function() {
				await storage.library('wm_conference');
				wm_conference.get(this._aValues.EVNMEETINGID, this._aValues).join();
			}.bind(this);
		} else {
			this.MEETING_ACTION._disabled(!!this.__oresponse.propose || this.__attendee);
			if (sPrimaryAccountGUEST || (window.TeamChatAPI && TeamChatAPI.teamChatOnly())) {
				this.MEETING_ACTION._main.parentNode.parentNode.setAttribute('hidden', '');
			}
		}
		this.x_enable_password._onchange = async function(event, enabled) {
			if(enabled) {
				await storage.library('wordGen', 'wordGen');
				this.MEETING_PASSWORD._value(this.MEETING_PASSWORD._value() || (wordGen() + (Math.random() * 899999999 + 100000000)).slice(0, 10));
				removecss(this.MEETING_PASSWORD._main, 'hidden');
				this.MEETING_PASSWORD.__eIN.select();
			} else {
				this.MEETING_PASSWORD._value('');
				addcss(this.MEETING_PASSWORD._main, 'hidden');
			}
			this._updateConferenceSummary();
		}.bind(this);
		this.x_enable_password._value(!!this._aValues.MEETING_PASSWORD || !!this._aValues.EVNMEETINGPASSWORD);

		this.MEETING_PASSWORD && this.MEETING_PASSWORD.__setMask({
				'toggle': ['', getLang('COMMON::SHOW'), 2]
			},
			[function () {
				if (me.MEETING_PASSWORD.__eIN.getAttribute('type') === 'text') {
					me.MEETING_PASSWORD.__eIN.setAttribute('type', 'password');
				} else {
					me.MEETING_PASSWORD.__eIN.setAttribute('type', 'text');
				}
			}]
		);
		if (this.x_enable_recording) {
			this.x_enable_recording._onchange = function() {
				this._updateConferenceSummary();
			}.bind(this);
			this.x_enable_recording._value(this._aValues.EVNFLAGS & 256);
		}

		this.x_enable_lobby._onchange = function() {
			this._updateConferenceSummary();
			this.__updateLobbySettings();
		}.bind(this);
		this.x_enable_lobby._value(this._aValues.EVNFLAGS & 512);
		this.__updateLobbySettings();

		if (!this.__moderator && (!!this.__oresponse.propose || this.__attendee)) {
			if (this.x_enable_recording) {
				this.x_enable_recording._disabled(true);
			}
			if (this.x_enable_lobby) {
				this.x_enable_lobby._disabled(true);
			}
			if (this.x_enable_password) {
				this.x_enable_password._disabled(true);
			}
			if (this.x_enable_lobby_background) {
				this.x_enable_lobby_background._disabled(true);
			}

			if (this.MEETING_PASSWORD) {
				this.MEETING_PASSWORD._readonly(true);
			}
		}
}

	await this._create('X_TIMEINTERVAL', 'obj_timeinterval2', '', '', true, true, {
		startDate: this.startDate,
		startTime: this.startTime,
		endDate: this.endDate,
		endTime: this.endTime,
		durationDays: this.durationDays,
		durationTime: this.durationTime,
		timezone: this.timezone,
		tzlink: this.tzlink,
		allDay: this.allDay
	});

	if (!this.__oresponse.propose) {
		this.X_TIMEINTERVAL._disabled(this.__readonly);
		this.x_freebusy._readonly(this.__readonly);
	}
	this.X_REPEATING._disabled(this.__readonly);
	this.X_REMINDERS._disabled(this.__readonly);
	this.X_PATH._disabled(this.__readonly);
	this.X_EVNFLAGS._disabled(this.__readonly);

	// X_REMINDERS
	this.X_REMINDERS._fillLang({
		'0': 'REMINDER::NONE',
		'0M': ['REMINDER::MINUTESBEFORE', ['0']],
		'10M': ['REMINDER::MINUTESBEFORE', ['10']],
		'30M': ['REMINDER::MINUTESBEFORE', ['30']],
		'1H': ['REMINDER::HOURSBEFORE', ['1']],
		'2H': ['REMINDER::HOURSBEFORE', ['2']],
		'1D': ['REMINDER::DAYSBEFORE', ['1']],
		'2D': ['REMINDER::DAYSBEFORE', ['2']],
		'7D': 'REMINDER::WEEKBEFORE',
		'*': 'SETTINGS::CUSTOM'
	});

	var last_remind_value;
	this.X_REMINDERS._onbeforechange = function () {
		last_remind_value = this.__value;
	};

	this.X_REMINDERS._onchange = async function () {
		if (this.__value === '*') {
			if (this.popup && !this.popup._destructed){
				this.popup._focus();
			}
			else{
				this.popup = await gui._create('frm_reminders', 'obj_popup', '', 'frm_reminders');
				this.popup._size(420, 'auto', true);
				this.popup._modal(true);
				this.popup._resizable(false);
				this.popup._dockable(false);

				await this.popup._create('btn_ok', 'obj_button', 'footer', 'ok noborder color1');
				this.popup.btn_ok._value('FORM_BUTTONS::OK');
				await this.popup._create('btn_cancel', 'obj_button', 'footer', 'cancel noborder');
				this.popup.btn_cancel._value('FORM_BUTTONS::CANCEL');

				this.popup._onclose = function(b){
					if (b){
						me.X_REMINDERS._value(last_remind_value);
						me.X_REMINDERS._focus();
					}

					return true;
				};

				this.popup.btn_cancel._onclick = function () {
					me.X_REMINDERS._value(last_remind_value);
					this._parent._destruct();
					me.X_REMINDERS._focus();
				};

				this.popup._title('REMINDER::REMINDER');
				await this.popup._create('X_REMINDERS', 'obj_reminder', 'main', '', 'EVENT_SETTINGS');
				this.popup.X_REMINDERS._value([me._reminderKeyToObject(last_remind_value)]);
				this.popup.btn_ok._onclick = function () {
					me._setReminderSelect(this.X_REMINDERS._value());
					this._destruct();
				}.bind(this.popup);

				this.popup.X_REMINDERS.reminder_1.time.x_text._onerror = function(error) {
					this.btn_ok._disabled(error);
				}.bind(this.popup);
			}
		}
		else
		if (this.popup && !this.popup._destructed)
			this.popup._destruct();
	};

	this.X_REMINDERS._onkeydown = function(e){
		if (this.popup && !this.popup._destructed){
			if (e.keyCode == 27 || e.keyCode == 9)
				this.popup._close(true);

			if (e.keyCode == 27){
				e.preventDefault();
				e.stopPropagation();
			}
		}
	};


	// X_REPEATING
	if (me.__oresponse.propose && !this._aValues.RECURRENCES){
		this.X_REPEATING._disabled(true);
	}
	else{

		var last_repeating_value;
		this.X_REPEATING._onbeforechange = function () {
			last_repeating_value = this.__value;
		};

		this.X_REPEATING._onselect = async function () {
			if (this.__value === '*') {
				if (this.popup && !this.popup._destructed){
					this.popup._focus();
				}
				else{
					this.popup = await gui._create('frm_repeatings', 'obj_popup', '', 'frm_repeatings');
					this.popup._size(650, 'auto', true);
					this.popup._modal(true);
					this.popup._resizable(false);
					this.popup._dockable(false);

					await this.popup._create('btn_ok', 'obj_button', 'footer', 'ok noborder color1');
					this.popup.btn_ok._value('FORM_BUTTONS::OK');
					await this.popup._create('btn_cancel', 'obj_button', 'footer', 'cancel noborder');
					this.popup.btn_cancel._value('FORM_BUTTONS::CANCEL');

					this.popup._onclose = function(b){
						if (b){
							me.X_REPEATING._value(last_repeating_value);
							me.X_REPEATING._focus();
						}

						return true;
					};

					this.popup.btn_cancel._onclick = function () {
						me.X_REPEATING._value(last_repeating_value);
						this._parent._destruct();
						me.X_REPEATING._focus();
					};

					this.popup._title('EVENT::REPEAT');
					await this.popup._create('X_REPEATING', 'obj_repeating', 'main', '');
					this.popup.X_REPEATING._onerror = function(has_error){
						this._parent.btn_ok._disabled(has_error);
					};

					this.popup.X_REPEATING._value(me.X_REPEATING.__rcrvalue || me._repeatingKeyToObject(last_repeating_value));
					this.popup.X_REPEATING._setDate(IcewarpDate.julian(me.X_TIMEINTERVAL._value().EVNSTARTDATE));

					if (me.__oresponse.propose){
						this.popup.btn_ok._disabled(true);
					}
					else{
						this.popup.btn_ok._onclick = function () {
							var restricted = this.X_REPEATING.container._getChildObjects().some(function(child) {
								return child.__check && !child.__check();
							});
							if(restricted) {
								return;
							}
							var rec = (this.X_REPEATING._value() || {}).values || {};
							if (rec && +rec.RCRMONTHREPETITION && +rec.RCRDAYREPETITION) {
								var d = IcewarpDate.julian(me.X_TIMEINTERVAL.startDate._value()).date(rec.RCRDAYREPETITION);
								var now = new IcewarpDate();
								if(now.format('julian') > d.format('julian')) {
									d.month(d.month() + 1);
								}
								me.X_TIMEINTERVAL.startDate._value(d.format('julian'));
								me.X_TIMEINTERVAL.__setFrom();
							}

							me._setRecurrenceSelect([this.X_REPEATING._value()]);

							this._destruct();

						}.bind(this.popup);
					}
				}

			} else {
				if (this.popup && !this.popup._destructed)
					this.popup._destruct();

				//Do not save on propose mode
				if (!me.__oresponse.propose && this.__value !== last_repeating_value){
					last_repeating_value = this.__value;
					me._setRecurrenceSelect([me._repeatingKeyToObject(this._value())]);
				}
			}

			//always set back old value on propose mode
			if (me.__oresponse.propose){
				me._setRecurrenceSelect([me.X_REPEATING.__rcrvalue], true);
			}
		};

		this.X_REPEATING._onkeydown = this.X_REMINDERS._onkeydown;
	}


	this.EVNLOCATION._oncreateOptionList = function (bSkipUpdate) {
		if (this.___init)
			return;

		this.___init = true;

		var resources_path = dataSet.get('main', ['resources_path']);
		if (resources_path) {
			var aItemsInfo = {
				aid: sPrimaryAccount,
				fid: resources_path,
				filter: {
					sort: 'ITMCLASSIFYAS',
					search: 'category:Room'
				},
				values: [
					'ITMCLASSIFYAS',
					'LCTEMAIL1'
				]
			};

			WMItems.list(aItemsInfo, '', '', '', [function (tmp) {
				if (tmp) {

					var out = {},
						sEmail;

					for (var i in tmp)
						for (var j in tmp[i]) {
							delete tmp[i][j]['/'];
							delete tmp[i][j]['#'];
							delete tmp[i][j]['$'];
							delete tmp[i][j]['@'];

							for (var k in tmp[i][j]) {
								sEmail = MailAddress.createEmail(tmp[i][j][k].ITMCLASSIFYAS, tmp[i][j][k].LCTEMAIL1);
								out[sEmail] = sEmail;
							}
						}

					me.EVNLOCATION.__out = out;
					if(!bSkipUpdate) {
						me.EVNLOCATION._fill(out);
						me.EVNLOCATION._show();
					}
				}
			}]);
		}
	};

	var autoadded_resource;
	this.EVNLOCATION.__eIN.addEventListener('blur', function() {
		if (autoadded_resource) {
			me.x_list.__users.forEach(function(user) {
				user.active = user.name === autoadded_resource.name && user.email === autoadded_resource.email;
			});
			me.x_list._removeUser();
		}
		if (~this.value.indexOf('@')) {
			autoadded_resource = MailAddress.splitEmailsAndNames(this.value)[0];
			autoadded_resource.role = 'S';
			me.x_list._addUser(autoadded_resource);
		}
	});

	this.X_LOCMAP._value([this.EVNLOCATION, '_value']);
	this.X_LOCMAP._callback_function = function(input) {
		me.EVNLOCATION._value(input);
	};
	this.EVNLOCATION._disabled(this.__attendee || this.__readonly);
	this._initGooglePlacesAutocomplete(GWOthers.getItem('EXTERNAL_SETTINGS', 'google_maps_api_key'));

	this.EVNTITLE._disabled(this.__readonly);

	//Copy contact name into window title
	this.EVNTITLE._onkeyup = (function () {

		var sAppendix = '';

		if (me._aValues.EVNFOLDER && me._aValues.EVNFOLDER != '@@trash@@'){

			var sFolder = Path.slash(me._aValues.EVNFOLDER),
				ds = dataSet.get('folders',[sPrimaryAccount, sFolder]);

			if (ds && ds.NAME){
				var aPath = sFolder.split('/');
				aPath.pop();
				aPath.push(ds.NAME);
				sAppendix = ' - ' + aPath.join('/');
			}
			else{
				sAppendix = ' - ' + sFolder;
			}
		}

		return function(){
			me._title((this._value() || getLang('EVENT::EVENT')) + sAppendix, true);
			me.x_freebusy._title(this._value() || getLang('EVENT::EVENT'));
		};
	})();

	me.EVNNOTE.select._fillLang({
		'enabled': "COMPOSE::HTML",
		'disabled': "COMPOSE::TEXT",
		'code': 'RICH::CODE'
	});
	me.EVNNOTE.select._value((this._aValues.EVNDESCFORMAT || '').toLowerCase() !== 'text/plain' ? 'enabled' : 'disabled');

	me.EVNNOTE._showSignatureButton(true);

	this.x_note._onclick = this._openNotePreview.bind(this);

	this._getAnchor('close_right').addEventListener('click', this._closeRight.bind(this, false));

	await this._create('x_btn_att', 'obj_button', {
		position: 'afterend',
		element: this.x_btn_ok._main
	}, 'ico ico_att pad color4 attach');
	this.x_btn_att._value('COMPOSE::ATTACH_FILES');

	this.X_ATTACHMENTS._destruct();
	this.X_ATTACHMENTS = await obj_upload._instance(this, this._id[2] ? this._id[1] + '/' + this._id[2] : ('tmp' + (+new Date())), {
		onclick: function(attachment) {
			return me.X_ATTACHMENTS._open(attachment.__file.id);
		}
	}, 'obj_upload_item');

	if (this.__readonly) {
		this.x_btn_att._disabled(true);
		this.EVNNOTE._readonly(true);
	} else {
		this.x_btn_att._onclick = this.X_ATTACHMENTS._upload.bind(this.X_ATTACHMENTS);
		this.X_ATTACHMENTS._dropzone(this._getAnchor('container'), async function(){
			return await (new cTemplate()).tmp('dropzone',{title:getLang('COMPOSE::DROP_TITLE'), body:getLang('COMPOSE::DROP_BODY')});
		}, 'item small');

		this.X_ATTACHMENTS._onuploadstart = function(files){
			me.x_btn_ok._disabled(true);
			[].forEach.call(files, async function(file) {
				if (file.removed) {
					return;
				}
				addcss(me._main, 'has_attachment');
				var attachment = await me._create('attachment', 'obj_attachment', 'attach_list', '', file, { progress: { pie: true } });
				if (file.id && file.class === 'attachment') {
					attachment.__abort = function() {
						me.X_ATTACHMENTS._remove(file.id);
						attachment._destruct();
					};
				}
			}, this);
		};

		gui._obeyEvent('onuploadaborted', [this, '__onuploadaborted']);
		this._add_destructor('__disobeyEvents');

		this.X_ATTACHMENTS._onuploadend = function(){
			me.x_btn_ok._disabled(false);
		};
	}

	this.EVNTYPE._setId(me._id);

	var loc = me._aValues.EVNLOCATION;
	if (loc && loc.indexOf('@')<0)
		loc = '';

	if (loc && (loc = MailAddress.splitEmailsAndNames(loc)[0]) && Is.Email(loc.email)){
		me._aValues['CONTACTS'] = me._aValues['CONTACTS'] || {};

		var bFound = false;
		for(i in me._aValues['CONTACTS']) {
			if (me._aValues['CONTACTS'][i].values.CNTEMAIL == loc.email){
				bFound = true;
				break;
			}
		}

		if (!bFound) {
			me._aValues['CONTACTS'][getFreeKey(me._aValues['CONTACTS'])] = {
				values: {
					CNTEMAIL: loc.email,
					CNTCONTACTNAME: loc.name,
					CNTROLE: 'S',
					CNTSTATUS:'B',
					NEW: true
				}
			};
		}
	}

	//CNTCONTACTNAME: '__@@groupchat@@__' === loc.email?getLang('ATTENDEES::ALL_ATTENDEES'):loc.name,

	// Remove old location resource if a new location has been entered
	if(me.__originalLocation && me.__originalLocation != this.EVNLOCATION._value()) {
		for(i in me._aValues['CONTACTS']) {
			if (me._aValues['CONTACTS'][i].values && me._aValues['CONTACTS'][i].values.CNTEMAIL === me.__originalLocation){
				delete me._aValues['CONTACTS'][i];
				break;
			}
		}
	}

	var users = [];
	var users2 = [];
	for(i in me._aValues.CONTACTS) {
		var value = me._aValues.CONTACTS[i].values;
		users.push(value.CNTEMAIL);
		users2.push({
			email: value.CNTEMAIL,
			name: value.CNTCONTACTNAME,
			role: value.CNTROLE || '',
			status: value.CNTSTATUS,
			id: value.CNT_ID,
			moderator: +(value.CNTMODERATOR == '1'),
			groupchat: value.GROUPCHAT
		});
	};


	this.x_freebusy._init({
		evnid: me._aValues.EVN_ID,
		users: users
	});

	this.x_freebusy._onchange = function(d) {
		me.X_TIMEINTERVAL._value({
			EVNSTARTDATE: d.startdate,
			EVNSTARTTIME: d.starttime,
			EVNENDDATE: d.enddate,
			EVNENDTIME: d.endtime,
		}, true);
		me._previewTimeBlock();
	};

	var guest = sPrimaryAccountGUEST  || (window.TeamChatAPI && TeamChatAPI.teamChatOnly());
	if (guest || this.__attendee) {
		this.x_address_book_icon._main.classList.remove('noborder');
		this.x_address_book_icon._disabled(true);
	}
	else{
		this.x_address_book_icon._onclick = async function() {
			await gui._create('address_book', 'frm_addaddress', '', '', [me, '__onAddNewFromAddressbook'], ['ADDRESS_BOOK::SELECTED_ADDRESSES'], void 0, void 0, true, void 0,true);
			gui.address_book._modal(true);
		};
	}

	this.x_suggest._single = true;
	this.x_suggest._itemClass = 'C';

	this.x_suggest._disobeyEvent('change',[this.x_suggest, '_checksize']);
	this.x_suggest._checksize = function() {};
	this.x_suggest._placeholder(getLang('ATTENDEES::QUICK_ADD'));
	this.x_suggest._onpaste = function(e) {
		var toPaste = (e.clipboardData.getData('text/plain') || e.clipboardData.getData('text')).replace(/[\u200B-\u200D\uFEFF]/g, '').trim();
		if (toPaste) {
			var tmp = MailAddress.splitEmailsAndNames(toPaste.split('\n').join(','));
			if (tmp && tmp[0] && tmp[0].email) {
				var attendees = tmp.map(function(u) {
					if (u.email && u.email.indexOf('@') > 0) {
						return MailAddress.createEmail(u.name, u.email);
					}
				}).filter(Boolean);
				me.__onAddNewFromAddressbook(true, [attendees]);
				if (attendees.length) {
					e.preventDefault();
					this._value('');
				}
			}
		}
	};
	this.x_suggest._onsubmit = function(){
		if (!this._checkError.length) {
			var tmp = MailAddress.splitEmailsAndNames(this._value());
			this._value('');
			if (tmp && tmp[0] && tmp[0].email) {
				me.__onAddNewFromAddressbook(true, [[MailAddress.createEmail(tmp[0].name, tmp[0].email)]]);
			}
		}
	};
	this.x_suggest._onblur = function() {
		if (this._value()) {
			this._onsubmit();
		}
	};
	this.x_suggest.__minWidth = 400;
	this.x_suggest._onmouseselect = this.x_suggest._onsubmit;
	this.x_suggest._restrict([function(v) {
		if (v === '') return true;
		var tmp = MailAddress.splitEmailsAndNames(v);
		if (tmp && tmp[0] && tmp[0].email) {
			if (!v.indexOf('[') && v.indexOf(']') === v.length - 1) {
				return true;
			}
			return Is.Email(tmp[0].email);
		}
		return false;
	}]);
	if(!this.__readonly && !guest && !this.__attendee) {
		this.x_suggest._main.appendChild(mkElement('div', {
			className: 'add',
			onclick: async function() {
				await gui._create('address_book', 'frm_addaddress', '', '', [me, '__onAddNewFromAddressbook'], ['ADDRESS_BOOK::SELECTED_ADDRESSES'], void 0, void 0, void 0, void 0,true);
				gui.address_book._modal(true);
			}
		}));
	}
	if (this.__readonly || this.__attendee) {
		this.x_suggest._destruct();
	}

	this.x_list = this._getAnchor('user_list');
	this.x_list.__users = [];

	// User roles:
	//   Required='Q', Resource='S', Optional='T', Organizer='G';

	// User status:
	//   Accepted = 'A'; Declined = 'D'; Delegated = 'E'; None = 'N';
	//   Completed = 'M'; NeedsAction = 'B'; Tentative = 'T'; Confirmed = 'C';
	//   Cancelled = 'Q'; InProcess = 'I'; Draft = 'F'; Final = 'L';

	this.x_list.onclick = function(e){
		var elm = e.target,
			bModerator = false,
			bRemove = false;

		if (elm.tagName == 'SPAN') {
			bRemove = true;
			elm = elm.parentNode;
		} else if (elm.classList.contains('make_moderator')) {
			bModerator = true;
			elm = elm.parentNode;
		}

		if(!elm.id) {
			elm = elm.parentNode;
		}

		var id = elm.id.substr((me._pathName+'.list/').length);

		if (this.__users[id]){

			if (this.__users[id].active && (e.ctrlKey || e.metaKey)){
				removecss(elm,'active');
				this.__users[id].active = false;
			}
			else{
				if (!e.ctrlKey && !e.metaKey){
					var active = this._getActive();
					var tmp;
					for (var i in active){
						try{
							tmp = document.getElementById(me._pathName+'.list/'+active[i]);
							removecss(tmp,'active');
							this.__users[active[i]].active = false;
						}
						catch(r){ console.log(this._name||false,r);}
					}
				}

				addcss(elm,'active');
				this.__users[id].active = true;
			}

			if (bModerator)
				me.x_list._moderator();
			else if (bRemove)
				me.x_list._removeUser();
			else{
				var pos = e.clientX-getSize(elm).x;
				if (pos<40 && !gui._rtl || gui._rtl && pos>205){

					this.oncontextmenu && this.oncontextmenu(e);

					e.preventDefault();
					e.stopPropagation();
				}
			}
		}
	};

	this.x_list.oncontextmenu =	function(e){
		var elm = e.target;

		if(!elm.id) {
			elm = elm.parentNode;
		}

		if (elm.id) {
			var id = elm.id.replace(me._pathName + '.list/', '');
			var user = this.__users[id];
			gui._create('cmenu', 'obj_context_link', '', '', user.name, user.email, void 0, void 0).then(function(cmenu) {
				cmenu._place(e.clientX, e.clientY, '', 2);
			});
			e.preventDefault();
		}
	};

	this.x_list.ondblclick = function(e){
		var elm = e.target;

		if(!elm.id) {
			elm = elm.parentNode;
		}

		if (elm.id && elm.id.indexOf((me._pathName+'.list/'))==0){
			e.preventDefault();
			var active = this._getActive();
			if (active.length){
				var user = this.__users[active[0]];
				gui._create('edit_dialog', 'frm_edit_attendee', '', '', 'frm_edit_attendee', 'ATTENDEES::EDIT_TITLE', [me, '__onEdit'], {CNT_ID:user.id,CNTEMAIL:user.email,CNTCONTACTNAME:user.name,CNTROLE:user.role,CNTSTATUS:user.status,GROUPCHAT: user.groupchat}, active, me.__attendee).then(function(popup) {
					popup.CNTSTATUS._disabled(!me._sItemID);
				});
			}
		}
	};

	//get all active rows
    this.x_list._getActive = function(){
		var active = [];
		for(var i in this.__users)
			if (this.__users[i] && this.__users[i].active && this.__users[i].action != 'remove')
                active.push(i);

		return active;
	};

	//fill list
    var ulp = this._getAnchor('user_list_preview');
	this.x_list._fill = function(scroll_to_last){
		var c = 0, css, out = mkElement('div');
		var folder = me.__evnid.fid ? dataSet.get('folders', [me.__evnid.aid, Path.slash(me.__evnid.fid)]) || {} : {};

		var bIsOrganizer = !me.__evnid.iid || this.__users.some(function (user) {
			return user.email === me.__real_email && user.role === 'G';
		}) || ~(folder.RIGHTS || '').indexOf('w') || (me.__evnid.owner_id === sPrimaryAccount);
		/*for(var i in dataSet.get('items', [sPrimaryAccount])) {
			var item = dataSet.get('items', [sPrimaryAccount, i, WMItems.__clientID(me.__evnid)]);
			if(item && item.EVNFLAGS & 2) {
				bIsOrganizer = true;
			}
		}*/
		this.__users = this.__users.sort(function(a, b) {
			return (a.role === 'G') ? -1 : (b.role === 'G');
		});

		for(var i = 0; i < this.__users.length; i++){
			if (this.__users[i].action == 'remove')
				continue;

			css = '';
			if (this.__users[i].status)
				css = 'status_' + this.__users[i].status;

			if (this.__users[i].role)
				css += (css ? ' ' : '') + 'role_' + this.__users[i].role;

			out.appendChild(mkElement('div',{
				id: me._pathName + '.list/' + i,
				className: (this.__users[i].active ? 'active' : '') + (this.__users[i].moderator ? ' moderator' : '') + (this.__users[i].css ? ' ' + this.__users[i].css : '') + ' ' + css,
				unselectable: 'on',
				title: this.__users[i].email + ' - ' + getLang('ATTENDEES::ROLE_' + this.__users[i].role.toUpperCase()),
				innerHTML: obj_avatar.getAvatarHTML({ email: this.__users[i].email, name: this.__users[i].name, size: 28 }) + (this.__users[i].email === me.__real_email ? getLang('COMMON::YOU') : (this.__users[i].name || this.__users[i].email).escapeHTML()) + ((!i && WMFolders.getType(me._id) == 'I' && this.__users[i].role == 'Q') || !(this.__users[i].role!='G' && bIsOrganizer) ? '':(me.__attendee?'':('<div class="make_moderator"></div><span></span>')))
			}));

			c++;
		}

		this.innerHTML = out.innerHTML;
		out = null;
		if (scroll_to_last) {
			this.lastElementChild.scrollIntoView();
		}

		//set height because of scrollbar
		if (me._container)
			me._container.style.height = (c>8?(c*25)+'px':'100%');

		ulp.textContent = getLang('ATTENDEES::ATTENDEES', [this.__users.length]);

		var manageAnchor = me._getAnchor('manage');
		if ((!me._id[2] && this.__users.length > 1) || (MailAddress.splitEmailsAndNames(me._aValues.EVNORGANIZER)[0] || {}).email === sPrimaryAccount) {
			manageAnchor.classList.remove('hidden');
		} else {
			manageAnchor.classList.add('hidden');
		}
	};

	//add user
	this.x_list._addUser = function(aInfo, bNoUpdate, bSkipNew, bNoScroll){
		if (aInfo.email && aInfo.email.indexOf('[') === 0){
			(new wm_tools()).distrib({
				name: aInfo.email
			}, [this, '_addGroup', [aInfo.role,bNoUpdate,bSkipNew,bNoScroll]]);
			return false;
		} else {
			aInfo.email = aInfo.email.toLowerCase();
			for(var i = this.__users.length - 1; i > -1; i--)
				if (this.__users[i].email == aInfo.email && this.__users[i].action != 'remove') //ignore
					return false;

			if(!bSkipNew) {
				aInfo.action = 'new';
			}
			this.__users.push(aInfo);
			this._fill(!bNoScroll);

			if (!bNoUpdate)
				me.x_freebusy._users(this.__users.map(function(user) {
					return user.email;
				}));

			return true;
		}
	};

	//add group of users
	this.x_list._addGroup = function(aData,sRole,bNoUpdate,bSkipNew,bNoScroll){

		for(var i in aData){
		    aData[i].role = sRole;
			this._addUser(aData[i],true,bSkipNew,bNoScroll);
		}

		if (!bNoUpdate)
			me.x_freebusy._users(this.__users.map(function(user) {
				return user.email;
			}));
	};

	//edit user
	this.x_list._editUser = function(aValues, iid){
		if (Is.Defined(iid) && this.__users[iid]){

			//check email
			for(var i = this.__users.length-1;i>-1;i--)
				if (i!=iid && this.__users[i].email == aValues.email){
					aValues.email = this.__users[iid].email;
					break;
				}

			//check update
			var doUpd = false;
			if (this.__users[iid].email != aValues.email)
                doUpd = true;

			//merge values
			for (i in aValues)
				this.__users[iid][i] = aValues[i];

			if(this.__users[iid].action !== 'new') {
				this.__users[iid].action = 'edit';
			}

			this._fill();

			if (doUpd)
				me.x_freebusy._users(this.__users.map(function(user) {
					return user.email;
				}));
		}
		else{
            aValues.checked = true;
			this._addUser(aValues);
		}
	};

	this.x_list._moderator = function(){
		for(var i in this.__users)
			if (this.__users[i] && this.__users[i].active) {
				this.__users[i].moderator = !this.__users[i].moderator;
				this.__users[i].action = 'edit';
				this._fill();
			}
	};

	//remove user
	this.x_list._removeUser = function(bSkipFill) {
		for(var i in this.__users)
			if (this.__users[i] && this.__users[i].active){
				if (this.__users[i].action == 'new') {
					this.__users = this.__users.filter(function(user) {
						return user !== this.__users[i];
					}, this);
				} else {
					this.__users[i].action = 'remove';
				}
			}

		if (!bSkipFill) {
			this._fill();
            me.x_freebusy._users(this.__users.map(function(user) {
				return user.email;
			}));
		}
	};

	this.x_list._getAttendees = function() {
		var aResult = [], values;
		for (var i in this.__users) {
			switch (this.__users[i]['action']) {
				case 'remove':
					if (this.__users[i].id) {
						aResult.push({'uid': this.__users[i].id});
					}
					break;
				case 'edit':
					values = {
						CNTCONTACTNAME: this.__users[i].name,
						CNTEMAIL: this.__users[i].email,
						CNTROLE: this.__users[i].role,
						CNTSTATUS: this.__users[i].status,
						CNT_ID: this.__users[i].id,
						CNTMODERATOR: +this.__users[i].moderator,
						GROUPCHAT: this.__users[i].groupchat
					};
					aResult.push({'uid': this.__users[i].id, 'values': values});
					break;
				case 'new':
					values = {
						CNTCONTACTNAME: this.__users[i].name,
						CNTEMAIL: this.__users[i].email,
						CNTROLE: this.__users[i].role,
						CNTSTATUS: this.__users[i].status,
						CNT_ID: this.__users[i].id,
						CNTMODERATOR: +this.__users[i].moderator,
						GROUPCHAT: this.__users[i].groupchat
					};
					aResult.push({'values': values});
				default:
					break;
			}
		}
		return aResult;
	};

	if (this.__readonly) {
		this.x_manage._destruct();
	} else {
		this.x_manage._onclick = async function() {
			var manage = await gui._create('frm_moderators', 'frm_moderators', '', '', me.x_list.__users, function(users) {
				me.x_list.__users = users;
				me.x_list._fill();
			}, {
				description: me.MEETING_ACTION && me.MEETING_ACTION._checked(),
				moderators_support: me.MEETING_ACTION && me.MEETING_ACTION._checked(),
				admin_support: !this.__readonly && me.MEETING_ACTION && me.MEETING_ACTION._checked(),
				invite_support: !this.__readonly,
				remove_support: !this.__readonly,
				readonly: this.__readonly,
				remove_myself_admin_support: false
			});
			var skip_email_invitation = await manage._create('skip_email_invitation', 'obj_checkbox', {
				element: manage._main.querySelector('.obj_popupmainbody'),
				position: 'beforeend'
			}, 'switch skip_email_invitation', 'EVENT::SKIP_EMAIL_INVITATION');
			skip_email_invitation._checked(me._aValues.skip_email_invitation);
			skip_email_invitation._onchange = function() {
				me._aValues.skip_email_invitation = this._checked();
			};
		};
	}

	//INSERT DEFAULT ACCOUNT
    var acc = MailAddress.splitEmailsAndNames(sOwner || me.__real_email)[0];
    	acc.css = 'main_account';
		acc.role = 'G';
		acc.status = 'A';
		acc.moderator = true;

	var aAccInfo = dataSet.get('accounts', [sOwner || me.__real_email]);
	if (aAccInfo && aAccInfo['FULLNAME'])
		acc.name = aAccInfo['FULLNAME'];

	users2.forEach(function(user) {
		this.x_list._addUser(user, false, !!me._id[2], true);
	}, this);

	if (WMFolders.getType([this._sAccountID, this._sFolderID]) !== 'I')
		this.x_list._addUser(acc, false, true, true);

	await this.__initForm('EVENT::EVENT');
	if ((this.__oresponse || {}).propose) {
		this.x_btn_ok._disabled(0);
	}

	var datetime = this.X_TIMEINTERVAL._value();
	this.x_freebusy._value({
		startdate: datetime.EVNSTARTDATE,
		starttime: datetime.EVNSTARTTIME,
		enddate: datetime.EVNENDDATE,
		endtime: datetime.EVNENDTIME,
		tzid: datetime.TZID,
		title: this.EVNTITLE._value() || getLang('EVENT::EVENT')
	});

	this.EVNNOTE._value(this._aValues.EVNNOTE || '', false, false, function() {
		if (me.EVNNOTE._value()) {
			me._generateNotePreview();
			me._openNotePreview();
		}
	});

	this._previewTimeBlock();

	[].forEach.call(this._main.querySelectorAll('.collapse'), function(collapse) {
		collapse.addEventListener('click', function(e) {
			e.stopPropagation();
			e.stopImmediatePropagation();
			me._previewTimeBlock();
			collapse.parentNode.classList.toggle('collapsed');
		});
	});
	[].forEach.call(this._main.querySelectorAll('.block'), function(block) {
		block.addEventListener('click', function(e) {
			e.stopImmediatePropagation();
			if (this.classList.contains('collapsed')) {
				me._previewTimeBlock();
				this.classList.toggle('collapsed');
			}
		});
	});

	if (!this._id[2]) {
		this.__currentSaveState = await this.__stringifyForm();
	}

	if (this._getAnchor('conference_modify')) {
		this._getAnchor('conference_modify').onclick = function(e) {
			e.stopPropagation();
			me._openConferenceSetup();
		}

		if (!this.__moderator && (!!this.__oresponse.propose || this.__attendee)) {
			this._getAnchor('conference_modify').textContent = '(' + getLang('ATTACHMENT::VIEW') + ')';
		}
	}

	this.x_copy_shareable_link._onclick = function() {
		toClipboard({
			'text/plain': aData.conference_link
		});
	}

	if (this._getAnchor('start_note_edit')) {
		this._getAnchor('start_note_edit').addEventListener('click', this.__start_note_edit.bind(this));
	}

	await this._create('scrollbar', 'obj_scrollbar');
	this.scrollbar._scrollbar(this._getAnchor('conference_content'), this._getAnchor('conference_content').parentNode);

	if (gui.frm_main && gui.frm_main.dnd)
		gui.frm_main.dnd.registr_drop(this, ['item']);
};

_me._active_dropzone = async function(v){
	if (v && v.type == 'item') {
		var mask = mkElement('div', {
			className: 'dropzone item small',
			onmouseenter: function() {
				mask.classList.add('active');
			},
			onmouseleave: function() {
				mask.classList.remove('active');
			},
			innerHTML: await (new cTemplate()).tmp('dropzone', {
				title: getLang('COMPOSE::DROP_TITLE'),
				body: getLang('COMPOSE::DROP_BODY')
			})
		});
		this._getAnchor('box').appendChild(mask);
		return mask;
	} else {
		return false;
	}
};

_me._ondrop = function(v) {
	this.X_ATTACHMENTS._addItem(v.value.map(function(v) {
		return {
			type: 'item',
			title: v.name,
			size: v.size,
			aid: v.aid,
			fid: v.fid,
			iid: v.iid,
			fullpath: v.aid + '/' + v.fid + '/' + v.iid
		}
	}));
};

_me._updateConferenceSummary = function() {
	this._getAnchor('summary').innerText = (this.MEETING_ACTION && this.MEETING_ACTION._checked()) ? [
		this.x_enable_password._checked() && getLang('EVENT::PASSWORD_PROTECTED'),
		this.x_enable_recording && this.x_enable_recording._checked() && getLang('EVENT::RECORDING_ON'),
		this.x_enable_lobby._checked() && getLang('EVENT::LOBBY_ON')
	].filter(Boolean).join(', ') : '';
};

_me._openNotePreview = function() {
	var value = this.EVNNOTE._value().trim();
	if (value) {
		this._main.setAttribute('iw-view', 'note_preview');
	} else if (!this._readonly) {
		this.__start_note_edit();
	}
};

_me._closeRight = function(bForce) {
	if (this._main.getAttribute('iw-view') === 'note_edit' && !bForce) {
		return this.__stop_note_edit();
	}

	this._main.removeAttribute('iw-view');
};

_me.__start_note_edit = function() {
	this._main.setAttribute('iw-view', 'note_edit');
	this.EVNNOTE._focus();
};

_me.__stop_note_edit = function() {
	this._generateNotePreview();

	var value = this.EVNNOTE._value().trim();
	if (value) {
		this._openNotePreview();
	} else {
		this._main.removeAttribute('iw-view');
	}
};

_me._openConferenceSetup = function() {
	this._main.setAttribute('iw-view', 'conference');
};

_me._generateNotePreview = function() {
	var sValue = this.EVNNOTE._value().trim();
	var bPlainText = this.EVNNOTE.select._value() === 'disabled';
	
	if (bPlainText) {
		this.x_note_preview._value({TEXT: sValue});
	} else {
		this.x_note_preview._value({HTML: sValue});
	}

	sValue = (sValue || '').replace(/<a href=".*?".*?>(.*?)<\/a>/g, '$1');
	sValue = createTextVersion(sValue.replace(/\n/, '<br />'), {
		linkProcess: function(href, linkText) {
			return linkText || href;
		},
		imgProcess: function() {
			return '';
		}
	}).trim();
	if (sValue) {
		this.x_note._value(sValue);
		this.x_note._main.classList.add('filled');
	} else {
		this.x_note._value(getLang('EVENT::ADD_NOTE'));
		this.x_note._main.classList.remove('filled');
		this.x_note_preview._value({HTML: ''});
	}
};

_me.__onEdit = function(aValues, iid){
	this.x_list._editUser({
		name: aValues.CNTCONTACTNAME,
		email: aValues.CNTEMAIL,
		role: aValues.CNTROLE,
		status: aValues.CNTSTATUS,
		id: aValues.CNT_ID,
		groupchat: aValues.GROUPCHAT
	}, iid);
};

_me.__onAddNew = function(aValues){
	var out = {
		name: aValues.CNTCONTACTNAME,
		email: aValues.CNTEMAIL,
		role: ~this.EVNLOCATION.__out.indexOf(aValues.CNTEMAIL) ? 'S' : aValues.CNTROLE,
		groupchat: !!aValues.GROUPCHAT
	};
	if (aValues.CNTSTATUS !== 'P')
		out.status = aValues.CNTSTATUS;
	this.x_list._addUser(out);
};

_me.__onAddNewFromAddressbook = function(bOK, aAddresses,sRole){
    if (bOK && aAddresses[0]) {
		var tmp, bUpdate = false;

		for (var i in aAddresses[0]){
			tmp = MailAddress.splitEmailsAndNames(aAddresses[0][i]);

			if (typeof tmp[0] === 'object'){
				var resource = false;
				for(var j in this.EVNLOCATION.__out || {}) {
					resource = MailAddress.splitEmailsAndNames(this.EVNLOCATION.__out[j])[0].email === tmp[0].email;
					if(resource) {
						break;
					}
				}
				tmp[0].role = resource ? 'S' : (Is.String(sRole) ? sRole : 'Q');
				bUpdate = this.x_list._addUser(tmp[0], true);
			}
		}

		if (bUpdate) {
			this.x_freebusy._users(this.x_list.__users.map(function(user) {
				return user.email;
			}));
		}
	}
};

_me._initGooglePlacesAutocomplete = function (API_KEY) {
	if (!API_KEY) {
		return;
	}

	if (!document.getElementById('googleapis')) {
		document.head.appendChild(mkElement('script', {
			id: 'googleapis',
			src: 'https://maps.googleapis.com/maps/api/js?key=' + API_KEY + '&libraries=places&callback=' + this._pathName + '.__googlePlacesAutocompleteCallback',
		}));
	} else if (window.google) {
		this.__googlePlacesAutocompleteCallback();
	}
};

_me.__googlePlacesAutocompleteCallback = function () {
	var me = this;

	var service = new google.maps.places.AutocompleteService();
	var last_value = '';
	this.EVNLOCATION.__eIN.addEventListener('keyup', function (e) {
		if (e.target.value) {
			me.EVNLOCATION.block && !me.EVNLOCATION.block._destructed && me.EVNLOCATION.block._destruct();
			me.EVNLOCATION._custom_list_className = 'powered_by_google';
			if (last_value !== e.target.value) {
				last_value = e.target.value;
				service.getQueryPredictions({
					input: e.target.value
				}, function (results) {
					var out = {};
					for (var i in me.EVNLOCATION.__out) {
						if (~me.EVNLOCATION.__out[i].toLowerCase().indexOf(e.target.value)) {
							out[i] = me.EVNLOCATION.__out[i];
						}
					}
					(results || []).forEach(function (result) {
						out[result.description] = result.description;
					});
					me.EVNLOCATION.block && !me.EVNLOCATION.block._destructed && me.EVNLOCATION.block._destruct();
					me.EVNLOCATION._fill(out);
					me.EVNLOCATION._show();
				});
			} else {
				me.EVNLOCATION._show();
			}
		} else {
			me.EVNLOCATION._custom_list_className = '';
			me.EVNLOCATION.block && !me.EVNLOCATION.block._destructed && me.EVNLOCATION.block._destruct();
			me.EVNLOCATION._fill(me.EVNLOCATION.__out);
		}
	});
};

_me._previewTimeBlock = function () {
	var v = this.X_TIMEINTERVAL._value(),
		from = v.TZID,
		to = normalizeTimezone(GWOthers.getItem('CALENDAR_SETTINGS', 'timezone')),
		from_offset;

	this.__previewTimeBlockState = Object.assign({}, v);
	if (from && from !== to) {
		try {
			from_offset = this.X_TIMEINTERVAL.timezone.__idTable[from][0].match(/\(.*\)/)[0];
		} catch {
			//
		}
		this.__tools.timezone({ from: from, to: to, times: {
			start: {
				date: v.EVNSTARTDATE,
				time: v.EVNSTARTTIME
			},
			end: {
				date: v.EVNENDDATE,
				time: v.EVNENDTIME
			}
		}}, [function(result) {
			if (IcewarpDate.julian(v.EVNSTARTDATE, v.EVNSTARTTIME).isSame(IcewarpDate.julian(result.start.date, result.start.time), 'date')) {
				this._getAnchor('time_preview').innerHTML = [
					new iMipRecurrence(this._repeatToImip(this.X_REPEATING.__rcrvalue), IcewarpDate.julian(v.EVNSTARTDATE, v.EVNSTARTTIME), v.EVNTIMEFORMAT !== 'F', IcewarpDate.julian(v.EVNENDDATE, v.EVNENDTIME)).toString('ddd D, MMM'),
					(this.X_REMINDERS._value() && this.X_REMINDERS._value() !== '0') ? getLang('REMINDER::REMINDER') + ' ' + this._reminderObjectToText(this._reminderKeyToObject(this.X_REMINDERS._value())) : false
				].filter(Boolean).join('<br>');
			} else {
				this._getAnchor('time_preview').innerHTML = [
					new iMipRecurrence(this._repeatToImip(this.X_REPEATING.__rcrvalue), IcewarpDate.julian(v.EVNSTARTDATE, v.EVNSTARTTIME), v.EVNTIMEFORMAT !== 'F', IcewarpDate.julian(v.EVNENDDATE, v.EVNENDTIME)).toString('ddd D, MMM') + ' ' + (from_offset || ('(' + from + ')')),
					new iMipRecurrence(this._repeatToImip(this.X_REPEATING.__rcrvalue), IcewarpDate.julian(result.start.date, result.start.time), v.EVNTIMEFORMAT !== 'F', IcewarpDate.julian(result.end.date, result.end.time)).toString('ddd D, MMM') + ' (' + getLang('EVENT::LOCAL_TIME') + ')',
					(this.X_REMINDERS._value() && this.X_REMINDERS._value() !== '0') ? getLang('REMINDER::REMINDER') + ' ' + this._reminderObjectToText(this._reminderKeyToObject(this.X_REMINDERS._value())) : false
				].filter(Boolean).join('<br>');
			}
		}.bind(this)]);
	} else {
		this._getAnchor('time_preview').innerHTML = [
			new iMipRecurrence(this._repeatToImip(this.X_REPEATING.__rcrvalue), IcewarpDate.julian(v.EVNSTARTDATE, v.EVNSTARTTIME), v.EVNTIMEFORMAT !== 'F', IcewarpDate.julian(v.EVNENDDATE, v.EVNENDTIME)).toString('ddd D, MMM'),
			(this.X_REMINDERS._value() && this.X_REMINDERS._value() !== '0') ? getLang('REMINDER::REMINDER') + ' ' + this._reminderObjectToText(this._reminderKeyToObject(this.X_REMINDERS._value())) : false
		].filter(Boolean).join('<br>');
	}
};

_me._setReminderSelect = function (REMINDERS) {
	var rem;

	for(var i in REMINDERS) {
		if (REMINDERS[i].values && (!REMINDERS[i].values.RMNTIME || (+REMINDERS[i].values.RMNDAYSBEFORE || +REMINDERS[i].values.RMNHOURSBEFORE || +REMINDERS[i].values.RMNMINUTESBEFORE))){
			rem = REMINDERS[i];
			break;
		}
	}

	if (!rem) {
		this.X_REMINDERS._value('0');
	} else {
		if (~[1, 2, 7].indexOf(+rem.values.RMNDAYSBEFORE)) {
			this.X_REMINDERS._value(rem.values.RMNDAYSBEFORE + 'D');
		} else if (~[1440, 2880, 10080].indexOf(+rem.values.RMNMINUTESBEFORE)) {
			this.X_REMINDERS._value(rem.values.RMNMINUTESBEFORE / 1440 + 'D');
		} else if (~[1, 2].indexOf(+rem.values.RMNHOURSBEFORE)) {
			this.X_REMINDERS._value(rem.values.RMNHOURSBEFORE + 'H');
		} else if (~[60, 120].indexOf(+rem.values.RMNMINUTESBEFORE)) {
			this.X_REMINDERS._value(rem.values.RMNMINUTESBEFORE / 60 + 'H');
		} else if (~[0, 10, 30].indexOf(+rem.values.RMNMINUTESBEFORE)) {
			this.X_REMINDERS._value(rem.values.RMNMINUTESBEFORE + 'M');
		} else {
			this.X_REMINDERS._value('*', true);
		}
		this.X_REMINDERS.__eLBL.innerHTML = this._reminderObjectToText(rem.values);
	}
	this.X_REMINDERS.__value = rem;
};

_me._reminderKeyToObject = function (key) {
	switch (key) {
		case '0':
			return '';
		case '0M':
			return {
				values: {
					RMNDAYSBEFORE: 0,
					RMNHOURSBEFORE: 0,
					RMNMINUTESBEFORE: 0
				}
			};
		case '10M':
			return {
				values: {
					RMNDAYSBEFORE: 0,
					RMNHOURSBEFORE: 0,
					RMNMINUTESBEFORE: 10
				}
			};
		case '30M':
			return {
				values: {
					RMNDAYSBEFORE: 0,
					RMNHOURSBEFORE: 0,
					RMNMINUTESBEFORE: 30
				}
			};
		case '1H':
			return {
				values: {
					RMNDAYSBEFORE: 0,
					RMNHOURSBEFORE: 1,
					RMNMINUTESBEFORE: 0
				}
			};
		case '2H':
			return {
				values: {
					RMNDAYSBEFORE: 0,
					RMNHOURSBEFORE: 2,
					RMNMINUTESBEFORE: 0
				}
			};
		case '1D':
			return {
				values: {
					RMNDAYSBEFORE: 1,
					RMNHOURSBEFORE: 0,
					RMNMINUTESBEFORE: 0
				}
			};
		case '2D':
			return {
				values: {
					RMNDAYSBEFORE: 2,
					RMNHOURSBEFORE: 0,
					RMNMINUTESBEFORE: 0
				}
			};
		case '7D':
			return {
				values: {
					RMNDAYSBEFORE: 7,
					RMNHOURSBEFORE: 0,
					RMNMINUTESBEFORE: 0
				}
			};
	}
	if(key && key.values) {
		key.values.RMNDAYSBEFORE = key.values.RMNDAYSBEFORE || 0;
		key.values.RMNHOURSBEFORE = key.values.RMNHOURSBEFORE || 0;
		key.values.RMNMINUTESBEFORE = key.values.RMNMINUTESBEFORE || 0;
	}
	return key;
};

_me._reminderObjectToText = function (value) {
	var v = (value || {}).values || value;
	if (!v) {
		return 'REMINDER::NONE';
	}
	if (+v.RMNDAYSBEFORE === 7 || +v.RMNMINUTESBEFORE === 10080) {
		return getLang('REMINDER::WEEKBEFORE');
	} else if (+v.RMNDAYSBEFORE) {
		return getLang('REMINDER::DAYSBEFORE', [+v.RMNDAYSBEFORE]);
	} else if (+v.RMNHOURSBEFORE) {
		return getLang('REMINDER::HOURSBEFORE', [+v.RMNHOURSBEFORE]);
	} else if (+v.RMNMINUTESBEFORE) {
		if (+v.RMNMINUTESBEFORE % 1440 === 0) {
			return getLang('REMINDER::DAYSBEFORE', [+v.RMNMINUTESBEFORE / 1440]);
		} else if (+v.RMNMINUTESBEFORE % 60 === 0) {
			return getLang('REMINDER::HOURSBEFORE', [+v.RMNMINUTESBEFORE / 60]);
		}
	}

	return getLang('REMINDER::MINUTESBEFORE', [+v.RMNMINUTESBEFORE]);
};

_me._setRecurrenceSelect = function (RECURRENCES, bNoUpdate) {
	var rec;
	for(var i in RECURRENCES) {
		rec = RECURRENCES[i];
	}

	if (!rec || !rec.values || (Object.keys(rec.values).length === 1 && rec.values.RCR_ID)) {
		this.X_REPEATING._value('0');
	} else {
		if (!+rec.values.RCRCOUNT && !+rec.values.RCRENDDATE) {
			if (+rec.values.RCRDAYREPETITION === 1 && +rec.values.RCRMONTHREPETITION === 0) {
				this.X_REPEATING._value('D', bNoUpdate);
			} else if (+rec.values.RCRWEEKREPETITION === 1 && (rec.values.RCRDAYOFWEEKNUMBER == 0 || +rec.values.RCRDAYOFWEEKNUMBER === [1,2,4,8,16,32,64][IcewarpDate.julian(this.X_TIMEINTERVAL._value().EVNSTARTDATE).day()])) {
				this.X_REPEATING._value('W', bNoUpdate);
			} else if (+rec.values.RCRWEEKREPETITION === 2 && (rec.values.RCRDAYOFWEEKNUMBER == 0 || +rec.values.RCRDAYOFWEEKNUMBER === [1,2,4,8,16,32,64][IcewarpDate.julian(this.X_TIMEINTERVAL._value().EVNSTARTDATE).day()])) {
				this.X_REPEATING._value('F', bNoUpdate);
			} else if (+rec.values.RCRMONTHREPETITION === 1 && +rec.values.RCRDAYREPETITION === IcewarpDate.julian(this.X_TIMEINTERVAL._value().EVNSTARTDATE).date()) {
				this.X_REPEATING._value('M', bNoUpdate);
			} else if (+rec.values.RCRYEARREPETITION === 1) {
				this.X_REPEATING._value('Y', bNoUpdate);
			} else {
				this.X_REPEATING._value('*', true);
				this.X_REPEATING.__eLBL.innerHTML = new iMipRecurrence(this._repeatToImip(rec)).toString();
			}
		} else {
			this.X_REPEATING._value('*', true);
			this.X_REPEATING.__eLBL.innerHTML = new iMipRecurrence(this._repeatToImip(rec)).toString();
		}
	}

	this.X_REPEATING.__rcrvalue = rec;
};

_me._repeatingKeyToObject = function (key) {
	switch (key) {
		case '0':
			return void 0;
		case 'D':
			return {
				values: {
					RCRDAYREPETITION: 1,
					RCRDAYOFWEEKNUMBER: 0,
					RCRWEEKREPETITION: 0,
					RCRWEEKOFMONTHNUMBER: 0,
					RCRMONTHREPETITION: 0,
					RCRMONTHOFYEARNUMBER: 0,
					RCRYEARREPETITION: 0,
					RCRENDDATE: "",
					RCRCOUNT: ""
				}
			};
		case 'W':
			return {
				values: {
					RCRDAYREPETITION: 0,
					RCRDAYOFWEEKNUMBER: 0, //[1,2,4,8,16,32,64][IcewarpDate.julian(this.X_TIMEINTERVAL._value().EVNSTARTDATE).day()],
					RCRWEEKREPETITION: 1,
					RCRWEEKOFMONTHNUMBER: 0,
					RCRMONTHREPETITION: 0,
					RCRMONTHOFYEARNUMBER: 0,
					RCRYEARREPETITION: 0,
					RCRENDDATE: "",
					RCRCOUNT: ""
				}
			};
		case 'F':
			return {
				values: {
					RCRDAYREPETITION: 0,
					RCRDAYOFWEEKNUMBER: 0, //[1,2,4,8,16,32,64][IcewarpDate.julian(this.X_TIMEINTERVAL._value().EVNSTARTDATE).day()],
					RCRWEEKREPETITION: 2,
					RCRWEEKOFMONTHNUMBER: 0,
					RCRMONTHREPETITION: 0,
					RCRMONTHOFYEARNUMBER: 0,
					RCRYEARREPETITION: 0,
					RCRENDDATE: "",
					RCRCOUNT: ""
				}
			};
		case 'M':
			return {
				values: {
					RCRDAYREPETITION: IcewarpDate.julian(this.X_TIMEINTERVAL._value().EVNSTARTDATE).date(),
					RCRDAYOFWEEKNUMBER: 0,
					RCRWEEKREPETITION: 0,
					RCRWEEKOFMONTHNUMBER: 0,
					RCRMONTHREPETITION: 1,
					RCRMONTHOFYEARNUMBER: 0,
					RCRYEARREPETITION: 0,
					RCRENDDATE: "",
					RCRCOUNT: ""
				}
			};
		case 'Y':
			return {
				values: {
					RCRDAYREPETITION: 0,
					RCRDAYOFWEEKNUMBER: 0,
					RCRWEEKREPETITION: 0,
					RCRWEEKOFMONTHNUMBER: 0,
					RCRMONTHREPETITION: 0,
					RCRMONTHOFYEARNUMBER: 0,
					RCRYEARREPETITION: 1,
					RCRENDDATE: "",
					RCRCOUNT: ""
				}
			};
	}
	return key;
};

_me._repeatToImipWeekDay = function (v) {
	if (+v.RCRDAYOFWEEKNUMBER) {
		var days = [];
		['SU', 'MO', 'TU', 'WE', 'TH', 'FR', 'SA'].forEach(function (h, k) {
			if (+v.RCRDAYOFWEEKNUMBER & Math.pow(2, k)) {
				days.push((+v.RCRWEEKOFMONTHNUMBER || '') + h);
			}
		});
		if (days.length) {
			return 'BYDAY=' + days.join(',');
		}
	}
};

_me._repeatToImip = function (repeat) {
	var v = (repeat || {}).values || repeat;
	if (!v) {
		return '';
	}
	var freq;
	var interval;
	var specific = [];
	var limit;
	if (+v.RCRYEARREPETITION) {
		freq = 'YEARLY';
		interval = v.RCRYEARREPETITION;
		if (+v.RCRMONTHOFYEARNUMBER) {
			specific.push('BYMONTH=' + v.RCRMONTHOFYEARNUMBER);
		}
		specific.push(this._repeatToImipWeekDay(v));
	} else if (+v.RCRMONTHREPETITION) {
		freq = 'MONTHLY';
		interval = v.RCRMONTHREPETITION;
		specific.push(this._repeatToImipWeekDay(v));
		if (+v.RCRDAYREPETITION) {
			specific.push('BYMONTHDAY=' + v.RCRDAYREPETITION);
		}
	} else if (+v.RCRWEEKREPETITION) {
		freq = 'WEEKLY';
		interval = v.RCRWEEKREPETITION;
		specific.push(this._repeatToImipWeekDay(v));
	} else if (+v.RCRDAYREPETITION) {
		freq = 'DAILY';
		interval = v.RCRDAYREPETITION;
	}
	if (+v.RCRCOUNT) {
		limit = 'COUNT=' + v.RCRCOUNT;
	} else if (+v.RCRENDDATE) {
		limit = 'UNTIL=' + IcewarpDate.julian(+v.RCRENDDATE).format('YYYYMMDD[T]HHmmss[Z]');
	}

	return [
		'FREQ=' + freq,
		'INTERVAL=' + interval,
		specific.filter(Boolean).join(';'),
		limit
	].filter(Boolean).join(';');
};

_me.__print = async function (aValues) {
	aValues = aValues.values;
	if ('text/html' === aValues.EVNDESCFORMAT) {
		aValues.EVNNOTE = DOMPurify.sanitize(aValues.EVNNOTE);
	}

	if ((aValues._TZEVNSTARTDATE || aValues.EVNSTARTDATE) > 0) {
		if ((aValues._TZEVNSTARTTIME || aValues.EVNSTARTTIME) > 0) {
			aValues.COUNT_DATE = IcewarpDate.julian(aValues._TZEVNSTARTDATE || aValues.EVNSTARTDATE).setTime(aValues._TZEVNSTARTTIME || aValues.EVNSTARTTIME, true).format('L LT');
		} else {
			aValues.COUNT_DATE = IcewarpDate.julian(aValues._TZEVNSTARTDATE || aValues.EVNSTARTDATE).setTime(0).format('L');
		}

		if ((aValues._TZEVNENDTIME || aValues.EVNENDTIME) > 0) {
			aValues.COUNT_DATE += ' - ' + IcewarpDate.julian(aValues._TZEVNENDDATE || aValues.EVNENDDATE).setTime(aValues._TZEVNENDTIME || aValues.EVNENDTIME, true).format('L LT');
		} else {
			aValues.COUNT_DATE += ' - ' + IcewarpDate.julian(aValues._TZEVNENDDATE || aValues.EVNENDDATE).setTime(0).format('L');
		}
	} else
		aValues.COUNT_DATE = '';

	if (!gui.print)
		await gui._create('print', 'frm_print');

	gui.print._add('E', aValues);
};

_me.__loadItems = function () {
	var me = this, att, atts, att_path;

	this._setRecurrenceSelect(this._aValues.RECURRENCES, true);

	for(var i in this._aValues.REMINDERS) {
		this.__reminderID = i;
		break;
	}

	if (!this._aValues.TZID) {
		this._aValues.TZID = normalizeTimezone(GWOthers.getItem('CALENDAR_SETTINGS', 'timezone'));
		this._aValues.EVNTIMEFORMAT = 'Z';
	}

	if (this._aValues.EVNSTARTDATE === void 0) { //set default time
		this._aValues = arrConcat(this._aValues, getCurrentEventTime());
	}

	this.X_TIMEINTERVAL._value(this._aValues);

	this.X_TIMEINTERVAL._onchange = function () {
		me._closeRight(true);
		me._aValues['EVNSTARTDATE'] = this._value().EVNSTARTDATE;
		var datetime = me.X_TIMEINTERVAL._value();
		me.x_freebusy._value({
			startdate: datetime.EVNSTARTDATE,
			starttime: Math.max(datetime.EVNSTARTTIME, 0),
			enddate: datetime.EVNENDDATE,
			endtime: Math.max(datetime.EVNENDTIME, 0),
			tzid: datetime.TZID,
			title: me.EVNTITLE._value() || getLang('EVENT::EVENT')
		}, true);
	};

	if (me._aValues.ATTACHMENTS) {
		att_path = (!me._aValues.fullpath && me._sItemID) ? me._sAccountID + '/' + me._sFolderID + '/' + WMItems.__serverID(me._sItemID) : me._aValues.fullpath;
		att_path && this.X_ATTACHMENTS._setFolder(att_path);

		atts = [];
		for (i in me._aValues.ATTACHMENTS) {
			att = me._aValues.ATTACHMENTS[i].values;
			atts.push({
				title: att.ATTDESC,
				type: att.ATTTYPE,
				id: i,
				ticket: att.TICKET,
				fullpath: att.FULLPATH || att_path,
				size: att.ATTSIZE
			});
		}
		me.X_ATTACHMENTS._addItem(atts);
	} else if (me._aValues.PUSH_ATTACHMENTS) {
		att_path = (me._aValues.PUSH_ATTACHMENTS[0] || {}).fullpath;
		att_path && this.X_ATTACHMENTS._setFolder(att_path.substr(0, att_path.lastIndexOf('/')));
		
		atts = [];
		for (i in me._aValues.PUSH_ATTACHMENTS) {
			att = me._aValues.PUSH_ATTACHMENTS[i];
			atts.push(att.values || {
				title: att.title,
				id: att.id,
				size: att.size,
				type: 'item',
				fullpath: att.fullpath
			});
		}
		me.X_ATTACHMENTS._addItem(atts);
	}

	if (this._aValues.EVNDESCFORMAT === 'text/plain') {
		this._aValues.EVNNOTE = (this._aValues.EVNNOTE || '').escapeHTML();
	}

	this.x_enable_lobby_background._onchange = function() {
		if (me.x_enable_lobby_background._checked()) {
			me.evnmeetinglobbybackground._main.removeAttribute('hidden');
		} else {
			me.evnmeetinglobbybackground._main.setAttribute('hidden', '');
		}
	};
	this.x_enable_lobby_background._onchange();
	var ldif = true;
	loadDataIntoForm(this, this._aValues);
	this.MEETING_ACTION && this.MEETING_ACTION._value(!!this._aValues.MEETING_ACTION);

	if (!this._aValues['EVN_ID']) {
		this.X_EVNFLAGS._value(GWOthers.getItem('DEFAULT_CALENDAR_SETTINGS', 'event_show_as'));
		if(+GWOthers.getItem('EVENT_SETTINGS', 'DEFAULT_REMINDER')) {
			this._setReminderSelect([{values:{RMNMINUTESBEFORE: GWOthers.getItem('EVENT_SETTINGS', 'TIME') / 60000}}]);
		} else {
			this.X_REMINDERS._value('0');
		}
	} else {
		this._setReminderSelect(this._aValues.REMINDERS);

		var tmp = 'S',
			flg = this._aValues.EVNFLAGS ? this._aValues.EVNFLAGS * 1 : 0;

		if ((flg & 16) === 16) {
			tmp = 'O';
		} else if ((flg & 4) === 4) {
			tmp = 'F';
		} else if ((flg & 8) === 8) {
			tmp = 'T';
		}

		this.X_EVNFLAGS._value(tmp);
	}
	if ((this._aValues.EVNFLAGS & 64) || (~['I', 'Y'].indexOf((dataSet.get('folders', [this._id[0], this._id[1]]) || {}).TYPE))) {
		this.X_REMINDERS._value('');
		this.X_REMINDERS._disabled(true);
		this.X_REMINDERS._main.parentNode.parentNode.setAttribute('hidden', '');
	}

	this.EVNTITLE._onkeyup();
	this.__verifyBackgrounds();
	this.evnmeetinglobbybackground._onchange = async function() {
		if (ldif) {
			ldif = false;
			return;
		}
		if (this.evnmeetinglobbybackground._value() === '') {
			if (me.__popup) {
				await me.__popup._destruct();
			}
			me.__popup = await this._gui._create('insert_item', 'frm_insert_item', '', 'frm_insert_item_nobottomdiv', [this ,'__addBackground'], sPrimaryAccount, '', '', gui.frm_main.upload, false, ['F', 'X']);
			gui._obeyEvent('onuploadcommit', [this, '__onbackgrounduploadcommit']);
		}
	}.bind(this);
};

_me.__updateLobbySettings = function() {
	[].forEach.call(this._getAnchor('right_content').querySelectorAll('[data-depends-on="lobby"]'), function(el) {
		el.style.display = this.x_enable_lobby._checked() ? '' : 'none';
	}, this);
};

_me.__onbackgrounduploadcommit = function(file) {
	gui._disobeyEvent('onuploadcommit', [this, '__onbackgrounduploadcommit']);
	if (this._destructed) {
		return;
	}
	this.__addBackground([{
		iid: file.data.id,
		fid: file.data.folder,
		aid: sPrimaryAccount
	}]);
};

_me.__addBackground = function(background) {
	if (background[0].url) {
		var backgrounds = Cookie.get(['conference', 'backgrounds']) || [];
		backgrounds.unshift(background[0].url);
		backgrounds = backgrounds.filter(function(v, i ,a) {
			return a.indexOf(v) === i;
		}).slice(0, 10);
		Cookie.set(['conference', 'backgrounds'], backgrounds);
		this.__fillBackgrounds(background[0].url);
	} else {
		TeamChatAPI.filesInvite({
			id: background[0].iid,
			aid: background[0].aid,
			fid: background[0].fid,
			editable: true,
			password: false,
			expiration: false
		}, {
			success: function (response) {
				this.__addBackground([{
					url: response.inviteticket
				}]);
			},
			context: this
		});
	}
};

_me.__verifyBackgrounds = function() {
	var backgrounds = Cookie.get(['conference', 'backgrounds']) || [];
	var length = backgrounds.length;
	if (!length) {
		return this.__fillBackgrounds();
	}

	backgrounds.forEach(function(background) {
		var xhr = new XMLHttpRequest();
		xhr.addEventListener('load', function() {
			if (xhr.status !== 200) {
				backgrounds = backgrounds.filter(function(back) {
					return background !== back;
				});
			}
			if (!--length) {
				Cookie.set(['conference', 'backgrounds'], backgrounds);
				var background = this._aValues && this._aValues.EVNMEETINGLOBBYBACKGROUND;
				this.__fillBackgrounds(background);
				if (background) {
					this.x_enable_lobby_background._value(true);
				}
			}
		}.bind(this));
		xhr.open('GET', background);
		xhr.send();
	}.bind(this));
};

_me.__fillBackgrounds = async function(value) {
	var backgrounds = Cookie.get(['conference', 'backgrounds']) || [];
	var backs = {
		'': ''
	};

	var length = backgrounds.length;
	if (!length) {
		await this.evnmeetinglobbybackground._fill(backs);
		this.evnmeetinglobbybackground._value('', true);
		return;
	}

	backgrounds.forEach(function(background) {
		ShortURL.resolve({
			url: background,
			skipPasswordPrompt: true,
			doNotTrack: true,
			callback: async function(oOut) {
				if (!oOut || !oOut.url) {
					backgrounds = backgrounds.filter(function(back) {
						return back !== background;
					});
					Cookie.set(['conference', 'backgrounds'], backgrounds);
				}
				backs[background] = '<img src="' + oOut.url + '"><div class="remove"></div>';
				if (!--length) {
					await this.evnmeetinglobbybackground._fill(backs, true);
					if (this.evnmeetinglobbybackground.__aData[value || (this._aValues || {}).EVNMEETINGLOBBYBACKGROUND]) {
						this.evnmeetinglobbybackground._value(value || (this._aValues || {}).EVNMEETINGLOBBYBACKGROUND);
					} else {
						this.evnmeetinglobbybackground._value('', true);
					}
					[].forEach.call(this.evnmeetinglobbybackground._main.querySelectorAll('.remove'), function(remove) {
						remove.addEventListener('click', function() {
							this.__removeBackground(remove.parentNode.getAttribute('data-value'), this.evnmeetinglobbybackground._value());
						}.bind(this));
					}.bind(this));
				}
			}.bind(this)
		});
	}, this);
};

_me.__removeBackground = function(background, value) {
	var backgrounds = Cookie.get(['conference', 'backgrounds']) || [];
	backgrounds = backgrounds.filter(function(back) {
		return back !== background;
	});
	Cookie.set(['conference', 'backgrounds'], backgrounds);
	this.__fillBackgrounds(value);
};

_me.__onBeforeSave = function () {
	!this.EVNTITLE._value() && this.EVNTITLE._value(getLang('EVENT_VIEW::NEWAPPOINTMENT'));
	this._sItemID = this._sItemID || '';
};

_me.__saveItems = function (aValues) {
	var addon;

	//Save As
	if (!Is.Defined(this._id[2])) {
		this._id = Path.split(this.X_PATH._value());
	}

	aValues.values.EVNDESCFORMAT = this.EVNNOTE.select._value() === 'enabled' ? 'text/html' : 'text/plain';
	if (aValues.values.EVNDESCFORMAT === 'text/plain') {
		aValues.values.EVNNOTE = mkElement('div', {
			innerHTML: aValues.values.EVNNOTE
		}).textContent;
	}
	aValues.values.EVNNOTE = aValues.values.EVNNOTE.replace(/iw-signature/g, '').replace(/iw-skip/g, '').replace(/iw-sent-via/g, '');

	// Show As
	if (this._aValues.EVNFLAGS)
		aValues.values.EVNFLAGS = this._aValues.EVNFLAGS & ~(4 | 8 | 16);
	else
		aValues.values.EVNFLAGS = 0;

	var tmp = {
		F: 4,
		T: 8,
		O: 16,
		S: 0
	};
	aValues.values.EVNFLAGS |= (aValues.values.EVNFLAGS || 0) | tmp[this.X_EVNFLAGS._value()];

	if (!Is.Empty(addon = this._reminderKeyToObject(this.X_REMINDERS._value()))) {
		if(this.__reminderID) {
			addon.uid = this.__reminderID;
		}
		aValues['REMINDERS'] = [addon];
	} else if(this.__reminderID) {
		aValues['REMINDERS'] = [{uid: this.__reminderID}];
	}

	if (aValues.values['MEETING_ACTION'] == 1) {
		if (this._aValues.EVNMEETINGID && (this._aValues.EVNMEETINGID !== true)) {
			aValues.values['MEETING_ACTION'] = 'edit';
		} else {
			aValues.values['MEETING_ACTION'] = 'create';
		}
	}

	if (this.x_enable_recording) {
		if (this.x_enable_recording._checked()) {
			aValues.values.EVNFLAGS = (aValues.values.EVNFLAGS || 0) | 256;
		} else {
			aValues.values.EVNFLAGS = (aValues.values.EVNFLAGS || 0) & ~256;
		}
	}

	if (this.x_enable_lobby._checked()) {
		aValues.values.EVNFLAGS = (aValues.values.EVNFLAGS || 0) | 512;
	} else {
		aValues.values.EVNFLAGS = (aValues.values.EVNFLAGS || 0) & ~512;
	}

	if (!this.x_enable_lobby_background._checked()) {
		aValues.values.evnmeetinglobbybackground = '';
	}

	delete aValues.values['btn_meet']; // There is no need to send this to server

	if (this.X_REPEATING && !Is.Empty(addon = this._repeatingKeyToObject(this.X_REPEATING.__rcrvalue))) {
		if (addon.values && addon.values.RCRENDDATE && addon.values.RCRENDDATE < aValues.values.EVNSTARTDATE)
			addon.values.RCRENDDATE = aValues.values.EVNSTARTDATE;

		aValues['RECURRENCES'] = [addon];

		if (this._aValues.RECURRENCES && Is.Object(this._aValues.RECURRENCES[this._aValues.EVNRCR_ID]) && compareObj(this._aValues.RECURRENCES[this._aValues.EVNRCR_ID], addon, true)){
		 	delete aValues.RECURRENCES;
		}
	} else if (this._aValues.EVNRCR_ID) {
		aValues.RECURRENCES = [{
			values: { RCRID: this._aValues.EVNRCR_ID }
		}];
	} else {
		delete aValues.RECURRENCES;
	}

	if(this.x_include_in_my_cal && this.x_include_in_my_cal._checked()) {
		this.x_list._addUser({
			email: this.__real_email,
			name: '',
			role: 'Q'
		});
	}

	if (!Is.Empty(addon = this.x_list._getAttendees())) {
		aValues['CONTACTS'] = addon;
		if (!(aValues.values.EVNFLAGS & 2)) {
			if (!this._aValues.skip_email_invitation) {
				aValues.values.EVNFLAGS = aValues.values.EVNFLAGS | 1;
			}
		} else
			aValues.values.EVNFLAGS = aValues.values.EVNFLAGS & ~1;
	}

	var i;
	//Resources Folder
	if (!this._sItemID && this._id[0] === this.__real_email) {
		var sFolderID = this._id[1];
		if (sFolderID === '__@@VIRTUAL@@__/__@@EVENTS@@__') {
			var aCalendars = dataSet.get('folders', [this.__real_email, '__@@VIRTUAL@@__/__@@EVENTS@@__', 'VIRTUAL', 'FOLDERS']);
			for (i in aCalendars)
				if (aCalendars[i]) {
					sFolderID = i;
					break;
				}
		}

		if (sFolderID.indexOf(dataSet.get('main', ['resources_path']) + '/') == 0) {
			var bFound = false;

			if (aValues['CONTACTS']) {
				for (i in aValues['CONTACTS'])
					if (aValues['CONTACTS'][i].values.CNTEMAIL == this.__real_email) {
						bFound = true;
						break;
					}
			} else
				aValues['CONTACTS'] = [];

			if (!bFound) {
				aValues['CONTACTS'].push({
					values: {
						CNTEMAIL: this.__real_email,
						CNTROLE: 'Q'
					}
				});

				if (!this._aValues.skip_email_invitation) {
					aValues.values.EVNFLAGS |= 1;
				}
			}
		}

	}

	// Automatically Add Location into Schedule
	if (aValues.values.EVNLOCATION && aValues.values.EVNLOCATION.indexOf('@') > -1) {

		var aMail = MailAddress.splitEmailsAndNames(aValues.values.EVNLOCATION);
		if (aMail && aMail[0] && aMail[0].email) {

			var aOld = {},
				found = false;
			if (this._aValues && this._aValues.CONTACTS)
				aOld = this._aValues.CONTACTS;

			if (aValues && aValues.CONTACTS)
				for (i in aValues.CONTACTS)
					if (aValues.CONTACTS[i].values && aValues.CONTACTS[i].values.CNTEMAIL == aMail[0].email) {
						found = true;
						break;
					}
			else
			if (aValues.CONTACTS[i].uid)
				delete aOld[aValues.CONTACTS[i].uid];

			if (!found && !Is.Empty(aOld))
				for (i in aOld)
					if (aOld[i].values && aOld[i].values.CNTEMAIL == aMail[0].email) {
						found = true;
						break;
					}

			//Add location into schedule
			if (!found) {
				if (!aValues.CONTACTS) aValues.CONTACTS = [];
				aValues.CONTACTS.push({
					values: {
						CNTEMAIL: aMail[0].email,
						CNTCONTACTNAME: aMail[0].name,
						CNTROLE: 'S'
					}
				});
				if (!this._aValues.skip_email_invitation) {
					//Send invitation to all attendees
					aValues.values.EVNFLAGS |= 1;
				}
			}
		}
	}

	// If location resource has changed, remove original location resource
	if (this._aValues.CONTACTS && this.__originalLocation && aValues.values.EVNLOCATION != this.__originalLocation) {
		var email = MailAddress.splitEmailsAndNames(this.__originalLocation)[0].email;
		if (!aValues.CONTACTS) aValues.CONTACTS = [];
		for (i in this._aValues.CONTACTS) {
			if (this._aValues.CONTACTS[i].values && this._aValues.CONTACTS[i].values.CNTEMAIL == email) {
				aValues.CONTACTS.push({
					uid: i
				});
				break;
			}
		}
	}

	this._notify_attendees = false;
	if (
		// datetime
		(this.startDate._value() != this._aValues.EVNSTARTDATE) ||
		(this.startTime._value() != (this._aValues.EVNSTARTTIME * 60000)) ||
		(this.endDate._value() != this._aValues.EVNENDDATE) ||
		(this.endTime._value() != (this._aValues.EVNENDTIME * 60000)) ||
		(normalizeTimezone(this.timezone._value()) != normalizeTimezone(this._aValues.TZID)) ||
		// recurrence change
		aValues.RECURRENCES ||
		// conference
		(((this.MEETING_ACTION && this.MEETING_ACTION._value()) ? 'edit' : 0) != (this._aValues.MEETING_ACTION || 0)) ||
		(this.MEETING_PASSWORD._value() != (this._aValues.MEETING_PASSWORD || '')) ||
		(this._aValues.EVNFLAGS & 256 !== this._aValues.EVNFLAGS & 256) || // recording
		(this._aValues.EVNFLAGS & 512 !== this._aValues.EVNFLAGS & 512) // lobby
	) {
		this._notify_attendees = true;
	} else if (!Is.Empty(addon = this.x_list._getAttendees())) { // added or removed participants
		for (i in addon) {
			if (addon[i].action == 'remove' || !(addon[i].values || {}).CNT_ID) {
				this._notify_attendees = true;
				break;
			}
		}
	}

	aValues.values = arrConcat(aValues.values, this.X_TIMEINTERVAL._value());

	if (this.MEETING_ACTION && this.MEETING_ACTION._checked() && WMFolders.getType([this._sAccountID, this._sFolderID]) === 'I' && !Is.Defined(this._id[2])){
		aValues.CONTACTS = aValues.CONTACTS || {};
		if (!Object.keys(aValues.CONTACTS).some(function(key) {
			return aValues.CONTACTS[key].values.CNTEMAIL === sPrimaryAccount;
		}, this)) {
			aValues.CONTACTS[getFreeKey(aValues.CONTACTS)] = {
				values: {
					CNTEMAIL: sPrimaryAccount,
					CNTCONTACTNAME: dataSet.get('main', ['fullname']),
					CNTROLE: 'G',
					CNTSTATUS: 'A',
					CNTMODERATOR: 1,
					NEW: true
				}
			};
		}
	}

	if (this.X_ATTACHMENTS && !Is.Empty(addon = this.X_ATTACHMENTS._getAddon()))
		aValues['ATTACHMENTS'] = addon;

	if (aValues.values['TZID'] == 'F') {
		aValues.values['EVNTIMEFORMAT'] = 'F';
		delete aValues.values['TZID'];
	} else
	if (aValues.values['EVNTIMEFORMAT'] == 'Z') {
		aValues.values['_TZEVNSTARTDATE'] = aValues.values['EVNSTARTDATE'];
		aValues.values['_TZEVNENDDATE'] = aValues.values['EVNENDDATE'];
		aValues.values['_TZEVNSTARTTIME'] = aValues.values['EVNSTARTTIME'];
		aValues.values['_TZEVNENDTIME'] = aValues.values['EVNENDTIME'];
		aValues.values['_TZID'] = aValues.values['TZID'];

		delete aValues.values['EVNSTARTDATE'];
		delete aValues.values['EVNENDDATE'];
		delete aValues.values['EVNSTARTTIME'];
		delete aValues.values['EVNENDTIME'];
		delete aValues.values['TZID'];
	}

	//Event RCR
	if (this._aValues['EXPDATE'])
		aValues.values['EXPDATE'] = this._aValues['EXPDATE'];

	if (this._aValues['EXPFOLLOWING'])
		aValues.values['EXPFOLLOWING'] = this._aValues['EXPFOLLOWING'];

};

_me.__autoreopen = function(data) {
	if (!data.values.EVN_ID && (data.ATTACHMENTS || []).length) {
		var i = 0;
		data.PUSH_ATTACHMENTS = (data.ATTACHMENTS || []).map(function(att) {
			att = att.values;
			return {
				values: {
					name: att.description,
					id: i++,
					size: att.size,
					class: att.class,
					fullpath: att.fullpath
				}
			}
		});
		delete data.ATTACHMENTS;
	}

	Object.assign(this._aValues, data, data.values);
	this.__loadItems();
};

_me.__onuploadaborted = async function(data) {
	for (var attachment of this._getChildObjects('attach_list')) {
		if (attachment.__file === data.file) {
			await attachment._destruct();
			this.X_ATTACHMENTS._remove(data.file.id);
		}
	}
	if (!this._getChildObjects('attach_list').length) {
		removecss(this._main, 'has_attachment');
	}
};

_me.__disobeyEvents = function() {
	gui._disobeyEvent('onuploadaborted', [this, '__onuploadaborted']);
};