function frm_document_onlyoffice() {}
_me = frm_document_onlyoffice.prototype;

frm_document_onlyoffice.DocsAPIPath = '/webdocuments/web-apps/apps/api/documents/api.js';

_me.__constructor = async function (autoreopenArgs) {
	autoreopenArgs && this.__setAutoreopenArgs(autoreopenArgs);

	this._defaultSize(1200, 800, {
		maximized: true
	});
	this._title('DOCUMENT::TITLE');
	this.__error = false;

	await this._draw('frm_document_onlyoffice', 'main');
	await this._create('loader', 'obj_loader');

	this.__id = 'onlyoffice_placeholder' + unique_id();
	this._getAnchor('editor').appendChild(mkElement('div', {id: this.__id}));

	if (typeof DocsAPI === typeof void 0) {
		document.head.appendChild(mkElement('script', {src: frm_document_onlyoffice.DocsAPIPath}));
	}

	this.__document_changed = false;
	this.__document_saved = true;

	gui._obeyEvent('ondetach', [this, '_ondetach']);
	gui._obeyEvent('changedId', [this, '__changedIdHandler'])

	this._add_destructor('__removeListeners');
};

_me.__removeListeners = function(){
	gui._disobeyEvent('ondetach', [this, '_ondetach']);
	gui._disobeyEvent('changedId', [this, '__changedIdHandler'])
};

_me._ondock = function(){
	try {
		if (Item.isSpreadsheet(this.__autoreopenArgs.args[0].EVNTITLE)) {
			this.__document_type = 'cell';
		} else if (Item.isPresentation(this.__autoreopenArgs.args[0].EVNTITLE)) {
			this.__document_type = 'slide';
		}
	} catch {}
	return this.__document_type?{css: 'ico_' + this.__document_type}:{};
};

_me._getType = function (url) {
	var a = document.createElement('a');
	a.href = url;
	if (Item.isDocument(a.pathname)) {
		return 'word';
	} else if (Item.isSpreadsheet(a.pathname)) {
		return 'cell';
	} else if (Item.isPresentation(a.pathname)) {
		return 'slide';
	}
};

_me._open = function (aItemInfo, mode, reopen_arguments, response, callback) {
	if (!Is.Object(aItemInfo)) {
		return;
	}
	aItemInfo.EVNTITLE && this._title(aItemInfo.EVNTITLE, true);
	if ((aItemInfo.EVN_ID && aItemInfo.EVNTITLE) || !(aItemInfo.aid && aItemInfo.fid)){
		this._open_success(aItemInfo, mode, reopen_arguments, response, callback);

		if (aItemInfo.iid) {
			gui.__exeEvent('previewItem', {
				aid: aItemInfo.aid,
				fid: aItemInfo.fid,
				iid: WMItems.__serverID(aItemInfo.iid)
			});
		} else {
			gui.__exeEvent('previewItem', {
				filename: aItemInfo.EVNTITLE,
				url: aItemInfo.url,
				previewURL: aItemInfo.previewURL
			});
		}
	}
	else{
		WMItems.list(aItemInfo, '','','',[function(aData){
			aData = aData[aItemInfo.aid] && aData[aItemInfo.aid][aItemInfo.fid] && aData[aItemInfo.aid][aItemInfo.fid][WMItems.__clientID(aItemInfo.iid)];
			if (!aData) {
				return this._destruct();
			}
			aItemInfo.EVNTITLE = aItemInfo.attid || aData.EVNTITLE;
			//Object.assign(aItemInfo, aData);
			this._open_success(aItemInfo, mode, reopen_arguments, response, callback);
		}.bind(this)]);
	}
};

_me._open_success = async function (aItemInfo, mode, reopen_arguments, response, callback) {
	var me = this;

	//File is not found
	if (Is.Object(response) && response.data && (!response.data.document || !response.data.document.fileType)) {
		gui.notifier._value({type: 'alert', args: {text: 'ALERTS::FILE_NOT_FOUND'}});
		this._destruct();
		return;
	}

	if (callback) {
		this.callback = callback;
	}

	if (typeof DocsAPI === typeof void 0) {
		return setTimeout(function () {
			this._open_success(aItemInfo, mode, reopen_arguments, response, callback);
		}.bind(this), 50);
	}

	if(+DocsAPI.DocEditor.version().split('.')[0] > 4) {
		if (aItemInfo.aid === sPrimaryAccount && this._getAnchor('title')) {
			this._getAnchor('title').insertAdjacentElement('afterend', mkElement('div', { className: "webdoc-btn webdoc-share", textContent: getLang('COMMON::SHARE'), onclick: function() {
				Item.collaborate([aItemInfo.aid, aItemInfo.fid, WMItems.__clientID(aItemInfo.iid)], me._gui);
			}}));
		}
	}

	var data = aItemInfo, i;
	if(!aItemInfo.url) {
		var d = dataSet.get('items', [aItemInfo.aid, aItemInfo.fid, aItemInfo.iid]);
		if (d) {
			for(i in d) {
				data[i] = d[i];
			}
		}
	}

	data.EVNTITLE && this._title(data.EVNTITLE, true);

	gui.socket && gui.socket.api._obeyEvent('onnotify', [this, '__notify']);

	this.aItemInfo = {
		aid: aItemInfo.aid,
		fid: aItemInfo.fid,
		iid: aItemInfo.iid,
		url: aItemInfo.url,
		ticket: aItemInfo.ticket,
		attid: aItemInfo.attid,
		session_key: response.key,
	};
	this.reopen_arguments = reopen_arguments;
	this.mode = response.mode;
	this._detachable(true);

	this.__responseData = this.__prepareData(response, this.aItemInfo);
	this._editor = new DocsAPI.DocEditor(this.__id, this.__responseData.data);

	if (WMFolders.getType(aItemInfo) == 'I' && mode != response.mode && response.mode == 1){
		this.__readonly();
		gui.notifier._value({type: 'alert', args: {text: 'ALERTS::COULD_NOT_EDIT'}});
	}
	else
	if(response.data.editorConfig.mode === 'view') {
		this.__readonly(false, (aItemInfo.editable !== false) && (mode == response.mode && WMFolders.getAccess(this.aItemInfo, WMFolders.getType(this.aItemInfo) === 'I' ? 'edit_document' : 'modify')));
	}

	if (data) {
		if (data.EVNLINKEXTRAS) {
			var extras = parseURL(data.EVNLINKEXTRAS);
			for (i in extras) {
				data[i.toUpperCase()] = data[i.toUpperCase()] || extras[i];
			}
		}
		if (data.EVN_DOCUMENTEDITINGINFO) {
			var document_editing_info;
			try {
				document_editing_info = JSON.parse(data.EVN_DOCUMENTEDITINGINFO);
				data.EVNLOCKOWN_EMAIL = data.EVNLOCKOWN_EMAIL || document_editing_info.editor_email;
			} catch {
				//
			}
		}
		if (data.EVNLOCKOWN_EMAIL && data.EVNLOCKOWN_EMAIL !== sPrimaryAccount) {
			this.__readonly(data);
		}
	}

	//Set document type for Icon
	addcss(this._main, 'ico_' + response.data.documentType);
	this.__document_type = response.data.documentType;

	//CHAT & COMMENTS
	if (data.EVNCLASS === 'R' || data.EVNCLASS === 'Z'){
		addcss(this._main, 'chat');

		this.btn_bubble._onclick = function(){
			Cookie.set(['aux', 'comments_info'], 1);

			removecss(this._main, 'splash', 'chat-new');
			addcss(this._main, 'chat-open');
			removecss(this._main, 'chatgpt-open');
			removecss(this._main, 'chatgpt-conv-open');
			this.comment.text && this.comment.text._focus();
		}.bind(this);

		this._getAnchor('chat_icon').onclick = function(){
			this.btn_bubble._onclick();
		}.bind(this);

		this._getAnchor('chat_close').onclick = function(){
			removecss(this._main, 'chat-open');
		}.bind(this);

		await this._create('comment','frm_comment','comment', 'obj_rdock_panel obj_rdock_thread light', {
			aid: data.aid,
			fid: data.fid.replace('/' + (data.EVNCOMEVNID || data.EVN_ID), ''),
			iid: WMItems.__clientID(data.EVNCOMEVNID || data.EVN_ID)
		}, void 0, {
			uploadInstanceId: (data.EVNCOMEVNID ? '/' + data.EVN_ID : '') + 'docView'
		});

		//splash screen
		if (!Cookie.get(['aux', 'comments_info']))
			setTimeout(function(){
				if (this && !this._destructed && !Cookie.get(['aux', 'comments_info']))
					addcss(this._main, 'splash');
			}.bind(this),500);
	}

	await this.__initChatGPT();
	gui._obeyEvent('chatgptChanged', [this, '__initChatGPT']);
};

_me.__initChatGPT = async function(options) {
	if (dataSet.get('chatgpt') && !this.chatgpt) {
		var alias = this.aItemInfo.ts || this.aItemInfo.attid || this.aItemInfo.iid;
		await this._create('chatgptconv', 'obj_rdock_chatgpt_conversation', 'chatgpt_conv_container', '', Object.assign({
			label: this._title.bind(this),
			detachable: false,
			allowEdit: false,
			allowNew: false,
			alias: alias,
			onback: function() {
				removecss(this._main, 'chatgpt-conv-open');
				addcss(this._main, 'chatgpt-open');
			}.bind(this),
			onClose: function() {
				removecss(this._main, 'chatgpt-conv-open');
			}.bind(this),
			handleNewConversation: function() {
				this.chatgptconv._init(this.__conversation || '');
			}.bind(this),
			onNewConversation: function(conversation) {
				this.__conversation = conversation;
				this.chatgpt._main.classList.add('conversation-exists');
			}.bind(this)
		}, options || {}));

		await this._create('chatgpt', 'obj_rdock_chatgpt', 'chatgpt_container', '', Object.assign({
			onClose: function() {
				removecss(this._main, 'chatgpt-open');
			}.bind(this),
			handleOpenConversation: function(conversation) {
				this.chatgptconv._init(this.__conversation || conversation);
				addcss(this._main, 'chatgpt-conv-open');
				removecss(this._main, 'chatgpt-open');
			}.bind(this)
		}, options || {}));

		ChatGPT.conversationCreate({
			label: this._title(),
			alias: alias,
			openai_model: 'assistant'
		}, async function(bOK, conversation, bNewlyCreated) {
			if (!bOK) {
				return this.chatgptconv._init(false);
			}

			this.__conversation = conversation;
			this.chatgpt._main.classList.add('conversation-exists');
			await this.chatgptconv._init(conversation);

			if (bNewlyCreated) {
				var url = this.aItemInfo.ticket || this.aItemInfo.url;
				if ((((this.__responseData || {}).data || {}).document || {}).url) {
					url = this.__responseData.data.document.url;
				}
				ChatGPT.createFile({
					alias: alias,
					name: this._title(),
					url: url
				}, function(bOK) {
					if (!bOK) {
						return;
					}

					conversation.messageCreate({
						message: getLang('CHATGPT::PROCESS_FILE'),
						files: [{
							alias: alias
						}]
					}, function (bOK) {
						if (bOK) {
							conversation.process();
							addcss(this._main, 'chatgpt', 'chatgpt_analyzed');
							this._getAnchor('chatgpt_icon').onclick = function() {
								addcss(this._main, 'chatgpt-conv-open');
								removecss(this._main, 'chatgpt-open');
								removecss(this._main, 'chat-open');
							}.bind(this);
						}
					}.bind(this));
				}.bind(this));
			} else {
				addcss(this._main, 'chatgpt');
				this._getAnchor('chatgpt_icon').onclick = function() {
					addcss(this._main, 'chatgpt-conv-open');
					removecss(this._main, 'chatgpt-open');
					removecss(this._main, 'chat-open');
				}.bind(this);
			}
		}.bind(this));
	} else if (!dataSet.get('chatgpt') && this.chatgpt) {
		removecss(this._main, 'chatgpt');
		this.chatgptconv._destruct();
		this.chatgpt._destruct();
	}
};

_me.__prepareData = function(response) {
	var wmpath = document.location.origin + document.location.pathname;

	response.data.documentType = this._getType(response.data.document.url);

	response.data.editorConfig = response.data.editorConfig || {};
	response.data.editorConfig.customization = response.data.editorConfig.customization || {};
	localStorage.removeItem('ui-theme-id');
	Object.assign(response.data.editorConfig.customization, {
		about: false,
		chat: false,
		feedback: false,
		compactHeader: true,
		toolbarHideFileName: true,
		logo: {
			image: wmpath + 'client/skins/default/images/transparent.gif',
			imageEmbedded: wmpath + 'client/skins/default/images/transparent.gif',
			url: 'javascript: return false;'
		},
		customer: {
			address: "Georgiou Gennadiou 43, Limassol - CY3041",
			logo: "https://wwwcdn.icewarp.com/img/homepage/litea/logo-icewarp-old2.svg",
			mail: "info@icewarp.com",
			name: "IceWarp Limited",
			www: "https://www.icewarp.com/"
		},
		uiTheme: (window.IW_NM && window.IW_NM.init) ? 'theme-dark' : 'theme-light'
	});

	response.data.editorConfig.lang = isoLanguageCode(GWOthers.getItem('LAYOUT_SETTINGS', 'language'));
	response.data.events = {
		onDocumentStateChange: function(event) {
			this.__document_changed = this.__document_changed || event.data;
			this.__document_saved = !event.data;
		}.bind(this),
		onAppReady: function() {
			this.loader && this.loader._destruct();
			var doc = this.__eMain.querySelector('iframe').contentWindow.document;

			doc.head.appendChild(mkElement('link', {
				rel: 'stylesheet',
				type: 'text/css',
				href: wmpath + 'client/skins/default/css/onlyoffice.css'
			}));
			doc.head.appendChild(mkElement('link', {
				rel: 'stylesheet',
				type: 'text/css',
				href: wmpath + 'client/skins/default/css/onlyoffice_' + response.data.documentType + '.css'
			}));

			doc.body.addEventListener('click', function(){
				this._focus(true);
			}.bind(this), true);

		}.bind(this),

		onWarning: function (event) {
			console.warn("ONLYOFFICE Document Editor reports an warning: code " + event.data.warningCode + ", description " + event.data.warningDescription);
		},
		onError: function (event) {
			this.__error = true;
			console.warn("ONLYOFFICE Document Editor reports an error: code " + event.data.errorCode + ", description " + event.data.errorDescription);
			window.Sentry && Sentry.withScope(function(scope) {
				scope.setTag('module', 'OnlyOffice');
				Sentry.captureException(event);
			});
		}.bind(this),
		onRequestClose: function() {
			this.__onclose();
		}.bind(this)
	};

	return response;
}

_me.__notify = function (aData) {

	if (this._destructed)
		return;

	switch(aData.ACTION){
		case 'unlock':
			var aFolder = dataSet.get('folders',[this.aItemInfo.aid, this.aItemInfo.fid]),
				rp = Path.slash(aData.FOLDER);

			if ((aFolder.RELATIVE_PATH === rp || this.aItemInfo.fid === rp) && aData.ITEM === WMItems.__serverID(this.aItemInfo.iid)){
				dataSet.add('items', [this.aItemInfo.aid, this.aItemInfo.fid, this.aItemInfo.iid, 'EVNLOCKOWN_EMAIL'], sPrimaryAccount);
				dataSet.add('items', [this.aItemInfo.aid, this.aItemInfo.fid, this.aItemInfo.iid, 'EVN_DOCUMENTEDITINGINFO'], '');
				this.__reload();
			}
			break;

		case 'comment':
			if (!hascss(this._main, 'chat-open')){
				addcss(this._main, 'chat-new');
			}
	}

};

_me.__changedIdHandler = function(data) {
	var oldId = WMItems.__clientID(data.oldId);
	var newId = WMItems.__clientID(data.newId);
	if (oldId === newId) {
		return;
	}

	if (this.aItemInfo.iid === oldId && this.__autoreopenArgs) {
		this.__autoreopenArgs.args[0].iid = newId;
		var docked = this._docked;
		this._destruct();
		var office_window = Item.filesEdit.apply(Item, this.__autoreopenArgs.args);
		if (docked) {
			office_window._dock();
		}
	}
};

_me.__reload = function () {
	var panel = this.__eContainer.querySelector('.panel');
	panel && panel.parentNode.removeChild(panel);

	this._getAnchor('top').insertAdjacentElement('afterend', mkElement('div', {
		className: 'table panel'
	}, false, [
		mkElement('div', {
			className: 'cell'
		}, false, [
			mkElement('div', {
				className: 'label',
				textContent: getLang('DOCUMENT::READ_ONLY_MODE')
			})
		]),
		mkElement('div', {
			className: 'cell middle'
		}, false, [
			mkElement('div', {
				className: 'name',
				textContent: getLang('DOCUMENT::DOCUMENT_UNLOCKED')
			}),
			mkElement('div', {
				className: 'button',
				textContent: getLang('DOCUMENT::RELOAD'),
				onclick: function() {
					this._remove_destructor('_onclose');
					this._destruct();
					Item.officeOpen.apply(Item, this.reopen_arguments);
				}.bind(this)
			})
		]),
		mkElement('div', {
			className: 'cell last'
		})
	]));
};

_me.__request = function (data) {
	var room = dataSet.get('folders', [sPrimaryAccount, this.aItemInfo.fid]);
	var group = '';

	if (room.TYPE == 'I' && room.NAME){
		group = this.aItemInfo.fid.split('/');
		group.splice(-1, 1, room.NAME);
		group = group.join('/');
	}

	var body = getLang('DOCUMENT::REQUEST_UNLOCK_TEXT', [data.EVNTITLE, (group || room.NAME || room.RELATIVE_PATH)]);
	var body_header = getLang('DOCUMENT::REQUEST_UNLOCK_TEXT_GREETINGS', [dataSet.get('xmpp', ['roster', data.EVNLOCKOWN_EMAIL, 'name']) || data.EVNLOCKOWN_EMAIL]);

	if(!dataSet.get('xmpp', ['roster', data.EVNLOCKOWN_EMAIL]) || ~['both', 'none', 'offline', '', void 0].indexOf(dataSet.get('xmpp', ['roster', data.EVNLOCKOWN_EMAIL, 'show']))) {
		if ((window.TeamChatAPI && TeamChatAPI.teamChatOnly()) || sPrimaryAccountGUEST) {
			Item.sendEmailTo(data.EVNLOCKOWN_EMAIL, {sBody: '<div>' + body_header + '</div>' + NewMessage.crlf + '<div>' + body + '</div>', sSubject: getLang('DOCUMENT::REQUEST_UNLOCK_TEXT_SUBJECT', [(group || room.NAME || room.RELATIVE_PATH) + '/' + data.EVNTITLE]), addSignature: false});
		} else {
			NewMessage.compose({
				to: data.EVNLOCKOWN_EMAIL,
				subject: getLang('DOCUMENT::REQUEST_UNLOCK_TEXT_SUBJECT', [(room.NAME || room.RELATIVE_PATH) + '/' + data.EVNTITLE]),
				mailBody: '<div>' + body_header + '</div>' + NewMessage.crlf + '<div>' + body + '</div>'
			});
		}
	} else {
		gui.frm_main.im._activate(data.EVNLOCKOWN_EMAIL);
		gui.frm_main.im._chat(data.EVNLOCKOWN_EMAIL);
		gui.frm_chat.tabs[gui.frm_chat.tabs._value()].text._value(body);
		gui.frm_chat._focus();
	}
};

_me.__readonly = function (data, has_access) {
	var panel = this.__eContainer.querySelector('.table.panel');
	panel && panel.parentNode.removeChild(panel);
	this._getAnchor('top').insertAdjacentElement('afterend', mkElement('div', {
		className: 'table panel'
	}, false, [
		mkElement('div', {
			className: 'cell'
		}, false, [
			mkElement('div', {
				className: 'label',
				textContent: getLang('DOCUMENT::READ_ONLY_MODE')
			})
		]),
		data ? mkElement('div', {
			className: 'cell middle'
		}, false, [
			obj_avatar.getAvatarElement({
				email: data.EVNLOCKOWN_EMAIL,
				name: dataSet.get('xmpp', ['roster', data.EVNLOCKOWN_EMAIL, 'name'])
			}),
			mkElement('div', {
				className: 'name',
				textContent: getLang('DOCUMENT::NAME_IS_EDITING_THIS_DOCUMENT', [dataSet.get('xmpp', ['roster', data.EVNLOCKOWN_EMAIL, 'name']) || data.EVNLOCKOWN_EMAIL])
			}),
			mkElement('div', {
				className: 'button',
				textContent: getLang('DOCUMENT::REQUEST_UNLOCK'),
				onclick: function() {
					this.__request(data);
				}.bind(this)
			})
		]) : false,
		has_access ? mkElement('div', {
			className: 'cell middle'
		}, false, [
			mkElement('div', {
				className: 'button',
				textContent: getLang('DOCUMENT::SWITCH_TO_EDIT_MODE'),
				onclick: async function() {
					this._remove_destructor('_onclose');
					await this._destruct();
					var args = this.reopen_arguments;
					Item.officeOpen(args[0], args[1], args[2], 'force_edit', args[4]);
				}.bind(this)
			})
		]) : false,
		mkElement('div', {
			className: 'cell last'
		})
	].filter(Boolean)));
};

_me._onclose = async function () {
	if (this.__closing)
		return;

	gui.socket && gui.socket.api._disobeyEvent('onnotify', [this, '__notify']);

	if (this.__document_type === 'pdf') {
		if (this.__document_changed) {
			var confirm = await gui._create('frm_confirm', 'frm_confirm', '', '', [this, '__onclose'], 'CONFIRMATION::CLOSE_UNSAVED_DOCUMENT_TITLE');
			confirm.obj_label._value(getLang('CONFIRMATION::CLOSE_PDF1') + '<br />' + getLang('CONFIRMATION::CLOSE_PDF2'));
			// var save = await confirm._create('save', 'obj_button', {
			// 	element: confirm.x_btn_ok._main,
			// 	position: 'beforebegin'
			// }, 'save color1 noborder');
			// save._value('FORM_BUTTONS::SAVE_AND_CLOSE');
			// save._onclick = function() {
			// 	this._editor.downloadAs('pdf');
			// 	confirm._destruct();
			// 	this.__onclose();
			// }.bind(this);
			// confirm.x_btn_ok._value('FORM_BUTTONS::CLOSE');
		} else {
			this.__onclose();
		}
	} else if (this.aItemInfo && this.mode !== void 0 && this.mode !== 2 && !this.__error) {
		this._editor.requestClose();
	} else {
		this._destruct();
		gui._disobeyEvent('chatgptChanged', [this, '__initChatGPT']);
	}
};

_me.__onclose = function() {
	this._remove_destructor('_onclose');
	var final_cb = {};

	if (!this.aItemInfo) {
		this.__closing = false;
		(this._editor || {}).destroyEditor && this._editor.destroyEditor();
		this._destruct();
	}

	TeamChatAPI.filesStopEdit(this.aItemInfo, {
		success: function () {
			this.__closing = false;
			if (this.__document_changed && GWOthers.getItem('GW_MYGROUP', 'ownautorevisionmode') == '1' && this.aItemInfo.iid) {
				gui._create('revision', 'frm_revision', '', '', this.aItemInfo, true);
			}
			if (this.__document_changed && this.callback && this.callback.success){
				this.callback.success.call(this.callback.context || null, final_cb);

				if (this.aItemInfo.url)
					final_cb.success && final_cb.success.call(final_cb.context || null);
			}

			(this._editor || {}).destroyEditor && this._editor.destroyEditor();
			this._destruct();
		},
		error: function () {
			this.__closing = false;
			this.__document_changed && this.callback && this.callback.error && this.callback.error.call(this.callback.context || null);
			(this._editor || {}).destroyEditor && this._editor.destroyEditor();
			this._destruct();
		},
		context: this
	},
	{
		success: function () {
			this.__closing = false;
			!this.aItemInfo.url && final_cb.success && final_cb.success.call(final_cb.context || null);
		},
		context: this
	});
};

_me.__autoreopen = true;

_me._onbeforedetach = function(callback) {
	if (this._destructed) {
		return;
	}

	TeamChatAPI.filesStopEdit(this.aItemInfo, {
		success: function () {
			this._editor.destroyEditor();
			callback();
		},
		error: function () {
			this._editor.destroyEditor();
			callback();
		},
		context: this
	});
};

_me._ondetach = function(context) {
	if (this._destructed || this._gui !== context) {
		return;
	}

	TeamChatAPI.filesEdit(this.aItemInfo, this.mode, {
		success: function (response) {
			this.aItemInfo.session_key = response.data.key;
			var doc = this._main.ownerDocument,
				win = doc.defaultView,
				xhr;

			xhr = new XMLHttpRequest();
			xhr.addEventListener('load', function(event) {
				var DocsAPIGenerator = new win.Function('window', 'document', event.target.response);
				DocsAPIGenerator(win, doc);
				this._editor = new win.DocsAPI.DocEditor(this.__id, this.__prepareData(response).data);
			}.bind(this));

			xhr.open('GET', frm_document_onlyoffice.DocsAPIPath);
			xhr.send();
		},
		context: this
	});
};