function frm_dashboard_window() {};

frm_dashboard_window.prototype.__constructor = async function (oOptions) {
	this.__oOptions = oOptions;

	var windows = gui._getChildObjects('', 'frm_dashboard_window');
	for (var i in windows) {
		if (windows[i] !== this && windows[i].frame.__url.split('?')[0] === oOptions.url.split('?')[0]) {
			windows[i]._focus();
			return this._destruct();
		}
	}

	oOptions.type && this._main.classList.add(this._iconType = 'frm_' + oOptions.type);

	oOptions.title && this._title(oOptions.title, true);

	['resizable', 'modal', 'dockable', 'moveble', 'detachable', 'shareable'].forEach(function(action) {
		if (oOptions[action] !== void 0) {
			this['_' + action].call(this, oOptions[action]);
		}
	}, this);

	await this._create('frame', 'obj_dashboard_frame', 'main', '', oOptions, this.__messageHandler.bind(this));

	this._defaultSize(800, 600, {
		goldenRatio: true
	});
};

frm_dashboard_window.prototype.__messageHandler = function(event, data) {
	if (this['__onMessage_' + event]) {
		return this['__onMessage_' + event](data);
	}

	switch(event) {
		case 'click':
		case 'contextmenu':
			this._focus(true);
		break;
	}
};

frm_dashboard_window.prototype.__onMessage_close = frm_dashboard_window.prototype._close = function() {
	if (!this.frame.__authenticated) {
		return obj_popup.prototype._close.call(this);
	}

	this.__hide();
	this._main.style.display = 'none';
	this.frame._postMessage({
		event: 'destroy'
	});

	clearTimeout(this.__destroyTimeout);
	this.__destroyTimeout = setTimeout(function() {
		if (!this._destructed) {
			obj_popup.prototype._close.call(this);
		}
	}.bind(this), 5000);
};

frm_dashboard_window.prototype.__onMessage_destroy = function() {
	clearTimeout(this.__destroyTimeout);
	if (!this._destructed) {
		obj_popup.prototype._close.call(this);
	}
};

frm_dashboard_window.prototype.__onMessage_destroyError = function() {
	clearTimeout(this.__destroyTimeout);
	if (!this._destructed) {
		this.__show();
	}
};

frm_dashboard_window.prototype._shareable = frm_dashboard_window.prototype.__onMessage_shareable = async function(oOptions) {
	if (!oOptions) {
		if (this.x_btn_share) {
			await this.x_btn_share._destruct();
		}
		return;
	} else {
		if (typeof oOptions === 'object') {
			Object.assign(this.__oOptions, oOptions);
		}
		if (this.x_btn_share) {
			return;
		}
	}

	var share = await this._create('x_btn_share', 'obj_button', {
		position: 'afterend',
		element: this._getAnchor('title')
	}, 'color1 simple rounded share simple');
	share._value('MAIN_MENU::SHARE');
	share._onclick = function() {
		if (this.__oOptions.iid) {
			Item.collaborate([
				this.__oOptions.aid,
				this.__oOptions.fid,
				WMItems.__clientID(this.__oOptions.iid)
			]);
		} else {
			Folder.share(this.__oOptions).__aHandler = [function(aData) {
				if ((aData || []).length) {
					gui.frm_main.dashboard.frame._postMessage({
						event: 'folderShared',
						data: {
							aid: this.__oOptions.aid,
							fid: this.__oOptions.fid
						}
					});
				}
			}.bind(this)];
		}
	}.bind(this);
};

frm_dashboard_window.prototype.__detach = function() {
	window.open(this.frame.__url, '_blank');
	this._close();
};