function frm_dashboard() { };
_me = frm_dashboard.prototype;

frm_dashboard.__apps = [
	{ folderType: 'D', dashboard_only: true, label: getLang('COMMON_FOLDERS::DASHBOARD') },
	{ folderType: 'F', label: getLang('FOLDERS::FILES_DOCUMENTS') },
	{ folderType: 'N', label: getLang('FOLDERS::NOTES'), capability: 'notes' },
	// { folderType: 'E', label: getLang('MAIN_MENU::CALENDAR'), capability: 'calendar' },
	{ folderType: 'DA', dashboard_only: true, label: getLang('DASHBOARD::APPS'), capability: 'apps' },
	{ folderType: 'DS', dashboard_only: true, label: getLang('DASHBOARD::SETTINGS'), capability: 'settings' }
];

_me.__constructor = async function (callback) {
	await storage.library('short_url');
	await storage.library('wm_chatgpt');

	this.__callback = callback;
	this.__isLoaded = false;
	this.__capabilities = [];

	var me = this;

	this._add_destructor('__destructor');

	if (gui.preloader) {
		gui.preloader._value(getLang('PRELOADER::DASHBOARD'));
	}

	this.__loadConfig(function (config) {
		dataSet.add('dashboard', ['config'], config);
		dataSet.add('main', ['license_type'], config.license_type || dataSet.get('main', ['license_type']));
		if (sPrimaryAccountGUEST || gui._REQUEST_VARS.tconly || config.dashboard_enabled === false) {
			return me._destruct();
		}

		WMAccounts.__getLicense(function () {
			if (dataSet.get('main', ['license_type']) === 'onpremise' && !~[true, 'fake', void 0].indexOf(config.dashboard_enabled)) {
				return me._destruct();c
			}

			gui._obeyEvent('focus', [me, '__onFocusHandler']);
			gui._obeyEvent('online', [me, '__onOnlineHandler']);

			me.__init(function () {
				me._create('frame', 'obj_dashboard_frame', '', '', {}, me.__postMessageHandler.bind(me));
				me.__authenticateTimeout = setTimeout(function() {
					if (!me.__isLoaded) {
						me.__errorHandler();
					}
				}, 10000);
				gui.frm_main.search._obeyEvent('onsearch', [me, '__onsearch']);
				gui._obeyEvent('previewItem', [me, '__previewItemHandler']);
			});
		});
	});
};

_me.__onFocusHandler = function() {
	if (this.__isDown && !this.__isBooting) {
		this.__restart();
	}
};

_me.__onOnlineHandler = function() {
	if (this.__isDown && !this.__isBooting) {
		this.__restart();
	}
};

_me.__destructor = function () {
	gui._disobeyEvent('focus', [this, '__onFocusHandler']);
	gui._disobeyEvent('online', [this, '__onOnlineHandler']);

	gui.frm_main.filter.__update('folders');

	gui._disobeyEvent('previewItem', [this, '__previewItemHandler']);

	gui.frm_main.search._disobeyEvent('onsearch', [this, '__onsearch']);

	if (gui.preloader) {
		gui.preloader._remove();
	}

	executeCallbackFunction(this.__callback, false);
};

_me._newNoteWindow = async function(data) {
	var note = await this.frame.__onMessage_openWindowURL({
		uid: unique_id(),
		type: 'note',
		url: 'view/note',
	});
	if (data) {
		note.__onMessage_loaded = function() {
			note.frame._postMessage({
				event: 'setData',
				data: data
			});
		};
	}
};

_me._newEventWindow = async function(aData) {
	return await Item.openwindow([aData.aid, aData.fid], getCurrentEventTime(), null, 'E');
};

_me._hasCapability = function(capability) {
	if (this._destructed) {
		return;
	}
	capability = (capability || '').toLowerCase();
	if (~this.__capabilities.indexOf(capability)) {
		return true;
	}
	console.info('Dashboard does not support', capability);
};

_me._navigate = function(aData) {
	if (gui.frm_main && gui.frm_main.title && aData.to !== 'backgrounds') {
		this.__onMessage_setWindowTitle({
			title: getLang('TITLE::' + aData.to)
		});
	}

	this.frame._postMessage({
		event: 'navigate',
		data: aData
	});
	this.frame.__eFrame.focus();
};

_me._refresh = function() {
	this.frame._postMessage({
		event: 'refresh'
	});
};

_me._isPinnedItem = function(aData) {
	var aid = aData.aid;
	var fid = aData.fid ? Path.slash(aData.fid) : void 0;
	var iid = aData.iid ? WMItems.__serverID(aData.iid) : void 0;

	var pinnedItems = dataSet.get('dashboard', ['pinnedItems']) || [];
	return pinnedItems.filter(Boolean).some(function(pinnedItem) {
		return pinnedItem.type === aData.type && ((iid && pinnedItem.iid === iid) || (!iid && pinnedItem.aid === aid && pinnedItem.fid === fid));
	});
};

_me.__onMessage_openEventWindow = function(aData) {
	Item.openwindow([
		aData.aid,
		aData.fid,
		aData.iid
	]);
};

_me.__onMessage_pinItem = function(aData) {
	if (!aData || this._isPinnedItem(aData)) {
		return false;
	}

	var aid = aData.aid;
	var fid = aData.fid ? Path.slash(aData.fid) : void 0;
	var iid = aData.iid ? WMItems.__serverID(aData.iid) : void 0;

	var pinnedItems = dataSet.get('dashboard', ['pinnedItems']) || [];
	pinnedItems.push({ aid: aid, fid: fid, iid: iid, type: aData.type });
	dataSet.add('dashboard', ['pinnedItems'], pinnedItems.filter(Boolean));

	return true;
};

_me.__onMessage_unpinItem = function(aData) {
	var aid = aData.aid;
	var fid = aData.fid ? Path.slash(aData.fid) : void 0;
	var iid = aData.iid ? WMItems.__serverID(aData.iid) : void 0;

	var pinnedItems = dataSet.get('dashboard', ['pinnedItems']) || [];
	var filtered = false;
	pinnedItems = pinnedItems.filter(Boolean).filter(function(pinnedItem) {
		var found = !(pinnedItem.type === aData.type && ((iid && pinnedItem.iid === iid) || (!iid && pinnedItem.aid === aid && pinnedItem.fid === fid)));
		filtered = filtered || !found;
		return found;
	});
	dataSet.add('dashboard', ['pinnedItems'], pinnedItems);
	return filtered;
};

_me._pinItem = function(aData, elm, bcr) {
	if (!this.__onMessage_pinItem(aData)) {
		return;
	}

	var aid = aData.aid;
	var fid = aData.fid ? Path.slash(aData.fid) : void 0;
	var iid = aData.iid ? WMItems.__serverID(aData.iid) : void 0;

	this.frame._postMessage({
		event: 'pinItem',
		data: {
			aid: aid,
			fid: fid,
			iid: iid,
			type: aData.type
		}
	});

	var dashboardIcon = gui.frm_main.filter._getAnchor('D');
	if (elm || bcr) {
		bcr = bcr || elm.getBoundingClientRect();
		var ghost = cDnD.prototype.create_dragElement([{
			aid: aData.aid,
			fid: aData.fid,
			iid: aData.iid,
			name: dataSet.get('items', [aData.aid, aData.fid, aData.iid, 'EVNTITLE']),
			size: dataSet.get('items', [aData.aid, aData.fid, aData.iid, 'EVNCOMPLETE'])
		}]);
		ghost.classList.add('pinning');
		if (gui._rtl) {
			ghost.style.right = document.body.clientWidth - bcr.right + 'px';
		} else {
			ghost.style.left = bcr.x + 'px';
		}
		ghost.style.top = bcr.y + 'px';
		document.body.appendChild(ghost);
		setTimeout(function() {
			ghost.parentElement.removeChild(ghost);
			dashboardIcon.classList.add('pinning');
			clearTimeout(dashboardIcon._pinningTimeout);
			dashboardIcon._pinningTimeout = setTimeout(function() {
				dashboardIcon.classList.remove('pinning');
			}, 1000);
		}, 1000);
	} else {
		dashboardIcon.classList.add('pinning');
		clearTimeout(dashboardIcon._pinningTimeout);
		dashboardIcon._pinningTimeout = setTimeout(function() {
			dashboardIcon.classList.remove('pinning');
		}, 1000);
	}
};

_me._unpinItem = function(aData) {
	if (!this.__onMessage_unpinItem(aData)) {
		return;
	}

	var aid = aData.aid;
	var fid = aData.fid ? Path.slash(aData.fid) : void 0;
	var iid = aData.iid ? WMItems.__serverID(aData.iid) : void 0;

	this.frame._postMessage({
		event: 'unpinItem',
		data: {
			aid: aid,
			fid: fid,
			iid: iid,
			type: aData.type
		}
	});
};

_me.__previewItemHandler = function(data) {
	this.frame._postMessage({
		event: 'previewItem',
		data: data
	});
};

_me.__init = function (callback) {
	if (dataSet.get('dashboard', ['config', 'dashboard_enabled']) === 'fake') {
		return this.__fakeStart(callback);
	}

	this.__isBooting = true;
	this.__authenticate(callback);
};

_me.__loadConfig = async function (callback) {
	var config = {
		dashboard_enabled: GWOthers.getItem('RESTRICTIONS', 'disable_dashboard') !== '1',
		dashboard_files_enabled: GWOthers.getItem('RESTRICTIONS', 'dashboard_files_enabled'),
		dashboard_notes_enabled: GWOthers.getItem('RESTRICTIONS', 'dashboard_notes_enabled'),
		dashboard_marketplace_enabled: GWOthers.getItem('RESTRICTIONS', 'dashboard_marketplace_enabled')
	};

	var noCacheHeaders = new Headers();
		noCacheHeaders.append('pragma', 'no-cache');
		noCacheHeaders.append('cache-control', 'no-cache');

	var response = await fetch('dashboard_config.json', {
		method: 'GET',
		headers: noCacheHeaders,
	});
	if (response.status >= 200 && response.status < 300) {
		config = await response.json();
		if (config.dashboard_enabled === void 0) {
			config.dashboard_enabled = true;
		}
		['files', 'notes', 'marketplace'].forEach(function(app) {
			config['dashboard_' + app + '_enabled'] = config['dashboard_' + app + '_enabled'] === void 0 ?  GWOthers.getItem('RESTRICTIONS', 'dashboard_' + app + '_enabled') : config['dashboard_' + app + '_enabled'];
		});
	}

	if (!config.dashboard_url) {
		var cloudapi_hostname = GWOthers.getItem('GLOBAL_SETTINGS', 'cloudapi_hostname') || 'api.icewarp.com';
		if (!cloudapi_hostname.match(/\/v\d+\/?$/)) {
			cloudapi_hostname += '/v1';
		}

		cloudapi_hostname = cloudapi_hostname.replace(/^https?:\/\//, '');
		try {
			response = await fetch("//" + cloudapi_hostname + "/service/dashboard_url");
			config.dashboard_url = JSON.parse(await response.text());
		} catch {}
		config.dashboard_url = config.dashboard_url || 'https://webui.icewarp.com/v1/';
	}
	config.dashboard_url = (config.dashboard_url + '/').replace(/\/\/$/, '/');

	callback(config);
};

_me.__authenticate = function (callback) {
	var aliases = dataSet.get('storage',['ALIASES','ITEMS']).filter(function(alias) {
		return alias.VALUES.PRIMARY || (alias.VALUES.TYPE || {}).VALUE === 'user';
	}).map(function(alias) {
		return {
			email: alias.VALUES.EMAIL.VALUE,
			primary: +(alias.VALUES.PRIMARY || {}).VALUE || 0
		}
	});

	fetch(dataSet.get('dashboard', ['config', 'dashboard_url']) + 'api/authorization', {
		method: 'POST',
		headers: {
			'Content-Type': 'application/json'
		},
		mode: 'cors',
		credentials: 'include',
		body: JSON.stringify({
			email: sPrimaryAccount,
			aliases: aliases,
			token: icewarpapi.token,
			deviceId: dataSet.get('main', ['device_id']),
			favoriteFolders: (Cookie.get(['favorites']) || []).map(function(aFolder) {
				return aFolder.arg.fid && {
					aid: aFolder.arg.aid,
					fid: aFolder.arg.fid
				}
			}).filter(Boolean),
			quota: dataSet.get('main',['MBOX_QUOTA']) ? {
				quota: +dataSet.get('main',['MBOX_QUOTA']),
				usage: +dataSet.get('main',['MBOX_USAGE'])
			} : void 0,
			version: (dataSet.get('dashboard', ['config']) || {}).server_version,
			licenseType: dataSet.get('main', ['license_type'])
		})
	}).then(function(response) {
		if (response.status >= 200 && response.status < 300) {
			return response.json();
		} else {
			this.__errorHandler('ERROR::DASHBOARD_AUTHENTICATION');
		}
	}.bind(this)).then(function(response) {
		dataSet.add('dashboard', ['token'], response.token);
		dataSet.add('dashboard', ['guid'], response.guid);
		callback && callback(response);
	}).catch(this.__errorHandler.bind(this));
};

_me.__refreshToken = function (callback) {
	var uid = unique_id();

	this.frame.callbacks[uid] = callback;

	this.frame._postMessage({
		event: 'refreshToken',
		data: {
			uid: uid
		}
	});
};

_me.__errorHandler = function () {
	gui.preloader && gui.preloader._remove();

	this.__isDown = true;
	this.__isBooting = false;
	gui.frm_main.filter.__update('folders');

	executeCallbackFunction(this.__callback, false);
	delete this.__callback;

	if (this.__restartTimeout) {
		return;
	}
	this.__restartTimeout = setTimeout(function() {
		this.__restartTimeout = false;
		if (this.__isLoaded) {
			this.__init(function() {
				this.__onMessage_loaded();
			}.bind(this));
		} else {
			this.__restart();
		}
	}.bind(this), this.__getTimeoutDelay());
};

_me.__timeoutDelays = [0, 30, 60, 60, 60, 60, 60, 300, 300, 300, 300, 300, 900];
_me.__timeoutDelayIndex = 0;
_me.__getTimeoutDelay = function() {
	var timeout = this.__timeoutDelays[this.__timeoutDelayIndex++] * 1000;
	if (this.__timeoutDelayIndex >= this.__timeoutDelays.length) {
		this.__timeoutDelayIndex = this.__timeoutDelays.length - 1;
	}
	return timeout;
};

_me.__restart = function() {
	var me = this;
	this.__init(async function () {
		if (me.frame) {
			await me.frame._destruct();
		}
		await me._create('frame', 'obj_dashboard_frame', '', '', {}, me.__postMessageHandler.bind(me));

		me.__authenticateTimeout = setTimeout(function() {
			if (!me.__isLoaded) {
				me.__errorHandler();
			}
		}, 10000);
		gui.frm_main.search._obeyEvent('onsearch', [me, '__onsearch']);
		gui._obeyEvent('previewItem', [me, '__previewItemHandler']);
	});
};

_me.__fakeStart = function(callback) {
	this.__onMessage_loaded({
		capabilities: ['notes', 'apps', 'settings', 'backgrounds', 'calendar']
	});
	callback({});
};

_me.__onsearch = function(e, data) {
	if (dataSet.get('current_view') === 'dashboard_view') {
		var query = data.sql || '';
		var scope = data.scope || '';
		var match;
		if (match = query.match(/[+!?]?folders:"([^"]+)"/)) {
			scope = match[1];
			query = query.replace(/[+!?]?folders:"([^"]+)"/, '');
		}
		this.frame && this.frame._postMessage({
			event: 'search',
			data: {
				query: query,
				scope: scope
			}
		});
	}
};

_me.__postMessageHandler = function (event, data) {
	var messageHandler = this['__onMessage_' + event];
	if (messageHandler) {
		return messageHandler.call(this, data);
	}
};

_me.__onMessage_changeBackground = function () {
	GWOthers.setItem('LAYOUT_SETTINGS', 'daily_wallpaper', '0');
	GWOthers.save();
	this.__changeBackground();
};

_me.__onMessage_shareFolder = function(data) {
	Folder.share(data).__aHandler = [function(aData) {
		(aData || []).length && this.frame._postMessage({
			event: 'folderShared',
			data: {
				aid: data.aid,
				fid: data.fid
			}
		});
	}.bind(this)];
};

_me.__onMessage_openSidePanel = function (data) {
	var panel = gui.frm_main.rslide[data.panel];
	if (panel && (!panel._init || (data.aid && data.fid && data.iid))) {
		gui.frm_main.rslide._value(data.panel);
		if (panel._init) {
			panel._init({aid: data.aid, fid: data.fid, iid: data.iid});
		}
	}
};

_me.__onMessage_closeSidePanel = function () {
	if (gui.frm_main && gui.frm_main.rslide) {
		gui.frm_main.rslide._value(false);
	} else {
		Cookie.set(['rdock'], false);
	}
};

_me.__onMessage_onboardingStarted = function () {
	gui._main.classList.add('dashboard_onboarding');
	this.__onMessage_closeSidePanel();
	this.__onboardingFinished = false;
	gui.frm_main && gui.frm_main.filter && gui.frm_main.filter.__filter('D', true);
};

_me.__onMessage_onboardingFinished = async function () {
	if (this.__onboardingFinished) {
		return;
	}
	this.__onboardingFinished = true;
	gui._main.classList.add('dashboard_onboarding_step2');

	// popup to click on mail
	var popup = await gui._create('frm_dashboard_wizard_popup', 'frm_dashboard_wizard_popup', '', 'mail', getLang('DASHBOARD::WIZARD_MAIL'));
	popup._place(gui._rtl ? document.body.clientWidth - 400 : 142, 4);
	popup._add_destructor('__onclose');
	popup.__onclose = function() {
		gui.frm_main.filter.__filter('M');
	};
	gui.frm_main.filter._getAnchor('M').focus();

	dataSet.once('active_folder', [], async function() {
		gui._main.classList.remove('dashboard_onboarding');
		popup._destruct();
		var popup2 = await gui._create('frm_dashboard_wizard_popup', 'frm_dashboard_wizard_popup', '', 'dashboard', getLang('DASHBOARD::WIZARD_DASHBOARD'));
		popup2._place(gui._rtl ? document.body.clientWidth - 310 : 52, 0);
		setTimeout(function() {
			popup2._destruct();
			gui._main.classList.remove('dashboard_onboarding_step2');
		}, 5000);
		dataSet.once('active_folder', [], function() {
			popup2._destruct();
			gui._main.classList.remove('dashboard_onboarding_step2');
		});
		gui.frm_main.filter._getAnchor('D').focus();
	});
};

_me.__onMessage_loadingProgress = function(data) {
	if (data.failed && !this.__isLoaded) {
		this.__errorHandler();
	}
};

_me.__onMessage_authenticated = function() {
	var me = this;
	if (gui.preloader) {
		gui.preloader._value(getLang('PRELOADER::DASHBOARD2'));
	}
	clearTimeout(this.__authenticateTimeout);
	this.__authenticateTimeout = setTimeout(function() {
		if (!me.__isLoaded) {
			me.__errorHandler();
		}
	}, 30000);
	gui._main.classList.add('dashboard_enabled');

	this.__changeBackground();
};

_me.__onMessage_initialized = function (data) {
	this.__timeoutDelayIndex = 0;
	clearTimeout(this.__authenticateTimeout);

	if (data) {
		this.__capabilities = data.capabilities || [];
		dataSet.add('dashboard', ['middleware'], data.middleware);
		data.openai && this.__onMessage_openAI(data.openai);
	}

	gui.frm_main.filter.__update('folders');

	if (this.__callback) {
		executeCallbackFunction(this.__callback);
	}
};

_me.__onMessage_loaded = function (data) {
	clearTimeout(this.__authenticateTimeout);
	this.__isLoaded = true;

	if (data) {
		this.__capabilities = data.capabilities || [];
		dataSet.add('dashboard', ['pinnedItems'], data.pinnedItems || []);
		dataSet.add('dashboard', ['middleware'], data.middleware);

		if (data.smartlink && data.smartlink.hostname) {
			ShortURL.services.push(new RegExp('https?://(?:www\\.)?' + data.smartlink.hostname + '/[\\-_\\w]+'));
		}

		var defaultFolder = data.defaultFolder || 'Dashboard';
		if (!dataSet.get('folders', [sPrimaryAccount, defaultFolder])) {
			dataSet.add('folders', [sPrimaryAccount, defaultFolder], {
				NAME: 'Dashboard',
				TYPE: 'F',
				DEFAULT: 'D',
				RELATIVE_PATH: 'Dashboard'
			});
		} else {
			dataSet.add('folders', [sPrimaryAccount, defaultFolder, 'DEFAULT'], 'D');
		}
		dataSet.add('storage', ['DEFAULT_FOLDERS', 'ITEMS', '0', 'VALUES', 'DASHBOARD'], {
			ATTRIBUTES: {
				ACCESS: 'full',
				DONT_SEND: true
			},
			VALUE: sPrimaryAccount + '/' + defaultFolder
		});

		data.openai && this.__onMessage_openAI(data.openai);
	}

	if (this.__callback) {
		executeCallbackFunction(this.__callback, true);
		delete this.__callback;
	}

	this.__isDown = false;
	this.__isBooting = false;
	gui.frm_main.filter.__update('folders');
	gui.__exeEvent('dashboardLoaded');
};

_me.__backgroundIndex = 0;
_me.__changeBackground = async function () {
	gui._setTheme(false, dataSet.get('dashboard', ['config', 'dashboard_url']) + 'api/theme/background/' + encodeURIComponent(sPrimaryAccount) + '/active?resolution=' + Math.max(1280, window.screen.width * window.devicePixelRatio) + ('&guid=' + dataSet.get('dashboard', ['guid'])) + (this.__backgroundIndex ? '&_=' + this.__backgroundIndex : ''), true);
	this.__backgroundIndex++;
};

_me.__onMessage_setWindowTitle = function(data) {
	if (gui.frm_main && gui.frm_main.title) {
		var title = GWOthers.getItem('LAYOUT_SETTINGS','title');
		var account = dataSet.get('accounts',[sPrimaryAccount]);
		gui.frm_main.title._add([data.title, title, MailAddress.createEmail(account.FULLNAME, sPrimaryAccountGUEST ? account.USERNAME : sPrimaryAccount, true)].filter(Boolean).join(' - '));
	}

	return false;
};

_me._updateTag = function(data) {
	this.frame._postMessage({
		event: 'updateTag',
		data: {
			id: data.ID,
			name: data.TAGNAME,
			color: data.TAGCOLOR,
			usage_count: +data.TAGCOUNT || 0
		}
	});
};

_me.__onMessage_openAI = function(data) {
	dataSet.add('chatgpt', '', data || false);
	ChatGPT.models = [];
	if (data) {
		ChatGPT.modelsList(function(bOK) {
			if (!bOK) {
				return;
			}
			ChatGPT.filesList(void 0, void 0, function() {
				gui.__exeEvent('chatgptChanged');
			});
		});
	} else {
		gui.__exeEvent('chatgptChanged');
	}
};

_me._shortUrl = function (data, callback) {
	var uid = unique_id();

	this.frame.callbacks[uid] = callback;

	this.frame._postMessage({
		event: 'shorturl',
		data: {
			url: data.url,
			type: data.type,
			uid: uid
		}
	});
};

_me._addFolderToFavorites = function(aFolder) {
	this.frame._postMessage({
		event: 'addFolderToFavorites',
		data: {
			aid: aFolder.aid,
			fid: aFolder.fid
		}
	});
};

_me._removeFolderFromFavorites = function(aFolder) {
	this.frame._postMessage({
		event: 'removeFolderFromFavorites',
		data: {
			aid: aFolder.aid,
			fid: aFolder.fid
		}
	});
};

_me.__onMessage_addFolderToFavorites = function(data) {
	WMFolders.addToFavorites(data, true);
};

_me.__onMessage_removeFolderFromFavorites = function(data) {
	WMFolders.removeFromFavorites(data, true);
};

_me.__onMessage_layoutChange = function(data) {
	Cookie.set(['layout', data.module], data.layout);
	this.__doNotPostSettingsBack = true;
	gui.__exeEvent('settings_changed');
	setTimeout(function() {
		this.__doNotPostSettingsBack = false;
	}.bind(this), 50);
};

_me.__onMessage_tokenExpired = function() {
	this.__init();
};