_me = frm_compose.prototype;
function frm_compose(){};

_me.__constructor = async function(oMessage, oOldMessage, autoreopenArgs, ChatGPTOptions) {
	await storage.library('textversion', 'textversion');
	if(autoreopenArgs) {
		this.__setAutoreopenArgs(autoreopenArgs, true);
	} else {
		this.__autoreopen = false;
	}
	//default size - this line has to be presented after all elements of a window are created
	if (!gui._REQUEST_VARS['mailto'])
		this._defaultSize(900, 620, {
			goldenRatio: true,
			minHeight: 400
		});

	var me = this;

	this.__bDisableSave = false;
	this.__bContactsOpened = false;  //addContacts are opened
	this.__logoutOnDestruct = false; //try to logout on compose destruct
	//this.__bDelivery = false; //Show Delivery report
	this._detachable(true);

	this.__message = oMessage;
	this.__message_old = oOldMessage;

	//email je otevren z drafts
	if (!this.__message.__id)
		this.__removeOnDestruct = true;

	// Load mail settings
	await storage.library('gw_others');

	this.__settings = new cDataSet();
	this.__settings.add('VALUES', '', GWOthers.get('MAIL_SETTINGS_DEFAULT','storage').VALUES);
	this._settings('read_confirmation', oMessage.bReadConfirmation || (GWOthers.getItem('MAIL_SETTINGS_DEFAULT','read_confirmation') > 0));
	this._settings('reply_to_address', oMessage.sReplyTo);
	this._settings('spellchecker', oMessage.sSpellchecker);
	this._settings('sent', oMessage.sSent);


	this.__options = {};

	if (this.__message) {
		//priority
		this._settings('priority', this.__message.iPriority);
	}

	// Delayed sending in minutes
	this.__delay = parseInt(this._settings('send_delay') || 0);
	this.__fixed_delay = false;

	/*** SMS ***/
	if (sPrimaryAccountSMS && this.__message.sSMS && (GWOthers.getItem('RESTRICTIONS', 'disable_sms') || 0)<1){
		this._title('COMPOSE::SMS');
		this._settings('sms', '1');

		addcss(this._main,'sms');
	}
	else
	if (oMessage.template){
		this._title('COMPOSE::TEMPLATE');
		addcss(this._main, 'template');
		this._settings('template', '1');
		this.__removeOnDestruct = false;
	}
	else
		this._title('COMPOSE::NEWMAIL');

	/* Dropbox support allowed */
	this._settings('dropbox', (GWOthers.getItem('RESTRICTIONS', 'disable_dropbox') || 0)<1 && typeof Dropbox != 'undefined');

	/*** Smart-Attach Support ***/
	var dgw = GWOthers.getItem('RESTRICTIONS', 'disable_gw_types');
	this.__sa_support = sPrimaryAccountGW>0 && (!dgw || dgw.indexOf('f')<0);

	if (!this.__sa_support || (GWOthers.getItem('RESTRICTIONS', 'disable_smart') > 0)) {
		this._settings('direct_attach', 1);
	}

	/*** Upload ***/
	if (!this._settings('sms')){
		this.upload = await obj_upload._instance(this, this.__message.__id ? this.__message.__id[0] + '/' + this.__message.__id[1] + '/' + this.__message.__id[2] : ('tmp' + (+new Date())), {
			onclick: function(attachment) {
				return this.upload._open(attachment.__file.id);
				// this._focus();
			}.bind(this)
		}, 'obj_upload_item');
	}

	/*** Check for valid Certificate ***/
	this.__cert_support = false;

	var tmp, i,
		aCert = dataSet.get('storage',['CERTIFICATE','ITEMS']);

	if (Is.Object(aCert))
		for(i in aCert)
			if (aCert[i].VALUES && aCert[i].VALUES.INFO && aCert[i].VALUES.INFO.VALUE){
				tmp = XMLTools.Str2Arr(aCert[i].VALUES.INFO.VALUE).INFO[0];
				if (tmp.VALIDTO[0].VALUE && IcewarpDate.utct(tmp.VALIDTO[0].VALUE)>new IcewarpDate()){
					this.__cert_support = true;
					break;
				}
  			}

	if (!this.__cert_support){
		this._settings('encrypt', '0');
		this._settings('sign', '0');
	}

	if (!this._settings('sms')){

		//Parse Rcp
		var aRcp = {};
		if (oOldMessage && (oOldMessage.getTo() || oOldMessage.getCc())){
			if (oOldMessage.getTo()){
				tmp = MailAddress.splitEmailsAndNames(oOldMessage.getTo());
				for (i in tmp)
					aRcp[tmp[i].email.toLowerCase()] = true;
			}
			if (oOldMessage.getCc()){
				tmp = MailAddress.splitEmailsAndNames(oOldMessage.getCc());
				for (i in tmp)
					aRcp[tmp[i].email.toLowerCase()] = true;
			}
		}
		else
		if (oMessage && oMessage.sRcp){
			tmp = MailAddress.splitEmailsAndNames(oMessage.sRcp);
			for (i in tmp)
				aRcp[tmp[i].email.toLowerCase()] = true;
		}
		else
		if (this._settings('from')){
			tmp = MailAddress.splitEmailsAndNames(this._settings('from'));
			if (tmp[0].email.toLowerCase()!=sPrimaryAccount.toLowerCase())
				aRcp[tmp[0].email.toLowerCase()] = true;
			else
				aRcp[sPrimaryAccount.toLowerCase()] = true;
		}
		else
			aRcp[sPrimaryAccount.toLowerCase()] = true;

		//Get list of Aliases
		var bDisabled = GWOthers.getItem('RESTRICTIONS', 'disable_personalities')>0 && GWOthers.getItem('RESTRICTIONS', 'disable_delegated_aliases')>0,
			aAlias = {};

		if (!bDisabled){
			var iAliasID = null, sAlias = '', sMail, iPrimaryID = '', bFound = false;
			tmp = dataSet.get('storage',['ALIASES','ITEMS']);

			//Other Account
			if (oOldMessage && oOldMessage.__id[0] != sPrimaryAccount)
				sAlias = oOldMessage.__id[0].toLowerCase();
			else
			//Shared Account
			if (oOldMessage && oOldMessage.__id[0] == sPrimaryAccount && oOldMessage.__id[1].indexOf(sPrimaryAccountSPREFIX) == 0 && WMFolders.getAccess({aid:oOldMessage.__id[0],fid:oOldMessage.__id[1]},'modify'))
				sAlias = Path.split(oOldMessage.__id[1].substr(sPrimaryAccountSPREFIX.length))[0].toLowerCase();

			var sParimaryAlias = sPrimaryAccount.toLowerCase(),
				default_alias = GWOthers.getItem('MAIL_SETTINGS_DEFAULT', 'from');

			if (default_alias && (default_alias = MailAddress.splitEmailsAndNames(default_alias)) && (default_alias = default_alias[0]) && (default_alias = default_alias.email))
				sParimaryAlias = default_alias.toLowerCase();

			for(i in tmp)
				if (tmp[i] && tmp[i].VALUES && tmp[i].VALUES.EMAIL && (sMail = tmp[i].VALUES.EMAIL.VALUE.toLowerCase())){

					if (sAlias && sAlias == sMail){
						aAlias[i] = [MailAddress.createEmail(tmp[i].VALUES.NAME?tmp[i].VALUES.NAME.VALUE:'', sMail, true), MailAddress.createEmail(tmp[i].VALUES.NAME?tmp[i].VALUES.NAME.VALUE:'', sMail)];

						iAliasID = i;
						bFound = true;
					}
					else
					if (sParimaryAlias == sMail){

						if (sParimaryAlias == sPrimaryAccount.toLowerCase())
							aAlias[i] = [getPrimaryAccountFromAddress(true), getPrimaryAccountFromAddress()];
						else
							aAlias[i] = [MailAddress.createEmail(tmp[i].VALUES.NAME?tmp[i].VALUES.NAME.VALUE:'', sMail, true), MailAddress.createEmail(tmp[i].VALUES.NAME?tmp[i].VALUES.NAME.VALUE:'', sMail)];

						if (aRcp[sMail] && !bFound)
							iAliasID = i;

						iPrimaryID = i;
					}
					else
					if (sMail && tmp[i].VALUES.ENABLED && tmp[i].VALUES.ENABLED.VALUE == '1'){
						aAlias[i] = [MailAddress.createEmail(tmp[i].VALUES.NAME?tmp[i].VALUES.NAME.VALUE:'', sMail, true), MailAddress.createEmail(tmp[i].VALUES.NAME?tmp[i].VALUES.NAME.VALUE:'', sMail)];

						if (aRcp[sMail] && iAliasID == null)
							iAliasID = i;
					}
				}

			// Reply to shared mail folder with WRITE right
			if (sAlias && !bFound){
				aAlias['*'] = [MailAddress.createEmail('',sAlias, true), MailAddress.createEmail('',sAlias)];
				iAliasID = '*';
			}
			else
			if (iAliasID == null)
				iAliasID = iPrimaryID;
		}

		//Automatically Reply to Myself
		var rm = GWOthers.getItem('MAIL_SETTINGS_DEFAULT', 'reply_myself');
		switch(rm){
		case 'cc':
		case 'bcc':

			var sReAlias = '';
			if (!bDisabled && iAliasID != null && aAlias[iAliasID])
				sReAlias = aAlias[iAliasID][1];
			else
				sReAlias = getPrimaryAccountFromAddress();

			this.__message[rm == 'cc'?'sCc':'sBcc'] = MailAddress.appendEmail(this.__message[rm == 'cc'?'sCc':'sBcc'],sReAlias);
		}
	}

	var static_flags = ((this.__message_old || {}).__mailInfo || {}).STATIC_FLAGS || oMessage.static_flags;

	// Draw extended options in main area
	var disabled = {
		disable_pe: count(aAlias)<2,
		disable_ab:sPrimaryAccountGW<1 || (GWOthers.getItem('RESTRICTIONS', 'disable_gw_types') || '').indexOf('c')>-1,
		disable_chat: !sPrimaryAccountCHAT || (static_flags & 32 && this.__message._bIsReplying),
		hide_pe:GWOthers.getItem('MAIL_SETTINGS_DEFAULT','show_from')!=1 && iAliasID == iPrimaryID && sParimaryAlias == sPrimaryAccount.toLowerCase(),
		hide_cc:!this.__message.sCc && (GWOthers.getItem('MAIL_SETTINGS_DEFAULT','show_cc')!=1 || this._settings('sms')),
		hide_bcc:!this.__message.sBcc && (GWOthers.getItem('MAIL_SETTINGS_DEFAULT','show_bcc')!=1 || this._settings('sms')),
		ext_ab:GWOthers.getItem('GLOBAL_SETTINGS','external_contacts')?true:false,
		maxsize:dataSet.get('main',['message_size'])?true:false,
		sms:this._settings('sms'),

		disable_smart_attach: GWOthers.getItem('RESTRICTIONS', 'disable_smart') > 0 || !this.__sa_support,

		disable_signing: !this.__cert_support || !GWOthers.getItemAccess('MAIL_SETTINGS_DEFAULT','sign'),
		disable_encryption_rule: GWOthers.getItem('MAIL_SETTINGS_DEFAULT','encrypt') !== '1' && !GWOthers.getItemAccess('MAIL_SETTINGS_DEFAULT','encrypt'),
		disable_signing_rule: GWOthers.getItem('MAIL_SETTINGS_DEFAULT','sign') !== '1' && !GWOthers.getItemAccess('MAIL_SETTINGS_DEFAULT','sign'),
		disable_encryption: !this.__cert_support || !GWOthers.getItemAccess('MAIL_SETTINGS_DEFAULT','encrypt'),
		disable_confirmation: !GWOthers.getItemAccess('MAIL_SETTINGS_DEFAULT','read_confirmation'),
		disable_delivery_report: sPrimaryAccountDELIVERY==1?false:true,
		allow_delaying: sPrimaryAccountSMTP==1,
		replyto:GWOthers.getItemAccess('MAIL_SETTINGS_DEFAULT','reply_to_address'),
		template:this._settings('template'),
		disable_html:!GWOthers.getItemAccess('MAIL_SETTINGS_DEFAULT','html_message') && '0' === GWOthers.getItem('MAIL_SETTINGS_DEFAULT','html_message'),
		webclient_mail_control: GWOthers.getItem('MAIL_SETTINGS_DEFAULT', 'webclient_mail_control') == 1,
		classification: !oOldMessage && GWOthers.getItem('MAIL_SETTINGS_DEFAULT', 'classification')>0
	};

	this.__options.cc = !disabled.hide_cc;
	this.__options.bcc = !disabled.hide_bcc;

	// Draw main area
	await this._draw('frm_compose','main', disabled);

	if (disabled.classification) {
		var short = {};
		['unclassified', 'classified', 'public', 'red', 'internal', 'confidential', 'restricted'].forEach(function(i) {
			short[i[0]] = i;
		});
		var colors = {"unclassified": "", "classified": "", "public": "", "red": ""};
		try {
			colors = JSON.parse(GWOthers.getItem('MAIL_SETTINGS_DEFAULT', 'classification_colors'));
		} catch {}
		var classes = {};
		var first;
		for (var i in colors) {
			first = first || i;
			classes[i] = getLang('COMPOSE::CLASSIFICATION') + ': ' + getLang('COMPOSE::' + i);
			short[i[0]] = i;
		}
		this.classification._fill(classes);
		this.classification._value(first);
		this.__message.sSubject = (this.__message.sSubject || '').replace(/\s*\[([UCPRI])\]$/, function(_, c) {
			this.classification._value(short[c.toLowerCase()]);
			return '';
		}.bind(this));
	}

	if (!this._settings('sms')) {
		await this._create('body', 'obj_wysiwyg', 'body', '', {
			isEmail: true,
			reply: this.__message_old,
			disable_html: disabled.disable_html,
			classification: GWOthers.getItem('MAIL_SETTINGS_DEFAULT', 'classification')>0 && this.__addClassification.bind(this),
			onfocus: this._focus.bind(this),
			forceEmbeddedImages: false
		});
		this.body._tabIndex();
	}

	await this._draw('frm_compose_options', 'options', disabled);

	this._getAnchor('close_options').onclick = function(){
		this._options_toggle(false);
	}.bind(this);

	await this._draw('frm_compose_smart', 'smart', disabled);
	this.smart_password.__setMask({ toggle: ['', getLang('COMMON::SHOW')] }, [
		function () {
			if (me.smart_password.__eIN.getAttribute('type') === 'text') {
				me.smart_password.__eIN.setAttribute('type', 'password');
			} else {
				me.smart_password.__eIN.setAttribute('type', 'text');
			}
		}
	]);

	this._getAnchor('close_smart').onclick = function(){
		this._smart_toggle(false);
	}.bind(this);

	await this._draw('frm_compose_bottom','footer', disabled);

	//this.priority._disabled(!GWOthers.getItemAccess('MAIL_SETTINGS_DEFAULT','priority'));

	this.mode_select._disabled(!GWOthers.getItemAccess('MAIL_SETTINGS_DEFAULT','html_message'));

	//fill spellchecker lang in extended options
	var aLang = dataSet.get('storage',['SPELLCHECKER_LANGUAGES','ITEMS']),
		aTmp = [],
		aData = {};

	for (i in aLang)
		if (aLang[i].VALUES && aLang[i].VALUES.PATH && aLang[i].VALUES.NAME)
			aTmp.push([aLang[i].VALUES.PATH.VALUE, aLang[i].VALUES.NAME.VALUE]);

	//Sort
	if (aTmp.length){
		aTmp = aTmp.sort(function(a,b){
			if (a[1]<b[1])
				return 1;
			else
			if (a[1]>b[1])
				return -1;
			else
				return 0;
		});

		for (i = aTmp.length-1;i>=0;i--)
			aData[aTmp[i][0]] = aTmp[i][1];

		aTmp = null;
	}

	this.spellchecker._fill(aData);

	if (disabled.allow_delaying){
		await this._draw('frm_compose_delay','delay', disabled);

		//Close X
		this._getAnchor('close_delay').onclick = function(){
			this._delay_toggle();
		}.bind(this);

		// Delayed sending from settings
		if (this.__delay){
			//What to do?
		}
		else
		if (this.__message.sDeferred){
			this.__fixed_delay = true;

			var d = new IcewarpDate(this.__message.sDeferred);
			this.delay_time._value((d.hour()*60+d.minute())*60000,true);
			this.delay_date._value(d.format(IcewarpDate.JULIAN));
		}

		// Freeze date if changed by user
		this.delay_date._ondateselect = function() {
			me.__fixed_delay = true;

			var now = (new IcewarpDate()).format('julian');
			if (this._value()<now)
				this._value(now, true);
		};
		this.delay_time._onchange = function() {
			me.__fixed_delay = true;
		};
	}

	//Fill Select Sent folder
	this.sent.__fillme = function(){
		var aPath,
			aData = {'*':getLang('COMMON::NO')};

		var savedSentFolders = Cookie.get(['sent_folders']) || [];
		savedSentFolders.forEach(function(sFolder) {
			aPath = Path.split(sFolder);
			aData[sFolder] = dataSet.get('folders', [aPath[0], aPath[1], 'NAME']) || aPath[1];
		});

		if (me._settings('sent')){
			aPath = Path.split(me._settings('sent'));
			aData[me._settings('sent')] = dataSet.get('folders', [aPath[0], aPath[1], 'NAME']) || aPath[1];
		}

		aPath = Path.split(GWOthers.getItem('DEFAULT_FOLDERS','sent'));
		aData[GWOthers.getItem('DEFAULT_FOLDERS','sent')] = dataSet.get('folders', [aPath[0], aPath[1], 'NAME']) || aPath[1];
		aData['+'] = getLang('SELECT_FOLDER::SELECT_FOLDER');
		this._fill(aData);
	};
	this.sent.__fillme();

	this.sent._onchange = async function() {
		switch(this._value()){
		case '*':
			me._settings('save_sent_message', 0);
			me._settings('include_in_sent_folder', 0);
			me._getAnchor('include_in_sent_folder').setAttribute('hidden', '');
			break;

		case '+':
			var aPath = (me.__message_old && me.__message_old.__id) ? me.__message_old.__id : Path.split(GWOthers.getItem('DEFAULT_FOLDERS','sent'));

			await me._gui._create('select_folder', 'frm_select_folder', '', '', 'SELECT_FOLDER::SELECT_FOLDER', aPath[0], aPath[1], [function(sAccount, sFolder){
				if (sAccount && sFolder){
					me._settings('sent', sAccount+'/'+sFolder);
					me.sent.__fillme();
					me.sent._value(sAccount+'/'+sFolder);

					if (GWOthers.getItem('DEFAULT_FOLDERS','sent') !== (sAccount + '/' + sFolder)) {
						me._settings('include_in_sent_folder', 1);
						me._getAnchor('include_in_sent_folder').removeAttribute('hidden');
					} else {
						me._settings('include_in_sent_folder', 0);
						me._getAnchor('include_in_sent_folder').setAttribute('hidden', '');
					}
				}
			}], true, true, 'M', 'i', true);

			var sFolder = me._settings('save_sent_message') ? me._settings('sent') : '*';
			if ((sFolder === '*') || (GWOthers.getItem('DEFAULT_FOLDERS','sent') === sFolder)) {
				me._settings('include_in_sent_folder', 0);
				me._getAnchor('include_in_sent_folder').setAttribute('hidden', '');
			} else {
				me._settings('include_in_sent_folder', 1);
				me._getAnchor('include_in_sent_folder').removeAttribute('hidden');
			}
			me.sent._value(sFolder);
			break;

		default:
			var sFolder = me.sent._value();
			me._settings('save_sent_message', 1);
			me._settings('sent', sFolder);
			
			if (GWOthers.getItem('DEFAULT_FOLDERS','sent') === sFolder) {
				me._settings('include_in_sent_folder', 0);
				me._getAnchor('include_in_sent_folder').setAttribute('hidden', '');
			} else {
				me._settings('include_in_sent_folder', 1);
				me._getAnchor('include_in_sent_folder').removeAttribute('hidden');
			}
		}
	};

	this.spellchecker._onchange = function() {
		me._settings('spellchecker', this._value());
	};

	// this.priority._onchange = function(e) {
	// 	me._setPriority(me.priority._value());
	// };

	if (this.reply_to_address)
		this.reply_to_address._onblur = function() {
			me._settings('reply_to_address', me.reply_to_address._value());
		};

	if (this.from){

		this.from._fill(aAlias);

		if (iAliasID != null)
			this.from._value(iAliasID);

		var oGroup = {},
			snd = MailAddress.splitEmailsAndNames(this.from._getDataValue())[0].email,
			grp = dataSet.get('storage',['GROUPS','ITEMS']) || {},
			acc = dataSet.get('accounts'),
			ali = dataSet.get('storage',['ALIASES','ITEMS']);

		for(i in grp)
			if (grp[i].VALUES.SENTFOLDER && grp[i].VALUES.SENTFOLDER.VALUE)
				oGroup[grp[i].VALUES.GROUP.VALUE] = sPrimaryAccount + '/' + grp[i].VALUES.SENTFOLDER.VALUE;

		for (i in acc)
			if (!acc[i].PRIMARY && acc[i].SENTFOLDER)
				oGroup[i] = acc[i].SENTFOLDER;

		for (i in ali)
			if (ali[i].VALUES && !oGroup[ali[i].VALUES.EMAIL.VALUE] && ali[i].VALUES.ENABLED.VALUE == '1' && ali[i].VALUES.SENTFOLDER && ali[i].VALUES.SENTFOLDER.VALUE)
				oGroup[ali[i].VALUES.EMAIL.VALUE] = ali[i].VALUES.SENTFOLDER.VALUE;

		if (snd in oGroup){
			if (oGroup[snd] == '*'){
				me._settings('save_sent_message', 0);
				me._settings('sent', '');
			}
			else
				me._settings('sent', oGroup[snd]);

			// refresh Save to Sent Folder select in options
			if (this.sent){
				this.sent.__fillme();
				me.sent._value(me._settings('save_sent_message')?me._settings('sent'):'*');
			}
		}

		this.from._onchange = function(){
			var signID, v = this._value();

			// Forcing sent folder for sending group if applicable
			var snd = MailAddress.splitEmailsAndNames(this._getDataValue())[0].email;

			me._settings('save_sent_message', 1);
			if (snd in oGroup){
				if (oGroup[snd] == '*'){
					me._settings('save_sent_message', 0);
					me._settings('sent', '');
				}
				else
					me._settings('sent', oGroup[snd]);
			}
			else
				me._settings('sent', GWOthers.getItem('DEFAULT_FOLDERS', 'sent'));

			// refresh Save to Sent Folder select in options
			if (me.sent){
				me.sent.__fillme();
				me.sent._value(me._settings('save_sent_message')?me._settings('sent'):'*');
			}

			// Set signature according to sender address
			var aAlias = (dataSet.get('storage',['ALIASES','ITEMS',v]) || {}).VALUES;

			if (aAlias){
				if (Is.Defined(me.__message.sRcp))
					signID = aAlias.SIGN2?aAlias.SIGN2.VALUE:'';
				else
					signID = aAlias.SIGN1?aAlias.SIGN1.VALUE:'';

				me.__message.bDelegate = aAlias.ISDELEGATE && aAlias.ISDELEGATE.VALUE == '1';
			}

			me.body._addSignature(signID);
		};
	}

	//Extend button
	if (this.show_all) {
		this.show_all._onclick = function(){
			if (!me.__options.max){
				me._layout_maximize(true);
			} else {
				me._layout_minimize();
			}
		};
	}

	if (!this._settings('sms')){

		//Upload File
		this.x_btn_att._onclick = function(){
			if ((GWOthers.getItem('RESTRICTIONS', 'disable_attach_item') || 0) < 1) {
				var allowed_folder_types = ['M', 'C', 'F', 'E', 'J', 'N', 'T', 'X'];
				if (Alfresco.enabled()) {
					allowed_folder_types.push('K');
				}
	
				this._gui._create('insert_item', 'frm_insert_item', '', 'frm_insert_item_nobottomdiv', [me ,'__addItems'], sPrimaryAccount, '', '', me.upload, false, allowed_folder_types);
			} else {
				me.upload._click();
			}
		};

		if ((GWOthers.getItem('RESTRICTIONS', 'disable_attach_item') || 0) < 1) {
			this.x_btn_att._menu(function() {
				var disable_attach_item = ('1' == GWOthers.getItem('RESTRICTIONS', 'disable_attach_item')) && ~(GWOthers.getItem('RESTRICTIONS', 'disable_gw_types') || '').indexOf('f');
				return [
					{
						css: 'ico2 upload',
						title: 'COMPOSE::UPLOAD_FILE',
						arg: [function(){
							me.upload._click()
						}]
					},
					!disable_attach_item && {
						css: 'ico2 files',
						title: 'COMPOSE::UPLOAD_ITEM',
						arg: [function(){
							var allowed_folder_types = ['M', 'C', 'F', 'E', 'J', 'N', 'T', 'X'];
							if (Alfresco.enabled()) {
								allowed_folder_types.push('K');
							}

							me._gui._create('insert_item', 'frm_insert_item', '', 'frm_insert_item_nobottomdiv', [me ,'__addItems'], sPrimaryAccount, '', '', me.upload, false, allowed_folder_types, 'F');
						}]
					},
					!disable_attach_item && (gui.frm_main.dashboard || {}).__isLoaded && {
						css: 'ico2 dashboard',
						title: 'TITLE::DESKTOP',
						arg: [function(){
							var allowed_folder_types = ['M', 'C', 'F', 'E', 'J', 'N', 'T', 'X'];
							if (Alfresco.enabled()) {
								allowed_folder_types.push('K');
							}

							me._gui._create('insert_item', 'frm_insert_item', '', 'frm_insert_item_nobottomdiv', [me ,'__addItems'], sPrimaryAccount, Mapping.getDefaultFolderForGWType('D'), '', me.upload, false, allowed_folder_types, 'F');
						}]
					},
					GWOthers.getItem('RESTRICTIONS','disable_dropbox') == 0 && window.Dropbox && (GWOthers.getItem('EXTERNAL_SETTINGS', 'dropbox_app_key') || '').length && {
						css: 'ico2 dropbox',
						title: 'ATTACHMENT::FROM_DROPBOX',
						arg: [function() {
							Dropbox.choose({
								linkType: 'preview',
								success: function(files) {
									var aItems = [];
									for(var i in files) {
										aItems.push({
											type: 'url',
											title: files[i].name,
											fullpath: files[i].link,
											size: files[i].bytes
										});
									}
									me.__addItems(aItems);
								}
							});
						}]
					}
				].filter(Boolean);
			});
		} else {
			this.x_btn_att._main.classList.remove('obj_button_menu');
		}

		//Emoji
		this.body._emoji();

		this.body._showSignatureButton(true, {
			set: function(id) {
				me.__message.signatureID = id;
			},
			get: function() {
				return me.__message.signatureID;
			}
		});
		this.x_btn_priority = await this.body._create('x_btn_priority','obj_button_menu','additional_right','noborder transparent simple ico img priority');

		//Use font, size and direction container
		this.body.__output_format = true;
	}

	//Load headers
	function sendme(e){
		if ((e.ctrlKey || e.metaKey) && !me.__hidden && !(me.x_btn_save || me.x_btn_send)._disabled()){
			if (me._settings('template')){
				me.__save();
			}
			else{
				switch(GWOthers.getItem('MAIL_SETTINGS_DEFAULT','ctrl_enter').toString()){
					//Now
					case '1':
						//disable deferred delay
						if (me._settings('deferred'))
							me._delay_toggle();

						me.__send(false, true, void 0, void 0, true);
						break;

					//Delay
					case '2':
						if (disabled.allow_delaying && !me._settings('deferred'))
							me._delay_toggle();
					//Send
					default:
						me.__send(false, true);
				}
			}
		}

		return false;
	};

	if (this.to){
		this.to._collapsedValue(this.__message.sTo);
		this.to._onsubmit = sendme;
	}

	if (this.teamchat){
		this.teamchat._onsubmit = sendme;
		this.teamchat._onchange = function(){
			var a = MailAddress.splitEmails(this._value()),
				l = a.length,
				sFolder = (a[l-1] || '').replace(/[[\]]/g, '').split('::').shift();

			if (l>1)
				this._value(a.pop());

			window[l>0?'addcss':'removecss'](me.toggle_chat_message._main, 'show');

			if (me.teamchat_message.__folder.fid != sFolder){
				me.teamchat_message._value('');
				me.teamchat_message.__folder = {aid:sPrimaryAccount, fid:sFolder};
			}

			me.teamchat_message._disabled(!l);

			//Auto-focus to comment
			var elm = me._main.querySelector('div.chat_message');
			if (l){
				removecss(me._main.querySelector('div.ico_teamchat'), 'extended');

				//box lpad rpad chat_message extended
				if (elm) removecss(elm, 'extended');
				me.teamchat_message._focus();
			}
			else
			if (elm){
				addcss(elm, 'extended');
			}
			me._onresize();
		};

		if (this.__message.sTeamchat){
			this.teamchat._value('['+ this.__message.sTeamchat +']');
		}

		this.teamchat_message._onchange = function() {
			!me._destructed && window[this._value().length>0?'addcss':'removecss'](me.toggle_chat_message._main, 'dot');
		};
		this.teamchat_message._onblur = function(){
			this._onchange();
		};
		if (this.__message.sComment)
			this.teamchat_message._value(this.__message.sComment);


		this.lbl_chat._onclick = function(e, aHandler){
			var	sFolder,
				f = Cookie.get(['last']);

			if (f && (f = f['I']) && (f = Path.split(f)) && WMFolders.getType(f) == 'I'){
				sFolder = f[1];
			}
			else{
				f = dataSet.get('folders', [sPrimaryAccount]);
				for(var id in f){
					if (f[id].TYPE == 'I'){
						sFolder = id;
						break;
					}
				}
			}

			if (sFolder)
				me._gui._create('frm_select_folder', 'frm_select_folder', '', '', 'CHAT::SELECT', sPrimaryAccount, sFolder,
					[function(aid, fid){
						var sName = dataSet.get('folders', [aid, fid,'NAME']) || dataSet.get('folders', [aid, fid,'RELATIVE_PATH']) || '';
						if (sName.length){
							fid += '::'+ sName;
							me.teamchat._value('['+fid+']');

							if (aHandler)
								executeCallbackFunction(aHandler);
						}
					}], true, true, ['Y','I'], '', true
				);
		};
	}

	this.cc._collapsedValue(this.__message.sCc);
	this.cc._onsubmit = sendme;
	this.bcc._collapsedValue(this.__message.sBcc);
	this.bcc._onsubmit = sendme;
	this.subject._value(this.__message.sSubject);
	this.subject._onsubmit = sendme;

	if (!me._settings('sms') && this.__settings.get('VALUES','',true).check_external_recipients > 0) {
		var aliasDomains = dataSet.get('storage',['ALIASES','ITEMS']).filter(function(alias) {
			return alias.VALUES.PRIMARY || (alias.VALUES.TYPE || {}).VALUE === 'user';
		}).map(function(alias) {
			return alias.VALUES.EMAIL.VALUE.split('@').pop();
		});
		function onBeforeAdd(tag) {
			if (!tag.err && !tag.expand && !~aliasDomains.indexOf(MailAddress.splitEmailsAndNames(tag.tag)[0].email.split('@').pop())) {
				tag.css = ((tag.css || '') + ' external').trim();
			}
		};

		this.to._onBeforeAdd = onBeforeAdd;
		this.cc._onBeforeAdd = onBeforeAdd;
		this.bcc._onBeforeAdd = onBeforeAdd;

		var external = {};
		function onTagChange(type, value, aTags) {
			external[type] = aTags.some(function(tag) {
				return ~(tag.tag.css || '').indexOf('external');
			});
			if (Object.values(external).filter(Boolean).length) {
				addcss(me._main, 'external');
			} else {
				removecss(me._main, 'external');
			}
		}

		this.to._onchange = onTagChange.bind(null, 'to');
		this.cc._onchange = onTagChange.bind(null, 'cc');
		this.bcc._onchange = onTagChange.bind(null, 'bcc');
	}

	// SAVE (Ctrl+S) shortcut handler
	this.body.onkeydown = function(e){
		if ((e.ctrlKey || e.metaKey) && !e.altKey && (e.keyCode == 83 || e.keyCode == 13)){
			e.preventDefault();
			e.stopPropagation();

			if (me._settings('template'))
				me.__save(e.keyCode == 83);
			else
			if (e.keyCode == 83)
				me.__save();
			else
				sendme(e);
		} else if ((e.ctrlKey || e.metaKey) && e.key === 'q') {
			if (!me.body.__coded){
				me.body._editor.commands.exec('quote');
			}
		}

		if (me.body.mention_suggest && me.body.mention_suggest.suggest && ~[13, 38, 40].indexOf(e.keyCode)) { // up/down/enter
			me.body.mention_suggest.__onkeydown(e);
			e.preventDefault();
			e.stopPropagation();
			e.stopImmediatePropagation();
			return false;
		}
	};

	this.body._onesc = function() {
		if (!me.__detached) {
			me._close(true);
		}
	};

	if (this.__sa_support && this.upload){

		this.smart._value(me._settings('direct_attach') == '0');

		this.smart._onchange = function() {
			if (this._value() && me.upload._value().some(function(file) {
				return !file.removed && !WMFolders.getRights(file, 'write');
			})) {
				gui.notifier._value({type: 'info', args: {header: '', text: 'COMPOSE::SMART_ATTACH_ERROR'}});
				this._value(0);
			}
			me._settings('direct_attach', !this._value());
		};
		this.smart._onchange();

		this.__settings.on('VALUES', ['direct_attach'], function(v){
			this._value(!+v, true);
		}, this.smart, true);

	} else {
		me._settings('direct_attach', true);
	}

	this.body._onkeydown = function(e){
		switch(e.keyCode){
		case 13:
			if ((e.ctrlKey || e.metaKey) && !e.altKey){
				me.__send(false, true);
				return false;
			}
			break;
		case 83:
			if ((e.ctrlKey || e.metaKey) && !e.altKey){
				me.__save();
				return false;
			}
			break;
		case 27:
			if (me._onclose && me._onclose()){
				me._destruct();
				return false;
			}
		}
	};
	if (!this._settings('sms')){
		this.body.__getSpellLang = function(){
			return me._settings('spellchecker') || GWOthers.getItem('MAIL_SETTINGS_DEFAULT','spellchecker');
		};
		//iframe focus
		this.body.__doc().onmousedown = function(){
			me._focus();
		};
	}

	// Load mail settings
	this._aMailSettingsGeneral = GWOthers.get('MAIL_SETTINGS_GENERAL','storage');

	/******************/

	if (sPrimaryAccountGW>0){
		var btn = async function() {
			var aTabsNames, aTabsValues, address;
			if (this._name == 'btn_sms' || this._name == 'lbl_sms'){
				aTabsNames = {'sms': "DATAGRID_ITEMS_VIEW::PHONE"};
				aTabsValues = {'sms': me.sms._value()};

				address = await this._gui._create('add_address', 'frm_addaddress', '', '', [me, '_onPopupClose'], aTabsNames, aTabsValues, 'sms', false, ['L'], true);
				address._modal(true);
			}
			else{
				if (me._settings('sms') == 1){
					aTabsNames = {'cc': "DATAGRID_ITEMS_VIEW::CC", 'bcc': "DATAGRID_ITEMS_VIEW::BCC"};
					aTabsValues = {'cc': me.cc._value(), 'bcc': me.bcc._value()};
				}
				else{
					aTabsNames = {'to': "DATAGRID_ITEMS_VIEW::TO", 'cc': "DATAGRID_ITEMS_VIEW::CC", 'bcc': "DATAGRID_ITEMS_VIEW::BCC"};
					aTabsValues = {'to': me.to._value(), 'cc': me.cc._value(), 'bcc': me.bcc._value()};
				}

				switch(this._name) {
				case 'btn_to':
				case 'lbl_to':
					address = await this._gui._create('add_address', 'frm_addaddress', '', '', [me, '_onPopupClose'], aTabsNames, aTabsValues, 'to', true, false, true);
					address._modal(true);
					break;
				case 'btn_cc':
				case 'lbl_cc':
					address = await this._gui._create('add_address', 'frm_addaddress', '', '', [me, '_onPopupClose'], aTabsNames, aTabsValues, 'cc', true, false, true);
					address._modal(true);
					break;
				case 'btn_bcc':
				case 'lbl_bcc':
					address = await this._gui._create('add_address', 'frm_addaddress', '', '', [me, '_onPopupClose'], aTabsNames, aTabsValues, 'bcc', true, false, true);
					address._modal(true);
				}
			}
		};

		this.btn_sms && (this.btn_sms._onclick = btn);
		this.lbl_sms && (this.lbl_sms._onclick = btn);

		this.lbl_to && (this.lbl_to._onclick = btn);
		this.btn_to && (this.btn_to._onclick = btn);

		this.lbl_cc && (this.lbl_cc._onclick = btn);
		this.btn_cc && (this.btn_cc._onclick = btn);

		this.lbl_bcc && (this.lbl_bcc._onclick = btn);
		this.btn_bcc && (this.btn_bcc._onclick = btn);
	}

	// Custom Devel, External AB
	if (GWOthers.getItem('GLOBAL_SETTINGS','external_contacts')){
		var btn_ext = async function (){

			try{
				if (me.__ext_ab && me.__ext_ab.closed === false)
					me.__ext_ab.close();
			}
			catch(r){ console.log(this._name||false,r);}

			if (!(me.__ext_ab = window.open(await template.exe(GWOthers.getItem('GLOBAL_SETTINGS','external_contacts'),{"sid":dataSet.get('main',['sid']), "email":sPrimaryAccount}) + '&' + buildURL({o:me._pathName, btn:({btn_to_ext:'to',btn_cc_ext:'cc',btn_bcc_ext:'bcc',btn_sms_ext:'sms'})[this._name]}), 'external_contects','menubar=no,resizable=yes,status=no,location=no,width=300,height=300')))
				gui.notifier._value({type: 'alert', args: {header: '', text: 'ALERTS::POPUP_BLOCKER'}});
		};

		if (this.btn_to_ext)
			this.btn_to_ext._onclick = btn_ext;
		if (this.btn_cc_ext)
			this.btn_cc_ext._onclick = btn_ext;
		if (this.btn_bcc_ext)
			this.btn_bcc_ext._onclick = btn_ext;
	}

	////// SMS //////
	if (me._settings('sms')){
		await this._create('smsinfo', 'obj_label', 'footer_right');

		this.sms._onsubmit = sendme;
       	this.smsinfo._value(getLang('COMPOSE::SMS_INFO',[0,0]));

		this.body._onkeyup = function(){

			var tmp = this._value(),
				c, bSmall = false;

			if (tmp)
				me._title(tmp,true);
			else
				me._title('COMPOSE::SMS');

			for (var i = tmp.length-1;i>-1;i--){
				c = tmp.charCodeAt(i);
				if (c != 0xA4 && inArray(me.__GSM0338_To_Unicode_Charset,c)<0){
					bSmall = true;
					break;
				}
			}

			var n = bSmall?70:160;
			if (tmp.length/n>1)
				n = bSmall?67:153;

			c = Math.ceil(tmp.length/n);
			me.smsinfo._value((c>5?'<b>':'') + getLang('COMPOSE::SMS_INFO',[tmp.length,c])+ (c>5?'</b>':''));
		};

		if (this.__message.sSMS!==true)
			this.sms._value(this.__message.sSMS);

		this._fullbody(this.__message.sBody);

		// update SMS characters counter
		this.body._onkeyup();
	}
	//HTML Mode switcher
	else{
		// suggestions
		this.body._onkeyup = async function(e) {
			await me.__updateMaxSize();

			if(e.data.caret.container.parentElement.tagName === 'A') {
				return;
			}
			var last_word = e.data.caret.container.textContent.substr(0, e.data.caret.containerOffset).split(/\s/g).pop();
			if(last_word[0] !== '@') {
				if (me.body.mention_suggest) {
					me.body.mention_suggest.__onblur();
				}
				return;
			}
			if (!me.body.mention_suggest) {
				await me.body._create('mention_suggest', 'obj_suggest_mail', 'frame', 'floating');
				me.body.mention_suggest._itemClass = 'C';
				me.body.mention_suggest._single = true;
			}
			// var bcr = getSize(e.data.caret.range.endContainer);
			// me.body.mention_suggest._main.style.top = bcr.top + 'px';
			// me.body.mention_suggest._main.style.left = bcr.left + 'px';

			me.body.mention_suggest.__centerSuggest = e.data.caret.range.endContainer;
			// me.body.mention_suggest.__centerSuggest = me.body.mention_suggest._main;

			e.data.last_word = last_word;
			me.body.mention_suggest._obeyEvent('change', [me, '_replaceMention', [e.data]]);
			me.body.mention_suggest._value(last_word.substr(1), true);
			me.body.mention_suggest._focus = function() {};
			me.body.mention_suggest.__hasFocus = true;
			me.body.mention_suggest.__onfocus();
		}
		//call value before text-mode, to avoid nl2br conversion

		/* fix broken HTML */
		var el = mkElement('div');
		el.innerHTML = DOMPurify.sanitize(this.__message.sBody || '');
		this.__message.sBody = el.innerHTML.replace(/<span[^>]*?>(&nbsp;)?<\/span>/gi, '').replace(/<p[^>]*?>(&nbsp;)?<\/p>/gi, '');
		/* fix broken HTML */

		var quote = DOMPurify.sanitize(this.__message.sQuote);
		if (quote) {
			el.innerHTML = quote;
			quote = el.innerHTML.replace(/<span[^>]*?>(&nbsp;)?<\/span>/gi, '').replace(/<p[^>]*?>(&nbsp;)?<\/p>/gi, '');

			if ((this.__message.isHtml() && quote.length < 51200 && (this.__message.sReferences || '').split(/\n/).length < 10) || (!this.__message.isHtml() && quote.length < 1048576)) {
				this.__message.sBody += quote;
				delete this.__message.sQuote;
			}
		}
		
		if (GWOthers.getItem('MAIL_SETTINGS_DEFAULT', 'sent_via_icewarp') == 1 && !~this.__message.sBody.indexOf('iw-sent-via') && !~this.__message.sTemplate.indexOf('iw-sent-via')) {
			this.__message.sBody = NewMessage.crlf + NewMessage.crlf + '<div class="iw-sent-via">' + getLang('COMPOSE::SENT_VIA', ['<a href="https://icewarp.com">IceWarp</a>']) + '<div>' + this.__message.sBody;
		}

		if (!~this.__message.sBody.indexOf('<div class="iw-signature">') && !~this.__message.sTemplate.indexOf('<div class="iw-signature">') && !(autoreopenArgs || {}).bForwardResend) {
			this.__message.addSignature();
		}

		var sTemplate = DOMPurify.sanitize(this.__message.sTemplate || '');
		if (sTemplate) {
			el.innerHTML = sTemplate;
			sTemplate = el.innerHTML.replace(/<span[^>]*?>(&nbsp;)?<\/span>/gi, '').replace(/<p[^>]*?>(&nbsp;)?<\/p>/gi, '');

			this.__message.sBody = sTemplate + this.__message.sBody;
			delete this.__message.sTemplate;
		}

		if (!oOldMessage && (static_flags & 4 || static_flags & 32)) {
			this.__message.sBody = NewMessage.crlf + '<div class="iw-reply-block">' + this.__message.sBody + '<div>';
		}
		this._fullbody(this.__message.sBody, function() {
			this.body.__exec('undo.reset', [], true);
			var doc = this.body._editor.el.ownerDocument;

			if (static_flags & 4 || static_flags & 32) {
				[].forEach.call(doc.querySelectorAll(".iw-reply-block"), function(replyBlock) {
					replyBlock.setAttribute('contenteditable', 'false');
					if (static_flags & 4) {
						replyBlock.style.userSelect = 'none';
					}
				});
			}

			if(~['Mozilla', 'Safari'].indexOf(currentBrowser())) {
				doc.getSelection().collapse(doc.body.firstChild);
			}

			if (oMessage) {
				if (oMessage.sTo && !oMessage.sSubject) {
					this.subject._focus();
				} else if (oMessage.sTo || (oMessage.sSMS && oMessage.sSMS!==true)) {
					this.body._focus(true, true);
				} else if (this.to) {
					this.to._focus();
				} else {
					this.sms._focus();
				}
			} else if (this.to) {
				this.to._focus();
			} else {
				this.sms._focus();
			}

			if (this.__message.sQuote) {
				this._showMore = mkElement('div', {
					className: 'show_more',
					textContent: getLang('RICH::SHOW_FULL_MESSAGE')
				});
				this._showMore.addEventListener('click', function(e) {
					e.preventDefault();
					e.stopPropagation();
					e.stopImmediatePropagation();
					this._showMore.parentNode.removeChild(this._showMore);
					this.body.__exec('html.set', [this.body._editor.html.get(true) + quote], true);
					delete this.__message.sQuote;
					if (static_flags & 4 || static_flags & 32) {
						[].forEach.call(doc.querySelectorAll(".iw-reply-block"), function(replyBlock) {
							replyBlock.setAttribute('contenteditable', 'false');
							if (static_flags & 4) {
								replyBlock.style.userSelect = 'none';
							}
						});
					}
					this._onresize();
				}.bind(this), false);

				this.body.__eFrame.insertAdjacentElement('afterend', this._showMore);
			}
			this._onresize();
		}.bind(this));

		if (GWOthers.getItem('RESTRICTIONS', 'disable_mailformat') == 1){
			if (this.__message.isHtml())
				this.body.select._fillLang({'enabled': "COMPOSE::HTML", 'code':'RICH::CODE'});
			else
				this.body.select._fillLang({'disabled': "COMPOSE::TEXT", 'code':'RICH::CODE'});
		}
		else
			this.body.select._fillLang({'enabled': "COMPOSE::HTML", 'disabled': "COMPOSE::TEXT", 'code':'RICH::CODE'});

		this.body.select._value(this.__message.isHtml() ? 'enabled' : 'disabled');

		//Copy subject into window title
		this.subject._onkeyup = function(){
			var sTitle = this._value();
			if (sTitle){
				if (me._settings('template'))
					sTitle += ' - ' + getLang('COMPOSE::TEMPLATE');

				me._title(sTitle, true);
			}
			else
			if (me._settings('template'))
				me._title('COMPOSE::TEMPLATE');
			else
				me._title('COMPOSE::NEWMAIL');
		};

		this.subject._onkeyup();
	}

	//Load Attachments
	if (this.upload){

		this.body.__oUpload = this.upload;

		this.upload._onuploadstart = function(files){
			if (files.length) {
				addcss(me._main,'att_list');
			}

			[].forEach.call(files, async function(file) {
				if (file.removed) {
					return;
				}
				file.meta = me.subject._value();
				await me._create('attachment', 'obj_attachment', 'attach_list', '', file, { progress: { pie: true } });
			}, this);

			if (me.x_btn_send) me.x_btn_send._value('COMPOSE::SEND_AFTER_UPLOAD');
			me.__preventSend = true;
			if (me.x_btn_save) me.x_btn_save._disabled(true);

			me._onresize();
		};

		gui._obeyEvent('onuploadaborted', [this, '__onuploadaborted']);
		this._add_destructor('__disobeyEvents');

		this.upload._onuploadend = function(){
			me.__updateMaxSize();

			if (!disabled.disable_smart_attach){
				// Switch to HTML when SmartAttach
				if (me._settings('direct_attach') == '0' && me.body.select.__idTable['enabled'] && me.body.select._value() == 'disabled' && me.upload._filteredValue().length>0)
					me.body.select._value('enabled');
			}

			if (me.x_btn_send) me.x_btn_send._value('COMPOSE::SEND');
			me.__preventSend = false;
			if (me.x_btn_save) me.x_btn_save._disabled(false);

			me._onresize();

			if (me.__sendAfterUpload) {
				me.__send(false, true, void 0, void 0, true);
			}
		};

		//Registr DropZone
		this.upload._dropzone(this.__eContainer, async function(){
			return await (new cTemplate()).tmp('dropzone',{title:getLang('COMPOSE::DROP_TITLE'), body:getLang('COMPOSE::DROP_BODY')});
		}, 'item small');

		if (((this.__message.aAttachments || {}).attachments || []).length){
			this.upload._setAttachments(this.__message.aAttachments);

			if (!this._settings('direct_attach') && this.body.select.__idTable['enabled'] && this.body.select._value()!='enabled')
				this.body.select._value('enabled');

			if (!disabled.disable_smart_attach && this.__message.aAttachments.attachments.some(function(att) {
				return att.values.smart === 'true';
			})) {
				me._settings('direct_attach', '0');
			} else {
				// me._settings('direct_attach', '1');
			}
		} else if (me.__message.__id) {
			me._settings('direct_attach', this.__message.bSmart ? '0' : '1');
		}
		this.__updateMaxSize();
	}

	this._onclose = function() {

		//onclose is called multiple times...
		if (me._destructed) return false;

		if (!me.__bDisableSave && (me.__changed() || (me.__removeOnDestruct && me.__message.__id))) {

			//to avoid propagation of ESC to the frm_confirm
			setTimeout(async function(){
				//bring frm to front
				me._focus();

				//call save confirmation
				if (!dataSet.get('main',['sid'])){
					await gui._create('reauth','frm_reauth', '', '', [function(bOk) {
						if (bOk) {
							me.__save();
						}
					}]);
				}
				else
				if (!me.cdialog || me.cdialog._destructed){
					me.cdialog = await me._gui._create('frm_confirm','frm_confirm_threestates', '','', [me, '__confirmed'], 'CONFIRMATION::SAVE_TITLE','CONFIRMATION::SAVE_CONFIRMATION', '','CONFIRMATION::SAVE','FORM_BUTTONS::CANCEL','CONFIRMATION::DISCARD');

					addcss(me.cdialog.x_btn_ok._main,'color1');

					me.cdialog.x_btn_cancel._onclick = function() {
						this._parent._destruct(true);
					};

					addcss(me.cdialog.x_btn_cancel2._main,'trash color2 x_btn_right');
					me.cdialog.x_btn_cancel2._onclick = function() {
						executeCallbackFunction([me, '__confirmed'], false);
						me._destruct(true);
					};
				}
				else
					me.cdialog._focus();

			},0);

			return false;
		}
		else
			return true;
	};

	this._bAutoSave = parseInt(this._aMailSettingsGeneral['VALUES']['autosave']);
	this._nAutoSaveInterval = parseInt(this._aMailSettingsGeneral['VALUES']['autosave_minutes'])*60000;

	if (this._bAutoSave && this._nAutoSaveInterval)
		this.__saveTimer = setTimeout(function(){
			try{
				this.__autoSave();
			}
			catch(e){ console.log(this._name||false,e);}
		}.bind(this), this._nAutoSaveInterval);

	this._add_destructor('__onDestruct');

	if (oMessage){
		if (oMessage.sTo && !oMessage.sSubject)
			this.subject._focus();
		else
		if (oMessage.sTo || (oMessage.sSMS && oMessage.sSMS!==true))
			this.body._focus(true, true);
		else
		if (this.to)
			this.to._focus();
		else
			this.sms._focus();
	}
	else
	if (this.to)
		this.to._focus();
	else
		this.sms._focus();

	//Drop Image to richtext
	if (window.FormData && !this._settings('sms')){
		this.body.__doc().addEventListener("paste", function(e){
			// skip file upload when there is HTML clipboard entry
			if (~(e.clipboardData || (e.originalEvent || {}).clipboardData || {}).types.indexOf('text/html')) {
				return;
			}

			var items = (e.clipboardData || (e.originalEvent || {}).clipboardData || {}).items || (window.clipboardData || {}).files || [];
			for (var i = 0; i < items.length; i++) {
				if (items[i].getAsFile) {
					var file = items[i].getAsFile();
					if (!file) {
						continue;
					}
					if (items[i].type.indexOf('image') === 0) {
						me.body._editor.opts.imagePaste = false;
						me.__lastPastedImage = file.name;
						var disable_mailformat = +GWOthers.getItem('RESTRICTIONS', 'disable_mailformat');
						if ((isNaN(disable_mailformat) || disable_mailformat === 0) && true !== disabled.disable_html) {
							me.body.select._value('enabled');
						}
						try {
							file = new File([file], 'clipboard-' + new IcewarpDate() + '.png', {
								type: items[i].type
							});
							file.removed = true;
						} catch {
							//
						}
						me.upload.file.__ondropfile([file],[me,'__richImage',[[e.rangeParent,e.rangeOffset]]]);
					} else {
						me.upload.file.__ondropfile([file]);
					}
					e.stopPropagation();
					e.stopImmediatePropagation();
					e.preventDefault();
				}
			}
		}, false);

		function dropHandler(e) {
			gui.frm_main.__file_dragover(false);
			e.stopPropagation();

			if (e.dataTransfer.files.length>0){
				e.preventDefault();
				if (me.upload.file.__ondropfile){

					//check for already uploaded images
					for (var b, file, files = [], i = 0; i < e.dataTransfer.files.length; i++) {
						b = false;
						file = e.dataTransfer.files[i];

						if (file.type.toLowerCase().indexOf('image/') === 0){
							file.removed = true;
							var val = me.upload.file._value();
							for (var j in val){
								if (file.name == val[j].name && file.size == val[j].size && !val[j].removed) {
									b = true;
									me.__richImage(val[j], file.type, {}, [e.rangeParent, e.rangeOffset]);
									break;
								}
							}
						}

						if (!b) {
							files.push(file);
						}
					}

					if (files.length) {
						me.upload.file.__ondropfile(files,[me,'__richImage',[[e.rangeParent,e.rangeOffset]]]);
					}
				}
			}
		}

		this.body.__doc().addEventListener("drop", dropHandler, false);
		this.body._getAnchor('frame').addEventListener("drop", dropHandler, false);
		this._add_destructor('__disobeyEvents');
	}

	// Footer
	if (me.x_btn_send){

		this.x_btn_send._onclick = function(){
			if (me.__preventSend) {
				me.__sendAfterUpload = true;
				me.__hide();
				me.__sendAfterUploadNotification = gui.notifier._value({
					type: 'send_after_upload',
					args: {
						undo: function() {
							me.__sendAfterUpload = false;
							me.__show();
							me.__sendAfterUploadNotification.close();
						}
					}
				});
			} else {
				me.__send(false, true, false, false, GWOthers.getItem('MAIL_SETTINGS_DEFAULT','send_undo') != '1');
			}
		};

		this.x_btn_send._menu(function(){

			var arr = [];

			arr.push(
				{
					title: 'COMPOSE::SEND_NOW',
					arg: [
						function(){
							//disable deferred delay
							if (me._settings('deferred'))
								me._delay_toggle();

							me.__send(false, true, void 0, void 0, true);
						}
					],
					disabled: me.__preventSend
				}
			);

			if (disabled.allow_delaying) {
				arr.push(
					{
						title: 'COMPOSE::SEND_WITH_DELAY',
						arg: [function() {me._delay_toggle()}],
						disabled: me.__preventSend
					}
				);
			}

			arr.push(
				{
					title: 'COMPOSE::SAVEINFO',
					arg: [function() { me.__save() }],
					disabled: me.__preventSend
				}
			);

			if (sPrimaryAccountCHAT && me.teamchat){
				arr.push({
					title: 'COMPOSE::SENDTCHAT',
					arg:[function(){ //disabled:!me.teamchat._value()
						if (me.teamchat._value()){
							if (!me.__bDisableSave)
								me.__send(2, true);
						}
						//pop folder select
						else{
							me.lbl_chat._onclick(null, [function(){
								if (!me.__bDisableSave && me.teamchat._value())
									me.__send(2, true);
							}]);
						}
					}],
					disabled: me.__preventSend
				});
			}

			return arr;
		}, 'compose_send_menu');
	}

	if (this.x_btn_save)
		this.x_btn_save._onclick = function(){
			me.__save();
		};

	if (this.x_btn_confirm){
		this.x_btn_confirm._onclick = function(){
			me._options_toggle(true);
			me.__highlightOption('confirm');
		};

		this.__settings.on('VALUES', ['read_confirmation'], function(v){
			togglecss(this._main, 'show', v == '1');
		}, this.x_btn_confirm, true);
	}

	if (this.x_webclient_smart_expiration){
		this.x_webclient_smart_expiration._onclick = function(){
			me._smart_toggle(true);
			me.__highlightOption('smart_expiration', 'smart');
		};

		this.__settings.on('VALUES', ['webclient_smart_expiration'], function(v){
			togglecss(this._main, 'show', !!+v);
			if (v !== "1") {
				togglecss(this._main, 'color2', IcewarpDate.unix(me.smart_expiration._value(void 0, false, false)).isBefore(new IcewarpDate(), 'day'));
			}
		}, this.x_webclient_smart_expiration, true);
	}

	if (this.x_webclient_smart_password){
		this.x_webclient_smart_password._onclick = function(){
			me._smart_toggle(true);
			me.__highlightOption('smart_password', 'smart');
		};

		this.__settings.on('VALUES', ['webclient_smart_password'], function(v){
			togglecss(this._main, 'show', !!v);
		}, this.x_webclient_smart_password, true);
	}

	if (this.x_webclient_print){
		this.x_webclient_print._onclick = function(){
			me._options_toggle(true);
			me.__highlightOption('print');
		};

		this.__settings.on('VALUES', ['webclient_print'], function(v){
			togglecss(this._main, 'show', !!v);
		}, this.x_webclient_print, true);
	}

	if (this.x_webclient_forward){
		this.x_webclient_forward._onclick = function(){
			me._options_toggle(true);
			me.__highlightOption('forward');
		};

		this.__settings.on('VALUES', ['webclient_forward'], function(v){
			togglecss(this._main, 'show', v == '1');
		}, this.x_webclient_forward, true);
	}

	if (this.x_webclient_reply){
		this.x_webclient_reply._onclick = function(){
			me._options_toggle(true);
			me.__highlightOption('reply');
		};

		this.__settings.on('VALUES', ['webclient_reply'], function(v){
			togglecss(this._main, 'show', v == '1');
		}, this.x_webclient_reply, true);
	}

	if (this.x_webclient_edit){
		this.x_webclient_edit._onclick = function(){
			me._options_toggle(true);
			me.__highlightOption('edit');
		};

		this.__settings.on('VALUES', ['webclient_edit'], function(v){
			togglecss(this._main, 'show', v == '1');
		}, this.x_webclient_edit, true);
	}

	if (this.x_btn_delivery){
		this.x_btn_delivery._onclick = function(){
			me._options_toggle(true);
			me.__highlightOption('delivery');
		};

		this.__settings.on('VALUES', ['delivery'], function(v){
			togglecss(this._main, 'show', v == '1');
		}, this.x_btn_delivery, true);
	}

	if (this.x_btn_encrypt){
		this.x_btn_encrypt._onclick = function(){
			me._options_toggle(true);
			me.__highlightOption('encrypt');
		};

		this.__settings.on('VALUES', ['encrypt'], function(v){
			togglecss(this._main, 'show', v == '1');
		}, this.x_btn_encrypt, true);
	}

	if (this.x_btn_sign){
		this.x_btn_sign._onclick = function(){
			me._options_toggle(true);
			me.__highlightOption('sign');
		};

		this.__settings.on('VALUES', ['sign'], function(v){
			togglecss(this._main, 'show', v == '1');
		}, this.x_btn_sign, true);
	}

	if (this.smart){
		this.__settings.on('VALUES', ['direct_attach'], function(v){
			togglecss(this._main, 'show', v == '1');
			me._main.classList.toggle('direct_attach', v == '1');

			if (v == '0') {
				me.x_btn_att._main.classList.remove('direct');
				me.x_btn_att._main.classList.add('smart');

				me.smart._title('COMPOSE::SMARTATTACH');
				me.smart._main.querySelector('label').appendChild(mkElement('span', {
					textContent: getLang('COMPOSE::SMARTATTACH_HELPER')
				}));
				me.smart._main.querySelector('label').appendChild(mkElement('a', {
					textContent: getLang('COMPOSE::SET_SMART'),
					onclick: function(e) {
						e.preventDefault();
						e.stopPropagation();
						e.stopImmediatePropagation();
						me._smart_toggle(true);
					}
				}));
			} else {
				me._smart_toggle(false);
				me.x_btn_att._main.classList.add('direct');
				me.x_btn_att._main.classList.remove('smart');

				me.smart._title('COMPOSE::DIRECTATTACH');
				me.smart._main.querySelector('label').appendChild(mkElement('span', {
					textContent: getLang('COMPOSE::DIRECTATTACH_HELPER')
				}));
			}
		}, this.smart, true);
	} else {
		me._main.classList.add('direct_attach');
	}

	if (this.x_btn_priority){
		this.x_btn_priority._onopen = function() {
			me.body.cmenu = this.cmenu;
		}
		this.x_btn_priority._onclick = function(e){
			if (!this.cmenu || this.cmenu._destructed){
				e.stopPropagation();
				this.__eArrow.onclick();
			}
		};
		this.x_btn_priority._main.onmousedown = function(e){
		 	if (this.cmenu && !this.cmenu._destructed){
		 		e.stopPropagation();
		 	}
		}.bind(this.x_btn_priority);

		this.x_btn_priority._menu(function(){
			var arr = [
				{
					title: 'EMAIL_PRIORITY::HIGH',
					css:'ico2 high',
					arg: [me, '_setPriority', [2]]
				},
				{
					title: 'EMAIL_PRIORITY::NORMAL',
					css:'ico2 normal',
					arg: [me, '_setPriority', [3]]
				},
				{
					title: 'EMAIL_PRIORITY::LOW',
					css:'ico2 low',
					arg: [me, '_setPriority', [4]]
				}
			];

			return arr;
		}, 'compose_priority_menu');

		this.__settings.on('VALUES', ['priority'], function(v){
			this._main.setAttribute('iw-priority', ({1:'high', 2:'high', 3:'', 4:'low', 5:'low'})[v]);
			this._title(getLang('SETTINGS::PRIORITY') + ' - ' + getLang(({1:'EMAIL_PRIORITY::HIGH', 2:'EMAIL_PRIORITY::HIGH', 3:'EMAIL_PRIORITY::NORMAL', 4:'EMAIL_PRIORITY::LOW', 5:'EMAIL_PRIORITY::LOW'})[v]), true);
		}, this.x_btn_priority, true);
	}


	//Options
	if (this.x_btn_options) {
		this.x_btn_options._onclick = function(){
			me._options_toggle();
		};

		if (this.read_confirmation){
			this.read_confirmation._onchange = function(){
				this._settings('read_confirmation', this.read_confirmation._value()?'1':'0');
			}.bind(this);

			this.__settings.on('VALUES','read_confirmation',function(v){
				this._value(v);
			}, this.read_confirmation);
		}

		if (this.sign){
			this.sign._onchange = function(){
				this._settings('sign', this.sign._value().toString());
			}.bind(this);

			this.__settings.on('VALUES','sign',function(v){
				this._value(v);
			}, this.sign);
		}

		if (this.encrypt){
			this.encrypt._onchange = function(){
				this._settings('encrypt', this.encrypt._value().toString());
			}.bind(this);

			this.__settings.on('VALUES','encrypt',function(v){
				this._value(v);
			}, this.encrypt);
		}

		if (this.smart_expiration) {
			var expiration_days = this._settings('webclient_smart_expiration_days');
			if (expiration_days > 0) {
				this.smart_expiration._value(new IcewarpDate().add(expiration_days, 'day').unix(), false, false);
			} else {
				this.smart_expiration._value(new IcewarpDate().add(1, 'month').unix(), false, false);
			}
			this.smart_expiration.__opt.minDate = new IcewarpDate();

			this.smart_expiration_enabled._onchange = function(e, checked) {
				this._getAnchor('smart_expiration_container').classList[checked ? 'remove' : 'add']('hidden');
				this._settings('webclient_smart_expiration', this.smart_expiration_enabled._value() && this.smart_expiration._value(void 0, false, false));
			}.bind(this);

			this.smart_expiration._ondateselect = function() {
				this._settings('webclient_smart_expiration', this.smart_expiration._value(void 0, false, false));
			}.bind(this);

			this.__settings.on('VALUES','webclient_smart_expiration', function(v) {
				me.smart_expiration_enabled._checked(!!v);
			}, this.smart_expiration);

			this.smart_expiration_enabled._value(this._settings('webclient_smart_expiration') == 1);
		}

		if (this.smart_password) {
			this.smart_password_enabled._onchange = function(e, checked) {
				this._getAnchor('smart_password_container').classList[checked ? 'remove' : 'add']('hidden');
				this._settings('webclient_smart_password', this.smart_password_enabled._value() && this.smart_password._value());
			}.bind(this);

			this.smart_password._onkeyup = function() {
				this._settings('webclient_smart_password', this.smart_password._value());
			}.bind(this);

			this.__settings.on('VALUES','webclient_smart_password', function(v) {
				if (v) {
					me.smart_password_enabled._checked(true);
					this._value(v);
				}
			}, this.smart_password);
		}

		if (this.webclient_print){
			this.webclient_print._onchange = function(){
				this._settings('webclient_print', this.webclient_print._value()?'1':'0');
			}.bind(this);

			this.__settings.on('VALUES','webclient_print',function(v){
				this._value(v);
			}, this.webclient_print);
		}

		if (this.webclient_forward){
			this.webclient_forward._onchange = function(){
				this._settings('webclient_forward', this.webclient_forward._value()?'1':'0');
			}.bind(this);

			this.__settings.on('VALUES','webclient_forward',function(v){
				this._value(v);
			}, this.webclient_forward);
		}

		if (this.webclient_reply){
			this.webclient_reply._onchange = function(){
				this._settings('webclient_reply', this.webclient_reply._value()?'1':'0');
			}.bind(this);

			this.__settings.on('VALUES','webclient_reply',function(v){
				this._value(v);
			}, this.webclient_reply);
		}

		if (this.webclient_edit){
			this.webclient_edit._onchange = function(){
				this._settings('webclient_edit', this.webclient_edit._value()?'1':'0');
			}.bind(this);

			this.__settings.on('VALUES','webclient_edit',function(v){
				this._value(v);
			}, this.webclient_edit);
		}

		this.include_in_sent_folder._onchange = function() {
			this._settings('include_in_sent_folder', +this.include_in_sent_folder._checked());
		}.bind(this)
		this.__settings.on('VALUES','include_in_sent_folder', function(v) {
			this._value(v);
		}, this.include_in_sent_folder);
	}

	if (static_flags) {
		if (static_flags & 4) {
			this._settings('webclient_print', '1');
			this.webclient_print._disabled(true);
		}
		if (static_flags & 8) {
			this._settings('webclient_forward', '1');
			this.webclient_forward._disabled(true);
		}
		if (static_flags & 16) {
			this._settings('webclient_reply', '1');
			this.webclient_reply._disabled(true);
		}
		if (static_flags & 32) {
			this._settings('webclient_edit', '1');
			this.webclient_edit._disabled(true);
			this.subject._disabled(true);

			if (this.__message._bIsReplying) {
				this.to._disabled(true);
				this.lbl_to._disabled(true);
				this.cc._disabled(true);
				this.lbl_cc._disabled(true);
				this.bcc._disabled(true);
				this.lbl_bcc._disabled(true);
			} else if (this.__message._bIsForwarding) {
				gui.frm_compose.attach._main.classList.add('readonly');
				this.x_btn_att._destruct();
				this.x_btn_att2._destruct();
			}
		}
	}

	setTimeout(function() {
		if (!this.__message || !this.__message.ask_on_close)
			this.__rememberState();
	}.bind(this), 200);

	if (this.toggle_chat_message) {
		this.toggle_chat_message._onclick = function() {
			var elm = me._main.querySelector('div.chat_message');

			if (elm.classList.contains('extended')) {
				elm.classList.remove('extended');

				addcss(me.toggle_chat_message._main, 'nodot');

			} else {
				elm.classList.add('extended');

				removecss(me.toggle_chat_message._main, 'nodot');
			}

			if (me.teamchat_message._disabled() == false)
				me.teamchat_message._focus();

			me._onresize();
		};
	}

	//Maximize on Headers
	[(this.to || this.sms), this.cc, this.bcc, this.teamchat].forEach(function(obj){
		if (obj){
			obj._main.addEventListener('click', function() {
				me._layout_maximize();
			});
			obj._main.addEventListener('keyup', function() {
				me._layout_maximize();
			});
		}
	});

	//Minimize on Body
	var eBodyElm = this._settings('sms')?this.body._getFocusElement():this.body.__doc();
	eBodyElm.addEventListener('keyup', function() {
		me._layout_minimize();
	});
	eBodyElm.addEventListener('click', function() {
		me._layout_minimize();
	});

	if (gui.frm_main && gui.frm_main.dnd)
		gui.frm_main.dnd.registr_drop(this, ['item', 'attachment']);

	if (!this._settings('sms')) {
		this.__initChatGPT(ChatGPTOptions);
		gui._obeyEvent('chatgptChanged', [this, '__initChatGPT']);
	}

	this.body._obeyEvent('selectionHighlighted', [this, '__handleSelectionHighlighted']);
	this.body._obeyEvent('selectionUnhighlighted', [this, '__handleSelectionUnhighlighted']);

	this.__images = {};
};

_me.__handleSelectionHighlighted = function() {
	this.__bDisableSaveState = this.__bDisableSave;
	this.__bDisableSave = true;
};

_me.__handleSelectionUnhighlighted = function() {
	this.__bDisableSave = this.__bDisableSaveState;
};

_me.__initChatGPT = async function(options) {
	if (dataSet.get('chatgpt') && !this.chatgpt) {
		this.body._getAnchor('richheader').prepend(mkElement('span', {}, this.body.__doc(), [
			this.__chatgptToggleButton = mkElement('a', {
				className: 'ico chatgpt',
				onclick: function() {
					this.__toggleChatGPTPanel();
				}.bind(this)
			}, this.body.__doc()),
			mkElement('div', {
				className: 'separator'
			}, this.body.__doc())
		]));
		await this._create('chatgpt', 'obj_chatgpt_panel', { first: true }, '', Object.assign({
			editor: this.body,
			compose: true,
			reply: this.__message_old,
			alias: ((this.__message_old || {}).__id || [])[2],
			label: function() {
				return this._title();
			}.bind(this)
		}, options || {}));
		this.chatgpt.slider.menu._getAnchor('collapse').addEventListener('click', function() {
			this.__toggleChatGPTPanel(false);
		}.bind(this));
		this.body.__opt.chatgpt = this.chatgpt;
		this.__toggleChatGPTPanel(Cookie.get(['chatgpt', 'compose_side_panel']));
	} else if (this.chatgpt) {
		this.__chatgptToggleButton.parentElement.parentElement.removeChild(this.__chatgptToggleButton.parentElement);
		this.body.__opt.chatgpt = false;
		this.chatgpt._destruct();
	}
};

_me.__toggleChatGPTPanel = function(bForcedState) {
	var toggleState = bForcedState === void 0 ? !this._main.classList.contains('chatgpt_panel') : !!+bForcedState;
	if (toggleState) {
		this._main.classList.add('chatgpt_panel');
		this.chatgpt._main.removeAttribute('aria-hidden');
		this.__chatgptToggleButton.classList.add('active');
	} else {
		this._main.classList.remove('chatgpt_panel');
		this.chatgpt._main.setAttribute('aria-hidden', '');
		this.__chatgptToggleButton.classList.remove('active');
	}
	Cookie.set(['chatgpt', 'compose_side_panel'], (+!!toggleState).toString());
};

_me.__highlightOption = function(option, anchor) {
	option = this._getAnchor(anchor || 'options').querySelector('.' + option);
	if (this.__hightlightedOption) {
		this.__hightlightedOption.classList.remove('highlight');
	}

	if (option) {
		this.__hightlightedOption = option;
		clearTimeout(option.__highlightTimeout);

		if (option.scrollIntoViewIfNeeded) {
			option.scrollIntoViewIfNeeded();
		} else {
			option.scrollIntoView();
		}
		option.classList.add('highlight');
		option.__highlightTimeout = setTimeout(function() {
			option.classList.remove('highlight');
		}, 2000);
	}
};

_me._active_dropzone = async function(v){
	if (v && ['item', 'attachment'].indexOf(v.type)) {
		var mask = mkElement('div', {
			className: 'dropzone item',
			onmouseenter: function() {
				mask.classList.add('active');
			},
			onmouseleave: function() {
				mask.classList.remove('active');
			},
			innerHTML: await (new cTemplate()).tmp('dropzone', {
				title: getLang('COMPOSE::DROP_TITLE'),
				body: ''
			})
		});
		this._getAnchor('box').appendChild(mask);
		return mask;
	} else {
		return false;
	}
};

_me._ondrop = function(aData) {
	this.__addItems(aData.value.map(function(v) {
		if (aData.type === 'attachment') {
			return v;
		}
		var aItem = v.EVNLOCATION ? v : dataSet.get('items', [v.aid, v.fid, WMItems.__clientID(v.iid)]) || v;
		var size = 0;
		var title = '';
		var type = 'item';
		var sType = WMFolders.getType(v);
		var fullpath = v.aid + '/' + Path.slash(v.fid) + '/' + WMItems.__serverID(v.iid);
		switch (sType) {
			case 'M':
				title = (aItem.SUBJECT || getLang('MAILVIEW::NOSUBJECT')) + '.eml';
				type = 'message';
				size = aItem.SIZE;
				break;
			case 'C':
				title = aItem.ITMCLASSIFYAS + '.vcf';
				break;
			case 'I':
			case 'K':
			case 'F':
				title = aItem.EVNLOCATION || aItem.name || v.name;
				size = aItem.EVNCOMPLETE || aItem.size || v.size;
				break;
			case 'E':
			case 'J':
			case 'N':
			case 'T':
				title = aItem.EVNTITLE + '.ics';
				break;
			default:
				title = getLang('INSERT_ITEM::UNTITLED');
		}

		return {
			type: type,
			aid: v.aid,
			fid: v.fid,
			iid: v.iid,
			fullpath: fullpath,
			embedded: true,
			title: title,
			size: size
		};
	}, this));
};

_me._ondragover = function() {
	clearTimeout(this.__focusTimeout);
	this.__focusTimeout = setTimeout(function() {
		this._focus();
	}.bind(this), 500);
};

_me._ondragout = function() {
	clearTimeout(this.__focusTimeout);
};

_me._replaceMention = function(_, __, data) {
	var mail = MailAddress.splitEmailsAndNames(this.body.mention_suggest._value());
	this.to._addTag({
		label: MailAddress.createEmail(mail[0].name || mail[0].email, mail[0].email, true),
		tag: MailAddress.createEmail(mail[0].name || mail[0].email, mail[0].email)
	});
	var suffix = data.caret.container.textContent.substr(data.caret.containerOffset).match(/^\w+/) || [];
	this.body._replace(data.caret.container, mkElement('a', {
		href: 'mailto:' + mail[0].email,
		textContent: '@' + (mail[0].name || mail[0].email)
	}, this.body.__doc()), data.caret.containerOffset - data.last_word.length, data.caret.containerOffset + (suffix[0] || '').length);
}

_me._options_toggle = function(toggle){
	if (toggle === void 0) {
		toggle = !hascss(this._getAnchor('options'), 'show');
	}

	if (!toggle) {
		removecss(this._getAnchor('options'), 'show');
		removecss(this._main, 'show_options');
	} else {
		this._smart_toggle(false);
		this._delay_toggle(false);
		addcss(this._main, 'show_options');

		var aInitValues = this._settings();

		if (this.read_confirmation){
			this.read_confirmation._value(aInitValues['read_confirmation']);
		}
		if (this.encrypt) {
			this.encrypt._value(aInitValues['encrypt']);
		}
		if (this.sign) {
			this.sign._value(aInitValues['sign']);
		}

		if (this.reply_to_address){
			this.reply_to_address._value(aInitValues['reply_to_address']);
			this.reply_to_address._placeholder(sPrimaryAccount);
		}

		//connect mode select from richedit
		this.mode_select._fill(this.body.select.__idTable);

		if (!GWOthers.getItemAccess('MAIL_SETTINGS_DEFAULT','html_message') && '0' === GWOthers.getItem('MAIL_SETTINGS_DEFAULT','html_message')) {
			this.mode_select._value('disabled');
		}

		this.mode_select._onchange = function(){
			this.body.select._value(this.mode_select._value());
		}.bind(this);
		this.body.select._onchange = function(){
			this.mode_select._value(this.body.select._value(), true);
		}.bind(this);
		this.body.select._onchange();

		//POZOR
		if (aInitValues['save_sent_message'] == 1)
			this.sent._value(aInitValues['sent'] || GWOthers.getItem('DEFAULT_FOLDERS','sent'));
		else
			this.sent._value('*');

		//this.priority._value(aInitValues['priority']);
		this.spellchecker._value(aInitValues['spellchecker'] || GWOthers.getItem('MAIL_SETTINGS_DEFAULT','spellchecker'));

		// Display extended options
		addcss(this._getAnchor('options'),'show');
		addcss(this.x_btn_options._main,'active');
	}
};

_me._smart_toggle = function(toggle){
	if (toggle === void 0) {
		toggle = !hascss(this._getAnchor('smart'), 'show');
	}

	if (!toggle) {
		removecss(this._getAnchor('smart'),'show');
		removecss(this._main, 'show_options');
	} else {
		this._options_toggle(false);
		this._delay_toggle(false);
		addcss(this._main, 'show_options');
		addcss(this._getAnchor('smart'),'show');
	}
};

_me._onresize = function () {
	if (!this.body.__eFrame) {
		return;
	}
};

_me._delay_toggle = function(toggle) {
	if (toggle === void 0) {
		toggle = !hascss(this._getAnchor('delay'), 'show');
	}

	if (!toggle) {
		removecss(this._getAnchor('delay'),'show');
		removecss(this._main, 'show_options');
		this.x_btn_send._value('COMPOSE::SEND');
		delete(this.__message.sDeferred);
		this._settings('deferred', 0);
	} else {
		// Hide Options
		this._options_toggle(false);
		this._smart_toggle(false);

		addcss(this._main, 'show_options');

		// Set send time with delay from settings if not already changed
		if (!this.__fixed_delay) {

			var d = new IcewarpDate();

			if (this.__delay){
				d.add(this.__delay, 'minutes');
			}
			else{
				if (d.minute()<30){
					d.minute(30);
				}
				else{
					d.minute(0);
					d.add(1, 'hours');
				}
			}

			this.delay_time._value((d.hour()*60+d.minute())*60000,true);
			this.delay_date._value(d.format(IcewarpDate.JULIAN));
		}

		// Display delay details
		addcss(this._getAnchor('delay'), 'show');
		this.x_btn_send._value('COMPOSE::SEND_WITH_DELAY');
		this._settings('deferred', 1);
	}
};

_me._settings = function(key, val){

	if (Is.String(key))
		key = [key];

	if (Is.Defined(val)){
		this.__settings.add('VALUES', key, val);
		return val;
	}
	else
		return this.__settings.get('VALUES', key);
};

_me._layout_minimize = function() {
	addcss(this._main, 'minimize');

	this.__options.max = false;

	var a = [];

	if (GWOthers.getItem('MAIL_SETTINGS_DEFAULT','show_from')!=1)
		a.push(this._main.querySelector('div.from'));

	if (!this.cc._value())
		a.push(this._main.querySelector('div.cc'));
	if (!this.bcc._value())
		a.push(this._main.querySelector('div.bcc'));

	if (this.teamchat && !this.teamchat._value())
		a.push(this._main.querySelector('div.chat'));

	if (this.teamchat_message/* && !this.teamchat_message._value()*/){
		a.push(this._main.querySelector('div.chat_message'));
		removecss(this._main.querySelector('div.toggle.teamchat'),'nodot');
	}

	a.forEach(function(elm){
		addcss(elm, 'extended');
	});
	this._onresize();
};

_me._layout_maximize = function(bFull) {
	removecss(this._main, 'minimize');

	var a = [];

	if (bFull){
		this.__options.max = true;
		a.push(this._main.querySelector('div.from'));
	}

	if (bFull || this.cc._value())
		a.push(this._main.querySelector('div.cc'));
	if (bFull || this.bcc._value())
		a.push(this._main.querySelector('div.bcc'));

	if (this.teamchat && (bFull || this.teamchat._value())){
		a.push(this._main.querySelector('div.chat'));

		if (this.teamchat_message._value() && (bFull)){
			a.push(this._main.querySelector('div.chat_message'));
			addcss(this._main.querySelector('div.toggle.teamchat'), 'nodot');
		}
	}

	a.forEach(function(elm){
		removecss(elm, 'extended');
	});
	this._onresize();
};

_me._setPriority = function (no){
	this._settings('priority', no);
	// if (this.priority){
	// 	this.priority._value(no,true);
//		this.body._getAnchor('priority').className = 'ico icopriority ' + {1:'high',2:'high',3:'normal',4:'low',5:'low'}[no];
//		this.priority._value(no);
	// }
};

/**
 * add uploaded image into richaread in HTML mode
 **/
_me.__richImage = function(aResponse,aFile,idtable,pos){
	if (aFile && aFile.type && aFile.type.toLowerCase().indexOf('image/') === 0 && aResponse.folder && aResponse.id){

		// Add "removed" flag to upload.__idtable to make it invisible on attachment list
		idtable.removed = true;

		//	- set cursor position is not possible for Chrome 12
		try{
			this.body._focus(true);
			if (pos[0]){
				var r = this.body.__eFrame.contentWindow.getSelection().getRangeAt(0);
		 			r.setStart(pos[0],pos[1]);
		 			r.setEnd(pos[0],pos[1]); //+1
	 		}
		}catch(err){ console.log(this._name||false,err)}

		var src = sPrimaryAccountClient + 'server/download.php?'+ buildURL({'dlsess': dataSet.get('main', ['dlsess']), 'class': 'file', 'fullpath': aResponse.folder+'/'+aResponse.id});
		var id = +new Date();
		var sHTML = '<img id="' + id + '" src="' + src + '" border="0">';
		this.body.__exec('html.insert', [sHTML, true]);

		if (this.body.select.__idTable['enabled'])
			this.body.select._value('enabled');

		var image = this.body.__doc().getElementById(id);
		image && image.addEventListener('load', function() {
			this.body.__img_removeEdit();
		}.bind(this));
	}
	if (this.__lastPastedImage === aFile.name) {
		this.body._editor.opts.imagePaste = true;
	}
};

_me.__onDestruct = function() {
	gui._disobeyEvent('chatgptChanged', [this, '__initChatGPT']);
	this.body._disobeyEvent('selectionHighlighted', [this, '__handleSelectionHighlighted']);
	this.body._disobeyEvent('selectionUnhighlighted', [this, '__handleSelectionUnhighlighted']);
	this.__saveTimer && clearTimeout(this.__saveTimer);

	if (this.__removeOnDestruct || this._settings('direct_attach')) {
		this._getChildObjects('attach_list').forEach(function(attachment) {
			gui.__exeEvent('onuploadaborted',{owner: this, file: attachment.__file});
		}, this);
	}

	if (this.__removeOnDestruct) {
		if (this.__message.__id && this.__message.__id[2]) {
			Item.remove(makeIDSFromID(this.__message.__id), true);
		}
	}

	//Unlock TeamChat Item
	if (this.__message.__id_chat && this.__message.__id_chat[2])
		Item.set_lock(this.__message.__id_chat, false, false,'','M');

	this.__message.dispose();

	//Custom devel, external AB
	try{
		if (this.__ext_ab && this.__ext_ab.closed === false)
			this.__ext_ab.close();
	}
	catch(r){ console.log(this._name||false,r);}
};

_me.__autoSave = function() {
	if (this._destructed)
		return;

	if (!this.__bDisableSave && this.__changed())
		this.__save(true);

	this.__saveTimer && clearTimeout(this.__saveTimer);
	this.__saveTimer = setTimeout(function(){
		this.__autoSave && this.__autoSave();
	}.bind(this), this._nAutoSaveInterval);
};

_me.__rememberState = function() {

	if (this.to)
		this.__sSavedTo = this.to._value();
	else
		this.__sSavedSMS = this.sms._value();

	this.__sSavedCc = this.cc._value();
	this.__sSavedBcc = this.bcc._value();
	this.__sSavedSubject = this.subject._value();

	this.__sSavedAtt = [];
	if (this.__message.aAttachments){
		var tmp = this.__message.aAttachments.attachments;
		for (var i in tmp)
			this.__sSavedAtt.push(tmp[i].values || tmp[i]);
	}

	if (this.teamchat){
		this.__sSavedChat = this.teamchat._value();
		this.__sSavedComment = this.teamchat_message._value();
	}

	this.__sSavedBody = this.body._value();
};

_me.__changed = function() {
	try{
		if (this.upload){
			var att = this.upload._getAttachments();
			if (att && (att = att.attachments) && JSON.stringify(att) !== JSON.stringify(this.__sSavedAtt))
				return true;
		}

		if (this._settings('sms')){
			if (this.__sSavedSMS != this.sms._value())
			 	return true;
		}
		else
		if (this.__sSavedTo != this.to._value())
			return true;

		if (this.teamchat){
			if (this.__sSavedChat != this.teamchat._value() || this.__sSavedComment != this.teamchat_message._value())
				return true;
		}

		return this.__sSavedCc != this.cc._value() || this.__sSavedBcc != this.bcc._value() || this.__sSavedSubject != this.subject._value() || this.__sSavedBody != this.body._value();
	}
	catch(e){
		 console.log('compose.__changed', e);
		return !this._destructed;
	}
};

_me.__confirmed = function(bSave) {
	if (bSave)
		this.__save(void 0, [function(bOk) {
			if (bOk) {
				this.__bDisableSave = true;
				this._destruct();
			
				//we need to call confirms in all opened compose windows before logout
				if (this.__logoutOnDestruct && gui.frm_main)
					gui.frm_main.__logout();
			}
		}.bind(this)]);
};

_me.__send = async function(bSave, bKeepAttachments, bAutoSave, bSubject, bSendNow, aResponse) {
	if (this.__bDisableSend) return;
	
	var aSettings = this.__settings.get('VALUES','',true),
		sRCP = '', me = this;

	if (aSettings.sms) {
		this.__skipMissingAttachmentCheck = true;
		sRCP = this.__message.sSMS = this.sms._value();
	} else{
		this.body._unhighlight(true);

		//Check for blank Subject
		if (!bSave && !bSubject && !this.subject._value().trim() && aSettings.check_subject>0){
			var frm = await this._gui._create('subject','frm_confirm','','','','COMPOSE::NEWMAIL','COMPOSE::SUBJECT_EMPTY');
			frm.x_btn_ok._onclick = function (){
				me.__send(false, bKeepAttachments, bAutoSave, true, bSendNow, aResponse);
				this._parent._destruct(true);
			};
			frm.x_btn_cancel._onclick = function(){
				me.subject._focus();
				this._parent._destruct(true);
			};

			return;
		}

		//Personality Alias
		var sAlias = getPrimaryAccountFromAddress();
		if ((GWOthers.getItem('RESTRICTIONS', 'disable_personalities')!=1 || GWOthers.getItem('RESTRICTIONS', 'disable_delegated_aliases') != 1) && this.from)
			if (this.from.__idTable[this.from._value()])
				sAlias = this.from.__idTable[this.from._value()][1];
			else
				sAlias = getPrimaryAccountFromAddress();

		//Check for Certificate (sign)
		if (aSettings.sign == '1'){

			var tmp, bValid = false, aEA = [], sEA = '',
				sAliasMail = MailAddress.splitEmailsAndNames(sAlias)[0].email.toLowerCase(),
				aCert = dataSet.get('storage',['CERTIFICATE','ITEMS']);

			if (Is.Object(aCert))
				for(var i in aCert)
					if (aCert[i].VALUES && aCert[i].VALUES.INFO && aCert[i].VALUES.INFO.VALUE){
						tmp = XMLTools.Str2Arr(aCert[i].VALUES.INFO.VALUE).INFO[0];

						//Extension
						if (tmp.SUBJECTALTNAME && tmp.SUBJECTALTNAME[0].VALUE)
							aEA = MailAddress.splitEmailsAndNames(tmp.SUBJECTALTNAME[0].VALUE);
						else
						//SUBJECT (backup)
						if (tmp.SUBJECT && tmp.SUBJECT[0].EMAILADDRESS && tmp.SUBJECT[0].EMAILADDRESS[0].VALUE)
							aEA = MailAddress.splitEmailsAndNames(tmp.SUBJECT[0].EMAILADDRESS[0].VALUE);
						else
							continue;

						//Check
						for (var j in aEA)
							if (aEA[j].email){
								sEA = aEA[j].email.toLowerCase();

								//Check for validity
								if (sEA == sAliasMail){
									if (tmp.VALIDTO && tmp.VALIDTO[0].VALUE && IcewarpDate.utct(tmp.VALIDTO[0].VALUE)<(new IcewarpDate()))
										continue;

									bValid = true;
									break;
								}
							}
		  			}


		  	if (!bValid){

				if (bSave)
					aSettings.sign = 0;
				else{
					frm = await this._gui._create('cert','frm_confirm','','','','COMPOSE::SIGN','COMPOSE::NOSIGN');
					addcss(frm.x_btn_ok._main,'send');
					frm.x_btn_ok._value('COMPOSE::SEND');
					frm.x_btn_ok._onclick = function (){
						me._settings('sign', 0);
						me.__send(bSave, bKeepAttachments, bAutoSave, bSubject, bSendNow, aResponse);
						this._parent._destruct(true);
					};
					frm.x_btn_cancel._onclick = function(){
						me.subject._focus();
						this._parent._destruct(true);
					};

					return;
				}
		  	}
		}

		aSettings.from = sAlias;
		var value = this.body.select._value();
		this.__message.setHtml((value === 'enabled' || value === 'code') ? true : false);
	}

	if (this.to)
		sRCP += this.__message.sTo = this.to._value();

	sRCP += this.__message.sCc = this.cc._value();
	sRCP += this.__message.sBcc = this.bcc._value();

	if (!bSave && !sRCP.trim().length){
		frm = await this._gui._create('recipient','frm_confirm','','','','COMPOSE::NEWMAIL','COMPOSE::RCP_EMPTY');
		frm.x_btn_ok._onclick = function (){
			if (me._settings('sms'))
				me.sms._focus();
			else
				me.to._focus();
			this._parent._destruct(true);
		};
		addcss(frm.x_btn_ok._main,'color2');
		return;
	}

	if (this.teamchat){
		this.__message.sTeamchat = this.teamchat._value().replace(/^\[(.+)\]$/g,'$1');
		this.__message.sComment = this.teamchat_message._value();
	}

	// If delayed sending
	if (this._settings('deferred') === 1) {
		bSendNow = true;
		var d;

		if (this.__delay && !this.__fixed_delay) {
			d = new IcewarpDate(new Date, {locale: 'en'});
			d.add(this.__delay, 'minutes');
		}
		else{
			var now = new IcewarpDate(new Date(), {locale: 'en'});
			d = IcewarpDate.julian(this.delay_date._value(), this.delay_time._value()/60000, {locale: 'en'});

			if (d.isBefore(now, 'time'))
				d = now;
		}

		this.__message.sDeferred = d.format('rfc2822');
	} else {
		delete this.__message.sDeferred;
	}

	this.__bDisableSave = true;
	this.__bDisableSend = true;

	this.__message.sSubject = this.subject._value();
	if (this.classification) {
		this.__message.sSubject = this.__message.sSubject.replace(/s*\[[UCPRI]\]$/, '');
		this.__message.sSubject += ' [' + this.classification._value()[0].toUpperCase() + ']';
	}

	this.__message.sBody = this._fullbody();

	if (this.__message.sQuote) {
		this.__message.sBody += this.__message.sQuote;
	}

	if (this.upload) {
		var atts = this.upload._getAttachments();
		if (atts) {
			this.__message.aAttachments = {
				attachments: atts.attachments,
				folder: ''
			};
		}
	}

	// Check for Certificate
	/*
	var tmp,
		aCert = dataSet.get('storage',['CERTIFICATE','ITEMS']);

	if (Is.Object(aCert))
		for(var i in aCert)
			if (aCert[i].VALUES && aCert[i].VALUES.INFO && aCert[i].VALUES.INFO.VALUE){
				tmp = XMLTools.Str2Arr(aCert[i].VALUES.INFO.VALUE).INFO[0];
				if (tmp.VALIDTO[0].VALUE && IcewarpDate.utct(tmp.VALIDTO[0].VALUE)>new IcewarpDate()){
					this.__cert_support = true;
					break;
				}
  			}
	*/

	if (bSave) {

		// save settings in custom headers headers
		['spellchecker', 'sent'].forEach(function(setting) {
			if (aSettings[setting] !== void 0 && aSettings[setting] !== 'false') {
				this.__message.oHeaders['x-icewarp-' + setting] = aSettings[setting];
			}
		}, this);

		if ((bSave == 2 && !this.__message.sTeamchat) || !await this.__message.save(bKeepAttachments, [this, '__messageSaved',[bAutoSave, aResponse, bSave == 2]], aSettings, bSave == 2)){
			this.__errorAlert('ALERTS::MESSAGE_NOT_SAVED');
			this.__bDisableSave = false;
			this.__bDisableSend = false;
			return;
		}
		else
		if (!bAutoSave && (this._settings('template') || bSave == 2))
			this.__hide('COMMON::SENDING', true);

	}
	else{
		if (this.__sendAfterUploadNotification) {
			this.__sendAfterUploadNotification.close();
		}
		var errors = (this.to ? this.to._getErrors() : []).concat(this.cc._getErrors(), this.bcc._getErrors());
		if (errors.length) {
			this.__bDisableSend = false;
			return this.__errorAlert('ALERTS::WRONG_RECIPIENTS', '', getLang('ALERTS::WRONG_RECIPIENTS_HELPER', [errors.join(', ')]));
		}

		if (aSettings.read_confirmation == 2){ // Note: this option is not currently used

			this.__bDisableSend = false;

			frm = await this._gui._create('read_confirm','frm_confirm','','',null,'CONFIRMATION::CREATE_READING_CONFIRMATION_TITLE','CONFIRMATION::SEND_READING_CONFIRMATION');

			frm.x_btn_ok._value('COMMON::YES');
			frm.x_btn_ok._onclick = function(){
				frm._destruct(true);

				executeCallbackFunction([me,'__rconfirm',[true]]);
			};
			frm.x_btn_cancel._value('COMMON::NO');
			frm.x_btn_cancel._onclick = function(){
				frm._destruct(true);

				executeCallbackFunction([me,'__rconfirm',[false]]);
			};

			return;
		}

		if (!this.__skipMissingAttachmentCheck && this.__settings.get('VALUES','',true).check_missing_attachments > 0) {
			var body = document.createElement('template');
				body.innerHTML = this.body.__eFrame.contentDocument.body.innerHTML;
			var replyBlock = body.content.querySelector('.iw-reply-block');
			replyBlock && replyBlock.parentNode.removeChild(replyBlock);
			[].forEach.call(body.content.querySelectorAll('.classification, img'), function(el) {
				el.parentElement && el.parentElement.removeChild(el);
			});

			var regexp = new RegExp('\\w*(' + getLang('COMPOSE::MATCH_ATTACHMENT_REGEXP_NO_ACCENTS').split('|').concat('attach').join('|') + ')\\w*', 'i');
			var text_version = createTextVersion(body.innerHTML, {
				linkProcess: function(href, linkText) {
					return linkText || href;
				},
				imgProcess: function() {
					return '';
				}
			});
			try {
				text_version = text_version.normalize("NFD").replace(/[\u0300-\u036f]/g, "");
			} catch {
				//
			}
			var matched_word = text_version.toLowerCase().match(regexp);

			if (matched_word && !((this.__message.aAttachments || {}).attachments || []).length) {
				this.__bDisableSend = false;
				frm = await this._gui._create('missing_attachment', 'frm_confirm', '', '', null, 'CONFIRMATION::MISSING_ATTACHMENT_TITLE', 'CONFIRMATION::MISSING_ATTACHMENT', [text_version.substring(matched_word.index, matched_word.index + matched_word[0].length)]);

				frm.x_btn_ok._value('COMPOSE::SEND_ANYWAYS');
				frm.x_btn_ok._onclick = function() {
					frm._destruct(true);

					this.__skipMissingAttachmentCheck = true;
					this.__send(bSave, bKeepAttachments, bAutoSave, bSubject, bSendNow, aResponse);
				}.bind(this);
				frm.x_btn_cancel._value('COMMON::NO');
				frm.x_btn_cancel._onclick = function() {
					me.__bDisableSave = false;
					me.__bDisableSend = false;
					frm._destruct(true);
				};

				return;
			};
		}

		if (this._settings('save_sent_message') && this._settings('sent')) {
			var savedSentFolders = Cookie.get(['sent_folders']) || [];
			if (~savedSentFolders.indexOf(this._settings('sent'))) {
				savedSentFolders = savedSentFolders.filter(function(folder) {
					return folder !== this._settings('sent');
				}, this);
			}
			savedSentFolders.unshift(this._settings('sent'));
			savedSentFolders = savedSentFolders.slice(0, 3);
			Cookie.set(['sent_folders'], savedSentFolders);
		}

		this.__hide('COMMON::SENDING', true);
		if (bSendNow) {
			this.__skipMissingAttachmentCheck = false;
			// this.__message.save(true, [this, '__messageSaved', [true, [function() {
				this.__message.sBody = this.__message.sBody.replace(/iw-signature/g, this.__message.sDeferred ? 'iw-deferred-signature' : '').replace(/iw-skip/g, '').replace(/iw-sent-via/g, this.__message.sDeferred ? 'iw-deferred-sent-via' : '');
				this.__message.bSMS = this._settings('sms');
				if (await this.__message.send(false, [this, '__messageSent'], aSettings)) {
					this.__bDisableSend = false;
					executeCallbackFunction(aResponse);
				} else {
					this.__bDisableSend = false;
					this.__show();
				}
			// }.bind(this)]]], aSettings);
			return true;
		} else {
			this.__bDisableSend = false;
			this.__skipMissingAttachmentCheck = false;
			//Save to Drafts before Send
			this.__send(true, true, true, false, false, [function(bOK, error, sError){
				if (bOK){

					//Load Attachments from Draft for fw. message
					if (this.__message.aAttachments && this.__message_old && this.__message_old.__id && (this.__message_old.hasAttachments() || this.__message_old.hasEmbeddedAttachments())){

						//Load Draft
						WMItems.list({aid:this.__message.__id[0], fid:this.__message.__id[1], iid:this.__message.__id[2], values:['HAS_ATTACHMENT','HAS_EMBEDDED_ATTACHMENT','ATTACHMENTS','HTML']},'','','',[
							async function(aData){

								//Copy Attachments
								if (aData && (aData = aData[this.__message.__id[0]]) && (aData = aData[this.__message.__id[1]]) && (aData = aData[this.__message.__id[2]])){

									var draft = new OldMessage();
									await draft.init(this.__message.__id, aData);

									//Copy Body for embanded att
									if (draft.hasEmbeddedAttachments())
										this.__message.sBody = draft.getBody();

									//There is conversion!
									if (draft.hasAttachments())
										this.__message.aAttachments.attachments = draft.copyAttachments(this.__message.__id).attachments.map(function(v){
											return v.values;
										});

									this.__sendNotify(aSettings);
								}
								else{
									//Unable to load Draft file
									this.__show();
									this.__errorAlert('', 'MISSING_DRAFT');
								}

							}.bind(this)
						]);
					}
					else
						this.__sendNotify(aSettings);
				}
				else{
					this.__show();
					if (sError === 'attachment_add') {
						gui.notifier._value({type: 'alert', args: {header: 'ALERTS::MESSAGE_NOT_SENT', text_plain: getLang('ALERTS::MAILBOX_QUOTA_LIMIT')}});
					} else {
						this.__errorAlert('', error);
					}
				}

			}.bind(this)]);

			return true;
		}
	}
};

_me.__sendNotify = function(aSettings){
	this.__message.bSMS = this._settings('sms');

	if (gui.notifier){
		gui.notifier._value({
			type: 'send_message',
			css: this._settings('sms') ? 'sms ' : '',
			args: {
				interval: GWOthers.getItem('MAIL_SETTINGS_DEFAULT', 'SEND_NOTIFICATION_TIMEOUT'),
				callback: {
					success: function() {
						this.__message.sBody = this.__message.sBody.replace(/iw-signature/g, '').replace(/iw-skip/g, '').replace(/iw-sent-via/g, '');
						this.__message.send(false, [this, '__messageSent'], aSettings);
					},
					cancel: function() {
						this.__bDisableSend = false;
						this.__show();
						this._focus();
					},
					context: this
				}
			}
		});
	}
	else{
		this.__message.sBody = this.__message.sBody.replace(/iw-signature/g, '').replace(/iw-skip/g, '').replace(/iw-sent-via/g, '');
		this.__message.send(false, [this, '__messageSent'], aSettings);
	}
};

_me.__rconfirm = function(b){
	this._settings('read_confirmation', b?1:0);
	this.__send();
};

_me.__messageSaved = function(bOK, bFirstTime, message, sError, bAutoSave, aResponse, bTeamChat) {
	var sSavedFolder;

	if (this._destructed)
		return;

	if (bOK){
		if ((bOK.attachments || []).length && ((message.aAttachments || {}).attachments || []).length) {
			this.upload.__idtable = [];
			if (this.upload.file) {
				this.upload.file.__value = [];
			}
			this._getChildObjects('attach_list', 'obj_attachment').forEach(function(attachment) {
				attachment._destruct();
			});
			this.upload._setAttachments({attachments: message.aAttachments.attachments.map(function(att) {
				var found = bOK.attachments.filter(function(at) {
					return (at.ATTRIBUTES.UID === att.name || (at.VALUES[0].FULLPATH && at.VALUES[0].FULLPATH[0].VALUE === att.fullpath)) && at.VALUES[0].CLASS;
				})[0];
				if (found) {
					var id = att.id;
					att.fullpath = found.VALUES[0].FULLPATH[0].VALUE;
					var fullpath = Path.split(att.fullpath, true, true);
					att.id = fullpath.iid;
					att.folder = fullpath.fid;
					att.class = found.VALUES[0].CLASS[0].VALUE;
					gui.__exeEvent('onuploadcommit', { id: id, data: { id: att.id, name: att.name } });
				}
				return {
					values: att
				};
			})});
		}
		this.__setAutoreopenArgs({
			context: 'OldMessage',
			fun: ['edit'],
			args: [message.__id]
		}, true);
		if(bFirstTime && dataSet.get('folders', [message.__id[0], message.__id[1],'DEFAULT']) === 'D') {
			var count = dataSet.get('folders', [message.__id[0], message.__id[1], 'COUNT']) || 0;
			dataSet.add('folders', [message.__id[0], message.__id[1],'COUNT'], ++count);
		}
		if (!bAutoSave){
			if (gui.notifier) {
				sSavedFolder = (Object.prototype.hasOwnProperty.call(message, 'template') && true === message.template) ? 'templates' : 'drafts';
				if (bTeamChat) {
					gui.notifier._value({type: 'message_sent_tch', args: [WMFolders.getFolderName({aid: sPrimaryAccount, fid: bOK.TEAMCHAT})]});
				} else {
					gui.notifier._value({type: 'message_saved', args: [GWOthers.getItem('DEFAULT_FOLDERS',sSavedFolder).replace(sPrimaryAccount + '/', '')]});
					
				}
			}

			//Save template
			if (this._settings('template') || bTeamChat){
				this._destruct();
				return true;
			}
		}

		this.__rememberState();

		//Lock TeamChat Item
		if (!this.__locked && message.__id_chat && message.__id_chat[2]){
			Item.set_lock(this.__message.__id_chat, true, false, [function(){
				this.__locked = 1;
			}.bind(this)], 'M');
		}

		if (aResponse)
			executeCallbackFunction(aResponse, true);
	} else {
		this.__errorAlert('ALERTS::MESSAGE_NOT_SAVED', message, sError);
		if (aResponse) {
			executeCallbackFunction(aResponse, false, sError, message);
		}
	}

	if (!bAutoSave && (this._settings('template') || bTeamChat))
		this.__show();

	this.__bDisableSave = false;
	this.__bDisableSend = false;
};

_me.__messageSent = function(aOut, sUID, sError)
{
	if (this._destructed)
		return;

	if (sUID == 'imap_internal' || sUID == 'save_certificate_missing'){
		if (sUID == 'save_certificate_missing')
			sError = getLang('ALERTS::SAVE_CERTIFICATE_MISSING');

		gui.notifier._value({type: 'alert', args: {header: 'ALERTS::MESSAGE_NOT_SAVED', text_plain: sError}});

		aOut = true;
	}

	if (aOut){
		this.__removeOnDestruct = false; //Message is removed by NewMessage.onSentCallback

		this._destruct(true);

		if(!sError && !dataSet.get('folders', Path.split(GWOthers.getItem('DEFAULT_FOLDERS', 'sent')))) {
			// sent folder missing in folder tree
			gui.frm_main._getNew();
		}

		if (Is.Object(aOut)){
			if (sPrimaryAccountDELIVERY && this._settings('delivery') == 1)
			this._gui._create('frm_delivery', 'frm_delivery', '','','',aOut);
			/*
			else
			//Increment SMS count
			if (aOut.SMS_SEND)
				dataSet.add('main',['SMS_SENT'],aOut.SMS_SEND);
			*/
		}

		this.__exeEvent('onsend',true,{"owner":this});
	}
	else {
		this.__bDisableSave = false;
		this.__bDisableSend = false;

		this.__show();

		this.__errorAlert('',sUID,sError);
	}

	return false;
};

_me._onPopupClose = function(bOK, aAddresses){
	if (bOK){
debugger;
		if (aAddresses['sms'])
			this.sms._value(aAddresses['sms'].join(', '));
		else{
			if (this.to)
				this.to._value(aAddresses['to'].join(', '));

			if(aAddresses['cc'].length || aAddresses['bcc'].length) {

				var elm;

				// Add copy recipients
				this.cc._value(aAddresses['cc'].join(', '));
				if (aAddresses['cc'].length && (elm = this._main.querySelector('.extended.cc')))
					removecss(elm,'extended');

				this.bcc._value(aAddresses['bcc'].join(', '));
				if (aAddresses['bcc'].length && (elm = this._main.querySelector('.extended.bcc')))
					removecss(elm,'extended');

				this.cc._tabIndex('',1);
				this.bcc._tabIndex('',2);

				if ((elm = this._main.querySelector('.extended.subject')))
					removecss(elm,'extended');
				this.subject._focus(true);
			}
		}
	}

	this.__bContactsOpened = false;
};

//For Custom devel
_me.__contacts = function(aData){
	if (Is.Object(aData)){
		if (this.sms)
			this.sms._value(aData.sms);
		if (this.to)
			this.to._value(aData.to);
		if (this.cc)
			this.cc._value(aData.cc);
		if (this.bcc)
			this.bcc._value(aData.bcc);
	}
	else{
		var out = {};
		if (this.sms)
			out.sms = this.sms._value();
		if (this.to)
			out.to = this.to._value();
		if (this.cc)
			out.cc = this.cc._value();
		if (this.bcc)
			out.bcc = this.bcc._value();

		return out;
	}
};

_me.__errorAlert = async function (sTitle,sUID,sError){
	var sErrOut;
	if (sUID){
    	sUID = sUID.toUpperCase();

		switch (sUID) {
		case 'SMTP_RECIPIENTS_FAILED':
			var aError = sError.unentityify().unentityify().split('<br/>');
			var oError = {};
			for (var i in aError) {
				var match = aError[i].split('\n')[0].match(/(?:.*?\s)?(?:<(.*?)>\s)?(.*)/);
				if (match && match.length > 1) {
					oError[match[1]] = match[2];
				}
			}
			var errorRecipients = Object.keys(oError);
			if (errorRecipients.length) {
				for (i in errorRecipients) {
					gui.notifier._value({type: 'alert', args: { header_plain: errorRecipients[i], text_plain: oError[errorRecipients[i]] }});
				}

				var frm = await this._gui._create('subject', 'frm_confirm', '', '', '', 'ERROR::REMOVE_INVALID_RECIPIENTS', 'ERROR::REMOVE_INVALID_RECIPIENTS_HELPER');
				frm.x_btn_ok._onclick = function () {
					[this.to, this.cc, this.bcc].map(function(input) {
						input._value(MailAddress.splitEmailsAndNames(input._value()).filter(function(recipient) {
							return !~errorRecipients.indexOf(recipient.email);
						}).map(function(recipient) {
							return MailAddress.createEmail(recipient.name, recipient.email);
						}).join(','));
					});
					frm._destruct(true);
				}.bind(this);
				frm.x_btn_cancel._onclick = function() {
					frm._destruct(true);
				};

				return;
			}
		case 'FOLDER_INSUFFICIEND_RIGHTS':
		case 'DEFAULT_FOLDER_MISSING':
		case 'DISTRIBUTION_LIST_INVALID_ID':
		case 'SMTP_FROM_FAILED':
		case 'SMTP_DATA_NOT_ACCEPTED':
		case 'PERSONAL_CERTIFICATE':
		case 'NO_RECIPIENT_CERTIFICATE':
		case 'RECIPIENT_CERTIFICATE_EXPIRED':
		case 'IMAP_MESSAGE_CREATE':
		case 'IMAP_QUOTA_EXCEEDED':
			sErrOut = getLang('ALERTS::'+sUID);
			break;
		case 'ATTACHMENT_ADD':
			var parts = (sError || '').split('|');
			if (parts[0] === 'Virus') {
				sError = '';
				sErrOut = getLang('ERROR::ATTACHMENT_VIRUS', [parts[2]]);
				break;
			}
			return;
		}
	}

	if (sError)
		sErrOut = (sErrOut?sErrOut + "\n":'') + sError.unescapeHTML();

	if (!sErrOut)
		sErrOut = getLang('ALERTS::MAILINGFAILED')+(sUID?' ('+sUID+')':'');

	gui.notifier._value({type: 'alert', args: {header: sTitle || 'ALERTS::MESSAGE_NOT_SENT', text_plain: sErrOut}});
};

_me.__save = function(bAutoSave, aHandler) {
	if (!this._destructed){
		if (!bAutoSave)
			this.__removeOnDestruct = false;

		if (!this.__bDisableSave && this.__changed())
			this.__send(true, true, bAutoSave, false, false, aHandler);

		return true;
	}
};

_me._ondock = function() {
	return {css: this._settings('sms')?'sms':''};
};

_me._fullbody = function(v, callback){
	var isSms = this._settings('sms');
	//Prefix all <style> elements
	if (Is.Defined(v)) {
		if (isSms) {
			this.body._value(v.removeTags());
			return;
		}
		v = DOMPurify.sanitize(v);
		this.body._value(v.replace(/<span[^>]*?><\/span>/gi, '').replace(/<p[^>]*?>(&nbsp;)?<\/p>/gi, '').replace(/windowtext/g, 'black'), false, false, function() {
			//hide reply headers
			[].forEach.call(this.body.__doc().querySelectorAll('span[iw-to="'+sPrimaryAccount+'"]'), function(elm){
				elm.style.display = 'none';
			});

			this.__applyClassification();

			//prefix styles
			this.__csstool.prefix('.iw-reply-block', this.body.__doc(), {tagOnly:true, removeIW:true, skip: 'iw-skip'});

			if (this.body.__doc().defaultView.IW_NM) {
				this.body.__doc().defaultView.IW_NM.activate();
			}

			callback && callback();
			this.__updateMaxSize();
		}.bind(this));
	}
	else if (isSms) {
		return this.body._value();
	}
	//copy link styles into content style
	else {
		if (this.body.__doc().defaultView.IW_NM) {
			this.body.__doc().defaultView.IW_NM.reset();
		}

		var	html = this.body._value(null, false, true);
		
		if (this.body.__doc().defaultView.IW_NM) {
			this.body.__doc().defaultView.IW_NM.activate();
		}

		// if (this.body.select._value() == 'disabled')
		// 	html = html.replace(/\n/g, '<br>');

		if (this.__message.isHtml())
			html = DOMPurify.sanitize(html);

		//prefix CSS
		var	div = document.createElement('template'),
			newStyle = mkElement('style', {type:"text/css"});
		div.innerHTML = html;

		this.__csstool.copy(this.body.__doc(), newStyle, {useIW:true, skipIW:true});
		div.content.insertBefore(newStyle, div.content.firstChild || null);

		// classification
		var colors = {"unclassified": "", "classified": "", "public": "", "red": ""};
		try {
			colors = JSON.parse(GWOthers.getItem('MAIL_SETTINGS_DEFAULT', 'classification_colors'));
		} catch {}
		[].forEach.call(div.content.querySelectorAll(".classification"), function(classification) {
			classification.innerHTML = '';
			classification.appendChild(mkElement('b', {
				textContent: getLang('COMPOSE::' + classification.getAttribute('value')).toUpperCase(),
				style: {
					color: colors[classification.getAttribute('value')]
				}
			}));
		});

		return div.innerHTML;
	}
};

_me.__addClassification = function(range) {
	var rel = +new Date();
	range = range || this.body.__doc().defaultView.getSelection().getRangeAt(0);
	var container = range.commonAncestorContainer;
	var begin = range.startContainer;
	var end = range.endContainer;
	if (!begin || !end) {
		return;
	}

	if (begin === end && begin === container && begin === this.body.__doc().body) {
		begin = end = container.childNodes[range.startOffset];
	} else {
		while (!~['DIV', 'TABLE', 'BODY'].indexOf(container.tagName) && container.parentElement) {
			container = container.parentElement;
		}
		while (begin !== container && begin.parentElement !== container) {
			begin = begin.parentElement;
		}
		if (begin.nodeType === 3) {
			begin = begin.parentElement;
		}
		while (end !== container && end.parentElement !== container) {
			end = end.parentElement;
		}
		if (end.nodeType === 3) {
			end = end.parentElement;
		}
	}

	begin.insertAdjacentElement('beforebegin', mkElement('div', {
		className: 'classification',
		rel: rel
	}));
	end.insertAdjacentElement('afterend', mkElement('div', {
		className: 'classification end',
		rel: rel
	}));

	range.collapse();

	this.__applyClassification();
};

_me.__applyClassification = function() {
	var doc = this.body.__doc();
	var classes = {"unclassified": "", "classified": "", "public": "", "red": ""};
	try {
		classes = JSON.parse(GWOthers.getItem('MAIL_SETTINGS_DEFAULT', 'classification_colors'));
	} catch {}

	[].forEach.call(doc.querySelectorAll('.classification'), function(classification) {
		classification.setAttribute('contenteditable', 'false');
		var end = classification.classList.contains('end');
		var rel = classification.getAttribute('rel');
		var classification_label = (end ? getLang('COMPOSE::CLASSIFICATION_END') : getLang('COMPOSE::CLASSIFICATION')) + ': ';
		var select = mkElement('select', {
			rel: rel,
			disabled: end ? 'disabled' : void 0,
			className: end ? 'end': '',
			onchange: function() {
				this.parentElement.setAttribute('value', this.value);
				this.style.color = classes[this.value];
				var select = doc.querySelector('select.end[rel="' + this.getAttribute('rel') + '"]');
				if (select !== this) {
					select.value = this.value;
					select.parentElement.setAttribute('value', this.value);
					select.style.color = classes[this.value];
				}
			}
		}, false, Object.keys(classes).map(function(classification) {
			return mkElement('option', {
				value: classification,
				style: {
					color: classes[classification]
				},
				textContent: classification_label + getLang('COMPOSE::' + classification)
			});
		}));
		classification.innerHTML = '';
		classification.appendChild(select);
		if (!end && rel !== 'main') {
			classification.appendChild(mkElement('div', {
				rel: rel,
				textContent: '🗙',
				title: getLang('COMPOSE::REMOVE_CLASSIFICATION'),
				className: 'remove_classification',
				onclick: function() {
					[].forEach.call(doc.querySelectorAll('.classification[rel="' + this.getAttribute('rel') + '"]'), function(classification) {
						classification.parentElement.removeChild(classification);
					});
				}
			}));
		}
		select.value = classification.getAttribute('value') || 'unclassified';
	});
	[].forEach.call(doc.querySelectorAll('.classification select'), function(select) {
		select.onchange();
	});
};

_me.__autoreopen = function(data) {
	for(var i in data)
		this[i] && this[i]._value && this[i]._value(data[i]);
};

_me.__storeAutoreopenData = function(bUnload) {
	var data = {};
	if (bUnload) {
		this.body._unhighlight(true);
	}
	this._getChildObjects().forEach(function(child) {
		if (child._value && !~child._name.indexOf('x_')) {
			data[child._name] = child._value();
		}
	});
	return data;
};

_me.__addItems = function(files) {
	if (files.some(function(file) {
		return !WMFolders.getRights(file, 'write');
	})) {
		this._settings('direct_attach', 1);
	}
	this.upload._addItem(files);
};

_me.__onuploadaborted = function(data) {
	var me = this;
	[].forEach.call(this._getChildObjects('attach_list'), function(attachment) {
		if (attachment.__file === data.file) {
			attachment._destruct();
			attachment.__file.removed = true;
			me.upload._remove(data.file.id);
		}
	});

	this.__updateMaxSize();

	if (!this._getChildObjects('attach_list').length) {
		removecss(this._main,'att_list');
	}
	this._onresize();
};

_me.__updateMaxSize = async function() {
	if (!dataSet.get('main',['message_size']) || this._destructed || this.quota === false) {
		return;
	}
	this.quota = this.quota || false;

	[].forEach.call(this.body.__doc().querySelectorAll('img'), function(img) {
		if (img.src.indexOf('http') !== 0) {
			return; // skip non http(s) images
		}
		if (this.__images[img.src] === void 0) {
			this.__images[img.src] = -1;
		}
		if (this.__images[img.src] === -1) {
			this.__images[img.src] = 0;
			var xhr = new XMLHttpRequest();
			xhr.open('GET', img.src);
			xhr.send();
			xhr.onreadystatechange = () => {
				if (xhr.readyState === xhr.HEADERS_RECEIVED) {
					this.__images[img.src] = +xhr.getResponseHeader("Content-Length") || 0;
					this.__updateMaxSize();
				}
			};
		}
	}.bind(this));

	this.quota = this.quota || await this._create('quota', 'obj_progress', 'quota');

	var q = dataSet.get('main',['message_size']) * 1024;
	this.quota._range(q);

	var isize = this.upload.file._value().reduce(function(prev, curr) {
		return prev + (curr.removed ? 0 : (+curr.size ||  0));
	}, 0) + [].reduce.call(this.body.__doc().querySelectorAll('img'), function(prev, curr) {
		return prev + (this.__images[curr.src] || 0);
	}.bind(this), 0);
	var u = isize * 1.333 + (this.body._value().length + (this.__message.sQuote || '').length);

	this.quota._value(u);

	var percent = roundTo(u / q * 100, 1);
	this._getAnchor('maxsize').classList.remove('alert');
	this._getAnchor('maxsize').classList.remove('warning');
	if (percent >= 90) {
		this._getAnchor('maxsize').classList.add('alert');
	} else if (percent >= 70) {
		this._getAnchor('maxsize').classList.add('warning');
	}

	this._getAnchor('quota_text').textContent = getLang('USAGE::LABEL', [parseFileSize(u), parseFileSize(q)]);
};

_me.__disobeyEvents = function() {
	gui._disobeyEvent('onuploadaborted', [this, '__onuploadaborted']);
};

_me.__GSM0338_To_Unicode_Charset = [
	0x40, 0x24, 0xA5, 0xE8, 0xE9, 0xF9, 0xEC, 0xF2, 0xE7, 0x0A, 0xD8, 0xF8, 0x0D, 0xC5, 0xE5, 0x394,
	0x5F, 0x3A6, 0x393, 0x39B, 0x3A9, 0x3A0, 0x3A8, 0x3A3, 0x398, 0x39E, 0x1B, 0xC6, 0xE6, 0xDF, 0xC9,
	0x20, 0x21, 0x22, 0x23, 0xA4, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F,
	0xA1, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5A, 0xC4, 0xD6, 0xD1, 0xDC, 0xA7,
	0xBF, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F,
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7A, 0xE4, 0xF6, 0xF1, 0xFC, 0xE0
];

_me.__csstool = {
	//rx: /(^|[\s,])(body)([\s,]|$)/g,

	st: function(str, prefix){
		return str.split(',').map(function(v){
			v = v.trim();
			if (v.toLowerCase() == 'body')
				return prefix;
			else
				return prefix + ' ' + v;
		}).join(',');
	},

	// Prefix styleSheets in document
	// aOpt: 	tagOnly		- apply only on <style> tag in body
	//			removeIW	- removes styles with iw-style attribute
	prefix: function (prefix, target_document, aOpt) {
		var doc = target_document || document,
			arr = [].slice.call(doc.styleSheets),
			me = this;
		aOpt = aOpt || {}

		for (var style, i = arr.length-1; i>=0; i--){
			style = arr[i];

			//apply only on <style> tags inside of message
			if ((!aOpt.tagOnly || !style.href) && style.cssRules && style.ownerNode && (!aOpt.skip || !style.ownerNode.classList.contains(aOpt.skip))){

				//Remove iw-style
				if (aOpt.removeIW && style.ownerNode.hasAttribute('iwstyle'))
					style.ownerNode.parentNode.removeChild(style.ownerNode);
				else
				if (!style.ownerNode.hasAttribute('iwfix') && !style.ownerNode.hasAttribute('data-fr-style'))
					//change link.rules
					if (style.href){
						[].slice.call(style.cssRules).forEach(function (rule, i) {
							if (rule.type === 1)
								try{
									style.insertRule(me.st(rule.selectorText, prefix) + rule.cssText.substr(rule.selectorText.length), i);
									style.deleteRule(i + 1);
								}
								catch {
									//  console.log('csstool.prefix.link', e);
								}
						});

						style.setAttribute('iwfix', prefix);
					}
					//hack, we need to actually change html inside of <style>
					else{
						var elm = mkElement('style', {type:"text/css", iwfix:prefix}, doc);
						[].slice.call(style.cssRules).forEach(function (rule) {
							try{
								if (rule.type === 1)
									elm.appendChild(doc.createTextNode(me.st(rule.selectorText, prefix) + rule.cssText.substr(rule.selectorText.length) + "\r\n"));
								else
									elm.appendChild(doc.createTextNode(rule.cssText + "\r\n"));
							}
							catch{
								//  console.log('csstool.prefix.style', e);
							}
						});
						style.ownerNode.parentNode.replaceChild(elm, style.ownerNode);
					}
			}
		}
	},

	// Copy rules from <link> to <style>
	// aOpt 	useIW	- use iw-style in <style> element
	//			skipIW	- skip <links> with iw-style attribute
	copy: function (target_document, newStyle, aOpt) {
		var doc = target_document || document;
		aOpt = aOpt || {}

		if (doc.styleSheets){

			newStyle = newStyle || mkElement('style', {type:"text/css"}, doc);

			if (aOpt.useIW)
				newStyle.setAttribute('iwstyle','iwstyle');

			doc.body.insertBefore(newStyle, doc.body.firstChild || null);

			try{
				[].slice.call(doc.styleSheets).forEach(function (style) {
					if (style && style.cssRules && style.href && style.ownerNode && (!aOpt.skipIW/* || !style.ownerNode.hasAttribute('iwstyle')*/))
						style.cssRules && [].slice.call(style.cssRules).forEach(function (rule) {
							//hack, we need to actually change html inside of <style>
							if (rule.cssText)
								newStyle.appendChild(doc.createTextNode(rule.cssText + "\r\n"));

							//can not be used, <style> tag seems to be empty for innerHTML
							//newStyle.sheet.insertRule(rule.cssText);
						});
				});
			}
			catch{
				//  console.log('csstool.copy', e);
			}

		}
	}
};

_me._onbeforedetach = function(callback) {
	this.body._onbeforedetach(function() {
		try {
			this.chatgpt.slider.menu.text.input.__initEditor('textarea');
		} catch {
			//
		}
		try {
			this.chatgpt.slider.conversation.thread.text.input.__initEditor('textarea');
		} catch {
			//
		}
		callback();
	}.bind(this));
};