_me = frm_comment.prototype;
function frm_comment(){};

/**
 *
 *
 * @param {object} aData		path or whole object injection
 * @param {handler} aHandler	loading success handler
 */
_me.__constructor = async function(aData, aHandler, aOptions){

	this.__aHandler = aHandler;
	this.__aOptions = Object.assign({
		autofocus: true
	}, aOptions || {});

	//original item data injected
	if (aData.EVNCOMEVNID){
		aData = {aid:aData.aid, fid:aData.fid, iid:WMItems.__clientID(aData.EVNCOMEVNID)};
	}

	if (aData.EVNCLASS){
		aData = clone(aData, true);
		delete aData.COMMENT;
		for (var i in aData) {
			if (!i.indexOf('LAST')) {
				delete aData[i];
			}
		}
		this.__init(aData);
		aHandler && executeCallbackFunction(aHandler, {action: 'load', data:aData});
	} else if (aData.iid) {
		WMItems.list({aid:aData.aid, fid:aData.fid, iid:aData.iid},'','','',[function(aResponse){
			// load item & it's comments
			if (aResponse && (aResponse = aResponse[aData.aid]) && (aResponse = aResponse[aData.fid]) && (aResponse = aResponse[aData.iid])){
				aResponse = Object.assign(aResponse, aData);
				if (aResponse.EVN_CREATED) {
					this.__init(aResponse);
					aHandler && executeCallbackFunction(aHandler, {action: 'load', data:aResponse});
				} else {
					aHandler && executeCallbackFunction(aHandler, {action: 'delete'});
					this._destruct();
				}
			}
			// item doesn't exist
			else{
				aHandler && executeCallbackFunction(aHandler, {action: 'delete'});
				this._destruct();
			}

		}.bind(this)]);
	} else {
		aHandler && executeCallbackFunction(aHandler, {action: 'delete'});
		this._destruct();
	}

	gui.frm_main.dnd.registr_drop(this, ['item']);
};

_me.__init = async function(aData){

	if (this._destructed) {
		return;
	}
	this.__aData = aData;
	var folder = {
		aid: this.__aData.aid,
		fid: this.__aData.fid,
		iid: this.__aData.iid,
		cid: WMItems.__serverID(this.__aData.iid)
	};

	//Item Types
	// var aTypes = obj_groupchat_item.__comTypes;
	await this._create('list', 'obj_groupchat', 'chat', 'private');
	this.list._placeholder('THREADS::SPLASH_HEADER');
	this.list.__options.rdock = true;
	this.list.__options.comments = false;
	this.list.__options.thread = true;
	this.list._obeyEvent('onnotify', [this, '__onnotify']);
	this.list._obeyEvent('onlayoutchange', [this, '__onlayout']);
	this.list.__layoutResize();
	this.list._getAnchor('refresh').onclick = function() {
		this.list._scroll(0);
	}.bind(this);

	var response = {};
	response[folder.aid] = {};
	response[folder.aid][folder.fid + '/' + folder.cid] = {};
	response[folder.aid][folder.fid + '/' + folder.cid][this.__aData.iid] = clone(aData, true);
	response[folder.aid][folder.fid + '/' + folder.cid][this.__aData.iid].fid = folder.fid + '/' + folder.cid;
	this.list.__aRequestData.folder = folder;
	await this.list._response(response, false, false, false, true);

	this.list.__originalItem = aData;
	this.list.__aRequestData.oldest = 0;
	this.list.__aRequestData.folder = {};
	this.list._serverSort(folder, true);

	this.list._onclick = async function(e, elm){
		//Send mail
		if (hascss(elm, 'mailto')){
			var email = elm.getAttribute('rel');
			if (email)
				Item.sendEmailTo(email);
		}
		else
		if (elm.tagName == 'SPAN'){
			var addr, id;
			if (hascss(elm, 'mention') && (id = elm.getAttribute('rel'))){

				addr = MailAddress.splitEmailsAndNames(id);
				if ((addr = addr[0]) && addr.email){
					this._parent.text.input._addMention(addr);
				}
			}
			else
			if (hascss(elm, 'private_msg')){
				var sMail = elm.getAttribute('rel');
				if (sMail){
					addr = MailAddress.splitEmailsAndNames(sMail.urlDecode());
					if (addr && addr[0]){

						this.__options.autoscroll = false;

						var pos = getSize(elm),
							cmenu = await gui._create('cmenu', 'obj_context_link','','',addr[0].name, addr[0].email);
							cmenu._place(pos.x+pos.w,pos.y+(pos.h/2));
							cmenu._onclose = function(){
								this.__options.autoscroll = true;
								return true;
							}.bind(this);

						e.stopPropagation();
					}
				}
			}
		}
		else
		if (elm.tagName == 'A' && elm.protocol === 'mailto:'){
			e.preventDefault();
			NewMessage.compose({to:elm.pathname});
			return false;
		}
	};

	this.list._oncontextEvent = function(evn){
		switch(evn.type){
			case 'quote':
				this.text.input._value('"' + evn.value + '" ');
				this.text.input._focus();
				break;
			case 'event':
				frm_main_chat.prototype.__global_context_menu.call(this, evn.e, evn.elm, evn.obj);
		}
	}.bind(this);

	// PUSH Notifications
	// if (aTypes[aData.EVNCLASS])
	// 	this.list.__aData[aData.iid] = {obj:this.item};

	if (WMFolders.getRights({aid: this.__aData.aid, fid: this.__aData.fid}).write) {

		//chat input
		this.__input_menu_handlers = {
			word:[function(){
				WMChat.addDocument({aid:this.__aData.aid, fid:this.__aData.fid}, {type:'F', doc:'.docx', comevnid:WMItems.__serverID(this.__aData.iid)}, function() {}, this._gui);
			}.bind(this)],
			excel:[function(){
				WMChat.addDocument({aid:this.__aData.aid, fid:this.__aData.fid}, {type:'F', doc:'.xlsx', comevnid:WMItems.__serverID(this.__aData.iid)}, function() {}, this._gui);
			}.bind(this)],
			ppoint:[function(){
				WMChat.addDocument({aid:this.__aData.aid, fid:this.__aData.fid}, {type:'F', doc:'.pptx', comevnid:WMItems.__serverID(this.__aData.iid)}, function() {}, this._gui);
			}.bind(this)],
			// note:[function(){
			// 	WMChat.addDocument({aid:this.__aData.aid, fid:this.__aData.fid}, {type:'N', comevnid:WMItems.__serverID(this.__aData.iid)});
			// }.bind(this)],
			code:[this,'_code'],
			attach:[this,'_attachFile'],
			event:[
				function(){
					WMChat.addEvent({aid:this.__aData.aid, fid:this.__aData.fid}, {comevnid:WMItems.__serverID(this.__aData.iid)}, function() {}, this._gui);
				}.bind(this)
			],
			conference:(sPrimaryAccountGUEST  || (window.TeamChatAPI && TeamChatAPI.teamChatOnly())) ? void 0 : [
				function(){
					WMChat.addEvent({aid:this.__aData.aid, fid:this.__aData.fid}, {conference:true, comevnid:WMItems.__serverID(this.__aData.iid)}, function() {}, this._gui);
				}.bind(this)
			],
			email:(sPrimaryAccountGUEST  || (window.TeamChatAPI && TeamChatAPI.teamChatOnly())) ? void 0 : [
				function(){
					WMChat.addEmail({aid:this.__aData.aid, fid:this.__aData.fid}, {comevnid:WMItems.__serverID(this.__aData.iid)}, this._gui);
				}.bind(this)
			]
		};

		await this._create("text", "obj_chat_input", "text", "", {
			parseurl: true,
			block:true,
			handlers: this.__input_menu_handlers,
			memory:{
				set:[function(val){
					dataSet.add('teamchat', [this.__aData.fid, this.__aData.iid, 'input'], val, true);
				}.bind(this)],
				get:[function(){
					return dataSet.get('teamchat', [this.__aData.fid, this.__aData.iid, 'input']) || '';
				}.bind(this)]
			},
			upload: true,
			upload_enabled: true,
			uploadInstanceId: this.__aOptions.uploadInstanceId,
			alias: this.__aData.fid + '_' + this.__aData.iid,
			label: function() {
				return WMFolders.getFolderName(this.__aData);
			}.bind(this)
		});

		this.text._folder(this.__aData);
		this.text.input._placeholder(getLang('IM::COMMENT_PH'));

		this.text._onsubmit = function (v, arg, aPrivate, callback) {
			if (v.length || (arg && arg.url) || this.text._upload._getAttachments().length) {
				arg = arg || {};
				arg.comevnid = WMItems.__serverID(this.__aData.iid);
				this._message(v, arg, callback);
			}
		}.bind(this);

		this.text.input._obeyEvent('onkeyup', [this, '__keyupHandler']);
		this.__aOptions.autofocus && this.text._focus();
		this._main.classList.remove('readonly');
	} else {
		this._main.classList.add('readonly');
	}

	//Room status
	gui._obeyEvent('visibilitychange', [this, '__pushBackgroundStatus']);
	this.__pushBackgroundStatus();
	this._add_destructor('__pushOfflineStatus');
};

_me._ondrop = function(v) {
	if (v.type == 'item'){
		this.__addItems(v.value.map(function(v) {
			return {
				aid: v.aid,
				fid: v.fid,
				iid: v.iid,
				title: v.name,
				size: v.size
			}
		}));
	}
};

_me.__pushOfflineStatus = function(){
	gui._disobeyEvent('visibilitychange', [this, '__pushBackgroundStatus']);
	WMChat.setRoomStatus(this.list, {aid:this.__aData.aid, fid:this.__aData.fid}, 'OFFLINE');
};
_me.__pushBackgroundStatus = function(){
	WMChat.setRoomStatus(this.list, {aid:this.__aData.aid, fid:this.__aData.fid}, gui._isVisible() ? 'ONLINE' : 'BACKGROUND');
};
_me.__keyupHandler = function(){
	if (this.__statusTimer)
		clearTimeout(this.__statusTimer);
	else
		WMChat.setRoomStatus(this.list, {aid:this.__aData.aid, fid:this.__aData.fid}, 'TYPING');

	this.__statusTimer = setTimeout(function(){
		if (!this._destructed)
			this.__pushBackgroundStatus();

		delete this.__statusTimer;
	}.bind(this), 2000);
};


_me.__onnotify = function(e, aData){
	if (aData && aData.data.ITEM == WMItems.__serverID(this.__aData.iid)){
		var sAction = aData.data.ACTION;

		switch(aData.data.ACTION){
			case 'delete':
				this._destruct();
				break;

			case 'follow':
			case 'unfollow':
				break;

			default:
				return;
		}

		this.__aHandler && executeCallbackFunction(this.__aHandler, {action:sAction, data:this.__aData, evnData: aData.data});
	}
};

_me.__onlayout = function(e, aData){
	if (aData)
		this._main.setAttribute('iw-layout', aData.value);
};
//// ITEM METHODS ////
_me._code = function () {
	gui._create('insert_code', 'frm_insert_code', '', '', [function (sBody) {
		if (this.text._value()) {
			this.text._value(this.text._value() + '\n' + sBody);
		} else {
			this._message(sBody, {
				comevnid: WMItems.__serverID(this.__aData.iid)
			});
		}
	}.bind(this)]);
};

_me._attachFile = function(){
	if (this.__aData.aid && this.__aData.fid){
		// In case "Attach from webclient" is disabled, just show browser upload dialog
		if ('1' === GWOthers.getItem('RESTRICTIONS', 'disable_attach_item'))
			this.text._upload._click();
		else
			gui._create('insert_item', 'frm_insert_item', '', 'frm_insert_item_nobottomdiv', [this, '__addItems'], this.__aData.aid, this.__aData.fid, '', this.text._upload, false, ['M', 'F', 'I', 'X']);
	}
};

_me.__addItems = function(files) {
	this.text._upload._addFiles(files.map(function (file) {
		return {
			class: 'item',
			aid: file.aid,
			fid: file.fid,
			iid: file.iid,
			name: file.title,
			size: file.size,
			fullpath: file.fullpath
		};
	}));
};

_me._message = async function(sBody, aArgs, callback) {
	if (this.__aData.aid && this.__aData.fid){
		if(sBody[0] === '/') {
			var me = this;
			var confirm = await this._gui._create('confirm', 'frm_confirm', '', '', [function() {
				me.__message(sBody, aArgs);
				callback && callback();
			}], 'CHAT::COMMAND_DETECTED', 'CHAT::COMMAND_DETECTED_HELPER', false, [function() {
				me.__message('\\' + sBody, aArgs);
				callback && callback();
			}]);
			confirm.x_btn_ok._value('CHAT::SEND_AS_COMMAND');
			confirm.x_btn_cancel._value('CHAT::SEND_AS_TEXT');
			confirm.x_btn_cancel._main.classList.add('color4');

			await confirm._create('x_btn_close', 'obj_button', 'footer', 'cancel noborder');
			confirm.x_btn_close._tabIndex();
			confirm.x_btn_close._value('FORM_BUTTONS::CANCEL');
			confirm.x_btn_close._onclick = function() {
				confirm._destruct();
			};
		} else {
			this.__message(sBody, aArgs);
			callback && callback();
		}
	}
};

_me.__message = function(sBody, aArgs){
	var files = this.text._upload._getAttachments();
	aArgs = Object.assign(aArgs || {}, {body:sBody});

	if (this.text._isUploading()) {
		WMChat.queueMessageWithAttachments(this.__aData, this.text._upload, aArgs);

		this.text._clearAttachments();
		return;
	}

	if (sBody.match(/\(data:.*?;base64,.*?\)/)) {
		replaceAsync(sBody, /!\[(.*?)\]\((data:image\/(.*?);base64,.*?)\)/g, (full, name, data, type) => {
			return new Promise((resolve) => {
				fetch(data).then(res => res.blob()).then(async blob => {
					if (type === 'heif') {
						type = 'heic'
					}
					var image = new File([blob], name + '.' + type, { type: 'image/' + type });

					var uploadInstance = await obj_upload._instance(this, unique_id());
					
					function uploadEndHandler(data) {
						if (data.owner !== uploadInstance.file) {
							return;
						}

						gui._disobeyEvent('onuploadend', [uploadEndHandler]);
						if (!data.files.length) {
							resolve('');
						}
						var aFolder = {
							aid: sPrimaryAccount,
							fid: Mapping.getDefaultFolderForGWType('F')
						};
				
						var now = new IcewarpDate();
						WMItems.add([aFolder.aid, aFolder.fid], {
							values: {
								EVNSHARETYPE: GWOthers.getItem('DEFAULT_CALENDAR_SETTINGS', 'file_sharing'),
								EVNSTARTDATE: now.format(IcewarpDate.JULIAN),
								EVNSTARTTIME: now.hour() * 60 + now.minute()
							},
							ATTACHMENTS: uploadInstance._getAddon()
						}, '', '', '', [function (aResponse, aData) {
							uploadInstance._destruct();
							if (aResponse === true) {
								resolve('![' + name + '](' + aData.att_link + ')');
							} else if (aResponse !== 2) {
								resolve('');
							}
						}]);
					}
					gui._obeyEvent('onuploadend', [uploadEndHandler]);
					uploadInstance.file.__ondropfile([image]);
				});
			});
		}).then((sBody) => {
			aArgs.body = sBody;
			if (files.length) {
				WMChat.addMessageWithAttachments(this.__aData, files, aArgs);
		
				this.text._clearAttachments(true);
			} else {
				WMChat.message(this.__aData, aArgs);
			}
		});
	} else if (files.length) {
		WMChat.addMessageWithAttachments(this.__aData, files, aArgs);

		this.text._clearAttachments(true);
	} else {
		WMChat.message(this.__aData, aArgs);
	}

	//show chat
	if (hascss(this._main,'full'))
		removecss(this._main,'full');
};