_me = frm_color_picker.prototype;
function frm_color_picker() { };

_me.__constructor = async function (sTitle, sValue, aResponse, oOptions) {
	oOptions = Object.assign({
		hue: true,
		lightness: true,
		hex: true,
		theme: false
	}, oOptions);

	var me = this;
	this._modal(true);
	this._resizable(false);
	this._dockable(false);
	this._title(sTitle);

	await this._create('color_picker', 'obj_colorpicker', '', '', oOptions);
	this._size('auto', 'auto', true);

	if (sValue === 'transparent') {
		sValue = '#000000';
	}
	if (~sValue.indexOf('#')) {
		this.color_picker._value(sValue);
	} else {
		sValue = sValue.match(/(\d{1,3}).*?(\d{1,3}).*?(\d{1,3})/);
		this.color_picker._rgb_value([sValue[1], sValue[2], sValue[3]]);
	}

	if (oOptions.theme) {
		this.color_picker._onchange = function(sColor) {
			var rgb = colors.hex2rgb(sColor);
			var hsl = colors.rgb2hsl.apply(colors, rgb);
		
			rgb = colors.hsl2rgb(hsl[0], hsl[1], 0.45);
			var hex = colors.rgb2hex(rgb[0], rgb[1], rgb[2]);
		
			rgb = colors.hsl2rgb(hsl[0], hsl[1], 0.3);
			var hex_dark = colors.rgb2hex(rgb[0], rgb[1], rgb[2]);

			me._main.setAttribute('style', '--bg_ok_button:' + hex + ';--bg_ok_button_darker:' + hex_dark + ';');
		};
		this.color_picker._onchange(sValue);
	}

	await this._create('btn_ok', 'obj_button', 'footer', 'ok noborder color1');
	this.btn_ok._value('FORM_BUTTONS::OK');
	this.btn_ok._onclick = function () {
		executeCallbackFunction(aResponse, me.color_picker._value());
		me._destruct();
	};

	await this._create('btn_cancel', 'obj_button', 'footer', 'cancel noborder');
	this.btn_cancel._value('FORM_BUTTONS::CANCEL');
	this.btn_cancel._onclick = function () {
		executeCallbackFunction(aResponse);
		me._destruct();
	};

	await this._create('btn_default', 'obj_button', 'footer', 'cancel noborder color4 x_btn_right');
	this.btn_default._value('SETTINGS::DEFAULT');
	this.btn_default._onclick = function () {
		executeCallbackFunction(aResponse, false);
		me._destruct();
	};
};