_me = frm_collaboration.prototype;

function frm_collaboration() {};

_me.__constructor = async function (aValues) {
	if (WMFolders.getType(aValues) === 'N') {
		aValues.INVITETICKET = aValues.EVNURL;
	}

	await storage.library('short_url');
	await storage.library('textversion', 'textversion');
	var me = this;
	var isNote = WMFolders.getType(aValues) === 'N';
	var isDocument = Item.isDocument(aValues.EVNTITLE) || Item.isSpreadsheet(aValues.EVNTITLE) || Item.isPresentation(aValues.EVNTITLE);
	this.__aOptions = {
		reset_link: !isNote && aValues.INVITETICKET && !ShortURL.matches(aValues.INVITETICKET),
		note: isNote,
		document: !isNote && isDocument,
		file: !isNote && !isDocument,
	};
	this.__aValues = aValues;

	await this._draw('obj_share_collaboration', 'main_content', this.__aOptions);

	this.enabled._onchange = function (event, enabled) {
		me.__invite(function(response) {
			me.enabled._value(!!response.inviteticket, true);
			aValues.EVNURL = aValues.INVITETICKET = response.inviteticket;
			me.__preview();
			me._getAnchor('editing').classList[enabled ? 'remove' : 'add']('disabled');
			me._getAnchor('download').classList[enabled ? 'remove' : 'add']('disabled');
			me._getAnchor('expiration').classList[enabled ? 'remove' : 'add']('disabled');
			me._getAnchor('password').classList[enabled ? 'remove' : 'add']('disabled');
			me._getAnchor('share').classList[enabled ? 'remove' : 'add']('disabled');
			me.__changed = true;
			me._reposition();
		});
	};

	this.allowed_editing._onchange = function () {
		me.__invite();
		return false;
	};

	this.disable_download._onchange = function () {
		me.__invite();
		return false;
	};

	this.password_protected._onchange = function (e, enabled) {
		var password = me.password._value();
		var sharing_enabled = me.enabled._checked();
		me.__invite(function() {
			me._getAnchor('password_container').classList[!enabled || !sharing_enabled ? 'add' : 'remove']('hidden');
			me._getAnchor('password_protected').classList[(enabled && password) ? 'remove' : 'add']('hidden');
			me._reposition();
		});
	};

	this.password._onkeydown = function (e) {
		if (e.keyCode === 13) {
			me.save_password._onclick();
			me.password._focus();
		}
	};

	var preventBlur = false;
	this.password._onblur = function (e) {
		if (preventBlur) {
			preventBlur = false;
			return;
		}
		if (me._destructed || e.relatedTarget === '') {
			return;
		}
		if (aValues.EVNDOCPASS !== me.password._value()) {
			me.save_password._onclick();
			me.password._focus();
		}
	};

	this.password.__setMask({ toggle: ['', getLang('COMMON::SHOW')] }, [
		function () {
			preventBlur = false;
			if (me.password.__eIN.getAttribute('type') === 'text') {
				me.password.__eIN.setAttribute('type', 'password');
			} else {
				me.password.__eIN.setAttribute('type', 'text');
			}
			me.password._focus();
		}
	]);
	this.password.__mask.addEventListener('mousedown', function() {
		preventBlur = true;
	});

	this.password._onchange = function () {
		if (me.__resetSavePasswordTimeout) {
			clearTimeout(me.__resetSavePasswordTimeout);
			me.__resetSavePassword();
		}

		me.save_password._main.classList[(me.password._value() === (aValues.EVNDOCPASS || '')) ? 'add' : 'remove']('hidden');
	};

	this.__resetSavePassword = function () {
		if (me.save_password) {
			me.save_password._disabled(false);
			me.save_password._value('FORM_BUTTONS::SAVE');
			me.save_password._main.classList.add('hidden');
			me._reposition();
		}
	};

	this.save_password._onclick = function () {
		me.__invite(function() {
			me.save_password._disabled(true);
			me.save_password._value('FORM_BUTTONS::SAVED');
			me.__resetSavePasswordTimeout = setTimeout(me.__resetSavePassword.bind(me), 2000);
			me._getAnchor('password_protected').classList[me.password._value() ? 'remove' : 'add']('hidden');
			aValues.EVNDOCPASS = me.password._value();
			me._reposition();
		});
		return false;
	};

	this.expiration_enabled._onchange = function (e, enabled) {
		me._getAnchor('expiration_container').classList[!enabled ? 'add' : 'remove']('hidden');

		me.__invite(function() {
			aValues.EVNDOCEXPIRE = me.expiration._value(void 0, false, false);
		});
		me._reposition();
	};

	this.expiration._ondateselect = function () {
		me.__invite(function() {
			me.expiration._focus();
		});
	};

	this.expiration.__opt.minDate = new IcewarpDate();

	if (+aValues.EVNDOCEXPIRE) {
		this.expiration._value(aValues.EVNDOCEXPIRE, true, false);
		this.expiration_enabled._checked(!!aValues.EVNDOCEXPIRE, true);
	} else {
		this.expiration._value(new IcewarpDate().add(1, 'month'), true);
	}
	this._getAnchor('expiration_container').classList[!aValues.EVNDOCEXPIRE ? 'add' : 'remove']('hidden');

	if (Item.officeSupport(aValues.EVNTITLE, true)) {
		this._getAnchor('editing').classList.remove('hidden');
		this._getAnchor('download').classList.remove('hidden');
	}

	var enabled = !!aValues.INVITETICKET || (aValues.EVNDOCINVITE == 1);
	this.enabled._value(enabled, true);
	me._getAnchor('editing').classList[enabled ? 'remove' : 'add']('disabled');
	me._getAnchor('download').classList[enabled ? 'remove' : 'add']('disabled');
	me._getAnchor('expiration').classList[enabled ? 'remove' : 'add']('disabled');
	me._getAnchor('password').classList[enabled ? 'remove' : 'add']('disabled');
	me._getAnchor('share').classList[enabled ? 'remove' : 'add']('disabled');

	this.allowed_editing._value(aValues.EVNDOCEDITABLE === '1', true);
	this.disable_download._value(aValues.EVNDOCDISABLEDOWNLOAD == '1', true);
	if (aValues.EVNDOCPASS_PLAIN) {
		aValues.EVNDOCPASS = aValues.EVNDOCPASS_PLAIN;
	}

	if (GWOthers.getItem('RESTRICTIONS', 'force_sharing_password') == '1') {
		await storage.library('wordGen', 'wordGen');
		if (!aValues.EVNDOCPASS) {
			this.password.__eIN.setAttribute('type', 'text');
		}
		aValues.EVNDOCPASS = aValues.EVNDOCPASS || (wordGen() + (Math.random() * 899999999 + 100000000)).slice(0, 10);
		this.password_protected._disabled(true);
	}

	if (aValues.EVNDOCPASS) {
		this.password._value(aValues.EVNDOCPASS.unentityify());
		this._getAnchor('password_container').classList.remove('hidden');
	}
	this.password_protected._value(!!aValues.EVNDOCPASS, true);
	this._getAnchor('password_protected').classList[aValues.EVNDOCPASS ? 'remove' : 'add']('hidden');

	if (this.reset_link) {
		this.reset_link._onclick = Item.revokeCollaborationLink.bind(this, [aValues.aid, aValues.fid, aValues.EVN_ID]);
	}

	gui._obeyEvent('changedId', [this, '__changedIdHandler']);
	this._add_destructor('__changedIdHandlerDestructor');

	this._size(700, 'auto', true);
	this._place(false, 0);

	if (WMFolders.getType(aValues) === 'N') {
		if (aValues.INVITETICKET) {
			this.__preview();
		} else if (aValues.EVNDOCINVITE) {
			me.__invite(function(response) {
				me.enabled._value(!!response.inviteticket, true);
				aValues.INVITETICKET = response.inviteticket;
				me.__preview();
				me.__changed = true;
			});
		}

		this.__teamchatAction = function(aPath, aItemInfo, aHandler) {
			var aData = this.preview._value();
			aData.title = aValues.EVNTITLE;
			aData.type = WMChat.const.LINK.NOTE;
			aData.linkData = JSON.stringify({
				type: WMChat.const.LINK.NOTE,
				body: aValues.NOTES ? aValues.NOTES[0].values.NOTE_TEXT : ''
			});
			WMChat.message(aPath, aData, aHandler);
		}.bind(this);
	}
};

_me.__processing = function(disable) {
	this.enabled._disabled(disable);
	this.allowed_editing._disabled(disable);
	this.disable_download._disabled(disable);
	this.password_protected._disabled(disable || GWOthers.getItem('RESTRICTIONS', 'force_sharing_password') == '1');
	this.password._disabled(disable);
	this.expiration._disabled(disable);
	this.expiration_enabled._disabled(disable);
	this.save_password._disabled(disable);
}

_me.__invite = function(callback) {
	if (this._destructed) {
		return;
	}

	var enabled = this.enabled._checked();
	var editable = this.allowed_editing._value();
	var disable_download = this.disable_download._value();
	var protect = this.password_protected._checked();
	var password = this.password._value();

	if (enabled && GWOthers.getItem('RESTRICTIONS', 'force_sharing_password') == '1' && !password) {
		password = this.__aValues.EVNDOCPASS_PLAIN || this.__aValues.EVNDOCPASS;
		this.password._value(password);
	}
	this.__aValues.EVNDOCPASS = password;

	var expiration = this.expiration._value(void 0, false, false);
	var expiration_enabled = this.expiration_enabled._value();

	this.__processing(true);

	TeamChatAPI[enabled ? 'filesInvite' : 'filesUninvite'].call(TeamChatAPI, {
		id: this.__aValues.EVN_ID,
		aid: this.__aValues.aid,
		fid: this.__aValues.fid,
		editable: editable,
		disable_download: disable_download,
		password: protect && password,
		expiration: expiration_enabled && expiration
	}, {
		success: function (response) {
			if (enabled && WMFolders.getType(this.__aValues) === 'N') {
				gui.frm_main.dashboard._shortUrl({
					url: response.inviteticket,
					type: 'note', 
				}, function(data) {
					WMItems.add([this.__aValues.aid, this.__aValues.fid, this.__aValues.EVN_ID], {
						values: {
							EVNURL: data.url
						}
					}, '', '','', [function() {
						this.__processing(false);
						this.__addCloseButton();
						callback && callback({
							inviteticket: data.url
						});
					}.bind(this)]);
				}.bind(this));
			} else {
				this.__processing(false);
				this.__addCloseButton();
				callback && callback(response);
			}
			gui.__exeEvent('itemShare', {
				aid: this.__aValues.aid,
				fid: this.__aValues.fid,
				iid: this.__aValues.EVN_ID,
				isShared: !!enabled,
				isEditable: !!editable,
				downloadDisabled: !!disable_download,
				passwordProtected: !!protect,
				password: password || '',
				expirationEnabled: !!expiration_enabled,
				expiration: expiration || 0
			});
		},
		error: function () {
			gui.notifier._value({
				type: 'alert',
				args: {
					header: '',
					text: 'ALERTS::FILE_LOCKED_EDIT'
				}
			});
			this.__processing(false);
		},
		context: this
	});
};

_me.__changedIdHandler = function() {
	this._destruct();
};

_me.__changedIdHandlerDestructor = function() {
	gui._disobeyEvent('changedId', [this, '__changedIdHandler']);

	if (this.__changed) {
		gui.__exeEvent('changedId', {
			oldId: this.__aValues.EVN_ID,
			newId: this.__aValues.EVN_ID
		});
	}
};