_me = frm_chatgpt_conversation.prototype;
function frm_chatgpt_conversation() { };

/**
 *
 * @param {object} aData chatgpt conversation
 */
_me.__constructor = async function (aData, oOptions, oHandlers) {
	this.__aData = aData;
	this.__oOptions = oOptions || {};
	this.__oHandlers = oHandlers || {};
	await this.__init();

	gui._obeyEvent('ChatGPTConversationUpdate', [this, '__ChatGPTConversationUpdate']);

	gui._obeyEvent('ondetach', [this, '_ondetach']);
	this._add_destructor('__destructor');

	// gui.frm_main.dnd.registr_drop(this, ['item']);
};

_me.__destructor = function () {
	gui._disobeyEvent('ChatGPTConversationUpdate', [this, '__ChatGPTConversationUpdate']);
	gui._disobeyEvent('ondetach', [this, '_ondetach']);
};

_me.__init = async function () {
	await this._create('list', 'obj_list_load_chatgpt_conversation', 'chat', 'private', this.__oOptions);

	if (this.__aData) {
		this.list._serverSort(this.__aData);
	} else {
		this.list._oncount();
	}

	var instanceId = this.__aData ? this.__aData.alias || this.__aData.id : unique_id();
	await this._create("text", "obj_chat_input", "text", "", {
		block: true,
		gifs_enabled: false,
		smiles_enabled: false,
		chatgpt_enabled: false,
		upload_enabled: true,
		uploadInstanceId: instanceId,
		memory: {
			set: [function (val) {
				this.__aData && dataSet.add('chatgpt', ['memory', instanceId], val, true);
			}.bind(this)],
			get: [function () {
				return this.__aData ? dataSet.get('chatgpt', ['memory', instanceId]) || '' : '';
			}.bind(this)]
		},
		handlers: {
			make_bullet_points: [this, '_message', [getLang('chatgpt::make_bullet_points') + getLang('chatgpt::pure_result')]],
			fix_grammar: [this, '_message', [getLang('chatgpt::fix_grammar') + getLang('chatgpt::pure_result')]],
			improve_styling: [this, '_message', [getLang('chatgpt::improve_styling') + getLang('chatgpt::pure_result')]],
			make_shorter: [this, '_message', [getLang('chatgpt::make_shorter') + getLang('chatgpt::pure_result')]],
			make_longer: [this, '_message', [getLang('chatgpt::make_longer') + getLang('chatgpt::pure_result')]],
			translate: [this, '_message']
		}
	});

	this.text._onsubmit = function (v, arg, aPrivate, callback) {
		if (this.text._isUploading()) {
			return;
		}

		if (!v.trim()) {
			return;
		}

		this._message(v, arg, callback);
	}.bind(this);

	gui.tooltip._add(this.text.add._main, getLang('CHATGPT::QUICK_ACTIONS'));

	this.__setInput();

	this.text._focus();
};

_me._message = function (sBody, aArgs, callback) {
	this.text._readonly(true);
	sBody += this.__context ? '\n\n' + getLang('chatgpt::context') + ':\n' + this.__context() : '';
	if (!this.__aData) {
		return ChatGPT.conversationCreate({
			label: (this.__oOptions.label ? this.__oOptions.label() : '') || sBody.split(/\.\?!/)[0],
			alias: this.__oOptions.alias
		}, function (bOK, conversation) {
			if (bOK) {
				this.__aData = conversation;
				this.list.__conversation = conversation;
				this.__oHandlers.newConversation(conversation);
				this.__message(sBody, callback, this.text._upload && this.text._upload._getAttachments());
			} else {
				this.text._readonly(false);
			}
		}.bind(this));
	}

	this.__message(sBody, callback, this.text._upload && this.text._upload._getAttachments());
};

_me.__message = async function (sBody, callback, files) {
	this.text._readonly(true);
	if (!files.length) {
		return this.___message(sBody, callback, responses);
	}

	var length = files.length;
	var responses = [];
	var me = this;

	(await this._create('loader', 'obj_loader'))._value(getLang('CHATGPT::ANALYZING_FILES'));

	var toUpload = files.filter(function(file) {
		return file.file;
	}).map(function(file) {
		return {
			values:{
				class: 'file',
				description: file.name,
				fullpath: file.folder + '/' + file.id,
				size: file.size
			}
		};
	});
	var now = new IcewarpDate(),
		aValues = {
			values: {
				EVNSHARETYPE: GWOthers.getItem('DEFAULT_CALENDAR_SETTINGS','file_sharing'),
				EVNSTARTDATE: now.format(IcewarpDate.JULIAN),
				EVNSTARTTIME: now.hour() * 60 + now.minute()
			},
			ATTACHMENTS: toUpload
		};

	if (toUpload.length) {
		WMItems.add([sPrimaryAccount, '__@@UPLOAD@@__'], aValues, '', '','', [function(bOK, aData) {
			if (bOK !== true) {
				me.text._readonly(false);
				return;
			}
			(Array.isArray(aData) ? aData : [aData]).forEach(function (aData, index) {
				gui.__exeEvent('onuploadcommit', { id: files[index].id, data: aData });
				ChatGPT.createFile({
					alias: WMItems.__clientID(aData.id),
					name: files[index].name,
					url: aData.att_link
				}, function(bOK, response) {
					if (!bOK) {
						me.text._readonly(false);
						me.loader._destruct();
						return;
					}
					responses.push(response);
					if (!--length) {
						me.loader._destruct();
						me.text._clearAttachments(true);
						me.___message(sBody, callback, responses);
					}
				});
			});
		}]);
	}

	files.filter(function(file) {
		return !file.file;
	}).forEach(function(file) {
		ChatGPT.createFile({
			alias: WMItems.__clientID(file.iid),
			name: file.name,
			url: sPrimaryAccountClient + 'server/download.php?'+ buildURL({dlsess: dataSet.get('main', ['dlsess']), class: 'file', fullpath: file.fid + '/' + file.iid})
		}, function(bOK, response) {
			if (!bOK) {
				me.loader._destruct();
				me.text._readonly(false);
				return;
			}
			responses.push(response);
			if (!--length) {
				me.loader._destruct();
				me.text._clearAttachments(true);
				me.___message(sBody, callback, responses);
			}
		});
	})
}

_me.___message = function(sBody, callback, files) {
	this.text._readonly(true);
	this.__aData.messageCreate({
		message: sBody,
		files: (files || []).map(function(file) {
			return {
				alias: file.alias
			}
		})
	}, function (bOK, message) {
		this.__aData = message.conversation;
		this.text._readonly(false);
		this.text._focus();
		if (bOK) {
			callback && callback();
			this.__aData.process();
		}
	}.bind(this));
};

_me.__ChatGPTConversationUpdate = function(conversation) {
	if (conversation !== this.__aData) {
		return;
	}

	var instanceChanged = (this.__aData || {}).instance !== (conversation.realConversation || conversation).instance;

	if (conversation.realConversation) {
		this.__aData = conversation.realConversation;
	}

	if (instanceChanged) {
		this.__setInput();
	}
};

_me.__setInput = function() {
	var placeholder = getLang('CHATGPT::ASSISTANT_INPUT_PLACEHOLDER' + (Math.floor((Math.random() * 3)) || ''));
	var instance = (this.__aData || {}).instance || 'assistant';
	if (instance === 'image') {
		placeholder = getLang('CHATGPT::IMAGE_INPUT_PLACEHOLDER');
	}
	this.text.input._placeholder(placeholder);

	this._main.setAttribute('iw-gpt-type', instance);
}

_me._onbeforedetach = function(callback) {
	this.__hasRight = !!this._main.closest('.right');
	this.text.input.__initEditor('textarea');
	callback();
};

_me._ondetach = function(context) {
	if (this._destructed || this._gui !== context) {
		return;
	}
	if (gui.frm_main.rslide._value() === 'chatgpt_conversation') {
		gui.frm_main.rslide._value('chatgpt');
	}
	this._gui._main.classList.add('detached', 'obj_rdock_panel', 'obj_rdock_thread', 'obj_rdock_chatgpt_conversation');
	if (this.__hasRight) {
		this._gui._main.parentNode.classList.add('right');
	}
};

_me._title = function() {
	return this.__aData.label;
}

_me._active_dropzone = async function(v) {
	if (!v) {
		return;
	}

	var mask = mkElement('div', {
		className: 'dropzone item',
		onmouseenter: function() {
			mask.classList.add('active');
		},
		onmouseleave: function() {
			mask.classList.remove('active');
		},
		innerHTML: await (new cTemplate()).tmp('dropzone', {
			title: getLang('CHAT::DROP_TITLE', [this.__aData ? this.__aData.label : getLang('CHATGPT::NEW_CONVERSATION')]),
			body: ''
		})
	});

	this._main.appendChild(mask);

	return mask
};

_me._ondrop = function(v) {
	if (v.type !== 'item') {
		return;
	}

	this.text._upload._addFiles(v.value.map(function (file) {
		return {
			class: file.class || 'item',
			aid: file.aid,
			fid: file.fid,
			iid: file.iid || file.id,
			name: file.name,
			size: file.size,
			fullpath: file.fullpath || (file.aid + '/' + Path.slash(file.fid) + '/' + WMItems.__serverID(file.iid))
		};
	}));
};