_me = frm_chat.prototype;
function frm_chat(){};

_me.__constructor = async function(sFrom) {
	this._detachable(true);
	var me = this;
	this.__sJID = sFrom;

	this._title('IM::IM');
	this.__hide();

	this.__options = {
		history: 20
	};
	this.__searchResults = [];

	this.__dockOrder = -1;
	this.__dockMovable = true;

	this._defaultSize(800, 500, {
		goldenRatio: true
	});

	await this._draw('frm_chat_form','main');

	this.__conversation = this._getAnchor('wrapper');
	await this._create('menu','obj_hmenu',{
		target: 'wrapper',
		first: true
	},'border');

	var a = [
		{text: '', tooltip: 'FORM_BUTTONS::SEARCH', arg: 'search', css: 'ico img ico_search', disabled: me.__sJID.indexOf('~')===0 || !sPrimaryAccountIMHISTORY}
	];

	if (window.sPrimaryAccountSIP && location.protocol == 'https:' && (GWOthers.getItem('RESTRICTIONS', 'disable_sip') || 0)<1){
		a.push(
			{"text": '', tooltip:'DIAL::VIDEO', "arg":'video', "css":'ico img ico_video'},
			{"text": '', tooltip:'DIAL::CALL', "arg":'call', "css":'ico img ico_call'}
		);
	}

	await this.menu._fill(a);

	this.menu._onclick = function(e,elm,id,arg){
		switch(arg){
			case 'call':
				gui.frm_main._call(this.__sJID);
				break;

			case 'video':
				gui.frm_main._call(this.__sJID, true);
				break;

			case 'search':
				addcss(this._main, 'search');
				me.next_search_result._disabled(true);
				me.prev_search_result._disabled(true);
				this.search._focus();
				break;
		}
	}.bind(this);

	await this._draw('frm_chat_search','main',null,true);
	this.search._placeholder(getLang('IM::SEARCH_PH'));

	this.search._onkeyup = this.search._onclose = function(e) {
		if (e.keyCode === 27) {
			e.preventDefault();
			e.stopPropagation();
			me.__clearSearch();
		}
	};

	this.search._onsubmit = function() {
		if (!(me.__im && me.__im._is_active()))
			return;

		var s = me.search._value();

		me.chat._placeholder('IM::SEARCH_NO_RESULTS');

		if (me.__search != s){
			me.__search = s;
			me.__searchIndex = 0;

			if (!s) {
				return me.__clearSearch();
			}

			me.next_search_result._disabled(true);
			me.prev_search_result._disabled(true);
			me.__searchResults = [];
			addcss(me._main, 'loading');
			me.__loadSearchResults(async function() {
				await me.chat._clear();
				removecss(me._main, 'loading');
				if (me.__searchResults.length) {
					removecss(me.chat._main, 'noitems');
					me.next_search_result._disabled(false);
					me.prev_search_result._disabled(false);
					me._jumpTo(me.__searchIndex);
				} else {
					addcss(me.chat._main, 'noitems');
					me.search_results._value('');
				}
			});
		} else if (s) {
			me.__jumpToNextSearchResult();
		}
	};

	this.next_search_result._onclick = function() {
		me.__jumpToNextSearchResult();
	};

	this.prev_search_result._onclick = function() {
		me.__jumpToPrevSearchResult();
	};

	//sip integration
	if (window.sPrimaryAccountSIP && (GWOthers.getItem('RESTRICTIONS', 'disable_sip') || 0)<1)
		this._listen('sip', void 0, true);

	this._listen('xmpp',['roster', this.__sJID], true);
};

_me.__clearSearch = async function() {
	removecss(this._main, 'search');

	dataSet.remove('xmpp',['roster',this.__sJID,'first_history'], true);
	dataSet.remove('xmpp',['roster',this.__sJID,'last_history'], true);
	dataSet.remove('xmpp',['roster',this.__sJID,'history'], true);

	this.search._value('');
	this.search._onsubmit();
	this.search_results._value('');
	this.__searchResults = [];

	if (this.chat) {
		await this.chat._clear();
		this.chat._placeholder('IM::NO_RESULTS');
		this.chat._request && this.chat._request(true);
	}
	if (this.text) {
		this.text._focus();
	}
};

_me.__loadSearchResults = function(callback) {
	if (dataSet.get('xmpp', ['roster', this.__sJID, 'first_history']) == 'full')
		return;

	this.__search_request_id = unique_id();

	var items = 20,
		h = this.__searchResults,
		aGet = {
			from: this.__sJID,
			max: items,
			start: (h[h.length - 1] || {}).start || '',
			before: (h[h.length - 1] || {}).offset || '',
			search: this.__search
		};

	this.__im.__xmpp._history_get(aGet, [function(aData, rqid, sFrom) {
		if (this._destructed || this.__search_request_id !== rqid) {
			return;
		}

		var arr = this.__history_parser(aData).reverse();

		this.__searchResults = this.__searchResults.concat(arr.filter(Boolean));

		var resultCount = this.__searchResults.length;

		this.search_results._value((this.__searchIndex + 1) + '/' + resultCount);

		if (items > arr.length) {
			dataSet.add('xmpp',['roster', sFrom, 'first_history'], 'full', true);
			callback && callback();
		} else if (resultCount < 100) {
			this.__loadSearchResults(callback);
		} else {
			callback && callback();
		}
	}.bind(this), [this.__search_request_id, this.__sJID]]);
};

_me.__jumpToPrevSearchResult = function() {
	if (!this.__searchResults.length) {
		return;
	}
	this.__searchIndex--;
	if (this.__searchIndex < 0) {
		this.__searchIndex = this.__searchResults.length - 1;
	}
	this.search_results._value((this.__searchIndex + 1) + '/' + this.__searchResults.length);
	this._jumpTo(this.__searchIndex);
};

_me.__jumpToNextSearchResult = function() {
	if (!this.__searchResults.length) {
		return;
	}
	this.__searchIndex++;
	if (this.__searchIndex >= this.__searchResults.length) {
		this.__searchIndex = 0;
	}
	this.search_results._value((this.__searchIndex + 1) + '/' + this.__searchResults.length);
	this._jumpTo(this.__searchIndex);
};

_me.__title = function (){
	var v = this.__sJID;
	if (v.indexOf('~')===0){
		var aTmp = dataSet.get('xmpp', ['roster']),
			g = v.replace(/^~/g,'');

		v = '';
		for(var i in aTmp)
			if (aTmp[i].group == g)
				v += v?'; '+i:i;

		v = v || g;
	} else {
		if (this._docked) {
			this.__dock_ico.classList.add('avatar');
		}
	
		var aData = dataSet.get('xmpp',['roster',v]);
		if (aData) {
			if (aData.name)
				v = MailAddress.createEmail(aData.name,v, true);


			var avatarHTML = obj_avatar.getAvatarHTML({ email: this.__sJID, name: aData.name || this.__sJID, size: 28 });

			if (this.__lastStatus) {
				removecss(this._main, this.__lastStatus);
				if (this._docked) {
					removecss(this.__dock_ico, this.__lastStatus);
				}
			}

			this.__lastStatus = (aData.show?encodeURIComponent(aData.show):'offline');
			addcss(this._main, this.__lastStatus);
			if (this._docked) {
				addcss(this.__dock_ico, this.__lastStatus);

				this.__dock_ico.innerHTML = avatarHTML;
			}
			this._getAnchor('ico').className = 'obj_popupico '+ (aData.type?encodeURIComponent('set_'+aData.type)+' gateway ':'');
			this._getAnchor('ico').innerHTML = avatarHTML;
			this._getAnchor('avatar').innerHTML = obj_avatar.getAvatarHTML({ email: this.__sJID, name: aData.name || this.__sJID, size: 24 });
		} else {
			if (this._docked) {
				this.__dock_ico.innerHTML = '<div></div>';
			}
		}
	}

	this._title(v,true);
};

_me.__update = function(sDName,sDPath){
	var ds;
	if (sDName === 'xmpp' && sDPath && sDPath[0] === 'roster'){
		if (sDPath[1] !== this.__sJID) {
			return;
		}
		ds = dataSet.get(sDName, ['roster',this.__sJID]);
		if (ds){
			dataSet.add('xmpp',['roster', this.__sJID, 'view'], this.__im._getStatus(this.__sJID));
			if (this._docked && !dataSet.get('xmpp', ['roster', this.__sJID, 'action']) && this.__dock.classList.contains('event')) {
				gui.frm_main.title._refresh();
				this.__dock.classList.remove('event');
			}
			this.__title();
		}
	} else if (sDName === 'sip' && gui.frm_main.sip){
		ds = dataSet.get('sip');
		if (ds && ds.state == 'online')
			switch (ds.activity){
				case 'Phoning':
				case 'Ringing':
				case 'Calling':
					if (ds.p1 === this.__sJID)
						this._sip_init(ds.p1);
					return;
			}
	}
};

_me._sip_init = async function(sName){
	if (sName){
		if (!this.sip || this.sip._destructed){
			if (this.sip)
				await this.sip._destruct();

			this.sip = await this._create('sip','obj_chat_voip','chat');
		}
	}
};

_me._getRecipients = function() {
	var aTo = [],
		sTo = this.__sJID;

	if (sTo.indexOf('~')===0)
		aTo = this.__im._getGroupUsers(sTo);

	aTo = (aTo && aTo.length) ? aTo : [sTo];

	return aTo;
};

_me._send = function(sMessage,bConference){
	var sTo = this.__sJID,
		b = sMessage || this.text._value();

	if (b.length){
		var reply = this.__reply ? this.__reply.split('\n').map(function(row) { return '||' + row; }).join('\n') + '\n' : '';
		this._reply();
		if (gui.frm_main && gui.frm_main.sound && GWOthers.getItem('IM','sound_notify')>0)
			gui.frm_main.sound._play('im_out');

		if (bConference)
			this.__im._send(sTo, reply + b+' '+dataSet.get('conference',['information','url']), true);
		else {
			setTimeout(async function() {
				this.text._value('');
				if (await this.__im._send(sTo, reply + b)){
					if (this.text.__options && this.text.__options.memory && this.text.__options.memory.set){
						executeCallbackFunction(this.text.__options.memory.set, '');
					}
				} else {
					this.text._value(b);
				}
			}.bind(this), 5);
		}
	} else {
		setTimeout(function() {
			this.text._value('');
		}.bind(this), 5);
	}

	this.text._focus(true);
};

_me._compose = function(){
	if (this._docked) {
		addcss(this.__dock, 'typing');
	} else {
		addcss(this._main, 'typing');
	}
	if (this.__composeTimeout) {
		return;
	}
	if (this.chat) {
		this.chat._getAnchor('main').scrollTop += 34;
	}

	clearTimeout(this.__composeTimeout);
	this.__composeTimeout = false;
	this.__composeTimeout = setTimeout(function(){
		this._wait();
	}.bind(this), 10000);
};

_me._wait = function (){
	if (!this.__composeTimeout) {
		return;
	}
	clearTimeout(this.__composeTimeout);
	this.__composeTimeout = false;
	if (this.chat) {
		this.chat._getAnchor('main').scrollTop -= 34;
	}
	if (this._docked) {
		removecss(this.__dock, 'typing');
	} else {
		removecss(this._main, 'typing');
	}
};

_me._gone = function (){
	this._notice(getLang('STATUS::GONE'));
};

_me._onresize_end = function (){
	this.text._focus(true);

	return true;
};

_me._dock = async function(bShowChat) {
	await this.__clearSearch();
	obj_popup.prototype._dock.call(this);
	// var bUnshift = !bShowChat && !this.__docked;
	// if (bShowChat) {
	// 	this.__dockOrder = -1;
	// 	if (this.__dock) {
	// 		this.__dock.__order = -1;
	// 	}
	// } else {
	// 	this.__dockOrder = 0;
	// 	if (this.__dock) {
	// 		this.__dock.__order = 50;
	// 	}
	// }
	// obj_popup.prototype._dock.call(this, false, false, bUnshift);
	// if (!bShowChat) {
	// 	gui.frm_main.dock._add(this, false, false, bUnshift);
	// }
	this.__title();
	if (bShowChat) {
		await this._createChat();
		if (this.__conversation.parentNode !== this.__dock.querySelector('.body')) {
			this.__dock.querySelector('.body').appendChild(this.__conversation);
			this.chat.__body.scrollTo(0, this.chat.__body.scrollHeight);
		}

		this._onDockedHeaderClick = function(e) {
			if (this.__onclicktimer) {
				clearTimeout(this.__onclicktimer);
			}
			e.stopPropagation();
			this.__onclicktimer = setTimeout(function() {
				this._dock();
			}.bind(this), 50);
			return false;
		}.bind(this);

		this.__undock = this.__undock || mkElement('div', {
			className: 'undock icon',
			onclick: function(e) {
				e.stopPropagation();
				this._undock();
			}.bind(this)
		});
		this.__detachIcon = this.__detachIcon || mkElement('div', {
			className: 'detach icon',
			onclick: async function(e) {
				e.stopPropagation();
				await this._undock();
				this._detach();
			}.bind(this)
		});
		this.__minimize = this.__minimize || mkElement('div', {
			className: 'minimize icon'
		});
		this.__dock.__header.appendChild(this.__undock);
		this.__dock.__header.appendChild(this.__detachIcon);
		this.__dock.__header.appendChild(this.__minimize);
		this.__dock.style.zIndex = maxZIndex.get();
		this.__setZIndex = function() {
			this.__dock.style.zIndex = maxZIndex.get();
		}.bind(this);
		this.__dock.addEventListener('click', this.__setZIndex);

		gui.frm_main.dock._active.push(this);
		gui.frm_main.dock.__checkSize();
		this._onfocus();
	} else {
		if (this.text) {
			if (this._gui.smile) {
				this._gui.smile._destruct();
			}
			if (this.text.add && this.text.add.cmenu) {
				this.text.add.cmenu._destruct();
			}
			if (this.text.chat && this.text.chat.cmenu) {
				this.text.chat.cmenu._destruct();
			}
			if (this.text.input && this.text.input.__eIN) {
				this.text.input.__eIN.blur();
			}
			if (this.text.input && this.text.input.__editor) {
				this.text.input.__editor.getCurrentModeEditor().view.editable = false;
				this.text.input.__editor.blur();
			}
			if (this.text._main.contains(document.activeElement)) {
				document.activeElement.blur();
			}
		}
		this._onDockedHeaderClick = function(e) {
			if (this.__onclicktimer) {
				clearTimeout(this.__onclicktimer);
			}
			e.stopPropagation();
			this.__onclicktimer = setTimeout(function() {
				this._dock(true);
			}.bind(this), 50);
			return false;
		}.bind(this);
		this.__typing = this.__typing || mkElement('div', {
			className: 'typing icon'
		}, false, [
			mkElement('div', {
				className: 'dots'
			}, false, [
				mkElement('div', {
					className: 'dot'
				}),
				mkElement('div', {
					className: 'dot'
				}),
				mkElement('div', {
					className: 'dot'
				})
			])
		]);
		this.__dock.__header.appendChild(this.__typing);
		this.__dock.style.zIndex = '';
		if (this.__setZIndex) {
			this.__dock.removeEventListener('click', this.__setZIndex);
		}
		gui.frm_main.dock._active.splice(gui.frm_main.dock._active.indexOf(this), 1);
		gui.frm_main.dock.__checkSize();
	}

	this.__dock.__header.ondblclick = function(e) {
		if (this.__onclicktimer) {
			clearTimeout(this.__onclicktimer);
		}
		if (this._destructed) {
			return;
		}
		e.preventDefault();
		e.stopPropagation();
		e.stopImmediatePropagation();
		this._undock();
	}.bind(this);

	this.__dock.classList.toggle('active', !!bShowChat);
	if (bShowChat) {
		this.text._focus(true);
	}
};

_me._undock = async function() {
	await this._createChat();
	this._getAnchor('main').appendChild(this.__conversation);
	this.chat.__body.scrollTo(0, this.chat.__body.scrollHeight);
	obj_popup.prototype._undock.call(this);
	gui.frm_main.dock._active.splice(gui.frm_main.dock._active.indexOf(this), 1);
	gui.frm_main.dock.__checkSize();
};

_me._ondock = function (){
	return {
		title: this._getUserName(),
		css: dataSet.get('xmpp', ['roster', this.__sJID, 'action']) ? 'event' : ''
	};
};
_me._onundock = function () {
	this.text && this.text._focus(true);

	return true;
};

_me._isActive = function() {
	return /*obj_popup.prototype._isActive.call(this) && */this.text && this.text._hasFocus();
}

_me._onfocus = function(){
	var h, sFrom = this.__sJID;

	if (this.__destructing || (dataSet.get('xmpp', ['roster', sFrom, 'first_history']) === false)) {
		return;
	}
	if (this._docked) {
		this.__dock.classList.remove('event');
	}

	//COOKIE - odebrat
	if (Cookie.get(['im','queue',sFrom],'msg') == 1){

		var oNot = dataSet.get('xmpp', ['roster', sFrom, 'notification']);
		if (oNot){
			try{
				oNot.close();
			}
			catch(r){ console.log(this._name||false,r)}

			dataSet.remove('xmpp', ['roster', sFrom, 'notification'], true);
		}

		h = dataSet.get('xmpp',['roster',sFrom,'history']) || [];
		if (h.length) {
			gui.frm_main.title._refresh();
			if (h[h.length - 1].markable) {
				this.__im.__xmpp._markAsDisplayed(sFrom, h[h.length - 1].id);
			}
		}

		dataSet.add('xmpp', ['roster', sFrom, 'action'], '');
	}
	else if (dataSet.get('xmpp', ['roster', sFrom, 'action'])) {
		dataSet.add('xmpp', ['roster', sFrom, 'action'], '');

		h = dataSet.get('xmpp',['roster',sFrom,'history']) || [];
		if (h.length) {
			gui.frm_main.title._refresh();
			if (h[h.length - 1].markable) {
				this.__im.__xmpp._markAsDisplayed(sFrom, h[h.length - 1].id);
			}
		}
	}

	dataSet.update('main', ['im']);
};

_me._getUserName = function(){
	var sName;
	var sFrom = this.__sJID;
	if (sFrom.indexOf('~')===0){

		sName = sFrom.replace(/^~/g,'');

		if (sName == '*')
			sName = getLang('IM::OTHER');
		else
		if (sName == '~')
			sName = getLang('IM::NOT_LISTED');
		else
		if (sFrom.indexOf(';')>-1)
			sName = getLang('IM::SELECTED');
	}
	else
	if (!(sName = dataSet.get('xmpp', ['roster', sFrom, 'name']))){
		sName = sFrom;
		if (sName.indexOf('@')>0)
			sName = sName.split('@').shift();
	}

	return sName;
};

_me._createChat = async function(){
	if (this.__chatCreated || this._destructed) {
		return;
	}
	this.__chatCreated = true;

	var me = this;

	var isGroup = this.__sJID.indexOf('~') === 0;

	this.__sName = this._getUserName();
	this.__search = '';

	if (!isGroup)
		dataSet.add('xmpp',['roster',this.__sJID,'active'], false, true);

	var handlers = {
		attach:[function() {
			this._gui._create('insert_item', 'frm_insert_item', '', 'frm_insert_item_nobottomdiv', [this ,'__addItems'], sPrimaryAccount, '', '', this.text._upload, false, ['F', 'X']);
		}.bind(this)],

		conference: [async function(){
			await storage.library('wm_conference');
			wm_conference.create(function(conference) {
				conference.join();
				conference.invite(me._getRecipients());
			}, {
				subject: getLang('CONFERENCE::BETWEEN', [
					dataSet.get('main', ['fullname']),
					this.__sName
				])
			});
		}.bind(this)],

		'geo':[function(){
			if ("geolocation" in navigator)
				navigator.geolocation.getCurrentPosition(function(pos) {
					var aArg = {lat:pos.coords.latitude, lon:pos.coords.longitude};
						me.__im._geo(me.__sJID, aArg);
				});

		}.bind(this)],

		code: [me, '_code', [this]]

	};

	//Text Input
	await this._create('text', 'obj_chat_input', 'text', '', {
		block:true,
		handlers: handlers,
		memory:{
			set:[function(val){
				dataSet.add('xmpp', ['roster', this.__sJID, 'input'], val, true);
			}.bind(this)]
		},
		upload: true,
		upload_enabled: true,
		alias: this.__sJID,
		label: function() {
			return dataSet.get('xmpp', ['roster', me.__sJID, 'name']) || me.__sJID;
		},
		dalle: true,
		mentions_enabled: false
	});

	this.__newUploadInstance();

	this.text._value(dataSet.get('xmpp', ['roster', this.__sJID, 'input']) || '');
	this.text.input._placeholder(getLang('IM::MESSAGE_PH'));

	this.text.add._disabled(!(me.__im && me.__im._is_active()));
	me.__im.__xmpp._obeyEvent('status', [function(){
		if (!this || this._destructed)
			return false;

		this.text.add._disabled(!(me.__im && me.__im._is_active()));

	}.bind(this)]);

	//Send (Ctrl + Enter)
	this.text._onsubmit = function(){
		var files = this.text._upload._getAttachments();

		if (this.text._isUploading()) {
			this.__queueFiles();
		} else if (files.length) {
			this.__sendFiles();
			this.text._clearAttachments(true);
		}
		if (me.__im && me.__im._is_active()){

			var uid = this.__sJID,
				usr = dataSet.get('xmpp', ['roster', uid]);

			if (usr){

				if (!isGroup){
					if (Is.Defined(this.__composing_timeout))
						clearTimeout(this.__composing_timeout);

					this.__is_composing = false;
					me.__im.__xmpp._msg_status(uid+(usr.resource?'/'+usr.resource:''),'paused');
				}

				me._send();
			}
		}
		else
			return false;

	}.bind(this);

	this.text._onkeydown = function(){
		if (!isGroup && me.__im && me.__im._is_active() && me._gui.__focus){

			var uid = this.__sJID,
				usr = dataSet.get('xmpp', ['roster', uid]);

			if (usr){

				if(!this.__is_composing) {
					this.__is_composing = true;
					me.__im.__xmpp._msg_status(uid+(usr.resource?'/'+usr.resource:''),'composing');
				}

				if (Is.Defined(this.__composing_timeout))
					clearTimeout(this.__composing_timeout);

				this.__composing_timeout = setTimeout(function() {
					this.__is_composing = false;
					me.__im.__xmpp._msg_status(uid+(usr.resource?'/'+usr.resource:''),'paused');
				}.bind(this), 3000);
			}
		}

	}.bind(this);

	this.text._onclose = async function(){
		if (me.__reply) {
			return me._reply();
		}

		if (me.__detached) {
			return;
		}

		switch(parseInt(GWOthers.getItem('IM','esc'))){
			case 1:
				await me.__clearSearch();
				me._dock();
				break;
			case 2:
				await me.__clearSearch();
				me._destruct();
		}
	};

	this.text.input._onfocus = function(){
		if (me.__dock && me.__dock.classList && me.__dock.classList.contains('active')) {
			me._onfocus();
		}
	};

	//chat
	if (sPrimaryAccountIMHISTORY && !isGroup) {
		this.chat._request = function(bForceScroll){
			if (dataSet.get('xmpp',['roster',me.__sJID,'last_history']) == 'full')
				return;

			this.__request_id = unique_id();

			var items = 20, aGet,
				h = dataSet.get('xmpp',['roster',me.__sJID,'history']) || [],
				iStart = '', iOffset = '';

			for(var i in h){
				if (h[i] && Is.Defined(h[i].start)){
					iStart = h[i].start;
					iOffset = h[i].offset;
				}
				break;
			}

			this.__loading = 1;

			aGet = {
				'from':me.__sJID,
				'max':20,
				'start':iStart,
				'before':iOffset
			};

			me.chat._placeholder('IM::NO_RESULTS');

			addcss(this._main, 'loading');
			me.__im.__xmpp._history_get(aGet, [function(aData, rqid, sFrom){
				this.__loading = 0;
				if (!this._destructed && this.__request_id == rqid){
					var arr = me.__history_parser(aData),
						h = dataSet.get('xmpp',['roster',sFrom,'history']) || [];

					if (items>arr.length)
						dataSet.add('xmpp',['roster', sFrom, 'last_history'], 'full', true);

					arr = arr.filter(Boolean);
					//Alter history
					dataSet.add('xmpp',['roster', sFrom,'history'], [].concat(arr, h), true);

					//Fill to top
					if (arr.length) {
						this._response(arr.reverse(), false, bForceScroll);
						if (!iStart && !iOffset && arr[arr.length - 1].markable) {
							me.__im.__xmpp._markAsDisplayed(me.__sJID, arr[arr.length - 1].id);
						}
					}

					if (dataSet.get('xmpp',['roster', sFrom,'history']).length){
						removecss(this._main, 'noitems');
					} else {
						addcss(this._main, 'noitems');
					}
				}

				removecss(this._main, 'loading');

			}.bind(this), [this.__request_id, me.__sJID]]);

		};

		this.chat._request2 = function() {
			if (dataSet.get('xmpp', ['roster', me.__sJID, 'first_history']) == 'full')
				return;

			this.__request_id = unique_id();
			this.__loading = 1;

			var limit = 20,
				h = dataSet.get('xmpp',['roster',me.__sJID,'history']) || [],
				aGet = {
					from: me.__sJID,
					max: limit,
					start: h[h.length - 1].start,
					after: h[h.length - 1].offset
				};

			addcss(this._main, 'loading');
			me.__im.__xmpp._history_get(aGet, [function(aData, rqid, sFrom) {
				if (!this._destructed && this.__request_id == rqid) {
					var arr = me.__history_parser(aData),
						h = dataSet.get('xmpp',['roster',sFrom,'history']) || [];

					if (limit > arr.length) {
						dataSet.add('xmpp',['roster', sFrom, 'first_history'], 'full', true);
						me._onfocus();
						this.__aRequestData.fetchnew = false;
						if (arr[0] && arr[0].markable) {
							me.__im.__xmpp._markAsDisplayed(me.__sJID, arr[0].id);
						}
					} else {
						this.__aRequestData.fetchnew = true;
					}

					arr = arr.filter(Boolean);

					dataSet.add('xmpp',['roster', sFrom, 'history'], [].concat(h, arr), true);

					if (arr.length) {
						this._response(arr, true);
					}

					if (dataSet.get('xmpp',['roster', sFrom, 'history']).length){
						removecss(this._main, 'noitems');
					} else {
						addcss(this._main, 'noitems');
					}
				}

				removecss(this._main, 'loading');

			}.bind(this), [this.__request_id, me.__sJID]]);

		};
	}

	//tab is active
	if (!isGroup)
		dataSet.add('xmpp',['roster',this.__sJID,'active'], true, true);

	//load already preloaded history
	var arr = dataSet.get('xmpp',['roster',this.__sJID,'history'], true);
	if (Is.Array(arr)){
		this.chat.__loading = 1;
		this.chat._response(arr.reverse(), false, true);
	}
	else
	//if (bClick && this.chat._request)
	if (this.chat._request)
		this.chat._request(true);

	me.__title();

	//Search
	if (this.__search){
		this._parent.search._value(this.__search);
		addcss(me._main, 'search');
	}
	else
		removecss(me._main, 'search');

	//COOKIE - odebrat
	if (dataSet.get('xmpp', ['roster', this.__sJID, 'action']) == 'msg'){
		dataSet.add('xmpp', ['roster', this.__sJID, 'action'], '');
		dataSet.update('main', ['im']);
	}

	//scroll chat if exists
	if (this.chat){
		this.text._focus();
		this.chat._scroll(0);
	}

	//Listen to roster
	this.__update('xmpp',['roster', this.__sJID]);

	this._add_destructor('__onDestruct');

	//check SIP
	this.__update();

	return this;
};

_me.__newUploadInstance = async function() {
	var me = this;
	this.__uploadInstanceId = this.__uploadInstanceId || 0;
	var uploadInstance = await obj_upload._instance(this, this.__sJID + '_' + this.__uploadInstanceId++, {
		onclick: function() {
			gui.frm_main.im._chat(me.__sJID);
		}
	});
	
	if (this.text._upload) {
		this.text._upload.__remove_dropzone(this.__conversation);
		if (this.text._upload !== uploadInstance && !this.text._upload.file._isUploading && !this.text._upload.file.__value.length) {
			await this.text._upload._destruct();
		}
	}

	this.text._upload = uploadInstance;

	this.text._upload._onuploadstart = function(files) {
		if (files.length) {
			this.text._main.classList.add('has-attachments');
		}

		[].forEach.call(files, function(file) {
			// file.meta = { type: 'im', email: this.__sJID, name: this._getUserName() };
			this.text._create('attachment', 'obj_attachment', 'attachments', '', file, { progress: { pie: true }});
		}, this);
	}.bind(this);

	this.text._clearAttachments();
	this.text._upload._restore();

	this.text._upload._dropzone(this.__conversation, async function(){
		return await (new cTemplate()).tmp('dropzone',{title:getLang('CHAT::DROP_TITLE', [me._getUserName()])});
	},'item');
};

_me.__sendFiles = function(files) {
	files = files || this.text._upload._getAttachments();
	var d = new IcewarpDate(),
		aItemInfo = {values:{},ATTACHMENTS:files.filter(function(file) {
			return file.class !== 'item';
		}).map(function(file) {
			var guid = file.tmp_id || this.__im.__xmpp._getUniqueID();
			this._chat(this.__sJID, sPrimaryAccount, {
				url: (file.fullpath || '').match(/^https?:\/\//) ? file.fullpath : file.file ? URL.createObjectURL(file.file) : sPrimaryAccountClient + 'server/download.php?'+ buildURL({dlsess: dataSet.get('main', ['dlsess']), class: 'file', fullpath: file.folder + '/' + file.id}),
				desc: file.name,
				size: file.size,
				type: 'file'
			}, '', '', guid);
			delete file.file;
			file.tmp_id = guid;
			file.share = true;
			return {values:file};
		}, this)};
		aItemInfo.values.EVNSHARETYPE = 'U';
		aItemInfo.values.EVNSTARTDATE = d.format(IcewarpDate.JULIAN);
		aItemInfo.values.EVNSTARTTIME = d.hour()*60 + d.minute();
		aItemInfo.values.META = JSON.stringify({ type: 'im', email: this.__sJID, name: this._getUserName() });

	aItemInfo.ATTACHMENTS.length && WMItems.add([sPrimaryAccount, '__@@UPLOAD@@__'], aItemInfo, '', '','',[function(bOK, aData){
		if (bOK){
			if (aData && this.__sJID){
				(Array.isArray(aData) ? aData : [aData]).forEach(function (aData, index) {
					gui.__exeEvent('onuploadcommit', { id: files[index].id, data: aData });
					if (files[index].tmp_id) {
						this.__deleteMessage(files[index].tmp_id);
					}
					var name = aData.name.match(/^\(\d+\)$/) ? files[index].name : aData.name;
					this.__im._link(this.__sJID, {link: aData.att_link + '&id=' + aData.id, desc: name, size: aData.att_size});
				}, this);
			}
		}
	}.bind(this)]);

	files.filter(function(file) {
		return file.class === 'item';
	}).map(function(file) {
		WMItems.list({
			aid: file.aid,
			fid: file.fid,
			iid: file.iid,
			values: ['TICKET']
		}, '', '', '', [async function(aData) {
			if (aData && (aData = aData[file.aid]) && (aData = aData[file.fid]) && (aData = aData[WMItems.__clientID(file.iid)])){
				if (!aData.INVITETICKET && TeamChatAPI) {
					var password = '';
					if (GWOthers.getItem('RESTRICTIONS', 'force_sharing_password')) {
						await storage.library('wordGen', 'wordGen');
						password = (wordGen() + (Math.random() * 899999999 + 100000000)).slice(0, 10);
					}

					return TeamChatAPI.filesInvite({
						id: WMItems.__serverID(file.iid),
						aid: file.aid,
						fid: file.fid,
						editable: false,
						password: password
					}, {
						success: function (response) {
							if (file.tmp_id) {
								this.__deleteMessage(file.tmp_id);
							}
							this.__im._link(this.__sJID, {link: response.inviteticket, desc: file.name, size: file.size});

						},
						error: function () {},
						context: this
					});
				}

				if (file.tmp_id) {
					this.__deleteMessage(file.tmp_id);
				}
				this.__im._link(this.__sJID, {link: aData.INVITETICKET || file.fullpath, desc: file.name, size: file.size});
			}
		}.bind(this)]);
	}, this);
};

_me.__queueFiles = function() {
	var oUpload = this.text._upload;
	this.__queue = this.__queue || [];

	if (!~this.__queue.indexOf(oUpload)) {
		this.__queue.push(oUpload);

		var queue = [].concat(oUpload.file.__value, oUpload.file.__queue).filter(function(file) {
			if (file.xhr.readyState === 4) {
				file.data.file = file;
				file.data.class = 'file';
				file.data.fullpath = file.folder + '/' + file.id;
				this.__sendFiles([file.data]);
				return false;
			}
			return true;
		}, this);

		queue.forEach(function(attachment) {
			this._chat(this.__sJID, sPrimaryAccount, {
				url: URL.createObjectURL(attachment),
				desc: attachment.name,
				size: attachment.size,
				type: 'file'
			}, '', '', attachment.iid || this.__im.__xmpp._getUniqueID());
		}, this);

		oUpload._onuploadsuccess = function(file) {
			file.data.tmp_id = file.iid;
			file.data.class = 'file';
			file.data.fullpath = file.folder + '/' + file.id;
			this.__sendFiles([file.data]);
		}.bind(this);
		oUpload._onuploadaborted = function(file) {
			this.__deleteMessage(file.iid);
		}.bind(this);
		oUpload._onuploadend = function() {
			this.__queue = this.__queue.filter(function(upload) {
				return upload !== oUpload;
			});
		}.bind(this);
	}

	this.text._clearAttachments();
	this.__newUploadInstance();
}

_me.__onDestruct = function() {
	// dataSet.add('xmpp', ['roster', this.__sJID, 'history'], false);
	this._disobeyEvent('onstatechange', [this, '__autoreopenCallback']);
	this.text._upload.__remove_dropzone(this.__conversation);
	delete this.__im.__chats[this.__sJID];
};

_me._code = function (chat) {
	this._gui._create('insert_code', 'frm_insert_code', '', '', [function (sBody) {
		if (chat.text._value()) {
			chat.text._value(chat.text._value() + '\n' + sBody);
		} else {
			this._send(sBody);
		}
	}.bind(this)]);
};

_me._reply = async function(sBody) {
	if (sBody) {
		if (this.text.reply) {
			await this.text.reply._destruct();
		}
		if (Is.Object(sBody) && sBody.size) {
			this.__reply = JSON.stringify(sBody);
			// this._getAnchor('reply').classList.add('image');
			await this.text._create('reply', 'obj_list_load_im_file', 'block', 'reply', {
				body: sBody
			}, {});
		} else {
			this.__reply = sBody.body || sBody;
			await this.text._create('reply', 'obj_list_load_im_message', 'block', 'reply', {}, {
				body: obj_groupchat_item.prototype.__encode_body(sBody.body || sBody)
			});
		}

		await this.text.reply._create('close', 'obj_button', '', 'ico transparent cancel simple');
		this.text.reply.close._onclick = function() {
			this._reply();
		}.bind(this);

		addcss(this.text._main, 'block');
		this.text._focus();
	} else if(this.text.reply) {
		this.__reply = '';
		this.text.reply._destruct();
		removecss(this.text._main, 'block');
	}
}

_me.__transformImageMessages = function (msg) {

	if (msg.EVENT && msg.EVENT[0].ITEMS && msg.EVENT[0].ITEMS[0].ITEM && msg.EVENT[0].ITEMS[0].ITEM[0].GEOLOC)
		msg.BODY = [{VALUE: {geoloc: msg.EVENT[0].ITEMS[0].ITEM[0].GEOLOC[0], type: "geoloc"}}];
	else
	if (msg.X && msg.X[0].URL)
		msg.BODY = [{VALUE: {url: msg.X[0].URL[0].VALUE, desc: msg.X[0].DESC?msg.X[0].DESC[0].VALUE:'', size: msg.X[0].SIZE?msg.X[0].SIZE[0].VALUE:'', type: "file"}}];

	return msg;
};

_me._notice = function(sBody){
	if (sBody && this.chat){
		this.chat._notice(this.__sJID, sBody);
	}
};

_me._chat = async function(sFrom, sTo, sBody, iDate, bError, sId){
	sFrom = Path.split(sFrom)[0];

	if (sBody && this.chat){

		//Opened for first time, drop the message & use history
		if (this.chat._request && !Is.Defined(dataSet.get('xmpp',['roster',sFrom,'history']))){
			this.chat._request();
			return;
		}

		// if shown history, skip adding message
		if (dataSet.get('xmpp', ['roster', sFrom, 'first_history']) === false) {
			return;
		}

		//Save history
		iDate = iDate || (new IcewarpDate()).unix();
		var h = dataSet.get('xmpp',['roster',sFrom,'history']) || [];
			h.push({
				from: sTo || sFrom,
				to: sFrom,
				body: sBody,
				reply: !!sTo,
				date: iDate,
				undelivered: bError,
				id: sId
			});

		dataSet.add('xmpp',['roster',sFrom,'history'],h,true);
		var message = await this.chat._add(sFrom, sTo, sBody, !!sTo, iDate, bError, sId);
		if (this._docked && !this.__dock.classList.contains('active')) {
			this.chat._scroll(0);
		} else if (this._isActive()) {
			this.__im.__xmpp._markAsDisplayed(sFrom, sId);
		}
		return message;
	}
};

_me.__deleteMessage = function(sId) {
	this.chat && this.chat._delete(sId);
	var history = dataSet.get('xmpp',['roster',this.__sJID,'history']) || [];
	history = history.filter(function(h) {
		return h.id !== sId;
	});

	dataSet.add('xmpp',['roster',this.__sJID,'history'], history, true);
};

_me.__addItems = function(files) {
	this.text._upload._addFiles(files.map(function (file) {
		return {
			class: file.class || 'item',
			aid: file.aid,
			fid: file.fid,
			iid: file.iid || file.id,
			name: file.title,
			size: file.size,
			fullpath: file.fullpath || (file.aid + '/' + Path.slash(file.fid) + '/' + WMItems.__serverID(file.iid))
		};
	}));
};

_me.__history_parser = function(aData){

	var arr = [], i;
	try{
		if (aData && aData.IQ && (aData = aData.IQ[0]) && aData.CHAT) {
			if (aData.CHAT[0].TO) {
				aData.CHAT[0].TO = aData.CHAT[0].TO.map(this.__transformImageMessages);
				for (i in aData.CHAT[0].TO) {
					var to = aData.CHAT[0].TO[i];
					if (to.BODY && to.BODY[0] && to.BODY[0].VALUE) {
						arr.push({
							from: sPrimaryAccount,
							body: to.BODY[0].VALUE,
							reply: true,
							date: (new IcewarpDate(aData.CHAT[0].ATTRIBUTES.START).utcOffset(new IcewarpDate().utcOffset()).add(to.ATTRIBUTES.SECS, 'seconds')).unix(),
							start: aData.CHAT[0].ATTRIBUTES.START,
							offset: to.ATTRIBUTES.SECS,
							undelivered: (to.ATTRIBUTES.TYPE || '').toLowerCase() === 'error',
							id: to.ATTRIBUTES.ID,
							markable: to.MARKABLE
						});
					} else if (to.DISPLAYED || to.RECEIVED) {
						arr.some(function(a) {
							if (a.id === to.ATTRIBUTES.ID) {
								a.markable = false;
								return true;
							}
						});
						arr.push({
							from: sPrimaryAccount,
							reply: true,
							date: (new IcewarpDate(aData.CHAT[0].ATTRIBUTES.START).utcOffset(new IcewarpDate().utcOffset()).add(to.ATTRIBUTES.SECS, 'seconds')).unix(),
							start: aData.CHAT[0].ATTRIBUTES.START,
							offset: to.ATTRIBUTES.SECS,
							id: to.ATTRIBUTES.ID
						})
					} else {
						arr.push(false);
					}
				}
			}

			if (aData.CHAT[0].FROM) {
				aData.CHAT[0].FROM = aData.CHAT[0].FROM.map(this.__transformImageMessages);

				for (i in aData.CHAT[0].FROM) {
					var from = aData.CHAT[0].FROM[i];
					if (from.BODY && from.BODY[0] && from.BODY[0].VALUE) {
						arr.push({
							from: from.ATTRIBUTES.JID,
							body: from.BODY[0].VALUE,
							reply: false,
							date: (new IcewarpDate(aData.CHAT[0].ATTRIBUTES.START).utcOffset(new IcewarpDate().utcOffset()).add(from.ATTRIBUTES.SECS, 'seconds')).unix(),
							start: aData.CHAT[0].ATTRIBUTES.START,
							offset: from.ATTRIBUTES.SECS,
							undelivered: (from.ATTRIBUTES.TYPE || '').toLowerCase() === 'error',
							id: from.ATTRIBUTES.ID,
							markable: from.MARKABLE
						});
					} else if (from.DISPLAYED || from.RECEIVED) {
						arr.some(function(a) {
							if (a.id === from.ATTRIBUTES.ID) {
								a.markable = false;
								return true;
							}
						});
						arr.push({
							from: sPrimaryAccount,
							reply: true,
							date: (new IcewarpDate(aData.CHAT[0].ATTRIBUTES.START).utcOffset(new IcewarpDate().utcOffset()).add(from.ATTRIBUTES.SECS, 'seconds')).unix(),
							start: aData.CHAT[0].ATTRIBUTES.START,
							offset: from.ATTRIBUTES.SECS,
							id: from.ATTRIBUTES.ID
						})
					} else {
						arr.push(false);
					}
				}
			}

			if (arr.length>0)
				arr.sort(function (a,b){
					var aDate = (a || {}).date;
					var bDate = (b || {}).date;
					if (!aDate && !bDate) {
						return 0;
					}
					if (!aDate) {
						return 1;
					}
					if (!bDate) {
						return -1;
					}
					return aDate - bDate;
				});
		}
	}
	catch(e){
		console.log('frm_chat.__history_parser', e);
		window.Sentry && Sentry.withScope(function(scope) {
			scope.setTag('module', 'IM');
			Sentry.captureException(e);
		});
	}

	return arr;
};

_me._jumpTo = async function(index) {
	var aMessage = this.__searchResults[index];

	var limit = 20;
	var aGet = {
		from: this.__sJID,
		max: limit,
		start: aMessage.start,
		after: aMessage.offset - 1
	};

	if (this.chat.__aData[aMessage.id]) {
		var data = this.chat.__aData[aMessage.id];
		var highlighted = this.chat._main.querySelector('.highlight');
		highlighted && highlighted.classList.remove('highlight');
		data.row._main.classList.add('highlight');
		this.chat._getAnchor('main').scrollTop = this.chat._getAnchor(data.anchor).offsetTop - 50;
		this.chat.__body.onscroll();
		return;
	}

	//clear search
	dataSet.remove('xmpp',['roster',this.__sJID,'last_history'], true);
	dataSet.remove('xmpp',['roster',this.__sJID,'history'], true);
	dataSet.add('xmpp',['roster', this.__sJID, 'first_history'], false, true);
	await this.chat._clear();
	this.chat.__aRequestData.fetchnew = true;
	this.chat.__highlight = aMessage.id;

	// this.chat.__loading = 1;
	this.__request_id = unique_id();

	addcss(this._main, 'loading');
	this.__im.__xmpp._history_get(aGet, [function(aData, rqid, sFrom) {
		if (this && !this._destructed && this.__request_id == rqid){
			var arr = this.__history_parser(aData),
				h = dataSet.get('xmpp',['roster',sFrom,'history']) || [];

			if (limit > arr.length) {
				dataSet.add('xmpp',['roster', sFrom, 'first_history'], 'full', true);
				this._onfocus();
			}

			//Alter history
			dataSet.add('xmpp',['roster', sFrom,'history'], [].concat(arr, h), true);

			this.chat.__aRequestData.youngest = arr[arr.length - 1];

			//Fill to top
			if (arr.length) {
				this.chat._response(arr, true);
			}

			this.chat._main.classList.add('newitem');
			this.chat._getAnchor('refresh').onclick = function(){
				this.__clearSearch();
			}.bind(this);

			if (dataSet.get('xmpp',['roster', sFrom,'history']).length){
				removecss(this._main, 'noitems');
			} else {
				addcss(this._main, 'noitems');
			}
		}
		removecss(this._main, 'loading');

	}.bind(this), [this.__request_id, this.__sJID]]);
};

_me._onclose = async function(b, e){
	await this.__clearSearch();
	if (b){
		if (e && e.keyCode==27)
			switch(parseInt(GWOthers.getItem('IM','esc'))){
				case 1:
					this._dock();
				case 0:
					return false;
			}
	}
	return true;
};

_me.__autoreopenCallback = async function(state, _, data) {
	if(state === 5 && (!gui.frm_main.im.__chats[data] || gui.frm_main.im.__chats[data]._destructed)) {
		this.__im = gui.frm_main.im;
		gui.frm_main.im.__chats[data] = this;
		this.__sJID = data;
		this.__show();
		if (this._docked) {
			var options = this._ondock();
			gui.frm_main.dock._add(this, options.title, options.css);
			this.__title();
			obj_popup.activeStack.remove(this);
			dataSet.add('xmpp',['roster',this.__sJID,'active'], true, true);
		} else {
			await this._createChat();
		}
		this._disobeyEvent('onstatechange', [this, '__autoreopenCallback']);
	}
};

_me.__autoreopen = function(data) {
	if (!data) {
		this._destruct();
	}
	this.__hide();
	gui.socket.xmpp._obeyEvent('onstatechange', [this, '__autoreopenCallback', [data]]);
};

_me.__storeAutoreopenData = function() {
	return this.__sJID;
};

_me._onbeforedetach = function(callback) {
	this.text.input.__initEditor('textarea');
	callback();
};