_me = frm_autoresponder.prototype;
function frm_autoresponder(){};

_me.__constructor = async function() {
	var me = this;

	//init buttons
	this.x_add._onclick = function(){
		var s = (this._parent.x_personality._value() || '').trim();

		if (!s) return;

		var aEmail = MailAddress.splitEmailsAndNames(s);
			s = MailAddress.createEmail(aEmail[0].name,aEmail[0].email);

		if (!s) return;

		//domains are unique
		var old = this._parent.x_persons._value();
		for(var i in old)
			if(old[i].person == s) return;

		this._parent.x_persons._add([{'person':s}]);

		this._parent.x_personality._value('');
		this._parent.x_personality._focus();
	};

	this.x_personality._onsubmit = function(){
		this._parent.x_add._onclick();
	};

	this.x_remove._onclick = function(){
		this._parent.x_persons._removeSelected();
	};

	this.u_respondbetweenfrom._ondateselect = this.u_respondbetweenfrom.input._onchange = function() {
		var from_date = me.u_respondbetweenfrom._value();
		var to_date = me.u_respondbetweento._value();
		if (to_date && from_date > to_date)
			me.u_respondbetweento._value(from_date);
	};

	this.u_respondbetweento._ondateselect = this.u_respondbetweento.input._onchange = function() {
		var from_date = me.u_respondbetweenfrom._value();
		var to_date = me.u_respondbetweento._value();
		if (from_date && from_date > to_date)
			me.u_respondbetweenfrom._value(to_date);
	};

	this.__init = true;
	this.x_respond._onchange = function() {
		var b = !this._value();

		var now = new IcewarpDate();
		var to = me.u_respondbetweento._value();
		if (arguments[1] === true && !me.__init && to && (to < now.format(IcewarpDate.JULIAN))) {
			me.u_respondbetweento._value(now.clone().add(7, 'days'));
		}
		if (0 in arguments) {
			me.__init = false;
		}

		me.u_respondperiod._disabled(b);

		me.x_subject._disabled(b);
		me.x_respondercontent._disabled(b);
		me.u_respondbetweenfrom._disabled(b);
		me.u_respondbetweento._disabled(b);

		//norespondfor
		me.x_respondperiod._disabled(b);
		me.x_persons._disabled(b);
		me.x_add._disabled(b);
		me.x_remove._disabled(b);
		me.x_personality._disabled(b);
	}

	this.x_respond._onchange();

	me.u_respondbetweenfrom._defaultEmptyLabel(getLang('COMMON::ALL'));
	me.u_respondbetweento._defaultEmptyLabel(getLang('COMMON::ALL'));
};

_me._value = function(aValues) {
	var i, tmp;
	if (Is.Defined(aValues)) {
		loadDataIntoFormOnAccess(this, aValues);
		this.__parseContent(aValues['VALUES']['u_respondercontent']);

		//u_norespondfor
		if (aValues['VALUES']['u_norespondfor']){
			tmp = [];
			var persons = aValues['VALUES']['u_norespondfor'].split("\n");

			for(i in persons)
				if (persons[i])
					tmp.push({'person':'<'+persons[i]+'>'});

			this.x_persons._add(tmp);
		}

		this.x_respond._value(aValues['VALUES']['u_respond']);
		this.x_respondperiod._checked(aValues['VALUES']['u_respond'] == 3);
	} else {
		var aReturn = {
			// u_respondonlyiftome: 1
		};
		storeDataFromForm(this, aReturn);
		aReturn['u_respondercontent'] = this.__getContent();

		aReturn.u_respond = 0;
		if (this.x_respond._value()) {
			aReturn.u_respond = 2;
			if (this.x_respondperiod._value()) {
				aReturn.u_respond = 3;
			}
		}

        //u_norespondfor
		var arr = [];
		tmp = this.x_persons._value();
		for(i in tmp)
			if (tmp[i].person)
				arr.push(tmp[i].person.trim());
		aReturn['u_norespondfor'] = arr.join("\n").replace(/[<>]/g,'');

		return aReturn;
	}
};

_me.__parseContent = function (sContent) {
	var aTmp = sContent.split("\n");
	var aRest = [];

	for (var i in aTmp){
		if (aTmp[i].substring(0,2) == '$$' && aTmp[i].substring(aTmp[i].length-2) == '$$') {
			var del,nam,val;
			del = aTmp[i].indexOf(' ',2);
			nam = aTmp[i].substring(2,del);
			val = aTmp[i].substring(del+1,aTmp[i].length - 2);
			switch (nam) {
				case 'setactualfrom':
					//this.x_from._value(val);
					break;

				case 'setsubject':
					this.x_subject._value(val);
					break;

				default:
					aRest.push(aTmp[i]);
					continue;
			}
		}
		else
			aRest.push(aTmp[i]);
	}

	this.x_respondercontent._value(aRest.join('\n'));
};

_me.__getContent = function () {
	var s2 = this.x_subject._value(),
		sResult = s2 ? '$$setsubject ' + s2 + '$$\n' : '';

	sResult += this.x_respondercontent._value();
	return sResult;
};