/***
 *
 *	!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
 *
 *	WE SHOULD USE elementFromPoint TO DETERMINATE Z-INDEX OF PROP:
 *		var element = document.elementFromPoint(x, y);
 *
 ***/

function cDnD(){
	storage.css('dragndrop');
	this.value;     	//draged data
	this.dropper = [];   //drop target object stock
	this.dndInitiator = null;
	this.masks = [];

	this.addoffset = 5;
};

/*
Main object methods:
 	_dragstart()
	_ondragend()

Target Object methods:
	_ondragover()
	_ondrop()
	_active_dropzone()


Drop data:
	type
    value
	originator
*/



/**
 * Registr drop objects
 **/
cDnD.prototype.registr_drop = function(obj, aType){
	if (typeof obj !='object' || !aType) return false;

	if (!this.dropper.some(function(dropper) {
		return dropper.obj === obj;
	})) {
		this.dropper.push({
			obj: obj,
			type: aType
		});
	}

	return true;
};

/**
 * @param aData Object
 * @param aData.type String
 * @param aData.value Object[]
 * @param aData.value.iid String
 * @param aData.value.type String
 * @param aData.value.name String
 * @param aData.value.icon String
 * @param aData.value.icon_type String
 * @param aData.value.size String
 * @param aData.value.folder String
 * @param aData.x Number
 * @param aData.y Number
 * @param aData.obj Object
 * @params:
 *	aData	- { type,arg,css,obj}
 *  x,y     - mouse coordinates
 **/
cDnD.prototype.create_drag = function (aData) {
	this.dndInitiator = aData.obj;

	if (typeof aData.type != 'string') return;

	if (this.eDiv) {
		this.eDiv.parentNode && this.eDiv.parentNode.removeChild(this.eDiv);
		this.eDiv = null;
	}
	this.eDiv = this.create_dragElement(aData.value);
	this.__gui = aData.obj ? aData.obj._gui : gui;
	this.__doc = this.__gui._main.ownerDocument;

	if (aData.x || gui.__X) {
		if (gui._rtl) {
			this.eDiv.style.right = this.__doc.body.clientWidth - ((aData.x || gui.__X) - this.addoffset) + 'px';
		} else {
			this.eDiv.style.left = ((aData.x || gui.__X) + this.addoffset) + 'px';
		}
	}
	if (aData.y || gui.__Y) {
		this.eDiv.style.top = ((aData.y || gui.__Y) + this.addoffset) + 'px';
	}

	this.value = aData;

	//Call object functions
	if (aData.obj){
		if (aData.obj._ondragstart)
			aData.obj._ondragstart(this.value);

		if (aData.obj._ondragover)
			aData.obj._ondragover(this.value);
	}

	this.__doc.body.appendChild(this.eDiv);

	if (aData.ctrlKey || aData.metaKey){
		this.__forceCtrl = true;
		addcss(this.eDiv, 'ctrl');
	}
	else{
		this.__forceCtrl = false;

		//EVENT HANDLERS
		this.__keydown = function (e){
			if (this.eDiv && (e.ctrlKey || e.metaKey))
				addcss(this.eDiv,'ctrl');

			this.value.ctrl = this.__forceCtrl || e.ctrlKey || e.metaKey;
		};
		this.__gui._obeyEvent('keydown',[this,'__keydown']);

		this.__keyup = function (e){
			if (this.eDiv && !e.ctrlKey && !e.metaKey)
				removecss(this.eDiv,'ctrl');

			this.value.ctrl = this.__forceCtrl || e.ctrlKey || e.metaKey;
		};
		this.__gui._obeyEvent('keyup',[this,'__keyup']);
	}

	//MOUSEMOVE
	var me = this;
	this.__mousemove = function(e){

		//Remove selections
		if (window.getSelection)
			window.getSelection().removeAllRanges();
		else
		if (me.__doc.selection)
			me.__doc.selection.empty();

		this.value.x = e.clientX;
		this.value.y = e.clientY;
		this.value.ctrl = this.__forceCtrl || e.ctrlKey || e.metaKey;

		if (gui._rtl) {
			this.eDiv.style.right = me.__doc.body.clientWidth - (e.clientX - this.addoffset)+'px';
		} else {
			this.eDiv.style.left = (e.clientX + this.addoffset)+'px';
		}
		this.eDiv.style.top = (e.clientY + this.addoffset)+'px';
	};
	this.__gui._obeyEvent('mousemove',[this,'__mousemove']);


	//MOUSEUP
	this.__mouseup = function(e){
		this.value.x = e.clientX;
		this.value.y = e.clientY;
		this.value.ctrl = this.__forceCtrl || e.ctrlKey || e.metaKey;

		this.remove_drag(e);
	};
	this.__gui._obeyEvent('mouseup',[this,'__mouseup']);

	this.active_drop(1);

	return this.eDiv;
};

cDnD.prototype.create_dragElement = function(aItems) {

	return mkElement('div', {
		className: 'dnd_element',
	}, false, [
		mkElement('div', {
			className: 'dnd_ico',
			textContent: ' '
		}),
		mkElement('div', {
			className: 'dnd_body'
		}, false, aItems.map(function(aItem) {
			return mkElement('div', {
				className: 'dnd_item ' + (aItem.type || (aItem.iid ? 'item' : 'folder'))
			}, false, [
				mkElement('div', {
					className: 'icon ' + (aItem.icon_type || (aItem.iid ? Item.getFileType(aItem.name) : '')),
					innerHTML: aItem.icon || ''
				}),
				mkElement('div', {
					className: 'info'
				}, false, [
					mkElement('div', {
						className: 'name',
						textContent: aItem.name || ''
					}),
					mkElement('div', {
						className: 'folder',
						textContent: aItem.folder || WMFolders.getFolderName(aItem)
					}),
					mkElement('div', {
						className: 'size',
						textContent: +aItem.size ? parseFileSize(aItem.size) : (aItem.size || '')
					})
				])
			]);
		}))
	]);
}

/**
 * Activate dropzones if defined in drop objects
 * @option: b - true for Active, false for Deactive
 **/
cDnD.prototype.active_drop = async function (b){
	
	//Clear old mask divs
	this.remove_masks();

	//Create dropping targets
	for (var dropper of this.dropper) {
		if (!~inArray(dropper.type, this.value.type) || dropper.obj._destructed) {
			continue;
		}

		try{
			var mask = '';

			// active_dropzone returns mask div or its created automatically inside _main element
			// _main element must be positioned relative|absolute
			if (dropper.obj._active_dropzone && (mask = await dropper.obj._active_dropzone(b?this.value:undefined)) === false)
				continue;

			if (b){

				if (!mask || !mask.parentNode){
					mask = mkElement('div',{className:'dropzone'});
					dropper.obj._main.appendChild(mask);
				}

				this.masks.push(mask);

				//Mask div handlers
				mask.onmouseout = mask.onmouseout || function(obj) {
					if (obj._ondragout)
						obj._ondragout(this.value);
				}.bind(this, dropper.obj);
				mask.onmouseleave = mask.onmouseleave || mask.onmouseout;

				mask.onmousemove = mask.onmousemove || function(obj, mask) {
					if (obj._ondragover)
						mask.style.cursor = obj._ondragover(this.value) == false?'not-allowed':'';
				}.bind(this, dropper.obj, mask);

				mask.onmouseup = mask.onmouseup || function(obj) {
					this.dndInitiator = null;
					this.value.target = obj;

					//call drop on target
					if (obj._ondrop)
						obj._ondrop(this.value);

					if (obj._ondragout)
						obj._ondragout(this.value);
				}.bind(this, dropper.obj);
			}
		} catch {
			//
		}
	};
};

/**
 * Remove dragged element, disable drop zones
 **/

cDnD.prototype.remove_drag = function (e){

	if (this.eDiv){

		this.__gui._disobeyEvent('mousemove',[this,'__mousemove']);
		this.__gui._disobeyEvent('mouseup',[this,'__mouseup']);
		this.__gui._disobeyEvent('keydown',[this,'__keydown']);
		this.__gui._disobeyEvent('keyup',[this,'__keyup']);

		//remove child
		try{
			this.eDiv.parentNode.removeChild(this.eDiv);
		}
		catch(er){ console.log(this._name||false,er);}

		//disable dropzones
		this.active_drop();
		
		if (this.value && this.value.obj) {
			if (this.value.obj._ondragout) {
				this.value.obj._ondragout(this.value);
			}
			if (this.value.obj._ondragend) {
				this.value.obj._ondragend(e, this.value);
			}
		}

		this.value = '';
	}

	this.eDiv = null;
};

cDnD.prototype.remove_masks = function(){
	this.masks = this.masks.filter(function(mask) {
		if (mask && mask.parentNode) {
			if (mask.keep) {
				mask.onmouseout = '';
				mask.onmousemove = '';
				mask.onmouseup = '';
				return true;
			} else {
				mask.parentNode.removeChild(mask);
			}
		}
	});
};
