/**
 * Class for querying and manipulating with emails already stored in mail folders.
 *
 * WARNING! Because of the instance is listening on dataset when you finish work and the instance
 * is no more needet you have to call this.dispose() function in order not to leak.
 *
 * @param	id			[aid, fid, iid]
 * @param	mailInfo	Optional. If you specify extended attributes no server query is proceeded.
 *
 * @see	OldMessage.send()
 * @see	OldMessage.forward()
 * @see OldMessage.reply()
 *
 * @see	OldMessage.getColor()
 * @see OldMessage.setColor()
 *
 * @see	this.dispose()
 */
function OldMessage() {};
OldMessage.prototype.init = async function(id, mailInfo, bSkipLinkify) {
	this.__id = id;
	this.__datasetItems = {};
	this.__mailInfo = {};

	// Listen on the dataset.
	// When the dataset is changed, function this.__update() is called.
	// Function this.__update() assures that OldMessage is always synchronized with dataset 'items'.
	// If in the dataset there is a message with 'id', private field this.__datasetItems is set pointing
	// to that. Otherwise the this.__datasetItems is left undefined.
	// @see	this.__update()
	dataSet.obey(this, null, 'items');

	// mailInfo is optional parameter. User can specify extended attributes of the message
	// when creating instance of class OldMessage which saves query to the server.

	if (mailInfo){
		this.__mailInfo = mailInfo;
	}
	else {
		try {
			this.__mailInfo = (await WMItems.list(
				{"aid": this.__id[0], "fid": this.__id[1], "iid": this.__id[2], "values": OldMessage.__FULLMAIL_VALUES_DANGER.concat(bSkipLinkify ? ['DONT_LINKIFY'] : [])}
			))[this.__id[0]][this.__id[1]][this.__id[2]];
			delete this.__mailInfo['/'];
		} catch {}
	}

	for (var k in this.__mailInfo)
		this.__datasetItems[k] = this.__mailInfo[k];
};

OldMessage.__FULLMAIL_VALUES = [
	'TO', 'FROM', 'SENDER', 'CLEAN_HTML', 'CC', 'BCC', 'SMS', 'REPLY_TO', 'ATTACHMENTS', 'FLAGS', 'HAS_ATTACHMENT', 'HAS_EMBEDDED_ATTACHMENT', 'PRIORITY', 'TAGS',
	'STATIC_FLAGS', 'SUBJECT', 'SMIME_STATUS', 'CONFIRM_ADDR', 'DATE', 'SIZE','CERTIFICATE','MESSAGE_ID','REFERENCES','IN_REPLY_TO','COLOR',
	'DEFERRED_DELIVERY', 'KEEP_SEEN'
];
OldMessage.__FULLMAIL_VALUES_DANGER = [
	'TO', 'FROM', 'SENDER', 'HTML', 'CC', 'BCC', 'SMS', 'REPLY_TO', 'ATTACHMENTS', 'FLAGS', 'HAS_ATTACHMENT', 'HAS_EMBEDDED_ATTACHMENT', 'PRIORITY', 'TAGS',
	'STATIC_FLAGS', 'SUBJECT', 'SMIME_STATUS', 'CONFIRM_ADDR', 'DATE', 'SIZE','CERTIFICATE','MESSAGE_ID','REFERENCES','IN_REPLY_TO',
	'REPLY_FULLPATH','FORWARD_FULLPATH','COLOR', 'KEEP_SEEN', 'DEFERRED_DELIVERY'
];
OldMessage.__TEXTMAIL_VALUES = [
	'TO', 'FROM', 'SENDER', 'TEXT', 'CC', 'BCC', 'SMS', 'REPLY_TO', 'ATTACHMENTS', 'FLAGS', 'HAS_ATTACHMENT', 'HAS_EMBEDDED_ATTACHMENT', 'PRIORITY', 'TAGS',
	'STATIC_FLAGS', 'SUBJECT', 'SMIME_STATUS', 'CONFIRM_ADDR', 'DATE', 'SIZE','CERTIFICATE','MESSAGE_ID','REFERENCES','IN_REPLY_TO','COLOR',
	'DEFERRED_DELIVERY'
];

OldMessage.source = function (id){
	WMItems.list({"aid": id[0], "fid": id[1], "iid": id[2], "values": ['SUBJECT','SOURCE', 'STATIC_FLAGS']},'', '', '',[async function(aData){
		if (aData && (aData = aData[id[0]]) && (aData = aData[id[1]]) && (aData = aData[id[2]])){
			if (aData.STATIC_FLAGS & 4 || aData.STATIC_FLAGS & 8 || aData.STATIC_FLAGS & 16 || aData.STATIC_FLAGS & 32) {
				return gui.notifier._value({type: 'alert', args: {header: '', text: 'ERROR::ACTION_DISABLED'}});
			}
			var frm = await gui._create('source','obj_popup','','frm_source');
				frm._title(aData.SUBJECT || getLang('POPUP_ITEMS::SOURCE'), true);
				frm._defaultSize(900,620);
				frm._ondock = function(){return {title: this._title(), css:'ico_frm_source'}};

				await frm._create('text','obj_text','main','obj_text100 noborder');
				frm.text._value(aData.SOURCE || '');
		}
	}]);
};

/**
 * aValues	- additional values, will be merged to newMessage
 *
 **/
OldMessage.edit = async function(id, aValues, bIsHTML) {
	var tmp_id,
		static_flags = ((await WMItems.list({
			aid: id[0],
			fid: id[1],
			iid: Is.Array(id[2]) ? id[2][0] : id[2],
			values: ['STATIC_FLAGS']
		}))[id[0]][id[1]][id[2]] || {}).STATIC_FLAGS;

	var cid,arr = gui._getChildObjects('main','frm_compose');
	for(var i in arr){
		if (arr[i].__message && (cid = arr[i].__message.__id || arr[i].__message.__id_chat) && cid[0]==id[0] && cid[1]==id[1] && cid[2]==(id[2].replace('|@@MAIN@@',''))){
			arr[i]._focus();
			return;
		}
	}

	try{
		var oldMessage = new OldMessage();
		await oldMessage.init(id, false, true);
		var newMessage = new NewMessage(id);
	}
	catch {
		return;
	}

	newMessage.sTo = oldMessage.getTo();
    newMessage.sRcp = newMessage.sFrom = oldMessage.getFrom();
	newMessage.sCc = oldMessage.getCc();
	newMessage.sBcc = oldMessage.getBcc();
	newMessage.sTeamchat = oldMessage.getTeamchat();
	newMessage.sComment = oldMessage.getComment();
	newMessage.sSMS = oldMessage.getSms();
	newMessage.sSubject = oldMessage.getSubject();
	newMessage.setHtml(oldMessage.isHtml(true));
	if(bIsHTML !== void 0) {
		newMessage.setHtml(bIsHTML);
	}
	newMessage.sBody = oldMessage.getBody();
	newMessage.aAttachments = oldMessage.copyAttachments(id);

	newMessage.iPriority = oldMessage.getPriority();
	newMessage.sDeferred = oldMessage.getDelay();
	newMessage.sBody = newMessage.sBody.replace(/"iw-deferred-([^"]+)"/g, newMessage.sDeferred ? '"iw-$1"' : '');
	newMessage.static_flags = static_flags;
	newMessage.sReplyTo = oldMessage.getReply();
	newMessage.bReadConfirmation = !!oldMessage.getConfirmAddress();
	newMessage.sSpellchecker = oldMessage.getSpellCheckerLanguage();
	newMessage.sSent = oldMessage.getSentFolder();
	newMessage.bSmart = oldMessage.__mailInfo.SMART_ATTACH === 'true';

	//inject aValues
	if (Is.Object(aValues))
		for(var k in aValues)
			newMessage[k] = aValues[k];

	oldMessage.dispose();

	if (WMFolders.getType([id[0],id[1]]) == 'M' && id[0]+'/'+id[1] != GWOthers.getItem('DEFAULT_FOLDERS', 'templates')){
		newMessage.onSentCallback.push([Item.remove, [makeIDSFromID(id), true, '', '', '']]);

		//Mark Answered/Forwarded FLAG to original message
		if (oldMessage.__mailInfo.REPLY_FULLPATH){
			tmp_id = Path.split(oldMessage.__mailInfo.REPLY_FULLPATH, false, true);
			tmp_id[2] = [tmp_id[2]];

			newMessage.onSentCallback.push([OldMessage.markAsAnswered, [tmp_id]]);
		}

		if (oldMessage.__mailInfo.FORWARD_FULLPATH){
			tmp_id = Path.split(oldMessage.__mailInfo.FORWARD_FULLPATH, false, true);
			tmp_id[2] = [tmp_id[2]];

			newMessage.onSentCallback.push([OldMessage.markAsForwarded, [tmp_id]]);
		}
	}

	var result = await gui._create('frm_compose', 'frm_compose', '', '', newMessage, void 0, {
		context: 'OldMessage',
		fun: ['edit'],
		args: [].slice.call(arguments)
	});

	result._newMessage = newMessage;

	return result;
};

OldMessage.forward = async function(oOptions) {
	var { id, bForwardAsMessage, bForwardResend, bIsHTML } = oOptions;

	var i;
	var oldMessageData = dataSet.get('preview', [id[0], id[1], Is.Array(id[2]) ? id[2][0] : id[2]]);
	try {
		var static_flags = (oldMessageData || (await WMItems.list({aid: id[0], fid: id[1], iid: Is.Array(id[2]) ? id[2][0] : id[2], values: ['STATIC_FLAGS']}))[id[0]][id[1]][id[2]] || {}).STATIC_FLAGS;
		if (static_flags & 8) {
			return gui.notifier._value({type: 'alert', args: {header: '', text: 'ERROR::ACTION_DISABLED'}});
		}
	} catch {}
	try{
		var newMessage = new NewMessage(),
			oldMessage = [], old;

		if (Is.Array(id[2])){
			for(i in id[2]) {
				old = new OldMessage();
				await old.init([id[0],id[1],id[2][i]]);
				oldMessage.push(old);
			}
		}
		else{
			old = new OldMessage();
			await old.init(id, oldMessageData);
			oldMessage.push(old);

			//FORWARD X-HEADER
			if (WMFolders.getType(id[0],id[1]) =='M')
				newMessage.oHeaders['X-Forward-Fullpath'] = id[0] +'/'+ id[1] +'/'+ WMItems.__serverID(id[2]);
		}
	}
	catch{
		return;
	}

	if (!Is.Defined(bForwardAsMessage) || bForwardAsMessage === false) {

		await storage.library('gw_others');
		bForwardAsMessage = (GWOthers.getItem('MAIL_SETTINGS_GENERAL', 'forward_messages') != 'inline');

		//RFC 2822
		if (oldMessage[0].__mailInfo.REFERENCES)
			newMessage.sReferences = oldMessage[0].__mailInfo.REFERENCES.trim();
		else
		if (oldMessage[0].__mailInfo.IN_REPLY_TO)
			newMessage.sReferences = oldMessage[0].__mailInfo.IN_REPLY_TO.split("\n").shift().trim() || '';

		if (oldMessage[0].__mailInfo.MESSAGE_ID){
			newMessage.sIn_Reply_To = oldMessage[0].__mailInfo.MESSAGE_ID.trim();
			newMessage.sReferences = (newMessage.sReferences?newMessage.sReferences+"\r\n\t":'') + newMessage.sIn_Reply_To;
		}
	}

	if (bForwardResend) {
		newMessage.sSubject = oldMessage[0].getSubject();
		newMessage.sTo = oldMessage[0].getTo();
	} else {
		newMessage.sSubject = OldMessage.__prefixParser(oldMessage[0].getSubject(), 'Fw');
	}

	if (bForwardAsMessage) {
		newMessage.aAttachments = { attachments: [] };
		for(i in oldMessage) {
			newMessage.aAttachments.attachments.push({
				values: {
					class: 'message',
					fullpath: id[0] + '/' + id[1] + '/' + WMItems.__serverID(oldMessage[i].__id[2]),
					name: oldMessage[0].getSubject() + '.eml',
					size: oldMessage[i].getSize()
				}
			});
		}
	}
	else {
		if (bForwardResend)
			newMessage.sBody = oldMessage[0].getBody();
		else
			newMessage.sQuote = await oldMessage[0].quoteMessage(getLang('EMAIL::FORWARD_MESSAGE_HTML'));
		newMessage.aAttachments = oldMessage[0].copyAttachments(id);
		// newMessage.setHtml(oldMessage[0].isHtml(true));
		newMessage.setHtml(true);
	}

	if(bIsHTML !== void 0) {
		newMessage.setHtml(bIsHTML);
	}

	// if (!bForwardResend)
	// 	newMessage.addSignature();

	//if not embanded email
	var tmp_id = [oldMessage[0].__id[0],oldMessage[0].__id[1],[]];
	for (i in oldMessage){
		if (oldMessage[i].__id[2].indexOf('|')<0)
			tmp_id[2].push(oldMessage[i].__id[2]);

		newMessage.onDisposeCallback.push([oldMessage[i], oldMessage[i].dispose]);
	}

	if (tmp_id[2].length)
		newMessage.onSentCallback.push([OldMessage.markAsForwarded, [tmp_id]]);

	newMessage._bIsForwarding = true;
	return await gui._create('frm_compose', 'frm_compose', '', '', newMessage, oldMessage[0], {
		context: 'OldMessage',
		fun: ['forward'],
		args: [].slice.call(arguments),
		bForwardResend: bForwardResend
	});
};

OldMessage.prototype.quoteMessage = async function(sLabel, bReply) {
	if (bReply && (GWOthers.getItem('MAIL_SETTINGS_DEFAULT', 'include_original_when_replying') != 1)) {
		return '';
	}

	var sBody = '';
	if (this.isHtml()){

		//Base tag (it should be moved into .getBase())
		var sBase = this.getBase();
		if (sBase){
		    var sBase2 = document.location.protocol +'//'+ document.location.hostname+'/',
				div = mkElement('div');
		        div.innerHTML = this.getBody();

			//links
			var elms = div.getElementsByTagName('a');
		    for(var i = elms.length-1; i>=0; i--)
				if (elms[i].href && elms[i].href.toLowerCase().indexOf(sBase2) === 0)
					elms[i].href = sBase + elms[i].href.substr(sBase2.length);

			//images
			elms = div.getElementsByTagName('img');
		    for(i = elms.length-1; i>=0; i--)
				if (elms[i].src && elms[i].src.toLowerCase().indexOf(sBase2) === 0)
					elms[i].src = sBase + elms[i].src.substr(sBase2.length);

			sBody = div.innerHTML;
			div = null;
		}
		else
			sBody = this.getBody();
	}
	else
		sBody = this.getBody();

	var aTo = MailAddress.splitEmailsAndNames(this.getTo());

	return NewMessage.crlf + await (new cTemplate()).tmp('obj_mailview_quote',{
		html: this.isHtml(),
		label: sLabel || getLang('EMAIL::REPLY_MESSAGE_HTML'),
		from: OldMessage._parseRcp(this.getFrom()),
		to: OldMessage._parseRcp(this.getTo()),
		cc: OldMessage._parseRcp(this.getCc()),
		date: (new IcewarpDate(parseInt(this.getDate())*1000)).format('L LT'),
		subject: this.getSubject(),
		short: bReply && aTo.length === 1 && aTo[0].email === sPrimaryAccount?sPrimaryAccount:'',
		body: sBody
	});

};


OldMessage.replyTemplate = async function(id, bReplyToAll){
	var f = Path.split(GWOthers.getItem('DEFAULT_FOLDERS','templates')),
		frm = await gui._create('template','frm_insert_item','','frm_insert_item_nobottomdiv',[
		function(aPath){
			if ((aPath = aPath[0]))
				OldMessage.reply({
					id,
					bReplyToAll,
					aTemplate: [aPath.aid,aPath.fid,aPath.id]
				});
		}],
		f[0],f[1],'M','',true);

		frm._title('COMPOSE::TEMPLATE');
};

OldMessage.reply = async function(oOptions) {
	var { id, bReplyToAll, aTemplate, bSkipCreateComposeWindow, bIsHTML, bCopyAttachments, ChatGPTOptions, wWindow } = oOptions;


	var iid = Is.Array(id[2]) ? id[2][0] : id[2];
	var oldMessageData = dataSet.get('preview', [id[0], id[1], iid]);
	try {
		var static_flags = (oldMessageData || ((await WMItems.list({aid: id[0], fid: id[1], iid: iid, values: ['STATIC_FLAGS']}))[id[0]][id[1]][iid] || {})).STATIC_FLAGS;
		if (static_flags & 16) {
			return gui.notifier._value({type: 'alert', args: {header: '', text: 'ERROR::ACTION_DISABLED'}});
		}
	} catch {}

	try{
		var oldMessage = new OldMessage();
		await oldMessage.init(id, oldMessageData);
		var newMessage = new NewMessage();
		if (aTemplate) {
			var oldTemplate = new OldMessage();
			await oldTemplate.init(aTemplate);
		}
	}
	catch{
		return;
	}

	newMessage.sRcp = OldMessage.__extractMail(oldMessage.getTo(), sPrimaryAccount);

	if (bReplyToAll) {
		var sTo = oldMessage.getReply(),
            sMy = MailAddress.splitEmailsAndNames(id[0])[0].email.toLowerCase(),
            aAlias = dataSet.get('storage',['ALIASES','ITEMS']),
			aEx = [];

		for(var i in aAlias)
			if (aAlias[i].VALUES.EMAIL.VALUE.toLowerCase() != sMy)
            	aEx.push(aAlias[i].VALUES.EMAIL.VALUE.toLowerCase());

		newMessage.sTo = OldMessage.__extractMail((sTo?sTo+', ':'') + oldMessage.getTo(), sMy, aEx) || sTo;
		newMessage.sCc = OldMessage.__extractMail(oldMessage.getCc(), sMy);
		newMessage.sBcc = OldMessage.__extractMail(oldMessage.getBcc());
	}
	else{

		newMessage.sTo = oldMessage.getReply();

		if (sPrimaryAccountSMS && ((GWOthers.getItem('RESTRICTIONS', 'disable_sms') || 0)<1)){
	        var aMails = MailAddress.splitEmailsAndNames(newMessage.sTo);
			if (aMails && aMails[0] && aMails[0].email && (aMails[0].email = aMails[0].email.replace(/"/g,'')) && aMails[0].email.indexOf('sms:')===0){

				var num = /sms:([+0-9]+)@/g.exec(aMails[0].email);
				if (num && (num = num[1]) && num!=aMails[0].name)
					newMessage.sSMS = MailAddress.createEmail(aMails[0].name,num);
				else
					newMessage.sSMS = MailAddress.createEmail('',aMails[0].name);

				newMessage.sTo = '';
			}
		}
	}

	if (!newMessage.sSMS){

		newMessage.sSubject = OldMessage.__prefixParser(oldMessage.getSubject(), 'Re');
		newMessage.sQuote = await oldMessage.quoteMessage(getLang('EMAIL::REPLY_MESSAGE_HTML'), true);

		if (oldTemplate){
			//Body
			// newMessage.setHtml(oldMessage.isHtml(true) || oldTemplate.isHtml(true));
			newMessage.setHtml(true);

			var b = mkElement('div');
				b.innerHTML = oldTemplate.getBody();

			newMessage.sTemplate = b.innerHTML || '';
			newMessage.sBody = newMessage.sBody || '';

			if (document.getElementsByClassName){
				//Remove first signature
				var elm = b.getElementsByClassName('iw-signature');
				if (elm && (elm = elm[0]))
					elm.parentNode.removeChild(elm);

				// newMessage.addSignature();
			}
			// else
			// if (oldTemplate.getBody().indexOf('<div class="iw-signature">')<0)
			// 	newMessage.addSignature();

			//Attachments
			newMessage.aAttachments = oldTemplate.copyAttachments(aTemplate);
		}
		else{
			// newMessage.setHtml(oldMessage.isHtml(true));
			newMessage.setHtml(true);
			// newMessage.addSignature();
		}

		//Forward with attachments
		if (bCopyAttachments)
			newMessage.aAttachments = oldMessage.copyAttachments(id);

		newMessage.addvCard();
	}

	if(bIsHTML !== void 0) {
		newMessage.setHtml(bIsHTML);
	}

	//RFC 2822
	if (oldMessage.__mailInfo.REFERENCES)
		newMessage.sReferences = oldMessage.__mailInfo.REFERENCES.trim();
	else
	if (oldMessage.__mailInfo.IN_REPLY_TO)
		newMessage.sReferences = oldMessage.__mailInfo.IN_REPLY_TO.split("\n").shift().trim() || '';

	if (oldMessage.__mailInfo.MESSAGE_ID){
		newMessage.sIn_Reply_To = oldMessage.__mailInfo.MESSAGE_ID.trim();
		newMessage.sReferences = (newMessage.sReferences?newMessage.sReferences+"\r\n\t":'') + newMessage.sIn_Reply_To;
	}

	//if not embanded email
	if (id[2].indexOf('|')<0)
		newMessage.onSentCallback.push([oldMessage, oldMessage.setAnswered]);

	newMessage.onDisposeCallback.push([oldMessage, oldMessage.dispose]);

	//REPLY X-HEADER
	newMessage.oHeaders['X-Reply-Fullpath'] = id[0] +'/'+ id[1] +'/'+ WMItems.__serverID(id[2]);

	var result = {};
	if (!bSkipCreateComposeWindow) {
		newMessage._bIsReplying = true;
		result = await gui._create('frm_compose', 'frm_compose', '', '', newMessage, oldMessage, {
			context: 'OldMessage',
			fun: ['reply'],
			args: [].slice.call(arguments)
		}, ChatGPTOptions);
		if (wWindow) {
			setTimeout(function() {
				result._detach(wWindow);
			}, 5);
		}
	}
	result._oldMessage = oldMessage;
	result._newMessage = newMessage;

	return result;
};

OldMessage.replyAllNew = async function(id) {
	try{
		var oldMessage = new OldMessage();
		await oldMessage.init(id, dataSet.get('preview', [id[0], id[1], Is.Array(id[2]) ? id[2][0] : id[2]]));
		var newMessage = new NewMessage();
	} catch{ return; }

	newMessage.sRcp = OldMessage.__extractMail(oldMessage.getTo(), sPrimaryAccount);

	var sTo = oldMessage.getReply(),
		sMy = MailAddress.splitEmailsAndNames(id[0])[0].email.toLowerCase(),
		aAlias = dataSet.get('storage',['ALIASES','ITEMS']),
		aEx = [];

	for(var i in aAlias)
		if (aAlias[i].VALUES.EMAIL.VALUE.toLowerCase() != sMy)
			aEx.push(aAlias[i].VALUES.EMAIL.VALUE.toLowerCase());

	newMessage.sTo = OldMessage.__extractMail((sTo ? sTo + ', ' : '') + oldMessage.getTo(), sMy, aEx) || sTo;
	newMessage.sCc = OldMessage.__extractMail(oldMessage.getCc(), sMy);
	newMessage.sBcc = OldMessage.__extractMail(oldMessage.getBcc());

	var result = await gui._create('frm_compose', 'frm_compose', '', '', newMessage, oldMessage, {
		context: 'OldMessage',
		fun: ['reply'],
		args: [].slice.call(arguments)
	});
	result._oldMessage = oldMessage;
	result._newMessage = newMessage;

	return result;
};

OldMessage.__extractMail = function(sMails, sExtract, aExtract) {
	if (!sMails || !sExtract) return sMails;
		sExtract = sExtract.toLowerCase();

		var	addr = MailAddress.splitEmailsAndNames(sMails),
			out = [], bSkip = false;

		for (var i = 0, j = addr.length;i<j;i++)
		    if (sExtract == addr[i].email.toLowerCase())
		        bSkip = true;
			else
				out.push(MailAddress.createEmail(addr[i].name,addr[i].email));

		if (!bSkip && aExtract && aExtract.length>0){
            out  = [];
			for (i = 0, j = addr.length;i<j;i++)
			    if (inArray(aExtract,addr[i].email.toLowerCase())<0)
					out.push(MailAddress.createEmail(addr[i].name,addr[i].email));
		}

		return out.join(', ');
};

OldMessage.redirect = async function(id) {
	var frm = await gui._create('frm_addaddress', 'frm_addaddress', '', '', [OldMessage.__redirect, [id]],
		{'to': "DATAGRID_ITEMS_VIEW::TO"}, {}, 'to', true
	);

	frm.x_btn_ok._onclick = function(){
		this._parent.__hide();
		this._parent.__ok = true;
		this._parent._onclose();
	};
};

OldMessage.whitelistSender = function(ids, cList, iNext) {
	var senders = ids[2].map(function(iid) {
		var sender = dataSet.get('items', [ids[0], ids[1], iid, 'FROM']);
		return sender && (MailAddress.splitEmailsAndNames(sender)[0] || {}).email;
	}).filter(Boolean).filter(function(v, i, a) {
		return a.indexOf(v) === i;
	}).join(', ');
	gui._create('frm_confirm', 'frm_confirm', '', '', [OldMessage.__blackOrWhiteList, [ids, true, false, cList, iNext]],
		'CONFIRMATION::WHITELIST_SENDER_CONFIRMATION', 'CONFIRMATION::WHITELIST_SENDER', ['<b>' + senders.escapeHTML() + '</b>']
	);
};

OldMessage.blacklistSender = function(ids, cList, iNext) {
	var senders = ids[2].map(function(iid) {
		var sender = dataSet.get('items', [ids[0], ids[1], iid, 'FROM']);
		return sender && (MailAddress.splitEmailsAndNames(sender)[0] || {}).email;
	}).filter(Boolean).filter(function(v, i, a) {
		return a.indexOf(v) === i;
	}).join(', ');
	gui._create('frm_confirm', 'frm_confirm', '', '', [OldMessage.__blackOrWhiteList, [ids, false, false, cList, iNext]],
		'CONFIRMATION::BLACKLIST_SENDER_CONFIRMATION', 'CONFIRMATION::BLACKLIST_SENDER', ['<b>' + senders.escapeHTML() + '</b>']
	);
};

OldMessage.whitelistDomain = function(ids) {
	var domains = ids[2].map(function(iid) {
		var sender = dataSet.get('items', [ids[0], ids[1], iid, 'FROM']);
		sender = sender && (MailAddress.splitEmailsAndNames(sender)[0] || {}).email;
		return sender && sender.split('@').pop();
	}).filter(Boolean).filter(function(v, i, a) {
		return a.indexOf(v) === i;
	}).join(', ');
	gui._create('frm_confirm', 'frm_confirm', '', '', [OldMessage.__blackOrWhiteList, [ids, true, true]],
		'CONFIRMATION::WHITELIST_SENDER_CONFIRMATION', 'CONFIRMATION::WHITELIST_DOMAIN', ['<b>' + domains.escapeHTML() + '</b>']
	);
};

OldMessage.blacklistDomain = function(ids) {
	var domains = ids[2].map(function(iid) {
		var sender = dataSet.get('items', [ids[0], ids[1], iid, 'FROM']);
		sender = sender && (MailAddress.splitEmailsAndNames(sender)[0] || {}).email;
		return sender && sender.split('@').pop();
	}).filter(Boolean).filter(function(v, i, a) {
		return a.indexOf(v) === i;
	}).join(', ');
	gui._create('frm_confirm', 'frm_confirm', '', '', [OldMessage.__blackOrWhiteList, [ids, false, true]],
		'CONFIRMATION::BLACKLIST_SENDER_CONFIRMATION', 'CONFIRMATION::BLACKLIST_DOMAIN', ['<b>' + domains.escapeHTML() + '</b>']
	);
};

OldMessage.deliver = function(ids) { OldMessage.__quarantineAction(ids, 'deliver') };
OldMessage.whitelist = function(ids) {
	OldMessage.__quarantineAction(ids, 'whitelist');
	if (gui.notifier)
		gui.notifier._value({type: 'sender_whitelisted'});
};
OldMessage.blacklist = function(ids) {
	OldMessage.__quarantineAction(ids, 'blacklist');
	if (gui.notifier)
		gui.notifier._value({type: 'sender_blacklisted'});
};
OldMessage.__quarantineAction = function(ids, sAction){
	Item.__removeFromDataset(ids);
	WMItems.quarantine({'aid': ids[0], 'fid': ids[1], 'iid': ids[2], 'action': sAction}, 'items', '', 'folders');
};

/**
 * @param	id			[aid, fid, iid]
 * @param	sColor		OldMessage.RED .. OldMessage.CLEAR
 */
OldMessage.setColor = function(ids, sColor) {

	//Multiple
	if (!Is.Array(ids[2]))
		ids[2] = [ids[2]];

	for(var id, sOldColor, i = 0; i<ids[2].length; i++){

		id = [ids[0],ids[1],ids[2][i]];
		sOldColor = OldMessage.getColor(id);

		if (!sOldColor || sOldColor != sColor) {

			dataSet.add('items', id.concat(['COLOR']), sColor);

			// Perform and refresh mailview
			WMItems.add(id, {'values': {'COLOR': sColor}}, 'items','','',[function(bOK){
				if (bOK) {
					if(dataSet.get('preview', id)) {
						dataSet.add('preview', id.concat(['COLOR']), sColor);
					}
				} else {
					dataSet.add('items', id.concat(['COLOR']), sOldColor);
				}
			}]);
		}
	}

};

OldMessage.getColor = function(id) { return dataSet.get('items', id.concat(['COLOR'])) };

OldMessage.open = async function(id) {
	if (dataSet.get('preview', id)) {
		return;
	}

	if (gui.frm_main.main.mailview && (gui.frm_main.main.mailview.__aid !== id[0] || gui.frm_main.main.mailview.__fid === id[1] || gui.frm_main.main.mailview.__iid !== id[2])) {
		gui.frm_main.main.mailview._value();
	}

	dataSet.add('active_items', [id[0],id[1]], id[2]);
	var def_val;
	if ((GWOthers.getItem('MAIL_SETTINGS_GENERAL','show_inline_images') || 0)<1 || (dataSet.get('main',['spam_path']) == id[0]+'/'+id[1] && (GWOthers.getItem('MAIL_SETTINGS_GENERAL','show_images') || 0)<1))
		def_val = OldMessage.__FULLMAIL_VALUES;
	else
		def_val = OldMessage.__FULLMAIL_VALUES_DANGER;

	if (WMFolders.getType(id) == 'M'){
		//if you try to open email which is unavailable already
		try{
			var message = new OldMessage();
			await message.init(id, {});

			if (OldMessage.__openXHR) {
				OldMessage.__openXHR.onabort = void 0;
				OldMessage.__openXHR.abort();
			}
			// Async list item (refresh mailview) and refresh folders (folder tree)
			OldMessage.__openXHR = await WMItems.list({"aid": id[0], "fid": id[1], "iid": id[2], "values": def_val, "custom_values": {KEEP_SEEN: !((WMFolders.getRights(id, 'write') || WMFolders.getRights(id, 'owner')) && GWOthers.getItem('MAIL_SETTINGS_GENERAL', 'mark_as_read') > 0 && GWOthers.getItem('MAIL_SETTINGS_GENERAL', 'mark_as_read_delay') == 0)}},'preview', '', 'folders', [OldMessage.__mailviewCallback, [message, message.hasFlag('SEEN')]]);
		}
		catch(er){ console.log(this._name||false,er)}
	}
	else
		WMItems.list({"aid": id[0], "fid": id[1], "iid": id[2], "values": def_val},'preview', '', 'folders');
};

OldMessage.delivery_report = function(id) {
	gui._create('frm_delivery', 'frm_delivery', '','', id);
};

OldMessage.openwindow = function(id, aSortInfo, aLockInfo, bIsHTML) {

	//Focus already opened email
	var frms = gui._getChildObjects('main','frm_mail');
	if (frms.length)
		for (var i = frms.length-1; i>=0; i--)
			if (Is.Array(frms[i].__id) && arrayCompare(frms[i].__id, id)){
				frms[i]._focus();
				return;
			}

	gui._create('frm_mail', 'frm_mail', '','', id, aSortInfo, aLockInfo, bIsHTML);
};

OldMessage.markWithFlag = function(ids,aFlags,bUpdFolders) {
	WMItems.setFlag({"aid": ids[0], "fid": ids[1], "iid": ids[2]}, aFlags, 'items', bUpdFolders?'folders':'');
};

OldMessage.markAsRead = async function(ids) {
	if (ids[2].length === 1) {
		var aData = dataSet.get('items', [ids[0], ids[1], ids[2][0]]);
		var writeRight = WMFolders.getRights(ids, 'write') || WMFolders.getRights(ids, 'owner');
		if (!aData || !writeRight) {
			return;
		}
		var flags = aData.FLAGS;
		if (!flags || (flags & 32)) {
			return;
		}
		OldMessage.markWithFlag(ids, {SEEN: true}, true);
		var data = WMItems.list({
			aid: ids[0], 
			fid: ids[1], 
			iid: ids[2][0],
			values: ['FLAGS', 'CONFIRM_ADDR', 'KEEP_SEEN'],
			custom_values: { KEEP_SEEN: true }
		});
		data = ((data[ids[0]] || {})[ids[1]] || {})[ids[2][0]];
		if (!data || !data.CONFIRM_ADDR) {
			return;
		}
		var old;
		switch(GWOthers.getItem('READ_CONFIRMATION', 'send_confirmation') || '0') {
			case '0': // Ask
				old = new OldMessage();
				await old.init([ids[0], ids[1], ids[2][0]], {});
				var tmp = await gui._create('msg_read_confirm', 'frm_confirm', '', '',
					[OldMessage.__createReadingConfirmation, [old]],
					'CONFIRMATION::CREATE_READING_CONFIRMATION_TITLE',
					'CONFIRMATION::CREATE_READING_CONFIRMATION'
				);
				tmp._modal(false);
				tmp.x_btn_ok._value('COMMON::YES');
				tmp.x_btn_cancel._value('COMMON::NO');
				break;
			case '1': // Send without asking
				old = new OldMessage();
				old.init([ids[0], ids[1], ids[2][0]], {});
				OldMessage.__createReadingConfirmation(old);
		}
	} else {
		OldMessage.markWithFlag(ids, {SEEN: true}, true);
	}
};

OldMessage.markAsUnread = function(ids) {
	OldMessage.markWithFlag(ids,{'SEEN': false},true);
};
OldMessage.markAsForwarded = function(ids) {
	OldMessage.markWithFlag(ids,{'FORWARDED':true},false);
};
OldMessage.markAsAnswered = function(ids) {
	OldMessage.markWithFlag(ids,{'ANSWERED':true},false);
};


OldMessage.__blackOrWhiteList = function(ids, bWhitelist, bDomain, cList, iNext) {
	var sFolder = bWhitelist?'SPAM_QUEUE/Whitelist':'SPAM_QUEUE/Blacklist';

	for (var i in ids[2]) {
		// Get sender email of item
		var sender = dataSet.get('items', [ids[0], ids[1], ids[2][i], 'FROM']);
		if (!sender || !(sender = MailAddress.splitEmailsAndNames(sender))) continue;
		sender = sender[0]['email'];
		// Black/Whitelist whole domain
		if(bDomain)
			sender = sender.split("@")[1];
		// Send request
		WMItems.add([sPrimaryAccount, sFolder], {'values': {'EMAIL': sender}}, 'items');
	}

	// Get SPAMbox
	var sSpam = Path.split(dataSet.get('main',['spam_path'])).pop();
	if (sSpam){
		// Move to Inbox
		if (bWhitelist && ids[1] == sSpam)
			Item.__copyOrMoveItems(sPrimaryAccount, 'INBOX', 'move', ids, cList, iNext);
		else
		// Move to Spam
		if (!bWhitelist && ids[1] != sSpam){
			if (!dataSet.get('folders',[sSpam]))
				dataSet.add('folders',[sSpam],{'TYPE':'M','RIGHTS':'rw','NAME':getLang('COMMON_FOLDERS::SPAM'),'ACCESS':'rwmd'});

			Item.__copyOrMoveItems(sPrimaryAccount, sSpam, 'move', ids, cList, iNext);
		}
	}

	// Confirm black/whitelisting
	if (gui.notifier) {
		if(bWhitelist) {
			gui.notifier._value({type: 'sender_whitelisted'});
		} else {
			gui.notifier._value({type: 'sender_blacklisted'});
		}
	}
};

OldMessage.__mailviewCallback = async function(message, bPrevSeen, mailInfo) {

	if (message && mailInfo){
		var aData = ((mailInfo[message.__id[0]] || {})[message.__id[1]] || {})[message.__id[2]];
		if (!aData) {
			return;
		}
		message.__synchronizeFlags(aData);
		if (!bPrevSeen && message.hasFlag('SEEN') && (!message.__id || GWOthers.getItem('DEFAULT_FOLDERS', 'drafts') != [message.__id[0],message.__id[1]].join('/')) && message.getConfirmAddress()){

			if (gui.msg_read_confirm)
				await gui.msg_read_confirm._destruct();

			switch(GWOthers.getItem('READ_CONFIRMATION','send_confirmation') || '0') {
				case '0': // Ask
					var tmp = await gui._create('msg_read_confirm', 'frm_confirm', '', '',
						[OldMessage.__createReadingConfirmation, [message]],
						'CONFIRMATION::CREATE_READING_CONFIRMATION_TITLE',
						'CONFIRMATION::CREATE_READING_CONFIRMATION'
					);
					tmp._modal(false);
					tmp.x_btn_ok._value('COMMON::YES');
					tmp.x_btn_cancel._value('COMMON::NO');
					break;
				case '1': // Send without asking
					OldMessage.__createReadingConfirmation(message);
			}
			// Otherwise '2' - do not send confirmation
		}
		else
			message.dispose();
	}
	return;
};

OldMessage.prototype.__synchronizeFlags = function(mailInfo) {

	this.__mailInfo = mailInfo;
	var datasetItems = this.__datasetItems;

	function testAndSet(sItemName) {
		if (mailInfo && (datasetItems[sItemName] != mailInfo[sItemName])) {
			datasetItems[sItemName] = mailInfo[sItemName];
			return true;
		}
		return false;
	}

	var bChanged = false;
	bChanged |= testAndSet('FLAGS');

	if (bChanged && dataSet.get('active_folder') === mailInfo.aid + '/' + mailInfo.fid) {
		var include_ids = dataSet.get('temp', ['includeIds']) || [];
		include_ids.push(datasetItems.iid);
		dataSet.add('temp', ['includeIds'], include_ids);
		dataSet.update('temp', ['includeIds']);
	}

	bChanged |= testAndSet('HAS_ATTACHMENT');
	bChanged |= testAndSet('SMIME_STATUS');
	bChanged |= testAndSet('PRIORITY');

	if (bChanged && dataSet.get('items', this.__id))
		dataSet.update('items', this.__id);
};


OldMessage.__redirect = function(bOK, aAddresses, id, eForm) {
	if (bOK && eForm && aAddresses && aAddresses['to'].length) {
		var aMessageInfo = {"aid": id[0], "fid": id[1], "iid": id[2]};
		var aResult = MailAddress.findDistribList({'to': aAddresses['to'].join(', ')});
		for (var sTag in aResult)
			aMessageInfo[sTag] = aResult[sTag];

		WMItems.redirect(aMessageInfo, 'dummy','',[OldMessage.__redirect_result,[eForm]]);
	}
};

OldMessage.__redirect_result = function(eForm,aError){

	eForm.__ok = false;

	if (aError){
		eForm.__show();
		if (aError[0])
			gui.notifier._value({type: 'alert', args: {header: 'ALERTS::'+aError[0].toUpperCase(), text_plain: aError[1]}});
		else
			gui.notifier._value({type: 'alert', args: {header: '', text_plain: aError[1]}});
	}
	else{
		eForm._destruct();

		if (gui.notifier)
			gui.notifier._value({type: 'message_redirected'});
	}
};

/**
 * read confirmation
 **/
OldMessage.__createReadingConfirmation = function(oldMessage) {

	function setMessageVariables(sText, oldMessage) {

		var date = new IcewarpDate(oldMessage.getDate() * 1000, {locale: 'en'}),
			//sdate = date.toGMTString().escapeHTML(),
			sdate = date.format('rfc2822'),
			from = oldMessage.getFrom() ? oldMessage.getFrom().escapeHTML() : '',
			to = oldMessage.getTo() ? oldMessage.getTo().escapeHTML() : '',
			subject = oldMessage.getSubject() || '';

		sText = sText.replace(/\n/g,"<br />").replace(/%FROM%/g, from).replace(/%TO%/g, to).replace(/%DATE%/g, sdate).replace(/%SUBJECT%/g, subject);

		//FormatDateTime parsing
		sText = sText.replace(/%FormatDateTime ([^%]+)[^%]*%/gm, function($0,$1){ return date.format($1) });

		return sText;
	}

	var newMessage = new NewMessage();

//	newMessage.sFrom = getPrimaryAccountFromAddress();//oldMessage.getTo();
	newMessage.sTo = oldMessage.getConfirmAddress() || oldMessage.getFrom();
	newMessage.sSubject = setMessageVariables(GWOthers.getItem('READ_CONFIRMATION', 'subject'), oldMessage);
	newMessage.sBody = setMessageVariables(GWOthers.getItem('READ_CONFIRMATION', 'text'), oldMessage);

	oldMessage.dispose();

	newMessage.send(false,'',{'read_confirmation':false,'priority':4});
};

OldMessage.prototype.getFrom = function() {
	return this.__toString(this.__datasetItems.FROM).trim();
};
OldMessage.prototype.getCc = function() {
	return this.__toString(this.__datasetItems.CC).trim();
};
OldMessage.prototype.getBcc = function() {
	return this.__toString(this.__datasetItems.BCC).trim();
};
OldMessage.prototype.getTeamchat = function() {
	return this.__toString(this.__mailInfo.TEAMCHAT).trim();
};
OldMessage.prototype.getComment = function() {
	return this.__toString(this.__mailInfo.TEAMCHAT_COMMENT).trim();
};
OldMessage.prototype.getTo = function() {
	return this.__datasetItems.TO === '"undisclosed-recipients:"' ? '' : this.__toString(this.__datasetItems.TO).trim();
};

OldMessage.prototype.getReply = function() {
	if (this.__mailInfo.REPLY_TO)
		return this.__toString(this.__mailInfo.REPLY_TO).trim();
	else
		return this.getFrom();
};
OldMessage.prototype.getSubject = function() { return this.__toString(this.__datasetItems.SUBJECT) };
OldMessage.prototype.getFlags = function() { return this.__datasetItems.FLAGS };
OldMessage.prototype.getDate = function() { return this.__datasetItems.DATE };
OldMessage.prototype.getSize = function() { return this.__datasetItems.SIZE };

OldMessage.prototype.hasAttachments = function() { return (this.__mailInfo.HAS_ATTACHMENT == 'true') };
OldMessage.prototype.hasEmbeddedAttachments = function() { return !!this.__mailInfo.HAS_EMBEDDED_ATTACHMENT };

OldMessage.prototype.getSms = function() { return this.__toString(this.__mailInfo.SMS) };
OldMessage.prototype.getBody = function() { return this.__toString(this.__mailInfo.CLEAN_HTML || this.__mailInfo.HTML) };
OldMessage.prototype.getPriority = function() { return this.__toString(this.__mailInfo.PRIORITY) };
OldMessage.prototype.getDelay = function() { return this.__toString(this.__mailInfo.DEFERRED_DELIVERY) };

OldMessage.prototype.getBase = function() {

	var sBase = this.__mailInfo.BASE_URL || '';
	if (sBase){
		if (sBase.indexOf('file://')===0)
			sBase = '';
		else{
			if (!(/\/$/gi.test(sBase)))
				sBase += '/';

			if (!(/^((http)|(https)):/gi.test(sBase)))
				sBase = 'http://' + sBase;
		}
	}

	return this.__toString(sBase);
};

OldMessage.prototype.isHtml = function(bReply) {
	if (bReply)
		switch(GWOthers.getItem('MAIL_SETTINGS_DEFAULT', 'reply_message').toString()){
			case '1':
				return false;
			case '2':
				return true;
		}

	return (this.getStaticFlags() & 1) ? true : false;
};
OldMessage.prototype.getAttachments = function() { return this.__mailInfo.ATTACHMENTS };
OldMessage.prototype.getStaticFlags = function() { return this.__mailInfo.STATIC_FLAGS };
OldMessage.prototype.getConfirmAddress = function() { return this.__toString(this.__mailInfo.CONFIRM_ADDR) };
OldMessage.prototype.getSpellCheckerLanguage = function() { return this.__toString(this.__mailInfo.SPELLCHECKER) };
OldMessage.prototype.getSentFolder = function() { return this.__toString(this.__mailInfo.SENT) };

OldMessage.prototype.copyAttachments = function(id) {
	var result = { attachments: []};
	id = id || this.__id;

	if (this.hasAttachments()) {
		var aOldAttachments = this.getAttachments(),
			aAttachFrame, aAttachResult;

		for(var sAttId in aOldAttachments) {
			aAttachFrame = aOldAttachments[sAttId]['values'];

			if (aAttachFrame.ALL || aAttachFrame.DOCREF || aAttachFrame.TYPE === 'certificate' || sAttId === 'CERT')
				continue;

			aAttachResult = {
				class: aAttachFrame.URL ? 'link' : 'attachment',
				fullpath: aAttachFrame.URL || (id[0] + '/' + id[1] + '/' + WMItems.__serverID(id[2]) +'/' + sAttId)
			};

			for(var sTag in aAttachFrame)
				aAttachResult[sTag.toLowerCase()] = aAttachFrame[sTag];

			result.attachments.push({values: aAttachResult});
		}
	}

	return result;
};

OldMessage.prototype.__toString = function(o) {
	return (o && o !== 'false' && o !== 'undefined') ? o.toString() : '';
};

OldMessage.prototype.hasFlag = function(sFlagName) {
	var nFlag;
	if ((nFlag = this.getFlags()) === undefined) return false;

	return WMItems.hasFlag(nFlag, sFlagName);
};

OldMessage.prototype.setFlags = function(aFlagNames) {
	var bUpdateFolders = false;
	var aFlagPairs = {};

	for (var i in aFlagNames) {
		if (aFlagNames[i] == 'SEEN')
			bUpdateFolders = true;

		aFlagPairs[aFlagNames[i]] = true;
	}

	if (bUpdateFolders)
		WMItems.setFlag({"aid": this.__id[0], "fid": this.__id[1], "iid": [this.__id[2]]}, aFlagPairs, 'items', 'folders');
	else
		WMItems.setFlag({"aid": this.__id[0], "fid": this.__id[1], "iid": [this.__id[2]]}, aFlagPairs, 'items');
};

OldMessage.prototype.setAnswered = function() {
	if (!this.hasFlag('SEEN'))
		this.setFlags(['ANSWERED', 'SEEN']);
	else
		this.setFlags(['ANSWERED']);
};

OldMessage.prototype.setForwarded = function() {
	if (!this.hasFlag('SEEN'))
		this.setFlags(['FORWARDED', 'SEEN']);
	else
		this.setFlags(['FORWARDED']);
};

OldMessage.prototype.dispose = function() {
	dataSet.disobey(this);
};

OldMessage.__prefixParser = function(sSubject, sType) {
	if (GWOthers.getItem('MAIL_SETTINGS_GENERAL', 'classic_prefix') != 0) {
		return sType + ': ' + sSubject;
	}

	var joinPrefixes,
		last_prefix = sType,
		count = 1,
		subject = '',
		parts = sSubject.split(/(?:(.*?)(?:\[(\d+)\])?:\s)/i);

	for (var i in parts) {
		switch(i % 3) {
			case 0: // txt
				if (i == parts.length - 1) {
					subject += last_prefix + (count > 1 ? '[' + count + ']' : '') + ': ';
				}
				subject += ' ' + parts[i];
				break;
			case 1: // prefix
				if (parts[i].toLowerCase() === last_prefix.toLowerCase()) {
					joinPrefixes = true;
				} else {
					subject += last_prefix + (count > 1 ? '[' + count + ']' : '') + ': ';
					joinPrefixes = false;
					count = 1;
				}
				last_prefix = parts[i];
				break;
			case 2: // count
				if (joinPrefixes) {
					count += +parts[i] || 1;
				} else {
					count = +parts[i] || 1
				}
				break;
		}
	}

	return subject.trim().replace(/\s+/g, ' ');
};

OldMessage.prototype.__update = function() {
	var datasetItems = dataSet.get('items', this.__id);
	if (datasetItems)
		this.__datasetItems = datasetItems;
};

//Auxiliary
OldMessage._parseRcp = function(sRcp){
	return MailAddress.splitEmailsAndNames(sRcp).map(function(mail){
		var	a = mkElement('a', {style:"color:#0088CC;text-decoration:none;", href:'mailto:' + mail.email, text: mail.email}).outerHTML;
		if (mail.name)
			mail.name = mail.name.replace(/(["\\])/g,'\\$1').trim();

		return mail.name?mail.name + ' (' + a + ')':a;

	}).join(', ');
};

OldMessage.snooze = function(aIds, dDate, oOriginator, iNext) {
	var refreshNeeded;
	if (dDate) {
		if (aIds[1] !== '__@@SNOOZED@@__') {
			if (oOriginator){
				oOriginator.__subtotal -= aIds[2].length;
				oOriginator._removeItems && oOriginator._removeItems(aIds[2]);
				if (oOriginator._focus)
					oOriginator._focus();
				if (typeof iNext != 'undefined')
					oOriginator._value([iNext], false, false);
			}
			refreshNeeded = !Item.__removeFromDataset(aIds);
		}

		WMItems.snooze({ aid: aIds[0], fid: aIds[1], iid: aIds[2], timestamp: dDate.unix() }, [function (bOk) {
			if (bOk) {
				refreshNeeded && Item.__refreshView(aIds, true);
				gui.notifier._value({type: 'email_snoozed', args: { aid: aIds[0], fid: aIds[1], iid: aIds[2], undo: function() {
					WMItems.snooze({ aid: aIds[0], fid: aIds[1], iid: aIds[2] }, [function (bOk) {
						if (bOk) {
							Item.__refreshView(aIds, true);
						}
					}]);
				} } });
			}
			var removedFromDataset = dataSet.get('removedFromDataset', [aIds[0], aIds[1]]) || [];
			removedFromDataset = removedFromDataset.filter(function(iid) {
				return !~aIds[2].indexOf(iid);
			});
			dataSet.add('removedFromDataset', [aIds[0], aIds[1]], removedFromDataset, true);
		}]);
	} else if (dDate === false) {
		if (oOriginator){
			oOriginator.__subtotal -= aIds[2].length;
		}
		refreshNeeded = Item.__removeFromDataset(aIds);
		WMItems.snooze({ aid: aIds[0], fid: aIds[1], iid: aIds[2] }, [function (bOk) {
			if (bOk) {
				refreshNeeded && Item.__refreshView(aIds, true);
				gui.notifier._value({type: 'email_unsnoozed', args: { aid: aIds[0], fid: aIds[1], iid: aIds[2] }});
			}
			var removedFromDataset = dataSet.get('removedFromDataset', [aIds[0], aIds[1]]) || [];
			removedFromDataset = removedFromDataset.filter(function(iid) {
				return !~aIds[2].indexOf(iid);
			});
			dataSet.add('removedFromDataset', [aIds[0], aIds[1]], removedFromDataset, true);
		}]);
	} else {
		gui._create('datetime_picker', 'frm_calendar', '', '', [function (dDate) {
			if (aIds[1] !== '__@@SNOOZED@@__') {
				if (oOriginator){
					oOriginator.__subtotal -= aIds[2].length;
					oOriginator._removeItems && oOriginator._removeItems(aIds[2]);
					if (oOriginator._focus)
						oOriginator._focus();
					if (typeof iNext != 'undefined')
						oOriginator._value([iNext], false, false);
				}
				refreshNeeded = Item.__removeFromDataset(aIds);
			}
			WMItems.snooze({ aid: aIds[0], fid: aIds[1], iid: aIds[2], timestamp: dDate.unix() }, [function (bOk) {
				if (bOk) {
					refreshNeeded && Item.__refreshView(aIds, true);
					gui.notifier._value({type: 'email_snoozed', args: { aid: aIds[0], fid: aIds[1], iid: aIds[2], undo: function() {
						WMItems.snooze({ aid: aIds[0], fid: aIds[1], iid: aIds[2] }, [function (bOk) {
							if (bOk) {
								Item.__refreshView(aIds, true);
							}
						}]);
					} } });
				}
				var removedFromDataset = dataSet.get('removedFromDataset', [aIds[0], aIds[1]]) || [];
				removedFromDataset = removedFromDataset.filter(function(iid) {
					return !~aIds[2].indexOf(iid);
				});
				dataSet.add('removedFromDataset', [aIds[0], aIds[1]], removedFromDataset, true);
			}]);
		}], {
			minDate: new IcewarpDate()
		});
	}
};

OldMessage.recall = function(aIds) {
	var subject = dataSet.get('items', [aIds[0], aIds[1], aIds[2], 'SUBJECT']);
	gui._create('frm_confirm', 'frm_confirm', '', '', [async function() {
		var oldMessage = new OldMessage();
		await oldMessage.init(aIds);
		var newMessage = new NewMessage();

		newMessage.sTo = OldMessage.__extractMail(oldMessage.getTo());
		newMessage.sCc = OldMessage.__extractMail(oldMessage.getCc());
		newMessage.sBcc = OldMessage.__extractMail(oldMessage.getBcc());
		newMessage.sSubject = OldMessage.__prefixParser(oldMessage.getSubject(), 'Recall');

		var textEn = getLang('RECALL_MESSAGE::BODY', [dataSet.get('main',['fullname']), subject], void 0, true);
		var textUser = getLang('RECALL_MESSAGE::BODY', [dataSet.get('main',['fullname']), subject]);
		newMessage.sBody = '<div>' + textEn + '</div>';
		if (GWOthers.getItem('LAYOUT_SETTINGS', 'language') !== 'en' && textEn !== textUser) {
			newMessage.sBody += '<div>&nbsp;<br></div><div>' + textUser + '</div>';
		}

		if (oldMessage.__mailInfo.REFERENCES) {
			newMessage.sReferences = oldMessage.__mailInfo.REFERENCES.trim();
		} else if (oldMessage.__mailInfo.IN_REPLY_TO) {
			newMessage.sReferences = oldMessage.__mailInfo.IN_REPLY_TO.split("\n").shift().trim() || '';
		}

		newMessage.oHeaders['X-IceWarp-Recall-Message-ID'] = oldMessage.__mailInfo.MESSAGE_ID;

		newMessage.send(void 0, [function(bOK) {
			if (bOK && ((gui.frm_main || {}).main || {}).list) {
				gui.frm_main.main.list._serverSort(false, false, false, false, false, true, true);
			}
		}], { save_sent_message: 1 });
	}],
		'RECALL_MESSAGE::TITLE', '', getLang('RECALL_MESSAGE::CONFIRMATION', [subject])
	);	
};