/*
	Public:
		- sFrom
		- sTo
		- sCc
		- sBcc
		- sSubject
		- aAttachments
		- sBody

		- isHtml()
		- setHtml()

		- onSentCallback  - array
		- onDisposeCallback - array
	Private:
		- __id
*/
function NewMessage(id) {
	if (id)
		this.__id = id;

	this.onSentCallback = [];
	// this.onTChCallback = [];
	this.onDisposeCallback  = [];
	this.oHeaders = {};
	this.sTemplate = '';
	this.sBody = '';

	this.signatureID = 0;
};

NewMessage.crlf = '<div><br></div>';
/**
 * Generates proper signature according to given alias or list of aliases
 * @params:	sRcp - comma separated list of recipient emails
 **/
NewMessage.signature = function(sRcp){
	var i, tmp, iAliasID = null,
		aTmp = dataSet.get('storage',['ALIASES','ITEMS']);

    if (GWOthers.getItem('RESTRICTIONS', 'disable_personalities')>0 && GWOthers.getItem('RESTRICTIONS', 'disable_delegated_aliases')>0){
		for(i in aTmp)
			if (aTmp[i].VALUES.EMAIL.VALUE.toLowerCase() == sPrimaryAccount){
				iAliasID = i;
				break;
			}
	}
	else{
		var aRcp = {};
		if (sRcp){
			tmp = MailAddress.splitEmailsAndNames(sRcp);
			for (i in tmp)
				aRcp[tmp[i].email.toLowerCase()] = true;
		}
		else{
			tmp = GWOthers.getItem('MAIL_SETTINGS_DEFAULT', 'from');
			if (tmp && (tmp = MailAddress.splitEmailsAndNames(tmp))){
			    if (tmp[0] && tmp[0].email.toLowerCase() != sPrimaryAccount.toLowerCase())
			    	aRcp[tmp[0].email.toLowerCase()] = true;
			    else
			    	aRcp[sPrimaryAccount.toLowerCase()] = true;
			}
			else
				aRcp[sPrimaryAccount.toLowerCase()] = true;
		}

		for(i in aTmp)
			if (aTmp[i].VALUES && ((iAliasID == null && aTmp[i].VALUES.EMAIL.VALUE.toLowerCase() == sPrimaryAccount) || (aTmp[i].VALUES.ENABLED && aTmp[i].VALUES.ENABLED.VALUE == '1' && aRcp[aTmp[i].VALUES.EMAIL.VALUE.toLowerCase()])))
				iAliasID = i;
	}

	if (iAliasID != null){
		var bDelegate = aTmp[iAliasID].VALUES.ISDELEGATE && aTmp[iAliasID].VALUES.ISDELEGATE.VALUE == '1';
		aTmp = aTmp[iAliasID].VALUES[Is.Defined(sRcp)?'SIGN2':'SIGN1'] || {VALUE:'0'};
		var aSign = dataSet.get('storage',['SIGNATURE','ITEMS']);
		var iLastUsed;
		if (GWOthers.getItem('MAIL_SETTINGS_DEFAULT', 'remember_last_used_signature') > 0) {
			iLastUsed = dataSet.get('cookies', ['last_used_signature']);
		}
		for (i in aSign)
	    	if ((iLastUsed && iLastUsed == i) || !iLastUsed && (aSign[i].VALUES.ID && aSign[i].VALUES.ID.VALUE == aTmp.VALUE || (aTmp.VALUE == '0' && !aSign[i].VALUES.ID)))
                if (aSign[i].VALUES.TEXT){
                	var signature = aSign[i].VALUES.TEXT.VALUE;

					//convert old signature
					if (signature.indexOf('<')<0)
						signature = signature.replace(/(\r\n)|(\n)/gm,'<br>');

                    return {
						//text:NewMessage.linkFix((GWOthers.getItem('MAIL_SETTINGS_DEFAULT', 'sign_separator')>0?'<div class="separator">-- </div>':'') + signature),
						text:(GWOthers.getItem('MAIL_SETTINGS_DEFAULT', 'sign_separator')>0?'<div class="separator">-- </div>':'') + signature,
						id:(aSign[i].VALUES.ID?aSign[i].VALUES.ID.VALUE:0),
						delegate:bDelegate
                    };
                }

	}

	return {text: '', id: '*', delegate: false};
};

NewMessage.linkFix = function(v){
	var tmp = document.implementation.createHTMLDocument("link").body;
		tmp.innerHTML = v;

	[].forEach.call(tmp.querySelectorAll('a[href]'), function(elm){
		try{
			elm.href = (elm.protocol?elm.protocol + (elm.protocol == 'mailto:'?'':'//'):'') + elm.host + elm.pathname + elm.search + elm.hash;
		}
		catch{
			elm.removeAttribute('href');
		}
	});

	return tmp.innerHTML;
};


NewMessage.compose_sms = function(aResponse) {
	if (aResponse){
		for (var i in aResponse)
		    for (var j in aResponse[i]){
				delete aResponse[i][j]['/'];
				delete aResponse[i][j]['#'];
				delete aResponse[i][j]['$'];
				delete aResponse[i][j]['@'];
				var tmp = '';
				for (var k in aResponse[i][j])
				    tmp += (tmp?';':'')+ MailAddress.createEmail(aResponse[i][j][k].ITMCLASSIFYAS,aResponse[i][j][k].LCTPHNMOBILE);

				if (tmp)
                    NewMessage.compose({sms:tmp});
				else
					gui.notifier._value({type: 'alert', args: {header: 'MAIN_MENU::SMS', text: 'CONFIRMATION::NO_MOBILE'}});
			}
	}
	else
		NewMessage.compose({sms:true});
};

NewMessage.compose = async function(aRecipients, bIsHTML, oGui) {
	oGui = oGui || gui;
	var newMessage = new NewMessage();

	if (aRecipients instanceof OldMessage){
		newMessage.sTo = aRecipients.getTo();
		newMessage.sRcp = newMessage.sFrom = aRecipients.getFrom();
		newMessage.sCc = aRecipients.getCc();
		newMessage.sBcc = aRecipients.getBcc();
		newMessage.sTeamchat = aRecipients.getTeamchat();
		newMessage.sComment = aRecipients.getComment();
		newMessage.sSMS = aRecipients.getSms();
		newMessage.sSubject = aRecipients.getSubject();
		newMessage.setHtml(aRecipients.isHtml(true));
		if ((aRecipients.__mailInfo.aid + '/' + aRecipients.__mailInfo.fid) === GWOthers.getItem('DEFAULT_FOLDERS','templates')) {
			newMessage.sTemplate = aRecipients.getBody();
		} else {
			newMessage.sBody = aRecipients.getBody();
		}
		newMessage.aAttachments = aRecipients.copyAttachments(aRecipients.__id);
		delete newMessage.__id;
	}
	else
	if (typeof aRecipients == 'object'){
	    if (aRecipients.to)
	    	newMessage.sTo = aRecipients.to;
	    if (aRecipients.cc)
	    	newMessage.sCc = aRecipients.cc;
	    if (aRecipients.bcc)
	    	newMessage.sBcc = aRecipients.bcc;

		if (aRecipients.sms)
	    	newMessage.sSMS = aRecipients.sms;
		else
		if (aRecipients.template)
			newMessage.template = aRecipients.template;
		else
		if(aRecipients.mailBody) {
			//newMessage.setHtml(false);
			newMessage.sBody = aRecipients.mailBody;
			newMessage.addSignature(true);
		}
		else{
			if (aRecipients.alias)
				newMessage.sRcp = MailAddress.createEmail('', aRecipients.alias);
			if (aRecipients.htmlBody) {
				newMessage.sBody = aRecipients.htmlBody;
			}

			// newMessage.addSignature();
		}

		if (aRecipients.teamchat){
			newMessage.sTeamchat = aRecipients.teamchat;
			if (aRecipients.teamchat_comment)
				newMessage.sComment = aRecipients.teamchat_comment;
		}

		if (aRecipients.subject)
	    	newMessage.sSubject = aRecipients.subject;

		if (aRecipients.headers)
			newMessage.oHeaders = aRecipients.headers;

		if (aRecipients.body){
	    	newMessage.sBody = aRecipients.body;
			newMessage.setHtml(false);
		}
		if (aRecipients.oSave) {
			newMessage.oSave = aRecipients.oSave;
		}
	}

	if (!aRecipients || (!aRecipients.sms && !aRecipients.template))
		newMessage.addvCard();

	if(bIsHTML !== void 0) {
		newMessage.setHtml(bIsHTML);
	}
	
	var args = [].slice.call(arguments).filter(function(arg) {
		return arg !== oGui;
	});
	return await oGui._create('frm_compose', 'frm_compose', '', '', newMessage, void 0, {
		context: 'NewMessage',
		fun: ['compose'],
		args: args
	});
};

NewMessage.composeTemplate = async function(){
	var f = Path.split(GWOthers.getItem('DEFAULT_FOLDERS','templates')),
		frm = await gui._create('template','frm_insert_item','','frm_insert_item_nobottomdiv',[
		async function(aPath){
			if ((aPath = aPath[0])){
				var oldTemplate = new OldMessage();
				await oldTemplate.init([aPath.aid, aPath.fid, aPath.id]);
				NewMessage.compose(oldTemplate);
			}
		}],
		f[0],f[1],'M','',true);
		frm._title('COMPOSE::TEMPLATE');
};

NewMessage.prototype.isHtml = function() {
	if (!Is.Defined(this.__bHtml))
		this.__bHtml = (GWOthers.getItem('MAIL_SETTINGS_DEFAULT', 'html_message') || 0)>0 ? true : false;

	return this.__bHtml;
};

NewMessage.prototype.setHtml = function(bHtml) {
	// set HTML composing if bHtml is true, otherwise ignore the bHtml and signify
	// isHtml according to MAIL_SETTINGS_DEFAULT
	this.__bHtml = bHtml?true:false;
};

NewMessage.prototype.save = async function(bKeepAttachments, aHandler, aSettingsDefault, bTeamChat) {

	var aMessageIQ = this.__loadCommonMessageIQ(bKeepAttachments, aSettingsDefault);
	aMessageIQ.to = this.sTo;
	aMessageIQ.cc = this.sCc;
	aMessageIQ.bcc = this.sBcc;
	aMessageIQ.action.email = 'false';

	if (this.sTeamchat){
		aMessageIQ.teamchat = this.sTeamchat;
		aMessageIQ.teamchat_comment = this.sComment || '';

		if (!this.__id_chat || this.__id_chat[1] != this.sTeamchat.replace(/::.+$/g,''))
			this.__id_chat = {0:sPrimaryAccount, 1:this.sTeamchat.replace(/::.+$/g,'')};

		aMessageIQ['action']['save_chat'] = {aid: this.__id_chat[0], fid: this.__id_chat[1]};
		if (this.__id_chat[2]) aMessageIQ['action']['save_chat']['iid'] = WMItems.__serverID(Array.isArray(this.__id_chat[2]) ? this.__id_chat[2][0] : this.__id_chat[2]);
	}
	else
	if (bTeamChat)
		return false;

	if (!bTeamChat){

		if (aSettingsDefault.sms>0 && this.sSMS)
			aMessageIQ.sms = this.sSMS;

		if (!this.__id) {
			this.__id = [];

			var aTarget = [];
			if (this.template) {
				aTarget = Path.split(GWOthers.getItem('DEFAULT_FOLDERS', ('templates')));
			} else {
				aTarget = Path.split(GWOthers.getItem('DEFAULT_FOLDERS', ('drafts')));
				var from = MailAddress.splitEmailsAndNames(aMessageIQ.from)[0].email;
				var aliases = dataSet.get('storage',['ALIASES','ITEMS']);

				for(var i in aliases) {
					if (aliases[i].VALUES.EMAIL.VALUE.toLowerCase() === from && (aliases[i].VALUES.DRAFTFOLDER || {}).VALUE) {
						aTarget = Path.split(aliases[i].VALUES.DRAFTFOLDER.VALUE);
					}
				}
			}

			this.__id[0] = aTarget.shift();
			this.__id[1] = aTarget.join('/');

			if (!dataSet.get('folders', this.__id))
				dataSet.add('folders', this.__id, {'NAME': getLang('COMMON_FOLDERS::' + (this.template ? 'TEMPLATES' : 'DRAFTS')),'TYPE':'M','RIGHTS':'rwmd'});
		}

		if (this.oSave) {
			this.__id[0] = this.oSave.aid;
			this.__id[1] = this.oSave.fid;
		}

		aMessageIQ['action']['save'] = {"aid": this.__id[0], "fid": this.__id[1]};
		if (this.__id[2]) aMessageIQ['action']['save']['iid'] = Array.isArray(this.__id[2]) ? this.__id[2][0] : this.__id[2];
	}

	await storage.library('wm_messages');
	return await message.add(aMessageIQ, '', '', [this, '__messageSaved', [aHandler, bTeamChat]]);
};

NewMessage.prototype.send = async function(bKeepAttachments, aHandler, aSettingsDefault) {
	aSettingsDefault = aSettingsDefault || {};
	var aMessageIQ = this.__loadCommonMessageIQ(bKeepAttachments, aSettingsDefault);

	if (this.sTo == '' && this.sCc == '' && this.sBcc == '' && this.sSMS == '')
		return false;

	aMessageIQ['action']['email'] = 'true';

	//Save to Sent
	if ((typeof aSettingsDefault == 'object' && parseInt(aSettingsDefault['save_sent_message'])>0) || (typeof aSettingsDefault != 'object' && parseInt(GWOthers.getItem('MAIL_SETTINGS_DEFAULT', 'save_sent_message'))>0)) {
		var sSentFolder = Path.split(aSettingsDefault['sent'] || GWOthers.getItem('DEFAULT_FOLDERS', 'sent'));
		aMessageIQ['action']['save'] = {"aid": sSentFolder[0], "fid": sSentFolder[1]};
		aMessageIQ['action']['include_in_sent_folder'] = aSettingsDefault.include_in_sent_folder || 0;
	}

	//Save to Teamchat
	if (this.sTeamchat){
		aMessageIQ.teamchat = this.sTeamchat;
		aMessageIQ.teamchat_comment = this.sComment || '';

		if (!this.__id_chat || this.__id_chat[1] != this.sTeamchat.replace(/::.+$/g,''))
			this.__id_chat = {0:sPrimaryAccount, 1:this.sTeamchat.replace(/::.+$/g,'')};

		aMessageIQ['action']['save_chat'] = {aid: this.__id_chat[0], fid: this.__id_chat[1]};
		if (this.__id_chat[2]) aMessageIQ['action']['save_chat']['iid'] = WMItems.__serverID(Array.isArray(this.__id_chat[2]) ? this.__id_chat[2][0] : this.__id_chat[2]);
	}

    if (GWOthers.getItem('MAIL_SETTINGS_GENERAL', 'smtp_relay')>0)
    	aMessageIQ['action']['smtp_relay'] = 'true';

	var aDistribList = MailAddress.findDistribList({'to': this.sTo, 'cc': this.sCc, 'bcc': this.sBcc});

	for (var sTag in aDistribList)
		aMessageIQ[sTag] = aDistribList[sTag];

    if (aSettingsDefault.sms>0 && this.sSMS)
		aMessageIQ.sms = this.sSMS;

	if (this.__id && this.__id[2]) {
		aMessageIQ.action.draft_id = WMItems.__serverID(this.__id[2]);
	}

	var rst = GWOthers.getItem('RESTRICTIONS', 'disable_gw_types') || '';
	if (rst.indexOf('c')<0 && window.sPrimaryAccountGW && parseInt(GWOthers.getItem('MAIL_SETTINGS_GENERAL', 'auto_recipient_to_addressbook')))
		aMessageIQ['action']['auto_addressbook'] = 'true';

	//REMOVE iw-remove marked tags
	if (aMessageIQ.body){
		await storage.library('purify.wrapper', 'purify');

		var safeHtml = document.createElement('template');
			safeHtml.innerHTML = DOMPurify.sanitize(aMessageIQ.body);

		[].forEach.call(safeHtml.content.querySelectorAll('[iw-remove='+ (aMessageIQ.action.html_body === "true"?'html':'text') +']'), function(elm){
			elm.parentNode.removeChild(elm);
		});
		aMessageIQ.body = safeHtml.innerHTML;
		aMessageIQ.body = aMessageIQ.body.replace(/class="classification[^"]*?"/g, '');
	}

	var recipientHistory = Cookie.get(['recipient_history']) || [];
	MailAddress.splitEmailsAndNames([this.sTo, this.sCc, this.sBcc].filter(Boolean).join(',')).reverse().forEach(function(recipient) {
		if (~recipientHistory.indexOf(recipient.email)) {
			recipientHistory.splice(recipientHistory.indexOf(recipient.email), 1);
		}
		recipientHistory.unshift(recipient.email);
	});
	recipientHistory = recipientHistory.slice(0, 15);
	Cookie.set(['recipient_history'], recipientHistory);

	await storage.library('wm_messages');
	return await message.add(aMessageIQ, '', '' , [this, '__messageSent', [aHandler]]);
};

NewMessage.prototype.dispose = function() {
	if (typeof this.onDisposeCallback == 'object' && this.onDisposeCallback.length>0)
		for(var i in this.onDisposeCallback)
			executeCallbackFunction(this.onDisposeCallback[i]);
};

NewMessage.prototype.addvCard = function() {
	if (GWOthers.getItem('MAIL_SETTINGS_DEFAULT', 'append_vcard')>0){
		if (!this.aAttachments || !this.aAttachments.attachments)
			this.aAttachments = {'attachments':[]};

		this.aAttachments.attachments.push({'values': {'class': 'item', 'fullpath': sPrimaryAccount+'/@@mycard@@/@@mycard@@', 'name': (dataSet.get('main',['fullname']) || 'vCard')+'.vcf'}});
	}
};

NewMessage.prototype.addSignature = function(bBottom) {

	if (!Is.Defined(this.sBody))
		this.sBody = '';
	else
		this.sBody = this.sBody.replace('<div class="iw-signature">','<div>');

	var aSign = NewMessage.signature(this.sRcp),
		sSign = NewMessage.crlf + NewMessage.crlf + (aSign.text ? '<div class="iw-signature">' + aSign.text + '</div>' : '');

	sSign = sSign.replace(/<html.*?>.*?<body.*?>/, '').replace(/<\/body>.*?<\/html>/, '').replace(/<style(.*?)>/g, '<style $1 class="iw-skip">');

	//Add default signature ID
	this.signatureID = aSign.id;
	this.bDelegate = aSign.delegate;

	if (GWOthers.getItem('MAIL_SETTINGS_DEFAULT', 'classification')>0 && !~this.sBody.indexOf('class="classification')) {
		sSign = '<div class="classification" rel="main"></div>' + sSign + '<div class="classification end" rel="main"></div>'
	}

	if (!bBottom && GWOthers.getItem('MAIL_SETTINGS_DEFAULT', 'sign_top')>0)
		this.sBody = sSign + this.sBody;
	else
		this.sBody = this.sBody + sSign;
};

NewMessage.prototype.__loadCommonMessageIQ = function(bKeepAttachments, aSettings) {
	var i, aMessageIQ = {};

	if (typeof aSettings != 'object')
		aSettings = GWOthers.get('MAIL_SETTINGS_DEFAULT', 'storage')['VALUES'];

	aMessageIQ['action'] = {
		"im": 'false',
		"keep": (bKeepAttachments) ? 'true' : 'false',
		"html_body": (this.isHtml()) ? 'true' : 'false'
	};

	aMessageIQ['from'] = aSettings['from'] || getPrimaryAccountFromAddress();

	var smartattach = {
		process: false
	};
	if (aSettings.direct_attach==0){

		smartattach.process = true;

		var asap = Path.split(GWOthers.getItem('DEFAULT_FOLDERS','smartattach'));
		var from = MailAddress.splitEmailsAndNames(aMessageIQ['from'])[0].email;
		var aliases = dataSet.get('storage',['ALIASES','ITEMS']);

		for(i in aliases) {
			if (aliases[i].VALUES.EMAIL.VALUE.toLowerCase() === from && (aliases[i].VALUES.SMARTFOLDER || {}).VALUE) {
				asap = Path.split(aliases[i].VALUES.SMARTFOLDER.VALUE);
			}
		}

		if (asap && asap[1])
			smartattach.folder = asap[1];

		if (aSettings.webclient_smart_password) {
			smartattach.password = aSettings.webclient_smart_password;
		}
		if (aSettings.webclient_smart_expiration) {
			smartattach.expire = aSettings.webclient_smart_expiration;
		}
	}
	aMessageIQ.action.smartattach = smartattach;

	aMessageIQ['subject'] = this.sSubject;

	if (aSettings.sms>0){
		aMessageIQ['action'].sms = 'true';
		aMessageIQ['text'] = this.sBody;
	}
	else
		aMessageIQ['body'] = this.sBody;

	if (this.sDeferred)
		aMessageIQ['deferred_date'] = this.sDeferred;

	var aHeaders = [];
	if (parseInt(aSettings['read_confirmation']) || aSettings['read_confirmation'] === true) {
		aHeaders.push('X-Confirm-Reading-To: ' + aMessageIQ['from']);
		aHeaders.push('Disposition-Notification-To: ' + aMessageIQ['from']);
	}
	if (parseInt(aSettings['webclient_print'])) {
		aHeaders.push('X-IceWarp-WebClient-Print-Disabled: 1');
	}
	if (parseInt(aSettings['webclient_forward'])) {
		aHeaders.push('X-IceWarp-WebClient-Forward-Disabled: 1');
	}
	if (parseInt(aSettings['webclient_reply'])) {
		aHeaders.push('X-IceWarp-WebClient-Reply-Disabled: 1');
	}
	if (parseInt(aSettings['webclient_edit'])) {
		aHeaders.push('X-IceWarp-WebClient-Edit-Disabled: 1');
	}
	// Add any custom headers for this message
	for(i in this.oHeaders)
		aHeaders.push(i+': '+this.oHeaders[i]);

	//RFC 2822 Reply conversations
	if (this.sIn_Reply_To)
		aHeaders.push('In-Reply-To: ' + this.sIn_Reply_To);
	if (this.sReferences)
		aHeaders.push('References: ' + this.sReferences);

	if (parseInt(aSettings['priority']))
		aHeaders.push('X-Priority: ' + aSettings['priority']);

	if (aSettings['reply_to_address']){
        var aTmp = MailAddress.splitEmailsAndNames(aSettings['reply_to_address']);
        if (aTmp && aTmp[0])
            aHeaders.push('Reply-To: ' + MailAddress.createEmail(aTmp[0].name,aTmp[0].email));
	}

	if (this.bDelegate)
		aHeaders.push('Sender: ' + getPrimaryAccountFromAddress());

	if (!Is.Empty(aHeaders))
		aMessageIQ['headers'] = aHeaders;

	//if (aSettings['charset']) aMessageIQ['charset'] = aSettings['charset'];

	if (parseInt(aSettings['encrypt']))
		aMessageIQ['action']['encrypt'] = 'true';
	if (parseInt(aSettings['sign']))
		aMessageIQ['action']['sign'] = 'true';

	if (this.aAttachments) {
		var aAttachments = this.aAttachments['attachments'];
		var sUploadFolId = this.aAttachments['folder'];

		var aAttachResult = [];

		for (var n in aAttachments){
			aAttachResult[n] = {
				class: aAttachments[n].class || 'file',
				type: 'normal',
				fullpath: aAttachments[n].class ? aAttachments[n].fullpath : sUploadFolId + '/' + aAttachments[n].id,
				description: aAttachments[n].description || aAttachments[n].attachment || aAttachments[n].name
			};

			if (aAttachments[n].class === 'item') {
				aHeaders.push('X-Icewarp-Att-Data:' + this.__encodeUTF8Header(aAttachments[n].name) + '=' + this.__encodeUTF8Header(aAttachResult[n].fullpath));
			}
		}

		if (!Is.Empty(aAttachResult)) {
			aMessageIQ.attachments = aAttachResult;
		}
	}

	return aMessageIQ;
};


NewMessage.prototype.__encodeUTF8Header = function(string) {
	return '=?UTF-8?B?' + btoa(encodeURIComponent(string)) + '?=';
};

/**
 * @param {object or false} bOK
 */
NewMessage.prototype.__messageSaved = function(bOK, sUId, sError, aHandler, bChat) {
	if (bOK && (sUId.length || (bChat && bOK.TEAMCHAT_ID))) {
		var bFirstTime = false;

		//Notify TeamChat
		if (bChat){

			bOK.TEAMCHAT_ID = WMItems.__clientID(bOK.TEAMCHAT_ID);

			var sAction = this.__id_chat[2] != bOK.TEAMCHAT_ID?'add':'update';

			this.__id_chat[1] = Path.slash(bOK.TEAMCHAT);
			this.__id_chat[2] = bOK.TEAMCHAT_ID;

			Item.notify(this.__id_chat, sAction, {
				'ITEM-TYPE': 'M'
			});

			//Always ADD for Y
			if (bOK.TEAMCHAT_LINK_ID)
				Item.notify([this.__id_chat[0], this.__id_chat[1], WMItems.__clientID(bOK.TEAMCHAT_LINK_ID)], 'add', {
					'ITEM-TYPE': 'Y'
				});

			//Call onTChCallback
			// for(var i in this.onTChCallback){
			// 	pushParameterToCallback(this.onTChCallback[i], {aid:sPrimaryAccount, fid:this.__id_chat[1], iid:this.__id_chat[2]});
			// 	executeCallbackFunction(this.onTChCallback[i]);
			// }
		}
		else{

			if (this.__id[2] != sUId){
				bFirstTime = true;
				this.__id[2] = sUId;

				//Remove saved email from Drafts folder after Sent
				this.onSentCallback.push([function(id) {
					var oldDraftCount = dataSet.get('folders', [id[0], id[1], 'COUNT']);
					Item.remove(makeIDSFromID(id), true);
					dataSet.add('folders', [id[0], id[1], 'COUNT'], (oldDraftCount - 1).toString());
				},[this.__id]]);
			}

			//Refresh Draft folder if active
			Item.__refreshView(this.__id, true);
		}

  		if (aHandler)
			executeCallbackFunction(aHandler, bOK, bFirstTime, this, sError);
	}
	else
	if (aHandler)
		executeCallbackFunction(aHandler, false, false, sUId, sError);
};

NewMessage.prototype.__messageSent = function(aOut, sUId, sError, aHandler) {
	if (aOut && !sError && Is.Array(this.onSentCallback) && this.onSentCallback.length)
		for(var i in this.onSentCallback){
            pushParameterToCallback(this.onSentCallback[i], aOut);
			executeCallbackFunction(this.onSentCallback[i]);
		}

	if (aHandler)
		executeCallbackFunction(aHandler, aOut, sUId, sError);

	if (aOut && !sError) {

		//Notify TeamChat
		if (aOut.TEAMCHAT && aOut.TEAMCHAT_ID){
			aOut.TEAMCHAT_ID = WMItems.__clientID(aOut.TEAMCHAT_ID);

			var sAction = this.__id_chat[2] != aOut.TEAMCHAT_ID?'add':'update';

			this.__id_chat[1] = Path.slash(aOut.TEAMCHAT);
			this.__id_chat[2] = aOut.TEAMCHAT_ID;

			Item.notify(this.__id_chat, sAction, {
				'ITEM-TYPE': 'M'
			});

			//Always ADD for Y
			if (aOut.TEAMCHAT_LINK_ID)
				Item.notify(this.__id_chat, 'add', {
					'ITEM-TYPE': 'Y'
				});
		}

		//Notify User
		if (gui.notifier){
			if(this.sDeferred) {
				var d = new IcewarpDate(this.sDeferred);
				gui.notifier._value({type: 'send_message_deferred', args: [aOut, d]});
			} else if (!this._suppressSuccessNotifications) {
				gui.notifier._value({type: 'message_sent', css: this.bSMS ? 'sms ' : '', args: [aOut]});
			}
		}
	}

};