function Item() {};

Item.COLORS = {
	'RED': '1', 'BLUE': '2', 'GREEN': '3', 'GREY': '4', 'ORANGE': '5', 'CYAN': '6', 'BROWN': '7',
	'PURPLE': '8', 'LIGHT_BLUE': '9', 'YELLOW': 'A', 'COMPLETE': 'Y', 'CLEAR': 'Z'
};

Item.open = function(id, aOtherData, aValues, sFolderType, bForce) {
	if (gui.frm_main && gui.frm_main.main && gui.frm_main.main.itemview){

		if (!bForce && dataSet.get('preview', id)) return;

		dataSet.add('active_items', [id[0],id[1]], id[2]);

		var aItemsInfo = {"aid": id[0], "fid": id[1], "iid": id[2]};
		sFolderType = WMFolders.getType(id);

		if (sFolderType == 'F')
			aItemsInfo.values = [
				'EVN_ID',
				'EVNGRP_ID',
				'EVNOWN_ID',
				'EVN_METADATA',
				'EVNLOCKOWN_ID',
				'EVNMODIFIEDOWN_ID',
				'EVN_EDITCOUNTER',
				'EVN_CREATED',
				'EVN_MODIFIED',
				'EVNFOLDER',
				'EVNORIGINALFOLDER',
				'EVNTITLE',
				'EVNTYPE',
				'EVNNOTE',
				'EVNDESCFORMAT',
				'EVNLOCATION',
				'EVNCOMPLETE',
				'EVNCOLOR',
				'EVNCLASS',
				'EVNSHARETYPE',
				'EVNTIMEFORMAT',
				'EVNSTATUS',
				'EVNURL',
				'EVNSTARTDATE',
				'EVNSTARTTIME',
				'EVNENDDATE',
				'EVNENDTIME',
				'EVNRID',
				'EVNUID',
				'EVNFLAGS',
				'EVNLOCKHASH',
				'EVNLOCKINFO',
				'EVNLOCKOWN_EMAIL',
				'EVNLOCKAPPMASK',
				//'DATA',
				'EVNEXPIRE',
				'TICKET'];

		// send extra XML tag only for Notes, Tasks, Contacts, Calendar Events, Documents (F)
		if (sFolderType === 'N' || sFolderType === 'T' || sFolderType === 'C' || sFolderType === 'E' || sFolderType === 'F') {
			// do not use strict checking - settings are stored as strings
			if (1 == GWOthers.getItem('MAIL_SETTINGS_GENERAL', 'show_inline_images')) {
				aItemsInfo.values = ['show_inline_images']; // show external images
			}
		}

		WMItems.list(aItemsInfo, 'preview'); //,'','',[gui.frm_main.main.itemview,'_value']
	}
	else
		Item.openwindow(id, aValues, aOtherData, sFolderType);
};

/**
 * Open GW item for CREATE or EDIT in Item.Property window
 *
 * @param {array} id			[account_id, folder_id, item_id] item_id is optional
 * @param {object} aValues		item data, optional
 * @param {object} aOtherData	aux data usually Event.Recurrence
 * @param {string} sFolderType	force item type eg. 'E' will be determined from id when null or undefined
 * @param {cb} oResponse		executed on exit
 * @param {cb} oFinished		executed when frm initialised
 * @param {boolean} bClone
 */
Item.openwindow = async function(id, aValues, aOtherData, sFolderType, oResponse, oFinished, bClone, oGui) {

	oGui = oGui || gui;
	sFolderType = sFolderType || WMFolders.getType(id);

	var type = Mapping.getFormNameByGWType(sFolderType);

	if (!aValues && id[2]){

		//Search for already opened window
		var popups = oGui._getChildObjects('main',type);
		for(var i in popups)
			if (popups[i]._type === type && popups[i]._sAccountID === id[0] && popups[i]._sFolderID === id[1] && (id[2] === '@@mycard@@' ? popups[i].__mycard : popups[i]._sItemID === id[2]))
				return popups[i]._focus();

		//Get Values from server
		var aItemsInfo = {"aid": id[0], "fid": id[1], "iid": id[2]};
		if (aOtherData && Is.Defined(aOtherData.EVNRCR_ID) && Is.Defined(aOtherData.EVNSTARTDATE))
			aItemsInfo.date = aOtherData.EVNSTARTDATE;

		// send extra XML tag only for Notes, Tasks, Contacts, Calendar Events, Documents (F)
		if (sFolderType === 'N' || sFolderType === 'T' || sFolderType === 'C' || sFolderType === 'E' || sFolderType === 'F') {
			// do not use strict checking - settings are stored as strings
			if (1 == GWOthers.getItem('MAIL_SETTINGS_GENERAL', 'show_inline_images')) {
				aItemsInfo.values = ['show_inline_images']; // show external images
			}
		}

		WMItems.list(aItemsInfo, null, null, null, [async function(aData){
			if (aData && aData[id[0]] && aData[id[0]][id[1]]){
				if (id[1] == '@@mycard@@'){
					id[2] = '';

					aValues = aData[id[0]][id[1]];
					delete aValues['/'];
					delete aValues['$'];
					delete aValues['#'];
					delete aValues['@'];

					for(var i in aValues)
						if (Is.Object(aValues[i])){
							id[2] = i;
							break;
						}

					aValues = aValues[id[2]] || {};
				}
				else
					aValues = aData[id[0]][id[1]][id[2]];
			}
			else
			if (id[1] == '@@mycard@@'){
				id[2] = '';
				aValues = {LOCATIONS:[{values:{LCTEMAIL1:sPrimaryAccount,LCTTYPE:'H'}}]};
			}
			else
				aValues = {};

			if ((aOtherData || {}).EVNFLAGS) {
				aValues.EVNFLAGS = (aValues.EVNFLAGS || 0) | aOtherData.EVNFLAGS;
			}

			var frm = await oGui._create('gw', type, '', '', id[0], id[1], id[2], aValues, aOtherData, oResponse, bClone);
			if (id[1] === '@@mycard@@') {
				frm.__mycard = true;
			}
			if (oFinished)
				executeCallbackFunction(oFinished, frm);

		}]);

		return;
	}

	var frm = await oGui._create('gw', type, '', '', id[0], id[1], id[2], aValues, aOtherData, oResponse, bClone);
	if (oFinished)
		executeCallbackFunction(oFinished, frm);
	return frm;
};


/**
 * Clone only for events! Copies event and opens edit dialog with cloned event
 *
 * @returns {undefined}
 */
Item.cloneEvent = function(id) {
	WMItems.list({aid: id[0], fid: id[1], iid: id[2]}, null, null, null,
		[
			function (aRes){
				if (aRes && (aRes = aRes[id[0]]) && (aRes = aRes[id[1]]) && (aRes = aRes[id[2]])){

					var aItemsInfo = {
						aid: id[0],
						fid: id[1],
						iid: [id[2]],
						account: id[0],
						folder: Path.slash(aRes['EVNFOLDER'])
					};

					WMItems.copy(aItemsInfo,'items','','folders',
						[
							function(bOK, aData){
								if (bOK){
									Item.__refreshView([id[0],id[1]],true);
									Item.openwindow([id[0],id[1],WMItems.__clientID(aData.Array.IQ[0].RESULT[0].ID[0].VALUE)], void 0, { EVNFLAGS: 1 });
								}
							}
						]
					);
				}
			}
		]
	);
};

Item.print = function(ids, filename){

	if (!ids || !ids[2].length)
		return;

	var aItemsInfo = {aid:ids[0],fid:ids[1]},
		sType = WMFolders.getType(ids);

	aItemsInfo.filter = {search:'items:"' + ids[2].join(',').replace(/\*/g,'') + '"'};

	switch(sType){

	case 'F':
		if (Item.officeSupport(filename)) {
			Item.previewItem([ids[0], ids[1], ids[2][0]], filename);
		}
		break;

	case 'T':
		aItemsInfo.values = [
			'EVNTITLE','EVNLOCATION','EVNNOTE','EVNDESCFORMAT','EVNSTATUS','EVNCOMPLETE','EVNENDDATE','EVNSTARTDATE','EVNTYPE'
		];

		WMItems.list(aItemsInfo, '', '','', [async function(aData){

			if (aData && (aData = aData[aItemsInfo.aid]) && (aData = aData[aItemsInfo.fid])){
				var out = [];

				for(var i in ids[2])
					if (aData[ids[2][i]])
						out.push(aData[ids[2][i]]);

				if (out.length){
					var frm;
					if (!(frm = gui.print))
						frm = await gui._create('print', 'frm_print');

					frm._add(sType, out);
				}
			}

		}]);

		break;
	case 'N':
		aItemsInfo.filter = false;
		aItemsInfo.values = ['show_inline_images'];
		aItemsInfo.iid = WMItems.__serverID(ids[2][0]);

		WMItems.list(aItemsInfo, '', '','', [async function(aData){
			if (aData && (aData = aData[aItemsInfo.aid]) && (aData = aData[aItemsInfo.fid]) && (aData = aData[ids[2][0]])){
				aData.NOTE_TEXT = aData.NOTES[0].values.NOTE_TEXT;
				var frm;
				if (!(frm = gui.print))
					frm = await gui._create('print', 'frm_print');

				frm._add(sType, aData);
			}

		}]);

		break;
	case 'C':

		aItemsInfo.values = [

			'ITMCLASSIFYAS','ITMTITLE','ITMFIRSTNAME','ITMMIDDLENAME','ITMSURNAME','ITMCLASS','ITMSUFFIX','ITMCOMPANY','ITMJOBTITLE','ITMDEPARTMENT',
			'LCTEMAIL1','LCTEMAIL2','LCTEMAIL3',

			//ALL Phones
			'LCTPHNPRIMARY',
			'LCTPHNWORK1','LCTPHNWORK2','LCTPHNFAXWORK',
			'LCTPHNHOME1','LCTPHNHOME2','LCTPHNFAXHOME',
			'LCTPHNASSISTANT','LCTPHNCALLBACK','LCTPHNCOMPANY','LCTPHNCAR','LCTPHNISDN','LCTPHNOTHER','LCTPHNOTHERFAX','LCTPHNPAGER',
			'LCTPHNFAXWORK','LCTPHNMOBILE','LCTPHNRADIO','LCTPHNTELEX','LCTPHNHEARING'
		];

		//Loactions
		aItemsInfo.locations = true;

		aItemsInfo.filter.sort = 'ITMSURNAME,ITMFIRSTNAME,ITMCLASSIFYAS';

		WMItems.list(aItemsInfo, '', '','', [async function(aData){

			if (aData && (aData = aData[aItemsInfo.aid]) && (aData = aData[aItemsInfo.fid])){
				var tmp,out = [], loc;

				for(var i in ids[2])
					//Contacts only
					if (aData[ids[2][i]] && aData[ids[2][i]].ITMCLASS == 'C'){
						tmp = {PHONES:[]};
						for(var j in aData[ids[2][i]])
							//Parse Locatons
							if (j === 'LOCATIONS'){
								for(var k in aData[ids[2][i]][j])
									if ((loc = aData[ids[2][i]][j][k]) && (loc = loc.values)){
										//expose home loc
										var l;
										if (loc.LCTTYPE === 'H'){
											for(l in loc) {
												if (l.indexOf('LCTPHN') == 0){
													if (loc[l])
														tmp.PHONES.push({PHNTYPE:getLang('PHONE::'+ l.toUpperCase()), PHNNUMBER:loc[l]});
												}
												loc[l] && (tmp[l] = loc[l]);
											}
										}
										else{
											tmp[loc.LCTTYPE] = {};
											for(l in loc)
												loc[l] && (tmp[loc.LCTTYPE][l] = loc[l]);
										}
									}
							}
							else
							//phones
							if (j.indexOf('LCTPHN') == 0){
								if (aData[ids[2][i]][j])
									tmp.PHONES.push({PHNTYPE:getLang('PHONE::'+ j.toUpperCase()), PHNNUMBER:aData[ids[2][i]][j]});
							}
							else
								tmp[j] = aData[ids[2][i]][j];

						out.push(tmp);
					}

				if (out.length) {
					gui.print = gui.print || await gui._create('print', 'frm_print');
					gui.print._add(sType, out);
				}
			}

		}]);

		break;
	}
};

Item.create = async function(sType, oOptions) {
	oOptions = Object.assign({
		docType: '.docx',
		useCurrentActiveFolder: true
	}, oOptions || {});

	var aActive = gui.frm_main.bar.folders._getActive(),
		sFolder = Mapping.getDefaultFolderForGWType(sType), sAccount = sPrimaryAccount;

	// Pokud je aktualni folder stejneho typu, jako vytvarena polozka, bude vytvorena
	// v danem folderu, jinak se vezme defaultni folder pro dany typ polozky
	if (oOptions.useCurrentActiveFolder && (aActive[0] != '' || aActive[1] != '')) {
		var sFolType = WMFolders.getType(aActive);
		if (sType == sFolType || (sType == 'L' && sFolType == 'C') || (sType == 'F' && (sFolType == 'I' || sFolType == 'Y'))) {
			sAccount = aActive[0];
			sFolder = aActive[1];
		}
	}

	if (sType === 'E') {
		if (gui.frm_main._dashboardLoaded() && gui.frm_main.dashboard._hasCapability('capabilities')) {
			return await gui.frm_main.dashboard._newEventWindow({
				aid: sAccount,
				fid: sFolder
			});
		} else {
			return await Item.openwindow([sAccount, sFolder], getCurrentEventTime(), null, sType);
		}
	} else if (sType === 'N' && gui.frm_main._dashboardLoaded() && gui.frm_main.dashboard._hasCapability('notes') && dataSet.get('dashboard', ['config', 'dashboard_notes_enabled']) == 1) {
		return await gui.frm_main.dashboard._newNoteWindow();
	} else {
		var aValues;
		if (oOptions.docType)
			aValues = {'ATTACHMENTS': [{'values': {'ATTTYPE': 'document', 'ATTDESC': oOptions.docType}}]};

		return await Item.openwindow([sAccount, sFolder], aValues, null, sType);
	}
};

Item.createInFolder = function(sAccount, sFolder, aValues) {
	var sFolderType = WMFolders.getType([sAccount, sFolder]);

	if (sFolderType === 'N' && gui.frm_main._dashboardLoaded() && gui.frm_main.dashboard._hasCapability('notes') && dataSet.get('dashboard', ['config', 'dashboard_notes_enabled']) == 1) {
		return gui.frm_main.dashboard._newNoteWindow({
			title: aValues.EVNTITLE,
			note: aValues.EVNNOTE || (((aValues.NOTES || [])[0] || {}).values || {}).NOTE_TEXT || '',
			note_html: aValues.EVNDESCFORMAT === 'text/html',
			attachments: aValues.PUSH_ATTACHMENTS.map(function(attachment) {
				var path = Path.split(attachment.fullpath, true, true);
				return {
					aid: path.aid,
					fid: path.fid,
					iid: path.iid,
					title: attachment.title,
					size: +attachment.size
				}
			})
		});
	}

	if (sFolderType == 'M'){

		var newMessage = new NewMessage();
		// newMessage.addSignature();

		if (aValues.PUSH_ATTACHMENTS){
			newMessage.aAttachments = {'attachments': []};
			for (var i in aValues.PUSH_ATTACHMENTS)
				if (aValues.PUSH_ATTACHMENTS[i].fullpath)
					newMessage.aAttachments.attachments.push({'values': {'class': 'item', 'fullpath':aValues.PUSH_ATTACHMENTS[i].fullpath, 'name':aValues.PUSH_ATTACHMENTS[i]['title']}});
		}

		if (aValues.EVNTITLE)
			newMessage.sSubject = aValues.EVNTITLE;

		gui._create('frm_compose', 'frm_compose', '', '', newMessage, void 0, {
			context: 'Item',
			fun: ['createInFolder'],
			args: [].slice.call(arguments)
		});
	}
	else
	if (sFolderType === 'F' && !aValues) {
		gui._create('insert_item', 'frm_insert_item', '', 'frm_insert_item_nobottomdiv', [gui.frm_main, '__copyItem', [[sAccount, sFolder]]], sAccount, sFolder, '', gui.frm_main.upload, false, ['F', 'I', 'X'], 'X');
	}
	else
	if (sFolderType === 'I' && aValues.PUSH_ATTACHMENTS) {

		var aBuffer = [];
		aValues.PUSH_ATTACHMENTS.forEach(function(att){
			aBuffer.push({
				class: 'item',
				description: att.title,
				size: att.size,
				fullpath: att.fullpath
			});
		});

		if (aBuffer.length == 1){
			gui._create('chat_upload', 'frm_chat_upload', '', '', aBuffer[0].description, '', {aid:sAccount, fid:sFolder}, [function (sName, sDesc, aArg) {
				Item.CopyToChat(aBuffer, sName, sDesc, aArg, null, {aid:sAccount, fid:sFolder});
			}]);
		}
		else{
			Item.CopyToChat(aBuffer, null, null, null, null, {aid:sAccount, fid:sFolder});
		}

	} else{
		if (sFolderType === 'E') {
			aValues = aValues || {};
			aValues.EVNCLASS = 'E';
		}

		Item.openwindow ([sAccount, sFolder], aValues, null, sFolderType);
	}
};



Item.CopyToChat = function(aBuffer, sName, sDesc, aArg, comevnid, aPath, aHandler){
	if (aBuffer && aBuffer.length){

		var d = new IcewarpDate(),
			aItemInfo = {values:{},ATTACHMENTS:[]};

		aItemInfo.values.EVNSHARETYPE = 'U';
		aItemInfo.values.EVNCLASS = 'F';
		aItemInfo.values.EVNSTARTDATE = d.format(IcewarpDate.JULIAN);
		aItemInfo.values.EVNSTARTTIME = d.hour()*60 + d.minute();

		if (comevnid)
			aItemInfo.values.EVNCOMEVNID = comevnid;

		if (aBuffer.length == 1){

			aItemInfo['values']['EVNRID'] = aItemInfo['values']['EVNLOCATION'] = aItemInfo['values']['EVNTITLE'] = sName || aBuffer[0].name;
			aItemInfo['values']['EVNCOMPLETE'] = aBuffer[0].size;

			if (Is.String(sDesc) && sDesc.length){
				aItemInfo['values']['EVNNOTE'] = sDesc;
				aItemInfo['values']['EVNDESCFORMAT'] = 'text/plain';
			}
		}

		for(var i=0, j = aBuffer.length;i<j;i++)
			aItemInfo['ATTACHMENTS'].push({values:aBuffer[i]});

		//Sent to server
		WMItems.add([aPath.aid,aPath.fid], aItemInfo,'','','', [function(bOK, aData){
			if (bOK && aHandler){
				executeCallbackFunction(aHandler,[bOK, aData, aArg]);
			}
		}]);
	}
};

Item.notify = function(id, sAction, aVal){
	if (gui.socket){
		var f = dataSet.get('folders',[id[0],id[1]]);
		if (f){
			var aOut = {
				'ACTION': sAction,
				'TYPE': id[2] ? 'item' : 'folder',
				'ACCOUNT': id[0],
				'FOLDER': Path.slash(f.RELATIVE_PATH || id[1]),
				'FOLDER-TYPE': f.TYPE,
				'FOLDER-NAME': f.NAME,
				'ITEM': WMItems.__serverID(id[2]),
				'ITEM-TYPE': f.TYPE,
				'EMAIL': f.OWNER || sPrimaryAccount,
				'ORIGINATOR-ID': sPrimaryAccountGWID,
				'ORIGINATOR-NAME': dataSet.get('main',['fullname']),
				'ORIGINATOR-EMAIL': sPrimaryAccount,
				'ORIGINATOR-DEVICEID': dataSet.get('main', ['device_id'])
			};

			if (aVal)
				for(var k in aVal)
					aOut[k] = aVal[k];

			gui.socket.api._notify(aOut);
		}
	}
};

Item.emailAttendees = function(id) {
	return WMItems.list({ aid: id[0], fid: id[1], iid: id[2] }, null, null, null, [function(aData) {
		aData = ((aData[id[0]] || {})[id[1]] || {})[id[2]] || {};
		var aTo = [];
		if (aData.EVNORGANIZER) {
			var cc = MailAddress.splitEmailsAndNames(aData.EVNORGANIZER)[0];
			if (cc.email !== sPrimaryAccount) {
				aTo = [MailAddress.createEmail(cc.name, cc.email)];
			}
		}

		var contacts = aData.CONTACTS || {};
		for(var i in contacts) {
			if (contacts[i].values.CNTEMAIL !== sPrimaryAccount) {
				aTo.push(MailAddress.createEmail(contacts[i].values.CNTCONTACTNAME, contacts[i].values.CNTEMAIL));
			}
		}

		var newMessage = new NewMessage();
		newMessage.sSubject = aData.EVNTITLE;
		newMessage.sTo = aTo.join(',');

		gui._create('frm_compose', 'frm_compose', '', '', newMessage, void 0, {
			context: 'Item',
			fun: ['emailAttendees'],
			args: [id]
		});
	}]);
};

Item.set_lock = function(ids, bLock, bRefreshPreview, aHandler){ //, sItemType
	WMItems.action({"aid": ids[0], "fid": ids[1], "iid": ids[2]}, (bLock?'lock':'unlock'), [function(bOK){
		if (bOK){
			//Notify
			Item.notify(ids, (bLock?'lock':'unlock'), {
				'ITEM-TYPE': '-', //sItemType
				BODY:'1'
			});

			//Refresh DataGrid
			if (bRefreshPreview)
				Item.__refreshView(ids, true);
		}

		/*		//called in __refreshView
		//Refresh preview
		if (bRefreshPreview){
			if (gui.frm_main && gui.frm_main.main && gui.frm_main.main.itemview){

				if (!Is.Array(ids[2]))
					ids[2] = [ids[2]];

				for (var i in ids[2])
					if (dataSet.get('preview', [ids[0], ids[1], ids[2][i]])){
						dataSet.remove('preview');
						Item.open([ids[0], ids[1], ids[2][i]]);
						break;
					}
			}
		}
*/
		if (aHandler)
			executeCallbackFunction(aHandler, bOK);
	}]);
};


Item.edit_value = function(sValue,id,sColumn,aOut){
	aOut = aOut || {values:{}};

	if (sColumn == 'EVNFILENAME' || sColumn == 'CONVERT'){
		WMItems.list({"aid": id[0], "fid": id[1], "iid": id[2], "values": ['ATTACHMENTS']},'','','',[
			function(aData){
				if ((aData = aData[id[0]]) && (aData = aData[id[1]]) && (aData = aData[id[2]]) && (aData = aData.ATTACHMENTS)){
					for(var uid in aData){

						if (sColumn == 'CONVERT'){
							aOut = {ATTACHMENTS:[{"uid":uid,"values":{"convert":sValue}}]};
						}
						else{
							aOut.values['EVNTITLE'] = sValue;
							aOut.values['EVNLOCATION'] = sValue;
							aOut.values['EVNRID'] = sValue;
							aOut.ATTACHMENTS = [{"uid":uid,"values":{"description":sValue}}];
						}

						Item.edit_value('',id,'',aOut);
						return;
					}
				}

				//Some Error...
				Item.__refreshView(id,true);
			}
		]);
		return;
	}
	else
	if (sColumn)
		aOut.values[sColumn] = sValue;

	WMItems.add(id,aOut,'items','','',[
		function(){
			Item.__refreshView(id,true);

			//Refresh preview
			// if (gui.frm_main && gui.frm_main.main && gui.frm_main.main.itemview){

			// 	if (!Is.Array(id[2]))
			// 		id[2] = [id[2]];

			// 	for (var i in id[2])
			// 		if (dataSet.get('preview', [id[0], id[1], id[2][i]])){
			// 			dataSet.remove('preview');
			// 			Item.open([id[0], id[1], id[2][i]]);
			// 			break;
			// 		}
			// }


		}
	]);
};

Item.addCert = function(id) {
	gui._create('add_cert','frm_insert_item','','frm_insert_item_nobottomdiv',[Item.addCert_request, [id]],sPrimaryAccount,Mapping.getDefaultFolderForGWType('C'),'C',false,false, ['C'], false, 'w');
};
Item.addCert_request = function(aItem,ids) {
	if (aItem && aItem[0]){
		aItem = aItem[0];
		WMItems.certificate({account:ids[0],folder:ids[1],item:ids[2],aid:aItem.aid,fid:aItem.fid,iid:aItem.id}, [Item.addCert_response]);
	}
};
Item.addCert_response = async function(aData){
	//Error
	if (aData.error){
		var tmp = 'CERTIFICATE::';
		switch(aData.error){
		case 'account_invalid_id':
		case 'item_invalid_id':
		case 'folder_does_not_exist':
			tmp += 'INVALIDITEM';
			break;
		case 'certificate_data_missing':
			    tmp += 'MISSING';
		}

		gui.notifier._value({type: 'alert', args: {header: '', text: tmp}});
	}
	// OK
	else{
		var obj = await gui._create('confirm','frm_confirm','','',[Item.open,[[aData.data.aid, aData.data.fid, aData.data.iid]]],'CERTIFICATE::CERTIFICATE','CERTIFICATE::ASSIGNED');
		    obj.x_btn_ok._value('POPUP_ITEMS::OPEN');
		    obj = null;
	}

/*
 [data]
.. [aid](string) = admin@merakdemo.com
.. [fid](string) = Contacts
.. [iid](string) = 3a2c8e2a3005
*/

};

/**
 * Recover items from recovery folder to their original folders
 *
 * @param Array   aIds Standard ids array (0: account id, 1: folder id, 2: array of item ids)
 * @param Boolean bAsk Show confirmation dialog at the beginning
 *
 * @return undefined
 */
Item.recover = function(aIds, bAsk) {
	var helper;

	helper = new ItemsRecoverHelper(
		aIds,
		bAsk,
		[Item.__recoverCallback] // Argument for executeCallbackFunction
	);

	helper.process();
};

/**
 * Callback which is called at the end of items recovery
 *
 * @param Array aFoldersMapping Folders mapping (format: [{source: 'xy', destination: 'xy'}, ...])
 * @param Array aIds            Standard ids array (0: account id, 1: folder id, 2: array of item ids)
 *
 * @return undefined
 */
Item.__recoverCallback = async function(aFoldersMapping, aIds) {
	await WMItems.recover(
		{
			'aid':aIds[0],
			'fid':aIds[1],
			'iid':aIds[2],
			'action': 'recover'
		},
		'items',
		'',
		'folders',
		aFoldersMapping
	);

	if (!Item.__removeFromDataset(aIds))
		Item.__refreshView(aIds, true);
};

Item.copy = async function(ids, oOriginator) {
	return await gui._create('frm_select_folder', 'frm_quick_select_folder', '', '', 'POPUP_ITEMS::COPY_MAIL_TO', ids[0], ids[1],
		[Item.__copyOrMoveItems, ['copy' + ((oOriginator && oOriginator._select_all) ? 'all' : ''), ids]], false, false, WMFolders.getType(ids),'w'
	);
};

Item.copyToAlfresco = function(ids) {
	gui._create('frm_select_folder', 'frm_quick_select_folder', '', '', 'POPUP_ITEMS::COPY_MAIL_TO', '@@alfresco@@', '', [Item.__copyOrMoveItems, ['copy', ids]], false, true, 'K');
};

Item.clone = function(ids) {
	WMItems.copy({
		'aid': ids[0],
		'fid': ids[1],
		'iid': ids[2],
		'account': ids[0],
		'folder': ids[1],
		'duplicity':"rename"
	}, 'items', '', 'folders', [function () {
		Item.__refreshView([ids[0], ids[1]], true);
	}]);
};

Item.move = async function(ids, oOriginator, iNext) {
	var popup = await gui._create('frm_select_folder', 'frm_quick_select_folder', '', '', 'POPUP_ITEMS::MOVE_MAIL_TO', ids[0], ids[1],
		[function(destAcc, destFol) {

			if (ids[0] === destAcc && ids[1] === destFol) {
				gui.notifier._value({
					type: 'alert',
					args: {
						header: 'ERROR::SAME_FOLDER'
					}
				});
				return Item.move(ids, oOriginator, iNext);
			}
			Item.__copyOrMove(ids, destAcc, destFol, false, oOriginator, iNext);
		}], false, true, WMFolders.getType(ids),'w'
	);
	return popup;
};

/**
 * Share to Teamchat
 *
 * @param {object} files
 * @param {object} opt
 */
Item.copy_tch = function(files, opt, oGui) {
	opt = opt || {};

	var folderType = WMFolders.getType([files[0], files[1]]);

	function __uploadhandler(aTo, aBuffer, sName, sDesc) {
		if (aBuffer && aBuffer.length){
			var d = new IcewarpDate(),
				aItemInfo = {values: {}, ATTACHMENTS: []};

			aItemInfo.values.EVNSHARETYPE = 'U';
			switch(folderType) {
				case 'M':
				case 'E':
					aItemInfo.values.EVNCLASS = folderType;
					break;
				default:
					aItemInfo.values.EVNCLASS = 'F';
			}
			aItemInfo.values.EVNSTARTDATE = d.format(IcewarpDate.JULIAN);
			aItemInfo.values.EVNSTARTTIME = d.hour()*60 + d.minute();

			if (aBuffer.length == 1){
				aItemInfo['values']['EVNRID'] = aItemInfo['values']['EVNLOCATION'] = aItemInfo['values']['EVNTITLE'] = sName || aBuffer[0].name;
				aItemInfo['values']['EVNCOMPLETE'] = aBuffer[0].size;

				if (Is.String(sDesc) && sDesc.length){
					aItemInfo['values']['EVNNOTE'] = sDesc;
					aItemInfo['values']['EVNDESCFORMAT'] = 'text/plain';
				}
			}

			for (var i = 0, j = aBuffer.length; i < j; i++) {
				aItemInfo['ATTACHMENTS'].push({values:aBuffer[i]});
			}

			//Sent to server
			WMItems.add(aTo, aItemInfo,'','','', [function(bOK, aData){
				if (bOK){
					gui.notifier._value({type: 'message_sent_tch', args: [WMFolders.getFolderName({aid: aTo[0], fid: aTo[1]})]});
				} else {
					if(aData === 'item_create') {
						aData = 'ALERTS::FOLDER_INSUFFICIENT_RIGHTS';
					} else {
						aData = 'ERROR::' + aData;
					}
					gui.notifier._value({type: 'alert', args: {header: 'ALERTS::MESSAGE_NOT_SAVED', text: aData}});
				}
			}.bind(this)]);
		}
	};

	var sFolder;
	var f = dataSet.get('folders', [sPrimaryAccount]);
	for(var id in f){
		if (f[id].TYPE == 'I'){
			sFolder = id;
			break;
		}
	}

	if (sFolder) {
		(oGui || gui)._create('frm_select_folder', 'frm_select_folder', '', '', 'CHAT::SELECT', sPrimaryAccount, sFolder,
			[async function(aid, fid) {
				var __upload_buffer = [];

				for (var i in files[2]) {
					var file = files[2][i];
					var data = dataSet.get('items', [files[0], files[1], file]) || (await WMItems.list({aid: files[0], fid: files[1], iid: file}))[files[0]][files[1]][WMItems.__clientID(file)];

					if (data){
						var sFileName = '';
						switch(folderType){
							case 'I':
							case 'F':
							case 'E':
								sFileName = data.EVNTITLE;
								break;
							case 'M':
								sFileName = data.SUBJECT || getLang('MAIL_VIEW::NOSUBJECT');
								break;
							case 'C':
								sFileName = data.ITMCLASSIFYAS + '.vcf';
								break;
							default:
								sFileName = data.EVNTITLE + '.ics';
						}
					}

					sFileName = sFileName.split('.');
					var ext = '';
					if (sFileName.length > 1) {
						ext = '.' + sFileName.pop();
					}
					sFileName = sFileName.join('.').substr(0, 128 - ext.length) + ext;

					__upload_buffer.push({
						'class': 'item',
						'description': (sFileName || '').replace(/[<>:/\\|?*""[\]]/g, ''),
						'size': data.SIZE || data.EVNCOMPLETE,
						'fullpath': files[0] + '/' + files[1] + '/' + WMItems.__serverID(file).replace(/\|.*/, ''),
						'client_id': file
					});
				};

				if (__upload_buffer.length == 1) {
					(oGui || gui)._create('chat_upload', 'frm_chat_upload', '', '', __upload_buffer[0].description, '', {aid: aid, fid: fid}, [function (sName, sDesc, aArg) {

						//link one item
						if (opt.link){

							WMItems.action({"aid": files[0], "fid": files[1], "iid": __upload_buffer[0].client_id, nodes:{note:sDesc, folder:fid}}, 'document_link', [function(bOK){
								if (bOK)
									gui.notifier._value({type: 'message_sent_tch', args: [WMFolders.getFolderName({aid: files[0], fid: files[1]})]});
								else
									gui.notifier._value({type: 'alert', args: {header: 'ALERTS::MESSAGE_NOT_SAVED', text: 'ALERTS::FOLDER_INSUFFICIENT_RIGHTS'}});
							}]);

							return;
						}

						__uploadhandler([aid, fid], __upload_buffer, sName, sDesc, aArg);
					}]);
				}
				else
				//link multiple items
				if (opt.link){
					__upload_buffer.forEach(function(file){
						WMItems.action({"aid": files[0], "fid": files[1], "iid": file.client_id, nodes:{folder:fid}}, 'document_link', [function(bOK){
							if (bOK)
								gui.notifier._value({type: 'message_sent_tch', args: [WMFolders.getFolderName({aid: files[0], fid: files[1]})]});
							else
								gui.notifier._value({type: 'alert', args: {header: 'ALERTS::MESSAGE_NOT_SAVED', text: 'ALERTS::FOLDER_INSUFFICIENT_RIGHTS'}});
						}]);
					});
				}
				else{
					__uploadhandler([aid, fid], __upload_buffer);
				}
			}], true, true, ['Y','I'], '', true
		);
	}
};

Item.invite_tch = function(sMail){
	var sFolder;
	var f = dataSet.get('folders', [sPrimaryAccount]);
	for(var id in f){
		if (f[id].TYPE == 'I'){
			sFolder = id;
			break;
		}
	}

	if (sFolder) {
		gui._create('frm_select_folder', 'frm_select_folder', '', '', 'CHAT::SELECT', sPrimaryAccount, sFolder,
			[function(aid, fid) {
				gui._create('invite', 'frm_groupchat_invite','','',{aid:aid, fid:fid},[function(){
					gui.notifier._value({type: 'success', args: {text: 'CHAT::INVITATION_SENT'}});
				}],sMail);
			}], true, true, ['Y','I'], '', true
		);
	}
};

/**
 * Sends message to the TeamChat Room
 *
 * @param {*} sFolder
 * @param {*} sBody
 * @param {*} aHandler
 * @returns folder picker form
 */
Item.message_tch = function(sFolder, sBody, aHandler){

	function mssg (sFolder, sBody){
		var aItemInfo = {
			values:{
				EVNNOTE: sBody,
				EVNSHARETYPE: 'U'
			}
		};

		WMItems.add([sPrimaryAccount, sFolder], aItemInfo,'','','', aHandler);
	};

	if (!sFolder){
		var f = dataSet.get('folders', [sPrimaryAccount]);
		for(var id in f){
			if (f[id].TYPE == 'I'){
				sFolder = id;
				break;
			}
		}

		if (sFolder) {
			gui._create('frm_select_folder', 'frm_select_folder', '', '', 'CHAT::SELECT', sPrimaryAccount, sFolder,
				[function(aid, sFolder) {
					mssg(sFolder, sBody);
				}], true, true, ['Y','I'], '', true
			);
		}
	}
	else
		mssg(sFolder, sBody);
};

Item.downloadMultiple = function(ids) {
	WMItems.save_items({"aid": ids[0], "fid": ids[1], "iid": ids[2]});
};

Item.downloadSource = async function(id,ext) {
	var iid = Array.isArray(id[2]) ? id[2][0] : id[2];
	iid = WMItems.__clientID(iid);
	try {
		var static_flags = ((await WMItems.list({aid: id[0], fid: id[1], iid: iid, values: ['STATIC_FLAGS']}))[id[0]][id[1]][iid] || {}).STATIC_FLAGS;
		if (static_flags & 4 || static_flags & 8 || static_flags & 16 || static_flags & 32) {
			return gui.notifier._value({type: 'alert', args: {header: '', text: 'ERROR::ACTION_DISABLED'}});
		}
	} catch {}

	var aUrl = {'dlsess': dataSet.get('main', ['dlsess']), 'class': 'item'+(ext || ''), 'fullpath': id[0]+'/'+id[1]+'/'+WMItems.__serverID(iid.replace(/\|\w+/, ''))};
	downloadItem(buildURL(aUrl));
};

Item.webdavURL = async function(id, sAtId, oParts) {
	try{
		if (!Array.isArray(id)) {
			id = [id.aid || sPrimaryAccount, id.fid, WMItems.__clientID(id.iid)];
		} else {
			id = [id[0] || sPrimaryAccount, id[1], WMItems.__clientID(id[2])];
		}
		if (!Is.Defined(sAtId)){
			var aData = (await WMItems.list({aid: id[0], fid: id[1], iid: id[2], values: ['EVN_ID']}))[id[0]][id[1]][id[2]];
			for (sAtId in aData['ATTACHMENTS']) {
				break;
			}

			if (!Is.Defined(sAtId))
				return false;
		} else {
			sAtId = encodeURIComponent(decodeURIComponent(sAtId)).replace(/%26/g, '&').replace(/%20/g, ' ');
		}

		return sPrimaryAccountClient + 'server/download.php?' + buildURL(Object.assign({
			dlsess: dataSet.get('main', ['dlsess']),
			class: sAtId.length ? 'attachment' : 'item',
			fullpath: [id[0], id[1], WMItems.__serverID(id[2]), sAtId].filter(Boolean).join('/')
		}, oParts || {}));
	}
	catch(r){ console.log(this._name||false,r)}

	return false;
};
Item.downloadFile = async function(id) {
	try{
		downloadItem(await Item.getPublicUrl(id) || await Item.webdavURL(id), true);
		return true;
	}
	catch(r){ console.log(this._name||false,r)}

	return false;
};
Item.getPublicUrl = async function(id) {
	try{
		id = clone(id);
		id[2] = WMItems.__clientID(id[2]);
		var aData = (await WMItems.list({"aid": id[0], "fid": id[1], "iid": id[2], "values": ['EVN_ID']}))[id[0]][id[1]][id[2]];
		for (var sAtId in aData['ATTACHMENTS'])
			break;

		return aData.ATTACHMENTS[sAtId].values.TICKET || false;
	} catch {
		//
	}

	return false;
};

/**
 * oOriginator - object which will be focused after execution
 * iNext - originator next value
 */
Item.remove = async function(ids, bForce, oRepeating, oOriginator, iNext, aHandler)
{
	var frm;
	if (Is.Object(oRepeating)){
		frm = await gui._create('frm_confirm','frm_confirm_repeating','','frm_trash', [Item.__removeWithRepeating, [ids,oRepeating,void 0, bForce, aHandler]],'REPEATING_CONFIRM::TITLE_DELETE','REPEATING_CONFIRM::TEXT_DELETE');

		//return focus to originator object if any
		if (oOriginator && oOriginator._focus){
			frm.___returnFocus = function(){
				oOriginator._focus();
			};
			frm._add_destructor('___returnFocus');
		}

		return;
	}

	await storage.library('gw_others');

	var sFolderType = WMFolders.getType(ids);

	if (bForce){
		return Item.__delete(ids, oOriginator, iNext, bForce, aHandler);
	}
	else
	if (sFolderType == 'M' && parseInt(GWOthers.getItem('MAIL_SETTINGS_GENERAL','move_to_trash'))>0){
		//Primary Account
		var sTrashFolder = Path.split(GWOthers.getItem('DEFAULT_FOLDERS','trash'))[1];

		//Other Account
		if (sPrimaryAccount != ids[0]){
			var sTrash = dataSet.get('accounts',[ids[0],'TRASHFOLDER']);
			if (sTrash)
				sTrashFolder = Path.split(sTrash)[1];
		}

		// Alias
		var from = ids[1].indexOf(sPrimaryAccountSPREFIX) === 0 && (ids[1].split('/')[0] || '').replace(new RegExp('^' + sPrimaryAccountSPREFIX), '');
		if (from) {
			var aliases = dataSet.get('storage',['ALIASES','ITEMS']);

			for(var i in aliases) {
				if (aliases[i].VALUES.EMAIL.VALUE.toLowerCase() === from && (aliases[i].VALUES.TRASHFOLDER || {}).VALUE) {
					sTrashFolder = Path.split(aliases[i].VALUES.TRASHFOLDER.VALUE)[1];
				}
			}
		}

		if (sTrashFolder != ids[1]){

			var aFolders = dataSet.get('folders');
			if (!aFolders[ids[0]][sTrashFolder])
				dataSet.add('folders',[ids[0],sTrashFolder],{'NAME':sTrashFolder,'TYPE':'M','RIGHTS':'rwmd'});

			return Item.__copyOrMove(ids, sPrimaryAccount, sTrashFolder, false, oOriginator, iNext);
		}
	}

	if (gui.__bSkipDeleteConfirmation){
		Item.__delete(ids,oOriginator,iNext, false, aHandler);
		if (oOriginator && oOriginator._focus)
			oOriginator._focus();
	} else {

		var title = 'CONFIRMATION::DELETE_ITEM_CONFIRMATION';
		var label = 'CONFIRMATION::DELETE_ITEM';

		if (sFolderType === 'F') {
			var items = dataSet.get('items', [ids[0], ids[1]]);
			var isShared = ids[2].some(function(iid) {
				return items[iid].EVNURL;
			}, this);
			var isSmartAttached = ids[2].some(function(iid) {
				return items[iid].EVNURL && ~(items[iid].EVNTYPE || '').indexOf('SmartAttach');
			}, this);

			if (isSmartAttached) {
				title = 'CONFIRMATION::DELETE_SMART_ITEM_CONFIRMATION';
				label = 'CONFIRMATION::DELETE_SMART_ITEM';
			} else if (isShared) {
				title = 'CONFIRMATION::DELETE_SHARED_ITEM_CONFIRMATION';
				label = 'CONFIRMATION::DELETE_SHARED_ITEM';
			}
		}

		frm = await gui._create('frm_confirm','frm_confirm', '', 'noblur frm_trash', [Item.__delete, [ids,oOriginator,iNext,false,aHandler]], title, label);

		if (sPrimaryAccountGWTRASH){
			switch(sFolderType) {
				case 'M':
				case 'G':
				case 'Q':
				case 'QL':
					addcss(frm.x_btn_ok._main,'color2');
					break;

				default:
					frm.obj_label.__eIN.innerHTML += '<br>' + getLang('CONFIRMATION::DELETE_ITEM_TRASH');
				}
		}
		else{
			addcss(frm.x_btn_ok._main,'color2');
		}
		frm._size(400, 'auto');

		var skip = await frm._create('skip','obj_button_check','footer', 'transparent simple x_btn_right');
		skip._value('POPUP_ITEMS::SKIP_DELETE');
		skip._tabIndex();
		skip._onclick = function(){
			gui.__bSkipDeleteConfirmation = this._checked()>0;
		};

		//return focus to originator object if any
		if (oOriginator && oOriginator._focus){
			frm.___returnFocus = function(){
				if (oOriginator._focus)
					oOriginator._focus();
			};
			frm._add_destructor('___returnFocus');
		}
	}
};

Item.setColor = function(id, sColor) {
	var sOldColor = Item.getColor(id);

	if (!sOldColor || (sOldColor != sColor)) {
		dataSet.add('items', id.concat(['EVNCOLOR']), sColor);
		WMItems.add(id, {'values': {'EVNCOLOR': sColor}}, 'items');
	}
};

Item.getColor = function(id) {
	return dataSet.get('items', id.concat(['EVNCOLOR']));
};

Item.hasReccurence = function(id,rcr_id,itmData) {
	if (!Is.Object(id))	return false;

	itmData = itmData && itmData.EVNRCR_ID?itmData:dataSet.get('items',id);

	if (!Is.Object(itmData) || itmData.EVNCLASS == 'O') return false;

	if (!Is.Defined(rcr_id))
		rcr_id = itmData.EVNRCR_ID;

	return rcr_id?true:false;
};
Item.sendEmailTo = function(sLctEmail,aValues){
	if (sPrimaryAccountGUEST || (window.TeamChatAPI && TeamChatAPI.teamChatOnly())){
		window.location.href = "mailto:"+sLctEmail;
		return;
	}

	var newMessage = new NewMessage();
	newMessage.sTo = sLctEmail;
	// newMessage.addSignature();

	if (aValues){
		for (var i in aValues)
			if (Is.Function(newMessage[i]))
				newMessage[i](aValues[i]);
			else
				newMessage[i] = aValues[i];
	}

	gui._create('frm_compose', 'frm_compose', '', '', newMessage, void 0, {
		context: 'Item',
		fun: ['sendEmailTo'],
		args: [].slice.call(arguments)
	});

};

Item.sendAsEmail = async function(ids) {

	var aData, sName = '', sSize,
		sFTyle = WMFolders.getType(ids),
		newMessage = new NewMessage();
	// newMessage.addSignature();
	newMessage.aAttachments = {'attachments': []};

	for (var i in ids[2]){
		if (!Is.Defined(sName = dataSet.get('items', [ids[0], ids[1], ids[2][i], sFTyle == 'C'?'ITMCLASSIFYAS':'EVNTITLE']))){
			aData = await WMItems.list({"aid": ids[0], "fid": ids[1], "iid": ids[2][i], "values": [(sFTyle == 'C'?'ITMCLASSIFYAS':'EVNTITLE')]});
			try{
				sName = aData[ids[0]][ids[1]][ids[2][i]][sFTyle == 'C'?'ITMCLASSIFYAS':'EVNTITLE'] || getLang('EVENT_VIEW::NO_TITLE');
			}
			catch{
				continue;
			}
		}

		sSize = dataSet.get('items', [ids[0], ids[1], ids[2][i],'EVNCOMPLETE']);

		if (sName){
			newMessage.sSubject = sName;

			if (sFTyle != 'F')
				sName += sFTyle == 'C'?'.vcf':'.ics';

			newMessage.aAttachments.attachments.push({
				values: {
					class: 'item',
					fullpath: ids[0] + '/' + ids[1] + '/' + WMItems.__serverID(ids[2][i]),
					size: sSize,
					name: sName,
					id: ids[2][i]
				}
			});
		}
	}

	gui._create('frm_compose', 'frm_compose', '', '', newMessage, void 0, {
		context: 'Item',
		fun: ['sendAsEmail'],
		args: [].slice.call(arguments)
	});
};
/*
	acc, fol - destination folder
	v - drop values
*/
Item.__convertToFolder = async function(acc,fol,v, oOriginator, iNext){
	var t1  = WMFolders.getType([acc,fol]),
		t2  = WMFolders.getType(v.value[0]);

	//create ids
	var ids = [v.value[0].aid,v.value[0].fid,[]];
	for(var i in v.value)
		ids[2].push(WMItems.__clientID(v.value[i].iid));

	//Drag & Drop doesnt work with popups because of event handlers.
	gui.frm_main.dnd.remove_drag(true);

	if (v[0] === acc && v[1] === fol) {
		return gui.notifier._value({
			type: 'alert',
			args: {
				header: 'ERROR::SAME_FOLDER'
			}
		});
	}

	if (fol == 'SPAM_QUEUE/Whitelist' || fol == 'SPAM_QUEUE/Blacklist'){
		if (t2 == 'M')
			OldMessage.__blackOrWhiteList(ids, fol == 'SPAM_QUEUE/Whitelist');
	}
	else
	if (t1!=t2){
		var title = [], name, mail, q, note, arg, out = {}, att = [];
		for(i in v.value){

			arg = {
				id:v.value[i].iid,
				fullpath:v.value[i].aid+'/'+v.value[i].fid+'/'+WMItems.__serverID(v.value[i].iid),
				embedded:true
			};

			//Detail Request
			var aReq = {"aid": v.value[i].aid, "fid": v.value[i].fid, "iid": v.value[i].iid};
			if (t2 == 'P' || t2 == 'M')
				aReq.values = ['SUBJECT','SIZE','FROM','HTML','STATIC_FLAGS'];

			if (!(q = (await WMItems.list(aReq))[v.value[i].aid][v.value[i].fid][WMItems.__clientID(v.value[i].iid)]))
				return;

			switch(t2){
			case 'R':
				try{
					if (typeof title[0] == 'undefined')	title.push(q.SUBJECT);
					note = note || q.TEXT || q.HTML;
				}
				catch(r){ console.log(this._name||false,r)}

				break;

			case 'P':
			case 'M':
				arg.title = q.SUBJECT || '';
				arg.size =  q.SIZE || 0;

				if (typeof title[0] == 'undefined'){
					if (t1=='C'){
						var splited = MailAddress.splitEmailsAndNames(q.FROM);
						if (splited[0]){
							mail = splited[0].email;
							name = splited[0].name;
						}
					}
					title.push(arg.title);

					note = q.HTML;
					if (q.STATIC_FLAGS & 1)
						out[t1 == 'C' || t1 == 'D'?'ITMDESCFORMAT':'EVNDESCFORMAT'] = 'text/html';
				}

				arg.title += (arg.title?' - ':'')+ WMItems.__serverID(v.value[i].iid);

				break;

			case 'F':

				arg.title = q.EVNLOCATION;
				arg.size = q.EVNCOMPLETE || 0;
				arg.type = 'push_attachment';

				if (typeof title[0] == 'undefined' && !note)
					note = q.EVNNOTE;

				break;

			case 'C':
			case 'D':

				if (typeof title[0] == 'undefined' && !note)
					note = q.ITMDESCRIPTION;

				arg.title = q.ITMCLASSIFYAS + '.vcf';
				break;

			case 'N':
			case 'T':
			case 'E':
			case 'J':
				if (typeof title[0] == 'undefined' && !note)
					if (t2 == 'N') {
						note = q.NOTES && q.NOTES[0].values?q.NOTES[0].values.NOTE_TEXT:'';
					}else
						note = q.EVNNOTE;

				arg.title = (q.EVNTITLE || q.ITMTITLE || '') + '.ics';
			}

			att.push(arg);
		}

		if (name)
			parseNameToLocation(name,out);

		if (mail)
			out.LOCATIONS = [{values:{LCTTYPE:'H',LCTEMAIL1:mail}}];

		if (note){
			switch(t1){
			case 'C':
			case 'D':
				out.ITMDESCRIPTION = note;
				break;
			case 'N':
				out.NOTES = [{values:{NOTE_TEXT:note}}];
				break;
			case 'I':
				break;
			default:
				out.EVNNOTE = note;
			}
		}

		out.EVNTITLE = title.join(', ');

		if (t2 != 'R')
			out.PUSH_ATTACHMENTS = att;

		Item.createInFolder(acc, fol, out);
	}
	else {
		Item.__copyOrMove(ids, acc, fol, v.ctrl, oOriginator, iNext);
	}
};

Item.__copyOrMove = function(ids, acc, fol, bCtrl, oOriginator, iNext) {
	var all = oOriginator && oOriginator._select_all;
	oOriginator && (oOriginator._select_all = false);

	if (bCtrl) {
		return Item.__copyOrMoveItems(acc, fol, all ? 'copyall' : 'copy', ids);
	}

	if (!all && ((ids[1] !== '__@@SNOOZED@@__') || (fol === Path.split(GWOthers.getItem('DEFAULT_FOLDERS', 'trash'))[1]))) {
		Item.__removeFromDataset(ids, [acc, fol]);

		if (oOriginator) {
			oOriginator.__subtotal -= ids[2].length;
			oOriginator._removeItems && oOriginator._removeItems(ids[2]);
			if (oOriginator._focus)
				oOriginator._focus();
			if (typeof iNext != 'undefined')
				oOriginator._value([iNext], false, false);
		}
	}

	if (all) {
		gui.notifier._value({
			type: 'item_moved',
			args: {
				aid_from: ids[0],
				fid_from: ids[1],
				aid: acc,
				fid: fol,
				iid: '*'
			}
		});
		Item.__copyOrMoveItems(acc, fol, 'moveall', ids, oOriginator);
		oOriginator._serverSort(false, false, false, false, false, true, true);
		return;
	}

	Item.__moveNotifications[ids[0]] 		=		Item.__moveNotifications[ids[0]] || {};
	Item.__moveNotifications[ids[0]][ids[1]] 	=	Item.__moveNotifications[ids[0]][ids[1]] || {};
	Item.__moveNotifications[ids[0]][ids[1]][acc] = Item.__moveNotifications[ids[0]][ids[1]][acc] || {};
	if (Item.__moveNotifications[ids[0]][ids[1]][acc][fol]) {
		gui.notifier._closeNotification(Item.__moveNotifications[ids[0]][ids[1]][acc][fol].notification, true);
		ids[2] = ids[2].concat(Item.__moveNotifications[ids[0]][ids[1]][acc][fol].ids[2]);
	}
	Item.__moveNotifications[ids[0]][ids[1]][acc][fol] = {
		ids: ids,
		notification: gui.notifier._value({
			type: 'item_moved',
			args: {
				aid_from: ids[0],
				fid_from: ids[1],
				aid: acc,
				fid: fol,
				iid: ids[2],
				callback: {
					onclose: function() {
						delete Item.__moveNotifications[ids[0]][ids[1]][acc][fol];
						Item.__copyOrMoveItems(acc, fol, 'move', ids);
					},
					undo: function() {
						delete Item.__moveNotifications[ids[0]][ids[1]][acc][fol];
						dataSet.add('removedFromDataset', [ids[0], ids[1]], (dataSet.get('removedFromDataset', [ids[0], ids[1]]) || []).filter(function(id) {
							return !~ids[2].indexOf(id);
						}), true);
						oOriginator._serverSort(false, false, false, false, false, true, true);
						WMFolders.list({aid: acc, fid: fol}, '', '', [function(aData) {
							dataSet.add('folders', [acc, fol, 'RECENT'], aData[acc][fol].RECENT, true);
							dataSet.add('folders', [acc, fol, 'COUNT'], aData[acc][fol].COUNT, true);
							dataSet.update('folders');
						}]);
					}
				}
			},
			browserOnly: true
		})
	};
};
Item.__moveNotifications = {};

Item.__copyOrMoveItems = function(sDestAccount, sDestFolder, sAction, ids, oOriginator, iNext, callback) {
	if (sDestAccount && sDestFolder && (sAction != 'move' || sDestAccount != ids[0] || sDestFolder != ids[1]))
	{
		switch(sAction)
		{
		case 'copyall':
		case 'moveall':
			oOriginator && oOriginator._removeItems && oOriginator._removeItems(ids[2]);
			var filter = ids[3] || ((dataSet.get('current_folder') === (ids[0] + '/' + ids[1])) && oOriginator && (oOriginator.__filter.search || '').replace(/\+folders:".*?"/, '').trim());
			WMFolders.action({aid: ids[0], fid: ids[1], filter: filter },'folders','',sAction,{aid:sDestAccount,fid:sDestFolder});
			break;
		case 'copy':
			ids[2] = ids[2].map(function(id) {
				return id.split('|')[0];
			});
			//Async copy items and refresh folders (folder tree)
			WMItems.copy({'aid':ids[0],'fid':ids[1],'iid':ids[2],'account':sDestAccount,'folder':sDestFolder},'items','','folders',[function(bOK){
				if (bOK) {
					if (sDestAccount === '@@alfresco@@') {
						var item = dataSet.get('items', ids);
						if (ids[2].length > 1 || !item) {
							gui.notifier._value({type: 'success', args: {text_plain: getLang('NOTIFICATION::ITEMS_COPIED_ALFRESCO', [ids[2].length, sDestFolder])}});
						} else {
							gui.notifier._value({type: 'success', args: {text_plain: getLang('NOTIFICATION::ITEM_COPIED_ALFRESCO', [item.SUBJECT || item.EVNTITLE, sDestFolder])}});
						}
					} else {
						gui.notifier._value({type: 'item_copied', args: {
							aid_from: ids[0],
							fid_from: ids[1],
							aid: sDestAccount,
							fid: sDestFolder,
							iid: ids[2]
						}});
					}
					Item.notify([sDestAccount, sDestFolder], 'UPDATE');
				}
				Item.__refreshView([sDestAccount,sDestFolder],true);
				callback && callback(bOK);
			}]);
			break;

		case 'move':
			if (sDestAccount != ids[0] || sDestFolder != ids[1]) {
				ids[2] = ids[2].map(function(id) {
					return id.split('|')[0];
				});

				var rfd = false;
				if ((ids[1] !== '__@@SNOOZED@@__') || (sDestFolder === Path.split(GWOthers.getItem('DEFAULT_FOLDERS', 'trash'))[1])) {
					rfd = Item.__removeFromDataset(ids, [sDestAccount, sDestFolder]);

					if (oOriginator){
						oOriginator.__subtotal -= ids[2].length;
						oOriginator._removeItems && oOriginator._removeItems(ids[2]);
						if (oOriginator._focus)
							oOriginator._focus();
						if (typeof iNext != 'undefined')
							oOriginator._value([iNext], false, false);
					}
				}
				WMItems.move({'aid':ids[0],'fid':ids[1],'iid':ids[2],'account':sDestAccount,'folder':sDestFolder},'items','','folders',[
					function(bOK){
						if (bOK) {
							if (sDestAccount === '@@alfresco@@') {
								var item = dataSet.get('items', ids);
								if (ids[2].length > 1 || !item) {
									gui.notifier._value({type: 'success', args: {text_plain: getLang('NOTIFICATION::ITEMS_MOVED_ALFRESCO', [ids[2].length, sDestFolder])}});
								} else {
									gui.notifier._value({type: 'success', args: {text_plain: getLang('NOTIFICATION::ITEM_MOVED_ALFRESCO', [item.SUBJECT || item.EVNTITLE, sDestFolder])}});
								}
							}

							for(var n in ids[2]) {
								Item.notify(makeIDFromIDS(ids, WMItems.__serverID(n)), 'DELETE', {
									'ACCOUNT-ID': sDestAccount,
									'FOLDER-ID': sDestFolder
								});
							}
							Item.notify([sDestAccount, sDestFolder], 'UPDATE');
						}
						if (Mapping.isGlobalSearchFolder(ids[1]) || !rfd) {
							Item.__refreshView(ids, true);
						}
						Item.__refreshView([sDestAccount, sDestFolder], true);
						callback && callback(bOK);
					}]);
			}
			break;
		}
	}
};

Item.__removeWithRepeating = function(iState, ids, oRepeating,oOriginator, bForce, aHandler) {
	var aValues = {};
	bForce && (aValues.skip_trash = 1);
	switch(iState.toString()){
	case '2':
		aValues.EXPFOLLOWING = 'true';
	case '0':
		aValues.EXPDATE = oRepeating['EVNSTARTDATE'];
		WMItems.remove({'aid':ids[0],'fid':ids[1],'iid':ids[2].map(function(id) {
			return id.split('|')[0];
		}),'values':ids[2].map(function(){return aValues})},'items','','folders',[function(){
			if (aHandler)
				executeCallbackFunction(aHandler, true);
			else
				Item.__refreshView(ids,true);
		}]);
		break;
	default:
		ids[2] = ids[2].map(function(id) {
			return id.split('|')[0];
		});
		Item.__delete(ids, void 0, void 0, bForce, aHandler);
	}
};

/**
 * optional oOriginator,iNext (for DataGrid purpose)
 **/
Item.__delete = function(ids,oOriginator,iNext, skip_trash,aHandler) {

	// DELETE SELECTION 2
	for (var i in ids[2])
		 if (ids[2][i].indexOf('|')>-1)
		 	delete ids[2][i];

	if (!count(ids[2])) return;

	// Refresh folders (folder tree)
	// var aFolderProps = dataSet.get('folders',[ids[0],ids[1]]);
	// if (~['M', 'R'].indexOf(WMFolders.getType(ids))){
	// 	var iRecent = aFolderProps['RECENT'] || 0;

	// 	for(var n in ids[2])
	// 		if (!WMItems.getFlag(makeIDFromIDS(ids,n),'SEEN','items'))
	// 			iRecent--;

	// 	dataSet.add('folders',[ids[0],ids[1],'RECENT'],(iRecent>0?aFolderProps['RECENT']:0).toString(),true);
	// 	dataSet.update('folders',[ids[0],ids[1],'RECENT']);
	// }
	var data = {
		'aid': ids[0],
		'fid': ids[1],
		'iid': ids[2]
	};
	if (skip_trash) {
		data.values = ids[2].map(function () {
			return {skip_trash: 1};
		});
	}

	var rfd = Item.__removeFromDataset(ids);

	if (oOriginator) {
		oOriginator.__subtotal -= ids[2].length;
		oOriginator._removeItems && oOriginator._removeItems(ids[2]);

		if (oOriginator._focus)
			oOriginator._focus();
		if (typeof iNext != 'undefined')
			oOriginator._value([iNext],  false, false);
	}

	WMItems.remove(data,'items','','folders',[function(bOK){
		if (bOK){
			// Async remove items
			if(!rfd && !aHandler)
				Item.__refreshView(ids);

			for(var n in ids[2]) {
				Item.notify(makeIDFromIDS(ids, WMItems.__serverID(n)), 'DELETE');
			}

		} else if (!aHandler) {
			Item.__refreshView(ids);
		}

		if (aHandler)
			executeCallbackFunction(aHandler, bOK);
	}]);
};

Item.__removeFromDataset = function(ids, aDest)
{
	var sFolType = WMFolders.getType(ids);
	if (sFolType && ids && ids[2]){
		// Vymazání položek z datasetu
		var i, removedFromDataset = dataSet.get('removedFromDataset') || {};
		for(i in ids[2]) {
			var aData = dataSet.get('items', makeIDFromIDS(ids, i));
			if (aData) {
				var id = aData.ORIGINALACCOUNT ? aData.aid + '/' + aData.fid + '/' + ids[2][i] : ids[2][i];
				removedFromDataset[ids[0]] = removedFromDataset[ids[0]] || {};
				removedFromDataset[ids[0]][ids[1]] = removedFromDataset[ids[0]][ids[1]] || [];
				if (!~removedFromDataset[ids[0]][ids[1]].indexOf(id)) {
					removedFromDataset[ids[0]][ids[1]].push(id);
				}
				if (aData.ORIGINALACCOUNT) {
					removedFromDataset[aData.ORIGINALACCOUNT] = removedFromDataset[aData.ORIGINALACCOUNT] || {};
					removedFromDataset[aData.ORIGINALACCOUNT][aData.ORIGINALFOLDER] = removedFromDataset[aData.ORIGINALACCOUNT][aData.ORIGINALFOLDER] || [];
					if (!~removedFromDataset[aData.ORIGINALACCOUNT][aData.ORIGINALFOLDER].indexOf(ids[2][i])) {
						removedFromDataset[aData.ORIGINALACCOUNT][aData.ORIGINALFOLDER].push(ids[2][i]);
					}
				}

				var count = dataSet.get('folders', [aData.aid, aData.fid, 'COUNT']);
				var recent = dataSet.get('folders', [aData.aid, aData.fid, 'RECENT']) || 0;
				var iTotal = +dataSet.get("items",[aData.aid, aData.fid, '/']);

				+iTotal && dataSet.add("items",[aData.aid, aData.fid, '/'], --iTotal,true);
				+count && dataSet.add('folders', [aData.aid, aData.fid, 'COUNT'], (--count).toString(), true);
				var addRecent = false;
				if (+recent && !((aData.FLAGS || 0) & 32)) {
					addRecent = true;
					dataSet.add('folders', [aData.aid, aData.fid, 'RECENT'], (--recent).toString(), true);
				}

				dataSet.remove('items', [aData.aid, aData.fid, ids[2][i]], true)

				if (aDest) {
					dataSet.add('items', [aDest[0], aDest[1], ids[2][i]], aData, true);
					count = dataSet.get('folders', [aDest[0], aDest[1], 'COUNT']);
					if (count !== void 0) {
						dataSet.add('folders', [aDest[0], aDest[1], 'COUNT'], (++count).toString(), true);
					}
					if (addRecent) {
						recent = dataSet.get('folders', [aDest[0], aDest[1], 'RECENT']);
						if (recent !== void 0) {
							dataSet.add('folders', [aDest[0], aDest[1], 'RECENT'], (++recent).toString(), true);
						}
					}
				}
			}
		}
		dataSet.add('removedFromDataset', '', removedFromDataset, true);

		// Mažeme mail, který byl aktivní pro náš folder?
		var sIt = dataSet.get('active_items',[ids[0],ids[1]]);
		if (Is.Defined(sIt) && inArray(ids[2], sIt) > -1){
			dataSet.remove('active_items',[ids[0],ids[1]]);
			if (sFolType == WMFolders.getType(Path.split(dataSet.get('current_folder')))) {
				dataSet.remove('preview');
			}
		}

		if (sFolType != 'E' || Cookie.get(['views',ids[0],ids[1],'view']) == 'list_view'){
			dataSet.update('folders');
			dataSet.update('items');
			return true;
		} else {
			// indicate that the view needs to be updated from the server
			return false;
		}
	}
};

Item.__refreshView = async function(ids,bNoRefresh) {
	var aActive = Path.split(dataSet.get('current_folder')), i;

	ids = clone(ids);

	//disable refresh for Calendar
	if (WMFolders.getType(ids) == 'E')
		return;

	if (aActive && ((aActive[0] == ids[0] && aActive[1] == ids[1]) /*|| (WMFolders.getType(ids) == 'E' && aActive[1] == '__@@VIRTUAL@@__/__@@EVENTS@@__' && (ids[1] = '__@@VIRTUAL@@__/__@@EVENTS@@__'))*/)){

		await gui.frm_main._selectView({'aid':ids[0],'fid':ids[1]},null,false,null,(bNoRefresh?false:true));

		//Refresh preview
		if (bNoRefresh){
			if (gui.frm_main && gui.frm_main.main){

				if (!Is.Array(ids[2]))
					ids[2] = [ids[2]];

				if (gui.frm_main.main.mailview && WMFolders.getType(ids) == 'M'){
					for (i in ids[2])
						if (dataSet.get('preview', [ids[0], ids[1], ids[2][i]])){
							dataSet.remove('preview');
							OldMessage.open([ids[0], ids[1], ids[2][i]]);
							break;
						}
				}
				else
				if (gui.frm_main.main.itemview){
					for (i in ids[2])
						if (dataSet.get('preview', [ids[0], ids[1], ids[2][i]])){
							dataSet.remove('preview');
							Item.open([ids[0], ids[1], ids[2][i]]);
							break;
						}
				}

			}
		}
	}
};

Item.previewItem = function(aIds, sFilename, bSkipDownload, bReadonly, aData) {
	aData = aData || {};
	if (!Array.isArray(aIds)) {
		aIds = [
			aIds.aid,
			aIds.fid,
			Array.isArray(aIds.iid) ? aIds.iid[0] : aIds.iid
		];
	}

	sFilename = sFilename || dataSet.get('items', [aIds[0], aIds[1], aIds[2], 'EVNTITLE']);
	if (Item.officeSupport(sFilename)) {
		Item.officeOpen({aid: aIds[0], fid: aIds[1], iid: aIds[2]}, '', '', aData.mode);
	} else if (Item.editSupport(sFilename)) {
		Item.editFile(aIds, false, bReadonly);
	} else if (Item.htmlSupport(sFilename)) {
		Item.previewHTML(aIds, sFilename);
	} else if (Path.extension(sFilename) === 'pdf') {
		Item.openPDF(aIds);
	} else if (Item.audioSupport(sFilename) || Item.videoSupport(sFilename)) {
		Item.playFile(aIds, sFilename);
	} else if (Item.imageSupport(sFilename) || Path.extension(sFilename) === 'heic') {
		Item.previewImage(aIds);
	} else if (!bSkipDownload) {
		return Item.downloadFile(aIds);
	}

	gui.__exeEvent('previewItem', {
		aid: aIds[0],
		fid: aIds[1],
		iid: WMItems.__serverID(aIds[2])
	});
};

Item.previewURL = async function(sURL, sFilename, sPreviewURL, aData) {
	aData = aData || {};
	if (Item.officeSupport(sFilename) && !sURL.match(/^blob:/)) {
		Item.officeOpen({ url: sURL, EVNTITLE: sFilename, previewURL: sPreviewURL }, '', aData.mode);
	} else if(GWOthers.getItem('LAYOUT_SETTINGS','disable_pdf') == 1) {
		downloadItem(sURL, true);
	} else if (Item.pdfSupport() && Path.extension(sFilename) === 'pdf') {
		var pdf = await gui._create('pdf','frm_pdf');
		pdf._load(sURL, sFilename, sPreviewURL);
	}
};

Item.previewAttachment = async function(aIds, sAttid, sTicket, bSkipDownload) {
	if (!Array.isArray(aIds)) {
		aIds = [
			aIds.aid,
			aIds.fid,
			Array.isArray(aIds.iid) ? aIds.iid[0] : aIds.iid
		];
	}

	if (Item.officeSupport(sAttid)) {
		Item.officeOpen({ aid: aIds[0], fid: aIds[1], iid: aIds[2], attid: sAttid }, [function() {
			Item.officeOpen({ url: sTicket }, [function() {
				if (!bSkipDownload) {
					downloadItem(buildURL({dlsess: dataSet.get('main', ['dlsess']), class: 'attachment', fullpath: [aIds[0], aIds[1], WMItems.__serverID(aIds[2]), sAttid].join('/')}));
				}
			}]);
			return false;
		}]);
	} else if (Item.editSupport(sAttid)) {
		Item.editFile(aIds, sAttid);
	} else if (Item.htmlSupport(sAttid)) {
		Item.previewHTML(aIds, sAttid);
	} else if (Path.extension(sAttid) === 'pdf') {
		Item.openPDF(aIds, sAttid);
	} else if (Item.audioSupport(sAttid) || Item.videoSupport(sAttid)) {
		Item.playFile(aIds, sAttid, sAttid, sTicket);
	} else if (Item.imageSupport(sAttid) || Path.extension(sAttid) === 'heic') {
		var img = await gui._create('imgview', 'frm_imgview');
		await img._fill([{
			title: sAttid,
			url: sTicket
		}]);
		img._value(0);
	} else if (!bSkipDownload) {
		downloadItem(buildURL({dlsess: dataSet.get('main', ['dlsess']), class: 'attachment', fullpath: [aIds[0], aIds[1], WMItems.__serverID(aIds[2]), sAttid].join('/')}));
	}
};

Item.previewImage = function(aIds) {
	WMItems.list({aid: aIds[0], fid: aIds[1], iid: aIds[2]}, '', '', '', [async function(aData) {
		if (aData && (aData = aData[aIds[0]]) && (aData = aData[aIds[1]]) && (aData = aData[WMItems.__clientID(aIds[2])])) {
			for (var sAtId in aData.ATTACHMENTS){
				if (aData.ATTACHMENTS[sAtId].ATTTYPE === 'thumbnail') {
					continue;
				}
				if (aIds[3] && sAtId !== aIds[3]) {
					continue;
				}
				var img = await gui._create('imgview', 'frm_imgview');
				await img._fill([{
					title: aData.EVNTITLE,
					url: aData.ATTACHMENTS[sAtId].values.TICKET
				}]);
				img._value(0);
				break;
			}
		}
	}]);
};

// Accepts array or object
Item.playFile = function(id, sFilename, sAttid, sTicket){
	if (!gui.audio){
		return;
	}

	var q;
	if (Is.Array(id))
		q = {aid: id[0], fid: id[1], iid: WMItems.__clientID(id[2]), attid: sAttid};
	else
	if (Is.Object(id) && id.iid)
		q = {aid: id.aid, fid: id.fid, iid: WMItems.__clientID(id.iid), attid: sAttid};
	else
		return;

	if (sFilename && Item.videoSupport(sFilename)) {
		var frm = gui._getChildObjects('main', 'frm_videoplayer');
		for (id in frm) {
			if (frm[id].__id && frm[id].__id.aid === q.aid && frm[id].__id.fid === q.fid && frm[id].__id.iid === q.iid && frm[id].__id.attid === q.attid) {
				return frm[id]._focus && frm[id]._focus();
			}
		}
	}

	q.values =  ['EVN_ID'];

	async function open(q, sName, sAtId, sTicket) {
		if (Item.audioSupport(sName)) {
			gui.audio._value(sTicket || await Item.webdavURL(q, sAtId), sName);
		} else if (Item.videoSupport(sName)) {
			var videoPlayer = await gui._create('videoPlayer', 'frm_videoplayer', '', '', {
				title: sName,
				url: sTicket
			});
			videoPlayer.__id = q;
		}
	}

	if (sAttid) {
		return open(q, sFilename, sAttid, sTicket);
	}

	try{
		WMItems.list(q,'','','',[function(aData){
			if (aData && (aData = aData[q.aid]) && (aData = aData[q.fid]) && (aData = aData[q.iid]))
				for (var sAtId in aData.ATTACHMENTS){
					if (aData.ATTACHMENTS[sAtId].ATTTYPE === 'thumbnail') {
						continue;
					}
					return open(q, aData.ATTACHMENTS[sAtId].values.ATTDESC || sAtId, sAtId, aData.ATTACHMENTS[sAtId].values.TICKET);
				}
		}]);
	}
	catch(r){ console.log(this._name||false,r)}
};

// Accepts array or object
Item.openPDF = function(id, sAttid){
	var q;
	if (Is.Array(id))
		q = {aid: id[0], fid: id[1], iid: WMItems.__clientID(id[2]), attid: sAttid};
	else
	if (Is.Object(id) && id.iid)
		q = {aid: id.aid, fid: id.fid, iid: WMItems.__clientID(id.iid), attid: sAttid};
	else
		return;

	var frm = gui._getChildObjects('main', 'frm_pdf');
	for (id in frm) {
		if (frm[id].__id && frm[id].__id.aid === q.aid && frm[id].__id.fid === q.fid && frm[id].__id.iid === q.iid && frm[id].__id.attid === q.attid) {
			return frm[id]._focus && frm[id]._focus();
		}
	}

	q.values = ['EVN_ID'];

	async function open(q, sName, sAtId) {
		var url = q.url || await Item.webdavURL(q, sAtId);
		if(GWOthers.getItem('LAYOUT_SETTINGS','disable_pdf') == 1) {
			downloadItem(url, true);
		} else {
			var frm = await gui._create('pdf', 'frm_pdf');
			frm.__id = q;
			frm._load(url, sName, void 0, true);
		}
	}

	if (sAttid) {
		return open(q, sAttid, sAttid);
	}

	try{
		WMItems.list(q,'','','',[function(aData){
			if (aData && (aData = aData[q.aid]) && (aData = aData[q.fid]) && (aData = aData[q.iid]))
				for (var sAtId in aData.ATTACHMENTS){
					if (aData.ATTACHMENTS[sAtId].ATTTYPE === 'thumbnail') {
						continue;
					}
					var sName = aData.EVNTITLE || aData.ATTACHMENTS[sAtId].values.ATTDESC || sAtId;
					if (Path.extension(sName) == 'pdf'){
						q.url = aData.ATTACHMENTS[sAtId].values.TICKET;
						return open(q, sName, sAtId);
					}
				}
		}]);
	}
	catch(r){ console.log(this._name||false,r)}
};

/**
 * Open in Dialog
 * 12.2.2013
 **/

Item.editFile = async function(id, sAttid, bReadonly){
	if (Is.Array(id)){
		var frm = gui._getChildObjects('main', 'frm_editor');
		for (var i in frm) {
			if (frm[i].__id[0] === id[0] && frm[i].__id[1] === id[1] && frm[i].__id[2] === id[2] && frm[i].__id[3] === sAttid) {
				return frm[i]._focus && frm[i]._focus();
			}
		}

		if (sAttid) {
			id[3] = sAttid;
			var editor = await gui._create('text', 'frm_editor', '', '', {
				filename: sAttid,
				url: await Item.webdavURL(id, sAttid),
				readonly: bReadonly
			});
			return editor.__id = id;
		}

		gui._create('text', 'frm_editor', '', '', {
			id: id,
			readonly: bReadonly
		});
	}
};

Item.previewHTML = async function(id, sAttid){
	if (Is.Array(id)){
		var frm = gui._getChildObjects('main', 'frm_html');
		for (var i in frm) {
			if (frm[i].__id[0] === id[0] && frm[i].__id[1] === id[1] && frm[i].__id[2] === id[2] && frm[i].__id[3] === sAttid) {
				return frm[i]._focus && frm[i]._focus();
			}
		}

		if (sAttid) {
			id[3] = sAttid;
			var html = await gui._create('text', 'frm_html', '', '', {
				filename: sAttid,
				url: await Item.webdavURL(id, sAttid)
			});
			html.__id = id;
		}
	}
};

/*

[aData]
.. [admin@merakdemo.com]
.... [Files/fff]
...... [$](string) = 0
...... [*424751d1f703]
........ [aid](string) = admin@merakdemo.com
........ [fid](string) = Files/fff
........ [EVNTITLE](string) = html.html
........ [DATA](string) = <head><title></title></head>
<body></body>

........ [ATTACHMENTS]
.......... [html.html]
............ [values]
.............. [ATTNAME](string) = html.html
.............. [ATTTYPE](string) = attachment
.............. [ATTTIME](string) = 1360228475
.............. [ATTSIZE](string) = 0
.............. [ATTDESC](string) = html.html
.............. [ATTPARAMS](undefined) = undefined
.............. [TICKET](string) = http://merakdemo.com/webdav/ticket/eJwVyjEOgCAMAMDX2E2F0gaWTib8Q7FVIi7q,6MuN90mwUiZUlDSAia5Nr07nswMimS4pEdP8QvMCCpQhZAi.9VbdGHcn7MNP3CI.dkhLpjSCy7eGDM_/html.html
 [id]
.. [0](string) = admin@merakdemo.com
.. [1](string) = Files/fff
.. [2](string) = *424751d1f703
 [sType](string) = html


*/

/**
 * Open in office by SharePoint or Java OfficeLauncher
 * 26.1.2012 15:21:07
 **/

Item.isDocument = function(sFile) {
	return !!~['doc', 'docx', 'dot', 'docm', 'dotx', 'dotm', 'docb', 'odt', 'rtf'].indexOf(Path.extension(sFile));
};
Item.isSpreadsheet = function(sFile) {
	return !!~['xls', 'csv', 'xlsx', 'xla', 'xlam', 'xlsb', 'ods', 'xlsb', 'xlsm', 'xlt', 'xltm', 'xltx'].indexOf(Path.extension(sFile));
};
Item.isPresentation = function(sFile) {
	return !!~['ppt', 'pptx', 'odp', 'pps', 'ppsm', 'ppsx', 'pptm', 'ppa', 'ppam'].indexOf(Path.extension(sFile));
};
Item.isAccessDatabase = function(sFile) {
	return !!~['accda', 'accdb', 'accdc', 'accde', 'accdr', 'accdt', 'ade', 'adp', 'mda'].indexOf(Path.extension(sFile));
}
Item.officeSupport = function(sFile, bSkipRestrictions){
	var bDisabled = bSkipRestrictions ? false : (GWOthers.getItem('DOCUMENTS', 'disable_office') == 1 || GWOthers.getItem('RESTRICTIONS', 'disable_doc_integration') == 1);
	var bSupport = bSkipRestrictions ? true : (dataSet.get('accounts', [sPrimaryAccount, 'OFFICE_SUPPORT']) == 'true');
	return bSupport && !bDisabled && (Item.isDocument(sFile) || Item.isSpreadsheet(sFile) || Item.isPresentation(sFile));
};
Item.imageSupport = function(sFile){
	return ~['jpg', 'jpeg', 'png', 'gif', 'bmp', 'ico', 'webp'].indexOf(Path.extension(sFile));
};
Item.videoSupport = function(sFile){
	return ~['ogv', 'mp4', 'webm', 'mov', 'mkv', 'mpg', 'mpeg', 'avi'].indexOf(Path.extension(sFile));
};
Item.audioSupport = function(sFile){
	return ~['mp3', 'wav'].indexOf(Path.extension(sFile));
};
Item.editSupport = function(sFile){
	return ~['txt', 'md'].indexOf(Path.extension(sFile));
};
Item.htmlSupport = function(sFile){
	return ~['html', 'htm'].indexOf(Path.extension(sFile));
};
Item.isArchive = function(sFile){
	return ~['zip', 'rar', 'tar', 'gz', '7z'].indexOf(Path.extension(sFile));
};
Item.pdfSupport = function(bCheckLegacy) {
	function IsBrowserPluginInstalled(a) {
		return navigator.mimeTypes && navigator.mimeTypes[a] && navigator.mimeTypes[a].enabledPlugin;
	};
	
	return (bCheckLegacy || currentBrowser() !== 'Safari') && (navigator.pdfViewerEnabled || IsBrowserPluginInstalled('application/pdf') || isIos());
};

Item.getFileType = function(sFilename) {
	sFilename = sFilename || '';
	if (Item.imageSupport(sFilename)) {
		return 'image';
	}
	if (Item.audioSupport(sFilename)) {
		return 'audio';
	}
	if (Item.videoSupport(sFilename)) {
		return 'video';
	}
	if (Item.isDocument(sFilename)) {
		return 'doc';
	}
	if (Item.isSpreadsheet(sFilename)) {
		return 'xls';
	}
	if (Item.isPresentation(sFilename)) {
		return 'ppt';
	}
	if (Item.isArchive(sFilename)) {
		return 'archive';
	}
	if (Item.editSupport(sFilename)) {
		return 'note';
	}
	if (Item.htmlSupport(sFilename)) {
		return 'html';
	}
	switch(Path.extension(sFilename)) {
		case 'pdf':
			return 'pdf';
		case 'eml':
		case 'imap':
		case 'msg':
			return 'email';
		case 'heic':
			return 'heic';
		case 'ics':
			return 'event';
	}
	return '';
};

Item.officeOpen = async function (aItemInfo, aErrHandler, sExtension, sMode, callback) {
	try {
		if (!sMode) {
			switch (GWOthers.getItem('DOCUMENTS', 'office_app')) {
				case 'webdoc_read':
					sMode = 'view';
					break;
				case 'suite':
					sMode = 'external';
			}
		}
		if (sMode === 'external') {
			if (!sPrimaryAccountWebDAV) {
				throw 'webdav';
			} else if (aItemInfo.url) {
				Item.officeWebdav(aItemInfo.url, aErrHandler, sExtension);
			} else {
				await storage.library('wm_tools');
				new wm_tools().ticket(aItemInfo, 'rwil', [Item.officeWebdav, [aErrHandler, sExtension]]);
			}
			return;
		}

		//FOCUS already openned document
		var aii, mode = 0,
			folder_type = WMFolders.getType(aItemInfo),
			args = arguments,
			frm = gui._getChildObjects('main','frm_document_onlyoffice');

		for (var id in frm) {
			if ((aii = frm[id].aItemInfo) && ((aii.url && aii.url === aItemInfo.url) || (!aii.url && aii.aid === aItemInfo.aid && aii.fid === aItemInfo.fid && aii.iid === aItemInfo.iid && aii.attid === aItemInfo.attid))) {
				return frm[id]._focus && frm[id]._focus();
			}
		}

		if (sMode === 'view') {
			mode = 1;
		} else if (!aItemInfo.url){
			var data = dataSet.get('items', [aItemInfo.aid, aItemInfo.fid, aItemInfo.iid]) || {};
			if (data.EVNCOMPLETE > 50 * 1024 * 1024) {
				gui.notifier._value({type: 'alert', args: {text: 'ALERTS::TOO_LARGE_TO_EDIT'}});
				return Item.downloadFile([aItemInfo.aid, aItemInfo.fid, aItemInfo.iid]);
			}

			if(data.EVNLOCKOWN_EMAIL) {
				var document_editing_info = data.EVN_DOCUMENTEDITINGINFO && JSON.parse(data.EVN_DOCUMENTEDITINGINFO);
				if (document_editing_info) {
					if (document_editing_info.editor_ownid !== sPrimaryAccountGWID) {
						mode = document_editing_info.newparticipantsmode < 2;
					}
				} else {
					mode = ((data.EVNLOCKOWN_EMAIL === sPrimaryAccount) && WMFolders.getAccess(aItemInfo, folder_type === 'I' ? 'edit_document' : 'modify')) ? 0 : 1;
				}
			}
		}

		Item.filesEdit(aItemInfo, mode, args, callback, aErrHandler);
	} catch(err){
		 console.warn('officeOpen', err);
		Sentry && Sentry.captureException(err);
		aErrHandler && executeCallbackFunction(aErrHandler);
	}
};

Item.collaborate = function(aIds, _gui) {
	var iid = Array.isArray(aIds[2]) ? aIds[2][0] : aIds[2];
	WMItems.list({
		aid: aIds[0],
		fid: aIds[1],
		iid: iid,
		values: ['evn_id', 'evndocpass_plain', 'inviteticket', 'evntitle', 'evnurl', 'evndocdisabledownload']
	}, null, null, null, [function(aData){
		if (aData) {
			aData.INVITETICKET = aData.EVNURL || aData.INVITETICKET;
			(_gui || gui)._create('frm_collaboration', 'frm_collaboration', '', '', aData[aIds[0]][aIds[1]][iid] || aData[aIds[0]][aIds[1]][WMItems.__clientID(iid)]);
		}
	}]);
};

Item.revokeCollaborationLink = function(aIds) {
	gui._create('confirm', 'frm_confirm', '', '', [function() {
		WMItems.action({ aid: aIds[0], fid: aIds[1], iid: aIds[2] }, 'collaboration_reset', [function (_, response) {
			var newId;
			try {
				newId = response.IQ[0].RESULT[0].ID[0].VALUE;
				gui.__exeEvent('changedId', { oldId: aIds[2], newId: newId });
			} catch {
				gui.notifier._value({type: 'alert', args: { header: 'ALERTS::UNABLE_TO_REVOKE_LINK' }});
			}
		}]);
	}], 'COLLABORATION::RESET_LINK', 'COLLABORATION::RESET_LINK_HELPER');
};

Item.expiration = function(aIds, callback) {
	var iid = Array.isArray(aIds[2]) ? aIds[2][0] : aIds[2];
	WMItems.list({
		aid: aIds[0],
		fid: aIds[1],
		iid: iid,
		values: ['evn_id', 'EVNEXPIRE']
	}, null, null, null, [function(aData){
		aData && gui._create('frm_expiration', 'frm_expiration', '', '', (aData[aIds[0]][aIds[1]][iid] || aData[aIds[0]][aIds[1]][WMItems.__clientID(iid)]).EVNEXPIRE, [function(new_value) {
			WMItems.add(aIds, {
				values: {
					EVNEXPIRE: new_value
				}
			}, '', '', '', [
				function() {
					callback(new_value);
				}
			]);
		}]);
	}]);
};

Item.filesEdit = async function(aItemInfo, mode, args, callback, aErrHandler, oOfficeWindow, wrong_password) {
	aItemInfo.autoreopen = aItemInfo.autoreopen === void 0 ? true : aItemInfo.autoreopen;
	var office_window = oOfficeWindow || await gui._create('doc', 'frm_document_onlyoffice', '', '', aItemInfo.autoreopen && {
		args: [].slice.call(arguments),
		context: 'Item',
		fun: ['filesEdit']
	});

	TeamChatAPI.filesEdit(aItemInfo, mode, {
		success: function (response) {
			office_window._open(aItemInfo, mode, args, response, callback);
		},
		error: async function (e) {
			if (e && e.type === 'error') {
				return office_window._destruct();
			}
			if (e.error_details !== 'e_document_invite_password') {
				office_window._destruct();
				if (aErrHandler && await executeCallbackFunction(aErrHandler) === true) {
					return;
				}
			}
			if(e.error_details && e.error_details.indexOf('e_') === 0) {
				e.error = e.error_details;
			}
			switch(e.error) {
				case 'e_document_invite_password':
					var pass = await office_window._create('password', 'frm_password_protected', '', '', [function(password) {
						aItemInfo.password = password;
						pass._remove_destructor('__pass_destructor');
						Item.filesEdit(aItemInfo, mode, args, callback, aErrHandler, office_window, true);
					}], '', wrong_password);
					pass.__pass_destructor = function() {
						office_window._destruct();
					};
					pass._add_destructor('__pass_destructor');
					break;
				default:
					gui.notifier._value({type: 'alert', args: {text: 'ERROR::' + (e.error_details || e.error).toUpperCase()}});
			}
		},
		context: this
	});
	return office_window;
}

Item.officeWebdav = async function(sPath, aErrHandler, sExtension){

	if (!sPath) {
		return aErrHandler && await executeCallbackFunction(aErrHandler);
	}

	var type = '';
	if (Item.isDocument(sPath) || Item.isDocument('.' + sExtension)) {
		type = 'ms-word:ofe';
	} else if (Item.isSpreadsheet(sPath) || Item.isSpreadsheet('.' + sExtension)) {
		type = 'ms-excel:ofe';
	} else if (Item.isPresentation(sPath) || Item.isPresentation('.' + sExtension)) {
		type = 'ms-powerpoint:ofv';
	} else if (Item.isAccessDatabase(sPath) || Item.isAccessDatabase('.' + sExtension)) {
		type = 'ms-access:ofe';
	} else {
		return downloadItem(sPath, true);
	}

	downloadItem(type + '|u|' + sPath, true);
};

Item.getAliasFromPath = function(sPath){
	if (sPath){

		var aPath = Path.split(sPath);

		//Other Account
		if (aPath[0] != sPrimaryAccount)
			return aPath[0].toLowerCase();
		else
		//Shared Account
		if (aPath[1].indexOf(sPrimaryAccountSPREFIX) === 0)
			return aPath[1].substr(sPrimaryAccountSPREFIX.length).split('/').shift().toLowerCase();
	} else {
		 console.warn('Item.getAliasFromPath', sPath);
	}
};

Item.tags = function(id) {
	gui._create('frm_tags', 'frm_tags', '','', id);
};
