<?php
require_once(SHAREDLIB_PATH . 'api/api.php');
require_once('iw_file.php');

function is_null_or_empty($str)
{
	return ($str === null || trim($str) === '');
}

function init_global_api()
{
	global $api;
	$api = new IceWarpAPI();
	stream_wrapper_register("iw.file", "IceWarpFileStream");
}

function server_config()
{
	global $api;
	$_SESSION["config_path"] = $api->GetProperty("c_configpath");
	$_SESSION["Disabled"] = !$api->GetProperty("C_WebDAV_Active");
	$_SESSION["log_level"] = $api->GetProperty("C_System_Log_Services_WebDAV");
	$_SESSION["use_gal_for_search"] = $api->GetProperty("C_WebDAV_UseGALForSearch");
	$_SESSION['shared_prefix'] = $api->GetProperty("C_GW_SharedAccountPrefix");
	$_SESSION['resources'] = $api->GetProperty("C_GW_Resources");
	$_SESSION['auth_schemes'] = $api->GetProperty("c_accounts_policies_auth_schemes");
	$_SESSION['PathServiceId'] = 'Me:'.$api->GetProperty('C_PathServiceID');
}

function manage_parameters($parameters, $parameter, $value = null, $remove = false)
{
	 	if ($value === null)
	{
		 		if (is_null_or_empty($parameters) || is_null_or_empty($parameter))
			return null;
	}
	else
	{
		 		if (is_null_or_empty($parameters) && is_null_or_empty($parameter))
			return '';

		if (is_null_or_empty($parameters))
		{
			 			 			 			return $parameter . '=' . urlencode($value);
		}

		if (is_null_or_empty($parameter))
			return $parameters;
	}

	$found = false;
	$params = explode('&', $parameters);
	for($i = 0; $i < count($params); $i++)
	{
		$tuple = explode('=', $params[$i]);
		if ($tuple[0] == $parameter)
		{
			 			if ($value === null)
				return trim($tuple[1]) === '' ? null : urldecode($tuple[1]);

			 			if ($value == $tuple[1])
				return $parameters;

			$found = true;

			 			 			if ($value === ''  && $remove)
			{
				unset($params[$i]);
				break;
			}

			 			$params[$i] = $parameter . '=' . urlencode($value);
			break;
		}
	}

	 	if ($value === null)
		return null;

	 	if ($found)
		return implode('&', $params);

	 	return $parameters;
}

function do_log($body, $level = 1)
{
	global $api;
	 	if ($level > $_SESSION["log_level"]) return;

	 	$api->dolog(0, 17, session_id() . " (" . $_SERVER['REMOTE_ADDR'] . ") ", $body, 1, 1);
}
?>
