<?php
class newapi
{
    var $_request;
    var $_sid;

    function &__construct($command, $params = array())
    {

        $this->_request = array();
        $this->init_request($command, $params);

        return $this;
    }

    function array_to_xml($array, $rootElement = null, $xml = null)
    {
        $_xml = $xml;

                 if ($_xml === null)
        {
            $_xml = new SimpleXMLElement($rootElement !== null ? $rootElement : '<root/>');
        }

                 foreach ($array as $k => $v)
        {

                         if (is_array($v))
            {

                if ($k == '@attributes')
                {
                    foreach ($v as $kv => $vv)
                    {
                        $_xml->addAttribute($kv, $vv);
                    }

                }
                else

                                 $this->array_to_xml($v, $k, $_xml->addChild($k));
            }

            else
            {
                                 $_xml->addChild($k, $v);
            }
        }

        if (!$rootElement)
        {

                         return $_xml->{array_key_first($array) }->asXML();
        }
    }

    function xml_to_array($obj)
    {

        $namespace = $obj->getDocNamespaces(true);
        $namespace[NULL] = NULL;

        $children = array();

                 if (is_object($obj))
        {
            foreach ($namespace as $ns => $nsUrl)
            {

                                 $objAttributes = $obj->attributes($ns, true);
                foreach ($objAttributes as $attributeName => $attributeValue)
                {
                    $attribName = strtolower(trim((string)$attributeName));
                    $attribVal = trim((string)$attributeValue);
                    if (!empty($ns))
                    {
                        $attribName = $ns . ':' . $attribName;
                    }
                    $children['@attributes'][$attribName] = $attribVal;
                }

                                 $objChildren = $obj->children($ns, true);
                foreach ($objChildren as $childName => $child)
                {
                    $childName = strtolower((string)$childName);
                    if (!empty($ns))
                    {
                        $childName = $ns . ':' . $childName;
                    }

                    if ($child->count() > 0)
                    {
                        $children[$childName] = $this->xml_to_array($child);
                    }
                    else
                    {
                        $children[$childName] = (string)$child;
                    }
                }
            }
            return $children;
        }
        else
        {
        }
    }

    function init_request($command, $params = array())
    {

        $request = array();

        $request['iq'] = array();
        $iq = & $request['iq'];
        $iq['query'] = array();

        if ($this->_sid) $iq['@attributes']['sid'] = $this->_sid;

        $query = & $iq['query'];

        $query['@attributes']['xmlns'] = 'admin:iq:rpc';
        $query['commandname'] = $command;
        $query['commandparams'] = $params;

        $this->_request = & $request;
    }

    function send_request()
    {

        $xml = $this->array_to_xml($this->_request);
                 $response = icewarp_apitunnel($xml);
                 $rxml = new SimpleXMLElement($response);
        return array($rxml->getName() => $this->xml_to_array($rxml));
    }

    function set_sid($sid)
    {
        $this->_sid = $sid;
    }

    function set_and_send_request($command, $params = array())
    {
        $this->init_request($command, $params);
        return $this->send_request();
    }

}

?>
