_me = obj_whitelabeling.prototype;
function obj_whitelabeling(){};

obj_whitelabeling.LOGIN_SETTINGS = {
	layout_settings: [
		'login_logo_name','logo_file',
		'search_phrase',
		'website_link','facebook_link','twitter_link','linkedin_link'
	],
	custom_login_fields: [
		'login_verification_enabled','login_verification_type',
		'nickname_enabled','nickname_required',
		'company_enabled','company_required',
		'job_enabled','job_required',
		'profession_enabled','profession_required',
		'mobile_phone_enabled','mobile_phone_required',
		'work_phone_enabled','work_phone_required',
		'home_phone_enabled','home_phone_required',
		'im_enabled','im_required',
		'gender_enabled','gender_required',
		'birthday_enabled','birthday_required',
		'homepage_enabled','homepage_required'
	],
	restrictions: [
		'disable_languages','disable_remember','disable_autofill','disable_signup','disable_guest_signin',
		'contact_support','support_require_number','show_search',
		'website_disabled','facebook_disabled','twitter_disabled','linkedin_disabled'
	]
};
obj_whitelabeling.WEBMAIL_SETTINGS = {
	layout_settings: [
		'title',
		'skin',
		'login_background', 'login_background_name', 'login_background_file', 'login_background_color', 'login_background_wallpaper_size', 'login_background_solid', 'login_interface_color', 'login_favicon_name', 'login_favicon_file', 'login_favicon_uid'
	],
};
obj_whitelabeling.WEBADMIN_SETTINGS = {
	layout_settings_admin: [
		'title',
		'skin_style'
	]
};
obj_whitelabeling.COMBINED_SETTINGS = {
	layout_settings: obj_whitelabeling.WEBMAIL_SETTINGS.layout_settings,
	layout_settings_admin: obj_whitelabeling.WEBADMIN_SETTINGS.layout_settings_admin,
}
obj_whitelabeling.BANNER_SETTINGS = {
	banner_options: [
		'customer_id',
		'desktop_type','desktop_url','desktop_code',
		'mobile_type','mobile_url','mobile_code',
		'top_type','top_url','top_link','top_code',
		'below_type','below_url','below_link','below_code'
	],
	restrictions: ['enable_adsense']
};
obj_whitelabeling.CONFERENCING = {
	conferencing_options: [
		'jitsi_logo_file', 'jitsi_logo_name',
		'jitsi_redirect_url'
	]
};

/**
 * @brief:
 * @date : 26.10.2014
 **/
_me.__constructor = function(s){
	storage.library('extract-colors', 'extract-colors');
	var me = this;

	var view = this._view = new WhiteLabelingView(this);

	view.addSaveButton();

	this.__globalResources=helper.clone(gui._globalInfo.resources);
	this.__is_default_enabled=false;
	this.__resource_level=RESOURCE_LEVEL_SERVER;
	this.__who=false;
	if(location.parsed_query.domain){
		this.__resource_level=RESOURCE_LEVEL_DOMAIN;
		this.__who=location.parsed_query.domain;
	}
	if(location.parsed_query.account){
		this.__resource_level=RESOURCE_LEVEL_ACCOUNT;
		this.__who=location.parsed_query.account;
	}

	me.__domaindetail=false;
	if(location.parsed_query.domain){
		me.__domaindetail=location.parsed_query.domain;
	}

	if(!me.__domaindetail){
		gui.frm_main.main._init({
			name:'whitelabeling',
			heading:{
				value:getLang('main::white_labeling')
			}
		});
	}

	// Deciding on which level to apply the settings (server or domain)
	this._level = com;
	if(this.__domaindetail) {
		this._level = new Domain(this.__domaindetail);
	}
	// Create a container for all settings
	this._data = new IWAPI.Collection('Settings');

	/** settings */
	this.__settings={};

	this.__settings.skin={};
	this.__settings.background_urls = {
		'default_-1': "custom",
		default_0: "background--default.png",
		default_1: "background--abstract.png",
		default_2: "background--architecture.png",
		default_3: "background--car.png",
		default_4: "background--city.png",
		default_5: "background--fox.png",
		default_6: "background--mountains.png",
		default_7: "background--nature.png",
		default_8: "background--ship.png",
		default_9: "background--space.png",
		default_10: "background--vacation.png"
	};
	this.__settings.background_colors = {
		custom: 'custom',
		"#702EB7": "#702EB7",
		"#0086E5": "#0086E5",
		"#45A154": "#45A154",
		"#AF3A3A": "#AF3A3A",
		"#CF9517": "#CF9517",
		"#A1456D": "#A1456D"
	};
	this.__settings._getFileLabel = function(file) {
		var files = this.background_urls;
		for(var lbl in files) {
			if(files[lbl]==file) {
				return lbl;
			}
		}
	}

};

_me._hash_handler=function(){
	var me=this;

	this._draw('obj_whitelabeling', '', {
		domain: this.__domaindetail
	});

	// hide language settings for webadmin if not under global settings
	if(me.__domaindetail){
		me._getAnchor('fb_language').setAttribute('is-hidden',1);
		me.dropdown_language._disabled(true);
	}

	me._getAnchor('fi_login_default').removeAttribute('is-hidden');
	me._getAnchor('fi_wa_default').removeAttribute('is-hidden');
	me.__is_default_enabled=true;

	// Set logo used in preview
	var logo_custom = this.slider_login.preview_login._getAnchor('login_logo_custom');
	var logo_default = this.slider_login.preview_login._getAnchor('login_logo_default');
	var url = "./server/download.php?class=logo";
	url += "&fullpath="+encodeURIComponent(me.__domaindetail || '__@@GLOBAL@@__');
	url += "&uid="+Date.now();
	logo_custom.addEventListener('load', function() {
		logo_custom.removeAttribute('is-hidden');
		logo_default.setAttribute('is-hidden', '');

		this.button_login_logo_default._disabled(false);
	}.bind(this));
	this.button_login_logo_default._disabled(true);
	logo_custom.src = url;

	/* Form user interaction functionality */

	// Search url input
	me.toggle_search._onchange = function(checked) {
		me.input_search._readonly(!checked);
		this._main.parentNode.classList[checked?'remove':'add']('disabled');
	}

	// Social integration
	me.toggle_website._onchange=function(checked){
		me.input_website._readonly(checked);
	};
	me.toggle_facebook._onchange=function(checked){
		me.input_facebook._readonly(checked);
	};
	me.toggle_twitter._onchange=function(checked){
		me.input_twitter._readonly(checked);
	};
	me.toggle_linkedin._onchange=function(checked){
		me.input_linkedin._readonly(checked);
	};

	// Banners
	me.toggle_adsense._onchange=function(checked){
		me.input_adsense._readonly(!checked);
		me.radio_banner_desktop_code._disabled(!checked);
		me.radio_banner_mobile_code._disabled(!checked);
		me.radio_banner_top_code._disabled(!checked);
		me.radio_banner_bottom_code._disabled(!checked);
	};
	me.radio_banner_desktop._onchange=
	me.radio_banner_desktop_url._onchange=
	me.radio_banner_desktop_code._onchange=function(checked){
		me.input_banner_desktop_url._main.parentNode.setAttribute('is-hidden','1');
		me.input_banner_desktop_code._main.parentNode.setAttribute('is-hidden','1');
		switch(me.radio_banner_desktop._groupValue()) {
			case 'url':
				me.input_banner_desktop_url._main.parentNode.removeAttribute('is-hidden');
				break;
			case 'code':
				me.input_banner_desktop_code._main.parentNode.removeAttribute('is-hidden');
				break;
		}
	};
	me.radio_banner_mobile._onchange=
	me.radio_banner_mobile_url._onchange=
	me.radio_banner_mobile_code._onchange=function(checked){
		me.input_banner_mobile_url._main.parentNode.setAttribute('is-hidden','1');
		me.input_banner_mobile_code._main.parentNode.setAttribute('is-hidden','1');
		switch(me.radio_banner_mobile._groupValue()) {
			case 'url':
				me.input_banner_mobile_url._main.parentNode.removeAttribute('is-hidden');
				break;
			case 'code':
				me.input_banner_mobile_code._main.parentNode.removeAttribute('is-hidden');
				break;
		}
	};
	me.radio_banner_top._onchange=
	me.radio_banner_top_url._onchange=
	me.radio_banner_top_code._onchange=function(checked){
		me.input_banner_top_url._main.parentNode.setAttribute('is-hidden','1');
		me.input_banner_top_link._main.parentNode.setAttribute('is-hidden','1');
		me.input_banner_top_code._main.parentNode.setAttribute('is-hidden','1');
		switch(me.radio_banner_top._groupValue()) {
			case 'url':
				me.input_banner_top_url._main.parentNode.removeAttribute('is-hidden');
				me.input_banner_top_link._main.parentNode.removeAttribute('is-hidden');
				break;
			case 'code':
				me.input_banner_top_code._main.parentNode.removeAttribute('is-hidden');
				break;
		}
	};
	me.radio_banner_bottom._onchange=
	me.radio_banner_bottom_url._onchange=
	me.radio_banner_bottom_code._onchange=function(checked){
		me.input_banner_bottom_url._main.parentNode.setAttribute('is-hidden','1');
		me.input_banner_bottom_link._main.parentNode.setAttribute('is-hidden','1');
		me.input_banner_bottom_code._main.parentNode.setAttribute('is-hidden','1');
		switch(me.radio_banner_bottom._groupValue()) {
			case 'url':
				me.input_banner_bottom_url._main.parentNode.removeAttribute('is-hidden');
				me.input_banner_bottom_link._main.parentNode.removeAttribute('is-hidden');
				break;
			case 'code':
				me.input_banner_bottom_code._main.parentNode.removeAttribute('is-hidden');
				break;
		}
	};

	// Make backgrounds images visible and initialise
	for(var i in this.__settings.background_urls) {
		var bg = this['radio_background_image_'+i];
		if(bg) {
			bg._addcss("is-visible");
			bg._value(this.__settings.background_urls[i]);
		}
	}

	// activate use default buttons
	me.button_login_default._onclick=function(){
		gui.message.warning(getLang("warning::set_to_default"),false,[
			{
				value:getLang("generic::cancel"),
				type:'text borderless',
				method:'close'
			},
			{
				value:getLang("generic::set_to_default"),
				type:'success text',
				onclick:function(closeCallback){
					me._data.login.resetAll(function(r){
						if(r==1) {
							me._level.getSettings(obj_whitelabeling.LOGIN_SETTINGS,function(li){
								// Keep and fill in new data
								me._data.removeItem('login');
								me._data.addItem(li,'login');
								me._loadLogin(li);
								gui.message.toast(getLang("message::reset_to_default"));
							});
						} else {
							gui.message.error(getLang("error::default_reset_failed"));
						}
					});
					closeCallback();
					// Showing original IceWarp logo
					var img = me.slider_login.preview_login._main.getElementsByTagName('img')[0];
					var url = "./server/download.php?class=logo";
					url += "&fullpath="+encodeURIComponent(me.__domaindetail || '__@@GLOBAL@@__');
					url += "&uid="+Date.now();
					img.src = url;
				}
			}
		]);
	}
	me.button_wa_default._onclick=function(){
		gui.message.warning(getLang("warning::set_to_default"),false,[
			{
				value:getLang("generic::cancel"),
				type:'text borderless',
				method:'close'
			},
			{
				value:getLang("generic::set_to_default"),
				type:'success text',
				onclick:function(closeCallback){
					me._data.webadmin.resetAll(function(r){
						if(r==1) {
							me._level.getSettings(obj_whitelabeling.WEBADMIN_SETTINGS,function(wa){
								me._data.removeItem('webadmin');
								me._data.addItem(wa,'webadmin');
								me._loadWebAdmin(wa);
								gui.message.toast(getLang("message::reset_to_default"));
							});
						} else {
							gui.message.error(getLang("error::default_reset_failed"));
						}
					});
					closeCallback();
				}
			}
		]);
	}

	// Load using unified settings
	this._load();

}

// Load all values from server
_me._load = function() {

	// Languages
	com.getSettings('languages',function(langs){
		// Fill dropdown will all available languages
		this.__settings.languages = langs;
		this.dropdown_language._fill(langs);
		// Get the currently selected language
		com.getProperty('c_system_server_language',function(lang){
			this._language = lang;
			if(!lang.value) {
				lang.value = 'en';
			}
			this.dropdown_language._setValue(lang);
		}.bind(this));
	}.bind(this));

	// Login Settings
	this._level.getSettings(obj_whitelabeling.LOGIN_SETTINGS,function(s){
		if(s.error) {
			gui.message.error(getLang("error::server_failure")+s.error);
			return;
		}

		this._data.addItem(s,'login');

		this._loadLogin(s);
		this._activateLogin();
	}.bind(this));

	// WebMail and WebAdmin Settings
	this._level.getSettings(obj_whitelabeling.COMBINED_SETTINGS,function(s){
		if(s.error) {
			gui.message.error(getLang("error::server_failure")+s.error);
			return;
		}

		this._data.addItem(s.layout_settings,'webmail');
		this._data.addItem(s.layout_settings_admin,'webadmin');

		// For WebMail, get available design layouts
		com.settings.get('skins', function(layouts) {
			for(var id in layouts) {
				if (id !== 'banner' && id !== 'biggerrtl') {
					this.__settings.skin[id] = layouts[id];
				}
			}
			this.dropdown_wc_skin._fill(this.__settings.skin);

			// Fill in WebMail section and activate preview
			this._loadWebMail(s);
			this._activateWebMail();
		}.bind(this));

		// Fill in WebAdmin section and activate preview
		this._loadWebAdmin(s.layout_settings_admin);
		this._activateWebAdmin();
		this._loadFavicon(s.layout_settings);

		this._loadTheme(s.layout_settings);

	}.bind(this));

	// Banner options
	this._level.getSettings(obj_whitelabeling.BANNER_SETTINGS,function(banners){
		if(banners.error) {
			gui.message.error(getLang("error::server_failure")+banners.error);
			return;
		}

		this._data.addItem(banners,'banners');

		this._loadBanners(banners);
	}.bind(this));

	this._level.getSettings(obj_whitelabeling.CONFERENCING,function(conferencing){
		if(conferencing.error) {
			return gui.message.error(getLang("error::server_failure") + conferencing.error);
		}

		this._data.addItem(conferencing, 'conferencing');
		this._loadConferencing(conferencing);
	}.bind(this));

}

_me._setTheme = function(sColor, sImagePath) {
	if (!sColor && !sImagePath) {
		sColor = this.__sColor;
		sImagePath = this.__sImagePath;
	} else if (sColor) {
		this.__sColor = sColor;
		this.__sImagePath = '';
	} else if (sImagePath) {
		this.__sImagePath = sImagePath;
	}

	this.slider_login.preview_login._main.style.backgroundColor = this.__sColor;
	this.slider_webmail_skin.preview_webclient_skin._main.style.backgroundColor = this.__sColor;
	this.slider_login.preview_login._main.style.backgroundImage = this.__sImagePath ? "url(" + this.__sImagePath + ")" : '';
	this.slider_webmail_skin.preview_webclient_skin._main.style.backgroundImage = this.__sImagePath ? "url(" + this.__sImagePath + ")" : '';

	if (sImagePath) {
		extractColors.extractColorsFromSrc(sImagePath, {
			crossOrigin: 'anonymous'
		}).then(function(swatches) {
			var hsl, rgb, hex, hex_light;
			var mostPopulous = swatches[0];
			for (var i in swatches) {
				if (swatches[i].area * swatches[i].saturation > mostPopulous.area * mostPopulous.saturation) {
					mostPopulous = swatches[i];
				}
			}

			hsl = colors.rgb2hsl(mostPopulous.red, mostPopulous.green, mostPopulous.blue);

			rgb = colors.hsl2rgb(hsl[0], hsl[1], 0.45);
			hex = colors.rgb2hex.apply(colors, rgb);

			this.radio_interface_color_background_background._main.style.color = hex;
			if (this._data.webmail.login_interface_color.value === 'background') {
				this.slider_login.preview_login._main.style.setProperty('--theme-color', hex);
				this.slider_webmail_skin.preview_webclient_skin._main.style.setProperty('--theme-color', hex);
	
				rgb = colors.hsl2rgb(hsl[0], hsl[1], 0.95);
				hex_light = colors.rgb2hex.apply(colors, rgb);
				this.slider_login.preview_login._main.style.setProperty('--theme-color-light', hex_light);
				this.slider_webmail_skin.preview_webclient_skin._main.style.setProperty('--theme-color-light', hex_light);
			}
		}.bind(this));

		if (this._data.webmail.login_interface_color.value && this._data.webmail.login_interface_color.value !== 'background') {
			hex = this._data.webmail.login_interface_color.value;
			this.slider_login.preview_login._main.style.setProperty('--theme-color', hex);
			this.slider_webmail_skin.preview_webclient_skin._main.style.setProperty('--theme-color', hex);

			hsl = colors.rgb2hsl.apply(colors, colors.hex2rgb(hex));
			rgb = colors.hsl2rgb(hsl[0], hsl[1], 0.95);
			hex_light = colors.rgb2hex.apply(colors, rgb);
			this.slider_login.preview_login._main.style.setProperty('--theme-color-light', hex_light);
			this.slider_webmail_skin.preview_webclient_skin._main.style.setProperty('--theme-color-light', hex_light);
		}
	} else {
		var hsl = colors.rgb2hsl.apply(colors, colors.hex2rgb(sColor));
		var rgb = colors.hsl2rgb(hsl[0], hsl[1], 0.45);
		this.radio_interface_color_background_background._main.style.color = colors.rgb2hex.apply(colors, rgb);

		if (this._data.webmail.login_interface_color.value && this._data.webmail.login_interface_color.value !== 'background') {
			sColor = this._data.webmail.login_interface_color.value;
		}
		hsl = colors.rgb2hsl.apply(colors, colors.hex2rgb(sColor));

		rgb = colors.hsl2rgb(hsl[0], hsl[1], 0.45);
		var hex = colors.rgb2hex.apply(colors, rgb);
		this.slider_login.preview_login._main.style.setProperty('--theme-color', hex);
		this.slider_webmail_skin.preview_webclient_skin._main.style.setProperty('--theme-color', hex);

		rgb = colors.hsl2rgb(hsl[0], hsl[1], 0.95);
		var hex_light = colors.rgb2hex.apply(colors, rgb);
		this.slider_login.preview_login._main.style.setProperty('--theme-color-light', hex_light);
		this.slider_webmail_skin.preview_webclient_skin._main.style.setProperty('--theme-color-light', hex_light);

	}
}

_me._loadTheme = function(g) {
	this.slider_login.preview_login._main.classList.remove('cover', 'contain', 'tile', 'center');
	this.slider_login.preview_login._main.classList.add(g.login_background_wallpaper_size.value || 'cover');
	this.slider_webmail_skin.preview_webclient_skin._main.classList.remove('cover', 'contain', 'tile', 'center');
	this.slider_webmail_skin.preview_webclient_skin._main.classList.add(g.login_background_wallpaper_size.value || 'cover');

	this.dropdown_wallpaper_size._setValue(g.login_background_wallpaper_size);
	this.dropdown_wallpaper_size._fill({
		cover: getLang('WHITELABELING::WALLPAPER_COVER'),
		contain: getLang('WHITELABELING::WALLPAPER_CONTAIN'),
		tile: getLang('WHITELABELING::WALLPAPER_TILE'),
		center: getLang('WHITELABELING::WALLPAPER_CENTER')
	});
	this.dropdown_wallpaper_size._onchange = function(e, dropdown) {
		this.slider_login.preview_login._main.classList.remove('cover', 'contain', 'tile', 'center');
		this.slider_login.preview_login._main.classList.add(dropdown.value);
		this.slider_webmail_skin.preview_webclient_skin._main.classList.remove('cover', 'contain', 'tile', 'center');
		this.slider_webmail_skin.preview_webclient_skin._main.classList.add(dropdown.value);
	}.bind(this);

	// Default values when not defined on server
	g.login_background_name.default = this.__settings.background_urls['default_0'];
	g.login_interface_color.value = g.login_interface_color.value;

	this.upload_background_file._onfile = function(file) {
		if(!~['jpg', 'jpeg', 'png', 'gif'].indexOf((file.extension || '').toLowerCase())) {
			return gui.message.toast(getLang("error::unsupported_image_format"));
		}
		var filename = 'background.' + file.extension;
		g.login_background_name.initialValue = '';
		g.login_background_name.value = filename;
		g.login_background_file.value = file.content;
		this.__backgroundFileContent = file.content;
		this.__backgroundFileName = filename;
		g.login_background_color.value = '';
		g.login_background_solid.value = false;

		var checked = this.radio_background_color_custom._groupValue();
		if (checked) {
			(this['radio_background_color_' + checked] || this['radio_background_color_custom'])._checked(false);
		}
		var checked = this.radio_background_image_default_0._groupValue();
		if (checked) {
			checked = this.__settings._getFileLabel(checked);
			this['radio_background_image_' + checked]._checked(false);
		}

		this['radio_background_image_default_-1']._main.querySelector('i').style.backgroundImage = 'url(' + file.content + ')';
		this['radio_background_image_default_-1']._checked(true);

		this._setTheme(false, file.content);

	}.bind(this);
	this.upload_background_file._imagesOnly();

	if (g.login_background_solid.value !== 'true' && g.login_background_solid.value !== true) {
		this._setTheme(false, "./server/download.php?class=background&fullpath=" + encodeURIComponent(this.__domaindetail || '__@@GLOBAL@@__') + "&uid="+Date.now());
		this.radio_background_image_default_0._setValue(g.login_background_name);
		if (g.login_background_name.value && !this.__settings._getFileLabel(g.login_background_name.value)) {
			this.__backgroundFileName = g.login_background_name.value;
			var url = './server/download.php?class=background&fullpath=' + encodeURIComponent(this.__domaindetail || '__@@GLOBAL@@__') + '&uid=' + Date.now();
			this['radio_background_image_default_-1']._main.querySelector('i').style.backgroundImage = "url(" + url + ")";
			this['radio_background_image_default_-1']._checked(true);
			fetch(url).then((res) => res.blob()).then((blob) => {
				const reader = new FileReader();
				reader.onloadend = () => {
					this.__backgroundFileContent = reader.result;
				};
				reader.readAsDataURL(blob);
			});
		}
	} else {
		this._setTheme(g.login_background_color.value);
	}
	this.radio_background_color_custom._setValue(g.login_background_color);
	if (!this.__settings.background_colors[g.login_background_color.value]) {
		this.radio_background_color_custom._checked(true);
		this.radio_background_color_custom._main.style.color = g.login_background_color.value;
	}

	if (g.login_interface_color.value && !this.__settings.background_colors[g.login_interface_color.value] && g.login_interface_color.value !== 'background') {
		this.radio_interface_color_custom._main.style.color = g.login_interface_color.value;
	}

	this.radio_background_color_custom._onclick = function(e) {
		e.preventDefault();
		e.stopPropagation();
		e.stopImmediatePropagation();

		var popup = gui._create('popup', 'obj_popup');
		popup._init({
			name: 'colorpicker',
			heading: {
				value: getLang('whitelabeling::background_color')
			},
			fixed: false,
			footer: 'obj_accountinfo_changepwd_footer',
			content: 'obj_colorpicker'
		});
		popup.content._load({
			value: this.__customBackgroundColor || g.login_background_color.value || g.login_background_color.initialValue
		}, function(v) {
			this.__customBackgroundColor = v;
			g.login_background_color.value = v;
			this._setTheme(v);
			g.login_background_solid.value = true;

			var checked = this.radio_background_image_default_0._groupValue();
			this.radio_background_color_custom._main.style.color = v;
			if (checked) {
				checked = this.__settings._getFileLabel(checked);
				this['radio_background_image_' + checked]._checked(false);
			}
			var checked = this.radio_background_color_custom._groupValue();
			if (checked) {
				(this['radio_background_color_' + checked] || this['radio_background_color_custom'])._checked(false);
			}
			this.radio_background_color_custom._checked(true);
		}.bind(this));
	}.bind(this);

	this.radio_background_color_custom._groupOnchange = function(v) {
		g.login_background_color.value = v._value();
		this._setTheme(v._value());
		g.login_background_solid.value = true;
		g.login_background_file.value = null;

		var checked = this.radio_background_image_default_0._groupValue();
		if (checked) {
			checked = this.__settings._getFileLabel(checked);
			this['radio_background_image_' + checked]._checked(false);
		}
	}.bind(this);

	this['radio_background_image_default_-1']._onclick = function(e) {
		e.preventDefault();
		e.stopPropagation();
		e.stopImmediatePropagation();
		if (this.__backgroundFileName) {
			g.login_background_name.value = this.__backgroundFileName;
			g.login_background_file.value = this.__backgroundFileContent;
			this._setTheme(false, this.__backgroundFileContent);

			var checked = this.radio_background_color_custom._groupValue();
			if (checked) {
				(this['radio_background_color_' + checked] || this['radio_background_color_custom'])._checked(false);
			}
			var checked = this.radio_background_image_default_0._groupValue();
			if (checked) {
				checked = this.__settings._getFileLabel(checked);
				this['radio_background_image_' + checked]._checked(false);
			}

			setTimeout(function() {
				this['radio_background_image_default_-1']._checked(true)
			}.bind(this), 5);
		} else {
			this.upload_background_file.__eIN.click();
		}
	}.bind(this);

	this.radio_background_image_default_0._groupOnchange = function(v) {
		g.login_background_color.value = '';
		g.login_background_solid.value = false;
		g.login_background_file.value = null;

		this._setTheme(false, './client/skins/default/login/images/'+v._value());

		var checked = this.radio_background_color_custom._groupValue();
		if (checked) {
			(this['radio_background_color_' + checked] || this['radio_background_color_custom'])._checked(false);
		}
	}.bind(this);

	this.radio_interface_color_custom._onclick = function(e) {
		e.preventDefault();
		e.stopPropagation();
		e.stopImmediatePropagation();

		var popup = gui._create('popup', 'obj_popup');
		popup._init({
			name: 'colorpicker',
			heading: {
				value: getLang('whitelabeling::interface_color')
			},
			fixed: false,
			footer: 'obj_accountinfo_changepwd_footer',
			content: 'obj_colorpicker'
		});
		popup.content._load({
			theme: true,
			lightness: false,
			hex: false,
			value: this.__customInterfaceColor || (g.login_interface_color.value === 'background' ? '' : g.login_interface_color.value) || g.login_interface_color.initialValue
		}, function(v) {
			this.__customInterfaceColor = v;
			g.login_interface_color.value = v;
			this.radio_interface_color_custom._main.style.color = v;
			this._setTheme();
			this.radio_interface_color_background_background._checked(false);
			var checked = this.radio_interface_color_custom._groupValue();
			if (checked) {
				this['radio_interface_color_' + checked]._checked(false);
			}
			this['radio_interface_color_custom']._checked(true);
		}.bind(this));
	}.bind(this);
	
	this.radio_interface_color_custom._groupOnchange = function(v) {
		g.login_interface_color.value = v._value();
		this._setTheme();

		this.radio_interface_color_background_background._checked(false);
	}.bind(this);

	this.radio_interface_color_background_background._groupOnchange = function(v) {
		g.login_interface_color.value = 'background';
		this._setTheme();

		var checked = this.radio_interface_color_custom._groupValue();
		if (checked) {
			(this['radio_interface_color_' + checked] || this['radio_interface_color_custom'])._checked(false);
		}
	}.bind(this);

	if (g.login_interface_color.value === 'background') {
		this.radio_interface_color_background_background._checked(true);
	} else if (!this.__settings.background_colors[g.login_interface_color.value]) {
		this.radio_interface_color_custom._checked(true);
	} else {
		this['radio_interface_color_' + g.login_interface_color.value]._checked(true);
	}
	// this.radio_interface_color_custom._setValue(g.login_interface_color);

	// this.
};

// Fill in values into Login section
_me._loadLogin = function(l) {
	var r = l.restrictions;
	var f = l.custom_login_fields;
	var g = l.layout_settings;

	// Some restriction have values that appear opposite to UI elements
	r.disable_languages.inversed = true;
	r.disable_remember.inversed = true;
	r.disable_autofill.inversed = true;
	r.disable_signup.inversed = true;
	r.disable_guest_signin.inversed = true;
	r.website_disabled.inversed = true;
	r.facebook_disabled.inversed = true;
	r.twitter_disabled.inversed = true;
	r.linkedin_disabled.inversed = true;

	// Logo for Login
	var preview = this.slider_login.preview_login;
	this.upload_logo_file._onfile = function(file) {
		if(!~['jpg', 'jpeg', 'png', 'gif', 'svg'].indexOf((file.extension || '').toLowerCase())) {
			return gui.message.toast(getLang("error::unsupported_image_format"));
		}
		// Set uploaded logo as preview logo and show it
		var img = preview._main.getElementsByTagName('img')[0];
		var svg = img.parentNode.firstElementChild;
	//	if(file.type=="image/svg+xml")
		img.src = file.content;
		img.removeAttribute('is-hidden');
		svg.setAttribute('is-hidden',1);
		// Save upload filename
		g.logo_file.value = file.content;
		g.login_logo_name.initialValue = '';
		g.login_logo_name.value = 'login_logo.'+file.extension;
		this.button_login_logo_default._disabled(false);
	}.bind(this);

	this.button_login_logo_default._onclick = function() {
		this.button_login_logo_default._disabled(true);
		var img = preview._main.getElementsByTagName('img')[0];
		var svg = img.parentNode.firstElementChild;
		svg.removeAttribute('is-hidden');
		img.setAttribute('is-hidden', 1);
		g.logo_file.value = '';
		g.login_logo_name.value = '';
	}.bind(this);

	// Set restriction values
	this.toggle_disable_language._setValue(r.disable_languages);
	this.toggle_disable_remember_me._setValue(r.disable_remember);
	this.toggle_disable_autofill._setValue(r.disable_autofill);
	this.toggle_disable_sign_up._setValue(r.disable_signup);
	this.toggle_disable_guest_signin._setValue(r.disable_guest_signin);
	// Restrictions for Support
	var disable_support = this.toggle_disable_support_link;
	var require_phone = this.checkbox_phone_required;
	disable_support._setValue(r.contact_support);
	require_phone._setValue(r.support_require_number);
	if(!disable_support._checked()) {
		require_phone._hide();
	}
	disable_support._onchange = function(checked) {
		require_phone[checked?'_show':'_hide']();
	}
	// Restrictions for Search
	this.toggle_search._setValue(r.show_search);
	this.input_search._setValue(g.search_phrase);

	// Sign Up fields to show
	var signups = ['mobile_phone','birthday','company','gender','home_phone','homepage','im','job','nickname','profession','work_phone'];
	var field = '';
	while(field=signups.pop()) {
		this['toggle_'+field]._setValue(f[field+'_enabled']);
		this['checkbox_'+field+'_required']._setValue(f[field+'_required']);
		this['toggle_'+field]._onchange = (function(field) {
			return function(checked) {
				if(checked) {
					field._main.removeAttribute('is-hidden');
				} else {
					field._main.setAttribute('is-hidden',1);
				}
			}
		})(this['checkbox_'+field+'_required']);
		if(!this['toggle_'+field]._checked()) {
			this['checkbox_'+field+'_required']._main.setAttribute('is-hidden',1);
		}
	}

	// Sign up verification
	var toggle = this.toggle_two_step_verification;
	var dropdown = this.dropdown_two_step_verification;
	dropdown._fill({
		none: '',
		email: getLang('WHITELABELING::EMAIL'),
		sms: getLang('WHITELABELING::SMS')
	});
	toggle._setValue(f.login_verification_enabled);
	dropdown._setValue(f.login_verification_type);
	dropdown._disabled(!toggle._checked());
	toggle._onchange = function(checked) {
		dropdown._disabled(!checked);
	}
	dropdown._onchange = function(e) {
		if(this._value()=='none') {
			toggle._checked(false);
		}
	}

	// Social integration
	this.toggle_website._setValue(r.website_disabled);
	this.input_website._setValue(g.website_link);
	this.toggle_facebook._setValue(r.facebook_disabled);
	this.input_facebook._setValue(g.facebook_link);
	this.toggle_twitter._setValue(r.twitter_disabled);
	this.input_twitter._setValue(g.twitter_link);
	this.toggle_linkedin._setValue(r.linkedin_disabled);
	this.input_linkedin._setValue(g.linkedin_link);

	// Set preview according to values
	// preview._main.style.backgroundImage = "url(./server/download.php?class=background&fullpath=" + encodeURIComponent(this.__domaindetail || '__@@GLOBAL@@__') + "&uid=" + Date.now() + ")";
	// preview._main.className = preview._main.className.replace(/skin-[-a-z]+/,'');

	preview._enable('language',r.disable_languages!=1);
	preview._enable('remember',r.disable_remember!=1);
	preview._enable('autofill',r.disable_autofill!=1);
	preview._enable('sign_up',r.disable_signup);
	preview._enable('guest_signin',r.disable_guest_signin);
	preview._enable('support',r.contact_support==1);
	preview._enable('search',r.show_search==1);

	preview._enable('website',r.website_disabled!=1);
	preview._enable('facebook',r.facebook_disabled!=1);
	preview._enable('twitter',r.twitter_disabled!=1);
	preview._enable('linkedin',r.linkedin_disabled!=1);

}

// Activate preview logic for Login
_me._activateLogin = function() {
	var preview = this.slider_login.preview_login;
	this.toggle_disable_language._onchange = function(check) {
		preview._enable('language',check);
	}
	this.toggle_disable_remember_me._onchange = function(check) {
		preview._enable('remember',check);
	}
	this.toggle_disable_autofill._onchange = function(check) {
		preview._enable('autofill',check);
	}
	this.toggle_disable_sign_up._onchange = function(check) {
		preview._enable('sign_up',check);
	}
	this.toggle_disable_guest_signin._onchange = function(check) {
		preview._enable('guest_signin',check);
	}
	this.toggle_disable_support_link._onchange = function(check) {
		preview._enable('support',check);
	}
	this.toggle_search._onchange = function(check) {
		preview._enable('search',check);
	}

	this.toggle_website._onchange =
	this.toggle_facebook._onchange =
	this.toggle_twitter._onchange =
	this.toggle_linkedin._onchange =
	function(check) {
		preview._enable(this._name.substr(7),check);
	}

}

// Fill in values into WebClient section
_me._loadWebMail = function(wm) {
	var me = this;
	var skin = wm.layout_settings.skin;
	skin.default = 'default';
	if (skin.currentValue === 'banner') {
		skin.currentValue = 'default';
	} else if (skin.currentValue === 'biggerrtl') {
		skin.currentValue = 'bigger';
	}
	if (skin.initialValue === 'banner') {
		skin.initialValue = 'default';
	} else if (skin.initialValue === 'biggerrtl') {
		skin.initialValue = 'bigger';
	}

	this.input_wc_page_title._setValue(wm.layout_settings.title);
	this.dropdown_wc_skin._setValue(skin);

	// Set preview according to values
	var preview = this.slider_webmail_skin.preview_webclient_skin;
	preview._setAttribute('skin',skin.value || skin.default);
}
// Activate preview logic for WebMail
_me._activateWebMail = function() {
	var preview = this.slider_webmail_skin.preview_webclient_skin;

	this.dropdown_wc_skin._onchange = function(e) {
		if(e && e.target) {
			preview._setAttribute('skin',e.target.value);
		}
	}
}

// Fill in values into WebAdmin section
_me._loadWebAdmin = function(wa) {
	wa.skin_style.default = 'default';

	this.input_wa_page_title._setValue(wa.title);
	this.radio_wa_colorpicker_default._setValue(wa.skin_style);

	// Set preview according to values
	document.body.className = document.body.className.replace(/skin-[-a-z]+/,'');
	document.body.classList.add('skin-'+(wa.skin_style.value || wa.skin_style.default));
}
// Activate preview logic for WebAdmin
_me._activateWebAdmin = function() {
	this.radio_wa_colorpicker_default._groupOnchange = function(v) {
		document.body.className = document.body.className.replace(/skin-[-a-z]+/,'');
		document.body.classList.add('skin-'+v._value());
	}
}

// Fill in values into Banners section
_me._loadBanners = function(s) {
	this.toggle_adsense._setValue(s.restrictions.enable_adsense);

	var b = s.banner_options;
	this.input_adsense._setValue(b.customer_id);

	// Set default values
	b.desktop_type.default = 'none';
	b.mobile_type.default = 'none';
	b.top_type.default = 'none';
	b.below_type.default = 'none';

	this.radio_banner_desktop._setValue(b.desktop_type);
	this.input_banner_desktop_url._setValue(b.desktop_url);
	this.input_banner_desktop_code._setValue(b.desktop_code);

	this.radio_banner_mobile._setValue(b.mobile_type);
	this.input_banner_mobile_url._setValue(b.mobile_url);
	this.input_banner_mobile_code._setValue(b.mobile_code);

	this.radio_banner_top._setValue(b.top_type);
	this.input_banner_top_url._setValue(b.top_url);
	this.input_banner_top_link._setValue(b.top_link);
	this.input_banner_top_code._setValue(b.top_code);

	this.radio_banner_bottom._setValue(b.below_type);
	this.input_banner_bottom_url._setValue(b.below_url);
	this.input_banner_bottom_link._setValue(b.below_link);
	this.input_banner_bottom_code._setValue(b.below_code);
}

// Fill in values into Conferencing section
_me._loadConferencing = function(c) {
	this.upload_jitsi_logo_file._onfile = function(file) {
		if (!~['jpg', 'jpeg', 'png', 'gif'].indexOf((file.extension || '').toLowerCase())) {
			return;
		}
		c.jitsi_logo_file.value = file.content;
		c.jitsi_logo_name.initialValue = '';
		c.jitsi_logo_name.value = 'jitsi_logo.'+file.extension;
		this._getAnchor('jitsi_logo_preview').src = file.content;
		this._getAnchor('fi_jitsi_logo_default').classList.remove('hide');
	}.bind(this);

	if (c.jitsi_logo_name.value) {
		this._getAnchor('jitsi_logo_preview').src = './server/download.php?class=jitsi_logo&fullpath=' + (this.__domaindetail || '__@@GLOBAL@@__') + '&timestamp' + (+new Date());
	} else {
		this._getAnchor('fi_jitsi_logo_default').classList.add('hide');
	}

	this.button_jitsi_logo_default._onclick = function() {
		c.jitsi_logo_file.value = void 0;
		c.jitsi_logo_name.value = void 0;
		this._getAnchor('jitsi_logo_preview').src = './client/skins/default/images/preview/jitsi_watermark.png';
		this._getAnchor('fi_jitsi_logo_default').classList.add('hide');
	}.bind(this);

	this.input_jitsi_redirect_url._setValue(c.jitsi_redirect_url);
}

// Fill in values into Conferencing section
_me._loadFavicon = function(c) {
	this.upload_favicon_file._onfile = function(file) {
		if ((file.extension || '').toLowerCase() !== 'png') {
			return;
		}

		c.login_favicon_file.value = file.content;
		c.login_favicon_name.initialValue = '';
		c.login_favicon_name.value = 'favicon.png';
		this._getAnchor('favicon_preview').src = file.content;
		this._getAnchor('fi_favicon_default').classList.remove('hide');
	}.bind(this);

	if (c.login_favicon_name.value) {
		this._getAnchor('favicon_preview').src = './server/download.php?class=favicon&fullpath=' + (this.__domaindetail || '__@@GLOBAL@@__') + '&uid=' + (+new Date());
		this._getAnchor('fi_favicon_default').classList.remove('hide');
	} else {
		this._getAnchor('favicon_preview').src = './server/download.php?class=favicon&fullpath=' + (this.__domaindetail || '__@@GLOBAL@@__') + '&uid=1';
		this._getAnchor('fi_favicon_default').classList.add('hide');
	}

	this.button_favicon_default._onclick = function() {
		c.login_favicon_file.value = void 0;
		c.login_favicon_name.value = void 0;
		this._getAnchor('favicon_preview').src = './server/download.php?class=favicon&fullpath=' + (this.__domaindetail || '__@@GLOBAL@@__') + '&uid=1';
		this._getAnchor('fi_favicon_default').classList.add('hide');
	}.bind(this);
}

_me._issaved = function() {
	return !this._data.hasChanged();
}

_me._save = function(callback){
	var webadmin = this._data.webadmin;

	var changed = [];
	for(var i in this._data) {
		if(this._data[i].hasChanged()) {
			changed.push(this._data[i]);
		}
	}
	if(this._language.hasChanged()) {
		changed.push(this._language);
	}
	var failed = false;
	var saver = function(set) {
		set.saveChanges(function(r){
			if(r!=1) {
				failed = true;
			}
			if(set = changed.pop()) {
				saver(set);
			} else if(failed) {
				gui.message.error(getLang("error::save_unsuccessful"));
			} else {
				gui.message.toast(getLang("message::save_successfull"));
				// Note restriction changes are not updated, not used within WA
				gui._globalInfo.resources.removeItem('layout_settings_admin');
				gui._globalInfo.resources.addItem(webadmin);
				gui.frm_main._applySkin();
				if(callback) {
					callback(!failed);
				}
			}
		});
	};
	// If anything changed, save
	if(changed.length) {
		saver(changed.pop());
	}
}

_me._reset = function() {
	this._data.revertChanges();
}

/* View */

var WhiteLabelingView = function(controller) {
	this._control = controller;

}
WhiteLabelingView.prototype = Object.create(CoreView.prototype);
