function obj_userlist(){};
var _me = obj_userlist.prototype;
/**
 * @brief:
 * @date : 01.12.2014
 **/
_me.__constructor = function(s){
	var me = this;
	storage.library('wm_domain');
	storage.library('wm_user');
	storage.library('obj_accountpicker');

	me.page=0;
	me.max_count=0;
	me.loading=false;
	me._lastAccount = false;

	me.accounttypes={
		'-':getLang('accountdetail::all_types'),
		'*0':getLang('userlist::user'),
		'*1':getLang('userlist::mailing_list'),
		//'*2':getLang('userlist::executable'),
		//'*3':getLang('userlist::notification'),
		'*4':getLang('userlist::static_route'),
		//'*5':getLang('userlist::catalog'),
		//'*6':getLang('userlist::list_server'),
		'*7':getLang('userlist::group'),
		'*8':getLang('userlist::resource')
	};

	me.admintypes={
		'0':getLang('userlist::user'),
		'1':getLang('userlist::admin'),
		'2':getLang('userlist::domain_admin'),
		'3':getLang('userlist::webadmin')
	};

	me.plans = {
		'-': getLang('accountdetail::all_plans')
	};
	var plans = gui._globalInfo.licence.plans || [];
	if (plans.length) {
		plans.forEach(function(plan) {
			var label = getLang("SUBSCRIPTION_PLANS::" + plan.planlabel);
			me.plans[plan.planid] = ~label.indexOf("::") ? plan.planlabel : label;
		});
	}

	me.services = {
		'-': getLang('accountdetail::all_services'),
		'1': getLang('userlist_header::service_conferences'),
		'4': getLang('userlist_header::service_recording'),
		'2': getLang('userlist_header::service_activesync'),
		'3': getLang('userlist_header::service_desktop_client')
	};

	if(!gui.frm_main.main.actions){
		gui.frm_main.main._cleanHeadingButtonsAnchor();
		gui.frm_main.main._setAlternativeButtons(function(box,target_anchor){
			if(!box._alternativeButtons){
				box._alternativeButtons=[];
			}

			var actionobject = box._create('actions','obj_actionselect',target_anchor, 'userlist');
			actionobject._value('generic::select_action');
			if(target_anchor=='heading_buttons_mobile'){actionobject._addcss('full',true);}

			me._updateActions();

			actionobject._disabled(true);

			box._alternativeButtons.push(actionobject);

			if (plans.length) {
				var exportButton = box._create('export', 'obj_button', target_anchor, 'text primary');
				exportButton._value('generic::export');
				exportButton._onclick = function() {
					exportButton._disabled(true);
					me.__export(function() {
						exportButton._disabled(false);
					});
				}
				exportButton._disabled(true);
				if(target_anchor == 'heading_buttons_mobile') {
					exportButton._addcss('full', true);
				}
				box._alternativeButtons.push(exportButton);
			}
		});
	}
};

_me.__export = function(callback) {
	var me = this;
	var domain = new Domain(location.parsed_query.domain);
	var list = domain.getAccountList({type: Account.USER});

	var search = gui.frm_main._getSearch(true);
	list.filter(search);

	var type = me.list.dropdown_userlist_filter;
	if(!type) {
		type = 0;
	} else if (type._value() != '-') {
		type = type._value();
	} else {
		type = undefined;
	}
	list.type(type);

	if(me.list.dropdown_userlist_plans) {
		var plan = me.list.dropdown_userlist_plans._value();
		list.setFilter({ planmask: plan });
	}

	if(me.list.dropdown_userlist_services) {
		var service = me.list.dropdown_userlist_services._value();
		list.setFilter({ servicemask: service });
	}

	var plans = gui._globalInfo.licence.plans || [];
	list.load(function(items) {
		var data = [].map.call(items || [], function(item) {
			var plan, planlabel;
			var size = +item.quota.mailboxsize.value;
			var max = +item.quota.mailboxquota.value;

			if(plans.length && +item.planid.value) {
				plan = plans.filter(function(plan) {
					return +plan.planid.value === +item.planid.value;
				})[0] || {};
				planlabel = getLang("SUBSCRIPTION_PLANS::" + plan.planlabel);
				planlabel = planlabel.indexOf("::")==-1 ? planlabel : (plan.planlabel ? plan.planlabel.value : item.planid.value);
			}

			return {
				[getLang('userlist_header::account')]: punycode.ToUnicode(item.email.value),
				[getLang('userlist_header::name')]: item.name.value,
				[getLang('userlist_header::type')]: item.accounttype.value == 0 ? me.admintypes[item.admintype.value || 0] : me.accounttypes['*' + item.accounttype.value],
				[getLang('userlist_header::quota')]: [size ? relativeByteSize(size, 2, 1) : '', max ? relativeByteSize(max, 2, 1) : ''].filter(Boolean).join(' / '),
				[getLang('accountdetail::disabled')]: +((item.accountstate || {}).state || {}).value,
				[getLang('accountdetail::subscription_plan') + ' ID']: ((plan || {}).planid || {}).value || '',
				[getLang('accountdetail::subscription_plan')]: item.accounttype.value == 0 ? planlabel : '',
				[getLang('userlist_header::service_conferences')]: item.accounttype.value == 0 ? +item.serviceinfo.meetingvalue.value : '',
				[getLang('userlist_header::service_recording')]: item.accounttype.value == 0 ? +item.serviceinfo.recordingvalue.value : '',
				[getLang('userlist_header::service_activesync')]: item.accounttype.value == 0 ? +item.serviceinfo.activesyncvalue.value : '',
				[getLang('userlist_header::service_desktop_client')]: item.accounttype.value == 0 ? +item.serviceinfo.desktopvalue.value : ''
			};
		});
		
		if (data.length) {
			var csv = [Object.keys(data[0])].concat(data.map(function(item) {
				return Object.values(item).map(function(data) {
					return '"' + data.toString().replace(/^[=+\-@\r\t]/, "'$&").replace(/"/g, '""') + '"';
				});
			}));

			var link = document.createElement("a");
			link.setAttribute("href", encodeURI("data:text/csv;charset=utf-8," + csv.map(row => row.join(",")).join("\n")));
			link.setAttribute("download", location.parsed_query.domain + '.csv');
			document.body.appendChild(link);
			link.click();
			document.body.removeChild(link);
		}

		callback && callback();

	}, {chunk: 9999 });
};

_me._updateActions = function() {
	var me = this;
	var options = [];
	if(location.parsed_query.tab_management!="guestaccounts") {
		if (this.list && this.list._getSelectedList() !== 'all') {
			['activesync', 'desktop', 'meeting', 'recording'].forEach(function(service) {
				var list = {
					enable: this.list._getSelectedList().filter(function(item) {
						return item.type === 0 && item['u_' + service + 'editable'] && !item['u_' + service];
					}),
				 	disable: this.list._getSelectedList().filter(function(item) {
						return item.type === 0 && item['u_' + service + 'editable'] && item['u_' + service];
					})
				};
				['enable', 'disable'].forEach(function(type, i) {
					list[type].length && options.push({
						name: type + '_' + service,
						icon: 'service ' + service + ' ' + type,
						value: 'userlist::' + type + '_' + service,
						onclick: function() {
							me._setAccountsService(list[type], 'u_' + service, +!i, function() {
								me._lastAccount = false;
								me.list._emptySelectedList();
								me.list._load();
							});
							return false;
						}
					});
				});
			}, this);
		}

		options.push({
			name:'group',
			icon: 'plus-circle',
			onclick:function(){
				me._groupSelectedAccounts();
				return false;
			},
			value:'accountdetail::add_to_group'
		},{
			name:'move',
			icon: 'move',
			onclick:function(){
				me._showMoveDialog();
				return false;
			},
			value:'accountdetail::move'
		});
	}
	options.push({
		name:'delete',
		icon: 'delete',
		type: 'color-error',
		onclick:function(){
			me._deleteSelectedAccounts();
			return false;
		},
		value:'accountdetail::delete'
	});
	gui.frm_main.main.actions._fill(options);
}

_me._onSearch=function(string){
	dataSet.add('accountlist-filter',['search-'+location.parsed_query.domain],string);
	//log.log(['accountlist-onsearch',string,dataSet.get('accountlist-filter',['search'])]);
	this._lastAccount = false;
	this.list._empty();
	this.list._load();
}

_me._load = function(settings)
{
	var me=this;

	/** activate search icon, assign on search callback */
	gui.frm_main._initSearch(function (string) {
		me._onSearch(string);
	});

	this._draw('obj_userlist' + (settings && settings.subTemplate?"_" + settings.subTemplate:""), '', {
		items:{},
		options: JSON.stringify({
			plans: (gui._globalInfo.licence.plans || []).length
		})
	});

	if(settings){
		if(settings.domain){location.parsed_query.domain=settings.domain;}
	}

	// open dns info
	if(location.parsed_query.showdomaininfo){
		me._parent.domaindetail._DNSValidation();
	}
	//

	if(this.list.dropdown_userlist_filter){
		this.list.dropdown_userlist_filter._fill(me.accounttypes);
		this.list.dropdown_userlist_filter._value('0');	// set default filter type (user)

		me.list._main.setAttribute('iw-type', '0');
		this.list.dropdown_userlist_filter._onchange=function(e){
			var val=this._value();
			dataSet.add('accountlist-filter',['type-'+location.parsed_query.domain],val);
			me._lastAccount = false;
			me.list._emptySelectedList();
			me.list._empty();
			me.list._load();
			me.list._main.setAttribute('iw-type', val);
		};
	}

	if(this.list.dropdown_userlist_plans && Object.keys(me.plans).length > 1){
		this.list.dropdown_userlist_plans._fill(me.plans);
		this.list.dropdown_userlist_plans._value('-');

		this.list.dropdown_userlist_plans._onchange = function(e){
			var val = this._value();
			dataSet.add('accountlist-filter', ['plans-' + location.parsed_query.domain], val);
			me._lastAccount = false;
			me.list._emptySelectedList();
			me.list._empty();
			me.list._load();
		};
	} else if (this.list.dropdown_userlist_plans) {
		this.list.dropdown_userlist_plans._destruct();
	}

	if(this.list.dropdown_userlist_services) {
		this.list.dropdown_userlist_services._fill(me.services);
		this.list.dropdown_userlist_services._value('-');

		this.list.dropdown_userlist_services._onchange = function(e){
			var val = this._value();
			dataSet.add('accountlist-filter', ['services-' + location.parsed_query.domain], val);
			me._lastAccount = false;
			me.list._emptySelectedList();
			me.list._empty();
			me.list._load();
		};
	}

	this.list._onchange=function(e){
		try
		{
			//handle select all
			if(e && e.text=='select-all'){
				this._selectAll(e.type,true,true);
			}
			//

			if(me.list._getSelectedCount()==0){
				for(var i=0; i<gui.frm_main.main._alternativeButtons.length; i++)
				{
					gui.frm_main.main._alternativeButtons[0]._text(getLang("generic::select_action"));
					gui.frm_main.main._alternativeButtons[i]._disabled(true);
				}
			}else{
				for(var i=0; i<gui.frm_main.main._alternativeButtons.length; i++)
				{
					gui.frm_main.main._alternativeButtons[0]._text(getLang("generic::select_action")+" ("+me.list._getSelectedCount()+")");
					gui.frm_main.main._alternativeButtons[i]._disabled(false);
				}
			}

			/* prevent default action */
			if(e && e.text=='select-all'){
				return false;
			}
			//
		}
		catch(err){
			log.error(['userlist-onchange',e,err]);
		}
	}

	// handle saved filter
	var filter_type=dataSet.get('accountlist-filter',['type-'+location.parsed_query.domain]);
	if(typeof filter_type != 'undefined'){
		if(me.list.dropdown_userlist_filter){
			me.list.dropdown_userlist_filter._value(filter_type,true);
		}
	}
	var plan=dataSet.get('accountlist-filter',['plans-'+location.parsed_query.domain]);
	if(typeof plan != 'undefined'){
		if(me.list.dropdown_userlist_plans){
			me.list.dropdown_userlist_plans._value(plan,true);
		}
	}
	var services = dataSet.get('accountlist-filter', ['services-' + location.parsed_query.domain]);
	if(typeof services != 'undefined') {
		if(me.list.dropdown_userlist_services) {
			me.list.dropdown_userlist_services._value(services, true);
		}
	}
	var filter_search=dataSet.get('accountlist-filter',['search-'+location.parsed_query.domain]);
	if(filter_search){
		log.log(['accountlist-constructor',filter_search]);
		gui.frm_main._setSearchString(filter_search);
	}

	//
	var domain = new Domain(location.parsed_query.domain);
	var list = domain.getAccountList({type: Account.USER});

	this.list._init('obj_userlist',false,function(linesPerPage,page,callback){

		var search = gui.frm_main._getSearch(true);
		list.filter(search);

		var type = me.list.dropdown_userlist_filter;
		if(!type) {
			type = 0;
		} else if (type._value()!='-') {
			type = type._value();
		} else {
			type = undefined;
		}
		list.type(type);

		if(me.list.dropdown_userlist_plans) {
			var plan = me.list.dropdown_userlist_plans._value();
			list.setFilter({ planmask: plan });
		}

		if(me.list.dropdown_userlist_services) {
			var service = me.list.dropdown_userlist_services._value();
			list.setFilter({ servicemask: service });
		}

		me.__aData = [];
		list.load(function(items){
			gui.frm_main._setSearchResults(items.total);
			me.list._setMax(items.total);
			gui.frm_main.main.left_menu._setItemValue('userlist',getLang('domaindetail::users')+' ('+items.total+')');

			var plans = gui._globalInfo.licence.plans || [];
			for(var i=0, l=items.length; i<l; i++) {
				me.__aData.push(items[i]);
				var plan, planlabel;
				var size = +items[i].quota.mailboxsize.value;
				var max = +items[i].quota.mailboxquota.value;

				if(plans.length && +items[i].planid.value) {
					plan = plans.filter(function(plan) {
						return +plan.planid.value === +items[i].planid.value;
					})[0] || {};
					planlabel = getLang("SUBSCRIPTION_PLANS::" + plan.planlabel);
					planlabel = planlabel.indexOf("::")==-1 ? planlabel : plan.planlabel || items[i].planid.value;
				}

				var item = {
					id: items[i].email.value,
					name: items[i].name.value,
					unpunied: punycode.ToUnicode(items[i].email.value),
					image: items[i].image ? 'data:' + items[i].image.contenttype.value + ';base64,' + items[i].image.base64data.value : '',
					type: +items[i].accounttype.value,
					type_str: me.accounttypes['*'+items[i].accounttype.value],
					hasSubtype: items[i].accounttype.value==0,
					subtype: items[i].admintype.value || 0,
					subtype_str: me.admintypes[items[i].admintype.value || 0],
					size: relativeByteSize(size,2,1),
					disabled: +((items[i].accountstate || {}).state || {}).value,
					plans: plans.length,
					planlabel: items[i].accounttype.value == 0 ? planlabel : '',
					planid: (plan || {}).planid,
					hash: md5(items[i].accounttype.value == 0 ? 'ad-' + (items[i].admintype.value || 0) : ('ac-' + (items[i].accounttype.value || 0))),
					u_meetingeditable: +items[i].serviceinfo.meetingeditable.value,
					u_recordingeditable: +items[i].serviceinfo.recordingeditable.value,
					u_activesynceditable: +items[i].serviceinfo.activesynceditable.value,
					u_desktopeditable: +items[i].serviceinfo.desktopeditable.value,
					u_meeting: +items[i].serviceinfo.meetingvalue.value,
					u_recording: +items[i].serviceinfo.recordingvalue.value,
					u_activesync: +items[i].serviceinfo.activesyncvalue.value,
					u_desktop: +items[i].serviceinfo.desktopvalue.value
				};
				if(max) {
					item.isQuota = true;
					item.quota = (size/max*100).toFixed(2);
					item.quotaSize = relativeByteSize(max,2,1);
				}

				if (!settings.subTemplate && (!type || type === '0')) {
					item.subitem = true;
					if(!me._lastAccount || me._lastAccount.subtype!=item.subtype){
						me.list._drawItem({
							group: item.hash,
							plans: plans.length,
							selectable: false,
							name: +items[i].accounttype.value ? me.accounttypes['*'+items[i].accounttype.value] : me.admintypes[items[i].admintype.value]
						},function(elm,checked){
							var hash = elm._main.parentElement.getAttribute('group');
							[].slice.apply(me.list._getAnchor('body').getElementsByClassName(hash)).forEach(function(elm){
								var obj = eval(elm.querySelector('form.obj_checkbox').id);
								obj && !obj._destructed && obj._checked(checked);
							});
						});

						me._lastAccount=item;
					}
				}

				item.line = me.list._drawItem(item, function() {
					me._updateActions();
				});

				if (!settings.subTemplate && item.type === 0) {
					['meeting', 'recording', 'activesync', 'desktop'].forEach(function(service, i) {
						var button = item.line._objects[i + 1];
						if (button) {
							if (item['u_' + service + 'editable']) {
								button._title(item['u_' + service] ? 'USERLIST::DISABLE_' + service : 'USERLIST::ENABLE_' + service);
								button._onclick = function (item) {
									this._disabled(true);
									me._setAccountsService([item], 'u_' + service, +!item['u_' + service], function() {
										this._disabled(false);
										this._title(item['u_' + service] ? 'USERLIST::DISABLE_' + service : 'USERLIST::ENABLE_' + service);
										this._main.classList.toggle('active', item['u_' + service]);
									}.bind(this));
								}.bind(button, item);
							} else {
								button._title('USERLIST::' + service + '_DISABLED');
							}
						}
					});
				}
			}

			callback && callback();

		},{chunk: linesPerPage});
	});

	this.list._onempty = function(){
		list.reset();
	};

	this._main.onclick=function(e){

		var e = e || window.event,
		elm = e.target || e.srcElement;

		if(elm)
		{
			var ul=Is.Child(elm,'UL',this);
			if(ul && ul.getAttribute('hash')){
				location.hash=ul.getAttribute('hash');
			}
		}
	};
}

_me._setAccountsService = function(selectedList, service, value, callback) {
	var selected = (selectedList || me.list._getSelectedList()).filter(function(item) {
		return item[service + 'editable'] && (item[service] !== value);
	});
	var length = selected.length;
	
	if (!length) {
		return callback && callback();
	}

	selected.forEach(function(item) {
		var data = [{
			apiproperty: [{
				propname: [{ VALUE: service.replace(/(client_)?desktop/, 'client_desktop') }]
			}],
			propertyval: [{
				classname: [{VALUE: 'tpropertystring' }],
				val: [{ VALUE: value }]
			}]
		}];
		com.user.setData(item.id, data, [function (response) {
			try {
				if (response.Array.IQ[0].QUERY[0].RESULT[0].VALUE === '1') {
					item[service] = value;
				} else {
					gui.message.toast(getLang('error::action_failed'));
				}
			} catch(e) {}

			if (!--length) {
				this._updateActions();
				callback && callback();
			}
		}.bind(this)]);
	}, this);
}

_me._groupSelectedAccounts=function(){
	var me=this;

	gui.accountpicker(function(items,type){
		// what to do on accounts picked?
		var groups=[];
		for(var i=0; i<items.length; i++){
			groups.push(items[i].id);
		}

		var accounts=[];
		var selected=me.list._getSelectedList();

		if(typeof selected == 'string' && selected=='all')
		{
			// if selected all is active
			log.info('All is selected');

			var namemask=gui.frm_main._getSearch(true);
			var typemask=false;
			var type=0;
			if(me.list.dropdown_userlist_filter){
				type = me.list.dropdown_userlist_filter._value();
			}
			var planmask='*';
			var plan=0;
			if(me.list.dropdown_userlist_plans){
				plan = me.list.dropdown_userlist_plans._value();
			}
			var servicemask='*';
			var service=0;
			if(me.list.dropdown_userlist_services){
				service = me.list.dropdown_userlist_services._value();
			}

			if(type!='-'){
				typemask=type;
			}
			if(plan!='-'){
				planmask=plan;
			}
			if(service!='-'){
				servicemask=service;
			}

			com.user.addAllToGroup(groups,location.parsed_query.domain,{
				namemask:namemask,
				typemask:typemask,
				planmask:planmask,
				servicemask:servicemask
			},function(result){
				if(!result.Array.IQ[0].QUERY[0].RESULT || result.Array.IQ[0].QUERY[0].RESULT[0].VALUE==0){
					gui.message.error(getLang("error::save_unsuccessful"));
					if(result.Array.IQ[0].QUERY[0].ERROR){
						log.error('e:cannot_add_member_to_itself',result.Array.IQ[0].QUERY[0].ERROR);
					}
				}else{
					gui.message.toast(getLang("message::save_successfull"));
					me.list._emptySelectedList();
				}
			});
		}
		else
		{
			// if only some are selected
			for(var i=0; i<selected.length; i++){
				accounts.push(selected[i].id);
			}

			com.user.addToGroup(groups,accounts,function(result){
				if(!result.Array.IQ[0].QUERY[0].RESULT || result.Array.IQ[0].QUERY[0].RESULT[0].VALUE==0){
					gui.message.error(getLang("error::save_unsuccessful"));
					if(result.Array.IQ[0].QUERY[0].ERROR){
						log.error('e:cannot_add_member_to_itself',result.Array.IQ[0].QUERY[0].ERROR);
					}
				}else{
					gui.message.toast(getLang("message::save_successfull"));
					me.list._emptySelectedList();
				}
			});
		}
		//
	},{
		// some cool settings defining the accountPicker's behavior
		type:{force:true,value:7},
		disable_add_domain:true
	});
}

_me._showMoveDialog=function(){
	var me=this;

	gui.accountpicker(function(items,type){
		var domain = items[0].id;
		var selected = me.list._getSelectedList();

		var accounts = [];
		for(var i=0; i<selected.length; i++){
			accounts.push(selected[i].email || selected[i].id);
		}

		gui.message.warning(
			getLang("warning::move_selected_accounts", [selected.length, domain]),
			false,
			[
				{
					value:getLang("accountdetail::move"),
					onclick:function(closeCallback) {
						closeCallback();
						me._moveUser(domain, accounts);
					}
				},
				{
					value:getLang("generic::cancel"),
					type:'text borderless',
					onclick: function(closeCallback) {
						closeCallback();
						me._showMoveDialog();
					}
				}
			]
		);
	},{
		domainpicker: true,
		singledomain: true,
		disable_add_domain: true,
		exclude:{domains:[location.parsed_query.domain]}
	});
};

_me._moveUser=function(domain, accounts) {
	var me = this;

	com.domain.moveAccounts(domain,accounts,function(result){
		if(result.error || result == 0) {
			gui.message.error(getLang("error::save_unsuccessful"));
		} else {
			gui.message.toast(getLang("message::save_successfull"));
			me._lastAccount = false;
			me.list._emptySelectedList();
			me.list._load();
		}
	});
};

_me._deleteSelectedAccounts=function(bForceDeleteLoggedInUser, bForceDeleteLastAdmin) {
	var me = this;
	var num = this.list._getSelectedCount();
	var selected=me.list._getSelectedList();
	
	if (!bForceDeleteLoggedInUser) {
		for(var i in selected) {
			if ((gui._globalInfo.email === selected[i].id || gui._globalInfo.email === selected[i].unpunied)) {
				return gui.message.warning([getLang("warning::delete_logged_in_user")], false, [
					{
						value:getLang("generic::cancel"),
						method:'close'
					},
					{
						value:getLang("generic::delete"),
						onclick:function(closeCallback){
							closeCallback();
							me._deleteSelectedAccounts(true);
						},
						type:'text error'
					},
				]);
			}
		}
	}

	if (!bForceDeleteLastAdmin) {
		var admins = [];
		var hasAdmin = false;
		for (var i in this.__aData) {
			if (this.__aData[i].accounttype == 0 && this.__aData[i].admintype > 0) {
				admins.push(this.__aData[i].email.value);
				hasAdmin = true;
			}
		}
		for (var i in selected) {
			if (selected[i].type === 0 && selected[i].subtype > 0) {
				admins = admins.filter(function(admin) {
					return admin !== selected[i].id;
				});
			}
		}

		if (hasAdmin && !admins.length) {
			return gui.message.warning([getLang("warning::delete_last_admin")], false, [
				{
					value:getLang("generic::cancel"),
					method:'close'
				},
				{
					value:getLang("generic::delete"),
					onclick:function(closeCallback){
						closeCallback();
						me._deleteSelectedAccounts(bForceDeleteLoggedInUser, true);
					},
					type:'text error'
				},
			]);
		}
	}

	// check for deleting superior account
	var superior = false;
	var mytype = gui._globalInfo.admintype;
	for(var i in selected)
		if (mytype==USER_DOMAIN && selected[i].subtype==USER_ADMIN){
			superior = true;
			break;
		}

	if(superior || mytype==USER_USER) {
		gui.message.error(getLang('error::insufficient_rights'));
		return;
	}

	function subdelete(selected, total, done, step, closeCallback) {
		done = done || 0;
		step = step || 10;

		var toDelete;
		if (selected.length > step) {
			toDelete = selected.splice(0, step);
		} else {
			toDelete = selected;
			selected = [];
		}

		prompt.content._showLoading(getLang('generic::processing') + ' (' + (toDelete.length + done) + '/' + total + ')');
		com.domain.deleteAccounts(location.parsed_query.domain,toDelete,function(result){
			if (selected.length > 0) {
				subdelete(selected, total, toDelete.length + done, step, closeCallback);
			} else {
				closeCallback();
				me._lastAccount = false;
				me.list._emptySelectedList();
				me.list._load();
			}
		},function(error){
			if(error=='account_permission'){error='insufficient_rights';}
			closeCallback();
			me.list._emptySelectedList();
			gui.message.error(getLang('error::'+error));
		});
	}

	var prompt = gui.message.warning([getLang("warning::delete_selected_items", [num]), getLang('warning::operation_may_take_long_time')],false,[
		{
			value:getLang("generic::cancel"),
			method:'close'
		},
		{
			value:getLang("generic::delete"),
			onclick:function(closeCallback){
				prompt.main.btn_custom_0._disabled(true);
				prompt.main.btn_custom_1._disabled(true);
				prompt.content._showLoading(getLang('generic::processing'));

				if(typeof selected == 'string' && selected=='all')
				{
					// selected all active
					log.info('All is selected');
					filter={};

					var namemask=gui.frm_main._getSearch(true);
					var typemask=false;
					var type=0;
					if(me.list.dropdown_userlist_filter){
						type = me.list.dropdown_userlist_filter._value();
					}
					var planmask='*';
					var plan=0;
					if(me.list.dropdown_userlist_plans){
						plan = me.list.dropdown_userlist_plans._value();
					}
					var servicemask='*';
					var service=0;
					if(me.list.dropdown_userlist_services){
						service = me.list.dropdown_userlist_services._value();
					}

					if(type!='-'){
						typemask=type;
					}
					if(plan!='-'){
						planmask=plan;
					}
					if(service!='-'){
						servicemask=service;
					}

					filter.namemask=namemask;
					filter.typemask=typemask;
					filter.planmask=planmask;
					filter.servicemask=servicemask;

					com.domain.deleteAllAccounts(location.parsed_query.domain,filter,function(result){
						closeCallback();
						me._lastAccount = false;
						me.list._emptySelectedList();
						me.list._load();
					});
				}
				else
				{
					// only some are selected
					subdelete(selected, selected.length, 0, 10, closeCallback);
				}
			},
			type:'text error'
		},
	]);
};