function obj_stats() {};

var _me = obj_stats.prototype;
_me.__constructor = function () {};


_me._load = function (aData) {
	aData = Object.assign({
		from: calculateDateFrom(aData.to),
		to: new Date(),
		filter: '',
		maxitems: '',
		groupbydomain: false
	}, aData);

	this._draw('obj_stats', '', aData);

	this.input_from._value(aData.from);
	this.input_to._value(aData.to);
	if (aData.filter) {
		this.input_filter._value(aData.filter);
		this.input_filter._disabled(true);
	}
	this.input_maxitems._value(aData.maxitems);
	this.toggle_groupbydomain._checked(aData.groupbydomain);

	this.dropdown_range._fill({
		'*0': getLang('statistics::range_specified'),
		'*1': getLang('statistics::range_month'),
		'*2': getLang('statistics::range_2months'),
		'*3': getLang('statistics::range_quarter'),
		'*4': getLang('statistics::range_2quarters'),
		'*5': getLang('statistics::range_3quarters'),
		'*6': getLang('statistics::range_year'),
	});

	function calculateDateFrom(to, rangeType) {
		var rangeTypeToMonthsBack = {1: 1, 2: 2, 3: 3, 4: 6, 5: 9, 6: 12};

		to = to ? new Date(to) : new Date();
		return +rangeType ? new Date(to.setMonth(to.getMonth() - rangeTypeToMonthsBack[+rangeType])) : to;
	}

	this.dropdown_range._onchange = function() {
		this.input_from._disabled(+this.dropdown_range._value());
		this.input_from._value(calculateDateFrom(this.input_to._value(), this.dropdown_range._value()));
	}.bind(this);

	this.input_to.__eIN.addEventListener('change', function() {
		this.input_from._value(calculateDateFrom(this.input_to._value(), this.dropdown_range._value()));
	}.bind(this), false);

	this.button_download._onclick = function () {
		com.server.getUserStats({
			from: this.input_from._value(),
			to: this.input_to._value(),
			filter: this.input_filter._value(),
			maxitems: this.input_maxitems._value(),
			groupbydomain: this.toggle_groupbydomain._checked()
		}, function (url) {
			downloadItem(url, true);
		}, function() {
			gui.message.toast(getLang("statistics::download_unsuccessful"));
		});
	}.bind(this);
}

