function obj_login_ip_restrictions() { }
var _me = obj_login_ip_restrictions.prototype;

_me.__constructor = function (s) {
	storage.library("wm_server");
};

_me._load = function () {
	this.__restrictions = [];

	this._draw("obj_login_ip_restrictions");

	this._parent.btn_save._onclick = function () {
		this._parent.btn_save._disabled(true);
		this._save();
	}.bind(this);

	com.server.getLoginRestrictionsIPList(function (aFilterList) {
		(aFilterList || []).forEach(this._addRestriction, this);
	}.bind(this));

	this.add_restriction._onclick = function () {
		this._addRestriction();
	}.bind(this);
};

_me._addRestriction = function (aFilter) {
	aFilter = aFilter || {};
	var template = this._main.querySelector('.template.restriction').cloneNode(true);
	template.classList.remove('hide');

	var address = this._create('address', 'obj_input_text', '', 'form__element');
	address._tabIndex(true);
	address._value(aFilter.filter);
	address._placeholder('loginiprestrictions::address_placeholder')
	template.querySelector('.address').appendChild(address._main);

	var Restriction = {
		filter: address,
		hostlist: [],
		wrapper: template,
		hostsWrapper: template.querySelector('.hosts')
	};
	(aFilter.hostlist || []).forEach(function (sHost) {
		this._addHost(sHost, Restriction);
	}, this);

	var add_host = this._create('add_host', 'obj_button', '', 'text primary');
	add_host._tabIndex(true);
	add_host._value('loginiprestrictions::add_host');
	add_host._onclick = function () {
		this._addHost('', Restriction);
	}.bind(this);
	template.querySelector('.add_host').appendChild(add_host._main);

	if (!Restriction.hostlist.length) {
		this._addHost('', Restriction);
	}

	var remove = this._create('remove', 'obj_button', '', 'text error remove form__element');
	remove._value('loginiprestrictions::remove');
	remove._onclick = function () {
		if (!Restriction.filter._value() && !Restriction.hostlist.some(function (host) {
			return host._value();
		}) && this.__restrictions.length > 1) {
			this._removeRestriction(Restriction);
		}
	}.bind(this);
	template.querySelector('.actions').appendChild(remove._main);

	var moveUp = this._create('move_up', 'obj_button', '', 'icon icon-arrow-up primary move_up form__element');
	moveUp._onclick = function () {
		this._moveUp(Restriction);
	}.bind(this);
	template.querySelector('.actions').appendChild(moveUp._main);

	var moveDown = this._create('move_down', 'obj_button', '', 'icon icon-arrow-down primary move_down form__element');
	moveDown._onclick = function () {
		this._moveDown(Restriction);
	}.bind(this);
	template.querySelector('.actions').appendChild(moveDown._main);

	this._getAnchor('restrictions').appendChild(template);

	this.__restrictions.push(Restriction);
};

_me._removeRestriction = function (restriction) {
	this.__restrictions = this.__restrictions.filter(function (r) {
		return r !== restriction;
	});
	restriction.wrapper.parentNode.removeChild(restriction.wrapper);
};

_me._moveUp = function (Restriction) {
	var index = this.__restrictions.indexOf(Restriction);
	this.__restrictions.splice(index - 1, 0, this.__restrictions.splice(index, 1)[0]);
	Restriction.wrapper.previousSibling.insertAdjacentElement('beforebegin', Restriction.wrapper);
}

_me._moveDown = function (Restriction) {
	var index = this.__restrictions.indexOf(Restriction);
	this.__restrictions.splice(index + 1, 0, this.__restrictions.splice(index, 1)[0]);
	Restriction.wrapper.nextSibling.insertAdjacentElement('afterend', Restriction.wrapper);
}

_me._addHost = function (sHost, Restriction) {
	var me = this;
	var host = this._create('host', 'obj_input_text', '', 'form__element');
	host._tabIndex(true);
	host._value(sHost);
	host._placeholder('loginiprestrictions::host_placeholder');
	host._onblur = function () {
		if (!this._value() && Restriction.hostlist.length > 1) {
			me._removeHost(host);
		}
	}
	Restriction.hostlist.push(host);
	Restriction.hostsWrapper.appendChild(host._main);
	host.Restriction = Restriction;
	return host;
};

_me._removeHost = function (host) {
	host.Restriction.hostlist = host.Restriction.hostlist.filter(function (h) {
		return h !== host;
	});
	host._destruct();
};

_me._save = function () {
	var aFilterList = this.__restrictions.map(function (restriction) {
		return {
			filter: restriction.filter._value(),
			hostlist: restriction.hostlist.map(function (host) {
				return host._value();
			}).filter(Boolean)
		}
	}).filter(function (restriction) {
		return restriction.filter && restriction.hostlist.join('');
	});

	com.server.setLoginRestrictionsIPList(aFilterList, function (result) {
		if (result) {
			gui.message.toast(getLang("message::save_successfull"));
		} else {
			gui.message.error(getLang("error::save_unsuccessful"));
		}
		this._close();
	}.bind(this));
};
