function obj_features(){};
_me = obj_features.prototype;

obj_features.restrictions = {
	restrictions: ['disable_gw_types', 'disable_dashboard', 'dashboard_notes_enabled', 'dashboard_files_enabled', 'dashboard_marketplace_enabled'],
}

_me.__constructor = function(s){
	var me = this;

	var view = this._view = new WebclientSettingsView(this);

	view.addSaveButton();

	this.__globalResources=helper.clone(gui._globalInfo.resources);
	this.__is_default_enabled=false;
	this.__resource_level=RESOURCE_LEVEL_SERVER;
	this.__who=false;
	if(location.parsed_query.domain){
		this.__resource_level=RESOURCE_LEVEL_DOMAIN;
		this.__who=location.parsed_query.domain;
	}
	if(location.parsed_query.account){
		this.__resource_level=RESOURCE_LEVEL_ACCOUNT;
		this.__who=location.parsed_query.account;
	}

	me.__domaindetail=false;
	if(location.parsed_query.domain){
		me.__domaindetail=location.parsed_query.domain;
	}

	if(!me.__domaindetail) {
		gui.frm_main.main._init({
			name: 'features',
			heading: {
				value: getLang('main::features')
			}
		});
	}

	// Deciding on which level to apply the settings (server or domain)
	this._level = com;
	if(this.__domaindetail) {
		this._level = new Domain(this.__domaindetail);
	}
	// Create a container for all settings
	this._data = new IWAPI.Collection('Settings');

	/** settings */
	this.__settings={};

};

_me._hash_handler=function(){
	this._draw('obj_features', '', {
		domain: this.__domaindetail
	});

	this._load();
};

// Load all values from server
_me._load = function() {
	this._level.getSettings(obj_features.restrictions, function(restrictions) {
		if(restrictions.error) {
			gui.message.error(getLang("error::server_failure")+s.error);
			return;
		}

		this._data.addItem(restrictions, 'restrictions');

		this._loadWebMail(restrictions);
	}.bind(this));

};

_me._loadWebMail = function(rest) {
	var me = this;
	
	var disable_gw_types = rest.disable_gw_types.value || '';
	var gw_modules = {
		c: 'contacts',
		e: 'calendars',
		f: 'files',
		n: 'notes',
		t: 'tasks',
		q: 'quarantine'
	}

	for (var i in gw_modules) {
		var toggle = this['toggle_enable_module_' + gw_modules[i]];
		toggle._checked(!~disable_gw_types.indexOf(i));
		toggle._onchange = function(i) {
			if (me['toggle_enable_cloud_module_' + gw_modules[i]]) {
				me['toggle_enable_cloud_module_' + gw_modules[i]]._disabled(!this._checked());
			}

			if (me['enable_cloud_module_' + gw_modules[i] + '_0']) {
				me['enable_cloud_module_' + gw_modules[i] + '_0']._disabled(!this._checked());
			}
			if (me['enable_cloud_module_' + gw_modules[i] + '_1']) {
				me['enable_cloud_module_' + gw_modules[i] + '_1']._disabled(!this._checked());
			}

			if (this._checked() && ~disable_gw_types.indexOf(i)) {
				disable_gw_types = disable_gw_types.replace(i, '');
			} else if (!this._checked() && !~disable_gw_types.indexOf(i)) {
				disable_gw_types += i;
			}
			if ((rest.disable_gw_types.value || '') != disable_gw_types) {
				rest.disable_gw_types.value = disable_gw_types;
			}
		}.bind(toggle, i);
		toggle._onchange();
	}

	[
		'marketplace'
	].forEach(function(module) {
		this['toggle_enable_cloud_module_' + module]._setValue(rest['dashboard_' + module + '_enabled']);
	}, this);

	[
		'notes',
		'files',
	].forEach(function(module) {
		var value = rest['dashboard_' + module + '_enabled'] || 0;
		this['enable_cloud_module_' + module + '_' + value]._checked(true);
	}, this);

	if (rest.disable_dashboard == 1) {
		this._getAnchor('fb_cloud_module').setAttribute('hidden', '');
		this._getAnchor('fb_cloud_modules').setAttribute('hidden', '');
	}
}

_me._issaved = function() {
	return !this._data.hasChanged();
}

_me._save = function(callback){
	var webadmin = this._data.webadmin;

	[
		'notes',
		'files',
	].forEach(function(module) {
		this._data.restrictions['dashboard_' + module + '_enabled'].value = +this['enable_cloud_module_' + module + '_' + 1]._checked();
	}, this);

	var changed = [];
	for(var i in this._data) {
		if(this._data[i].hasChanged()) {
			changed.push(this._data[i]);
		}
	}
	var failed = false;
	var saver = function(set) {
		set.saveChanges(function(r){
			if(r!=1) {
				failed = true;
			}
			if(set = changed.pop()) {
				saver(set);
			} else if(failed) {
				gui.message.error(getLang("error::save_unsuccessful"));
			} else {
				gui.message.toast(getLang("message::save_successfull"));
				// Note restriction changes are not updated, not used within WA
				gui._globalInfo.resources.removeItem('layout_settings_admin');
				gui._globalInfo.resources.addItem(webadmin);
				gui.frm_main._applySkin();
				if(callback) {
					callback(!failed);
				}
			}
		});
	};
	// If anything changed, save
	if(changed.length) {
		saver(changed.pop());
	}
}

_me._reset = function() {
	this._data.revertChanges();
}

/* View */

var WebclientSettingsView = function(controller) {
	this._control = controller;

}
WebclientSettingsView.prototype = Object.create(CoreView.prototype);
