<?php

declare(strict_types=1);

namespace Sentry;

use Sentry\State\Hub;
use Sentry\State\HubInterface;

 
final class SentrySdk
{
     
    private static $currentHub;

     
    private function __construct()
    {
    }

     
    public static function init(): HubInterface
    {
        self::$currentHub = new Hub();

        return self::$currentHub;
    }

     
    public static function getCurrentHub(): HubInterface
    {
        if (self::$currentHub === null) {
            self::$currentHub = new Hub();
        }

        return self::$currentHub;
    }

     
    public static function setCurrentHub(HubInterface $hub): HubInterface
    {
        self::$currentHub = $hub;

        return $hub;
    }
}
