<?php

declare(strict_types=1);

namespace Sentry;

 
final class EventType implements \Stringable
{
     
    private $value;

     
    private static $instances = [];

    private function __construct(string $value)
    {
        $this->value = $value;
    }

    public static function event(): self
    {
        return self::getInstance('event');
    }

    public static function transaction(): self
    {
        return self::getInstance('transaction');
    }

    public static function checkIn(): self
    {
        return self::getInstance('check_in');
    }

    public static function logs(): self
    {
        return self::getInstance('log');
    }

     
    public static function metrics(): self
    {
        return self::getInstance('metrics');
    }

     
    public static function cases(): array
    {
        return [
            self::event(),
            self::transaction(),
            self::checkIn(),
            self::logs(),
            self::metrics(),
        ];
    }

    public function __toString(): string
    {
        return $this->value;
    }

    private static function getInstance(string $value): self
    {
        if (!isset(self::$instances[$value])) {
            self::$instances[$value] = new self($value);
        }

        return self::$instances[$value];
    }
}
