<?php

 
 



class SearchTool
{
	static $knownCommands = array(
		'from',
		'to',
		'subject',
		'cc',
		'bcc',
		'sms',
		'priority',
		'description',
		'title',
		'name',
		'email',
		'isemail',
		'company',
		'department',
		'location',
		'greater',
		'smaller',
		'keyword',
		'tag',
		'fulltext',
		'has',
		'is',
		'in',
		'after',
		'before',
		'beforetime',
		'aftertime',
		'beforeid',
		'afterid',
		'sinceid',
		'untilid',
		'color',
		'flag',
		'count',
		'class',
		'items',
		'classify',
		'mobile',
		'phone',
		'email1',
		'email2',
		'email3',
		'conference',
		'category',
		'note',
		'gchat',
		'everywhere',
		'creationdate',
		'comments',
		'next',
		'folder',
		'partid',
        'flags',
        'afterend',
        'beforeend',
        'taglist',
        'simplefulltext',
        'evncomevnid',
        'rid',
		'last',
		'with',
		'message-id',
	);
	static $operators = array(
		'creationdate'=>'=',
		'beforetime'=>'<',
		'before'=>'<',
		'aftertime'=>'>',
		'after'=>'>'
	);
	static $folderDefaults = array(
		 		'M'=>array(
			'header_from',
			'header_to',
			'subject',
			'header_cc',
			'header_bcc',
			'header_sms'
		),
		'SNOOZED'=>array(
			'header_from',
			'header_to',
			'subject',
			'header_cc',
			'header_bcc',
			'header_sms'
		),
		 		'C'=>array(
			'ItmTitle',
			'ItmClassifyAs',
			'LctEmail1',
			'LctEmail2',
			'LctEmail3',
			'ItmCompany',
			'ItmDepartment',
			'ItmCategory',
			'ItmFirstName',
			'ItmSurName',
			'ItmMiddleName',
			'ItmDescription',

			 			'LctPhnHome1',
			'LctPhnHome2',
			'LctPhnAssistant',
			'LctPhnWork1',
			'LctPhnWork2',
			'LctPhnFaxHome',
			'LctPhnFaxWork',
			'LctPhnCallback',
			'LctPhnCompany',
			'LctPhnCar',
			'LctPhnIsdn',
			'LctPhnMobile',
			'LctPhnOther',
			'LctPhnOtherFax',
			'LctPhnPager',
			'LctPhnPrimary',
			'LctPhnRadio',
			'LctPhnTelex',
			'LctPhnHearing'
		),
		'E'=>array(
			'EvnTitle',
			'EvnNote',
		),
		'T'=>array(
			'EvnTitle',
			'EvnNote'
		),
		'N'=>array(
			'EvnTitle',
			'EvnNote'
		),
		'F'=>array(
			'EvnTitle',
			'EvnLocation',
			'EvnNote'
		),
		'J'=>array(
			'EvnTitle',
			'EvnNote'
		),
		 		'Q'=>array(
			'SndEmail',
			'SndOwner',
			'SndDomain',
			'SndSubject'
		),
		'QL'=>array(
			'SndEmail',
			'SndOwner',
			'SndDomain'
		),
		 		'G'=>array(
			'ItmTitle',
			'ItmOriginalFolder',
			'Itm_Deleted'
		),
		 		'SL'=>array(
			'subject',
			'header_from'
		),
		 		'K'=>array(
			'tagname'
		),
		 		'HIPAA'=>array(
			'fullname',
			'type'
		),
		 		'I'=>array(
			'EvnTitle',
			'EvnNote',
		)
	);
	
	static private $wildcards = array("%","_","[","]","^");
	static private $escaped = array('\%','\_','\[','\]','\^');
	
	private $type;
	private $tableName;
    public $dbtype;
    public $oFolder;
    public $tz;
    public $account;
    public $filter;

	public function __construct(&$filter = false)
	{
		$this->configTableName($_SESSION['DBTYPE']);
		$this->dbtype = $_SESSION['DBTYPE'];
		$this->filter = &$filter;
	}

	public function setFolder($oFolder)
	{
		$this->oFolder = $oFolder;
	}
	
	public function setTimeZone($tz)
	{
		$this->tz = $tz;
	}
	
	public function configTableName($dbType)
	{
		$this->dbtype = $dbType;
		$this->setTableName(false);
		if($this->oFolder && $this->oFolder->type=='V' && $this->oFolder->getType()=='M' && $this->oFolder->isEmpty()){
            if (strtoupper($dbType) == 'MYSQL') $this->setTableName('i');
		}
	}
	
	public function setTableName($tableName)
	{
		$this->tableName = $tableName;
	}
	public function getTableName()
	{
		return $this->tableName?$this->tableName.'.':'';
	}
	
	
	public function setType($type)
	{
		$this->type = $type;
	}
	
	public function getType()
	{
		return $this->type;
	}
	
	public function setAccount(&$account)
	{
		$this->account = &$account;
	}
	
	public function getAccount()
	{
		return $this->account;
	}

	public function termToSql($term)
	{
		$keyword = strtolower($term['keyword']);
		$value = strtolower($term['value']);
		return $this->processFunction($keyword, $value);
	}
	
	static public function urlEnquoteEscape($str)
    {
        return slToolsString::urlenquote($str);
    }
	
	static public function urlEnquoteEscapeTag($str)
    {
        return str_replace('+', "'20", slToolsString::urlenquote($str));
    }

	private function escapeWildcards($value)
	{
		return str_replace(self::$wildcards,self::$escaped,$value);
	}
	
	private function escapeValue($value, $exact_match = false)
	{
		switch($this->type){
			case 'Q':
			case 'QL':
			     				$value = icewarp_escape_db_string($value,'antispam');
				break;
			default:
                $value = str_replace("'","''",$value);
				break;
		}
		return $value;
	}
	
	 
	private function processValue($value , $condition, $count, $value_callback = array(), $condition_callback = array(), $exact_match = false)
	{	
		 		$value = slToolsString::removeQuotes($value);
		
		 		$value = $this->escapeValue($value, $exact_match);  		
		 		$value = $this->executeCallback($value, $value_callback);
		
		 		if($value || trim($value,'"')==='0' || trim($value,"'")==='0'){
			if($count > 1){
				$condition = vsprintf($condition,array_fill(0,$count,$value));
			}elseif ($count!=0){
				$condition = sprintf($condition,$value);
			}			
		}
		$condition = $this->executeCallback($value, $condition_callback,$condition);

		return $condition;
	}
	
	private function executeCallback($value,$callback,$condition = '')
	{
		$arguments = array($value,$condition);
		
		if(is_array($callback['arguments'])){
			$arguments = slToolsPHP::array_merge($arguments,$callback['arguments']);
		}
		if(!empty($callback['func'])){
			if($callback['class']){
				$value = call_user_func_array(array($callback['class'], $callback['func']), $arguments);
			}else{
				$value = $callback['func']($arguments[0],$arguments[1],$arguments[2],$arguments[3],$arguments[4],$arguments[5]);
			}
		}else if($condition){
			$value = $condition; 
		}
		return $value;		
	}
	
	 
	private function processFunction($command, $value)
	{		
		$exact_match = false;  		$count = 1;  		$table = $this->getTableName();
		 		switch(strtolower($command)){
			 			case 'from':
				switch($this->type){
					case 'Q':
					case 'QL':
						$condition = "(".$table."SndEmail IS NOT NULL AND ".$table."SndEmail LIKE '%%%s%%' {ESCAPE '\\'})";
						break;
					case 'SNOOZED':
					case 'M':
						$condition = "(".$table."header_from IS NOT NULL AND ".$table."header_from LIKE '%%%s%%' {ESCAPE '\\'})";
						break;
					case 'I':
						$condition_callback = array(
							'class'=>&$this,
							'func'=>'teamChatMemberCondition',
							'arguments'=>array('from')
						);
						break;
				}
				break;
			case 'to':
				switch($this->type){
					case 'Q':
					case 'QL':
						$condition = "(SndOwner IS NOT NULL AND SndOwner LIKE '%%%s%%' {ESCAPE '\\'})";
						break;
					case 'SNOOZED':
					case 'M':
						$condition = "(".$table."header_to IS NOT NULL AND ".$table."header_to LIKE '%%%s%%' {ESCAPE '\\'})";
						break;
				}
				break;
			case 'subject':
				switch($this->type){
					case 'Q':
						$condition = "(SndSubject IS NOT NULL AND SndSubject LIKE '%%%s%%' {ESCAPE '\\'})";
						break;
					case 'SNOOZED':
					case 'M':
						$condition = "(".$table."subject IS NOT NULL AND ".$table."subject LIKE '%%%s%%' {ESCAPE '\\'})";
						break;
					}
					break;
				break;
			case 'cc':
				$condition = "(".$table."header_cc IS NOT NULL AND ".$table."header_cc LIKE '%%%s%%' {ESCAPE '\\'})";
				break;
			case 'bcc':
				$condition = "(".$table."header_bcc IS NOT NULL AND ".$table."header_bcc LIKE '%%%s%%' {ESCAPE '\\'})";
				break;
			case 'sms':
				$condition = "(".$table."header_sms IS NOT NULL AND ".$table."header_sms LIKE '%%%s%%' {ESCAPE '\\'})";
				break;
			case 'priority':
				$condition_callback = array(
					'class'=>&$this,
					'func'=>'priorityCondition'
				);
				break;
			case 'color':
				$condition_callback = array(
					'class'=>&$this,
					'func'=>'colorCondition'
				);				
			break;
			case 'last':
				$condition_callback = array(
					'class'=>&$this,
					'func'=>'lastCondition'
				);	
			break;
			case 'with':
				$condition = "(".  
				"(".$table."header_from IS NOT NULL AND ".$table."header_from LIKE '%%%s%%' {ESCAPE '\\'})".
				" OR (".$table."header_to IS NOT NULL AND ".$table."header_to LIKE '%%%s%%' {ESCAPE '\\'})".
				" OR (".$table."header_cc IS NOT NULL AND ".$table."header_cc LIKE '%%%s%%' {ESCAPE '\\'})".
				")";
				$count = 3;
			break;
			 			case 'note':
			case 'description':
				if($this->type=='C'){
					$condition = "(ItmDescription IS NOT NULL AND ItmDescription LIKE '%%%s%%' {ESCAPE '\\'})";
				}else{
					$condition = "(EvnNote IS NOT NULL AND EvnNote LIKE '%%%s%%' {ESCAPE '\\'})";
				}
				break;
			break;
            case 'evncomevnid':
                $condition = "(evncomevnid IS NOT NULL AND evncomevnid LIKE '%%%s%%' {ESCAPE '\\'})";
                break;
            case 'rid':
                if(in_array($this->type,['C', 'G'])){
                    $condition = "(ItmRID = '%s')";
                }else{
                    $condition = "(EvnRID = '%s')";
                }
                break;
			case 'gchat':
                $this->filter['groupchat_type'] = trim($value);
                $condition = "1=1";
				break;
			case 'title':
				switch($this->type){
					case 'G':
					case 'C':
						$condition = "(ItmTitle IS NOT NULL AND ItmTitle LIKE '%%%s%%' {ESCAPE '\\'})";
					break;
					case 'SL':
						$condition = "(header_from IS NOT NULL AND header_from LIKE '%%%s%%' {ESCAPE '\\'})";
						break;
					default:
						$condition = "(EvnTitle IS NOT NULL AND EvnTitle LIKE '%%%s%%' {ESCAPE '\\'})";
					break;
				}
				break;
			case 'name':
				switch($this->type){
					case 'C':
						$condition = "((ItmClassifyAs IS NOT NULL AND ItmClassifyAs LIKE '%%%s%%' {ESCAPE '\\'}) OR (ItmFirstName IS NOT NULL AND ItmFirstName LIKE '%%%s%%' {ESCAPE '\\'}) OR (ItmMiddleName IS NOT NULL AND ItmMiddleName LIKE '%%%s%%' {ESCAPE '\\'}) OR (ItmSurName IS NOT NULL AND ItmSurName LIKE '%%%s%%' {ESCAPE '\\'}))";
						$count = 4;
						break;
					case 'SL':
						$condition = "(header_from IS NOT NULL AND header_from LIKE '%%%s%%' {ESCAPE '\\'})";
						break;
					case 'Z':
						$this->filter['name'] = $value;
						 
						break;
				}
				break;
			case 'everywhere':
				switch($this->type)	{
					case 'Z':
						$this->filter['everywhere'] = $value;
						break;
					case 'I':						
						$condition_callback = array(
							'class'=>&$this,
							'func'=>'teamChatMemberCondition',
							'arguments'=>array('everywhere')
						);
						break;
				}
				break;
			case 'isemail':
				switch($this->type){
					case 'C':
						$condition = "((LCTEMAIL1 = '%s') OR (LCTEMAIL2 ='%s') OR (LCTEMAIL3 = '%s'))";
						$exact_match = true;
						$count = 3;
						break;
					case 'Z':
						$this->filter['email'] = $value;
						break;
					case 'I':
						$condition_callback = array(
							'class'=>&$this,
							'func'=>'teamChatMemberCondition',
							'arguments'=>array('isemail')
						);
						break;
				}
				break;
			case 'email':
				switch($this->type){
					case 'C':
						$condition = "((LCTEMAIL1 IS NOT NULL AND LCTEMAIL1 LIKE '%%%s%%'  {ESCAPE '\\'}) OR (LCTEMAIL2 IS NOT NULL AND LCTEMAIL2 LIKE '%%%s%%'  {ESCAPE '\\'}) OR (LCTEMAIL3 IS NOT NULL AND LCTEMAIL3 LIKE '%%%s%%' {ESCAPE '\\'}))";
						$count = 3;
						break;
					case 'SL':
						$condition = "(".$table."subject IS NOT NULL AND ".$table."subject LIKE '%%%s%%'  {ESCAPE '\\'})";
						$count = 1;
						break;
					case 'Z':
						$this->filter['email'] = $value;
						break;
					case 'I':
						$condition_callback = array(
							'class'=>&$this,
							'func'=>'teamChatMemberCondition',
							'arguments'=>array('email')
						);
						break;
				}
				break;
			case 'company':
				$condition = "(ItmCompany IS NOT NULL AND ItmCompany LIKE '%%%s%%' {ESCAPE '\\'})";
				break;
			case 'department':
				$condition = "(ItmDepartment IS NOT NULL AND ItmDepartment LIKE '%%%s%%' {ESCAPE '\\'})";
				break;
			case 'category':
				if($this->type!='M'){
					if($this->type=='C'){
						$col = 'ItmCategory';
					}else{
						$col = 'EvnCategory';
					}
					$condition = "($col IS NOT NULL AND $col LIKE '%%%s%%' {ESCAPE '\\'})";
				}
				break;
			case 'location':
				$condition = "(EvnLocation IS NOT NULL AND EvnLocation LIKE '%%%s%%' {ESCAPE '\\'})";
				break;
			break;
			 			case 'greater':
				switch($this->type){
					case 'M':
					case 'SNOOZED':
						$condition = $this->getTableName().'size > %s';
						$value_callback = array(
							'class'=>&$this,
							'func'=>'kbtob'
						);
					break;
					case 'I':
					case 'F':
						$condition = 'EvnComplete > %s';
						$value_callback = array(
							'class'=>&$this,
							'func'=>'kbtob'
						);
					break;
				}
			break;
			case 'smaller':
				switch($this->type){
					case 'M':
					case 'SNOOZED':
						$condition = $this->getTableName().'size < %s';
						$value_callback = array(
							'class'=>&$this,
							'func'=>'kbtob'
						);
					break;
					case 'I':
					case 'F':
						$condition = 'EvnComplete < %s';
						$value_callback = array(
							'class'=>&$this,
							'func'=>'kbtob'
						);
					break;
				}
			break;

			case 'keyword':			case 'tag':
				switch($this->type){
					case 'Q':
					case 'QL':
						break;
					case 'SNOOZED':
					case 'M':
							$condition = $this->getTagListCondition($value);
							$count = 0;
							break;
					case 'K':
						$condition = "(tagname IS NOT NULL AND tagname LIKE \"%%%s%%\" {ESCAPE '\\'})";
						break;
					default:
						$condition = "";
						$exact_match = true;
						break;
				}
				break;
            case 'taglist':
                $condition = $this->getTagListCondition($value);
				$count = 0;
				break;
			case 'fulltext':
            case 'simplefulltext':
                if(in_array($this->type, ['M','F','C','E','N','T','I','K','Q','QL', 'SNOOZED'])){
                    $conditions = [];
                    foreach(self::$folderDefaults[$this->type] as $field){
                        $conditions[] = "(".$this->getTableName().$field." IS NOT NULL AND ".$this->getTableName().$field." LIKE '%%%s%%' {ESCAPE '\\'})";
                    }
                    $condition = join(' OR ',$conditions);
                    $condition = '('.$condition.')';
                    $count = count(self::$folderDefaults[$this->type]);
                }elseif($this->type=='Z'){
					$this->filter['everywhere'] = $value;
				}
                break;
			case 'has':
				$condition_callback = array(
					'class'=>&$this,
					'func'=>'hasCondition'
				);		
				break;
			case 'is':
				$condition_callback = array(
					'class'=>&$this,
					'func'=>'isCondition'
				);		
				break;
			case 'in':
				$condition_callback = array(
					'class'=>&$this,
					'func'=>'inCondition'
				);		
			break;
            case 'afterend':
                if($this->type == 'E') {
                    $this->filter['idinterval'] = 'FUTURE';
                    $condition = null;
                    $value = null;
                }
                break;
            case 'beforeend':
                if($this->type == 'E') {
                    $this->filter['idinterval'] = 'PAST';
                    $condition = null;
                    $value = null;
                }
                break;
			case 'after':
			case 'aftertime':
			case 'beforetime':
			case 'creationdate':
			case 'before':
				$operator = self::$operators[strtolower($command)];
				$function_suffix  = strtolower($command)=='before'?'before':'';
				switch($this->type){
					case 'SNOOZED':
					case 'M':
						$condition= $this->getTableName().'date '.$operator.' %s';
						$value_callback = array(
							'class'=>&$this,
							'func'=>'strtotime'.$function_suffix
						);
						break;
					case 'C':
						break;
					case 'T':
						$condition= 'EvnEndDate '.$operator.' %s';
						$value_callback = array(
							'class'=>&$this,
							'func'=>'strtodelphidate'.$function_suffix
						);
						break;
					case 'E':
					case 'N':
					case 'J':
						$condition= 'EvnStartDate '.$operator.' %s';
						$value_callback = array(
							'class'=>&$this,
							'func'=>'strtodelphidate'.$function_suffix
						);
						break;
					case 'I':			
						$condition_callback = array(
							'class'=>&$this,
							'func'=>'teamChatTimeCondition',
							'arguments'=>array(strtolower($command))
						);
						break;
					case 'F':
						$condition= 'Evn_Modified '.$operator.' %s';
						$value_callback = array(
							'class'=>&$this,
							'func'=>'strtotime'.$function_suffix
						);
					break;
					case 'Q':
					case 'QL':
						$condition= 'SndCreatedOn '.$operator.' %s';
						$value_callback = array(
							'class'=>&$this,
							'func'=>'strtodelphidate'.$function_suffix
						);
					break;
					case 'G':
						$condition= 'Itm_Deleted '.$operator.' %s';
						$value_callback = array(
							'class'=>&$this,
							'func'=>'strtotime'.$function_suffix
						);
					break;
				}
			break;
			case 'comments':
				$condition = "(EvnComEvnID = '%s')";
				$exact_match = true;
				break; 
			case 'sinceid':
				$condition = "(Evn_ID >= '%s')";
				break;
			case 'afterid':
                if($this->type == 'E' && preg_match('/(?:afterend|beforeend)/i', $this->filter['search'])){
                    $this->filter['idinterval'] = ($this->filter['idinterval'] ?? '') . '+' . $value;
                    $condition = null;
                    $value = null;
                }else{
                    $condition = "(Evn_ID > '%s')";
                }
				break; 	
			case 'beforeid':
                if($this->type == 'E' && preg_match('/(?:afterend|beforeend)/i', $this->filter['search'])){
                    $this->filter['idinterval'] = ($this->filter['idinterval'] ?? '') . '+' . $value;
                    $condition = null;
                    $value = null;
                }else {
                    $condition = "(Evn_ID < '%s')";
                }
				break;
			case 'untilid':
				$condition = "(Evn_ID <= '%s')";
				break; 
			case 'next':
				$this->filter['next'] = $value;			
				$condition = "(1=1)";
				break;
			case 'folder':
				$condition = "(ItmOriginalFolder IS NOT NULL AND ItmOriginalFolder = '%s')";
				$exact_match = true;
				break;
			case 'flags':
				if($this->type == 'M' ){
					$condition = "(".$table."flags IS NOT NULL AND ".$table."flags = %s)";
					$exact_match = true;
				}else{
					$condition = "(1=1)";
				}
			break;
			case 'class':
				switch($this->type){
					case 'C':
						$condition = "(ItmClass = '%s')";
						break;
					case 'I':
						$condition = "(1=1)";
						break;
				}
				break;
			case 'items':
				$condition_callback = array(
					'class'=>&$this,
					'func'=>'itemsCondition'
				);		
				break;
			case 'classify':
				$condition = "(ItmClassifyAs IS NOT NULL AND ItmClassifyAs = '%s')";
				break;
			case 'mobile':
				$condition = "(LctPhnMobile IS NOT NULL AND LctPhnMobile LIKE '%%%s%%' {ESCAPE '\\'})";
				break;
			case 'email1':
				$condition = "(LCTEMAIL1 IS NOT NULL AND LCTEMAIL1 LIKE '%%%s%%' {ESCAPE '\\'})";
				break;
			case 'email2':
				$condition = "(LCTEMAIL2 IS NOT NULL AND LCTEMAIL2 LIKE '%%%s%%' {ESCAPE '\\'})";
				break;
			case 'email3':
				$condition = "(LCTEMAIL3 IS NOT NULL AND LCTEMAIL3 LIKE '%%%s%%' {ESCAPE '\\'})";
				break;
			case 'phone':
				$condition = "((LctPhnHome1 IS NOT NULL AND LctPhnHome1 LIKE '%%%s%%' {ESCAPE '\\'}) ".
						  "OR (LctPhnHome2 IS NOT NULL AND LctPhnHome2 LIKE '%%%s%%' {ESCAPE '\\'}) ".
						  "OR (LctPhnAssistant IS NOT NULL AND LctPhnAssistant LIKE '%%%s%%' {ESCAPE '\\'}) ".
						  "OR (LctPhnWork1 IS NOT NULL AND LctPhnWork1 LIKE '%%%s%%' {ESCAPE '\\'}) ".
						  "OR (LctPhnWork2 IS NOT NULL AND LctPhnWork2 LIKE '%%%s%%' {ESCAPE '\\'}) ".
						  "OR (LctPhnCallback IS NOT NULL AND LctPhnCallback LIKE '%%%s%%' {ESCAPE '\\'}) ".
						  "OR (LctPhnCompany IS NOT NULL AND LctPhnCompany LIKE '%%%s%%' {ESCAPE '\\'}) ".
						  "OR (LctPhnCar IS NOT NULL AND LctPhnCar LIKE '%%%s%%' {ESCAPE '\\'}) ".
						  "OR (LctPhnISDN IS NOT NULL AND LctPhnISDN LIKE '%%%s%%' {ESCAPE '\\'}) ".
						  "OR (LctPhnMobile IS NOT NULL AND LctPhnMobile LIKE '%%%s%%' {ESCAPE '\\'}) ".
						  "OR (LctPhnPager IS NOT NULL AND LctPhnPager LIKE '%%%s%%' {ESCAPE '\\'}) ".
						  "OR (LctPhnPrimary IS NOT NULL AND LctPhnPrimary LIKE '%%%s%%' {ESCAPE '\\'}) ".
						  "OR (LctPhnRadio IS NOT NULL AND LctPhnRadio LIKE '%%%s%%' {ESCAPE '\\'}) ".
						  "OR (LctPhnTelex IS NOT NULL AND LctPhnTelex LIKE '%%%s%%' {ESCAPE '\\'}) ".
						  "OR (LctPhnHearing IS NOT NULL AND LctPhnHearing LIKE '%%%s%%' {ESCAPE '\\'}))";
				$count = 15;
				
				break;
			case 'conference':
				$condition_callback = array(
					'class'=>&$this,
					'func'=>'conferenceCondition'
				);		
				break;
			case 'partid':
				$draft_pos = strpos($value,'draft_sa');
				if($draft_pos!==false){
					$value = substr($value, $draft_pos);
				}
				$condition = "(EvnUID = '%s')";
			break;
			case 'message-id':
				$condition = "(message_id = '%s')";
			break;
			 			case 'body':
				return '';
				break;
			default:
				if(stripos($value,'{TAG}')!==false){
					return $value;
				}
				$conditions = array();
				switch($this->type){
					case 'HIPAA':
							return $value;
						break;
					case 'Z':
						$this->filter['everywhere'] = $value;
						break;
					default:	
						foreach(self::$folderDefaults[$this->type] as $field){
							$conditions[] = "(".$this->getTableName().$field." IS NOT NULL AND ".$this->getTableName().$field." LIKE '%%%s%%' {ESCAPE '\\'})";
						}
						$condition = join(' OR ',$conditions);
						$condition = '('.$condition.')';
						$count = count(self::$folderDefaults[$this->type]);
	
						if($this->type == 'I' && strlen($command)==0){
							$condition_callback = array(
								'class'=>&$this,
								'func'=>'teamChatDefaultCondition'
							);
						}				
						break;
				}
				
			break;
		}
		$condition = $this->processValue($value, $condition, $count, $value_callback, $condition_callback, $exact_match);

		if($condition == ''){
			return '1 = 1';
		}
		return $condition;
	}
	
	private function itemsCondition($token)
	{
		switch($this->type){
			case 'SNOOZED':
			case 'M':
				$result = "(item_id = '".$token."' )";
				break;
			case 'E':
			case 'T':
			case 'N':
			case 'J':
			case 'F':
			case 'I':
				$result = "(EVN_ID = '".$token."' )";
				break;
			case 'G':
			case 'C':
				$result = "(ITM_ID = '".$token."' )";
				break;
		}
		return $result;
	}
	
	private function hasCondition($token)
	{
		switch($this->type){
			case 'SNOOZED':
			case 'M':
				switch($token){
					case 'attachment':
						$result = $this->getTableName()."has_attachment='T'";
						break;
					case 'flag':
						$result = $this->getTableName()."color <> 'Z'";
						break;
					case 'tag':
						$result = $this->getTableName()."taglist IS NOT NULL and taglist <> ''";
						break;
				}
				break;
			case 'C':
				switch($token){
					case 'email1':
						$result = "(NOT (LCTEMAIL1 = ''))";
						break;
					case 'email2':
						$result = "(NOT (LCTEMAIL2 = ''))";
						break;
					case 'email3':
						$result = "(NOT (LCTEMAIL3 = ''))";
						break;
					case 'email':
						$result = "((NOT (LCTEMAIL1 = '')) OR (NOT (LCTEMAIL2 = '')) OR (NOT (LCTEMAIL3 = '')))";
						break;
					case 'mobile':
						$result = "(NOT (LCTPHNMOBILE = ''))";
						break;
					case 'phone':
						$result = "( (NOT (LctPhnHome1 = '')) ".
								"OR (NOT (LctPhnHome2 = '')) ".
								"OR (NOT (LctPhnAssistant = '')) ".
								"OR (NOT (LctPhnWork1 = '')) ".
								"OR (NOT (LctPhnWork2 = '')) ".
								"OR (NOT (LctPhnCallback = '')) ".
								"OR (NOT (LctPhnCompany = '')) ".
								"OR (NOT (LctPhnCar = '')) ".
								"OR (NOT (LctPhnISDN = '')) ".
								"OR (NOT (LctPhnMobile = '')) ".
								"OR (NOT (LctPhnOther = '')) ".
								"OR (NOT (LctPhnPager = '')) ".
								"OR (NOT (LctPhnPrimary = '')) ".
								"OR (NOT (LctPhnRadio = '')) ".
								"OR (NOT (LctPhnTelex = '')) ".
								"OR (NOT (LctPhnHearing = ''))
								)";
						break;
					case 'sip':
						$result = "(LctPhnOther IS NOT NULL AND LctPhnOther LIKE 'sip:%')";
						break;
				}
				break;
			case 'E':
			case 'I':
				switch($token){
					case 'conference':
						$result = "(EvnMeetingID IS NOT NULL AND EvnMeetingID <> '')";
						break;
				}
				break;
			case 'K':
				switch($token){
					case 'email':
						$result = "(NOT (LCTEMAIL1 =''))";
						break;
				}
				break;
			break;
		}
		return $result;
	}
	
	private function isCondition($token)
	{
		switch(strtolower($token)){
			case 'read':
				$result = $this->getTableName().'unread = 0';
			break;
			case 'unread':
				$result = $this->getTableName().'unread = 1 ';
			break;
			case 'flagged':
				$result = $this->getTableName()."color <> 'Z'";
			break;
			case 'done':
				switch($this->type){
					case 'M':
					case 'SNOOZED':
						$result = $this->getTableName()."color = 'Y'";
					break;
					case 'E':
					case 'T':
					case 'N':
					case 'J':
					case 'F':
					case 'I':
						$result = "EvnStatus = 'M'";
					break;
				}
			break;
			case 'free':
				switch($this->type){
					case 'E':
					case 'T':
					case 'N':
					case 'J':
					case 'F':
					case 'I':
						$result = '{BITAND}EvnFlags,4{/BITAND}';
					break;
				}
			break;
			case 'busy':
				switch($this->type){
					case 'E':
					case 'T':
					case 'N':
					case 'J':
					case 'F':
					case 'I':
						$result = 'NOT {BITAND}EvnFlags,4{/BITAND}';
					break;
				}
			break;
			case 'private':
				switch($this->type){
					case 'C':
						$result = "(ItmShareType ='P' OR ItmShareType ='C')";
					break;
					case 'E':
					case 'T':
					case 'N':
					case 'J':
					case 'F':
					case 'I':
						$result = "(EvnShareType = 'C' OR EvnShareType='P')";
					break;
				}
			break;
			case 'public':
				switch($this->type){
					case 'C':
						$result = "(ItmShareType <> 'P' AND ItmShareType <> 'C')";
					break;
					case 'E':
					case 'T':
					case 'N':
					case 'J':
					case 'F':
					case 'I':
						$result = "(EvnShareType <> 'P' AND EvnShareType <> 'C')";
					break;
				}
			break;
			case 'anyone':
				if($this->type=='SL'){
					$result = "(lctemail1 = 'anyone')";
				}
				break;
		}
		return $result;
	}
	
	private function priorityCondition($value)
	{
		$priority = array(
			'highest'=>1,
			'high'=>2,
			'normal'=>3,
			'low'=>4,
			'lowest'=>5
		);
		
		$priority_val = $priority[trim(strtolower($this->escapeValue($value)))];
		if(!$priority_val){
			$priority_val = is_numeric($value)?$value:3;
		}
		$condition = $this->getTableName().'priority = '.$priority_val;			
		return $condition;
	}
	
	private function inCondition($folder)
	{
		if(trim(strtolower($folder))=='anywhere'){
			return '1 = 1';
		}
		if(!$oAccount = $this->getAccount()){
			return '0 = 1';
		}
		try{
			switch($this->type)
			{
				case 'SNOOZED':
				case 'M':
					$folder = str_replace("/","\\",$folder);
					$fdr = $oAccount->getFolder($folder);
					return "folder_id = ".$fdr->folderID;
				break;
				case 'C':
					return "ItmFolder = '".$folder."'";
				break;
				default:
					return "EvnFolder = '".$folder."'";
				break;
			}
		}catch(Exc $e){
			return '0 = 1';
		}
	}
	
	private function colorCondition($token)
	{
		switch($this->type){
			case 'SNOOZED':
			case 'M':
				switch(strtolower($token)){
					case 'none':
						$result = "color = 'Z'";
					break;
					case 'red':
						$result = "color = '1'";
					break;
					case 'blue':
						$result = "color = '2'";
					break;
					case 'green':
						$result = "color = '3'";
					break;
					case 'orange':
						$result = "color = '5'";
					break;
					case 'purple':
						$result = "color = '8'";
					break;
					case 'yellow':
						$result = "color = 'A'";
					break;
				}
				break;
			case 'K':
				$result = "(tagcolor IS NOT NULL AND tagcolor LIKE '%%%s%%' {ESCAPE '\\'})";
				break;
		}
		return $result;
	}

	private function lastCondition($token)
	{
		if(!is_numeric($token)){
			$timestamp = strtotime($token);
		} else {
			$daysBack = intval($token)-1;  			$date = new \DateTime();
			$date->modify('-' . $daysBack . ' days midnight');
			$timestamp = $date->getTimestamp();
		}
		switch($this->type){
			case 'SNOOZED':
			case 'M':
				$result = "(date > ".$timestamp.")";
				break;
		}
		return $result;		
	}
	
	private function conferenceCondition($token)
	{
		if($this->type!='E'){
			return '';
		}
		$accountID = $this->account->accountID;
		
		 		$accountID = str_replace(self::$wildcards,self::$escaped,$accountID);
		$accountID = str_replace("'","''",$accountID);
		
		switch($token){
			case 'organizer':
				$result = "((EvnMeetingID IS NOT NULL AND EvnMeetingID <> '') AND (EvnOrganizer LIKE '%%%s%%' {ESCAPE '\\'}))";
				break;
			case 'attendee':
				$result = "((EvnMeetingID IS NOT NULL AND EvnMeetingID <> '') AND NOT (EvnOrganizer IS NOT NULL AND EvnOrganizer LIKE '%%%s%%' {ESCAPE '\\'}))";
				break;
		}
		$result = sprintf($result,$accountID);
		return $result;
	}
	
	private function strtodelphidate($str)
	{
	    if(strcasecmp($str, 'now') === 0) $str = date('Y/m/d');
		$arr = explode('/',$str);
		return GregorianToJD($arr[1], $arr[2], $arr[0]);
	}
	
	private function strtodelphidatebefore($str)
	{
		return self::strtodelphidate($str)+1;
	}

	private function strtotime($str)
	{
		return strtotime($str);
	}
	
	private function strtotimebefore($str)
	{
		return self::strtotime($str)+86400;
	}


	private function kbtob($str)
	{
		return ((int) $str) * 1024;
	}
	
	protected function teamChatDefaultCondition($value,$condition)
	{
		if(strlen($value)>=3){
			$condition = '('.$condition.' OR '.$this->teamChatMemberCondition($value,'','everywhere').')';
		}
		return $condition;
	}
	
	protected function teamChatMemberCondition($value,$condition, $type)
	{
		 		if(!$this->account){
			throw new Exception('search_set_account_first_teamchat');
		}
		if(!$this->oFolder){
			throw new Exception('search_set_folder_first_teamchat');
		}
		if($type=='from'){
			$type = 'everywhere';
		}
		$oMembersFolder = $this->account->getFolder('__@@GROUP@@__/'.$this->oFolder->name);
		if($oMembersFolder){
			$filter = array();
			$filter[$type] = $value;
			$oMembers = $oMembersFolder->getItems($filter);
			$memberSQL = '';
			$ownerIDS = array();
			if ($oMembers) foreach($oMembers as $oMember){
				$ownerIDS[] = $oMember->item['OWNERID'];	
			}
			$condition = 'EvnOwn_ID in (\''.join('\',\'',$ownerIDS).'\')';
		}
		return $condition;		
	}

	protected function getTagListCondition($value)
	{
		$value = slToolsString::removeQuotes($value);
		$tag_name = $this->getTableName().'taglist';
		$condition = "(".$tag_name." IS NOT NULL AND (".$tag_name." LIKE \"%%%s%%\" {ESCAPE '\\'} OR ".$tag_name." LIKE \"%%%s%%\" {ESCAPE '\\'}))";
		$urlenquoteValue = self::urlEnquoteEscape($value);
		$urlenquoteTagValue = self::urlEnquoteEscapeTag($value);
		$condition = sprintf($condition, $urlenquoteValue, $urlenquoteTagValue);
		return $condition;				
	}
	
	protected function teamChatTimeCondition($value,$condition,$type)
	{
		if (!$this->tz){
			throw new Exception('search_set_timezone_first_teamchat');
		}
		switch($type){
			 			case 'beforetime':
			case 'aftertime':
			 			case 'creationdate':
			case 'before':  
			case 'after':
				$operator = self::$operators[$type];
				$dtNow = new DateTime();
				$dtNow->setTimezone(new DateTimeZone($this->tz));
				$dtNow->setTimestamp(strtotime($value));
				if($operator == '=' ){
					$startOfDay = clone $dtNow;
					$startOfDay->modify('today');		
					$endOfDay = clone $startOfDay;
					$endOfDay->modify('tomorrow');
					$endOfDay->modify('1 second ago');
					$start_stamp = $startOfDay->getTimestamp(); 
					$end_stamp = $endOfDay->getTimestamp();
					$timeCondition = '(Evn_Created >= '.$start_stamp.' AND Evn_Created <= '.$end_stamp.')';					
				}else{
					$timeCondition = '(Evn_Created '.$operator.' '.$dtNow->getTimestamp().')';
				}
				if($type=='before' || $type=='after'){
					$eventCondition = "(EvnStartDate ".$operator." ".unixtojd($dtNow->getTimestamp())." )";
					$timeCondition = ''.$timeCondition.' OR '.$eventCondition.'';
				}
				return $timeCondition;						
			break;	
		}
	}
}

?>
