<?php

class slToolsIpChecker {

  private $ipRanges = [];

  public function addRangesFromList($list) {
    if($list == "" ) return;
    $ranges = explode("\r\n", $list);
    if(empty($ranges)) return;
    foreach($ranges as $range) {
      $this->addIpRange($range);
    }
  }
  public function addIpRange($range) {
    $this->ipRanges[] = $range;
  }

  public function isIpInRange($ip) {
    if(!$this->checkInputIp($ip)){
      return false;
    }
    foreach ($this->ipRanges as $range) {
      if ($this->matchRange($ip, $range)) {
        return true;
      }
    }
    return false;
  }

  private function checkInputIp($ip)
  {
      $ipLong = ip2long($ip);
      $checkIp = long2ip($ipLong);

      return $checkIp == $ip;
  }

  private function matchRange($ip, $range) {
    if (strpos($range, '/') !== false) {
      return $this->cidrMatch($ip, $range);
    } elseif (strpos($range, '-') !== false) {
      return $this->rangeMatch($ip, $range);
    } elseif (strpos($range, '*') !== false) {
      return $this->wildcardMatch($ip, $range);
    } else {
      return $this->singleIpMatch($ip, $range);
    }
  }

  private function cidrMatch($ip, $cidr) {
    list($subnet, $mask) = explode('/', $cidr);
    if ((ip2long($ip) & ~((1 << (32 - $mask)) - 1)) == ip2long($subnet)) {
      return true;
    }
    return false;
  }

  private function rangeMatch($ip, $range) {
    $rangeParts = explode('-', $range);
    if (count($rangeParts) !== 2) {
      return false;      }

    $startIp = $this->convertWildcardIp($rangeParts[0]);
    $endIp = $this->convertWildcardIp($rangeParts[1]);

    $ipLong = ip2long($ip);
    $startIpLong = ip2long($startIp);
    $endIpLong = ip2long($endIp);

    return ($ipLong >= $startIpLong && $ipLong <= $endIpLong);
  }

  private function wildcardMatch($ip, $pattern) {
    $pattern = str_replace('*', '.*', $pattern);
    $pattern = '/^' . $pattern . '$/';
    return preg_match($pattern, $ip);
  }

  private function singleIpMatch($ip, $singleIp) {
    return $ip === $singleIp;
  }

  private function convertWildcardIp($ip) {
    $parts = explode('.', $ip);
    foreach ($parts as &$part) {
      if ($part === '*') {
        $part = '255';
      }
    }
    return implode('.', $parts);
  }
}

?>